/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Powerslave.Anim;
import ru.m210projects.Powerslave.Bullet;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Light;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Map;
import ru.m210projects.Powerslave.Player;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.BobStruct;
import ru.m210projects.Powerslave.Type.BulletStruct;
import ru.m210projects.Powerslave.Type.Channel;
import ru.m210projects.Powerslave.Type.DripStruct;
import ru.m210projects.Powerslave.Type.ElevStruct;
import ru.m210projects.Powerslave.Type.ObjectStruct;
import ru.m210projects.Powerslave.Type.SafeLoader;
import ru.m210projects.Powerslave.Type.TrailPointStruct;
import ru.m210projects.Powerslave.Type.TrailStruct;
import ru.m210projects.Powerslave.Type.TrapStruct;
import ru.m210projects.Powerslave.Type.WallFaceStruct;

public class Object {
    public static int ElevCount;
    public static final ElevStruct[] Elevator;
    public static int WallFaceCount;
    public static final WallFaceStruct[] WallFace;
    public static int longSeek_out;
    private static int FinaleMoves;
    private static int FinaleClock;
    private static boolean bLightTrig;

    public static void InitElev() {
        ElevCount = 1024;
        for (int i = 0; i < 1024; ++i) {
            Object.Elevator[i] = new ElevStruct();
        }
    }

    public static void saveElevs(OutputStream os) throws IOException {
        StreamUtils.writeShort(os, ElevCount);
        for (int i = ElevCount; i < 1024; ++i) {
            Elevator[i].save(os);
        }
    }

    public static void loadElevs(SafeLoader loader, InputStream is) throws IOException {
        for (int i = loader.ElevCount = (int)StreamUtils.readShort(is); i < 1024; ++i) {
            if (loader.Elevator[i] == null) {
                loader.Elevator[i] = new ElevStruct();
            }
            loader.Elevator[i].load(is);
        }
    }

    public static void loadElevs(SafeLoader loader) {
        ElevCount = loader.ElevCount;
        for (int i = loader.ElevCount; i < 1024; ++i) {
            if (Elevator[i] == null) {
                Object.Elevator[i] = new ElevStruct();
            }
            Elevator[i].copy(loader.Elevator[i]);
        }
    }

    public static int BuildElevC(int a1, int a2, int a3, int a4, int a5, int a6, int a7, int ... a8) {
        if (ElevCount <= 0) {
            throw new AssertException("ElevCount>0");
        }
        int i = --ElevCount;
        Object.Elevator[i].field_0 = a1;
        if ((a1 & 4) != 0) {
            a5 /= 2;
        }
        Object.Elevator[i].field_6 = a5;
        Object.Elevator[i].field_E = 0;
        Object.Elevator[i].field_36 = 0;
        Object.Elevator[i].field_10 = 0;
        Object.Elevator[i].field_A = a6;
        Object.Elevator[i].field_32 = -1;
        Object.Elevator[i].channel = a2;
        Object.Elevator[i].sectnum = a3;
        if (a4 < 0) {
            a4 = Object.BuildWallSprite(a3);
        }
        Object.Elevator[i].field_34 = a4;
        for (int j = 0; j < a7; ++j) {
            Object.Elevator[i].field_12[Object.Elevator[i].field_E] = a8[j];
            ++Object.Elevator[i].field_E;
        }
        return i;
    }

    public static int BuildElevF(int a1, int a2, int a3, int a4, int a5, int a6, int ... a7) {
        if (ElevCount <= 0) {
            throw new AssertException("ElevCount>0");
        }
        int i = --ElevCount;
        if ((a1 & 4) != 0) {
            a5 /= 2;
        }
        Object.Elevator[i].field_0 = 2;
        Object.Elevator[i].field_6 = a4;
        Object.Elevator[i].field_32 = -1;
        Object.Elevator[i].field_A = a5;
        Object.Elevator[i].channel = a1;
        Object.Elevator[i].sectnum = a2;
        Object.Elevator[i].field_E = 0;
        Object.Elevator[i].field_10 = 0;
        Object.Elevator[i].field_36 = 0;
        if (a3 < 0) {
            a3 = Object.BuildWallSprite(a2);
        }
        Object.Elevator[i].field_34 = a3;
        for (int j = 0; j < a6; ++j) {
            Object.Elevator[i].field_12[Object.Elevator[i].field_E] = a7[j];
            ++Object.Elevator[i].field_E;
        }
        return i;
    }

    public static void FuncElev(int nStack, int ignored, int RunPtr) {
        int elev = RunList.RunData[RunPtr].getObject();
        if (elev < 0 || elev >= 1024) {
            throw new AssertException("elev>=0 && elev<MAXELEV");
        }
        int nRun = nStack & 0x7F0000;
        if (nRun != 131072 && nRun != 65536) {
            return;
        }
        int chan = Object.Elevator[elev].channel;
        if (chan < 0 || chan >= 4096) {
            throw new AssertException("chan>=0 && chan<MAXCHAN");
        }
        Channel pChannel = RunList.channel[chan];
        int nFlags = Object.Elevator[elev].field_0;
        Sector elevSec = Main.boardService.getSector(Object.Elevator[elev].sectnum);
        if (elevSec == null) {
            return;
        }
        switch (nRun) {
            case 131072: {
                if ((nFlags & 2) != 0) {
                    Main.game.pInt.setfloorinterpolate(Object.Elevator[elev].sectnum, elevSec);
                    int v18 = Object.LongSeek(elevSec.getFloorz(), Object.Elevator[elev].field_12[Object.Elevator[elev].field_10], Object.Elevator[elev].field_6, Object.Elevator[elev].field_A);
                    elevSec.setFloorz(longSeek_out);
                    if (v18 == 0) {
                        int v29;
                        Sprite spr;
                        if ((nFlags & 0x10) != 0) {
                            Object.Elevator[elev].field_10 ^= 1;
                            Sound.StartElevSound(Object.Elevator[elev].field_34, nFlags);
                        } else {
                            Sound.StopSpriteSound(Object.Elevator[elev].field_34);
                            RunList.SubRunRec(RunPtr);
                            Object.Elevator[elev].field_32 = -1;
                            RunList.ReadyChannel(chan);
                            Sound.D3PlayFX(Sound.StaticSound[Map.nStopSound], Object.Elevator[elev].field_34);
                        }
                        int v16 = Object.Elevator[elev].field_34;
                        while (v16 != -1 && (spr = Main.boardService.getSprite(v29 = v16)) != null) {
                            v16 = spr.getOwner();
                            Main.game.pInt.setsprinterpolate(v29, spr);
                            spr.setZ(spr.getZ() + v18);
                        }
                        return;
                    }
                    Object.MoveSectorSprites(Object.Elevator[elev].sectnum, v18);
                    if (v18 >= 0 || !Object.CheckSectorSprites(Object.Elevator[elev].sectnum, 2)) {
                        int v29;
                        Sprite spr;
                        int v16 = Object.Elevator[elev].field_34;
                        while (v16 != -1 && (spr = Main.boardService.getSprite(v29 = v16)) != null) {
                            v16 = spr.getOwner();
                            Main.game.pInt.setsprinterpolate(v29, spr);
                            spr.setZ(spr.getZ() + v18);
                        }
                        return;
                    }
                    RunList.ChangeChannel(chan, RunList.channel[chan].field_4 == 0 ? 1 : 0);
                    return;
                }
                Main.game.pInt.setceilinterpolate(Object.Elevator[elev].sectnum, elevSec);
                int v30 = elevSec.getCeilingz();
                int v27 = Object.LongSeek(v30, Object.Elevator[elev].field_12[Object.Elevator[elev].field_10], Object.Elevator[elev].field_6, Object.Elevator[elev].field_A);
                v30 = longSeek_out;
                if (v27 != 0) {
                    int v29;
                    Sprite spr;
                    if (v27 > 0) {
                        if (v30 == Object.Elevator[elev].field_12[Object.Elevator[elev].field_10]) {
                            Sprite spr2;
                            if ((nFlags & 4) != 0) {
                                Object.SetQuake(Object.Elevator[elev].field_34, 30);
                            }
                            if ((spr2 = Main.boardService.getSprite(Object.Elevator[elev].field_34)) != null) {
                                Sound.PlayFXAtXYZ(Sound.StaticSound[26], spr2.getX(), spr2.getY(), spr2.getZ(), spr2.getSectnum());
                            }
                        }
                        if ((nFlags & 4) != 0) {
                            if (Object.CheckSectorSprites((short)Object.Elevator[elev].sectnum, 1)) {
                                return;
                            }
                        } else if (Object.CheckSectorSprites((short)Object.Elevator[elev].sectnum, 0)) {
                            RunList.ChangeChannel(chan, RunList.channel[chan].field_4 == 0 ? 1 : 0);
                            return;
                        }
                    }
                    elevSec.setCeilingz(v30);
                    int v16 = Object.Elevator[elev].field_34;
                    while (v16 != -1 && (spr = Main.boardService.getSprite(v29 = v16)) != null) {
                        v16 = spr.getOwner();
                        Main.game.pInt.setsprinterpolate(v29, spr);
                        spr.setZ(spr.getZ() + v27);
                    }
                    return;
                }
                if ((nFlags & 0x10) == 0) {
                    RunList.SubRunRec(RunPtr);
                    Object.Elevator[elev].field_32 = -1;
                    Sound.StopSpriteSound(Object.Elevator[elev].field_34);
                    Sound.D3PlayFX(Sound.StaticSound[Map.nStopSound], Object.Elevator[elev].field_34);
                    RunList.ReadyChannel(chan);
                    return;
                }
                Object.Elevator[elev].field_10 ^= 1;
                Sound.StartElevSound((short)Object.Elevator[elev].field_34, nFlags);
                return;
            }
            case 65536: {
                boolean a4 = false;
                if ((nFlags & 8) == 0) {
                    if ((nFlags & 0x10) != 0) {
                        if (Object.Elevator[elev].field_32 < 0) {
                            Object.Elevator[elev].field_32 = RunList.AddRunRec(RunList.NewRun, RunList.RunData[RunPtr].getEvent());
                            a4 = true;
                            Sound.StartElevSound((short)Object.Elevator[elev].field_34, nFlags);
                        }
                        if (a4) {
                            if (Object.Elevator[elev].field_32 >= 0) {
                                return;
                            }
                            Object.Elevator[elev].field_32 = RunList.AddRunRec(RunList.NewRun, RunList.RunData[RunPtr].getEvent());
                            Sound.StartElevSound((short)Object.Elevator[elev].field_34, nFlags);
                            return;
                        }
                        if (Object.Elevator[elev].field_32 >= 0) {
                            RunList.SubRunRec(Object.Elevator[elev].field_32);
                            Object.Elevator[elev].field_32 = -1;
                        }
                        return;
                    }
                    if (pChannel.field_4 >= 0) {
                        if (pChannel.field_4 == Object.Elevator[elev].field_10 || pChannel.field_4 >= Object.Elevator[elev].field_E) {
                            Object.Elevator[elev].field_36 = pChannel.field_4;
                        } else {
                            Object.Elevator[elev].field_10 = RunList.channel[chan].field_4;
                        }
                        if (Object.Elevator[elev].field_32 >= 0) {
                            return;
                        }
                        Object.Elevator[elev].field_32 = RunList.AddRunRec(RunList.NewRun, RunList.RunData[RunPtr].getEvent());
                        Sound.StartElevSound((short)Object.Elevator[elev].field_34, nFlags);
                        return;
                    }
                    if (Object.Elevator[elev].field_32 >= 0) {
                        RunList.SubRunRec(Object.Elevator[elev].field_32);
                        Object.Elevator[elev].field_32 = -1;
                    }
                    return;
                }
                if (pChannel.field_4 == 0) {
                    if (Object.Elevator[elev].field_32 >= 0) {
                        RunList.SubRunRec(Object.Elevator[elev].field_32);
                        Object.Elevator[elev].field_32 = -1;
                    }
                    return;
                }
                if (Object.Elevator[elev].field_32 >= 0) {
                    return;
                }
                Object.Elevator[elev].field_32 = RunList.AddRunRec(RunList.NewRun, RunList.RunData[RunPtr].getEvent());
                Sound.StartElevSound((short)Object.Elevator[elev].field_34, nFlags);
            }
        }
    }

    public static void BuildObject(int nSprite, int a2, int a3) {
        int v20 = Globals.ObjectCount;
        if (Globals.ObjectCount >= 128) {
            throw new AssertException("Too many objects!");
        }
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        if (Globals.ObjectList[v20] == null) {
            Globals.ObjectList[v20] = new ObjectStruct();
        }
        int v5 = Globals.ObjectStatnum[a2];
        ++Globals.ObjectCount;
        Main.engine.changespritestat(nSprite, v5);
        pSprite.setCstat((pSprite.getCstat() | 0x101) & 0xFFFF7FFD);
        pSprite.setXvel(0);
        pSprite.setYvel(0);
        pSprite.setZvel(0);
        pSprite.setExtra(-1);
        pSprite.setLotag(RunList.HeadRun() + 1);
        pSprite.setHitag(0);
        pSprite.setOwner(RunList.AddRunRec(pSprite.getLotag() - 1, 0x170000 | v20));
        Globals.ObjectList[v20].obj_2 = pSprite.getStatnum() == 97 ? 4 : 120;
        int v14 = RunList.NewRun;
        Globals.ObjectList[v20].field_6 = nSprite;
        Globals.ObjectList[v20].field_4 = RunList.AddRunRec(v14, 0x170000 | v20);
        int v15 = Globals.ObjectSeq[a2];
        if (v15 <= -1) {
            Globals.ObjectList[v20].field_0 = 0;
            short v23 = pSprite.getStatnum();
            Globals.ObjectList[v20].field_8 = -1;
            Globals.ObjectList[v20].obj_A = v23 == 97 ? -1 : -a3;
        } else {
            int v21;
            Sprite spr;
            int v16;
            Globals.ObjectList[v20].field_8 = v16 = Seq.SeqOffsets[v15];
            if (a2 == 0) {
                int v17 = Seq.SeqSize[v16] - 1;
                int v18 = Random.RandomSize(4);
                Globals.ObjectList[v20].field_0 = v18 % v17;
            }
            if ((spr = Main.boardService.getSprite(v21 = Main.engine.insertsprite(pSprite.getSectnum(), 0))) != null) {
                Globals.ObjectList[v20].obj_A = v21;
                spr.setCstat(32768);
                spr.setX(pSprite.getX());
                spr.setY(pSprite.getY());
                spr.setZ(pSprite.getZ());
            } else {
                Globals.ObjectList[v20].obj_A = -1;
            }
        }
    }

    public static void saveObjects(OutputStream os) throws IOException {
        StreamUtils.writeShort(os, Globals.ObjectCount);
        for (int i = 0; i < Globals.ObjectCount; i = (int)((short)(i + 1))) {
            Globals.ObjectList[i].save(os);
        }
    }

    public static void loadObjects(SafeLoader loader) {
        Globals.ObjectCount = loader.ObjectCount;
        for (int i = 0; i < loader.ObjectCount; i = (int)((short)(i + 1))) {
            if (Globals.ObjectList[i] == null) {
                Globals.ObjectList[i] = new ObjectStruct();
            }
            Globals.ObjectList[i].copy(loader.ObjectList[i]);
        }
    }

    public static void loadObjects(SafeLoader loader, InputStream is) throws IOException {
        loader.ObjectCount = StreamUtils.readShort(is);
        for (int i = 0; i < loader.ObjectCount; i = (int)((short)(i + 1))) {
            if (loader.ObjectList[i] == null) {
                loader.ObjectList[i] = new ObjectStruct();
            }
            loader.ObjectList[i].load(is);
        }
    }

    public static void FuncObject(int nStack, int a2, int a3) {
        ObjectStruct v5 = Globals.ObjectList[RunList.RunData[a3].getObject()];
        int nSprite = v5.field_6;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        short v43 = pSprite.getStatnum();
        int v8 = nStack & 0x7F0000;
        int v9 = v5.field_8;
        switch (v8) {
            case 131072: {
                if (v43 != 97 && (pSprite.getCstat() & 0x101) != 0) {
                    if (v43 != 152) {
                        Sprites.Gravity(nSprite);
                    }
                    if (v9 != -1) {
                        int v10;
                        v5.field_0 = v10 = v5.field_0 + 1;
                        if (v10 >= Seq.SeqSize[v9]) {
                            v5.field_0 = 0;
                        }
                        pSprite.setPicnum(Seq.GetSeqPicnum2(v9, v5.field_0));
                    }
                    if (v5.obj_2 >= 0 || v5.obj_2++ != -1) {
                        if (v43 != 152) {
                            int v24 = Main.engine.movesprite(nSprite, pSprite.getXvel() << 6, pSprite.getYvel() << 6, pSprite.getZvel(), 0, 0, 0);
                            if (pSprite.getStatnum() == 141) {
                                pSprite.setPal(1);
                            }
                            if ((v24 & 0x20000) != 0) {
                                pSprite.setXvel(pSprite.getXvel() - (pSprite.getXvel() >> 3));
                                pSprite.setYvel(pSprite.getYvel() - (pSprite.getYvel() >> 3));
                            }
                            if ((v24 & 0xE000) == 49152) {
                                pSprite.setYvel(0);
                                pSprite.setXvel(0);
                            }
                        }
                    } else {
                        int i;
                        Sector sec = Main.boardService.getSector(pSprite.getSectnum());
                        if (sec == null) {
                            return;
                        }
                        int v44 = v43 != 152 && pSprite.getZ() >= sec.getFloorz() ? 34 : 36;
                        Light.AddFlash(pSprite.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ(), 128);
                        Anim.BuildAnim(-1, v44, 0, pSprite.getX(), pSprite.getY(), sec.getFloorz(), pSprite.getSectnum(), 240, 4);
                        int hitMove = nSprite | 0x4000;
                        if (v43 == 141) {
                            for (i = 4; i < 8; ++i) {
                                Sprites.BuildCreatureChunk(hitMove, Seq.GetSeqPicnum(46, (i >> 2) + 1, 0));
                            }
                            Sprites.RadialDamageEnemy(nSprite, 200, 20);
                        } else if (v43 == 152) {
                            for (i = 0; i < 8; ++i) {
                                Sprites.BuildCreatureChunk(hitMove, Seq.GetSeqPicnum(46, (i >> 1) + 3, 0));
                            }
                        }
                        if (Globals.levelnum <= 20 || v43 != 141) {
                            RunList.SubRunRec(pSprite.getOwner());
                            RunList.SubRunRec(v5.field_4);
                            Main.engine.mydeletesprite(nSprite);
                        } else {
                            Object.StartRegenerate(nSprite);
                            int v19 = v5.obj_A;
                            Sprite pObj = Main.boardService.getSprite(v19);
                            if (pObj == null) {
                                return;
                            }
                            v5.obj_2 = 120;
                            pSprite.setX(pObj.getX());
                            pSprite.setY(pObj.getY());
                            pSprite.setZ(pObj.getZ());
                            Main.engine.mychangespritesect(nSprite, pObj.getSectnum());
                        }
                    }
                }
                return;
            }
            case 524288: {
                if (v43 >= 150) {
                    return;
                }
                if (v5.obj_2 <= 0) {
                    return;
                }
                if (v43 == 98) {
                    Sound.D3PlayFX(Random.RandomSize(2) << 9 | Sound.StaticSound[47] | 0x2000, v5.field_6);
                    return;
                }
                v5.obj_2 -= a2;
                if (v5.obj_2 > 0) {
                    return;
                }
                if (v43 == 97) {
                    Sprites.ExplodeScreen(nSprite);
                    return;
                }
                v5.obj_2 = -(Random.RandomSize(3) + 1);
                return;
            }
            case 589824: {
                if (v9 > -1) {
                    Renderer renderer = Main.game.getRenderer();
                    TSprite tsp = (TSprite)renderer.getRenderedSprites().get((short)(nStack & 0xFFFF));
                    Seq.PlotSequence(tsp, v9, v5.field_0, 1);
                }
                return;
            }
            case 655360: {
                short v31;
                int v28;
                Sprite pRadialSpr = Main.boardService.getSprite(Globals.nRadialSpr);
                if (v5.obj_2 <= 0 || (pSprite.getCstat() & 0x101) == 0 || !(v43 != 152 || pRadialSpr != null && pRadialSpr.getStatnum() == 201 || Globals.nRadialBullet != 3 && Globals.nRadialBullet > -1) && (pRadialSpr == null || pRadialSpr.getStatnum() != 141) || (v28 = Sprites.CheckRadialDamage(nSprite)) <= 0) break;
                if (pSprite.getStatnum() != 98) {
                    v5.obj_2 -= v28;
                }
                if ((v31 = pSprite.getStatnum()) == 152) {
                    pSprite.setZvel(0);
                    pSprite.setYvel(0);
                    pSprite.setXvel(0);
                } else if (v31 != 98) {
                    pSprite.setXvel(pSprite.getXvel() >> 1);
                    pSprite.setYvel(pSprite.getYvel() >> 1);
                    pSprite.setZvel(pSprite.getZvel() >> 1);
                }
                if (v5.obj_2 > 0) break;
                short v35 = pSprite.getStatnum();
                if (v35 == 152) {
                    int v36 = v5.obj_A;
                    v5.obj_2 = -1;
                    if (v36 >= 0 && Globals.ObjectList[v36].obj_2 > 0) {
                        Globals.ObjectList[v36].obj_2 = -1;
                    }
                    return;
                }
                if (v35 == 97) {
                    v5.obj_2 = 0;
                    Sprites.ExplodeScreen(nSprite);
                    return;
                }
                v5.obj_2 = -(Random.RandomSize(4) + 1);
            }
        }
    }

    public static void StartRegenerate(int nSprite) {
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        int v2 = -1;
        int nRegenerate = Map.nFirstRegenerate;
        int v3 = 0;
        while (true) {
            Sprite spr;
            if (v3 >= Map.nRegenerates) {
                pSprite.setXvel(pSprite.getXrepeat());
                pSprite.setZvel(pSprite.getShade());
                pSprite.setYvel(pSprite.getPal());
                break;
            }
            if (nRegenerate == nSprite) {
                if (v2 == -1) {
                    Map.nFirstRegenerate = pSprite.getAng();
                } else {
                    spr = Main.boardService.getSprite(v2);
                    if (spr != null) {
                        spr.setAng(pSprite.getAng());
                    }
                }
                --Map.nRegenerates;
                break;
            }
            v2 = nRegenerate;
            spr = Main.boardService.getSprite(nRegenerate);
            if (spr != null) {
                nRegenerate = spr.getAng();
            }
            ++v3;
        }
        pSprite.setExtra(1350);
        pSprite.setAng(Map.nFirstRegenerate);
        if (Globals.levelnum <= 20) {
            pSprite.setExtra(pSprite.getExtra() / 5);
        }
        pSprite.setCstat(Short.MIN_VALUE);
        pSprite.setXrepeat(1);
        pSprite.setYrepeat(1);
        pSprite.setPal(1);
        Map.nFirstRegenerate = nSprite;
        ++Map.nRegenerates;
    }

    public static void DoRegenerates() {
        Sprite pSprite;
        int spr = Map.nFirstRegenerate;
        int i = Map.nRegenerates;
        while (i > 0 && (pSprite = Main.boardService.getSprite(spr)) != null) {
            block9: {
                block8: {
                    block7: {
                        if (pSprite.getExtra() > 0) break block7;
                        if (pSprite.getXrepeat() >= pSprite.getXvel()) break block8;
                        pSprite.setXrepeat(pSprite.getXrepeat() + 2);
                        pSprite.setYrepeat(pSprite.getYrepeat() + 2);
                        break block9;
                    }
                    pSprite.setExtra(pSprite.getExtra() - 1);
                    if (pSprite.getExtra() > 0) break block9;
                    Anim.BuildAnim(-1, 38, 0, pSprite.getX(), pSprite.getY(), pSprite.getZ(), pSprite.getSectnum(), 64, 4);
                    Sound.D3PlayFX(Sound.StaticSound[12], spr);
                }
                pSprite.setXrepeat(pSprite.getXvel());
                pSprite.setYrepeat(pSprite.getXvel());
                pSprite.setPal(pSprite.getYvel());
                pSprite.setXvel(0);
                pSprite.setYvel(0);
                pSprite.setZvel(0);
                if (pSprite.getStatnum() == 141) {
                    pSprite.setCstat(257);
                } else {
                    pSprite.setCstat(0);
                }
                if (--Map.nRegenerates == 0) {
                    Map.nFirstRegenerate = -1;
                }
            }
            --i;
            spr = pSprite.getAng();
        }
    }

    private static void MoveSectorSprites(int a1, int a2) {
        for (ListNode<Sprite> node = Main.boardService.getSectNode(a1); node != null; node = node.getNext()) {
            Sprite spr = node.get();
            if (spr.getStatnum() == 200) continue;
            Main.game.pInt.setsprinterpolate(node.getIndex(), spr);
            spr.setZ(spr.getZ() + a2);
        }
    }

    private static boolean CheckSectorSprites(int a1, int a2) {
        boolean v10 = false;
        if (a2 != 0) {
            Sector sec = Main.boardService.getSector(a1);
            if (sec == null) {
                return false;
            }
            int v5 = sec.getFloorz() - sec.getCeilingz();
            for (ListNode<Sprite> v4 = Main.boardService.getSectNode(a1); v4 != null; v4 = v4.getNext()) {
                Sprite spr = v4.get();
                int index = v4.getIndex();
                if ((spr.getCstat() & 0x101) == 0 || v5 >= Sprites.GetSpriteHeight(index)) continue;
                if (a2 != 1) {
                    return true;
                }
                v10 = true;
                Sprites.DamageEnemy(index, -1, 5);
                if (spr.getStatnum() != 100 || Globals.PlayerList[Player.GetPlayerFromSprite((int)index)].HealthAmount > 0) continue;
                int v8 = spr.getSectnum() | 0x4000;
                Sound.PlayFXAtXYZ(Sound.StaticSound[60], spr.getX(), spr.getY(), spr.getZ(), v8);
            }
            return v10;
        }
        for (ListNode<Sprite> node = Main.boardService.getSectNode(a1); node != null; node = node.getNext()) {
            if ((node.get().getCstat() & 0x101) == 0) continue;
            return true;
        }
        return false;
    }

    public static void SetQuake(int nSprite, int a2) {
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        int v4 = 0;
        int v5 = a2 << 8;
        int v11 = pSprite.getX();
        int v10 = pSprite.getY();
        int v6 = 0;
        for (int v3 = 0; v3 < Mmulti.numplayers; ++v3) {
            int v7 = Globals.PlayerList[v4].spriteId;
            Sprite spr = Main.boardService.getSprite(v7);
            if (spr != null) {
                int v8 = EngineUtils.sqrt((spr.getX() - v11 >> 8) * (spr.getX() - v11 >> 8) + (spr.getY() - v10 >> 8) * (spr.getY() - v10 >> 8));
                int v9 = v5;
                if (v8 != 0) {
                    v9 = v5 / v8;
                    if (v5 / v8 >= 256) {
                        if (v9 > 3840) {
                            v9 = 3840;
                        }
                    } else {
                        v9 = 0;
                    }
                }
                if (v9 > Globals.nQuake[v6]) {
                    Globals.nQuake[v6] = v9;
                }
            }
            ++v4;
            ++v6;
        }
    }

    public static int LongSeek(int a1, int a2, int a3, int a4) {
        longSeek_out = a1;
        int v4 = a2 - longSeek_out;
        if (v4 < 0) {
            int v5 = -a3;
            if (v5 > v4) {
                v4 = v5;
            }
            longSeek_out += v4;
        }
        if (v4 > 0) {
            if (a4 < v4) {
                v4 = a4;
            }
            longSeek_out += v4;
        }
        return v4;
    }

    public static int BuildWallSprite(int a1) {
        Sector sec = Main.boardService.getSector(a1);
        if (sec == null) {
            return -1;
        }
        short nWall = sec.getWallptr();
        Wall wall = Main.boardService.getWall(nWall);
        if (wall == null) {
            return -1;
        }
        Wall wall2 = wall.getWall2();
        int nSprite = Main.engine.insertsprite(a1, 401);
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return -1;
        }
        pSprite.setX((wall.getX() + wall2.getX()) / 2);
        pSprite.setY((wall.getY() + wall2.getY()) / 2);
        pSprite.setZ((sec.getCeilingz() + sec.getFloorz()) / 2);
        pSprite.setCstat(32768);
        return nSprite;
    }

    public static void InitWallFace() {
        WallFaceCount = 4096;
        for (int i = 0; i < 4096; ++i) {
            Object.WallFace[i] = new WallFaceStruct();
        }
    }

    public static void saveWallFaces(OutputStream os) throws IOException {
        StreamUtils.writeShort(os, WallFaceCount);
        for (int i = WallFaceCount; i < 4096; ++i) {
            WallFace[i].save(os);
        }
    }

    public static void loadWallFaces(SafeLoader loader, InputStream is) throws IOException {
        for (int i = loader.WallFaceCount = (int)StreamUtils.readShort(is); i < 4096; ++i) {
            if (loader.WallFace[i] == null) {
                loader.WallFace[i] = new WallFaceStruct();
            }
            loader.WallFace[i].load(is);
        }
    }

    public static void loadWallFaces(SafeLoader loader) {
        WallFaceCount = loader.WallFaceCount;
        for (int i = loader.WallFaceCount; i < 4096; ++i) {
            if (WallFace[i] == null) {
                Object.WallFace[i] = new WallFaceStruct();
            }
            WallFace[i].copy(loader.WallFace[i]);
        }
    }

    public static int BuildWallFace(int a1, short a2, int a3, int ... a4) {
        if (WallFaceCount <= 0) {
            throw new AssertException("Too many wall faces!");
        }
        int i = --WallFaceCount;
        Object.WallFace[i].field_4 = 0;
        Object.WallFace[i].field_2 = a2;
        Object.WallFace[i].field_0 = a1;
        if (a3 > 8) {
            a3 = 8;
        }
        for (int j = 0; j < a3; ++j) {
            Object.WallFace[i].field_6[Object.WallFace[i].field_4] = a4[j];
            ++Object.WallFace[i].field_4;
        }
        return i | 0x70000;
    }

    public static void FuncWallFace(int nStack, int ignored, int a3) {
        Wall wall;
        int v6;
        int ws = RunList.RunData[a3].getObject();
        if (ws < 0 || ws >= 4096) {
            throw new AssertException("ws>=0 && ws<MAXWALLFACE");
        }
        if ((nStack & 0x7F0000) == 65536 && (v6 = RunList.channel[Object.WallFace[ws].field_0].field_4) <= Object.WallFace[ws].field_4 && v6 >= 0 && (wall = Main.boardService.getWall(Object.WallFace[ws].field_2)) != null) {
            wall.setPicnum(Object.WallFace[ws].field_6[v6]);
        }
    }

    public static int FindTrail(int a1) {
        int v3 = 0;
        for (int v2 = 0; v2 < Globals.nTrails; ++v2) {
            if (a1 == Globals.sTrail[v3].field_2) {
                return v2;
            }
            ++v3;
        }
        Globals.sTrail[Globals.nTrails].field_2 = a1;
        Globals.sTrail[Globals.nTrails].field_0 = -1;
        return Globals.nTrails++;
    }

    public static void saveTrails(OutputStream os) throws IOException {
        int i;
        StreamUtils.writeShort(os, Globals.nTrails);
        StreamUtils.writeShort(os, Globals.nTrailPoints);
        for (i = 0; i < Globals.nTrails; ++i) {
            Globals.sTrail[i].save(os);
        }
        for (i = 0; i < Globals.nTrailPoints; ++i) {
            Globals.sTrailPoint[i].save(os);
        }
        for (i = 0; i < 100; ++i) {
            StreamUtils.writeShort(os, Globals.nTrailPointVal[i]);
            StreamUtils.writeShort(os, Globals.nTrailPointNext[i]);
            StreamUtils.writeShort(os, Globals.nTrailPointPrev[i]);
        }
    }

    public static void loadTrails(SafeLoader loader, InputStream is) throws IOException {
        int i;
        loader.nTrails = StreamUtils.readShort(is);
        loader.nTrailPoints = StreamUtils.readShort(is);
        for (i = 0; i < loader.nTrails; ++i) {
            if (loader.sTrail[i] == null) {
                loader.sTrail[i] = new TrailStruct();
            }
            loader.sTrail[i].load(is);
        }
        for (i = 0; i < loader.nTrailPoints; ++i) {
            if (loader.sTrailPoint[i] == null) {
                loader.sTrailPoint[i] = new TrailPointStruct();
            }
            loader.sTrailPoint[i].load(is);
        }
        for (i = 0; i < 100; ++i) {
            loader.nTrailPointVal[i] = StreamUtils.readShort(is);
            loader.nTrailPointNext[i] = StreamUtils.readShort(is);
            loader.nTrailPointPrev[i] = StreamUtils.readShort(is);
        }
    }

    public static void loadTrails(SafeLoader loader) {
        int i;
        Globals.nTrails = loader.nTrails;
        Globals.nTrailPoints = loader.nTrailPoints;
        for (i = 0; i < loader.nTrails; ++i) {
            if (Globals.sTrail[i] == null) {
                Globals.sTrail[i] = new TrailStruct();
            }
            Globals.sTrail[i].copy(loader.sTrail[i]);
        }
        for (i = 0; i < loader.nTrailPoints; ++i) {
            if (Globals.sTrailPoint[i] == null) {
                Globals.sTrailPoint[i] = new TrailPointStruct();
            }
            Globals.sTrailPoint[i].copy(loader.sTrailPoint[i]);
        }
        System.arraycopy(loader.nTrailPointVal, 0, Globals.nTrailPointVal, 0, Globals.nTrailPoints);
        System.arraycopy(loader.nTrailPointNext, 0, Globals.nTrailPointNext, 0, 100);
        System.arraycopy(loader.nTrailPointPrev, 0, Globals.nTrailPointPrev, 0, 100);
    }

    public static void BuildSpark(int nSprite, int a2) {
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        int i = Main.engine.insertsprite(pSprite.getSectnum(), 0);
        if (i != -1) {
            Sprite spr = Main.boardService.getSprite(i);
            if (spr == null) {
                return;
            }
            spr.setX(pSprite.getX());
            spr.setY(pSprite.getY());
            spr.setCstat(0);
            spr.setShade(-127);
            spr.setPal(1);
            spr.setXrepeat(50);
            spr.setXoffset(0);
            spr.setYoffset(0);
            spr.setYrepeat(50);
            if (a2 >= 2) {
                spr.setPicnum(3605);
                ++Globals.nSmokeSparks;
                if (a2 == 3) {
                    spr.setXrepeat(120);
                    spr.setYrepeat(120);
                } else {
                    int size = pSprite.getXrepeat() + 15;
                    spr.setXrepeat(size);
                    spr.setYrepeat(size);
                }
            } else {
                int v11 = pSprite.getAng() + 256 - Random.RandomSize(9);
                if (a2 != 0) {
                    spr.setXvel(EngineUtils.sin(v11 + 512 & 0x7FF) >> 5);
                    spr.setYvel(EngineUtils.sin(v11 & 0x7FF) >> 5);
                } else {
                    spr.setXvel(EngineUtils.sin(v11 + 512 & 0x7FF) >> 6);
                    spr.setYvel(EngineUtils.sin(v11 & 0x7FF) >> 6);
                }
                spr.setZvel(-128 * Random.RandomSize(4));
                spr.setPicnum(a2 + 985);
            }
            spr.setZ(pSprite.getZ());
            spr.setLotag(RunList.HeadRun() + 1);
            spr.setClipdist(1);
            spr.setHitag(0);
            spr.setExtra(-1);
            spr.setOwner(RunList.AddRunRec(spr.getLotag() - 1, 0x260000 | i));
            spr.setHitag(RunList.AddRunRec(RunList.NewRun, 0x260000 | i));
        }
    }

    public static void FuncSpark(int nStack, int ignored, int RunPtr) {
        int nSprite = RunList.RunData[RunPtr].getObject();
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        if ((nStack & 0x7F0000) == 131072) {
            pSprite.setShade(pSprite.getShade() + 3);
            pSprite.setXrepeat(pSprite.getXrepeat() - 2);
            if (pSprite.getXrepeat() >= 4 && pSprite.getShade() < 100) {
                pSprite.setYrepeat(pSprite.getYrepeat() - 2);
                if (pSprite.getPicnum() == 986 && (pSprite.getXrepeat() & 2) != 0) {
                    Object.BuildSpark(nSprite, 2);
                }
                if (pSprite.getPicnum() >= 3000) {
                    return;
                }
                pSprite.setZvel(pSprite.getZvel() + 128);
                int result = Main.engine.movesprite(nSprite, pSprite.getXvel() << 12, pSprite.getYvel() << 12, pSprite.getZvel(), 2560, -2560, 1);
                if (result == 0 || pSprite.getZvel() <= 0) {
                    return;
                }
            }
            pSprite.setZvel(0);
            pSprite.setYvel(0);
            pSprite.setXvel(0);
            if (pSprite.getPicnum() > 3000) {
                --Globals.nSmokeSparks;
            }
            RunList.DoSubRunRec(pSprite.getOwner());
            RunList.FreeRun(pSprite.getLotag() - 1);
            RunList.SubRunRec(pSprite.getHitag());
            Main.engine.mydeletesprite(nSprite);
        }
    }

    public static int BuildFireBall(int a1, int a2, int a3) {
        return Object.BuildTrap(a1, 1, a2, a3);
    }

    public static int BuildArrow(int a1, int a2) {
        return Object.BuildTrap(a1, 0, -1, a2);
    }

    public static void saveTraps(OutputStream os) throws IOException {
        int i;
        StreamUtils.writeShort(os, Map.nTraps);
        for (i = 0; i < 40; i = (int)((short)(i + 1))) {
            StreamUtils.writeShort(os, Map.nTrapInterval[i]);
        }
        for (i = 0; i < Map.nTraps; i = (int)((short)(i + 1))) {
            Map.sTrap[i].save(os);
        }
    }

    public static void loadTraps(SafeLoader loader) {
        Map.nTraps = loader.nTraps;
        System.arraycopy(loader.nTrapInterval, 0, Map.nTrapInterval, 0, Map.nTraps);
        for (int i = 0; i < loader.nTraps; i = (int)((short)(i + 1))) {
            if (Map.sTrap[i] == null) {
                Map.sTrap[i] = new TrapStruct();
            }
            Map.sTrap[i].copy(loader.sTrap[i]);
        }
    }

    public static void loadTraps(SafeLoader loader, InputStream is) throws IOException {
        int i;
        loader.nTraps = StreamUtils.readShort(is);
        for (i = 0; i < 40; i = (int)((short)(i + 1))) {
            loader.nTrapInterval[i] = StreamUtils.readShort(is);
        }
        for (i = 0; i < loader.nTraps; i = (int)((short)(i + 1))) {
            if (loader.sTrap[i] == null) {
                loader.sTrap[i] = new TrapStruct();
            }
            loader.sTrap[i].load(is);
        }
    }

    public static int BuildTrap(int nSprite, int a2, int a3, int a4) {
        if (Map.nTraps >= 40) {
            throw new AssertException("Too many traps!");
        }
        int v5 = Map.nTraps++;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return -1;
        }
        Main.engine.changespritestat(nSprite, 0);
        pSprite.setCstat(32768);
        pSprite.setXvel(0);
        pSprite.setYvel(0);
        pSprite.setZvel(0);
        pSprite.setExtra(-1);
        pSprite.setLotag(RunList.HeadRun() + 1);
        pSprite.setHitag(RunList.AddRunRec(RunList.NewRun, 0x1F0000 | v5));
        pSprite.setOwner(RunList.AddRunRec(pSprite.getLotag() - 1, 0x1F0000 | v5));
        if (Map.sTrap[v5] == null) {
            Map.sTrap[v5] = new TrapStruct();
        }
        Map.sTrap[v5].field_2 = nSprite;
        Map.sTrap[v5].field_4 = (a2 == 0 ? 1 : 0) + 14;
        Map.sTrap[v5].field_0 = -1;
        Map.nTrapInterval[v5] = 64 - 2 * a4;
        if (Map.nTrapInterval[v5] < 5) {
            Map.nTrapInterval[v5] = 5;
        }
        Map.sTrap[v5].field_C = 0;
        Map.sTrap[v5].field_A = 0;
        if (a3 != -1) {
            Map.sTrap[v5].nWall = -1;
            Map.sTrap[v5].nWall2 = -1;
            Sector sec = Main.boardService.getSector(pSprite.getSectnum());
            if (sec != null) {
                int v16 = 0;
                int v17 = sec.getWallptr();
                while (v16 < sec.getWallnum()) {
                    Wall wall = Main.boardService.getWall(v17);
                    if (wall != null && a3 == wall.getHitag()) {
                        if (Map.sTrap[v5].nWall != -1) {
                            Map.sTrap[v5].nWall2 = v17;
                            Map.sTrap[v5].field_C = wall.getPicnum();
                            return 0x1F0000 | v5;
                        }
                        Map.sTrap[v5].nWall = v17;
                        Map.sTrap[v5].field_A = wall.getPicnum();
                    }
                    ++v16;
                    ++v17;
                }
            }
        }
        return 0x1F0000 | v5;
    }

    public static void FuncTrap(int nStack, int ignored, int RunPtr) {
        int nTrap = RunList.RunData[RunPtr].getObject();
        TrapStruct pTrap = Map.sTrap[nTrap];
        int nSprite = pTrap.field_2;
        switch (nStack & 0x7F0000) {
            case 65536: {
                pTrap.field_0 = RunList.channel[nStack & 0x1FFF].field_4 <= 0 ? -1 : 12;
                return;
            }
            case 131072: {
                Wall wall2;
                int v8 = pTrap.field_0;
                if (pTrap.field_0 < 0 || --pTrap.field_0 > 10) break;
                int v10 = pTrap.field_4;
                if (v8 == 1) {
                    Wall wall22;
                    pTrap.field_0 = Map.nTrapInterval[nTrap];
                    if (v10 != 14) break;
                    Wall wall = Main.boardService.getWall(pTrap.nWall);
                    if (wall != null) {
                        wall.setPicnum(pTrap.field_A);
                    }
                    if ((wall22 = Main.boardService.getWall(pTrap.nWall2)) == null) break;
                    wall22.setPicnum(pTrap.field_C);
                    break;
                }
                if (pTrap.field_0 != 5) break;
                Sprite pSprite = Main.boardService.getSprite(nSprite);
                if (pSprite == null) {
                    return;
                }
                BulletStruct.BulletResult bulletResult = Bullet.BuildBullet(nSprite, v10, 0, pSprite.getAng(), 0, 1);
                Sprite pBulletOwner = bulletResult.getSprite();
                if (pBulletOwner == null) {
                    return;
                }
                if (v10 == 15) {
                    pBulletOwner.setAng(pBulletOwner.getAng() - 512 & 0x7FF);
                    Sound.D3PlayFX(Sound.StaticSound[32], nSprite);
                    break;
                }
                pBulletOwner.setClipdist(50);
                Wall wall = Main.boardService.getWall(pTrap.nWall);
                if (wall != null) {
                    wall.setPicnum(pTrap.field_A + 1);
                }
                if ((wall2 = Main.boardService.getWall(pTrap.nWall2)) != null) {
                    wall2.setPicnum(pTrap.field_C + 1);
                }
                Sound.D3PlayFX(Sound.StaticSound[36], nSprite);
            }
        }
    }

    public static void saveDrips(OutputStream os) throws IOException {
        StreamUtils.writeShort(os, Globals.nDrips);
        for (int i = 0; i < Globals.nDrips; i = (int)((short)(i + 1))) {
            Globals.sDrip[i].save(os);
        }
    }

    public static void loadDrips(SafeLoader loader, InputStream is) throws IOException {
        loader.nDrips = StreamUtils.readShort(is);
        for (int i = 0; i < loader.nDrips; i = (int)((short)(i + 1))) {
            if (loader.sDrip[i] == null) {
                loader.sDrip[i] = new DripStruct();
            }
            loader.sDrip[i].load(is);
        }
    }

    public static void loadDrips(SafeLoader loader) {
        Globals.nDrips = loader.nDrips;
        for (int i = 0; i < loader.nDrips; i = (int)((short)(i + 1))) {
            if (Globals.sDrip[i] == null) {
                Globals.sDrip[i] = new DripStruct();
            }
            Globals.sDrip[i].copy(loader.sDrip[i]);
        }
    }

    public static void BuildDrip(int nSprite) {
        if (Globals.nDrips >= 50) {
            throw new AssertException("Too many drips!");
        }
        if (Globals.sDrip[Globals.nDrips] == null) {
            Globals.sDrip[Globals.nDrips] = new DripStruct();
        }
        DripStruct v4 = Globals.sDrip[Globals.nDrips];
        ++Globals.nDrips;
        v4.field_0 = nSprite;
        v4.field_2 = Random.RandomSize(8) + 90;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite != null) {
            pSprite.setCstat(32768);
        }
    }

    public static void saveBobs(OutputStream os) throws IOException {
        int i;
        StreamUtils.writeShort(os, Globals.nBobs);
        for (i = 0; i < 200; i = (int)((short)(i + 1))) {
            StreamUtils.writeShort(os, Globals.sBobID[i]);
        }
        for (i = 0; i < Globals.nBobs; i = (int)((short)(i + 1))) {
            Globals.sBob[i].save(os);
        }
    }

    public static void loadBobs(SafeLoader loader, InputStream is) throws IOException {
        int i;
        loader.nBobs = StreamUtils.readShort(is);
        for (i = 0; i < 200; i = (int)((short)(i + 1))) {
            loader.sBobID[i] = StreamUtils.readShort(is);
        }
        for (i = 0; i < loader.nBobs; i = (int)((short)(i + 1))) {
            if (loader.sBob[i] == null) {
                loader.sBob[i] = new BobStruct();
            }
            loader.sBob[i].load(is);
        }
    }

    public static void loadBobs(SafeLoader loader) {
        Globals.nBobs = loader.nBobs;
        System.arraycopy(loader.sBobID, 0, Globals.sBobID, 0, Globals.nBobs);
        for (int i = 0; i < loader.nBobs; i = (int)((short)(i + 1))) {
            if (Globals.sBob[i] == null) {
                Globals.sBob[i] = new BobStruct();
            }
            Globals.sBob[i].copy(loader.sBob[i]);
        }
    }

    public static void DoDrips() {
        int i;
        for (i = 0; i < Globals.nDrips; ++i) {
            if (--Globals.sDrip[i].field_2 > 0) continue;
            Sprite spr = Main.boardService.getSprite(Globals.sDrip[i].field_0);
            if (spr != null) {
                int v3 = Seq.SeqOffsets[62];
                if (Globals.SectFlag[spr.getSectnum() & 0x4000] == 0) {
                    v3 = Seq.SeqOffsets[62] + 1;
                }
                Seq.MoveSequence(Globals.sDrip[i].field_0, v3, Random.RandomSize(2) % Seq.SeqSize[v3]);
            }
            Globals.sDrip[i].field_2 = Random.RandomSize(8) + 90;
        }
        for (i = 0; i < Globals.nBobs; ++i) {
            Sector sec = Main.boardService.getSector(Globals.sBob[i].field_0);
            if (sec == null) continue;
            Globals.sBob[i].field_2 = (byte)(Globals.sBob[i].field_2 + 4);
            int v10 = EngineUtils.sin(8 * Globals.sBob[i].field_2 & 0x7FF) >> 4;
            if (Globals.sBob[i].field_3 != 0) {
                Main.game.pInt.setceilinterpolate(Globals.sBob[i].field_0, sec);
                sec.setCeilingz(Globals.sBob[i].field_4 + v10);
                continue;
            }
            int v13 = v10 + Globals.sBob[i].field_4;
            int v14 = v13 - sec.getFloorz();
            Main.game.pInt.setfloorinterpolate(Globals.sBob[i].field_0, sec);
            sec.setFloorz(v13);
            Object.MoveSectorSprites(Globals.sBob[i].field_0, v14);
        }
    }

    public static void DoFinale() {
        block9: {
            Sprite pSprite;
            block6: {
                block7: {
                    block10: {
                        block8: {
                            if (Globals.lFinaleStart == 0) {
                                return;
                            }
                            if (++FinaleMoves < 90) break block6;
                            Object.DimLights();
                            if (Globals.nDronePitch > -2400) break block7;
                            if (Globals.nFinaleStage >= 2) break block8;
                            if (Globals.nFinaleStage == 1) {
                                Sound.StopLocalSound();
                                Sound.PlayLocalSound(Sound.StaticSound[76], 0);
                                FinaleClock = Main.engine.getTotalClock() + 120;
                                ++Globals.nFinaleStage;
                            }
                            break block9;
                        }
                        if (Globals.nFinaleStage != 2) break block10;
                        if (Main.engine.getTotalClock() >= FinaleClock) {
                            Sound.PlayLocalSound(Sound.StaticSound[77], 0);
                            ++Globals.nFinaleStage;
                            FinaleClock = Main.engine.getTotalClock() + 360;
                        }
                        break block9;
                    }
                    if (Globals.nFinaleStage != 3 || Main.engine.getTotalClock() < FinaleClock) break block9;
                    Map.FinishLevel();
                    break block9;
                }
                Globals.nDronePitch -= 128;
                Sound.BendAmbientSound();
                Globals.nFinaleStage = 1;
                break block9;
            }
            if ((FinaleMoves & 2) == 0 && (pSprite = Main.boardService.getSprite(Globals.nFinaleSpr)) != null) {
                pSprite.setAng(Random.RandomSize(11));
                Object.BuildSpark(Globals.nFinaleSpr, 1);
            }
            if (Random.RandomSize(2) == 0) {
                Sound.PlayFX2(Sound.StaticSound[78] | 0x2000, Globals.nFinaleSpr);
                for (int i = 0; i < Mmulti.numplayers; ++i) {
                    Globals.nQuake[i] = 1280;
                }
            }
        }
    }

    private static void DimLights() {
        Sector[] sectors;
        boolean bl = bLightTrig = !bLightTrig;
        if (!bLightTrig) {
            return;
        }
        for (Sector sec : sectors = Main.boardService.getBoard().getSectors()) {
            if (sec.getCeilingshade() < 100) {
                sec.setCeilingshade(sec.getCeilingshade() + 1);
            }
            if (sec.getFloorshade() < 100) {
                sec.setFloorshade(sec.getFloorshade() + 1);
            }
            for (ListNode<Wall> wn = sec.getWallNode(); wn != null; wn = wn.getNext()) {
                Wall w = wn.get();
                if (w.getShade() >= 100) continue;
                w.setShade(w.getShade() + 1);
            }
        }
    }

    static {
        Elevator = new ElevStruct[1024];
        WallFace = new WallFaceStruct[4096];
    }
}

