/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector2;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Powerslave.Anim;
import ru.m210projects.Powerslave.Cinema;
import ru.m210projects.Powerslave.Enemies.Ra;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Light;
import ru.m210projects.Powerslave.LoadSave;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Map;
import ru.m210projects.Powerslave.Object;
import ru.m210projects.Powerslave.PSSector;
import ru.m210projects.Powerslave.Palette;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Screens.DemoScreen;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.SpiritHead;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.PlayerSave;
import ru.m210projects.Powerslave.Type.StatusAnim;
import ru.m210projects.Powerslave.View;
import ru.m210projects.Powerslave.Weapons;

public class Player {
    public static final String deathMessage1 = "or \"enter\" to load last saved game";
    public static final String deathMessage2 = "Press \"use\" to restart the level";
    public static final int MAXHORIZ = 300;
    public static final int MAXOHORIZ = 180;
    public static final int MINHORIZ = -130;
    public static final int MINOHORIZ = 0;
    public static final Action[] ActionSeq = new Action[]{new Action(18, false), new Action(0, false), new Action(9, false), new Action(27, false), new Action(63, false), new Action(72, false), new Action(54, false), new Action(45, false), new Action(54, false), new Action(81, false), new Action(90, false), new Action(99, false), new Action(108, false), new Action(8, false), new Action(0, false), new Action(139, false), new Action(117, true), new Action(119, true), new Action(120, true), new Action(121, true), new Action(122, true)};
    public static final short[] nActionEyeLevel = new short[]{-14080, -14080, -14080, -14080, -14080, -14080, -8320, -8320, -8320, -8320, -8320, -8320, -8320, -14080, -14080, -14080, -14080, -14080, -14080, -14080, -14080};
    public static final int[] nHeightTemplate = new int[]{0, 0, 0, 0, 0, 0, 7, 7, 7, 9, 9, 9, 9, 0, 0, 0, 0, 0, 0, 0, 0};
    public static int nLocalEyeSect;
    public static final PlayerSave[] sPlayerSave;

    public static int GetPlayerFromSprite(int num) {
        Sprite spr = Main.boardService.getSprite(num);
        if (spr != null) {
            return RunList.RunData[spr.getOwner()].getObject();
        }
        return -1;
    }

    public static void InitPlayerKeys(int num) {
        Globals.PlayerList[num].KeysBitMask = 0;
    }

    public static void RestartPlayer(int num) {
        int floorspr;
        int nSprite = Globals.PlayerList[num].spriteId;
        int nDopple = Globals.nDoppleSprite[num];
        Sprite pPlayerSpr = Main.boardService.getSprite(nSprite);
        if (pPlayerSpr != null) {
            Sprite pDopple;
            RunList.DoSubRunRec(pPlayerSpr.getOwner());
            RunList.FreeRun(pPlayerSpr.getLotag() - 1);
            Main.engine.changespritestat(nSprite, 0);
            Globals.PlayerList[num].spriteId = -1;
            if (Globals.nPlayerFloorSprite[num] > -1) {
                Main.engine.mydeletesprite(Globals.nPlayerFloorSprite[num]);
            }
            if ((pDopple = Main.boardService.getSprite(nDopple)) != null) {
                RunList.DoSubRunRec(pDopple.getOwner());
                RunList.FreeRun(pDopple.getLotag() - 1);
                Main.engine.mydeletesprite(nDopple);
            }
        }
        int spr = Sprites.GrabBody();
        Sprite pSprite = Main.boardService.getSprite(spr);
        PlayerSave pSave = sPlayerSave[num];
        Main.engine.changespritesect(spr, pSave.sect);
        Main.engine.changespritestat(spr, 100);
        if (pSprite == null) {
            throw new AssertException("Player sprite == null");
        }
        int dspr = Main.engine.insertsprite(pSprite.getSectnum(), 100);
        Sprite pDSprite = Main.boardService.getSprite(dspr);
        if (pDSprite == null) {
            throw new AssertException("(dspr>=0) && (dspr<MAXSPRITES)");
        }
        Globals.nDoppleSprite[num] = dspr;
        if (Mmulti.numplayers <= 1) {
            pSprite.setX(pSave.x);
            pSprite.setY(pSave.y);
            Sector sec = Main.boardService.getSector(pSave.sect);
            if (sec != null) {
                pSprite.setZ(sec.getFloorz());
            }
            Globals.PlayerList[num].ang = pSave.ang;
            pSprite.setAng(pSave.ang);
            floorspr = -1;
        } else {
            int nNetStart;
            Sprite pNetStart;
            if ((pNetStart = Main.boardService.getSprite(nNetStart = Globals.nNetStartSprite[Globals.nCurStartSprite++])) == null) {
                throw new AssertException("pNetStart != null");
            }
            if (Globals.nCurStartSprite >= Globals.nNetStartSprites) {
                Globals.nCurStartSprite = 0;
            }
            pSprite.setX(pNetStart.getX());
            pSprite.setY(pNetStart.getY());
            pSprite.setZ(pNetStart.getZ());
            Main.engine.mychangespritesect(spr, pNetStart.getSectnum());
            Globals.PlayerList[num].ang = pNetStart.getAng();
            pSprite.setAng((int)Globals.PlayerList[num].ang);
            floorspr = Main.engine.insertsprite(pSprite.getSectnum(), 0);
            Sprite pFloorspr = Main.boardService.getSprite(floorspr);
            if (pFloorspr == null) {
                throw new AssertException("(floorspr>=0 && floorspr<MAXSPRITES");
            }
            pFloorspr.setX(pSprite.getX());
            pFloorspr.setY(pSprite.getY());
            pFloorspr.setZ(pSprite.getZ());
            pFloorspr.setYrepeat(64);
            pFloorspr.setXrepeat(64);
            pFloorspr.setCstat(32);
            pFloorspr.setPicnum(num + 3571);
        }
        Globals.nPlayerFloorSprite[num] = floorspr;
        pSprite.setCstat(257);
        pSprite.setShade(-12);
        pSprite.setClipdist(58);
        pSprite.setPal(0);
        pSprite.setXrepeat(40);
        pSprite.setYrepeat(40);
        pSprite.setXoffset(0);
        pSprite.setYoffset(0);
        pSprite.setPicnum(Seq.GetSeqPicnum(25, 18, 0));
        Globals.nStandHeight = Sprites.GetSpriteHeight(spr);
        pSprite.setXvel(0);
        pSprite.setYvel(0);
        pSprite.setZvel(0);
        pSprite.setLotag(RunList.HeadRun() + 1);
        pSprite.setHitag(0);
        pSprite.setExtra(-1);
        pDSprite.setX(pSprite.getX());
        pDSprite.setY(pSprite.getY());
        pDSprite.setZ(pSprite.getZ());
        pDSprite.setXrepeat(pSprite.getXrepeat());
        pDSprite.setYrepeat(pSprite.getYrepeat());
        pDSprite.setYoffset(0);
        pDSprite.setXoffset(0);
        pDSprite.setShade(pSprite.getShade());
        pDSprite.setAng(pSprite.getAng());
        pDSprite.setCstat(pSprite.getCstat());
        pDSprite.setLotag(RunList.HeadRun() + 1);
        Globals.PlayerList[num].anim_ = 0;
        Globals.PlayerList[num].animCount = 0;
        Globals.PlayerList[num].spriteId = spr;
        Globals.PlayerList[num].invisibility = 0;
        Globals.PlayerList[num].mummified = 0;
        Main.engine.getPaletteManager().SetTorch(num, 0);
        Globals.nPlayerInvisible[num] = 0;
        Globals.PlayerList[num].weaponFire = 0;
        Globals.PlayerList[num].seqOffset = 0;
        Globals.nPlayerViewSect[num] = pSave.sect;
        Globals.PlayerList[num].weaponState = 0;
        Globals.nPlayerDouble[num] = 0;
        Globals.PlayerList[num].seq = 25;
        Globals.nPlayerPushSound[num] = -1;
        Globals.PlayerList[num].newWeapon = -1;
        Globals.PlayerList[num].lastWeapon = 0;
        Globals.PlayerList[num].AirAmount = 100;
        Globals.nPlayerGrenade[num] = -1;
        Globals.nPlayerTorch[num] = 0;
        Globals.PlayerList[num].AirMaskAmount = 0;
        if (LoadSave.gClassicMode) {
            Globals.PlayerList[num].HealthAmount = 800;
            if (Globals.nNetPlayerCount != 0) {
                Globals.PlayerList[num].HealthAmount = 1600;
            }
            if (Globals.PlayerList[num].currentWeapon == 7) {
                Globals.PlayerList[num].currentWeapon = Globals.PlayerList[num].lastWeapon;
            }
        }
        if (Globals.levelnum <= 20) {
            if (!LoadSave.gClassicMode) {
                Weapons.RestoreMinAmmo(num);
            } else {
                Weapons.CheckClip(num);
            }
        } else {
            Weapons.ResetPlayerWeapons(num);
            Globals.PlayerList[num].MagicAmount = 0;
        }
        Globals.PlayerList[num].eyelevel = -14080;
        Globals.dVertPan[num] = 0;
        Globals.nTemperature[num] = 0;
        Globals.nYDamage[num] = 0;
        Globals.nXDamage[num] = 0;
        Globals.PlayerList[num].horiz = 92.0f;
        Globals.nDestVertPan[num] = 92.0f;
        Globals.nBreathTimer[num] = 90;
        Globals.nTauntTimer[num] = Random.RandomSize(3) + 3;
        pDSprite.setOwner(RunList.AddRunRec(pDSprite.getLotag() - 1, 0xA0000 | num));
        pSprite.setOwner(RunList.AddRunRec(pSprite.getLotag() - 1, 0xA0000 | num));
        if (Globals.PlayerList[num].RunFunc < 0) {
            Globals.PlayerList[num].RunFunc = RunList.AddRunRec(RunList.NewRun, 0xA0000 | num);
        }
        Ra.BuildRa(num);
        if (num == Globals.nLocalPlayer) {
            View.SetMagicFrame();
            Main.engine.getPaletteManager().restoreGreenPal();
            Globals.bPlayerPan = false;
            Globals.bLockPan = false;
        }
        Globals.totalvel[num] = 0;
        Globals.nDeathType[num] = 0;
        Globals.nQuake[num] = 0;
        if (num == Globals.nLocalPlayer) {
            View.SetHealthFrame(0);
        }
    }

    public static void SetSavePoint(int num, int x, int y, int z, int sect, int ang) {
        PlayerSave ps = sPlayerSave[num];
        ps.x = x;
        ps.y = y;
        ps.z = z;
        ps.sect = sect;
        ps.ang = ang;
    }

    public static int GrabPlayer() {
        if (Globals.PlayerCount >= 8) {
            return -1;
        }
        return Globals.PlayerCount++;
    }

    public static void InitPlayerInventory(int nPlayer) {
        Globals.PlayerList[nPlayer].reset();
        Globals.PlayerList[nPlayer].nPlayer = nPlayer;
        Globals.nPlayerItem[nPlayer] = -1;
        Globals.nPlayerSwear[nPlayer] = 4;
        Weapons.ResetPlayerWeapons(nPlayer);
        Globals.nPlayerLives[nPlayer] = LoadSave.gClassicMode ? 3 : 0;
        Globals.PlayerList[nPlayer].spriteId = -1;
        Globals.PlayerList[nPlayer].RunFunc = -1;
        Globals.nPistolClip[nPlayer] = 6;
        Globals.nPlayerClip[nPlayer] = 0;
        Globals.PlayerList[nPlayer].currentWeapon = 0;
        if (nPlayer == Globals.nLocalPlayer) {
            Globals.bMapMode = false;
        }
        Globals.nPlayerScore[nPlayer] = 0;
    }

    public static void SetItemSeq() {
        int item = Globals.nPlayerItem[Globals.nLocalPlayer];
        if (item < 0) {
            Globals.nItemSeq = -1;
        } else {
            Globals.nItemAltSeq = Globals.nItemMagic[Globals.nPlayerItem[Globals.nLocalPlayer]] <= Globals.PlayerList[Globals.nLocalPlayer].MagicAmount ? 0 : 2;
            Globals.nItemFrame = 0;
            Globals.nItemSeq = Globals.nItemAltSeq + Globals.nItemSeqOffset[item];
            Globals.nItemFrames = Seq.SeqSize[Globals.nStatusSeqOffset + Globals.nItemSeq];
        }
    }

    public static void SetPlayerItem(int nPlayer, int nItem) {
        Globals.nPlayerItem[nPlayer] = nItem;
        if (nPlayer == Globals.nLocalPlayer) {
            Player.SetItemSeq();
            if (nItem >= 0) {
                StatusAnim.BuildStatusAnim(2 * Globals.PlayerList[nPlayer].ItemsAmount[nItem] + 156, 0);
            }
        }
    }

    public static void FuncPlayer(int nStack, int a2, int RunPtr) {
        int player = RunList.RunData[RunPtr].getObject();
        if (player < 0 || player >= 8) {
            throw new AssertException("player>=0 && player<MAXPLAYER");
        }
        if (Globals.PlayerList[player].network == -1) {
            return;
        }
        boolean v233 = false;
        int spr = Globals.PlayerList[player].spriteId;
        int dspr = Globals.nDoppleSprite[player];
        Sprite pDSprite = Main.boardService.getSprite(dspr);
        Sprite pSprite = Main.boardService.getSprite(spr);
        if (pSprite == null || pDSprite == null) {
            throw new AssertException("Player sprite == null");
        }
        int anim = Globals.PlayerList[player].anim_;
        int v229 = -1;
        switch (nStack & 0x7F0000) {
            case 131072: {
                boolean bViewUnderwater;
                Sector sec;
                short osect;
                boolean bUnderwater;
                int quake;
                int god;
                int invis;
                if ((Globals.sPlayerInput[player].bits & 0x200) != 0) {
                    Player.UseCurItem(player, Globals.nPlayerItem[player]);
                }
                if ((Globals.sPlayerInput[player].bits & 0x80) != 0) {
                    Player.SetPrevItem(player);
                }
                if ((Globals.sPlayerInput[player].bits & 0x100) != 0) {
                    Player.SetNextItem(player);
                }
                if ((Globals.sPlayerInput[player].bits & 0x80000) != 0) {
                    Player.UseCurItem(player, 3);
                }
                if ((Globals.sPlayerInput[player].bits & 0x100000) != 0) {
                    Player.UseCurItem(player, 4);
                }
                if ((Globals.sPlayerInput[player].bits & 0x200000) != 0) {
                    Player.UseCurItem(player, 5);
                }
                if ((Globals.sPlayerInput[player].bits & 0x400000) != 0) {
                    Player.UseCurItem(player, 0);
                }
                if ((Globals.sPlayerInput[player].bits & 0x800000) != 0) {
                    Player.UseCurItem(player, 2);
                }
                if ((Globals.sPlayerInput[player].bits & 0x1000000) != 0) {
                    Player.UseCurItem(player, 1);
                }
                int next_anim = Globals.PlayerList[player].anim_;
                pSprite.setXvel(Globals.sPlayerInput[player].xvel >> 14);
                pSprite.setYvel(Globals.sPlayerInput[player].yvel >> 14);
                if (Globals.sPlayerInput[player].field_F > -1) {
                    Player.UseItem(player, Globals.sPlayerInput[player].field_F);
                    Globals.sPlayerInput[player].field_F = (byte)-1;
                }
                int picnum = Seq.GetSeqPicnum(Globals.PlayerList[player].seq, Player.ActionSeq[Player.nHeightTemplate[anim]].seq, Globals.PlayerList[player].animCount);
                pDSprite.setPicnum(picnum);
                pSprite.setPicnum(picnum);
                int torch = Globals.nPlayerTorch[player];
                if (torch > 0) {
                    Globals.nPlayerTorch[player] = torch - 1;
                    if (torch == 1) {
                        Main.engine.getPaletteManager().SetTorch(player, 0);
                    } else if (player != Globals.nLocalPlayer) {
                        Light.nFlashDepth = 5;
                        Light.AddFlash(pSprite.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ(), 0);
                        Light.nFlashDepth = 2;
                    }
                } else if (player == Globals.nLocalPlayer) {
                    Light.bTorch = 0;
                }
                short dble = (short)Globals.nPlayerDouble[player];
                if (dble > 0) {
                    Globals.nPlayerDouble[player] = dble - 1;
                    if (Globals.nPlayerDouble[player] == 150 && player == Globals.nLocalPlayer) {
                        Player.PlayAlert("WEAPON POWER IS ABOUT TO EXPIRE", player);
                    }
                }
                if ((invis = Globals.nPlayerInvisible[player]) > 0) {
                    Globals.nPlayerInvisible[player] = invis - 1;
                    if (invis == 1) {
                        pSprite.setCstat(pSprite.getCstat() & Short.MAX_VALUE);
                        int fl = Globals.nPlayerFloorSprite[player];
                        Sprite floorSprite = Main.boardService.getSprite(fl);
                        if (floorSprite != null) {
                            floorSprite.setCstat(floorSprite.getCstat() & Short.MAX_VALUE);
                        }
                    } else if (Globals.nPlayerInvisible[player] == 150 && player == Globals.nLocalPlayer) {
                        Player.PlayAlert("INVISIBILITY IS ABOUT TO EXPIRE", player);
                    }
                }
                if ((god = Globals.PlayerList[player].invisibility) > 0) {
                    Globals.PlayerList[player].invisibility = god - 1;
                    if (Globals.PlayerList[player].invisibility == 150 && player == Globals.nLocalPlayer) {
                        Player.PlayAlert("INVINCIBILITY IS ABOUT TO EXPIRE", player);
                    }
                }
                if ((quake = Globals.nQuake[player]) != 0) {
                    Globals.nQuake[player] = -quake;
                    if (Globals.nQuake[player] >= 0 && Globals.nQuake[player] != 0) {
                        Globals.nQuake[player] = Globals.nQuake[player] - 512;
                        if (-quake - 512 < 0) {
                            Globals.nQuake[player] = 0;
                        }
                    }
                }
                Globals.PlayerList[player].ang = Gameutils.BClampAngle(Globals.PlayerList[player].ang + 4.0f * Globals.sPlayerInput[player].avel);
                pSprite.setAng((int)Globals.PlayerList[player].ang);
                short ozvel = pSprite.getZvel();
                Sprites.Gravity(spr);
                if (pSprite.getZvel() >= 6500 && ozvel < 6500) {
                    Sound.D3PlayFX(Sound.StaticSound[17], spr);
                }
                short osectnum = pSprite.getSectnum();
                boolean oUnderwater = (Globals.SectFlag[Globals.nPlayerViewSect[player]] & 0x2000) != 0;
                int sx = pSprite.getX();
                int sy = pSprite.getY();
                int sz = pSprite.getZ();
                int xvel = 4 * Globals.sPlayerInput[player].xvel >> 2;
                int yvel = 4 * Globals.sPlayerInput[player].yvel >> 2;
                int zvel = 4 * pSprite.getZvel() >> 2;
                if (pSprite.getZvel() > 8192) {
                    pSprite.setZvel(8192);
                }
                ozvel = pSprite.getZvel();
                if (Globals.PlayerList[player].mummified != 0) {
                    xvel /= 2;
                    yvel /= 2;
                }
                int moveHit = 0;
                if (Globals.bSlipMode) {
                    pSprite.setX(pSprite.getX() + (xvel >> 14));
                    pSprite.setY(pSprite.getY() + (yvel >> 14));
                    Main.engine.setsprite(spr, pSprite.getX(), pSprite.getY(), pSprite.getZ());
                    Sector sec2 = Main.boardService.getSector(pSprite.getSectnum());
                    if (sec2 != null) {
                        pSprite.setZ(sec2.getFloorz());
                    }
                } else {
                    moveHit = Main.engine.movesprite(spr, xvel, yvel, zvel, 5120, -5120, 0);
                    Main.engine.pushmove(pSprite.getX(), pSprite.getY(), pSprite.getZ(), pSprite.getSectnum(), 4 * pSprite.getClipdist(), 5120, -5120, 0);
                    pSprite.setX(Engine.pushmove_x);
                    pSprite.setY(Engine.pushmove_y);
                    pSprite.setZ(Engine.pushmove_z);
                    if (Main.boardService.isValidSector(Engine.pushmove_sectnum) && pSprite.getSectnum() != Engine.pushmove_sectnum) {
                        Main.engine.mychangespritesect(spr, Engine.pushmove_sectnum);
                    }
                    if (Main.engine.inside(pSprite.getX(), pSprite.getY(), pSprite.getSectnum()) == 0) {
                        Main.engine.mychangespritesect(spr, osectnum);
                        pSprite.setX(sx);
                        pSprite.setY(sy);
                        if (ozvel < pSprite.getZvel()) {
                            pSprite.setZvel(ozvel);
                        }
                    }
                }
                boolean bl = bUnderwater = (Globals.SectFlag[pSprite.getSectnum()] & 0x2000) != 0;
                if (bUnderwater) {
                    int v48 = Globals.nXDamage[player];
                    Globals.nXDamage[player] = v48 - (v48 & 0xFF00) >> 1;
                    int v49 = Globals.nYDamage[player];
                    Globals.nYDamage[player] = v49 - (v49 & 0xFF00) >> 1;
                }
                if ((Globals.SectFlag[pSprite.getSectnum()] & 0x8000) != 0 && Globals.bTouchFloor[0]) {
                    if (Mmulti.numplayers <= 1) {
                        Globals.PlayerList[player].ang = Sprites.GetAngleToSprite(pSprite, Main.boardService.getSprite(SpiritHead.nSpiritSprite));
                        pSprite.setAng((int)Globals.PlayerList[player].ang);
                        pSprite.setZvel(0);
                        pSprite.setYvel(0);
                        pSprite.setXvel(pSprite.getYvel());
                        if (Globals.nFreeze < 1) {
                            Globals.nFreeze = 1;
                            Sound.StopAllSounds();
                            Sound.StopLocalSound();
                            SpiritHead.InitSpiritHead();
                            Globals.nDestVertPan[player] = 92.0f;
                            Globals.nDestVertPan[player] = Globals.levelnum == 11 ? 138.0f : 103.0f;
                        }
                    } else {
                        Map.FinishLevel();
                    }
                    return;
                }
                if ((moveHit & 0x3C000) != 0) {
                    if (Globals.bTouchFloor[0]) {
                        int v53 = Globals.nXDamage[player];
                        Globals.nXDamage[player] = v53 - (v53 & 0xFF00) >> 1;
                        int v54 = Globals.nYDamage[player];
                        Globals.nYDamage[player] = v54 - (v54 & 0xFF00) >> 1;
                        if (player == Globals.nLocalPlayer && !Main.cfg.isgMouseAim() && Pragmas.klabs(ozvel) > 512) {
                            Globals.nDestVertPan[player] = 92.0f;
                        }
                        if (ozvel >= 6500) {
                            pSprite.setXvel(pSprite.getXvel() >> 2);
                            pSprite.setYvel(pSprite.getYvel() >> 2);
                            Sprites.DamageEnemy(spr, -1, (ozvel - 6500 >> 7) + 10);
                            if (Globals.PlayerList[player].HealthAmount > 0) {
                                Sound.D3PlayFX(Sound.StaticSound[27] | 0x2000, spr);
                            } else {
                                pSprite.setXvel(0);
                                pSprite.setYvel(0);
                                Sound.StopSpriteSound(spr);
                                Sound.PlayFXAtXYZ(Sound.StaticSound[60], pSprite.getX(), pSprite.getY(), pSprite.getZ(), pSprite.getSectnum() | 0x4000);
                            }
                        }
                    }
                    int hitobject = -1;
                    switch (moveHit & 0xE000) {
                        case 16384: {
                            hitobject = moveHit & 0x1FFF;
                            break;
                        }
                        case 32768: {
                            Wall wall = Main.boardService.getWall(moveHit & 0x1FFF);
                            if (wall == null) break;
                            hitobject = wall.getNextsector();
                        }
                    }
                    Sector pHitSector = Main.boardService.getSector(hitobject);
                    if (pHitSector != null && pHitSector.getHitag() == 45 && Globals.bTouchFloor[0] && Pragmas.klabs(Sprites.AngleDiff(Main.engine.GetWallNormal(moveHit & 0x1FFF), pSprite.getAng() + 1024 & 0x7FF)) <= 256) {
                        Globals.nPlayerPushSect[player] = hitobject;
                        int xv = Globals.sPlayerInput[player].xvel;
                        int yv = Globals.sPlayerInput[player].yvel;
                        Vector2 out = PSSector.MoveSector(hitobject, Main.engine.GetMyAngle(xv, yv), xv, yv);
                        xv = (int)out.x;
                        yv = (int)out.y;
                        if (Globals.nPlayerPushSound[player] == -1) {
                            Globals.nPlayerPushSound[player] = pHitSector.getExtra();
                            Sound.D3PlayFX(Sound.StaticSound[23], Globals.sBlockInfo[pHitSector.getExtra()].sprite | 0x4000);
                        } else {
                            pSprite.setX(sx);
                            pSprite.setY(sy);
                            pSprite.setZ(sz);
                            Main.engine.mychangespritesect(spr, osectnum);
                        }
                        Main.engine.movesprite(spr, xv, yv, zvel, 5120, -5120, 0);
                    } else if (Globals.nPlayerPushSound[player] != -1) {
                        if (Globals.nPlayerPushSect[player] != -1) {
                            Sound.StopSpriteSound(Globals.sBlockInfo[Globals.nPlayerPushSound[player]].sprite);
                        }
                        Globals.nPlayerPushSound[player] = -1;
                    }
                }
                if (!Globals.bPlayerPan && !Globals.bLockPan) {
                    int v74 = (sz - pSprite.getZ()) / 32 + 92;
                    Globals.nDestVertPan[player] = Gameutils.BClipRange(v74, 0, 183);
                }
                int dx = sx - pSprite.getX();
                int dy = sy - pSprite.getY();
                Globals.totalvel[player] = EngineUtils.sqrt(dx * dx + dy * dy);
                int sectnum = pSprite.getSectnum();
                int z = Globals.nQuake[player] + pSprite.getZ() + Globals.PlayerList[player].eyelevel;
                Sector s = Main.boardService.getSector(sectnum);
                if (s != null && z < s.getCeilingz() && Globals.SectAbove[sectnum] > -1) {
                    sectnum = Globals.SectAbove[sectnum];
                }
                if (bUnderwater && sectnum != (osect = pSprite.getSectnum()) && (moveHit & 0xE000) == 32768) {
                    int ox = pSprite.getX();
                    int oy = pSprite.getY();
                    int oz = pSprite.getZ();
                    Main.engine.mychangespritesect(spr, sectnum);
                    pSprite.setX(sx);
                    pSprite.setY(sy);
                    sec = Main.boardService.getSector(sectnum);
                    if (sec != null) {
                        int fz = -5120 + sec.getFloorz();
                        pSprite.setZ(fz);
                        if ((Main.engine.movesprite(spr, xvel, yvel, 0, 5120, 0, 0) & 0xE000) == 32768) {
                            Main.engine.mychangespritesect(spr, osect);
                            pSprite.setX(ox);
                            pSprite.setY(oy);
                            pSprite.setZ(oz);
                        } else {
                            pSprite.setZ(fz - 256);
                            Sound.D3PlayFX(Sound.StaticSound[42], spr);
                        }
                    }
                }
                Globals.nPlayerViewSect[player] = sectnum;
                Globals.nPlayerDX[player] = pSprite.getX() - sx;
                Globals.nPlayerDY[player] = pSprite.getY() - sy;
                boolean bl2 = bViewUnderwater = (Globals.SectFlag[sectnum] & 0x2000) != 0;
                if (Globals.PlayerList[player].HealthAmount <= 0) {
                    if (!LoadSave.gClassicMode && anim >= 16) {
                        if (Globals.message_timer <= 0) {
                            if (Main.game.isCurrentScreen(Main.gGameScreen) && LoadSave.lastload != null && LoadSave.lastload.exists()) {
                                View.StatusMessage(5000, deathMessage1, player);
                            } else {
                                View.StatusMessage(5000, deathMessage2, player);
                            }
                        }
                        if (Main.game.isCurrentScreen(Main.gGameScreen) && LoadSave.lastload != null && LoadSave.lastload.exists() && Gdx.input.isKeyPressed(66)) {
                            Main.game.changeScreen(Main.gLoadingScreen.setTitle(LoadSave.lastload.getName()));
                            Main.gLoadingScreen.init(() -> {
                                if (!LoadSave.loadgame(LoadSave.lastload)) {
                                    Main.game.GameMessage("Can't load game!");
                                }
                            });
                            return;
                        }
                    }
                    if ((Globals.sPlayerInput[player].bits & 4) != 0 && anim >= 16) {
                        if (!LoadSave.gClassicMode) {
                            Gdx.app.postRunnable(() -> Main.gGameScreen.newgame(Globals.mUserFlag == Main.UserFlag.UserMap ? Globals.boardfilename : Globals.gCurrentEpisode, Globals.levelnum, false));
                            return;
                        }
                        if (player == Globals.nLocalPlayer) {
                            Sound.StopAllSounds();
                            Sound.StopLocalSound();
                            Palette.GrabPalette();
                        }
                        Globals.PlayerList[player].currentWeapon = Globals.nPlayerOldWeapon[player];
                        if (Globals.nPlayerLives[player] != 0) {
                            if (anim != 20) {
                                pSprite.setPicnum(Seq.GetSeqPicnum(25, 120, 0));
                                pSprite.setCstat(0);
                                Sector sec3 = Main.boardService.getSector(pSprite.getSectnum());
                                if (sec3 != null) {
                                    pSprite.setZ(sec3.getFloorz());
                                }
                            }
                            Player.RestartPlayer(player);
                            dspr = Globals.nDoppleSprite[player];
                            pSprite = Main.boardService.getSprite(Globals.PlayerList[player].spriteId);
                            pDSprite = Main.boardService.getSprite(Globals.nDoppleSprite[player]);
                            if (pSprite == null || pDSprite == null) {
                                throw new AssertException("Player sprite == null");
                            }
                        } else if (Globals.levelnum == 20) {
                            Cinema.DoFailedFinalScene();
                        } else {
                            Cinema.DoGameOverScene();
                        }
                    }
                } else {
                    Sprite fspr;
                    if ((Globals.sPlayerInput[player].bits & 0x800) != 0 && Globals.PlayerList[player].turnAround == 0) {
                        Globals.PlayerList[player].turnAround = -1024;
                    }
                    if (Globals.PlayerList[player].turnAround < 0) {
                        Globals.PlayerList[player].turnAround = Gameutils.BClipHigh(Globals.PlayerList[player].turnAround + 128, 0);
                        Globals.PlayerList[player].ang = Gameutils.BClampAngle(Globals.PlayerList[player].ang + 128.0f);
                        pSprite.setAng((int)Globals.PlayerList[player].ang);
                    }
                    if (Globals.PlayerList[player].AirMaskAmount > 0) {
                        --Globals.PlayerList[player].AirMaskAmount;
                        if (Globals.PlayerList[player].AirMaskAmount == 150 && player == Globals.nLocalPlayer) {
                            Player.PlayAlert("MASK IS ABOUT TO EXPIRE", player);
                        }
                    }
                    if (Globals.PlayerList[player].invisibility == 0) {
                        int n = player;
                        Globals.nBreathTimer[n] = Globals.nBreathTimer[n] - 1;
                        if (Globals.nBreathTimer[player] <= 0) {
                            Globals.nBreathTimer[player] = 90;
                            if (bViewUnderwater) {
                                if (Globals.PlayerList[player].AirMaskAmount <= 0) {
                                    Globals.PlayerList[player].AirAmount -= 25;
                                    if (Globals.PlayerList[player].AirAmount <= 0) {
                                        Globals.PlayerList[player].HealthAmount += 4 * Globals.PlayerList[player].AirAmount;
                                        if (Globals.PlayerList[player].HealthAmount <= 0) {
                                            Globals.PlayerList[player].HealthAmount = 0;
                                            Seq.StartDeathSeq(player, 0);
                                        }
                                        if (player == Globals.nLocalPlayer) {
                                            View.SetHealthFrame(-1);
                                        }
                                        Globals.PlayerList[player].AirAmount = 0;
                                        if (Globals.PlayerList[player].HealthAmount >= 300) {
                                            Sound.D3PlayFX(Sound.StaticSound[19], spr);
                                        } else {
                                            Sound.D3PlayFX(Sound.StaticSound[79], spr);
                                        }
                                    } else {
                                        Sound.D3PlayFX(Sound.StaticSound[25], spr);
                                    }
                                } else {
                                    if (player == Globals.nLocalPlayer) {
                                        StatusAnim.BuildStatusAnim(132, 0);
                                    }
                                    Sound.D3PlayFX(Sound.StaticSound[30] | 0x1000, spr);
                                    Globals.PlayerList[player].AirAmount = 100;
                                }
                                Sprites.DoBubbles(player);
                                View.SetAirFrame();
                            } else if (player == Globals.nLocalPlayer) {
                                StatusAnim.BuildStatusAnim(132, 0);
                            }
                        }
                    }
                    if (bViewUnderwater) {
                        if (Globals.nPlayerTorch[player] > 0) {
                            Globals.nPlayerTorch[player] = 0;
                            Main.engine.getPaletteManager().SetTorch(player, 0);
                        }
                    } else {
                        Sector sec4;
                        if (Globals.totalvel[player] > 25 && (sec4 = Main.boardService.getSector(pSprite.getSectnum())) != null && pSprite.getZ() > sec4.getFloorz() && Globals.SectDepth[pSprite.getSectnum()] != 0 && Globals.SectSpeed[pSprite.getSectnum()] == 0 && Globals.SectDamage[pSprite.getSectnum()] == 0) {
                            Sound.D3PlayFX(Sound.StaticSound[42], spr);
                        }
                        if (oUnderwater) {
                            if (Globals.PlayerList[player].AirAmount < 50) {
                                Sound.D3PlayFX(Sound.StaticSound[14], spr);
                            }
                            Globals.nBreathTimer[player] = 1;
                        }
                        int n = player;
                        Globals.nBreathTimer[n] = Globals.nBreathTimer[n] - 1;
                        if (Globals.nBreathTimer[player] <= 0) {
                            Globals.nBreathTimer[player] = 90;
                            if (player == Globals.nLocalPlayer) {
                                StatusAnim.BuildStatusAnim(132, Globals.nLocalPlayer ^ player);
                            }
                        }
                        if (Globals.PlayerList[player].AirAmount < 100) {
                            Globals.PlayerList[player].AirAmount = 100;
                            View.SetAirFrame();
                        }
                    }
                    if (Mmulti.numplayers > 1 && (fspr = Main.boardService.getSprite(Globals.nPlayerFloorSprite[player])) != null) {
                        Sector sec5;
                        fspr.setX(pSprite.getX());
                        fspr.setY(pSprite.getY());
                        if (fspr.getSectnum() != pSprite.getSectnum()) {
                            Main.engine.mychangespritesect(Globals.nPlayerFloorSprite[player], pSprite.getSectnum());
                        }
                        if ((sec5 = Main.boardService.getSector(pSprite.getSectnum())) != null) {
                            fspr.setZ(sec5.getFloorz());
                        }
                    }
                    int flags = 0;
                    if (Globals.PlayerList[player].HealthAmount >= 800) {
                        flags = 2;
                    }
                    if (Globals.PlayerList[player].MagicAmount >= 1000) {
                        flags |= 1;
                    }
                    Main.engine.neartag(pSprite.getX(), pSprite.getY(), pSprite.getZ(), pSprite.getSectnum(), pSprite.getAng(), Engine.neartag, 1024, 2);
                    int v231 = PSSector.feebtag(pSprite.getX(), pSprite.getY(), pSprite.getZ(), pSprite.getSectnum(), flags, 768);
                    Sprite s231 = Main.boardService.getSprite(v231);
                    if (s231 != null) {
                        int nSnd = 9;
                        int tintGreen = 16;
                        int tintRed = 0;
                        int pickFlag = 0;
                        boolean magicPickuped = false;
                        int healthPickuped = -65536;
                        short statnum = s231.getStatnum();
                        if (statnum >= 900) {
                            int statBase = s231.getStatnum() - 900;
                            switch (statnum - 906) {
                                case 0: {
                                    if (!Weapons.AddAmmo(player, 1, s231.getHitag())) break;
                                    nSnd = Sound.StaticSound[69];
                                    pickFlag = 3;
                                    break;
                                }
                                case 1: {
                                    if (!Weapons.AddAmmo(player, 3, s231.getHitag())) break;
                                    nSnd = Sound.StaticSound[69];
                                    pickFlag = 3;
                                    break;
                                }
                                case 2: {
                                    if (!Weapons.AddAmmo(player, 2, s231.getHitag())) break;
                                    nSnd = Sound.StaticSound[69];
                                    pickFlag = 3;
                                    break;
                                }
                                case 4: 
                                case 9: 
                                case 10: 
                                case 18: 
                                case 25: 
                                case 28: 
                                case 29: 
                                case 30: 
                                case 33: 
                                case 34: 
                                case 35: 
                                case 36: 
                                case 37: 
                                case 38: 
                                case 45: 
                                case 52: {
                                    pickFlag = 3;
                                    break;
                                }
                                case 3: 
                                case 21: 
                                case 49: {
                                    if (!Weapons.AddAmmo(player, 4, 1)) break;
                                    nSnd = Sound.StaticSound[69];
                                    if ((Globals.nPlayerWeapons[player] & 0x10) == 0) {
                                        int n = player;
                                        Globals.nPlayerWeapons[n] = Globals.nPlayerWeapons[n] | 0x10;
                                        Weapons.SetNewWeaponIfBetter(player, 4);
                                    }
                                    if (statBase != 55) {
                                        pickFlag = 3;
                                        break;
                                    }
                                    s231.setCstat(32768);
                                    Sprites.DestroyItemAnim(v231);
                                    pickFlag = 2;
                                    break;
                                }
                                case 5: {
                                    Map.GrabMap();
                                    pickFlag = 3;
                                    break;
                                }
                                case 6: 
                                case 7: 
                                case 8: {
                                    if (s231.getHitag() == 0) break;
                                    nSnd = 20;
                                    int v123 = 40;
                                    int v1151 = 1;
                                    switch (statnum - 906) {
                                        case 7: {
                                            v123 = 160;
                                            break;
                                        }
                                        case 8: {
                                            v1151 = -1;
                                            v123 = -200;
                                        }
                                    }
                                    if (v123 > 0 && (flags & 2) != 0) break;
                                    if (Globals.PlayerList[player].invisibility == 0 || v123 > 0) {
                                        Globals.PlayerList[player].HealthAmount += v123;
                                        healthPickuped = v123;
                                        if (Globals.PlayerList[player].HealthAmount <= 800) {
                                            if (Globals.PlayerList[player].HealthAmount <= 0) {
                                                nSnd = -1;
                                                Seq.StartDeathSeq(player, 0);
                                            }
                                        } else {
                                            Globals.PlayerList[player].HealthAmount = 800;
                                        }
                                    }
                                    if (player == Globals.nLocalPlayer) {
                                        View.SetHealthFrame(v1151);
                                    }
                                    if (statBase == 12) {
                                        s231.setHitag(0);
                                        s231.setPicnum(s231.getPicnum() + 1);
                                        Main.engine.changespritestat(v231, 0);
                                        pickFlag = 2;
                                        break;
                                    }
                                    if (statBase == 14) {
                                        tintRed = tintGreen;
                                        tintGreen = 0;
                                        nSnd = 22;
                                    } else {
                                        nSnd = 21;
                                    }
                                    pickFlag = 3;
                                    break;
                                }
                                case 11: {
                                    Globals.PlayerList[player].AirAmount = Gameutils.BClipHigh(Globals.PlayerList[player].AirAmount + 10, 100);
                                    View.SetAirFrame();
                                    if (Globals.nBreathTimer[player] < 89) {
                                        Sound.D3PlayFX(Sound.StaticSound[13], spr);
                                    }
                                    Globals.nBreathTimer[player] = 90;
                                    break;
                                }
                                case 12: 
                                case 13: 
                                case 14: 
                                case 15: 
                                case 16: 
                                case 17: {
                                    int v130 = 0;
                                    switch (statnum - 906) {
                                        case 13: {
                                            v130 = 1;
                                            break;
                                        }
                                        case 14: {
                                            v130 = 3;
                                            break;
                                        }
                                        case 15: {
                                            v130 = 4;
                                            break;
                                        }
                                        case 16: {
                                            v130 = 2;
                                            break;
                                        }
                                        case 17: {
                                            v130 = 5;
                                        }
                                    }
                                    if (!Sprites.GrabItem(player, v130)) break;
                                    pickFlag = 3;
                                    break;
                                }
                                case 19: {
                                    nSnd = -1;
                                    if (Globals.nPlayerLives[player] >= 5) break;
                                    int n = player;
                                    Globals.nPlayerLives[n] = Globals.nPlayerLives[n] + 1;
                                    if (player == Globals.nLocalPlayer) {
                                        StatusAnim.BuildStatusAnim(2 * (Globals.nPlayerLives[player] - 1) + 146, 0);
                                    }
                                    tintGreen = 32;
                                    tintRed = 32;
                                    pickFlag = 3;
                                    break;
                                }
                                case 20: 
                                case 22: 
                                case 23: 
                                case 24: 
                                case 26: 
                                case 27: 
                                case 46: 
                                case 47: 
                                case 48: 
                                case 50: 
                                case 51: {
                                    int v251 = 1;
                                    int v136 = 0;
                                    switch (statnum - 906) {
                                        case 20: {
                                            v251 = 0;
                                            break;
                                        }
                                        case 22: 
                                        case 46: {
                                            v136 = 6;
                                            break;
                                        }
                                        case 23: 
                                        case 47: {
                                            v136 = 24;
                                            v251 = 2;
                                            break;
                                        }
                                        case 24: 
                                        case 48: {
                                            v136 = 100;
                                            v251 = 3;
                                            break;
                                        }
                                        case 26: 
                                        case 50: {
                                            v136 = 20;
                                            v251 = 5;
                                            break;
                                        }
                                        case 27: 
                                        case 51: {
                                            v251 = 6;
                                            v136 = 2;
                                        }
                                    }
                                    int v261 = 1 << v251;
                                    if ((Globals.nPlayerWeapons[player] & 1 << v251) != 0) {
                                        if (Globals.levelnum > 20) {
                                            Weapons.AddAmmo(player, Weapons.weaponInfo[1].field_1A, v136);
                                        }
                                    } else {
                                        Weapons.SetNewWeaponIfBetter(player, v251);
                                        int n = player;
                                        Globals.nPlayerWeapons[n] = Globals.nPlayerWeapons[n] | v261;
                                        Weapons.AddAmmo(player, Weapons.weaponInfo[v251].field_1A, v136);
                                        nSnd = Sound.StaticSound[72];
                                    }
                                    if (v251 == 2) {
                                        Weapons.CheckClip(player);
                                    }
                                    if (statBase <= 50) {
                                        pickFlag = 3;
                                        break;
                                    }
                                    s231.setCstat(32768);
                                    Sprites.DestroyItemAnim(v231);
                                    pickFlag = 2;
                                    break;
                                }
                                case 31: {
                                    if (!Weapons.AddAmmo(player, 5, 1)) break;
                                    nSnd = Sound.StaticSound[69];
                                    pickFlag = 3;
                                    break;
                                }
                                case 32: {
                                    if (!Weapons.AddAmmo(player, 6, s231.getHitag())) break;
                                    nSnd = Sound.StaticSound[69];
                                    pickFlag = 3;
                                    break;
                                }
                                case 39: 
                                case 40: 
                                case 41: 
                                case 42: {
                                    int v140 = 0;
                                    switch (statnum - 906) {
                                        case 39: {
                                            break;
                                        }
                                        case 40: {
                                            v140 = 1;
                                            break;
                                        }
                                        case 41: {
                                            v140 = 2;
                                            break;
                                        }
                                        case 42: {
                                            v140 = 3;
                                        }
                                    }
                                    nSnd = -1;
                                    int v115 = v140 != 0 ? 4096 << v140 : 4096;
                                    if ((Globals.PlayerList[player].KeysBitMask & v115) != 0) break;
                                    if (player == Globals.nLocalPlayer) {
                                        StatusAnim.BuildStatusAnim(2 * v140 + 36, Globals.nLocalPlayer ^ player);
                                    }
                                    Globals.PlayerList[player].KeysBitMask |= v115;
                                    if (Mmulti.numplayers <= 1) {
                                        pickFlag = 3;
                                        break;
                                    }
                                    pickFlag = 2;
                                    break;
                                }
                                case 43: 
                                case 44: {
                                    if (Globals.PlayerList[player].MagicAmount >= 1000) break;
                                    nSnd = Sound.StaticSound[67];
                                    Globals.PlayerList[player].MagicAmount = Gameutils.BClipHigh(Globals.PlayerList[player].MagicAmount + 100, 1000);
                                    if (player == Globals.nLocalPlayer) {
                                        View.SetMagicFrame();
                                    }
                                    pickFlag = 3;
                                    magicPickuped = true;
                                    break;
                                }
                                case 53: {
                                    if (player == Globals.nLocalPlayer) {
                                        short v144 = s231.getOwner();
                                        ++Anim.AnimList[v144].nAction;
                                        short s2 = v144;
                                        Anim.AnimFlags[s2] = (byte)(Anim.AnimFlags[s2] & 0xFFFFFFEF);
                                        Anim.AnimList[v144].nSeq = 0;
                                        Main.engine.changespritestat(v231, 899);
                                    }
                                    Player.SetSavePoint(player, pSprite.getX(), pSprite.getY(), pSprite.getZ(), pSprite.getSectnum(), pSprite.getAng());
                                    break;
                                }
                                case 54: {
                                    if (!DemoScreen.isDemoPlaying()) {
                                        Map.FinishLevel();
                                    }
                                    Sprites.DestroyItemAnim(v231);
                                    Main.engine.mydeletesprite(v231);
                                }
                            }
                            if ((pickFlag & 1) != 0) {
                                if (Globals.levelnum <= 20 || statBase == 25 || statBase == 50) {
                                    Sprites.DestroyItemAnim(v231);
                                    Main.engine.mydeletesprite(v231);
                                } else {
                                    Object.StartRegenerate(v231);
                                }
                            }
                            if ((pickFlag & 2) != 0 && player == Globals.nLocalPlayer) {
                                if (Globals.nItemText[statBase] > -1) {
                                    String message = Player.getPickupString(statBase, magicPickuped, healthPickuped);
                                    View.StatusMessage(400, message, player);
                                }
                                Palette.TintPalette(tintRed, tintGreen, 0);
                                if (nSnd > -1) {
                                    Sound.PlayLocalSound(nSnd, 0);
                                }
                            }
                        }
                    }
                    if (Globals.bTouchFloor[0] && (sec = Main.boardService.getSector(pSprite.getSectnum())) != null && sec.getLotag() > 0) {
                        RunList.SignalRun(sec.getLotag() - 1, 0x50000 | player);
                    }
                    if (osectnum != pSprite.getSectnum()) {
                        Sector sec6;
                        Sector osec = Main.boardService.getSector(osectnum);
                        if (osec != null && osec.getLotag() > 0) {
                            RunList.SignalRun(osec.getLotag() - 1, 0x70000 | player);
                        }
                        if ((sec6 = Main.boardService.getSector(pSprite.getSectnum())) != null && sec6.getLotag() > 0) {
                            RunList.SignalRun(sec6.getLotag() - 1, 0x60000 | player);
                        }
                    }
                    if (Globals.PlayerList[player].mummified != 0) {
                        if ((Globals.sPlayerInput[player].bits & 8) != 0) {
                            Weapons.FireWeapon(player);
                        }
                        if (anim != 15) {
                            next_anim = Globals.totalvel[player] <= 1 ? 13 : 14;
                        }
                    } else {
                        if ((Globals.sPlayerInput[player].bits & 4) != 0) {
                            Sector nearSector;
                            Wall nearWall = Main.boardService.getWall(Engine.neartag.tagwall);
                            if (nearWall != null && nearWall.getLotag() > 0) {
                                RunList.SignalRun(nearWall.getLotag() - 1, 0x40000 | player);
                            }
                            if ((nearSector = Main.boardService.getSector(Engine.neartag.tagsector)) != null && nearSector.getLotag() > 0) {
                                RunList.SignalRun(nearSector.getLotag() - 1, 0x40000 | player);
                            }
                        }
                        if ((Globals.sPlayerInput[player].bits & 8) != 0) {
                            Weapons.FireWeapon(player);
                        } else {
                            Weapons.StopFiringWeapon(player);
                        }
                        sec = Main.boardService.getSector(pSprite.getSectnum());
                        if (sec != null && Globals.nStandHeight > sec.getFloorz() - sec.getCeilingz()) {
                            v233 = true;
                        }
                        if ((Globals.sPlayerInput[player].bits & 1) != 0) {
                            Globals.PlayerList[player].crouch_toggle = false;
                            if (bUnderwater) {
                                pSprite.setZvel(-2048);
                                next_anim = 10;
                            } else if (Globals.bTouchFloor[0] && (anim < 6 || anim > 8)) {
                                pSprite.setZvel(-3584);
                                next_anim = 3;
                            }
                        } else if ((Globals.sPlayerInput[player].bits & 0x10) != 0) {
                            if (bUnderwater) {
                                pSprite.setZvel(2048);
                                next_anim = 10;
                            } else {
                                int elev = Globals.PlayerList[player].eyelevel;
                                if (elev < -8320) {
                                    Globals.PlayerList[player].eyelevel = (-8320 - elev >> 1) + elev;
                                }
                                next_anim = Globals.totalvel[player] >= 1 ? 7 : 6;
                            }
                        } else {
                            if (Globals.PlayerList[player].HealthAmount > 0) {
                                Globals.PlayerList[player].eyelevel += nActionEyeLevel[anim] - Globals.PlayerList[player].eyelevel >> 1;
                                next_anim = bUnderwater ? (Globals.totalvel[player] <= 1 ? 9 : 10) : (v233 ? (Globals.totalvel[player] >= 1 ? 7 : 6) : (Globals.totalvel[player] <= 1 ? 0 : (Globals.totalvel[player] <= 30 ? 2 : 1)));
                            }
                            if (!v233 && (Globals.sPlayerInput[player].bits & 8) != 0) {
                                if (bUnderwater) {
                                    next_anim = 11;
                                } else if (next_anim != 2 && next_anim != 1) {
                                    next_anim = 5;
                                }
                            }
                        }
                        int newWeapon = (Globals.sPlayerInput[player].bits >> 13 & 0xF) - 1;
                        if (newWeapon != -1) {
                            switch (newWeapon) {
                                case 9: {
                                    if ((1 << Globals.PlayerList[player].lastUsedWeapon & Globals.nPlayerWeapons[player]) == 0) break;
                                    Weapons.SetNewWeapon(player, Globals.PlayerList[player].lastUsedWeapon);
                                    break;
                                }
                                case 7: 
                                case 8: {
                                    int weap = Weapons.WeaponChange(player, newWeapon == 8);
                                    Weapons.SetNewWeapon(player, weap);
                                    break;
                                }
                                default: {
                                    if ((1 << newWeapon & Globals.nPlayerWeapons[player]) == 0) break;
                                    Weapons.SetNewWeapon(player, newWeapon);
                                }
                            }
                        }
                    }
                    if (next_anim != anim && anim != 4) {
                        anim = next_anim;
                        Globals.PlayerList[player].anim_ = next_anim;
                        Globals.PlayerList[player].animCount = 0;
                    }
                    if (player == Globals.nLocalPlayer) {
                        int dVertPan;
                        if ((Globals.sPlayerInput[player].bits & 0x20) != 0) {
                            Globals.bLockPan = true;
                            if (!(Globals.PlayerList[player].horiz >= (float)(Globals.isOriginal() ? 180 : 300))) {
                                Globals.PlayerList[player].horiz += 4.0f;
                            }
                            Globals.nDestVertPan[player] = Globals.PlayerList[player].horiz;
                        } else if ((Globals.sPlayerInput[player].bits & 0x40) != 0) {
                            Globals.bLockPan = true;
                            Globals.bPlayerPan = true;
                            float f = Globals.PlayerList[player].horiz;
                            int n = Globals.isOriginal() ? 0 : -130;
                            if (f > (float)(n + 4)) {
                                Globals.PlayerList[player].horiz -= 4.0f;
                            }
                            Globals.nDestVertPan[player] = Globals.PlayerList[player].horiz;
                        } else if ((Globals.sPlayerInput[player].bits & 0x40000) != 0) {
                            Globals.bLockPan = false;
                            Globals.bPlayerPan = false;
                            float f = Globals.PlayerList[player].horiz;
                            int n = Globals.isOriginal() ? 0 : -130;
                            if (f > (float)(n + 4)) {
                                Globals.PlayerList[player].horiz -= 4.0f;
                            }
                            Globals.nDestVertPan[player] = Globals.PlayerList[player].horiz;
                        } else if ((Globals.sPlayerInput[player].bits & 0x20000) != 0) {
                            Globals.bLockPan = false;
                            Globals.bPlayerPan = false;
                            if (!(Globals.PlayerList[player].horiz >= (float)(Globals.isOriginal() ? 180 : 300))) {
                                Globals.PlayerList[player].horiz += 4.0f;
                            }
                            Globals.nDestVertPan[player] = Globals.PlayerList[player].horiz;
                        } else if ((Globals.sPlayerInput[player].bits & 0x1000) != 0) {
                            Globals.bLockPan = false;
                            Globals.bPlayerPan = false;
                            Globals.nDestVertPan[player] = 92.0f;
                        }
                        if (Globals.sPlayerInput[player].horiz != 0.0f) {
                            Globals.bLockPan = true;
                            Globals.bPlayerPan = true;
                            Globals.PlayerList[player].horiz = Globals.isOriginal() ? Gameutils.BClipRange(Globals.PlayerList[player].horiz + Globals.sPlayerInput[player].horiz, 0.0f, 180.0f) : Gameutils.BClipRange(Globals.PlayerList[player].horiz + Globals.sPlayerInput[player].horiz, -130.0f, 300.0f);
                            Globals.nDestVertPan[player] = Globals.PlayerList[player].horiz;
                        }
                        Globals.sPlayerInput[player].nWeaponAim = (short)Globals.PlayerList[player].horiz;
                        if (Globals.totalvel[player] > 20) {
                            Globals.bPlayerPan = false;
                        }
                        if ((dVertPan = (int)(Globals.nDestVertPan[player] - Globals.PlayerList[player].horiz)) != 0) {
                            int val = dVertPan / 4;
                            if (Pragmas.klabs(val) >= 4) {
                                if (val >= 4) {
                                    Globals.PlayerList[player].horiz += 4.0f;
                                } else if (val <= -4) {
                                    Globals.PlayerList[player].horiz -= 4.0f;
                                }
                            } else {
                                Globals.PlayerList[player].horiz += (float)dVertPan / 2.0f;
                            }
                        }
                    }
                }
                if (player == Globals.nLocalPlayer) {
                    nLocalEyeSect = Globals.nPlayerViewSect[Globals.nLocalPlayer];
                    Sound.CheckAmbience(nLocalEyeSect);
                }
                int seqBase = Player.ActionSeq[anim].seq + Seq.SeqOffsets[Globals.PlayerList[player].seq];
                Seq.MoveSequence(spr, seqBase, Globals.PlayerList[player].animCount);
                ++Globals.PlayerList[player].animCount;
                if (Globals.PlayerList[player].animCount >= Seq.SeqSize[seqBase]) {
                    Globals.PlayerList[player].animCount = 0;
                    switch (Globals.PlayerList[player].anim_) {
                        case 3: {
                            Globals.PlayerList[player].animCount = Seq.SeqSize[seqBase] - 1;
                            break;
                        }
                        case 4: {
                            Globals.PlayerList[player].anim_ = 0;
                            break;
                        }
                        case 16: {
                            Globals.PlayerList[player].animCount = Seq.SeqSize[seqBase] - 1;
                            Sector sec7 = Main.boardService.getSector(pSprite.getSectnum());
                            if (sec7 != null && pSprite.getZ() < sec7.getFloorz()) {
                                pSprite.setZ(pSprite.getZ() + 256);
                            }
                            if (Random.RandomSize(5) != 0) break;
                            int[] out = Sprites.WheresMyMouth(player);
                            Anim.BuildAnim(-1, 71, 0, out[0], out[1], pSprite.getZ() + 3840, out[3], 75, -128);
                            break;
                        }
                        case 17: {
                            Globals.PlayerList[player].anim_ = 18;
                            break;
                        }
                        case 19: {
                            pSprite.setCstat(pSprite.getCstat() | 0x8000);
                            Globals.PlayerList[player].anim_ = 20;
                        }
                    }
                }
                if (player == Globals.nLocalPlayer) {
                    Globals.initx = pSprite.getX();
                    Globals.inity = pSprite.getY();
                    Globals.initz = pSprite.getZ();
                    Globals.initsect = pSprite.getSectnum();
                    Globals.inita = pSprite.getAng();
                }
                if (Globals.PlayerList[player].HealthAmount == 0) {
                    Globals.nYDamage[player] = 0;
                    Globals.nXDamage[player] = 0;
                    if (Globals.PlayerList[player].eyelevel >= -2816) {
                        Globals.PlayerList[player].eyelevel = -2816;
                        Globals.dVertPan[player] = 0;
                    } else if (Globals.PlayerList[player].horiz >= 92.0f) {
                        Globals.PlayerList[player].horiz += (float)Globals.dVertPan[player];
                        if (Globals.PlayerList[player].horiz < 200.0f) {
                            if (Globals.PlayerList[player].horiz <= 92.0f && (Globals.SectFlag[pSprite.getSectnum()] & 0x2000) == 0) {
                                Weapons.SetNewWeapon(player, Globals.nDeathType[player] + 8);
                            }
                        } else {
                            Globals.PlayerList[player].horiz = 199.0f;
                        }
                        int n = player;
                        Globals.dVertPan[n] = Globals.dVertPan[n] - 1;
                    } else {
                        Globals.PlayerList[player].horiz = 91.0f;
                        Globals.PlayerList[player].eyelevel -= Globals.dVertPan[player] << 8;
                    }
                }
                pDSprite.setX(pSprite.getX());
                pDSprite.setY(pSprite.getY());
                pDSprite.setZ(pSprite.getZ());
                if (Globals.SectAbove[pSprite.getSectnum()] <= -1) {
                    pDSprite.setCstat(32768);
                } else {
                    pDSprite.setAng(pSprite.getAng());
                    Main.engine.mychangespritesect(dspr, Globals.SectAbove[pSprite.getSectnum()]);
                    pDSprite.setCstat(257);
                }
                Weapons.MoveWeapons(player);
                return;
            }
            case 589824: {
                Renderer renderer = Main.game.getRenderer();
                TSprite tsp = (TSprite)renderer.getRenderedSprites().get((short)(nStack & 0xFFFF));
                Seq.PlotSequence(tsp, Player.ActionSeq[anim].seq + Seq.SeqOffsets[Globals.PlayerList[player].seq], Globals.PlayerList[player].animCount, Player.ActionSeq[anim].a2 ? 1 : 0);
                return;
            }
            case 524288: {
                if (a2 == 0) {
                    return;
                }
                v229 = (short)(nStack & 0xFFFF);
                break;
            }
            case 655360: {
                if (Globals.PlayerList[player].HealthAmount <= 0) break;
                a2 = Sprites.CheckRadialDamage(spr);
                if (a2 == 0) {
                    return;
                }
                v229 = (short)Globals.nRadialOwner;
                break;
            }
            default: {
                return;
            }
        }
        if (Globals.PlayerList[player].HealthAmount != 0) {
            if (Globals.PlayerList[player].invisibility == 0) {
                Globals.PlayerList[player].HealthAmount -= a2;
                if (player == Globals.nLocalPlayer) {
                    Palette.TintPalette(a2 >> 2, 0, 0);
                    View.SetHealthFrame(-1);
                }
            }
            if (Globals.PlayerList[player].HealthAmount > 0) {
                if ((a2 > 40 || (Globals.totalmoves & 0xF) < 2) && Globals.PlayerList[player].invisibility == 0) {
                    if ((Globals.SectFlag[pSprite.getSectnum()] & 0x2000) != 0) {
                        if (anim != 12) {
                            Globals.PlayerList[player].animCount = 0;
                            Globals.PlayerList[player].anim_ = 12;
                        }
                    } else if (anim != 4) {
                        Globals.PlayerList[player].animCount = 0;
                        Globals.PlayerList[player].anim_ = 4;
                        if (v229 > -1) {
                            int n = player;
                            Globals.nPlayerSwear[n] = Globals.nPlayerSwear[n] - 1;
                            if (Globals.nPlayerSwear[player] <= 0) {
                                Sound.D3PlayFX(Sound.StaticSound[52], dspr);
                                Globals.nPlayerSwear[player] = Random.RandomSize(3) + 4;
                            }
                        }
                    }
                }
            } else {
                int deathType;
                if (v229 < 0) {
                    int n = player;
                    Globals.nPlayerScore[n] = Globals.nPlayerScore[n] - 1;
                }
                if ((nStack & 0x7F0000) == 655360) {
                    for (int i = 122; i <= 131; ++i) {
                        Sprites.BuildCreatureChunk(spr, Seq.GetSeqPicnum(25, i, 0));
                    }
                    deathType = 1;
                } else {
                    deathType = 0;
                }
                Seq.StartDeathSeq(player, deathType);
            }
        }
    }

    private static String getPickupString(int statBase, boolean magicPickuped, int healthPickuped) {
        String message = Globals.gString[Globals.nItemText[statBase] + Globals.nItemTextIndex];
        if (magicPickuped) {
            message = message + " +10%";
        } else if (healthPickuped != -65536) {
            message = healthPickuped > 0 ? message + " +" : message + " ";
            message = message + healthPickuped * 100 / 800 + "%";
        }
        return message;
    }

    public static void SetCounter(int value) {
        if (value <= 999) {
            if (value < 0) {
                value = 0;
            }
        } else {
            value = 999;
        }
        Globals.nCounterDest = value;
    }

    public static void SetPlayerMummified(int nPlayer, int mummified) {
        Globals.PlayerList[nPlayer].mummified = mummified;
        int nSprite = Globals.PlayerList[nPlayer].spriteId;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite != null) {
            pSprite.setXvel(0);
            pSprite.setYvel(0);
        }
        if (mummified != 0) {
            Globals.PlayerList[nPlayer].anim_ = 13;
            Globals.PlayerList[nPlayer].seq = 10;
        } else {
            Globals.PlayerList[nPlayer].anim_ = 0;
            Globals.PlayerList[nPlayer].seq = 25;
        }
        Globals.PlayerList[nPlayer].animCount = 0;
    }

    public static void SetCounterImmediate(int a1) {
        Player.SetCounter(a1);
        Globals.nCounter = Globals.nCounterDest;
        Player.SetCounterDigits();
    }

    public static void SetCounterDigits() {
        View.nDigit[2] = 3 * (Globals.nCounter / 100 % 10);
        View.nDigit[1] = 3 * (Globals.nCounter / 10 % 10);
        View.nDigit[0] = 3 * (Globals.nCounter % 10);
    }

    public static void UseItem(int nPlayer, int nItem) {
        switch (nItem) {
            case 4: {
                Player.UseEye(nPlayer);
                break;
            }
            case 5: {
                Player.UseMask(nPlayer);
                break;
            }
            case 0: {
                Player.UseHeart(nPlayer);
                break;
            }
            case 2: {
                Light.UseTorch(nPlayer);
                break;
            }
            case 1: {
                Player.UseScarab(nPlayer);
                break;
            }
            case 3: {
                Player.UseHand(nPlayer);
            }
        }
        int n = nItem;
        byte by = (byte)(Globals.PlayerList[nPlayer].ItemsAmount[n] - 1);
        Globals.PlayerList[nPlayer].ItemsAmount[n] = by;
        byte amount = by;
        if (nPlayer == Globals.nLocalPlayer) {
            StatusAnim.BuildStatusAnim(2 * amount + 156, Globals.nLocalPlayer ^ nPlayer);
        }
        int i = nItem;
        if (amount == 0) {
            for (i = 0; i < 6 && Globals.PlayerList[nPlayer].ItemsAmount[i] <= 0; ++i) {
            }
            if (i == 6) {
                i = -1;
            }
        }
        Globals.PlayerList[nPlayer].MagicAmount -= Globals.nItemMagic[nItem];
        Player.SetPlayerItem(nPlayer, i);
        if (nPlayer == Globals.nLocalPlayer) {
            View.SetMagicFrame();
        }
    }

    public static void UseEye(int nPlayer) {
        int nSprite = Globals.PlayerList[nPlayer].spriteId;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        if (Globals.nPlayerInvisible[nPlayer] >= 0) {
            Globals.nPlayerInvisible[nPlayer] = 900;
        }
        pSprite.setCstat(pSprite.getCstat() | 0x8000);
        int nFloorSpr = Globals.nPlayerFloorSprite[nPlayer];
        Sprite pFloorSpr = Main.boardService.getSprite(nFloorSpr);
        if (pFloorSpr != null) {
            pFloorSpr.setCstat(pFloorSpr.getCstat() | 0x8000);
        }
        if (nPlayer == Globals.nLocalPlayer) {
            Player.ItemFlash();
            Sound.D3PlayFX(Sound.StaticSound[31], nSprite);
        }
    }

    public static void UseMask(int nPlayer) {
        Globals.PlayerList[nPlayer].AirMaskAmount = 1350;
        Globals.PlayerList[nPlayer].AirAmount = 100;
        if (nPlayer == Globals.nLocalPlayer) {
            View.SetAirFrame();
            Sound.D3PlayFX(Sound.StaticSound[31], Globals.PlayerList[nPlayer].spriteId);
        }
    }

    public static void UseHeart(int nPlayer) {
        if (Globals.PlayerList[nPlayer].HealthAmount < 800) {
            Globals.PlayerList[nPlayer].HealthAmount = 800;
        }
        if (nPlayer == Globals.nLocalPlayer) {
            Player.ItemFlash();
            View.SetHealthFrame(1);
            Sound.D3PlayFX(Sound.StaticSound[31], Globals.PlayerList[nPlayer].spriteId);
        }
    }

    public static void UseScarab(int nPlayer) {
        if (Globals.PlayerList[nPlayer].invisibility < 900) {
            Globals.PlayerList[nPlayer].invisibility = 900;
        }
        if (nPlayer == Globals.nLocalPlayer) {
            Player.ItemFlash();
            Sound.D3PlayFX(Sound.StaticSound[31], Globals.PlayerList[nPlayer].spriteId);
        }
    }

    public static void UseHand(int nPlayer) {
        Globals.nPlayerDouble[nPlayer] = 1350;
        if (nPlayer == Globals.nLocalPlayer) {
            Player.ItemFlash();
            Sound.D3PlayFX(Sound.StaticSound[31], Globals.PlayerList[nPlayer].spriteId);
        }
    }

    public static void UseCurItem(int nPlayer, int nItem) {
        if (nItem >= 0 && Globals.PlayerList[nPlayer].ItemsAmount[nItem] > 0 && Globals.nItemMagic[nItem] <= Globals.PlayerList[nPlayer].MagicAmount) {
            Globals.sPlayerInput[nPlayer].field_F = (byte)nItem;
            System.err.println("Use item " + nItem);
        }
    }

    public static void SetNextItem(int a1) {
        int nNextItem;
        int nItem = Globals.nPlayerItem[a1];
        for (nNextItem = 6; nNextItem > 0; --nNextItem) {
            if (++nItem == 6) {
                nItem = 0;
            }
            if (Globals.PlayerList[a1].ItemsAmount[nItem] != 0) break;
        }
        if (nNextItem > 0) {
            Player.SetPlayerItem(a1, nItem);
        }
    }

    public static void SetPrevItem(int a1) {
        int nNextItem;
        int nItem = Globals.nPlayerItem[a1];
        if (nItem == -1) {
            return;
        }
        for (nNextItem = 6; nNextItem > 0; --nNextItem) {
            if (--nItem < 0) {
                nItem = 5;
            }
            if (Globals.PlayerList[a1].ItemsAmount[nItem] != 0) break;
        }
        if (nNextItem > 0) {
            Player.SetPlayerItem(a1, nItem);
        }
    }

    public static void ItemFlash() {
        Palette.TintPalette(4, 4, 4);
    }

    public static void FillItems(int nPlayer) {
        for (int i = 0; i < 6; ++i) {
            Globals.PlayerList[nPlayer].ItemsAmount[i] = 5;
        }
        Globals.PlayerList[nPlayer].MagicAmount = 1000;
        if (nPlayer == Globals.nLocalPlayer) {
            Player.ItemFlash();
            View.SetMagicFrame();
        }
        if (Globals.nPlayerItem[nPlayer] == -1) {
            Player.SetPlayerItem(nPlayer, 0);
        }
        View.StatusMessage(750, "All items loaded for player " + nPlayer, Globals.nLocalPlayer);
    }

    public static void PlayAlert(String message, int nPlayer) {
        View.StatusMessage(300, message, nPlayer);
        Sound.PlayLocalSound(Sound.StaticSound[63], 0);
    }

    static {
        sPlayerSave = new PlayerSave[8];
    }

    public static class Action {
        public final int seq;
        final boolean a2;

        public Action(int seq, boolean a2) {
            this.seq = seq;
            this.a2 = a2;
        }
    }
}

