/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Screens;

import ru.m210projects.Build.Pattern.ScreenAdapters.SkippableAdapter;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.filehandle.art.ArtFile;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;
import ru.m210projects.Powerslave.Cinema;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Palette;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.Screens.GameScreen;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;

public class CinemaScreen
extends SkippableAdapter {
    private static final int CINEMA_TILE = 3623;
    private DynamicArtEntry cinemaEntry = ArtFile.DUMMY_ART_FILE;
    private final byte[] cinemaData;
    private final Main game;
    private int num;
    private int cinematile;
    private int backgroundCol;
    private int cinematext;
    private long time;
    private int lastScene;
    private int nLastSceneTextIndex;
    private int nCurrentSceneTextIndex;
    private sceneStatus lastStatus;
    private int openClock;
    private int lx;
    private int ly;
    private char[] gMessage;
    private int symPosX;
    private int symPosY;
    private int symCur;
    private int creditsShade;
    private long creditsTime;
    private boolean anyKeyPressed = false;

    public CinemaScreen(Main game) {
        super(game);
        this.game = game;
        ArtEntry src = this.engine.getTile(3623);
        this.cinemaData = src.getBytes();
    }

    @Override
    public void show() {
        byte[] palette = this.engine.getPaletteManager().getBasePalette();
        this.lastScene = 0;
        this.cinematext = -1;
        ArtEntry src = this.engine.getTile(3623);
        if (!this.cinemaEntry.exists()) {
            this.cinemaEntry = this.engine.allocatepermanenttile(src);
        }
        switch (this.num) {
            case 1: {
                this.cinematile = 3454;
                this.cinematext = 4;
                break;
            }
            case 2: {
                this.cinematile = 3452;
                this.cinematext = 0;
                break;
            }
            case 3: {
                this.cinematile = 3449;
                this.cinematext = 2;
                break;
            }
            case 4: {
                this.cinematile = 3445;
                this.cinematext = 7;
                break;
            }
            case 5: {
                this.cinematile = 3451;
                this.cinematext = 3;
                break;
            }
            case 6: {
                this.cinematile = 3448;
                this.cinematext = 8;
                break;
            }
            case 7: {
                this.cinematile = 3446;
                this.cinematext = 6;
                break;
            }
            case 8: {
                this.lastScene = 1;
                this.engine.setbrightness(Main.cfg.getPaletteGamma(), palette);
                this.backgroundCol = 96;
                break;
            }
            case 9: {
                this.lastScene = 2;
                this.engine.setbrightness(Main.cfg.getPaletteGamma(), palette);
                this.backgroundCol = 96;
            }
        }
        Sound.StopAllSounds();
        if (this.lastScene == 0) {
            if (this.cinematext != -1) {
                Sound.playCDtrack(this.cinematext + 2, false);
            }
            Palette.LoadCinemaPalette(this.num);
            this.engine.setbrightness(Main.cfg.getPaletteGamma(), Palette.cinemapal);
            this.backgroundCol = 0;
            int k = 255;
            for (int i = 0; i < 256; i += 3) {
                int j = (Palette.cinemapal[3 * i] & 0xFF) + (Palette.cinemapal[3 * i + 1] & 0xFF) + (Palette.cinemapal[3 * i + 2] & 0xFF);
                if (j >= k) continue;
                k = j;
                this.backgroundCol = i;
            }
            Cinema.ReadyCinemaText(this.cinematext);
            this.time = System.currentTimeMillis();
        } else if (this.lastScene == 1) {
            Sound.playCDtrack(19, true);
            this.nCurrentSceneTextIndex = this.nLastSceneTextIndex = this.game.FindGString("LASTLEVEL");
            Sound.PlayLocalSound(Sound.StaticSound[75], 0);
            if (this.cinemaEntry.exists()) {
                this.cinemaEntry.copyData(this.cinemaData);
            }
            this.lastStatus = sceneStatus.Open;
            this.openClock = this.engine.getTotalClock() + 240;
            this.lx = 12;
            this.ly = 16;
            this.time = System.currentTimeMillis();
        } else if (this.lastScene == 2) {
            Sound.playCDtrack(19, false);
            this.nCurrentSceneTextIndex = this.nLastSceneTextIndex = this.game.FindGString("CREDITS");
            this.NextCredit();
        }
        this.game.getProcessor().resetPollingStates();
    }

    @Override
    public void hide() {
        Sound.StopAllSounds();
        Sound.StopMusic();
        byte[] palette = this.engine.getPaletteManager().getBasePalette();
        this.engine.setbrightness(Main.cfg.getPaletteGamma(), palette);
    }

    public CinemaScreen setNum(int num) {
        this.num = num;
        return this;
    }

    @Override
    public void skip() {
        if (this.lastScene != 1) {
            super.skip();
        } else if (this.lastStatus != sceneStatus.Close) {
            Sound.PlayLocalSound(Sound.StaticSound[75], 0);
            this.lastStatus = sceneStatus.Close;
        } else {
            super.skip();
        }
    }

    @Override
    public void draw(float delta) {
        block44: {
            Renderer renderer;
            block43: {
                if (this.game.getProcessor().isKeyJustPressed(-1)) {
                    this.anyKeyPressed();
                }
                renderer = this.game.getRenderer();
                renderer.clearview(this.backgroundCol);
                if (this.lastScene != 0) break block43;
                renderer.rotatesprite(0xA00000, 0x640000, 65536, 0, this.cinematile, 0, 0, 10);
                if (this.cinematext == -1) break block44;
                if (Cinema.nHeight + Cinema.nCrawlY > 0 && System.currentTimeMillis() - this.time >= 120L) {
                    --Cinema.nCrawlY;
                    this.time = System.currentTimeMillis();
                }
                Cinema.AdvanceCinemaText();
                if (Cinema.nHeight + Cinema.nCrawlY > 0 || Sound.MusicPlaying()) break block44;
                this.skip();
                break block44;
            }
            if (this.lastScene == 1) {
                DynamicArtEntry dst = this.cinemaEntry;
                if (!dst.exists()) {
                    this.skip();
                    return;
                }
                switch (this.lastStatus.ordinal()) {
                    case 0: {
                        if (this.engine.getTotalClock() >= this.openClock) {
                            this.lastStatus = sceneStatus.Screen;
                            if (this.cinemaEntry.exists()) {
                                this.cinemaEntry.copyData(this.cinemaData);
                            }
                            this.NextScreen();
                            break;
                        }
                        if (System.currentTimeMillis() - this.time >= 15L) {
                            if (this.ly < 116) {
                                this.ly += 20;
                            } else if (this.lx < 192) {
                                this.lx += 20;
                            }
                            this.time = System.currentTimeMillis();
                        }
                        this.DoStatic(dst, this.lx, this.ly);
                        break;
                    }
                    case 1: {
                        if (this.lx == 12 && this.ly == 16) {
                            this.skip();
                            break;
                        }
                        if (System.currentTimeMillis() - this.time >= 15L) {
                            if (this.lx > 20) {
                                this.lx -= 20;
                            } else if (this.ly > 20) {
                                this.ly -= 20;
                            }
                            this.time = System.currentTimeMillis();
                        }
                        if (this.cinemaEntry.exists()) {
                            this.cinemaEntry.copyData(this.cinemaData);
                        }
                        this.DoStatic(dst, this.lx, this.ly);
                        break;
                    }
                    case 2: {
                        if (System.currentTimeMillis() - this.time >= 40L) {
                            if (this.symCur < this.gMessage.length) {
                                if (this.anyKeyPressed) {
                                    while (this.nLastSceneTextIndex - this.nCurrentSceneTextIndex >= 1) {
                                        while (this.symCur < this.gMessage.length) {
                                            this.symPosX += this.CopyCharToBitmap(this.gMessage[this.symCur++], dst, this.symPosX, this.symPosY);
                                        }
                                        this.NextLine();
                                    }
                                    --this.nCurrentSceneTextIndex;
                                    this.anyKeyPressed = false;
                                } else {
                                    char sym;
                                    if ((sym = this.gMessage[this.symCur++]) != ' ') {
                                        Sound.PlayLocalSound(Sound.StaticSound[71], 0);
                                    }
                                    this.symPosX += this.CopyCharToBitmap(sym, dst, this.symPosX, this.symPosY);
                                }
                                dst.invalidate();
                                this.time = System.currentTimeMillis();
                            } else if (this.nLastSceneTextIndex - this.nCurrentSceneTextIndex <= 1) {
                                if (System.currentTimeMillis() - this.time >= 10000L || this.anyKeyPressed) {
                                    if (this.cinemaEntry.exists()) {
                                        this.cinemaEntry.copyData(this.cinemaData);
                                    }
                                    this.NextScreen();
                                    this.anyKeyPressed = false;
                                }
                                if (this.nCurrentSceneTextIndex == this.nLastSceneTextIndex) {
                                    this.skip();
                                    break;
                                }
                            } else {
                                this.NextLine();
                            }
                        }
                        renderer.rotatesprite(0xA00000, 0x640000, 65536, 0, 3623, 0, 0, 10);
                    }
                }
            } else {
                if (System.currentTimeMillis() - this.time >= 30L) {
                    if (System.currentTimeMillis() - this.creditsTime <= 6000L) {
                        if (this.creditsShade >= 0) {
                            --this.creditsShade;
                        }
                    } else if (this.creditsShade < 64) {
                        ++this.creditsShade;
                    } else if (!this.NextCredit() && !Sound.MusicPlaying()) {
                        this.skip();
                    }
                    this.time = System.currentTimeMillis();
                }
                int y = this.symPosY;
                for (int i = this.nCurrentSceneTextIndex; i < this.nLastSceneTextIndex; ++i) {
                    this.game.getFont(0).drawTextScaled(renderer, this.symPosX, y, Globals.gString[i], 1.0f, this.creditsShade, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
                    y += this.game.getFont(0).getSize() + 1;
                }
            }
        }
    }

    private boolean NextCredit() {
        int index = this.nLastSceneTextIndex + 1;
        if (Globals.gString[index].equals("END")) {
            return false;
        }
        while (!Globals.gString[index].isEmpty()) {
            ++index;
        }
        this.creditsShade = 64;
        this.symPosX = 160;
        this.symPosY = 100 - (this.game.getFont(0).getSize() + 1) * (index - this.nLastSceneTextIndex - 1) / 2;
        this.nCurrentSceneTextIndex = this.nLastSceneTextIndex;
        this.nLastSceneTextIndex = index;
        this.creditsTime = this.time = System.currentTimeMillis();
        return true;
    }

    private void NextScreen() {
        int index = this.nLastSceneTextIndex;
        while (!Globals.gString[index].isEmpty()) {
            ++index;
        }
        this.symCur = 0;
        this.symPosX = 70;
        this.symPosY = 81 - 4 * (index - this.nLastSceneTextIndex);
        this.gMessage = Globals.gString[this.nLastSceneTextIndex].toCharArray();
        this.nCurrentSceneTextIndex = this.nLastSceneTextIndex + 1;
        this.nLastSceneTextIndex = index + 1;
        this.time = System.currentTimeMillis();
    }

    private void NextLine() {
        this.symCur = 0;
        this.symPosX = 70;
        this.symPosY += 8;
        this.gMessage = Globals.gString[this.nCurrentSceneTextIndex].toCharArray();
        ++this.nCurrentSceneTextIndex;
        this.time = System.currentTimeMillis();
    }

    private void DoStatic(DynamicArtEntry pic, int x, int y) {
        Random.RandomLong();
        int x1 = 160 - x / 2;
        int y1 = 81 - y / 2;
        int x2 = x1 + x;
        int y2 = y1 + y;
        int ptr = 200 * x1 + y1;
        byte[] data = pic.getBytes();
        for (int i = x1; i < x2; ++i) {
            int wptr = ptr;
            for (int j = y1; j < y2; ++j) {
                data[wptr++] = (byte)(16 * Random.RandomBit());
            }
            ptr += 200;
        }
        pic.invalidate();
        Renderer renderer = this.game.getRenderer();
        renderer.rotatesprite(0xA00000, 0x640000, 65536, 0, 3623, 0, 0, 10);
    }

    private int CopyCharToBitmap(char ch, DynamicArtEntry dest, int x, int y) {
        if (ch == ' ') {
            return 4;
        }
        int pic = Seq.GetSeqPicnum(69, 0, Character.toUpperCase(ch) - 32) + 102;
        ArtEntry src = this.engine.getTile(pic);
        if (!(src instanceof DynamicArtEntry && src.exists() || (src = this.engine.allocatepermanenttile(src)).exists())) {
            return 4;
        }
        GameScreen.CopyTileToBitmap((DynamicArtEntry)src, dest, x, y);
        return this.engine.getTile(pic).getWidth() + 1;
    }

    public void anyKeyPressed() {
        this.game.getProcessor().prepareNext();
        this.anyKeyPressed = true;
    }

    private static enum sceneStatus {
        Open,
        Close,
        Screen;

    }
}

