/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Screens;

import com.badlogic.gdx.Screen;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.settings.GameKeys;
import ru.m210projects.Powerslave.Config;
import ru.m210projects.Powerslave.Factory.PSMenuHandler;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.LoadSave;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Player;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.Screens.GameScreen;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Type.DemoFile;
import ru.m210projects.Powerslave.Type.Input;
import ru.m210projects.Powerslave.Weapons;

public class DemoScreen
extends GameScreen {
    private static boolean bPlayback = false;
    public int nDemonum = -1;
    public final List<Entry> demofiles = new ArrayList<Entry>();
    public DemoFile demfile;
    private int lockclock;

    public DemoScreen(Main game) {
        super(game);
    }

    @Override
    public void show() {
        LoadSave.lastload = null;
        Sound.playCDtrack(19, true);
    }

    public boolean showDemo(Entry entry) {
        this.demfile = null;
        try (InputStream is = entry.getInputStream();){
            this.demfile = new DemoFile(is);
        }
        catch (Exception e) {
            Console.out.println("Can't play the demo file: " + entry.getName(), OsdColor.RED);
            return false;
        }
        Main.game.nNetMode = BuildGame.NetMode.Single;
        Globals.levelnew = this.demfile.level;
        Globals.nPlayerWeapons[Globals.nLocalPlayer] = this.demfile.weapons;
        Globals.nPlayerClip[Globals.nLocalPlayer] = this.demfile.clip;
        Globals.nPlayerItem[Globals.nLocalPlayer] = this.demfile.items;
        Globals.nPistolClip[Globals.nLocalPlayer] = Math.min(Globals.PlayerList[Globals.nLocalPlayer].AmmosAmount[1], 6);
        Globals.PlayerList[Globals.nLocalPlayer].copy(this.demfile.player);
        Globals.nPlayerLives[Globals.nLocalPlayer] = this.demfile.lives;
        Player.SetPlayerItem(Globals.nLocalPlayer, Globals.nPlayerItem[Globals.nLocalPlayer]);
        Weapons.CheckClip(Globals.nLocalPlayer);
        LoadSave.gClassicMode = true;
        Random.InitRandom();
        Player.InitPlayerInventory(Player.GrabPlayer());
        Globals.PlayerCount = 1;
        if (Globals.levelnew == 0) {
            Globals.gCurrentEpisode = Globals.gTrainingEpisode;
        } else {
            Globals.gCurrentEpisode = Globals.gOriginalEpisode;
            --Globals.levelnew;
        }
        Globals.boardfilename = Main.game.cache.getEntry(Globals.gCurrentEpisode.gMapInfo.get((int)Globals.levelnew).path, true);
        this.loadboard(Globals.boardfilename, null).setTitle("Loading " + Globals.gCurrentEpisode.gMapInfo.get((int)Globals.levelnew).title);
        bPlayback = true;
        Console.out.println("Playing demo " + entry.getName());
        return true;
    }

    @Override
    protected void startboard(Runnable startboard) {
        Main.game.doPrecache(() -> {
            startboard.run();
            this.pNet.ResetTimers();
            this.lockclock = 0;
            this.pNet.ready2send = false;
        });
    }

    @Override
    public boolean gameKeyDown(GameKey gameKey) {
        if (super.gameKeyDown(gameKey)) {
            return true;
        }
        PSMenuHandler menu = Main.game.menu;
        if (GameKeys.Menu_Toggle.equals(gameKey)) {
            menu.mOpen(menu.mMenus[0], -1);
        }
        if (GameKeys.Enlarge_Screen.equals(gameKey)) {
            if (Main.cfg.nScreenSize > 0) {
                Main.cfg.nScreenSize = Gameutils.BClipLow(Main.cfg.nScreenSize - 1, 0);
            }
        } else if (GameKeys.Shrink_Screen.equals(gameKey)) {
            if (Main.cfg.nScreenSize < 2) {
                Main.cfg.nScreenSize = Gameutils.BClipHigh(Main.cfg.nScreenSize + 1, 2);
            }
        } else if (Config.PsKeys.Show_LoadMenu.equals(gameKey)) {
            if (Main.game.nNetMode == BuildGame.NetMode.Single) {
                menu.mOpen(menu.mMenus[3], -1);
            }
        } else if (Config.PsKeys.Quit.equals(gameKey)) {
            menu.mOpen(menu.mMenus[8], -1);
        } else if (Config.PsKeys.Show_SoundSetup.equals(gameKey)) {
            menu.mOpen(menu.mMenus[6], -1);
        } else if (Config.PsKeys.Show_Options.equals(gameKey)) {
            menu.mOpen(menu.mMenus[5], -1);
        } else if (Config.PsKeys.Gamma.equals(gameKey)) {
            menu.mOpen(menu.mMenus[7], -1);
        } else if (Config.PsKeys.Make_Screenshot.equals(gameKey)) {
            this.makeScreenshot();
        }
        return true;
    }

    @Override
    public void render(float delta) {
        this.DemoRender();
        float smoothratio = 65536.0f;
        if (!Main.game.gPaused && ((smoothratio = (float)this.pEngine.getTimer().getsmoothratio(delta)) < 0.0f || smoothratio > 65536.0f)) {
            smoothratio = Gameutils.BClipRange(smoothratio, 0.0f, 65536.0f);
        }
        Main.game.pInt.dointerpolations(smoothratio);
        this.DrawWorld(smoothratio);
        this.DrawHud(smoothratio);
        Main.game.pInt.restoreinterpolations();
        if (this.pMenu.gShowMenu) {
            this.pMenu.mDrawMenu();
        }
        this.PostFrame(this.pNet);
        this.pEngine.nextpage(delta);
    }

    private void DemoRender() {
        this.pNet.ready2send = false;
        if (!Main.game.isCurrentScreen(this)) {
            return;
        }
        if (!Main.game.gPaused && this.demfile != null) {
            while (Main.engine.getTotalClock() >= this.lockclock + 4) {
                Input pInput = this.demfile.ReadPlaybackInput();
                if (pInput == null) {
                    if (!this.showDemo()) {
                        this.onStopPlaying();
                        Main.game.changeScreen(Main.gMenuScreen);
                    }
                    return;
                }
                this.pNet.gFifoInput[this.pNet.gNetFifoHead[Globals.nLocalPlayer] & 0xFF][Globals.nLocalPlayer].Copy(pInput);
                Globals.Ra[Globals.nLocalPlayer].nTarget = Globals.besttarget = pInput.nTarget;
                int n = Globals.nLocalPlayer;
                this.pNet.gNetFifoHead[n] = this.pNet.gNetFifoHead[n] + 1;
                Main.game.pInt.clearinterpolations();
                while (Globals.moveframes > 0) {
                    this.ProcessFrame(this.pNet);
                    this.lockclock += Main.engine.getTimer().getFrameTicks();
                }
                ++this.pNet.gNetFifoTail;
            }
        } else {
            this.lockclock = Main.engine.getTotalClock();
        }
    }

    @Override
    protected void UpdateInputs(BuildNet net) {
        short i = Mmulti.connecthead;
        while (i >= 0) {
            Input src = (Input)net.gFifoInput[net.gNetFifoTail & 0xFF][i];
            Globals.sPlayerInput[i].Copy(src);
            i = Mmulti.connectpoint2[i];
        }
    }

    public boolean showDemo() {
        switch (Main.cfg.gDemoSeq) {
            case 0: {
                return false;
            }
            case 1: {
                if (this.nDemonum < this.demofiles.size() - 1) {
                    ++this.nDemonum;
                    break;
                }
                this.nDemonum = 0;
                break;
            }
            case 2: {
                int nextnum = this.nDemonum;
                if (this.demofiles.size() > 1) {
                    while (nextnum == this.nDemonum) {
                        nextnum = (int)(Math.random() * (double)this.demofiles.size());
                    }
                }
                this.nDemonum = Gameutils.BClipRange(nextnum, 0, this.demofiles.size() - 1);
            }
        }
        if (this.demofiles != null && !this.demofiles.isEmpty()) {
            boolean result = this.showDemo(this.demofiles.get(this.nDemonum));
            if (!result) {
                this.demofiles.remove(this.nDemonum);
                return false;
            }
            return result;
        }
        return false;
    }

    public void demoscan(Directory directory) {
        this.demofiles.clear();
        for (Entry file : directory.getEntries()) {
            if (!file.isExtension("vcr")) continue;
            this.demofiles.add(file);
        }
        if (!this.demofiles.isEmpty()) {
            this.demofiles.sort(Comparator.comparing(Entry::getName));
        }
        Console.out.println("There are " + this.demofiles.size() + " demo(s) in the loop", OsdColor.YELLOW);
    }

    @Override
    public boolean isOriginal() {
        return true;
    }

    public static boolean isDemoScreen(Screen screen) {
        return screen == Main.gDemoScreen;
    }

    public static boolean isDemoPlaying() {
        return bPlayback;
    }

    public void onLoad() {
        this.demfile = null;
        this.onStopPlaying();
    }

    public void onStopPlaying() {
        this.demfile = null;
        bPlayback = false;
    }

    public void onPrepareboard(GameScreen screen) {
        if (screen != this && DemoScreen.isDemoPlaying()) {
            this.onStopPlaying();
        }
    }
}

