/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Screens;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import ru.m210projects.Build.Architecture.common.audio.Source;
import ru.m210projects.Build.CRC32;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.ScreenAdapters.MovieScreen;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Sound;

public class PSMovieScreen
extends MovieScreen {
    private long lastCrc32;
    private int backgroundCol = 0;
    private int frameScale;
    private int frameAngle;
    private int currSub;
    private int oldAngle;
    private int oldScale;
    private final Subtitle[] subs = new Subtitle[]{new Subtitle(new String[]{"During the time of the pharaohs, the city of Karnak", "was a shining example of a civilization that all", "others nations could only hope to emulate"}, 35, 132), new Subtitle(new String[]{"Today Karnak lives on, surrounded by the spirits", "of the past, however something has gone terribly wrong."}, 143, 228), new Subtitle(new String[]{"Unknown forces have seized the city and great", "turmoil is spreading into neighboring lands."}, 242, 302), new Subtitle(new String[]{"World leaders from all parts of the globe have sent", "forces into the Karnak Valley, but none have returned."}, 308, 384), new Subtitle(new String[]{"The great power of this new empire is quickly crushing", "the best forces the human world has to offer."}, 392, 456), new Subtitle(new String[]{"The only known information about this crisis came from", "a Karnak villager, found wandering through the desert", "miles from his home, dazed, dehydrated and close to death."}, 477, 594), new Subtitle(new String[]{"In his final moments among the living, the villager told", "horrifying stories of fierce alien creatures that invaded", "the city, devoured the women and children, and made slaves", "of the men."}, 610, 733), new Subtitle(new String[]{"Many of the unfortunate victims were", "skinned alive or brutally dismembered."}, 741, 794), new Subtitle(new String[]{"Others were subjected to unbearable tortures, ", "injected with strange substances and ", "then mummified while still alive."}, 803, 886), new Subtitle(new String[]{"According to the villager, even the mummified body", "of the great King Ramses was ", "unearthed and taken away."}, 893, 967), new Subtitle(new String[]{"You have been chosen from a group of the best", "operatives in the world to infiltrate Karnak and ", "destroy the threatening forces."}, 979, 1055), new Subtitle(new String[]{"But as your helicopter nears the Karnak Valley, ", "it is shot down. You barely escape with your life."}, 1059, 1128), new Subtitle(new String[]{"With no possible contact to the outside world,"}, 1134, 1164), new Subtitle(new String[]{"you begin your adventure,"}, 1168, 1185), new Subtitle(new String[]{"ready to accomplish your mission..."}, 1190, 1208), new Subtitle(new String[]{"praying to return alive."}, 1215, 1235)};

    public PSMovieScreen(BuildGame game) {
        super(game, 764);
    }

    @Override
    protected MovieScreen.MovieFile GetFile(String file) {
        try {
            this.lastCrc32 = 0L;
            this.currSub = -1;
            this.backgroundCol = 96;
            this.frameScale = 0;
            this.frameAngle = 1536;
            return new LmfFile(file);
        }
        catch (FileNotFoundException fnf) {
            Console.out.println(file + " is not found!", OsdColor.RED);
            return null;
        }
        catch (Exception e) {
            Console.out.println(e.toString(), OsdColor.RED);
            return null;
        }
    }

    @Override
    protected void StopAllSounds() {
        Sound.StopAllSounds();
        Sound.StopMusic();
    }

    @Override
    protected byte[] DoDrawFrame(int num) {
        return this.mvfil.getFrame(num);
    }

    @Override
    protected Font GetFont() {
        return this.game.getFont(0);
    }

    @Override
    protected void DrawEscText(Font font, int pal) {
        Renderer renderer = this.game.getRenderer();
        int shade = 16 + Pragmas.mulscale(16L, EngineUtils.sin(20 * this.engine.getTotalClock() & 0x7FF), 16);
        font.drawTextScaled(renderer, 160, 5, "Press ESC to skip", 1.0f, shade, 251, TextAlign.Center, Transparent.None, ConvertType.Normal, true);
    }

    @Override
    protected void changepalette(byte[] pal) {
        super.changepalette(pal);
        if (pal != null && pal.length == 768) {
            this.backgroundCol = 0;
            int k = 255;
            for (int i = 0; i < 256; i += 3) {
                int j = (pal[3 * i] & 0xFF) + (pal[3 * i + 1] & 0xFF) + (pal[3 * i + 2] & 0xFF);
                if (j >= k) continue;
                k = j;
                this.backgroundCol = i;
            }
        }
    }

    @Override
    protected boolean play() {
        if (this.game.getProcessor().isKeyJustPressed(-1)) {
            this.anyKeyPressed();
        }
        Renderer renderer = this.game.getRenderer();
        if (this.mvfil != null) {
            if (this.LastMS == -1L) {
                this.LastMS = this.engine.getCurrentTimeMillis();
            }
            DynamicArtEntry pic = (DynamicArtEntry)renderer.getTile(this.TILE_MOVIE);
            long ms = this.engine.getCurrentTimeMillis();
            long dt = ms - this.LastMS;
            this.mvtime += dt;
            float tick = this.mvfil.getRate();
            if ((float)this.mvtime >= tick) {
                block16: {
                    try {
                        if (((LmfFile)this.mvfil).readFrame()) {
                            long crc32 = CRC32.getChecksum(((LmfFile)this.mvfil).framebuf);
                            if (this.lastCrc32 != crc32) {
                                pic.copyData(((LmfFile)this.mvfil).framebuf);
                                this.lastCrc32 = crc32;
                            }
                            ++this.frame;
                            int nextSub = this.currSub + 1;
                            if (nextSub < this.subs.length && this.frame >= this.subs[this.currSub + 1].from) {
                                ++this.currSub;
                            }
                            break block16;
                        }
                        return false;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
                this.oldScale = this.frameScale;
                if (this.frameScale < 65536) {
                    this.frameScale += 2048;
                }
                this.oldAngle = this.frameAngle;
                if (this.frameAngle != 0) {
                    this.frameAngle += 16;
                    if (this.frameAngle == 2048) {
                        this.frameAngle = 0;
                    }
                }
                this.mvtime -= (long)tick;
            }
            this.LastMS = ms;
            if (!pic.hasSize()) {
                return false;
            }
            int ang = this.oldAngle;
            int scale = this.oldScale;
            if (this.frameAngle != this.oldAngle && this.frameScale != this.oldScale) {
                int smoothratio = (int)((float)this.mvtime / tick * 65536.0f);
                ang += Pragmas.mulscale((this.frameAngle - this.oldAngle + 1024 & 0x7FF) - 1024, smoothratio, 16);
                scale += Pragmas.mulscale(this.frameScale - this.oldScale, smoothratio, 16);
            }
            renderer.rotatesprite(this.nPosX << 16, this.nPosY << 16, scale, ang, this.TILE_MOVIE, 0, 0, this.nFlags);
            if (Main.cfg.bSubtitles && this.currSub != -1 && this.frame < this.subs[this.currSub].to) {
                String[] text = this.subs[this.currSub].text;
                int pos = 190 - 8 * text.length;
                for (String s : text) {
                    this.game.getFont(0).drawTextScaled(renderer, 160, pos += 8, s, 0.7f, 0, 251, TextAlign.Center, Transparent.None, ConvertType.Normal, true);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void draw(float delta) {
        this.game.getRenderer().clearview(this.backgroundCol);
        super.draw(delta);
    }

    @Override
    protected void close() {
        super.close();
        this.oldAngle = 0;
        this.frameAngle = 0;
        this.frameScale = 0;
        this.oldScale = 0;
    }

    @Override
    public boolean open(String fn) {
        return super.open(fn);
    }

    private static class Subtitle {
        public final String[] text;
        public final int from;
        public final int to;

        public Subtitle(String[] text, int from, int to) {
            this.text = text;
            this.from = from;
            this.to = to;
        }
    }

    private class LmfFile
    implements MovieScreen.MovieFile {
        private final InputStream is;
        private final byte[] framebuf;
        private final ByteBuffer audbuf = ByteBuffer.allocateDirect(4096);

        public LmfFile(String fn) throws Exception {
            Entry entry = PSMovieScreen.this.game.getCache().getEntry(fn, true);
            if (!entry.exists()) {
                throw new FileNotFoundException();
            }
            this.is = entry.getInputStream();
            int size = (int)entry.getSize();
            if (size < 32 || !StreamUtils.readString(this.is, 4).equals("LMF ")) {
                this.is.close();
                throw new Exception("Wrong file format");
            }
            StreamUtils.skip(this.is, 28);
            this.framebuf = new byte[64000];
        }

        @Override
        public byte[] getFrame(int num) {
            return this.framebuf;
        }

        @Override
        public int getWidth() {
            return 200;
        }

        @Override
        public int getHeight() {
            return 320;
        }

        public boolean readFrame() throws IOException {
            if (this.is.available() == 0) {
                return false;
            }
            byte id;
            block6: while ((id = StreamUtils.readByte(this.is)) != 0) {
                int cSize = StreamUtils.readInt(this.is);
                switch (id) {
                    case 1: {
                        byte[] pal = StreamUtils.readBytes(this.is, 768);
                        StreamUtils.readByte(this.is);
                        int i = 0;
                        while (i < 768) {
                            int n = i++;
                            pal[n] = (byte)(pal[n] << 2);
                        }
                        PSMovieScreen.this.changepalette(pal);
                        continue block6;
                    }
                    case 2: {
                        this.audbuf.limit(cSize);
                        StreamUtils.readBuffer(this.is, this.audbuf);
                        Source hVoice = Sound.newSound(this.audbuf, 22050, 8, 255);
                        if (hVoice == null) continue block6;
                        hVoice.play(255.0f);
                        continue block6;
                    }
                    case 3: {
                        if (cSize == 0) continue block6;
                        int ptr = 200 * StreamUtils.readShort(this.is);
                        cSize -= 2;
                        while (true) {
                            if (cSize <= 0) continue block6;
                            ptr += StreamUtils.readUnsignedByte(this.is);
                            int len = StreamUtils.readUnsignedByte(this.is);
                            cSize -= 2;
                            if (len == 0) continue;
                            int rlen = this.is.read(this.framebuf, ptr, len);
                            if (rlen == -1) {
                                throw new EOFException();
                            }
                            ptr += len;
                            cSize -= len;
                        }
                    }
                    case 4: {
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public void close() {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public float getRate() {
            return 100.0f;
        }

        @Override
        public byte[] getPalette() {
            return null;
        }

        @Override
        public void playAudio() {
        }

        @Override
        public int getFrames() {
            return -1;
        }
    }
}

