/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import java.io.IOException;
import java.io.InputStream;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.RenderedSpriteList;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.AnimType;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Powerslave.Enemies.Ra;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Grenade;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Map;
import ru.m210projects.Powerslave.Player;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Type.StatusAnim;
import ru.m210projects.Powerslave.View;
import ru.m210projects.Powerslave.Weapons;

public class Seq {
    public static final int SEQMAX = 4096;
    public static final int FRAMEMAX = 18000;
    public static final int CHUNKMAX = 21000;
    public static int sequences;
    public static final int[] SeqBase;
    public static final int[] SeqSize;
    public static final int[] SeqFlag;
    public static final int[] SeqOffsets;
    public static int frames;
    public static final int[] FrameBase;
    public static final int[] FrameSize;
    public static final int[] FrameFlag;
    public static final int[] FrameSound;
    public static int chunks;
    public static final int[] ChunkXpos;
    public static final int[] ChunkYpos;
    public static final int[] ChunkPict;
    public static final int[] ChunkFlag;
    public static int centerx;
    public static int centery;
    private static final int[] nGunPicnum;

    public static void LoadSequences() {
        int i;
        String[] SeqNames = new String[]{"rothands.seq", "sword.seq", "pistol.seq", "m_60.seq", "flamer.seq", "grenade.seq", "cobra.seq", "bonesaw.seq", "scramble.seq", "glove.seq", "mummy.seq", "skull.seq", "poof.seq", "kapow.seq", "fireball.seq", "bubble.seq", "spider.seq", "anubis.seq", "anuball.seq", "fish.seq", "snakehed.seq", "snakbody.seq", "wasp.seq", "cobrapow.seq", "scorp.seq", "joe.seq", "status.seq", "dead.seq", "deadex.seq", "anupoof.seq", "skulpoof.seq", "bullet.seq", "shadow.seq", "grenroll.seq", "grenboom.seq", "splash.seq", "grenpow.seq", "skulstrt.seq", "firepoof.seq", "bloodhit.seq", "lion.seq", "items.seq", "lavag.seq", "lsplash.seq", "lavashot.seq", "smokebal.seq", "firepot.seq", "rex.seq", "set.seq", "queen.seq", "roach.seq", "hawk.seq", "setghost.seq", "setgblow.seq", "bizztail.seq", "bizzpoof.seq", "queenegg.seq", "roacshot.seq", "backgrnd.seq", "screens.seq", "arrow.seq", "fonts.seq", "drips.seq", "firetrap.seq", "magic2.seq", "creepy.seq", "slider.seq", "ravolt.seq", "eyehit.seq", "font2.seq", "seebubbl.seq", "blood.seq", "drum.seq", "poof2.seq", "deadbrn.seq", "grenbubb.seq", "rochfire.seq", "rat.seq"};
        for (i = 0; i < 78; ++i) {
            Seq.SeqOffsets[i] = sequences;
            if (Seq.ReadSequence(SeqNames[i])) continue;
            Console.out.println("Error loading " + SeqNames[i]);
        }
        Globals.nShadowPic = Seq.GetFirstSeqPicnum(32);
        Globals.nShadowWidth = Main.engine.getTile(Globals.nShadowPic).getWidth();
        Globals.nFlameHeight = Main.engine.getTile(Seq.GetFirstSeqPicnum(38)).getHeight();
        Globals.nBackgroundPic = Seq.GetFirstSeqPicnum(58);
        Globals.nPilotLightBase = SeqBase[SeqOffsets[4] + 3];
        Globals.nPilotLightCount = SeqSize[SeqOffsets[4] + 3];
        Globals.nPilotLightFrame = 0;
        Globals.nFontFirstChar = Seq.GetFirstSeqPicnum(69);
        for (i = 0; i < SeqSize[SeqOffsets[69]]; ++i) {
            Main.engine.getTile(i + Globals.nFontFirstChar).setOffset(0, 0);
        }
        View.InitStatus();
    }

    public static int GetSeqPicnum(int seq, int offset, int a3) {
        if (SeqBase[SeqOffsets[seq] + offset] + a3 == -1) {
            return 0;
        }
        return ChunkPict[FrameBase[SeqBase[SeqOffsets[seq] + offset] + a3]];
    }

    public static int GetSeqPicnum2(int seq, int a2) {
        if (SeqBase[seq] + a2 == -1) {
            return 0;
        }
        return ChunkPict[FrameBase[SeqBase[seq] + a2]];
    }

    public static int GetFirstSeqPicnum(int seq) {
        if (SeqBase[seq] == -1) {
            return 0;
        }
        return ChunkPict[FrameBase[SeqBase[SeqOffsets[seq]]]];
    }

    public static void DrawStatusSequence(int seq, int frameOffs, int yOffset) {
        Renderer renderer = Main.game.getRenderer();
        int v3 = SeqBase[seq] + frameOffs;
        if (v3 == -1) {
            return;
        }
        int chunkNum = FrameBase[v3];
        int count = FrameSize[v3];
        while (--count >= 0) {
            int ang = 0;
            int stat = 10;
            int orientation = ChunkFlag[chunkNum];
            int x = ChunkXpos[chunkNum] + 160;
            int y = ChunkYpos[chunkNum] + 100 + yOffset;
            if ((orientation & 3) != 0) {
                if ((orientation & 1) != 0) {
                    ang = 1024;
                }
                if (orientation != 3) {
                    stat |= 4;
                }
            }
            renderer.rotatesprite(x << 16, y << 16, 65536, ang, ChunkPict[chunkNum++], 0, 0, stat);
        }
    }

    public static void DrawCustomSequence(int baseSeq, int frameOffs, int xoffs, int yoffs, int shade, int pal, int dastat) {
        Renderer renderer = Main.game.getRenderer();
        if (baseSeq == -1) {
            return;
        }
        int v3 = SeqBase[baseSeq] + frameOffs;
        if (v3 == -1) {
            return;
        }
        int chunkNum = FrameBase[v3];
        int count = FrameSize[v3];
        while (--count >= 0) {
            int ang = 0;
            int stat = 0xA | dastat;
            int orientation = ChunkFlag[chunkNum];
            int x = ChunkXpos[chunkNum] + 160 + xoffs;
            int y = ChunkYpos[chunkNum] + 100 + yoffs;
            if ((orientation & 3) != 0) {
                if ((orientation & 1) != 0) {
                    ang = 1024;
                }
                if (orientation != 3) {
                    stat |= 4;
                }
            }
            renderer.rotatesprite(x << 16, y << 16, 65536, ang, ChunkPict[chunkNum++], shade, pal, stat);
        }
    }

    public static void DrawGunSequence(int baseSeq, int frameOffs, int xoffs, int yoffs, int shade, int pal, int extstat) {
        if (baseSeq == -1) {
            return;
        }
        Renderer renderer = Main.game.getRenderer();
        int v3 = SeqBase[baseSeq] + frameOffs;
        if (v3 == -1) {
            return;
        }
        int chunkNum = FrameBase[v3];
        int count = FrameSize[v3];
        int flags = FrameFlag[v3];
        while (--count >= 0) {
            int ang = 0;
            int stat = 0xA | extstat;
            int orientation = ChunkFlag[chunkNum];
            int x = ChunkXpos[chunkNum] + 160 + xoffs;
            int y = ChunkYpos[chunkNum] + 100 + yoffs;
            if ((orientation & 3) != 0) {
                if ((orientation & 1) != 0) {
                    ang = 1024;
                }
                if (orientation != 3) {
                    stat |= 4;
                }
            }
            if ((flags & 4) != 0) {
                shade -= 100;
            }
            if (Globals.nPlayerInvisible[Globals.nLocalPlayer] != 0) {
                stat |= 0x21;
            }
            renderer.rotatesprite(x << 16, y << 16, 65536, ang, ChunkPict[chunkNum++], shade, pal, stat);
        }
    }

    public static void PlotArrowSequence(TSprite tsp, int baseSeq, int frameOffs) {
        int ang = (tsp.getAng() + 512 - Main.engine.GetMyAngle(Globals.nCamerax - tsp.getX(), Globals.nCameray - tsp.getY()) + 128 & 0x7FF) >> 8;
        int seq = SeqBase[baseSeq + ang] + frameOffs;
        if (seq == -1) {
            return;
        }
        int frm = FrameBase[seq];
        int cstat = tsp.getCstat() | 0x80;
        byte shade = tsp.getShade();
        cstat = (ang & 3) != 0 ? (cstat |= 0x18) : (cstat &= 0xFFFFFFE7);
        if ((FrameFlag[seq] & 4) != 0) {
            shade = (byte)(shade - 100);
        }
        tsp.setCstat(cstat);
        tsp.setShade(shade);
        tsp.setStatnum(FrameSize[seq]);
        if ((ChunkFlag[frm] & 1) != 0) {
            tsp.setXoffset(ChunkXpos[frm]);
            tsp.setCstat(tsp.getCstat() | 4);
        } else {
            tsp.setXoffset(-ChunkXpos[frm]);
        }
        tsp.setYoffset(-ChunkYpos[frm]);
        tsp.setPicnum(ChunkPict[frm]);
    }

    public static void PlotSequence(Sprite pTSprite, int a2, int a3, int a4) {
        Renderer renderer = Main.game.getRenderer();
        RenderedSpriteList renderedSpriteList = renderer.getRenderedSprites();
        int dang = Main.engine.GetMyAngle(Globals.nCamerax - pTSprite.getX(), Globals.nCameray - pTSprite.getY());
        int nShade = pTSprite.getShade();
        if (SeqBase[a2] + a3 == -1) {
            return;
        }
        if ((FrameFlag[SeqBase[a2] + a3] & 4) != 0) {
            nShade -= 100;
        }
        int v8 = (a4 & 1) == 0 ? (pTSprite.getAng() - dang + 128 & 0x7FF) >> 8 : 0;
        int seq = SeqBase[v8 + a2] + a3;
        int frm = FrameBase[seq];
        int frmSize = FrameSize[seq];
        int nStatnum = 100;
        if ((a4 & 0x100) != 0) {
            nStatnum = -3;
        }
        short nOwner = pTSprite.getOwner();
        int nTile = ChunkPict[frm];
        for (int i = frmSize; i > 0; --i) {
            TSprite tsp = (TSprite)renderedSpriteList.obtain();
            int xoffs = Pragmas.mulscale(frmSize - i, EngineUtils.sin(dang + 512 & 0x7FF), 10);
            int yoffs = Pragmas.mulscale(frmSize - i, EngineUtils.sin(dang & 0x7FF), 10);
            tsp.setX(pTSprite.getX() + xoffs);
            tsp.setY(pTSprite.getY() + yoffs);
            tsp.setZ(pTSprite.getZ());
            tsp.setShade((byte)nShade);
            tsp.setPal(pTSprite.getPal());
            tsp.setXrepeat(pTSprite.getXrepeat());
            tsp.setYrepeat(pTSprite.getYrepeat());
            tsp.setAng(ChunkPict[frm] == 736 ? dang : (int)pTSprite.getAng());
            tsp.setOwner(pTSprite.getOwner());
            tsp.update(pTSprite.getX() + xoffs, pTSprite.getY() + yoffs, pTSprite.getZ(), pTSprite.getSectnum());
            tsp.setCstat(pTSprite.getCstat() | 0x80);
            tsp.setStatnum(i + nStatnum + 1);
            if ((ChunkFlag[frm] & 1) != 0) {
                tsp.setXoffset(ChunkXpos[frm]);
                tsp.setCstat(tsp.getCstat() | 4);
            } else {
                tsp.setXoffset(-ChunkXpos[frm]);
            }
            tsp.setYoffset(-ChunkYpos[frm]);
            tsp.setPicnum(ChunkPict[frm]);
            ++frm;
        }
        Sprite pOwner = Main.boardService.getSprite(nOwner);
        if ((pTSprite.getCstat() & 0x101) != 0 && (pOwner != null && pOwner.getStatnum() != 100 || Globals.nNetPlayerCount == 0)) {
            Sector sec = Main.boardService.getSector(pTSprite.getSectnum());
            if (sec == null) {
                pTSprite.setOwner(-1);
                return;
            }
            int fz = sec.getFloorz();
            if (fz > Globals.initz + Globals.PlayerList[Globals.nLocalPlayer].eyelevel) {
                if (!Main.cfg.bNewShadows) {
                    int siz = Math.max(32 * Main.engine.getTile(nTile).getWidth() / Globals.nShadowWidth - (fz - pTSprite.getZ() >> 10), 1);
                    pTSprite.setPicnum(Globals.nShadowPic);
                    pTSprite.setCstat(34);
                    pTSprite.setXrepeat(siz);
                    pTSprite.setYrepeat(siz);
                } else {
                    pTSprite.setX(pTSprite.getX() - Pragmas.mulscale(EngineUtils.sin(dang + 512 & 0x7FF), 100L, 16));
                    pTSprite.setY(pTSprite.getY() + Pragmas.mulscale(EngineUtils.sin(dang + 1024 & 0x7FF), 100L, 16));
                    int siz = Math.max(48 - (fz - pTSprite.getZ() >> 10), 1);
                    pTSprite.setPicnum(nTile);
                    pTSprite.setXrepeat(siz);
                    pTSprite.setYrepeat(pTSprite.getYrepeat() >> 3);
                    if (pTSprite.getYrepeat() < 4) {
                        pTSprite.setYrepeat(4);
                    }
                    pTSprite.setShade(127);
                    pTSprite.setCstat(pTSprite.getCstat() | 2);
                }
                pTSprite.setZ(fz + 1);
                pTSprite.setStatnum(-3);
                pTSprite.setPal(0);
                return;
            }
        }
        pTSprite.setOwner(-1);
    }

    public static void StartDeathSeq(int player, int seq) {
        short lotag;
        Ra.FreeRa(player);
        Globals.PlayerList[player].HealthAmount = 0;
        int nSprite = Globals.PlayerList[player].spriteId;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        Sector sec = Main.boardService.getSector(pSprite.getSectnum());
        if (sec != null && (lotag = sec.getLotag()) > 0) {
            RunList.SignalRun(lotag - 1, 0x70000 | player);
        }
        if (Globals.nPlayerGrenade[player] < 0) {
            if (Globals.nNetPlayerCount != 0 && Globals.PlayerList[player].currentWeapon > 0 && Globals.PlayerList[player].currentWeapon <= 6) {
                int sect = pSprite.getSectnum();
                if (Globals.SectBelow[sect] > -1) {
                    sect = Globals.SectBelow[sect];
                }
                int spr = Weapons.GrabBodyGunSprite();
                Sprite sprite = Main.boardService.getSprite(spr);
                Sector sec2 = Main.boardService.getSector(sect);
                if (sprite != null && sec2 != null) {
                    Main.engine.changespritesect(spr, sect);
                    sprite.setX(pSprite.getX());
                    sprite.setY(pSprite.getY());
                    sprite.setZ(sec2.getFloorz() - 512);
                    Main.engine.changespritestat(spr, Player.nActionEyeLevel[Globals.PlayerList[player].currentWeapon + 20] + 900);
                    sprite.setPicnum(nGunPicnum[Globals.PlayerList[player].currentWeapon - 1]);
                    Map.BuildItemAnim(spr);
                }
            }
        } else {
            Grenade.ThrowGrenade(player, 0, 0, 0, -10000);
        }
        Weapons.StopFiringWeapon(player);
        Globals.PlayerList[player].horiz = 92.0f;
        Globals.PlayerList[player].eyelevel = -14080;
        Globals.nPlayerInvisible[player] = 0;
        Globals.dVertPan[player] = 15;
        pSprite.setCstat(pSprite.getCstat() & 0xFFFF7EFE);
        Weapons.SetNewWeaponImmediate(player, -2);
        Globals.nDeathType[player] = Globals.SectDamage[pSprite.getSectnum()] <= 0 ? seq : 2;
        Globals.PlayerList[player].anim_ = seq != 0 || (Globals.SectFlag[pSprite.getSectnum()] & 0x2000) == 0 ? 2 * seq + 17 : 16;
        Globals.PlayerList[player].animCount = 0;
        if (Mmulti.numplayers == 1) {
            if (Globals.nPlayerLives[player] > 0) {
                StatusAnim.BuildStatusAnim(3 * (Globals.nPlayerLives[player] - 1) + 7, 0);
            }
            if (Globals.levelnum > 0 || Globals.mUserFlag == Main.UserFlag.UserMap) {
                int n = player;
                Globals.nPlayerLives[n] = Globals.nPlayerLives[n] - 1;
            }
            if (Globals.nPlayerLives[player] < 0) {
                Globals.nPlayerLives[player] = 0;
            }
        }
        Globals.totalvel[player] = 0;
    }

    public static void DrawPilotLightSeq(int x, int y) {
        Renderer renderer = Main.game.getRenderer();
        if ((Globals.SectFlag[Globals.nPlayerViewSect[Globals.nLocalPlayer]] & 0x2000) == 0) {
            int v3 = Globals.nPilotLightBase + Globals.nPilotLightFrame;
            int seq = FrameBase[v3];
            int count = FrameSize[v3];
            while (--count >= 0) {
                renderer.rotatesprite(x + 160 + ChunkXpos[seq] << 16, y + 100 + ChunkYpos[seq] << 16, 65536, -8 * (int)Globals.sPlayerInput[Globals.nLocalPlayer].avel, ChunkPict[seq], -127, 1, 10);
                ++seq;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean ReadSequence(String name) {
        int sequence = 0;
        Entry entry = Main.game.getCache().getEntry(name, true);
        if (!entry.exists()) {
            System.err.println("Unable to open " + name);
            return false;
        }
        try (InputStream is = entry.getInputStream();){
            int i;
            int i2;
            int i3;
            String sign = StreamUtils.readString(is, 2);
            centerx = StreamUtils.readShort(is);
            centery = StreamUtils.readShort(is);
            int nSeqs = StreamUtils.readShort(is);
            if (nSeqs <= 0 || nSeqs + sequences >= 4096) {
                System.err.println("Not enough sequences available!  Increase array");
                boolean bl = false;
                return bl;
            }
            for (i3 = 0; i3 < nSeqs; ++i3) {
                Seq.SeqBase[i3 + Seq.sequences] = StreamUtils.readShort(is);
            }
            for (i3 = 0; i3 < nSeqs; ++i3) {
                Seq.SeqSize[i3 + Seq.sequences] = StreamUtils.readShort(is);
            }
            for (i3 = 0; i3 < nSeqs; ++i3) {
                Seq.SeqFlag[i3 + Seq.sequences] = StreamUtils.readShort(is);
            }
            for (i3 = 0; i3 < nSeqs; ++i3) {
                int n = i3 + sequences;
                SeqBase[n] = SeqBase[n] + frames;
            }
            int oldSeqFrameOffset = frames;
            int nFrames = StreamUtils.readShort(is);
            if (nFrames <= 0 || frames + nFrames >= 18000) {
                System.err.println("Not enough frames available!  Increase FRAMEMAX");
                boolean bl = false;
                return bl;
            }
            for (i2 = 0; i2 < nFrames; ++i2) {
                Seq.FrameBase[i2 + Seq.frames] = StreamUtils.readShort(is);
            }
            for (i2 = 0; i2 < nFrames; ++i2) {
                Seq.FrameSize[i2 + Seq.frames] = StreamUtils.readShort(is);
            }
            for (i2 = 0; i2 < nFrames; ++i2) {
                Seq.FrameFlag[i2 + Seq.frames] = StreamUtils.readShort(is);
            }
            for (i2 = 0; i2 < nFrames; ++i2) {
                Seq.FrameSound[i2 + Seq.frames] = -1;
            }
            for (i2 = 0; i2 < nFrames; ++i2) {
                int n = i2 + frames;
                FrameBase[n] = FrameBase[n] + chunks;
            }
            int nChunks = StreamUtils.readShort(is);
            if (nChunks < 0 || chunks + nChunks >= 21000) {
                System.err.println("Not enough chunks available!  Increase CHUNKMAX");
                boolean bl = false;
                return bl;
            }
            for (i = 0; i < nChunks; ++i) {
                Seq.ChunkXpos[i + Seq.chunks] = StreamUtils.readShort(is);
            }
            for (i = 0; i < nChunks; ++i) {
                Seq.ChunkYpos[i + Seq.chunks] = StreamUtils.readShort(is);
            }
            for (i = 0; i < nChunks; ++i) {
                Seq.ChunkPict[i + Seq.chunks] = StreamUtils.readShort(is);
            }
            for (i = 0; i < nChunks; ++i) {
                if (Main.engine.getTile(ChunkPict[i + chunks]).getType() == AnimType.NONE) continue;
                System.err.println("sequence " + sequence + " tile " + ChunkPict[i + chunks] + " has Ken animation attached!");
            }
            for (i = 0; i < nChunks; ++i) {
                Seq.ChunkFlag[i + Seq.chunks] = StreamUtils.readShort(is);
            }
            for (i = 0; i < nChunks; ++i) {
                int n = i + chunks;
                ChunkXpos[n] = ChunkXpos[n] - centerx;
                int n2 = i + chunks;
                ChunkYpos[n2] = ChunkYpos[n2] - centery;
            }
            Seq.SeqBase[Seq.sequences += nSeqs] = frames += nFrames;
            Seq.FrameBase[Seq.frames] = chunks += nChunks;
            if (!sign.equals("DS")) return true;
            int numSounds = StreamUtils.readShort(is);
            String[] sounds = new String[20];
            byte[] data = new byte[8];
            for (int i4 = 0; i4 < numSounds; ++i4) {
                StreamUtils.readBytes(is, data);
                sounds[i4] = new String(data).trim();
            }
            int v52 = StreamUtils.readShort(is);
            int i5 = 0;
            while (i5 < v52) {
                short index = StreamUtils.readShort(is);
                short v46 = StreamUtils.readShort(is);
                Seq.FrameSound[index + oldSeqFrameOffset] = v46 & 0xFE00 | Sound.LoadSound(sounds[v46 & 0x1FF]);
                ++i5;
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static int GetFrameFlag(int a1, int a2) {
        return FrameFlag[a2 + SeqBase[a1]];
    }

    public static void MoveSequence(int nSprite, int a2, int a3) {
        int v4 = Sound.GetFrameSound(a2, a3);
        if (v4 != -1) {
            if (nSprite <= -1) {
                Sound.PlayLocalSound(v4, 0);
            } else {
                Sound.D3PlayFX(v4, nSprite);
            }
        }
    }

    static {
        SeqBase = new int[4096];
        SeqSize = new int[4096];
        SeqFlag = new int[4096];
        SeqOffsets = new int[78];
        FrameBase = new int[18000];
        FrameSize = new int[18000];
        FrameFlag = new int[18000];
        FrameSound = new int[18000];
        ChunkXpos = new int[21000];
        ChunkYpos = new int[21000];
        ChunkPict = new int[21000];
        ChunkFlag = new int[21000];
        nGunPicnum = new int[]{488, 490, 491, 878, 899, 3455};
    }
}

