/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Powerslave.Anim;
import ru.m210projects.Powerslave.Bullet;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Light;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.SafeLoader;
import ru.m210projects.Powerslave.Type.SnakeStruct;

public class Snake {
    public static final int MAX_SNAKES = 50;
    public static final SnakeStruct[] SnakeList = new SnakeStruct[50];
    private static int nSnakesFree;
    private static final int[] SnakeFree;
    private static final int[] nSnakePlayer;

    public static void InitSnakes() {
        for (int i = 0; i < 50; i = (int)((short)(i + 1))) {
            Snake.SnakeFree[i] = i;
        }
        nSnakesFree = 50;
        Arrays.fill(Globals.nPlayerSnake, 0);
    }

    public static void saveSnakes(OutputStream os) throws IOException {
        int i;
        int nSnakes = 0;
        for (i = 0; i < 50; ++i) {
            if (SnakeList[i] == null || Snake.SnakeList[i].nFunc == -1) continue;
            ++nSnakes;
        }
        StreamUtils.writeShort(os, nSnakesFree);
        for (i = 0; i < 50; ++i) {
            StreamUtils.writeShort(os, SnakeFree[i]);
            StreamUtils.writeShort(os, nSnakePlayer[i]);
        }
        if (nSnakes != 0) {
            for (i = 0; i < 50; ++i) {
                if (SnakeList[i] == null || Snake.SnakeList[i].nFunc == -1) continue;
                StreamUtils.writeShort(os, i);
                SnakeList[i].save(os);
            }
        }
    }

    public static void loadSnakes(SafeLoader loader) {
        nSnakesFree = loader.nSnakesFree;
        System.arraycopy(loader.SnakeFree, 0, SnakeFree, 0, 50);
        System.arraycopy(loader.nSnakePlayer, 0, nSnakePlayer, 0, 50);
        for (int i = 0; i < 50; ++i) {
            if (SnakeList[i] != null) {
                Snake.SnakeList[i].nFunc = -1;
            }
            if (loader.SnakeList[i] == null || loader.SnakeList[i].nFunc == -1) continue;
            if (SnakeList[i] == null) {
                Snake.SnakeList[i] = new SnakeStruct();
            }
            SnakeList[i].copy(loader.SnakeList[i]);
        }
    }

    public static void loadSnakes(SafeLoader loader, InputStream is) throws IOException {
        int i;
        for (i = 0; i < 50; ++i) {
            if (loader.SnakeList[i] == null) continue;
            loader.SnakeList[i].nFunc = -1;
        }
        loader.nSnakesFree = StreamUtils.readShort(is);
        for (i = 0; i < 50; ++i) {
            loader.SnakeFree[i] = StreamUtils.readShort(is);
            loader.nSnakePlayer[i] = StreamUtils.readShort(is);
        }
        for (int nSnakes = 50 - loader.nSnakesFree; nSnakes > 0; --nSnakes) {
            short i2 = StreamUtils.readShort(is);
            if (loader.SnakeList[i2] == null) {
                loader.SnakeList[i2] = new SnakeStruct();
            }
            loader.SnakeList[i2].load(is);
        }
    }

    public static int GrabSnake() {
        return SnakeFree[--nSnakesFree];
    }

    public static void DestroySnake(int a1) {
        RunList.SubRunRec(Snake.SnakeList[a1].nFunc);
        for (int i = 0; i < 8; ++i) {
            int spr = Snake.SnakeList[a1].nSprite[i];
            Sprite sp = Main.boardService.getSprite(spr);
            if (sp == null) continue;
            RunList.DoSubRunRec(sp.getLotag() - 1);
            RunList.DoSubRunRec(sp.getOwner());
            Main.engine.mydeletesprite(spr);
        }
        Snake.SnakeList[a1].nFunc = -1;
        Snake.SnakeFree[Snake.nSnakesFree] = a1;
        ++nSnakesFree;
        if (a1 == Globals.nSnakeCam) {
            Globals.nSnakeCam = -1;
        }
    }

    public static void ExplodeSnakeSprite(int nSprite, int a2) {
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        int v3 = Bullet.BulletInfo[5].force;
        if (Globals.nPlayerDouble[a2] > 0) {
            v3 = 2 * Bullet.BulletInfo[5].force;
        }
        short old = pSprite.getOwner();
        pSprite.setOwner(Globals.PlayerList[a2].spriteId);
        Sprites.RadialDamageEnemy(nSprite, v3, Bullet.BulletInfo[5].inf_10);
        pSprite.setOwner(old);
        Anim.BuildAnim(-1, 23, 0, pSprite.getX(), pSprite.getY(), pSprite.getZ(), pSprite.getSectnum(), 40, 4);
        Light.AddFlash(pSprite.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ(), 128);
        Sound.StopSpriteSound(nSprite);
    }

    public static void BuildSnake(int a1, int a2) {
        if (nSnakesFree != 0) {
            int nSprite = Globals.PlayerList[a1].spriteId;
            Sprite pSprite = Main.boardService.getSprite(nSprite);
            if (pSprite == null) {
                return;
            }
            int sect = Globals.nPlayerViewSect[a1];
            int picnum = Seq.GetSeqPicnum(21, 0, 0);
            int v40 = a2 - 1280;
            Main.engine.hitscan(pSprite.getX(), pSprite.getY(), v40 + pSprite.getZ() - 2560, pSprite.getSectnum(), EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF), EngineUtils.sin(pSprite.getAng() & 0x7FF), 0, Engine.pHitInfo, 0x1000040);
            if (EngineUtils.sqrt((Engine.pHitInfo.hitx - pSprite.getX()) * (Engine.pHitInfo.hitx - pSprite.getX()) + (Engine.pHitInfo.hity - pSprite.getY()) * (Engine.pHitInfo.hity - pSprite.getY())) >= EngineUtils.sin(512) >> 4) {
                Sprite pTarget = Main.boardService.getSprite(Engine.pHitInfo.hitsprite);
                int nTarget = pTarget == null || pTarget.getStatnum() < 90 || pTarget.getStatnum() > 199 ? Globals.sPlayerInput[a1].nTarget : Engine.pHitInfo.hitsprite;
                int nSnake = Snake.GrabSnake();
                if (SnakeList[nSnake] == null) {
                    Snake.SnakeList[nSnake] = new SnakeStruct();
                }
                int v55 = 0;
                int peer = -1;
                for (int i = 0; i < 8; ++i) {
                    int spr = Main.engine.insertsprite(sect, 202);
                    Sprite sp = Main.boardService.getSprite(spr);
                    if (sp == null) {
                        throw new AssertException("spr>=0 && spr<MAXSPRITES");
                    }
                    sp.setOwner(nSprite);
                    sp.setPicnum(picnum);
                    if (i != 0) {
                        Sprite pPeer = Main.boardService.getSprite(peer);
                        if (pPeer != null) {
                            sp.setX(pPeer.getX());
                            sp.setY(pPeer.getY());
                            sp.setZ(pPeer.getZ());
                            int siz = 40 - (i + v55);
                            sp.setXrepeat(siz);
                            sp.setYrepeat(siz);
                        }
                    } else {
                        sp.setX(pSprite.getX());
                        sp.setY(pSprite.getY());
                        sp.setZ(v40 + pSprite.getZ());
                        sp.setXrepeat(32);
                        sp.setYrepeat(32);
                        peer = spr;
                        sect = sp.getSectnum();
                    }
                    sp.setClipdist(10);
                    sp.setCstat(0);
                    sp.setShade(-64);
                    sp.setPal(0);
                    sp.setXoffset(0);
                    sp.setYoffset(0);
                    sp.setAng(pSprite.getAng());
                    sp.setXvel(0);
                    sp.setYvel(0);
                    sp.setZvel(0);
                    sp.setLotag(RunList.HeadRun() + 1);
                    sp.setHitag(0);
                    sp.setExtra(-1);
                    Snake.SnakeList[nSnake].nSprite[i] = spr;
                    sp.setOwner(RunList.AddRunRec(sp.getLotag() - 1, 0x110000 | i << 8 | nSnake));
                    Main.game.pInt.setsprinterpolate(spr, sp);
                    v55 += 2;
                }
                Snake.SnakeList[nSnake].nFunc = RunList.AddRunRec(RunList.NewRun, 0x110000 | nSnake);
                Snake.SnakeList[nSnake].field_14[1] = 2;
                Snake.SnakeList[nSnake].field_14[2] = 4;
                Snake.SnakeList[nSnake].field_14[3] = 6;
                Snake.SnakeList[nSnake].field_14[4] = 7;
                Snake.SnakeList[nSnake].field_14[5] = 5;
                Snake.SnakeList[nSnake].field_14[6] = 6;
                Snake.SnakeList[nSnake].field_14[7] = 7;
                Snake.SnakeList[nSnake].nTarget = nTarget;
                Snake.SnakeList[nSnake].field_10 = 1200;
                Snake.SnakeList[nSnake].zvec = 0;
                Snake.nSnakePlayer[nSnake] = a1;
                Globals.nPlayerSnake[a1] = nSnake;
                if (Globals.bSnakeCam && Globals.nSnakeCam < 0) {
                    Globals.nSnakeCam = nSnake;
                }
                Sound.D3PlayFX(Sound.StaticSound[6], peer);
            } else {
                Bullet.BackUpBullet(Engine.pHitInfo.hitx, Engine.pHitInfo.hity, pSprite.getAng());
                int i = Main.engine.insertsprite(Engine.pHitInfo.hitsect, 202);
                Sprite s = Main.boardService.getSprite(i);
                if (s != null) {
                    s.setX(Engine.pHitInfo.hitx);
                    s.setY(Engine.pHitInfo.hity);
                    s.setZ(Engine.pHitInfo.hitz);
                    Snake.ExplodeSnakeSprite(i, a1);
                    Main.engine.mydeletesprite(i);
                }
            }
        }
    }

    public static void FindSnakeEnemy(int nSnake) {
        int pspr = Globals.PlayerList[Snake.nSnakePlayer[nSnake]].spriteId;
        int spr = Snake.SnakeList[nSnake].nSprite[0];
        Sprite pSprite = Main.boardService.getSprite(spr);
        if (pSprite == null) {
            Snake.SnakeList[nSnake].nTarget = -1;
            return;
        }
        int v15 = -1;
        int v5 = 2048;
        for (ListNode<Sprite> node = Main.boardService.getSectNode(pSprite.getSectnum()); node != null; node = node.getNext()) {
            int v9;
            int i = node.getIndex();
            Sprite nodeSprite = node.get();
            if (nodeSprite.getStatnum() < 90 || nodeSprite.getStatnum() >= 150 || (nodeSprite.getCstat() & 0x101) == 0 || i == pspr || (nodeSprite.getCstat() >> 8 & 0x80) != 0 || (v9 = pSprite.getAng() - Sprites.GetAngleToSprite(pSprite, nodeSprite) & 0x7FF) >= v5) continue;
            v15 = i;
            v5 = v9;
        }
        if (v15 != -1) {
            Snake.SnakeList[nSnake].nTarget = v15;
            return;
        }
        if (--Snake.SnakeList[nSnake].nTarget < -25) {
            Snake.SnakeList[nSnake].nTarget = pspr;
        }
    }

    public static void FuncSnake(int nStack, int ignored, int RunPtr) {
        byte nSnake = (byte)(RunList.RunData[RunPtr].getObject() & 0xFF);
        if (nSnake < 0 || nSnake >= 50) {
            throw new AssertException("nSnake>=0 && nSnake<MAX_SNAKES");
        }
        int v37 = 0;
        int nHitMove = 0;
        short nObject = (short)(nStack & 0xFFFF);
        int nSprite = Snake.SnakeList[nSnake].nSprite[0];
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        switch (nStack & 0x7F0000) {
            case 131072: {
                Seq.MoveSequence(nSprite, Seq.SeqOffsets[20], 0);
                int nTarget = Snake.SnakeList[nSnake].nTarget;
                Sprite pTarget = Main.boardService.getSprite(nTarget);
                if (pTarget != null) {
                    if ((pTarget.getCstat() & 0x101) != 0) {
                        nHitMove = Sprites.AngleChase(nSprite, nTarget, 1200, Snake.SnakeList[nSnake].zvec, 32);
                        break;
                    }
                    Snake.SnakeList[nSnake].nTarget = -1;
                }
                nHitMove = Main.engine.movesprite(nSprite, 600 * EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF), 600 * EngineUtils.sin(pSprite.getAng() & 0x7FF), EngineUtils.sin(Snake.SnakeList[nSnake].zvec & 0x7FF) >> 5, 0, 0, 1);
                Snake.FindSnakeEnemy(nSnake);
                break;
            }
            case 589824: {
                Renderer renderer = Main.game.getRenderer();
                TSprite tsp = (TSprite)renderer.getRenderedSprites().get(nObject);
                if ((RunList.RunData[RunPtr].getObject() & 0xFF00) != 0) {
                    Seq.PlotSequence(tsp, Seq.SeqOffsets[21], 0, 0);
                } else {
                    Seq.PlotSequence(tsp, Seq.SeqOffsets[20], 0, 0);
                }
                tsp.setOwner(-1);
                return;
            }
        }
        if (nHitMove != 0) {
            Snake.ExplodeSnakeSprite(Snake.SnakeList[nSnake].nSprite[0], nSnakePlayer[nSnake]);
            Globals.nPlayerSnake[nObject] = -1;
            Snake.nSnakePlayer[nSnake] = -1;
            Snake.DestroySnake(nSnake);
        } else {
            short ang = pSprite.getAng();
            int v14 = -64 * EngineUtils.sin(ang & 0x7FF);
            int dx = -576 * EngineUtils.sin(ang + 512 & 0x7FF);
            int v36 = -64 * EngineUtils.sin(ang + 512 & 0x7FF);
            int v15 = -512 * EngineUtils.sin(ang & 0x7FF);
            int dy = v36 + v15;
            int v39 = Snake.SnakeList[nSnake].zvec;
            Snake.SnakeList[nSnake].zvec = v39 + 64 & 0x7FF;
            short sectnum = pSprite.getSectnum();
            int sx = pSprite.getX();
            int sy = pSprite.getY();
            int sz = pSprite.getZ();
            int dz = 0;
            for (int i = 7; i > 0; --i) {
                int spr = Snake.SnakeList[nSnake].nSprite[i];
                Sprite tailSprite = Main.boardService.getSprite(spr);
                if (tailSprite == null) continue;
                Main.game.pInt.setsprinterpolate(spr, tailSprite);
                tailSprite.setAng(ang);
                tailSprite.setX(sx);
                tailSprite.setY(sy);
                tailSprite.setZ(sz);
                Main.engine.mychangespritesect(spr, sectnum);
                int vel = Snake.SnakeList[nSnake].field_14[i] * EngineUtils.sin(v39 & 0x7FF) >> 9;
                Main.engine.movesprite(spr, vel * EngineUtils.sin(pSprite.getAng() + 1024 & 0x7FF) + (dx -= v36), EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) * vel + (dy -= v14), dz += v37, 0, 0, 1);
                v39 = v39 + 128 & 0x7FF;
            }
        }
    }

    static {
        SnakeFree = new int[50];
        nSnakePlayer = new int[50];
    }
}

