/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import com.badlogic.gdx.audio.Music;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import ru.m210projects.Build.Architecture.common.audio.BuildAudio;
import ru.m210projects.Build.Architecture.common.audio.SoundData;
import ru.m210projects.Build.Architecture.common.audio.Source;
import ru.m210projects.Build.Architecture.common.audio.SourceListener;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Script.CueScript;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Map;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Snake;
import ru.m210projects.Powerslave.Type.SoundResource;
import ru.m210projects.Powerslave.Type.VOCDecoder;

public class Sound {
    public static final String[] cdTrackList = new String[]{"", "track02.ogg", "track03.ogg", "track04.ogg", "track05.ogg", "track06.ogg", "track07.ogg", "track08.ogg", "track09.ogg", "track10.ogg", "track11.ogg", "track12.ogg", "track13.ogg", "track14.ogg", "track15.ogg", "track16.ogg", "track17.ogg", "track18.ogg", "track19.ogg"};
    private static final List<Entry> cdTrackEntries = new ArrayList<Entry>();
    public static final String[] SoundFiles = new String[]{"spl_big", "spl_smal", "bubble_l", "grn_drop", "p_click", "grn_roll", "cosprite", "m_chant0", "anu_icu", "item_reg", "item_spe", "item_key", "torch_on", "jon_bnst", "jon_gasp", "jon_land", "jon_gags", "jon_fall", "jon_drwn", "jon_air1", "jon_glp1", "jon_bbwl", "jon_pois", "amb_ston", "cat_icu", "bubble_h", "set_land", "jon_hlnd", "jon_laf2", "spi_jump", "jon_scub", "item_use", "tr_arrow", "swi_foot", "swi_ston", "swi_wtr1", "tr_fire", "m_skull5", "spi_atak", "anu_hit", "fishdies", "scrp_icu", "jon_wade", "amb_watr", "tele_1", "wasp_stg", "res", "drum4", "rex_icu", "m_hits_u", "q_tail", "vatr_mov", "jon_hit3", "jon_t_2", "jon_t_1", "jon_t_5", "jon_t_6", "jon_t_8", "jon_t_4", "rasprit1", "jon_fdie", "wijaf1", "ship_1", "saw_on", "ra_on", "amb_ston", "vatr_stp", "mana1", "mana2", "ammo", "pot_pc1", "pot_pc2", "weapon", "alarm", "tick1", "scrp_zap", "jon_t_3", "jon_laf1", "blasted", "jon_air2"};
    public static int nWaspSound = -1;
    public static final int[] StaticSound = new int[80];
    public static final SoundResource[] SoundBufs = new SoundResource[200];
    public static final String[] szSoundName = new String[200];
    public static int nSoundCount;
    public static int soundx;
    public static int soundy;
    public static int soundz;
    public static int soundsect;
    public static int nLocalSectFlags;
    public static int nAmbientChannel;
    public static int nLocalChan;
    public static ActiveSound[] sActiveSound;
    public static int nNextFreq;
    public static int nSwirlyFrames;
    public static int currTrack;
    public static Music currMusic;
    public static Entry userMusicEntry;
    private static BuildAudio audio;
    private static int pSoundVolume;
    private static int pSoundPitch;

    public static void sndInit() {
        Main.cfg.setAudioDriver(Main.cfg.getAudioDriver());
        Main.cfg.setMidiDevice(Main.cfg.getMidiDevice());
        audio = Main.cfg.getAudio();
        audio.registerDecoder("VOC", new VOCDecoder());
        Globals.nCreepyTimer = 180;
        Sound.InitSoundInfo(Main.cfg.getMaxvoices());
    }

    private static void InitSoundInfo(int voices) {
        sActiveSound = new ActiveSound[voices];
        for (int i = 0; i < sActiveSound.length; ++i) {
            Sound.sActiveSound[i] = new ActiveSound();
            Sound.sActiveSound[i].ambchannel = i;
        }
    }

    public static void GetSpriteSoundPitch(int nSector, int pVolume, int pPitch) {
        if (!Main.boardService.isValidSector(nSector)) {
            return;
        }
        pSoundVolume = pVolume;
        pSoundPitch = pPitch;
        if (((nLocalSectFlags ^ Globals.SectFlag[nSector]) & 0x2000) != 0) {
            pSoundVolume >>= 1;
            pSoundPitch -= 1200;
        }
    }

    @Deprecated
    public static boolean midRestart() {
        Sound.StopMusic();
        return false;
    }

    public static int GetFrameSound(int a1, int a2) {
        if (a1 < 0 || a1 >= Seq.SeqBase.length || a2 + Seq.SeqBase[a1] == -1) {
            return -1;
        }
        return Seq.FrameSound[a2 + Seq.SeqBase[a1]];
    }

    public static void LoadFX() {
        for (int i = 0; i < 80; ++i) {
            Sound.StaticSound[i] = Sound.LoadSound(SoundFiles[i]);
        }
    }

    public static void StartElevSound(int a1, int a2) {
        if ((a2 & 2) != 0) {
            Sound.D3PlayFX(StaticSound[Map.nElevSound], a1);
        } else {
            Sound.D3PlayFX(StaticSound[Map.nStoneSound], a1);
        }
    }

    public static int LoadSound(String name) {
        for (int i = 0; i < nSoundCount; ++i) {
            if (!szSoundName[i].equalsIgnoreCase(name)) continue;
            return i;
        }
        if (nSoundCount >= 200) {
            throw new AssertException("Too many sounds being loaded... increase array size");
        }
        Entry entry = Main.game.getCache().getEntry(name + ".voc", false);
        if (!entry.exists()) {
            Console.out.println("Sound " + name + " not found.", OsdColor.RED);
            return -1;
        }
        if (name.equals("WASP_WNG")) {
            nWaspSound = nSoundCount;
        }
        Sound.szSoundName[Sound.nSoundCount] = name;
        SoundData soundData = audio.getSoundDecoder(entry.getExtension()).decode(entry);
        boolean loop = false;
        if (soundData != null) {
            if (soundData instanceof VOCDecoder.PSSoundData) {
                loop = ((VOCDecoder.PSSoundData)soundData).isLoop();
            }
        } else {
            Console.out.println("Could not open sound " + name, OsdColor.RED);
            soundData = new SoundData(8000, 1, 8, ByteBuffer.allocateDirect(0));
        }
        Sound.SoundBufs[Sound.nSoundCount] = new SoundResource(soundData, nSoundCount, loop);
        return nSoundCount++;
    }

    public static void sndHandlePause(boolean gPaused) {
        if (gPaused) {
            if (currMusic != null) {
                currMusic.pause();
            }
            Sound.StopAllSounds();
        } else if (!Main.cfg.isMuteMusic() && currMusic != null) {
            currMusic.play();
        }
    }

    public static void searchCDtracks() {
        cdTrackEntries.clear();
        Directory gameDir = Main.game.getCache().getGameDirectory();
        for (Entry file : gameDir) {
            if (!file.isExtension("cue")) continue;
            CueScript cueScript = new CueScript(file.getName(), file);
            for (String track : cueScript.getTracks()) {
                Entry entry = Main.game.getCache().getEntry(track, true);
                if (!entry.exists()) continue;
                cdTrackEntries.add(entry);
            }
            if (cdTrackEntries.isEmpty()) continue;
            break;
        }
        if (cdTrackEntries.isEmpty()) {
            for (String cdTrack : cdTrackList) {
                FileEntry entry = gameDir.getEntry(FileUtils.getPath("music", cdTrack));
                if (!entry.exists()) continue;
                cdTrackEntries.add(entry);
            }
        }
        if (!cdTrackEntries.isEmpty()) {
            Console.out.println(cdTrackEntries.size() + " cd tracks found...");
        } else {
            Console.out.println("Cd tracks not found.");
        }
    }

    public static boolean MusicPlaying() {
        return currMusic != null && currMusic.isPlaying();
    }

    public static void playCDtrack(int nTrack, boolean loop) {
        Music mus;
        if (nTrack < 0 || Main.cfg.isMuteMusic()) {
            return;
        }
        if (Sound.MusicPlaying() && currTrack == nTrack) {
            return;
        }
        if (userMusicEntry != null && (mus = Sound.newMusic(userMusicEntry)) != null) {
            Sound.StopMusic();
            currMusic = mus;
            currTrack = nTrack;
            currMusic.setLooping(loop);
            currMusic.play();
            return;
        }
        if (nTrack > 0 && nTrack <= cdTrackEntries.size() && (mus = Sound.newMusic(cdTrackEntries.get(nTrack - 1))) != null) {
            Sound.StopMusic();
            currMusic = mus;
            currTrack = nTrack;
            currMusic.setLooping(loop);
            currMusic.play();
        }
    }

    public static void sndCheckUserMusic(Entry map) {
        userMusicEntry = null;
        if (map != null && map.exists()) {
            String mMapName = map.getName();
            userMusicEntry = map.getParent().getEntry(mMapName.substring(0, mMapName.lastIndexOf(46)) + ".ogg");
        }
    }

    public static void sndPlayMusic() {
        if (Globals.mUserFlag != Main.UserFlag.UserMap) {
            int num = Globals.levelnum;
            if (Globals.levelnum != 0) {
                num = Globals.levelnum - 1;
            }
            Sound.playCDtrack(num % 8 + 11, true);
        } else if (!Sound.MusicPlaying()) {
            int num = (int)(Math.random() * 8.0 + 11.0);
            Sound.playCDtrack(num, true);
        }
    }

    public static void StopMusic() {
        if (currMusic != null) {
            currMusic.stop();
        }
        currTrack = -1;
        currMusic = null;
    }

    public static void StopAllSounds() {
        audio.stopAllSounds();
        for (ActiveSound activeSound : sActiveSound) {
            if (activeSound.pHandle != null) {
                activeSound.pHandle.stop();
            }
            activeSound.pHandle = null;
            activeSound.rate = 0;
        }
        nAmbientChannel = -1;
    }

    public static void PlayLocalSound(int soundid, int rateoffs) {
        Source hVoice;
        if (Main.cfg.isNoSound() || soundid < 0 || soundid >= SoundBufs.length) {
            return;
        }
        if (nAmbientChannel == nLocalChan) {
            nAmbientChannel = -1;
        }
        ActiveSound pSound = sActiveSound[nLocalChan];
        SoundResource res = SoundBufs[soundid];
        if (res == null) {
            return;
        }
        int rate = res.getRate();
        if (rateoffs != 0) {
            rate += rateoffs;
        }
        if (Sound.LocalSoundPlaying()) {
            Sound.StopLocalSound();
        }
        if ((hVoice = Sound.newSound(res.getBuffer(), rate, res.getBits(), 255)) != null) {
            if (res.loop) {
                hVoice.loop(255.0f);
            } else {
                hVoice.play(255.0f);
            }
            pSound.pHandle = hVoice;
            pSound.rate = rate;
            pSound.soundnum = soundid;
            Sound.SetLocalChan(0);
        }
    }

    public static void CheckAmbience(int sect) {
        if (Main.boardService.isValidSector(sect) && Globals.SectSound[sect] != -1) {
            int nSourceSect = Globals.SectSoundSect[sect];
            Sector sec = Main.boardService.getSector(nSourceSect);
            if (sec == null || sec.getWallNode() == null) {
                return;
            }
            Wall pWall = sec.getWallNode().get();
            if (nAmbientChannel < 0) {
                Sound.PlayFXAtXYZ(Globals.SectSound[sect] | 0x4000, pWall.getX(), pWall.getY(), sec.getFloorz(), sect);
                return;
            }
            ActiveSound pSound = sActiveSound[nAmbientChannel];
            if (sect == nSourceSect) {
                Sprite pPlayer = Main.boardService.getSprite(Globals.PlayerList[Globals.nLocalPlayer].spriteId);
                if (pPlayer != null) {
                    pSound.x = pPlayer.getX();
                    pSound.y = pPlayer.getY();
                    pSound.z = pPlayer.getZ();
                }
            } else {
                pSound.x = pWall.getX();
                pSound.y = pWall.getY();
                pSound.z = sec.getFloorz();
            }
            return;
        }
        if (nAmbientChannel != -1) {
            if (Sound.sActiveSound[Sound.nAmbientChannel].pHandle != null) {
                Sound.sActiveSound[Sound.nAmbientChannel].pHandle.stop();
            }
            Sound.sActiveSound[Sound.nAmbientChannel].pHandle = null;
            Sound.sActiveSound[Sound.nAmbientChannel].rate = 0;
            nAmbientChannel = -1;
        }
    }

    public static void StopLocalSound() {
        if (nLocalChan == nAmbientChannel) {
            nAmbientChannel = -1;
        }
        if (Sound.LocalSoundPlaying()) {
            Sound.sActiveSound[Sound.nLocalChan].pHandle.stop();
        }
        Sound.sActiveSound[Sound.nLocalChan].pHandle = null;
        Sound.sActiveSound[Sound.nLocalChan].rate = 0;
    }

    public static void StopSpriteSound(int nSprite) {
        if (Main.cfg.isNoSound()) {
            return;
        }
        for (int i = 0; i < sActiveSound.length; ++i) {
            if (!Sound.SoundPlaying(i) || nSprite != Sound.sActiveSound[i].spr) continue;
            Sound.sActiveSound[i].pHandle.stop();
            Sound.sActiveSound[i].pHandle = null;
            Sound.sActiveSound[i].rate = 0;
            break;
        }
    }

    public static void BendAmbientSound() {
        if (Main.cfg.isNoSound()) {
            return;
        }
        if (nAmbientChannel >= 0) {
            ActiveSound pSound = sActiveSound[nAmbientChannel];
            if (pSound.pHandle != null) {
                pSound.pHandle.setPitch((float)(Globals.nDronePitch + 11000) / (float)pSound.rate);
            }
        }
    }

    public static void PlayFXAtXYZ(int soundid, int x, int y, int z, int sect) {
        if (Main.cfg.isNoSound()) {
            return;
        }
        soundx = x;
        soundy = y;
        soundz = z;
        soundsect = sect & Engine.MAXSECTORS - 1;
        int num = Sound.PlayFX2(soundid, -1);
        if (num != -1 && (sect & 0x4000) != 0) {
            Sound.sActiveSound[num].asound_C = 2000;
        }
    }

    public static void D3PlayFX(int soundid, int nSprite) {
        Sound.PlayFX2(soundid, nSprite);
    }

    public static int PlayFX2(int soundid, int nSprite) {
        int vol;
        if (Main.cfg.isNoSound()) {
            return -1;
        }
        nLocalSectFlags = Globals.SectFlag[Globals.nPlayerViewSect[Globals.nLocalPlayer]];
        boolean v33 = false;
        boolean v11 = false;
        if (nSprite >= 0) {
            v33 = (nSprite & 0x2000) != 0;
            v11 = (nSprite & 0x4000) != 0;
            Sprite pSprite = Main.boardService.getSprite(nSprite &= 0xFFF);
            if (pSprite != null) {
                soundx = pSprite.getX();
                soundy = pSprite.getY();
                soundz = pSprite.getZ();
                soundsect = pSprite.getSectnum();
            }
        }
        int dx = Globals.initx - soundx >> 8;
        int dy = Globals.inity - soundy >> 8;
        int dist = Sound.GetDistFromDXDY(dx, dy);
        int n = vol = v33 ? 255 : Gameutils.BClipRange(265 - (EngineUtils.sin(2 * dist & 0x7FF) >> 6), 0, 255);
        if (dist >= 255 || vol == 0) {
            if (nSprite >= 0) {
                Sound.StopSpriteSound(nSprite);
            }
            return -1;
        }
        int v37 = soundid & 0xFE00;
        boolean v39 = (soundid & 0x2000) != 0;
        boolean v38 = (soundid & 0x1000) != 0;
        boolean v35 = (soundid & 0x4000) != 0;
        int v29 = Integer.MAX_VALUE;
        int v36 = (soundid & 0xE00) >> 9;
        soundid &= 0x1FF;
        int v32 = 0;
        if (v38 || v35) {
            v32 = 1000;
        } else if (nSprite != -1 && v11) {
            v32 = 2000;
        }
        int nFree = 0;
        int v30 = 0;
        int v26 = 0;
        if (soundid >= SoundBufs.length) {
            return -1;
        }
        for (int i = 1; i < sActiveSound.length; ++i) {
            if (Sound.SoundPlaying(i)) {
                ActiveSound pSound = sActiveSound[i];
                if (v32 < pSound.asound_C) continue;
                if (v29 > pSound.clock && pSound.asound_C == v32) {
                    v30 = i;
                    v29 = pSound.clock;
                }
                if (v38) continue;
                if (soundid == pSound.soundnum) {
                    if (!v39 && nSprite == pSound.spr) {
                        return -1;
                    }
                    v26 = i;
                    continue;
                }
                if (nSprite != pSound.spr) continue;
                nFree = i;
                break;
            }
            nFree = i;
        }
        while (true) {
            if (nFree != 0) {
                SoundResource res;
                ActiveSound pFree = sActiveSound[nFree];
                if (pFree.pHandle != null && pFree.pHandle.isActive()) {
                    pFree.pHandle.stop();
                    if (pFree.ambchannel == nAmbientChannel) {
                        nAmbientChannel = -1;
                    }
                    pFree.pHandle = null;
                    pFree.rate = 0;
                }
                if ((res = SoundBufs[soundid]) == null) {
                    return -1;
                }
                if (!Main.cfg.bWaspSound && soundid == nWaspSound) {
                    return -1;
                }
                int rate = res.getRate();
                int pitch = 0;
                if (v36 != 0) {
                    pitch = -16 * (Globals.totalmoves & (1 << v36) - 1);
                }
                if (pitch != 0) {
                    rate += pitch;
                }
                pFree.oldpitch = pitch += rate;
                pFree.oldvolume = vol;
                if (nSprite < 0) {
                    pFree.x = soundx;
                    pFree.y = soundy;
                    pFree.z = soundz;
                    pFree.sectnum = soundsect;
                }
                Sound.GetSpriteSoundPitch(soundsect, vol, pitch);
                pFree.pitch = pSoundPitch;
                pFree.volume = pSoundVolume;
                pFree.spr = nSprite;
                pFree.soundnum = soundid;
                pFree.clock = Main.engine.getTotalClock();
                pFree.asound_C = v32;
                pFree.ambient = v37;
                boolean isPlayer = nSprite == Globals.PlayerList[Globals.nLocalPlayer].spriteId;
                Source hVoice = Sound.newSound(res.getBuffer(), rate, res.getBits(), isPlayer ? 255 : dist);
                if (hVoice != null) {
                    if (!isPlayer) {
                        hVoice.setPosition(soundx, soundz >> 4, soundy);
                    }
                    hVoice.setListener(pFree);
                    if (res.loop) {
                        hVoice.loop((float)vol / 255.0f);
                    } else {
                        hVoice.play((float)vol / 255.0f);
                    }
                    if (v35) {
                        nAmbientChannel = pFree.ambchannel;
                    }
                    Sprite pSprite = Main.boardService.getSprite(nSprite);
                    if (!isPlayer && pSprite != null && (pSprite.getCstat() & 0x101) != 0) {
                        Globals.nCreepyTimer = 180;
                    }
                    pFree.pHandle = hVoice;
                    pFree.rate = rate;
                    return pFree.ambchannel;
                }
                return -1;
            }
            if (v26 != 0) {
                nFree = v26;
                continue;
            }
            if (v30 == 0) break;
            nFree = v30;
        }
        return -1;
    }

    public static int GetDistFromDXDY(int dx, int dy) {
        return (dx * dx + dy * dy >> 3) - (dx * dx + dy * dy >> 5);
    }

    public static void StartSwirlies() {
        if (Main.cfg.isNoSound()) {
            return;
        }
        Sound.StopAllSounds();
        nNextFreq = 19000;
        nSwirlyFrames = 0;
        for (int i = 1; i <= 4; ++i) {
            Sound.StartSwirly(i);
        }
    }

    private static void StartSwirly(int nSwirly) {
        ActiveSound pSound = sActiveSound[nSwirly];
        pSound.panning &= 0x7FF;
        pSound.oldpitch = nNextFreq - Random.RandomSize(9);
        nNextFreq = Math.min(25000 - 6 * Random.RandomSize(10), 32000);
        SoundResource res = SoundBufs[StaticSound[67]];
        if (res == null) {
            return;
        }
        pSound.pHandle = Sound.newSound(res.getBuffer(), pSound.oldpitch, res.getBits(), 255);
        Source pHandle = pSound.pHandle;
        if (pHandle != null) {
            pHandle.setPosition(pSound.panning * 6000, 0, 0);
            pHandle.setListener(pSound);
            pHandle.play((float)Math.min(nSwirlyFrames + 1, 220) / 220.0f);
            pSound.rate = pSound.oldpitch;
        }
    }

    public static void UpdateSwirlies() {
        if (Main.cfg.isNoSound()) {
            return;
        }
        ++nSwirlyFrames;
        int nSound = 1;
        int nShift = 5;
        for (int i = 1; i <= 4; ++i) {
            ActiveSound pSound = sActiveSound[nSound++];
            if (pSound.pHandle == null || !pSound.pHandle.isActive()) {
                Sound.StartSwirly(i);
            }
            if (pSound.pHandle != null) {
                pSound.panning = (EngineUtils.sin(Main.engine.getTotalClock() << nShift & 0x7FF) >> 8) * 6000;
                pSound.pHandle.setVolume((float)Math.min(nSwirlyFrames + 1, 220) / 220.0f);
                pSound.pHandle.setPosition(pSound.panning, 0, pSound.panning);
            }
            ++nShift;
        }
    }

    public static void SoundBigEntrance() {
        if (Main.cfg.isNoSound()) {
            return;
        }
        Sound.StopAllSounds();
        int rate = -1200;
        for (int i = 0; i < 4; ++i) {
            SoundResource res = SoundBufs[12];
            if (res == null) {
                return;
            }
            ActiveSound pSound = sActiveSound[i];
            pSound.pHandle = Sound.newSound(res.getBuffer(), rate + 11000, res.getBits(), 255);
            Source pHandle = pSound.pHandle;
            if (pHandle == null) {
                return;
            }
            pSound.oldpitch = rate;
            pHandle.setPosition(63 - 127 * (i & 1), 0, 0);
            pHandle.setListener(pSound);
            pHandle.play(200.0f);
            pSound.rate = rate + 11000;
            rate += 512;
        }
    }

    private static boolean SoundPlaying(int num) {
        return num >= 0 && num < sActiveSound.length && Sound.sActiveSound[num].pHandle != null && Sound.sActiveSound[num].pHandle.isActive();
    }

    public static boolean LocalSoundPlaying() {
        return Sound.SoundPlaying(nLocalChan);
    }

    public static int GetLocalSound() {
        if (!Sound.LocalSoundPlaying()) {
            return -1;
        }
        return Sound.sActiveSound[Sound.nLocalChan].soundnum & 0x1FF;
    }

    public static void SetLocalChan(int channel) {
        if (channel >= 0 && channel < sActiveSound.length) {
            nLocalChan = channel;
        }
    }

    public static void PlayLogoSound() {
        Sound.PlayLocalSound(StaticSound[28], 7000);
    }

    public static void PlayGameOverSound() {
        Sound.PlayLocalSound(StaticSound[28], 0);
    }

    public static void UpdateSounds() {
        Sprite pPlayer;
        Sprite pSnake;
        if (Main.cfg.isNoSound() || Globals.nFreeze != 0) {
            if (Globals.nFreeze != 0) {
                audio.setListener(0, 0, 0, 0);
            }
            return;
        }
        nLocalSectFlags = Globals.SectFlag[Globals.nPlayerViewSect[Globals.nLocalPlayer]];
        int earx = Globals.initx;
        int eary = Globals.inity;
        int earz = Globals.initz;
        int earang = Globals.inita;
        if (Globals.nSnakeCam >= 0 && (pSnake = Main.boardService.getSprite(Snake.SnakeList[Globals.nSnakeCam].nSprite[0])) != null) {
            earx = pSnake.getX();
            eary = pSnake.getY();
            earz = pSnake.getZ();
            earang = pSnake.getAng();
        }
        audio.setListener(earx, earz >> 4, eary, earang);
        for (int i = 1; i < sActiveSound.length; ++i) {
            int dist;
            int dy;
            int dx;
            Sprite spr;
            if (!Sound.SoundPlaying(i)) continue;
            ActiveSound pSound = sActiveSound[i];
            Source pHandle = pSound.pHandle;
            Sprite sprite = spr = pSound.spr >= 0 ? Main.boardService.getSprite(pSound.spr) : null;
            if (spr != null) {
                dx = earx - spr.getX();
                dy = eary - spr.getY();
                if (spr != Main.boardService.getSprite(Globals.PlayerList[Globals.nLocalPlayer].spriteId)) {
                    pHandle.setPosition(spr.getX(), spr.getZ() >> 4, spr.getY());
                }
            } else {
                dx = earx - pSound.x;
                dy = eary - pSound.y;
                pHandle.setPosition(pSound.x, pSound.z >> 4, pSound.y);
            }
            if ((dist = Sound.GetDistFromDXDY(dx >> 8, dy >> 8)) >= 255) {
                pHandle.stop();
                if ((pSound.ambient & 0x4000) != 0) {
                    nAmbientChannel = -1;
                }
                return;
            }
            int vol = Gameutils.BClipRange(265 - (EngineUtils.sin(2 * dist & 0x7FF) >> 6), 0, 255);
            int pitch = pSound.oldpitch;
            int sectnum = pSound.sectnum;
            if (spr != null) {
                sectnum = spr == Main.boardService.getSprite(Globals.PlayerList[Globals.nLocalPlayer].spriteId) ? Globals.nPlayerViewSect[Globals.nLocalPlayer] : (int)spr.getSectnum();
            }
            Sound.GetSpriteSoundPitch(sectnum, vol, pitch);
            vol = pSoundVolume;
            pitch = pSoundPitch;
            if (pSound.pitch != pitch) {
                pSound.pitch = pitch;
            }
            if (vol == pSound.volume) continue;
            if (pitch < 0) {
                pitch = 7000;
            }
            pHandle.setPitch((float)pitch / (float)pSound.rate);
            pHandle.setVolume((float)vol / 255.0f);
            pSound.volume = vol;
        }
        if (Globals.nFreeze != 0 || Globals.levelnum == 20 || --Globals.nCreepyTimer > 0) {
            return;
        }
        if (Globals.nCreaturesLeft > 0 && (Globals.SectFlag[Globals.nPlayerViewSect[Globals.nLocalPlayer]] & 0x2000) == 0 && (pPlayer = Main.boardService.getSprite(Globals.PlayerList[Globals.nLocalPlayer].spriteId)) != null) {
            int soundId = Sound.GetFrameSound(Seq.SeqOffsets[65], Globals.totalmoves % Seq.SeqSize[Seq.SeqOffsets[65]]);
            int sx = Globals.totalmoves + 32 & 0x1F;
            if ((Globals.totalmoves & 1) != 0) {
                sx = -sx;
            }
            int sy = Globals.totalmoves + 32 & 0x3F;
            if ((Globals.totalmoves & 2) != 0) {
                sy = -sy;
            }
            Sound.PlayFXAtXYZ(soundId, pPlayer.getX() + sx, sy + pPlayer.getY(), pPlayer.getZ(), pPlayer.getSectnum());
        }
        Globals.nCreepyTimer = 180;
    }

    public static Source newSound(ByteBuffer buffer, int rate, int bits, int priority) {
        return (Source)audio.newSound(buffer, rate, bits, priority);
    }

    public static Music newMusic(Entry file) {
        return audio.newMusic(file);
    }

    static {
        nAmbientChannel = -1;
        currTrack = -1;
        currMusic = null;
    }

    public static class ActiveSound
    implements SourceListener {
        public Source pHandle;
        public int rate;
        public int spr;
        public int x;
        public int y;
        public int z;
        public int oldvolume;
        public int volume;
        public int panning;
        public int oldpitch;
        public int pitch;
        public int soundnum;
        public int asound_C;
        public int clock;
        public int ambient;
        public int ambchannel;
        public int sectnum;

        @Override
        public void onStop() {
            if (this.pHandle != null) {
                this.pHandle.stop();
            }
            this.pHandle = null;
            this.rate = 0;
        }
    }
}

