/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Powerslave.Anim;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Object;
import ru.m210projects.Powerslave.PSSector;
import ru.m210projects.Powerslave.Player;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Type.BubbleMachineStruct;
import ru.m210projects.Powerslave.Type.BubbleStruct;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class Sprites {
    public static final int[] nBodySprite = new int[50];
    public static int nCurBodyNum;
    public static int nBodyTotal;
    public static final int[] nChunkSprite;
    public static final int[] nBodyGunSprite;
    public static int nCurChunkNum;
    public static int nCurBodyGunNum;
    public static int nChunkTotal;
    public static int word_96760;
    private static final int[] wheresMyMouth;

    public static void InitChunks() {
        nCurChunkNum = 0;
        Arrays.fill(nChunkSprite, -1);
        Arrays.fill(nBodyGunSprite, -1);
        Arrays.fill(nBodySprite, -1);
        nCurBodyNum = 0;
        nCurBodyGunNum = 0;
        nBodyTotal = 0;
        nChunkTotal = 0;
    }

    public static int GrabBody() {
        int nSprite;
        Sprite spr;
        do {
            if ((spr = Main.boardService.getSprite(nSprite = nBodySprite[nCurBodyNum])) == null) {
                Sprites.nBodySprite[Sprites.nCurBodyNum] = nSprite = Main.engine.insertsprite(0, 899);
                spr = Main.boardService.getSprite(nSprite);
                if (spr == null) {
                    return -1;
                }
                spr.setCstat(32768);
            }
            if (++nCurBodyNum < 50) continue;
            nCurBodyNum = 0;
        } while ((spr.getCstat() & 0x101) != 0);
        if (nBodyTotal < 50) {
            ++nBodyTotal;
        }
        spr.setCstat(0);
        return nSprite;
    }

    public static boolean GrabItem(int nPlayer, int nItem) {
        if (Globals.PlayerList[nPlayer].ItemsAmount[nItem] < 5) {
            int n = nItem;
            Globals.PlayerList[nPlayer].ItemsAmount[n] = (byte)(Globals.PlayerList[nPlayer].ItemsAmount[n] + 1);
            if (Globals.nPlayerItem[nPlayer] < 0 || nItem == Globals.nPlayerItem[nPlayer]) {
                Player.SetPlayerItem(nPlayer, nItem);
            }
            return true;
        }
        return false;
    }

    public static int CheckRadialDamage(int a1) {
        Sprite v2;
        int v13 = 0;
        if (a1 != Globals.nRadialSpr && (v2 = Main.boardService.getSprite(a1)) != null && (v2.getCstat() & 0x101) != 0) {
            short v3 = v2.getStatnum();
            Sprite v4 = Main.boardService.getSprite(Globals.nRadialSpr);
            if (v4 != null && v3 < 1024 && v4.getStatnum() < 1024 && (v3 == 100 || a1 != Globals.nRadialOwner)) {
                int v19;
                int v5 = v2.getX() - v4.getX() >> 8;
                int v18 = v2.getY() - v4.getY() >> 8;
                int v8 = v2.getZ() - v4.getZ() >> 12;
                if (Pragmas.klabs(v5) <= Globals.nDamageRadius && Pragmas.klabs(v18) <= Globals.nDamageRadius && Pragmas.klabs(v8) <= Globals.nDamageRadius && (v19 = EngineUtils.sqrt(v5 * v5 + v18 * v18)) < Globals.nDamageRadius) {
                    short oldcstat = v2.getCstat();
                    v2.setCstat(257);
                    if ((152 - v2.getStatnum() <= 1 || Main.engine.cansee(v4.getX(), v4.getY(), v4.getZ() - 512, v4.getSectnum(), v2.getX(), v2.getY(), v2.getZ() - 8192, v2.getSectnum())) && (v13 = Globals.nRadialDamage * (Globals.nDamageRadius - v19) / Globals.nDamageRadius) > 20) {
                        int ang = Main.engine.GetMyAngle(v5, v18);
                        v2.setXvel(v2.getXvel() + (v13 * EngineUtils.sin(ang + 512 & 0x7FF) >> 3));
                        v2.setYvel(v2.getYvel() + (v13 * EngineUtils.sin(ang & 0x7FF) >> 3));
                        v2.setZvel(Gameutils.BClipLow(v2.getZvel() - 24 * v13, -3584));
                    }
                    v2.setCstat(oldcstat);
                }
            }
        }
        return v13;
    }

    public static void DestroyItemAnim(int nItem) {
        Sprite pItem = Main.boardService.getSprite(nItem);
        if (pItem == null || pItem.getOwner() < 0 || pItem.getOwner() >= 400) {
            return;
        }
        Anim.DestroyAnim(pItem.getOwner());
    }

    public static void ExplodeScreen(int a1) {
        Sprite spr = Main.boardService.getSprite(a1);
        if (spr == null) {
            return;
        }
        spr.setZ(spr.getZ() - Sprites.GetSpriteHeight(a1) / 2);
        for (int i = 0; i < 30; ++i) {
            Object.BuildSpark(a1, 0);
        }
        spr.setCstat(32768);
        Sound.PlayFX2(Sound.StaticSound[78], a1);
    }

    public static int GrabChunkSprite() {
        int nSprite = nChunkSprite[nCurChunkNum];
        Sprite spr = Main.boardService.getSprite(nSprite);
        if (spr == null) {
            nSprite = Main.engine.insertsprite(0, 899);
            spr = Main.boardService.getSprite(nSprite);
            Sprites.nChunkSprite[Sprites.nCurChunkNum] = nSprite;
        } else if (spr.getStatnum() != 0) {
            System.err.println("too many chunks being used at once!");
            return -1;
        }
        Main.engine.changespritestat(nSprite, 899);
        if (++nCurChunkNum >= 75) {
            nCurChunkNum = 0;
        }
        if (nChunkTotal < 75) {
            ++nChunkTotal;
        }
        if (spr != null) {
            spr.setCstat(128);
        }
        return nSprite;
    }

    public static int BuildCreatureChunk(int nSprite, int a1) {
        int spr = Sprites.GrabChunkSprite();
        Sprite v6 = Main.boardService.getSprite(spr);
        boolean v15 = false;
        if (v6 != null) {
            Sprite v7;
            if ((nSprite & 0x4000) != 0) {
                nSprite &= 0xFFFFBFFF;
                v15 = true;
            }
            if ((v7 = Main.boardService.getSprite(nSprite)) == null) {
                return -1;
            }
            v6.setX(v7.getX());
            v6.setY(v7.getY());
            v6.setZ(v7.getZ());
            Main.engine.mychangespritesect(spr, v7.getSectnum());
            v6.setCstat(128);
            v6.setShade(-12);
            v6.setPal(0);
            v6.setXvel((Random.RandomSize(5) - 16 & 0xFFFF) << 7);
            v6.setYvel((Random.RandomSize(5) - 16 & 0xFFFF) << 7);
            v6.setZvel(-8 * (Random.RandomSize(8) + 512));
            if (v15) {
                v6.setXvel(v6.getXvel() * 4);
                v6.setYvel(v6.getYvel() * 4);
                v6.setZvel(v6.getZvel() * 2);
            }
            v6.setXrepeat(64);
            v6.setYrepeat(64);
            v6.setXoffset(0);
            v6.setYoffset(0);
            v6.setPicnum(a1);
            v6.setLotag(RunList.HeadRun() + 1);
            v6.setClipdist(40);
            v6.setExtra(-1);
            v6.setOwner(RunList.AddRunRec(v6.getLotag() - 1, 0xD0000 | spr));
            v6.setHitag(RunList.AddRunRec(RunList.NewRun, 0xD0000 | spr));
        }
        return spr;
    }

    public static void FuncCreatureChunk(int nStack, int ignored, int RunPtr) {
        int spr = RunList.RunData[RunPtr].getObject();
        Sprite sprite = Main.boardService.getSprite(spr);
        if (sprite == null) {
            throw new AssertException("spr>=0 && spr<MAXSPRITES");
        }
        if ((nStack & 0x7F0000) == 131072) {
            Sector sec = Main.boardService.getSector(sprite.getSectnum());
            if (sec != null) {
                Sprites.Gravity(spr);
                sprite.setPal(sec.getCeilingpal());
                int hitMove = Main.engine.movesprite(spr, sprite.getXvel() << 10, sprite.getYvel() << 10, sprite.getZvel(), 2560, -2560, 1);
                if (sprite.getZ() < sec.getFloorz()) {
                    if (hitMove == 0) {
                        return;
                    }
                    if ((hitMove & 0x20000) == 0) {
                        int ang;
                        switch (hitMove & 0x3C000) {
                            default: {
                                return;
                            }
                            case 32768: {
                                ang = Main.engine.GetWallNormal(hitMove & 0x1FFF);
                                break;
                            }
                            case 49152: {
                                Sprite hitSprite = Main.boardService.getSprite(hitMove & 0x1FFF);
                                if (hitSprite == null) {
                                    return;
                                }
                                ang = hitSprite.getAng();
                                break;
                            }
                            case 65536: {
                                sprite.setXvel(sprite.getXvel() >> 1);
                                sprite.setYvel(sprite.getYvel() >> 1);
                                sprite.setZvel(-sprite.getZvel());
                                return;
                            }
                        }
                        int v20 = EngineUtils.sqrt((sprite.getYvel() >> 10) * (sprite.getYvel() >> 10) + (sprite.getXvel() >> 10) * (sprite.getXvel() >> 10) >> 8) >> 1;
                        sprite.setXvel(v20 * EngineUtils.sin(ang + 512 & 0x7FF));
                        sprite.setYvel(v20 * EngineUtils.sin(ang & 0x7FF));
                        return;
                    }
                    sprite.setCstat(32768);
                } else {
                    sprite.setXvel(0);
                    sprite.setYvel(0);
                    sprite.setZvel(0);
                    sprite.setZ(sec.getFloorz());
                }
            }
            RunList.DoSubRunRec(sprite.getOwner());
            if (sprite.getLotag() > 0) {
                RunList.FreeRun(sprite.getLotag() - 1);
            }
            RunList.SubRunRec(sprite.getHitag());
            Main.engine.changespritestat(spr, 0);
            sprite.setHitag(0);
            sprite.setLotag(0);
        }
    }

    public static void Gravity(int nSprite) {
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        if (Main.boardService.isValidSector(pSprite.getSectnum()) && (Globals.SectFlag[pSprite.getSectnum()] & 0x2000) != 0) {
            if (pSprite.getStatnum() == 100) {
                if (pSprite.getZvel() > 0) {
                    pSprite.setZvel(pSprite.getZvel() - 64);
                    if (pSprite.getZvel() < 0) {
                        pSprite.setZvel(0);
                    }
                } else if (pSprite.getZvel() < 0) {
                    pSprite.setZvel(pSprite.getZvel() + 64);
                    if (pSprite.getZvel() > 0) {
                        pSprite.setZvel(0);
                    }
                }
            } else if (pSprite.getZvel() <= 1024) {
                pSprite.setZvel(pSprite.getZvel() + 512);
            } else {
                pSprite.setZvel(pSprite.getZvel() - 64);
            }
        } else {
            pSprite.setZvel(pSprite.getZvel() + 512);
            pSprite.setZvel(Gameutils.BClipHigh((int)pSprite.getZvel(), 16384));
        }
    }

    public static void DamageEnemy(int nDest, int nSource, int nDamage) {
        int left = Globals.nCreaturesLeft;
        Sprite pDest = Main.boardService.getSprite(nDest);
        if (pDest != null && pDest.getStatnum() < 1024 && pDest.getOwner() > -1) {
            Sprite pSource;
            RunList.SendMessageToRunRec(pDest.getOwner(), 0x80000 | nSource & 0xFFFF, 4 * nDamage);
            if (left > Globals.nCreaturesLeft && (pSource = Main.boardService.getSprite(nSource)) != null && pSource.getStatnum() == 100) {
                int plr;
                int n = plr = Player.GetPlayerFromSprite(nSource);
                Globals.nTauntTimer[n] = Globals.nTauntTimer[n] - 1;
                if (Globals.nTauntTimer[plr] <= 0) {
                    if (Globals.SectFlag[Globals.PlayerList[plr].getSprite().getSectnum() & 0x2000] == 0) {
                        Sound.D3PlayFX(Sound.StaticSound[Random.RandomSize(3) % 5 + 53], Globals.nDoppleSprite[plr] | (plr == Globals.nLocalPlayer ? 24576 : 16384));
                    }
                    Globals.nTauntTimer[plr] = Random.RandomSize(3) + 3;
                }
            }
        }
    }

    public static void RadialDamageEnemy(int nSprite, int damage, int radius) {
        if (radius != 0) {
            ++word_96760;
            if (Globals.nRadialSpr == -1) {
                Globals.nRadialDamage = 4 * damage;
                Globals.nDamageRadius = radius;
                Globals.nRadialSpr = nSprite;
                Sprite pRadialSpr = Main.boardService.getSprite(nSprite);
                Globals.nRadialOwner = pRadialSpr != null ? (int)pRadialSpr.getOwner() : -1;
                RunList.ExplodeSignalRun();
                Globals.nRadialSpr = -1;
                --word_96760;
            }
        }
    }

    public static int GetAngleToSprite(Sprite spr1, Sprite spr2) {
        if (spr1 != null && spr2 != null) {
            return Main.engine.GetMyAngle(spr2.getX() - spr1.getX(), spr2.getY() - spr1.getY());
        }
        return -1;
    }

    public static int GetSpriteHeight(int num) {
        Sprite spr = Main.boardService.getSprite(num);
        if (spr == null) {
            return 0;
        }
        return 4 * spr.getYrepeat() * Main.engine.getTile(spr.getPicnum()).getHeight();
    }

    public static void BuildSplash(Sprite pSprite, int sectnum) {
        int v10;
        int v9;
        int v6;
        int v5;
        if (pSprite == null) {
            return;
        }
        if (pSprite.getStatnum() == 200) {
            v5 = 20;
            v6 = 1;
        } else {
            v5 = Random.RandomWord() % pSprite.getXrepeat() + pSprite.getXrepeat();
            v6 = 0;
        }
        if ((Globals.SectFlag[sectnum] & 0x4000) != 0) {
            v9 = 43;
            v10 = 4;
        } else {
            v9 = 35;
            v10 = 0;
        }
        Sector sec = Main.boardService.getSector(sectnum);
        if (sec != null) {
            int v11 = Anim.AnimList[Anim.BuildAnim((int)-1, (int)v9, (int)0, (int)pSprite.getX(), (int)pSprite.getY(), (int)sec.getFloorz(), (int)sectnum, (int)v5, (int)v10)].nSprite;
            if ((Globals.SectFlag[sectnum] & 0x4000) == 0) {
                Sound.D3PlayFX(Sound.StaticSound[v6] | 0xA00, v11);
            }
        }
    }

    public static int AngleChase(int nSprite, int nTarget, int a3, int a4, int a5) {
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return 0;
        }
        int nNewAngle = pSprite.getAng();
        Sprite pTarget = Main.boardService.getSprite(nTarget);
        if (pTarget != null) {
            int zTop = 2 * pTarget.getYrepeat() * Main.engine.getTile(pTarget.getPicnum()).getHeight();
            int dx = pTarget.getX() - pSprite.getX();
            int dy = pTarget.getY() - pSprite.getY();
            int dz = pTarget.getZ() - pSprite.getZ();
            int nGoalAngle = Sprites.AngleDelta(pSprite.getAng(), Main.engine.GetMyAngle(dx, dy), 1024);
            if (Pragmas.klabs(nGoalAngle) > 63 && (a3 /= Pragmas.klabs(nGoalAngle >> 6)) < 5) {
                a3 = 5;
            }
            if (Pragmas.klabs(nGoalAngle) > a5) {
                nGoalAngle = nGoalAngle >= 0 ? a5 : -a5;
            }
            nNewAngle = pSprite.getAng() + nGoalAngle & 0x7FF;
            pSprite.setZvel(pSprite.getZvel() + Sprites.AngleDelta(pSprite.getZvel(), Main.engine.GetMyAngle(EngineUtils.sqrt(dx * dx + dy * dy), dz - zTop >> 8), 24) & 0x7FF);
        } else {
            pSprite.setZvel(0);
        }
        pSprite.setAng(nNewAngle);
        int v28 = Pragmas.klabs(EngineUtils.sin(pSprite.getZvel() + 512 & 0x7FF));
        int xvel = v28 * (a3 * EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) >> 14);
        int yvel = v28 * (a3 * EngineUtils.sin(pSprite.getAng() & 0x7FF) >> 14);
        int v31 = EngineUtils.sqrt((xvel >> 8) * (xvel >> 8) + (yvel >> 8) * (yvel >> 8));
        return Main.engine.movesprite(nSprite, xvel >> 2, yvel >> 2, (EngineUtils.sin(a4 & 0x7FF) >> 5) + (v31 * EngineUtils.sin(pSprite.getZvel() & 0x7FF) >> 13), 0, 0, pSprite.getStatnum() != 107 ? 1 : 0);
    }

    public static int AngleDelta(int ang1, int ang2, int a3) {
        int dang = ang2 - ang1;
        if (dang >= 0) {
            if (dang > 1024) {
                dang = -(2048 - dang);
            }
        } else if (dang < -1024) {
            dang += 2048;
        }
        if (Pragmas.klabs(dang) > a3) {
            return dang < 0 ? -a3 : a3;
        }
        return dang;
    }

    public static int AngleDiff(int a1, int a2) {
        int result = a2 - a1 & 0x7FF;
        if (result > 1024) {
            result = 2048 - result;
        }
        return result;
    }

    public static int BelowNear(Sprite pSprite, int lohit) {
        int v10;
        int nSector = pSprite.getSectnum();
        Sector sec = Main.boardService.getSector(nSector);
        if (sec == null) {
            return 0;
        }
        int z = 0;
        if ((lohit & 0xE000) == 49152) {
            v10 = 49152;
            Sprite pHit = Main.boardService.getSprite(lohit & 0x1FFF);
            if (pHit != null) {
                z = pHit.getZ();
            }
        } else {
            v10 = 131072;
            z = (Globals.SectDepth[pSprite.getSectnum()] & 0xFFFF) + sec.getFloorz();
            if (PSSector.NearCount > 0) {
                int a2 = PSSector.NearSector[0];
                for (int i = 0; i < PSSector.NearCount; ++i) {
                    int v7;
                    int v8;
                    int j = PSSector.NearSector[i];
                    while (j >= 0) {
                        a2 = j;
                        j = Globals.SectBelow[j];
                    }
                    Sector s = Main.boardService.getSector(a2);
                    if (s == null || (v8 = (v7 = (Globals.SectDepth[a2] & 0xFFFF) + s.getFloorz()) - pSprite.getZ()) >= 0 || v8 < -5120) continue;
                    z = v7;
                    nSector = a2;
                }
            }
        }
        if (z >= pSprite.getZ()) {
            v10 = 0;
        } else {
            pSprite.setZ(z);
            PSSector.overridesect = nSector;
            pSprite.setZvel(0);
            Globals.bTouchFloor[0] = true;
        }
        return v10;
    }

    public static void BuildNear(int x, int y, int walldist, short sectnum) {
        PSSector.NearSector[0] = sectnum;
        PSSector.NearCount = 1;
        for (int j = 0; j < PSSector.NearCount; ++j) {
            Sector s = Main.boardService.getSector(PSSector.NearSector[j]);
            if (s == null) continue;
            int nWall = s.getWallptr();
            int nWalls = s.getWallnum();
            while (--nWalls >= 0) {
                short v8;
                Wall wall = Main.boardService.getWall(nWall);
                if (wall != null && (v8 = wall.getNextsector()) >= 0) {
                    int i;
                    for (i = 0; i < PSSector.NearCount && v8 != PSSector.NearSector[i]; ++i) {
                    }
                    if (i >= PSSector.NearCount && Main.engine.clipinsidebox(x, y, nWall, walldist) != 0) {
                        PSSector.NearSector[PSSector.NearCount] = v8;
                        ++PSSector.NearCount;
                    }
                }
                ++nWall;
            }
        }
    }

    public static void InitBubbles() {
        Globals.nMachineCount = 0;
        for (int i = 0; i < 200; ++i) {
            Globals.nBubblesFree[i] = (byte)i;
            if (Globals.BubbleList[i] == null) continue;
            Globals.BubbleList[i].nSprite = -1;
        }
        Globals.nFreeCount = 200;
    }

    public static void saveBubbles(OutputStream os) throws IOException {
        int i;
        int nBubbles = 0;
        for (i = 0; i < 200; ++i) {
            if (Globals.BubbleList[i] == null || Globals.BubbleList[i].nSprite == -1) continue;
            ++nBubbles;
        }
        StreamUtils.writeShort(os, Globals.nMachineCount);
        StreamUtils.writeShort(os, Globals.nFreeCount);
        for (i = 0; i < 200; ++i) {
            StreamUtils.writeByte(os, Globals.nBubblesFree[i]);
        }
        if (nBubbles != 0) {
            for (i = 0; i < 200; ++i) {
                if (Globals.BubbleList[i] == null || Globals.BubbleList[i].nSprite == -1) continue;
                StreamUtils.writeShort(os, i);
                Globals.BubbleList[i].save(os);
            }
        }
        for (i = 0; i < Globals.nMachineCount; ++i) {
            Globals.Machine[i].save(os);
        }
    }

    public static void loadBubbles(SafeLoader loader) {
        int i;
        Globals.nMachineCount = loader.nMachineCount;
        Globals.nFreeCount = loader.nFreeCount;
        System.arraycopy(loader.nBubblesFree, 0, Globals.nBubblesFree, 0, Globals.nBubblesFree.length);
        for (i = 0; i < 200; ++i) {
            if (Globals.BubbleList[i] != null) {
                Globals.BubbleList[i].nSprite = -1;
            }
            if (loader.BubbleList[i] == null || loader.BubbleList[i].nSprite == -1) continue;
            if (Globals.BubbleList[i] == null) {
                Globals.BubbleList[i] = new BubbleStruct();
            }
            Globals.BubbleList[i].copy(loader.BubbleList[i]);
        }
        for (i = 0; i < loader.nMachineCount; ++i) {
            if (Globals.Machine[i] == null) {
                Globals.Machine[i] = new BubbleMachineStruct();
            }
            Globals.Machine[i].copy(loader.Machine[i]);
        }
    }

    public static void loadBubbles(SafeLoader loader, InputStream is) throws IOException {
        int i;
        for (int i2 = 0; i2 < 200; ++i2) {
            if (loader.BubbleList[i2] == null) continue;
            loader.BubbleList[i2].nSprite = -1;
        }
        loader.nMachineCount = StreamUtils.readShort(is);
        loader.nFreeCount = StreamUtils.readShort(is);
        StreamUtils.readBytes(is, loader.nBubblesFree);
        for (int nBubbles = 200 - loader.nFreeCount; nBubbles > 0; --nBubbles) {
            i = StreamUtils.readShort(is);
            if (loader.BubbleList[i] == null) {
                loader.BubbleList[i] = new BubbleStruct();
            }
            loader.BubbleList[i].load(is);
        }
        for (i = 0; i < loader.nMachineCount; ++i) {
            if (loader.Machine[i] == null) {
                loader.Machine[i] = new BubbleMachineStruct();
            }
            loader.Machine[i].load(is);
        }
    }

    public static void DoBubbleMachines() {
        for (int i = 0; i < Globals.nMachineCount; ++i) {
            if (--Globals.Machine[i].field_0 > 0) continue;
            Sprite spr = Main.boardService.getSprite(Globals.Machine[i].field_2);
            Globals.Machine[i].field_0 = Random.RandomWord() % Globals.Machine[i].field_4 + 30;
            if (spr == null) continue;
            Sprites.BuildBubble(spr.getX(), spr.getY(), spr.getZ(), spr.getSectnum());
        }
    }

    private static BubbleStruct BuildBubble(int x, int y, int z, int sectnum) {
        int v6 = Random.RandomSize(3);
        if (v6 > 4) {
            v6 -= 4;
        }
        if (Globals.nFreeCount > 0) {
            int nBubble = Globals.nBubblesFree[--Globals.nFreeCount] & 0xFF;
            int spr = Main.engine.insertsprite(sectnum, 402);
            Sprite pSprite = Main.boardService.getSprite(spr);
            if (pSprite == null) {
                throw new AssertException("spr>=0 && spr<MAXSPRITES");
            }
            pSprite.setX(x);
            pSprite.setY(y);
            pSprite.setZ(z);
            pSprite.setCstat(0);
            pSprite.setShade(-32);
            pSprite.setPal(0);
            pSprite.setClipdist(5);
            pSprite.setXrepeat(40);
            pSprite.setYrepeat(40);
            pSprite.setXoffset(0);
            pSprite.setYoffset(0);
            pSprite.setPicnum(1);
            pSprite.setAng(Globals.inita);
            pSprite.setXvel(0);
            pSprite.setYvel(0);
            pSprite.setZvel(-1200);
            pSprite.setLotag(RunList.HeadRun() + 1);
            pSprite.setHitag(0);
            pSprite.setExtra(0);
            if (Globals.BubbleList[nBubble] == null) {
                Globals.BubbleList[nBubble] = new BubbleStruct();
            }
            Globals.BubbleList[nBubble].nSprite = spr;
            Globals.BubbleList[nBubble].field_0 = 0;
            Globals.BubbleList[nBubble].nSeq = v6 + Seq.SeqOffsets[15];
            pSprite.setOwner(RunList.AddRunRec(pSprite.getLotag() - 1, 0x140000 | nBubble));
            Globals.BubbleList[nBubble].field_6 = RunList.AddRunRec(RunList.NewRun, 0x140000 | nBubble);
            return Globals.BubbleList[nBubble];
        }
        return null;
    }

    public static void FuncBubble(int nStack, int ignored, int RunPtr) {
        int nBubble = RunList.RunData[RunPtr].getObject();
        if (nBubble < 0 || nBubble >= 200) {
            throw new AssertException("Bubble>=0 && Bubble<MAX_BUBBLES");
        }
        int nSprite = Globals.BubbleList[nBubble].nSprite;
        Sprite sprite = Main.boardService.getSprite(nSprite);
        if (sprite == null) {
            return;
        }
        Sector sec = Main.boardService.getSector(sprite.getSectnum());
        if (sec == null) {
            return;
        }
        switch (nStack & 0x7F0000) {
            case 131072: {
                Seq.MoveSequence(nSprite, Globals.BubbleList[nBubble].nSeq, Globals.BubbleList[nBubble].field_0);
                if (++Globals.BubbleList[nBubble].field_0 >= Seq.SeqSize[Globals.BubbleList[nBubble].nSeq]) {
                    Globals.BubbleList[nBubble].field_0 = 0;
                }
                sprite.setZ(sprite.getZ() + sprite.getZvel());
                Main.game.pInt.setsprinterpolate(nSprite, sprite);
                if (sprite.getZ() <= sec.getCeilingz()) {
                    int v13 = Globals.SectAbove[sprite.getSectnum()];
                    Sector sec13 = Main.boardService.getSector(v13);
                    if (sprite.getHitag() > -1 && sec13 != null) {
                        Anim.BuildAnim(-1, 70, 0, sprite.getX(), sprite.getY(), sec13.getFloorz(), v13, 64, 0);
                    }
                    Sprites.DestroyBubble(nBubble);
                }
                return;
            }
            case 589824: {
                Renderer renderer = Main.game.getRenderer();
                TSprite tsp = (TSprite)renderer.getRenderedSprites().get((short)(nStack & 0xFFFF));
                Seq.PlotSequence(tsp, Globals.BubbleList[nBubble].nSeq, Globals.BubbleList[nBubble].field_0, 1);
                tsp.setOwner(-1);
            }
        }
    }

    public static void DestroyBubble(int a1) {
        int nSprite = Globals.BubbleList[a1].nSprite;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            return;
        }
        RunList.DoSubRunRec(pSprite.getLotag() - 1);
        RunList.DoSubRunRec(pSprite.getOwner());
        RunList.SubRunRec(Globals.BubbleList[a1].field_6);
        Main.engine.mydeletesprite(nSprite);
        Globals.BubbleList[a1].nSprite = -1;
        Globals.nBubblesFree[Globals.nFreeCount] = (byte)a1;
        ++Globals.nFreeCount;
    }

    public static int GetBubbleSprite(BubbleStruct pBubble) {
        if (pBubble != null) {
            return pBubble.nSprite;
        }
        return -1;
    }

    public static void DoBubbles(int a1) {
        Sprite sprite;
        int[] out = Sprites.WheresMyMouth(a1);
        if (out[3] != -1 && (sprite = Main.boardService.getSprite(Sprites.GetBubbleSprite(Sprites.BuildBubble(out[0], out[1], out[2], out[3])))) != null) {
            sprite.setHitag(a1);
        }
    }

    public static int[] WheresMyMouth(int plr) {
        int nSprite = Globals.PlayerList[plr].spriteId;
        Sprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite != null) {
            Main.engine.clipmove(pSprite.getX(), pSprite.getY(), pSprite.getZ() - Sprites.GetSpriteHeight(nSprite) >> 1, pSprite.getSectnum(), (long)EngineUtils.sin(pSprite.getAng() + 512 & 0x7FF) << 7, (long)EngineUtils.sin(pSprite.getAng() & 0x7FF) << 7, 5120, 1280, 1280, 0x1000040);
            Sprites.wheresMyMouth[0] = Engine.clipmove_x;
            Sprites.wheresMyMouth[1] = Engine.clipmove_y;
            Sprites.wheresMyMouth[2] = Engine.clipmove_z;
            Sprites.wheresMyMouth[3] = Engine.clipmove_sectnum;
        }
        return wheresMyMouth;
    }

    static {
        nChunkSprite = new int[75];
        nBodyGunSprite = new int[50];
        wheresMyMouth = new int[4];
    }
}

