/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Type;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Type.EpisodeEntry;
import ru.m210projects.Powerslave.Type.EpisodeInfo;
import ru.m210projects.Powerslave.Type.MapInfo;

public class EpisodeManager {
    private final Map<String, EpisodeInfo> episodeCache = new HashMap<String, EpisodeInfo>();

    public void putEpisode(EpisodeInfo gameInfo) {
        this.episodeCache.put(this.getHashKey(gameInfo.getEpisodeEntry().getFileEntry()), gameInfo);
    }

    private String getHashKey(FileEntry entry) {
        return entry.getRelativePath().toString().toUpperCase(Locale.ROOT);
    }

    public EpisodeInfo getEpisode(FileEntry entry) {
        EpisodeInfo addon = this.episodeCache.get(this.getHashKey(entry));
        if (addon != null) {
            return addon;
        }
        addon = this.checkCustomAddon(entry);
        if (addon != null) {
            this.episodeCache.put(this.getHashKey(addon.getEpisodeEntry().getFileEntry()), addon);
            Console.out.println("Found addon: " + addon.Title + " ( " + entry.getName() + " )");
        }
        return addon;
    }

    public EpisodeInfo checkCustomAddon(FileEntry fileEntry) {
        if (!fileEntry.exists()) {
            return null;
        }
        Directory gr = fileEntry.isDirectory() ? fileEntry.getDirectory() : Main.game.cache.newGroup(fileEntry);
        List mapList = gr.stream().filter(e -> e.isExtension("map")).sorted(Entry::compareTo).collect(Collectors.toList());
        int nCount = 0;
        EpisodeInfo ep = new EpisodeInfo(fileEntry.getName(), new EpisodeEntry.Addon(gr, fileEntry));
        char[] mapname = "lev1.map".toCharArray();
        for (Entry entry : mapList) {
            if (!String.copyValueOf(mapname).equalsIgnoreCase(entry.getName())) continue;
            ep.gMapInfo.add(new MapInfo(entry.getName(), fileEntry.getName() + ": Map" + (nCount + 1)));
            mapname = ("lev" + (1 + ++nCount) + ".map").toCharArray();
        }
        if (ep.maps() > 0) {
            return ep;
        }
        if (!fileEntry.isDirectory() && mapList.size() == 1) {
            for (Entry entry : mapList) {
                ep.gMapInfo.add(new MapInfo(entry.getName(), entry.getName()));
            }
            return ep;
        }
        return null;
    }
}

