/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Type;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.BitMap;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Powerslave.Anim;
import ru.m210projects.Powerslave.Bullet;
import ru.m210projects.Powerslave.Enemies.Anubis;
import ru.m210projects.Powerslave.Enemies.Enemy;
import ru.m210projects.Powerslave.Enemies.Fish;
import ru.m210projects.Powerslave.Enemies.LavaDude;
import ru.m210projects.Powerslave.Enemies.Lion;
import ru.m210projects.Powerslave.Enemies.Mummy;
import ru.m210projects.Powerslave.Enemies.Queen;
import ru.m210projects.Powerslave.Enemies.Ra;
import ru.m210projects.Powerslave.Enemies.Rat;
import ru.m210projects.Powerslave.Enemies.Rex;
import ru.m210projects.Powerslave.Enemies.Roach;
import ru.m210projects.Powerslave.Enemies.Scorp;
import ru.m210projects.Powerslave.Enemies.Set;
import ru.m210projects.Powerslave.Enemies.Spider;
import ru.m210projects.Powerslave.Enemies.Wasp;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Grenade;
import ru.m210projects.Powerslave.Light;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Menus.PSMenuUserContent;
import ru.m210projects.Powerslave.Object;
import ru.m210projects.Powerslave.PSSector;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Slide;
import ru.m210projects.Powerslave.Snake;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Switch;
import ru.m210projects.Powerslave.Type.AnimStruct;
import ru.m210projects.Powerslave.Type.BlockInfo;
import ru.m210projects.Powerslave.Type.BobStruct;
import ru.m210projects.Powerslave.Type.BubbleMachineStruct;
import ru.m210projects.Powerslave.Type.BubbleStruct;
import ru.m210projects.Powerslave.Type.BulletStruct;
import ru.m210projects.Powerslave.Type.Channel;
import ru.m210projects.Powerslave.Type.DripStruct;
import ru.m210projects.Powerslave.Type.ElevStruct;
import ru.m210projects.Powerslave.Type.EpisodeInfo;
import ru.m210projects.Powerslave.Type.FishChunk;
import ru.m210projects.Powerslave.Type.FlashStruct;
import ru.m210projects.Powerslave.Type.FlickerStruct;
import ru.m210projects.Powerslave.Type.FlowStruct;
import ru.m210projects.Powerslave.Type.GrenadeStruct;
import ru.m210projects.Powerslave.Type.GrowStruct;
import ru.m210projects.Powerslave.Type.MoveSectStruct;
import ru.m210projects.Powerslave.Type.ObjectStruct;
import ru.m210projects.Powerslave.Type.PlayerStruct;
import ru.m210projects.Powerslave.Type.RaStruct;
import ru.m210projects.Powerslave.Type.RunData;
import ru.m210projects.Powerslave.Type.SnakeStruct;
import ru.m210projects.Powerslave.Type.SwitchStruct;
import ru.m210projects.Powerslave.Type.TrailPointStruct;
import ru.m210projects.Powerslave.Type.TrailStruct;
import ru.m210projects.Powerslave.Type.TrapStruct;
import ru.m210projects.Powerslave.Type.WallFaceStruct;

public class SafeLoader {
    public boolean gClassicMode;
    public String savename;
    public int level;
    public int best;
    public int lastlevel;
    public int warp_on;
    public Entry boardfilename;
    public final int[] nPlayerWeapons = new int[8];
    public final int[] nPlayerClip = new int[8];
    public final int[] nPistolClip = new int[8];
    public final int[] nPlayerLives = new int[8];
    public final int[] nPlayerItem = new int[8];
    public final PlayerStruct[] PlayerList = new PlayerStruct[8];
    public Sector[] sector;
    public Wall[] wall;
    public List<Sprite> sprite;
    public final int[] nNetStartSprite = new int[8];
    public final int[] nBodySprite = new int[50];
    public int nCurBodyNum;
    public int nBodyTotal;
    public final int[] nChunkSprite = new int[75];
    public final int[] nBodyGunSprite = new int[50];
    public int nCurChunkNum;
    public int nCurBodyGunNum;
    public int nChunkTotal;
    public int nAnimsFree;
    public final int[] AnimsFree = new int[400];
    public final int[] AnimRunRec = new int[400];
    public final byte[] AnimFlags = new byte[400];
    public final AnimStruct[] AnimList = new AnimStruct[400];
    public short initsect;
    public int initx;
    public int inity;
    public int initz;
    public int inita;
    public int nFreeze;
    public short connecthead;
    public final short[] connectpoint2 = new short[16];
    public int nXDamage;
    public int nYDamage;
    public short nDoppleSprite;
    public short nPlayerTorch;
    public short nPlayerInvisible;
    public short nPlayerDouble;
    public short nPlayerViewSect;
    public short nPlayerFloorSprite;
    public short nPlayerScore;
    public short nPlayerGrenade;
    public short nPlayerSnake;
    public short nDestVertPan;
    public short dVertPan;
    public short nDeathType;
    public short nQuake;
    public boolean bTouchFloor;
    public int ElevCount;
    public final ElevStruct[] Elevator = new ElevStruct[1024];
    public int WallFaceCount;
    public final WallFaceStruct[] WallFace = new WallFaceStruct[4096];
    public int ObjectCount;
    public final ObjectStruct[] ObjectList = new ObjectStruct[128];
    public int nDrips;
    public final DripStruct[] sDrip = new DripStruct[50];
    public int nTrails;
    public int nTrailPoints;
    public final TrailStruct[] sTrail = new TrailStruct[40];
    public final TrailPointStruct[] sTrailPoint = new TrailPointStruct[100];
    public final int[] nTrailPointPrev = new int[100];
    public final int[] nTrailPointNext = new int[100];
    public final int[] nTrailPointVal = new int[100];
    public int nTraps;
    public final TrapStruct[] sTrap = new TrapStruct[40];
    public final int[] nTrapInterval = new int[40];
    public int nBobs;
    public final BobStruct[] sBob = new BobStruct[200];
    public final int[] sBobID = new int[200];
    public int randA;
    public int randB;
    public int randC;
    public int lasthitx;
    public int lasthity;
    public int lasthitz;
    public int lasthitsect;
    public int lasthitwall;
    public int lasthitsprite;
    public int nBulletCount;
    public int nBulletsFree;
    public final int[] BulletFree = new int[500];
    public final int[] nBulletEnemy = new int[500];
    public final BulletStruct[] BulletList = new BulletStruct[500];
    public int nMachineCount;
    public final BubbleMachineStruct[] Machine = new BubbleMachineStruct[125];
    public int nFreeCount;
    public final byte[] nBubblesFree = new byte[200];
    public final BubbleStruct[] BubbleList = new BubbleStruct[200];
    public int nGrenadeCount;
    public int nGrenadesFree;
    public final int[] GrenadeFree = new int[50];
    public final int[] nGrenadePlayer = new int[50];
    public final GrenadeStruct[] GrenadeList = new GrenadeStruct[50];
    public int nSnakesFree;
    public final int[] SnakeFree = new int[50];
    public final int[] nSnakePlayer = new int[50];
    public final SnakeStruct[] SnakeList = new SnakeStruct[50];
    public int totalmoves;
    public int moveframes;
    public final BitMap show2dsector = new BitMap(1024);
    public final BitMap show2dwall = new BitMap(8192);
    public final BitMap show2dsprite = new BitMap(4096);
    public short nCreaturesLeft;
    public short nCreaturesMax;
    public short nSpiritSprite;
    public short nMagicCount;
    public short nRegenerates;
    public short nFirstRegenerate;
    public short nNetStartSprites;
    public short nCurStartSprite;
    public short nNetPlayerCount;
    public short nRadialSpr;
    public short nRadialDamage;
    public short nDamageRadius;
    public short nRadialOwner;
    public short nRadialBullet;
    public short nDronePitch;
    public short nFinaleSpr;
    public short lFinaleStart;
    public short nFinaleStage;
    public short nSmokeSparks;
    public int AnubisCount;
    public int nAnubisDrum;
    public final Enemy.EnemyStruct[] AnubisList = new Enemy.EnemyStruct[80];
    public int LionCount;
    public final Lion.LionStruct[] LionList = new Lion.LionStruct[40];
    public int FishCount;
    public int nChunksFree;
    public final int[] nFreeChunk = new int[128];
    public final FishChunk[] FishChunk = new FishChunk[128];
    public final Enemy.EnemyStruct[] FishList = new Enemy.EnemyStruct[128];
    public int LavaCount;
    public final Enemy.EnemyStruct[] LavaList = new Enemy.EnemyStruct[20];
    public int MummyCount;
    public final Enemy.EnemyStruct[] MummyList = new Enemy.EnemyStruct[150];
    public int QueenCount;
    public final int[] nEggFree = new int[10];
    public int nEggsFree;
    public final Enemy.EnemyStruct[] QueenEgg = new Enemy.EnemyStruct[10];
    public int nVelShift;
    public final Enemy.EnemyStruct QueenHead = new Enemy.EnemyStruct();
    public int nHeadVel;
    public final Queen.QueenStruct QueenList = new Queen.QueenStruct();
    public int QueenChan;
    public final int[] tailspr = new int[7];
    public int nQHead;
    public final int[] MoveQX = new int[25];
    public final int[] MoveQY = new int[25];
    public final int[] MoveQZ = new int[25];
    public final int[] MoveQA = new int[25];
    public final int[] MoveQS = new int[25];
    public final RaStruct[] Ra = new RaStruct[8];
    public int nRatCount;
    public int nMinChunk;
    public int nMaxChunk;
    public int nPlayerPic;
    public final Enemy.EnemyStruct[] RatList = new Enemy.EnemyStruct[50];
    public int RexCount;
    public final Enemy.EnemyStruct[] RexList = new Enemy.EnemyStruct[50];
    public final int[] RexChan = new int[50];
    public int RoachCount;
    public final Enemy.EnemyStruct[] RoachList = new Enemy.EnemyStruct[100];
    public int ScorpCount;
    public final Scorp.ScorpStruct[] ScorpList = new Scorp.ScorpStruct[5];
    public final int[] ScorpChan = new int[5];
    public int SetCount;
    public final Set.SetStruct[] SetList = new Set.SetStruct[10];
    public final int[] SetChan = new int[10];
    public int SpiderCount;
    public final Enemy.EnemyStruct[] SpiderList = new Enemy.EnemyStruct[100];
    public int nWaspCount;
    public int nVelShift_X_1;
    public final Wasp.WaspStruct[] WaspList = new Wasp.WaspStruct[100];
    public short nEnergyChan;
    public short nEnergyBlocks;
    public short nEnergyTowers;
    public short nSwitchSound;
    public short nStoneSound;
    public short nElevSound;
    public short nStopSound;
    public int lCountDown;
    public short nRedTicks;
    public short nAlarmTicks;
    public short nClockVal;
    public short nButtonColor;
    public int nFlickerCount;
    public int nGlowCount;
    public int nFlowCount;
    public int nFlashes;
    public int nFirstFlash = -1;
    public int nLastFlash = -1;
    public final int[] nFreeFlash = new int[2000];
    public final int[] nNextFlash = new int[2000];
    public final FlashStruct[] sFlash = new FlashStruct[2000];
    public final GrowStruct[] sGlow = new GrowStruct[50];
    public final FlickerStruct[] sFlicker = new FlickerStruct[100];
    public final FlowStruct[] sFlowInfo = new FlowStruct[375];
    public final byte[] sMoveDir = new byte[50];
    public final MoveSectStruct[] sMoveSect = new MoveSectStruct[50];
    public int nMoveSects;
    public int nPushBlocks;
    public final BlockInfo[] sBlockInfo = new BlockInfo[100];
    public int PointCount;
    public final int[] PointFree = new int[1024];
    public int SlideCount;
    public final int[] SlideFree = new int[128];
    public final Slide.PointStruct[] PointList = new Slide.PointStruct[1024];
    public final Slide.SlideStruct[] SlideData = new Slide.SlideStruct[128];
    public final Slide.SlideStruct2[] SlideData2 = new Slide.SlideStruct2[128];
    public int SwitchCount;
    public final SwitchStruct[] SwitchData = new SwitchStruct[1024];
    public int LinkCount;
    public final byte[][] LinkMap = new byte[1024][8];
    public final int[] SectFlag = new int[Engine.MAXSECTORS];
    public final int[] SectDepth = new int[Engine.MAXSECTORS];
    public final int[] SectSpeed = new int[Engine.MAXSECTORS];
    public final int[] SectDamage = new int[Engine.MAXSECTORS];
    public final int[] SectAbove = new int[Engine.MAXSECTORS];
    public final int[] SectBelow = new int[Engine.MAXSECTORS];
    public final int[] SectSound = new int[Engine.MAXSECTORS];
    public final int[] SectSoundSect = new int[Engine.MAXSECTORS];
    public int ChannelList;
    public int ChannelLast;
    public final Channel[] channel = new Channel[4096];
    public int NewRun;
    public int RunCount = -1;
    public int RunChain;
    public final int[] RunFree = new int[25600];
    public final RunData[] RunData = new RunData[25600];
    public int bTorch;
    public EpisodeInfo addon;
    public boolean packedAddon;
    public String addonFileName;
    private String message;

    public SafeLoader() {
        for (int i = 0; i < 8; ++i) {
            this.PlayerList[i] = new PlayerStruct();
        }
    }

    public boolean load(InputStream is) {
        try {
            this.addon = null;
            this.addonFileName = null;
            this.message = null;
            this.LoadGDXHeader(is);
            if (this.gClassicMode) {
                this.nPlayerWeapons[Globals.nLocalPlayer] = StreamUtils.readShort(is);
                this.PlayerList[Globals.nLocalPlayer].currentWeapon = StreamUtils.readShort(is);
                this.nPlayerClip[Globals.nLocalPlayer] = StreamUtils.readShort(is);
                this.nPlayerItem[Globals.nLocalPlayer] = StreamUtils.readShort(is);
                this.PlayerList[Globals.nLocalPlayer].readObject(is, false);
                this.nPlayerLives[Globals.nLocalPlayer] = StreamUtils.readShort(is);
            } else {
                this.lastlevel = StreamUtils.readInt(is);
                this.MapLoad(is);
                Anim.loadAnm(this, is);
                this.loadSprites(is);
                this.loadSectors(is);
                Object.loadWallFaces(this, is);
                RunList.loadRunList(this, is);
                this.loadPlayer(is);
                Random.loadRandom(this, is);
                this.totalmoves = StreamUtils.readInt(is);
                this.moveframes = StreamUtils.readInt(is);
                if (is.available() != 0) {
                    return false;
                }
            }
            if (this.warp_on == 2) {
                this.addon = this.findAddon(this.addonFileName);
                if (this.addon == null) {
                    this.message = "Can't find user episode file: " + this.boardfilename.getName();
                    this.warp_on = 1;
                    this.lastlevel = 0;
                    this.level = 0;
                    this.best = 0;
                }
            }
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    private EpisodeInfo findAddon(String addonFileName) {
        try {
            FileEntry addonEntry = Main.game.getCache().getGameDirectory().getEntry(FileUtils.getPath(addonFileName, new String[0]));
            if (addonEntry.exists()) {
                return PSMenuUserContent.episodeManager.getEpisode(addonEntry);
            }
        }
        catch (Exception e) {
            Console.out.println(e.toString(), OsdColor.RED);
        }
        return null;
    }

    public void LoadHeader(InputStream is) throws IOException {
        StreamUtils.skip(is, 8);
        this.savename = StreamUtils.readString(is, 32).trim();
        this.gClassicMode = StreamUtils.readBoolean(is);
        this.level = StreamUtils.readShort(is);
        this.best = StreamUtils.readShort(is);
    }

    public void LoadGDXBlock(InputStream is) throws IOException {
        boolean hasCapt = StreamUtils.readBoolean(is);
        if (hasCapt) {
            StreamUtils.skip(is, 16000);
        }
        this.warp_on = StreamUtils.readByte(is);
        if (this.warp_on == 2) {
            this.addonFileName = StreamUtils.readDataString(is).toLowerCase();
        }
        this.boardfilename = Main.game.getCache().getEntry(StreamUtils.readDataString(is), true);
    }

    public EpisodeInfo LoadGDXHeader(InputStream is) throws IOException {
        this.gClassicMode = false;
        this.level = -1;
        this.best = -1;
        this.warp_on = 0;
        this.packedAddon = false;
        this.addon = null;
        this.addonFileName = null;
        this.boardfilename = Directory.DUMMY_ENTRY;
        this.LoadHeader(is);
        this.LoadGDXBlock(is);
        if (this.warp_on == 2) {
            this.addon = this.findAddon(this.addonFileName);
        }
        return this.addon;
    }

    public void MapLoad(InputStream is) throws IOException {
        int i;
        this.sector = new Sector[StreamUtils.readInt(is)];
        for (i = 0; i < this.sector.length; ++i) {
            this.sector[i] = new Sector().readObject(is);
        }
        this.wall = new Wall[StreamUtils.readInt(is)];
        for (i = 0; i < this.wall.length; ++i) {
            this.wall[i] = new Wall().readObject(is);
        }
        int numSprites = StreamUtils.readInt(is);
        this.sprite = new ArrayList<Sprite>(numSprites * 2);
        for (int i2 = 0; i2 < numSprites; ++i2) {
            this.sprite.add(new Sprite().readObject(is));
        }
    }

    private void loadPlayer(InputStream is) throws IOException {
        this.PlayerList[Globals.nLocalPlayer].readObject(is, true);
        this.connecthead = StreamUtils.readShort(is);
        for (int i = 0; i < this.connectpoint2.length; ++i) {
            this.connectpoint2[i] = StreamUtils.readShort(is);
        }
        this.bTorch = StreamUtils.readByte(is);
        this.nFreeze = StreamUtils.readInt(is);
        this.nXDamage = StreamUtils.readInt(is);
        this.nYDamage = StreamUtils.readInt(is);
        this.nDoppleSprite = StreamUtils.readShort(is);
        this.nPlayerClip[Globals.nLocalPlayer] = StreamUtils.readShort(is);
        this.nPistolClip[Globals.nLocalPlayer] = StreamUtils.readShort(is);
        this.nPlayerTorch = StreamUtils.readShort(is);
        this.nPlayerWeapons[Globals.nLocalPlayer] = StreamUtils.readShort(is);
        this.nPlayerLives[Globals.nLocalPlayer] = StreamUtils.readShort(is);
        this.nPlayerItem[Globals.nLocalPlayer] = StreamUtils.readShort(is);
        this.nPlayerInvisible = StreamUtils.readShort(is);
        this.nPlayerDouble = StreamUtils.readShort(is);
        this.nPlayerViewSect = StreamUtils.readShort(is);
        this.nPlayerFloorSprite = StreamUtils.readShort(is);
        this.nPlayerScore = StreamUtils.readShort(is);
        this.nPlayerGrenade = StreamUtils.readShort(is);
        this.nPlayerSnake = StreamUtils.readShort(is);
        this.nDestVertPan = StreamUtils.readShort(is);
        this.dVertPan = StreamUtils.readShort(is);
        this.nDeathType = StreamUtils.readShort(is);
        this.nQuake = StreamUtils.readShort(is);
        this.bTouchFloor = StreamUtils.readBoolean(is);
        this.initx = StreamUtils.readInt(is);
        this.inity = StreamUtils.readInt(is);
        this.initz = StreamUtils.readInt(is);
        this.inita = StreamUtils.readShort(is);
        this.initsect = StreamUtils.readShort(is);
        this.show2dsector.readObject(is);
        this.show2dwall.readObject(is);
        this.show2dsprite.readObject(is);
    }

    private void loadSprites(InputStream is) throws IOException {
        int i;
        this.loadEnemies(is);
        Bullet.loadBullets(this, is);
        Grenade.loadGrenades(this, is);
        Sprites.loadBubbles(this, is);
        Snake.loadSnakes(this, is);
        Object.loadObjects(this, is);
        Object.loadTraps(this, is);
        Object.loadDrips(this, is);
        this.nCreaturesLeft = StreamUtils.readShort(is);
        this.nCreaturesMax = StreamUtils.readShort(is);
        this.nSpiritSprite = StreamUtils.readShort(is);
        this.nMagicCount = StreamUtils.readShort(is);
        this.nRegenerates = StreamUtils.readShort(is);
        this.nFirstRegenerate = StreamUtils.readShort(is);
        this.nNetStartSprites = StreamUtils.readShort(is);
        this.nCurStartSprite = StreamUtils.readShort(is);
        this.nNetPlayerCount = StreamUtils.readShort(is);
        for (i = 0; i < 8; ++i) {
            this.nNetStartSprite[i] = StreamUtils.readShort(is);
        }
        for (i = 0; i < this.nChunkSprite.length; ++i) {
            this.nChunkSprite[i] = StreamUtils.readShort(is);
        }
        for (i = 0; i < this.nBodyGunSprite.length; ++i) {
            this.nBodyGunSprite[i] = StreamUtils.readShort(is);
        }
        for (i = 0; i < this.nBodySprite.length; ++i) {
            this.nBodySprite[i] = StreamUtils.readShort(is);
        }
        this.nCurChunkNum = StreamUtils.readShort(is);
        this.nCurBodyNum = StreamUtils.readShort(is);
        this.nCurBodyGunNum = StreamUtils.readShort(is);
        this.nBodyTotal = StreamUtils.readShort(is);
        this.nChunkTotal = StreamUtils.readShort(is);
        this.nRadialSpr = StreamUtils.readShort(is);
        this.nRadialDamage = StreamUtils.readShort(is);
        this.nDamageRadius = StreamUtils.readShort(is);
        this.nRadialOwner = StreamUtils.readShort(is);
        this.nRadialBullet = StreamUtils.readShort(is);
        this.nDronePitch = StreamUtils.readShort(is);
        this.nFinaleSpr = StreamUtils.readShort(is);
        this.nFinaleStage = StreamUtils.readShort(is);
        this.lFinaleStart = StreamUtils.readShort(is);
        this.nSmokeSparks = StreamUtils.readShort(is);
    }

    private void loadSectors(InputStream is) throws IOException {
        Light.loadLights(this, is);
        Object.loadElevs(this, is);
        Object.loadBobs(this, is);
        PSSector.loadMoves(this, is);
        Object.loadTrails(this, is);
        PSSector.loadPushBlocks(this, is);
        Slide.loadSlide(this, is);
        Switch.loadSwitches(this, is);
        PSSector.loadLinks(this, is);
        PSSector.loadSecExtra(this, is);
        this.nEnergyChan = StreamUtils.readShort(is);
        this.nEnergyBlocks = StreamUtils.readShort(is);
        this.nEnergyTowers = StreamUtils.readShort(is);
        this.nSwitchSound = StreamUtils.readShort(is);
        this.nStoneSound = StreamUtils.readShort(is);
        this.nElevSound = StreamUtils.readShort(is);
        this.nStopSound = StreamUtils.readShort(is);
        this.lCountDown = StreamUtils.readInt(is);
        this.nAlarmTicks = StreamUtils.readShort(is);
        this.nRedTicks = StreamUtils.readShort(is);
        this.nClockVal = StreamUtils.readShort(is);
        this.nButtonColor = StreamUtils.readShort(is);
    }

    private void loadEnemies(InputStream is) throws IOException {
        Anubis.loadAnubis(this, is);
        Fish.loadFish(this, is);
        LavaDude.loadLava(this, is);
        Lion.loadLion(this, is);
        Mummy.loadMummy(this, is);
        Queen.loadQueen(this, is);
        ru.m210projects.Powerslave.Enemies.Ra.loadRa(this, is);
        Rat.loadRat(this, is);
        Rex.loadRex(this, is);
        Roach.loadRoach(this, is);
        Scorp.loadScorp(this, is);
        Set.loadSet(this, is);
        Spider.loadSpider(this, is);
        Wasp.loadWasp(this, is);
    }

    public String getMessage() {
        return this.message;
    }
}

