/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import java.util.Arrays;
import java.util.Objects;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.Tools.Interpolation;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.RenderedSpriteList;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Player;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Snake;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.StatusAnim;
import ru.m210projects.Powerslave.Weapons;

public class View {
    private static final int[] gItemPic = new int[]{736, 752, 754, 726, 744};
    private static final char[] statbuffer = new char[80];
    public static final int[] nDigit = new int[3];
    public static int nOverhead = 0;
    public static int zoom = 768;

    public static void SetHealthFrame(int var) {
        if (Globals.healthperline == 0) {
            return;
        }
        Globals.nHealthLevel = (800 - Globals.PlayerList[Globals.nLocalPlayer].HealthAmount) / Globals.healthperline;
        if (Globals.nHealthLevel >= Globals.nMeterRange) {
            Globals.nHealthLevel = Globals.nMeterRange - 1;
        }
        if (Globals.nHealthLevel < 0) {
            Globals.nHealthLevel = 0;
        }
        if (var < 0) {
            StatusAnim.BuildStatusAnim(4, 0);
        }
    }

    public static void SetMagicFrame() {
        if (Globals.magicperline == 0) {
            return;
        }
        Globals.nMagicLevel = (1000 - Globals.PlayerList[Globals.nLocalPlayer].MagicAmount) / Globals.magicperline;
        if (Globals.nMagicLevel >= Globals.nMeterRange) {
            Globals.nMagicLevel = Globals.nMeterRange - 1;
        }
        if (Globals.nMagicLevel < 0) {
            Globals.nMagicLevel = 0;
        }
    }

    public static void UpdateScreenSize() {
        Renderer renderer = Main.game.getRenderer();
        int xdim = renderer.getWidth();
        int ydim = renderer.getHeight();
        renderer.setview(0, 0, xdim - 1, ydim - 1);
        View.RefreshStatus();
    }

    public static void StatusMessage(int time, String text, int ignoredPlayer) {
        Globals.message_timer = time;
        Globals.message_text = text;
        Console.out.println(text);
    }

    public static void InitStatus() {
        Globals.nStatusSeqOffset = Seq.SeqOffsets[26];
        Globals.nHealthFrames = Seq.SeqSize[Seq.SeqOffsets[26] + 1];
        int tile = Seq.GetSeqPicnum(26, 1, 0);
        Globals.nMagicFrames = Seq.SeqSize[Globals.nStatusSeqOffset + 129];
        Globals.nHealthFrame = 0;
        Globals.nMagicFrame = 0;
        Globals.nHealthLevel = 0;
        Globals.nMagicLevel = 0;
        Globals.nMeterRange = Main.engine.getTile(tile).getHeight();
        if (Globals.nMeterRange <= 0) {
            throw new AssertException("Error: Tile #" + tile + " is not found");
        }
        Globals.magicperline = 1000 / Globals.nMeterRange;
        Globals.healthperline = 800 / Globals.nMeterRange;
        Globals.nAirFrames = Seq.SeqSize[Globals.nStatusSeqOffset + 133];
        if (Globals.nAirFrames != 0) {
            Globals.airperline = 100 / Globals.nAirFrames;
        }
        Globals.nCounter = 0;
        Globals.nCounterDest = 0;
        Arrays.fill(nDigit, 0);
        Player.SetCounter(0);
        View.SetHealthFrame(0);
        View.SetMagicFrame();
        View.SetAirFrame();
        for (int i = 0; i < 50; i = (int)((byte)(i + 1))) {
            StatusAnim.StatusAnimsFree[i] = i;
            if (Globals.StatusAnim[i] != null) continue;
            Globals.StatusAnim[i] = new StatusAnim();
        }
        Globals.nLastAnim = -1;
        Globals.nFirstAnim = -1;
        Globals.nItemSeq = -1;
        Globals.nAnimsFree_X_1 = 50;
        Globals.message_timer = 0;
    }

    public static void RefreshStatus() {
        StatusAnim.BuildStatusAnim(2 * Globals.nPlayerLives[Globals.nLocalPlayer] + 145, 0);
        int keys = Globals.PlayerList[Globals.nLocalPlayer].KeysBitMask >> 12;
        int i = 0;
        int s = 37;
        while (i < 4) {
            if ((keys & 1 << i) != 0) {
                StatusAnim.BuildStatusAnim(s, 0);
            }
            ++i;
            s += 2;
        }
        if (Globals.nPlayerItem[Globals.nLocalPlayer] != -1) {
            Globals.nItemAltSeq = Globals.nItemMagic[Globals.nPlayerItem[Globals.nLocalPlayer]] <= Globals.PlayerList[Globals.nLocalPlayer].MagicAmount ? 0 : 2;
            Globals.nItemSeq = Globals.nItemAltSeq + Globals.nItemSeqOffset[Globals.nPlayerItem[Globals.nLocalPlayer]];
            Globals.nItemFrames = Seq.SeqSize[Globals.nStatusSeqOffset + Globals.nItemSeq];
            StatusAnim.BuildStatusAnim(2 * Globals.PlayerList[Globals.nLocalPlayer].ItemsAmount[Globals.nPlayerItem[Globals.nLocalPlayer]] + 156, 0);
        }
        View.SetHealthFrame(0);
        View.SetMagicFrame();
    }

    public static void SetAirFrame() {
        if (Globals.airperline == 0) {
            return;
        }
        Globals.airframe = Globals.PlayerList[Globals.nLocalPlayer].AirAmount / Globals.airperline;
        if (Globals.airframe < Globals.nAirFrames) {
            if (Globals.airframe < 0) {
                Globals.airframe = 0;
            }
        } else {
            Globals.airframe = Globals.nAirFrames - 1;
        }
    }

    public static void MoveStatus() {
        if (++Globals.nHealthFrame >= Globals.nHealthFrames) {
            Globals.nHealthFrame = 0;
        }
        if (++Globals.nMagicFrame >= Globals.nMagicFrames) {
            Globals.nMagicFrame = 0;
        }
        if (Globals.nItemSeq >= 0 && ++Globals.nItemFrame >= Globals.nItemFrames) {
            if (Globals.nItemSeq == 67) {
                Player.SetItemSeq();
            } else {
                Globals.nItemSeq -= Globals.nItemAltSeq;
                if (Globals.nItemAltSeq != 0 || (Globals.totalmoves & 0x1F) != 0) {
                    if (Globals.nItemAltSeq < 2) {
                        Globals.nItemAltSeq = 0;
                    }
                } else {
                    Globals.nItemAltSeq = 1;
                }
                Globals.nItemFrame = 0;
                Globals.nItemFrames = Seq.SeqSize[Globals.nItemAltSeq + (Globals.nItemSeq += Globals.nItemAltSeq) + Globals.nStatusSeqOffset];
            }
        }
        int v1 = Globals.message_timer;
        if (Globals.message_timer != 0) {
            Globals.message_timer -= 4;
            if (v1 - 4 <= 0) {
                Globals.message_timer = 0;
            }
        }
        View.MoveStatusAnims();
        if (Globals.nCounter == Globals.nCounterDest) {
            Weapons.ammodelay = 3;
            return;
        }
        if (--Weapons.ammodelay == 0) {
            return;
        }
        int v2 = Globals.nCounterDest - Globals.nCounter;
        if (Globals.nCounterDest - Globals.nCounter <= 0) {
            if (v2 < -30) {
                Globals.nCounter += Globals.nCounterDest - Globals.nCounter >> 1;
                Player.SetCounterDigits();
                return;
            }
            for (int i = 0; i < 3; ++i) {
                int v8;
                View.nDigit[i] = v8 = nDigit[i] - 1;
                if (v8 < 0) {
                    View.nDigit[i] = v8 + 30;
                }
                if (nDigit[i] >= 27) {
                    continue;
                }
                break;
            }
        } else {
            if (v2 > 30) {
                Globals.nCounter += Globals.nCounterDest - Globals.nCounter >> 1;
                Player.SetCounterDigits();
                return;
            }
            for (int j = 0; j < 3; ++j) {
                int v5;
                View.nDigit[j] = v5 = nDigit[j] + 1;
                if (v5 > 27) {
                    if (v5 < 30) continue;
                    View.nDigit[j] = v5 - 30;
                    continue;
                }
                break;
            }
        }
        if (nDigit[0] % 3 == 0) {
            Globals.nCounter = nDigit[0] / 3 + 100 * (nDigit[2] / 3) + 10 * (nDigit[1] / 3);
        }
        int v9 = Globals.nCounterDest - Globals.nCounter;
        if (Globals.nCounterDest - Globals.nCounter < 0) {
            v9 = -v9;
        }
        if ((Weapons.ammodelay = 4 - (v9 >> 1)) >= 1) {
            return;
        }
        Weapons.ammodelay = 1;
    }

    public static void MoveStatusAnims() {
        int i = Globals.nFirstAnim;
        while (true) {
            int v7 = i;
            if (i == -1) break;
            int v2 = Globals.StatusAnim[i].field_0 + Globals.nStatusSeqOffset;
            Seq.MoveSequence(-1, Globals.StatusAnim[i].field_0 + Globals.nStatusSeqOffset, Globals.StatusAnim[i].field_2);
            int v4 = Globals.StatusAnim[i].field_2 + 1;
            int v5 = Seq.SeqSize[v2];
            Globals.StatusAnim[i].field_2 = v4;
            if (v4 >= v5) {
                int v6 = (StatusAnim.StatusAnimFlags[i] & 0x10) != 0 ? 0 : v5 - 1;
                Globals.StatusAnim[i].field_2 = v6;
            }
            i = Globals.StatusAnim[v7].field_6;
        }
    }

    public static void DrawStatus() {
        Renderer renderer = Main.game.getRenderer();
        int gView = Main.cfg.nScreenSize;
        if (gView == 2) {
            Seq.DrawStatusSequence(Globals.nStatusSeqOffset, 0, 0);
            Seq.DrawStatusSequence(Globals.nStatusSeqOffset + 128, 0, 0);
            Seq.DrawStatusSequence(Globals.nStatusSeqOffset + 127, 0, 0);
            Seq.DrawStatusSequence(Globals.nStatusSeqOffset + 1, Globals.nHealthFrame, Globals.nHealthLevel);
            Seq.DrawStatusSequence(Globals.nStatusSeqOffset + 129, Globals.nMagicFrame, Globals.nMagicLevel);
            Seq.DrawStatusSequence(Globals.nStatusSeqOffset + 125, 0, 0);
            Seq.DrawStatusSequence(Globals.nStatusSeqOffset + 130, 0, 0);
            Seq.DrawStatusSequence(Globals.nStatusSeqOffset + 131, 0, 0);
            if (Globals.nItemSeq >= 0) {
                Seq.DrawStatusSequence(Globals.nItemSeq + Globals.nStatusSeqOffset, Globals.nItemFrame, 0);
            }
            View.DrawStatusAnims(false);
            if ((Globals.SectFlag[Globals.nPlayerViewSect[Globals.nLocalPlayer]] & 0x2000) != 0) {
                Seq.DrawStatusSequence(Globals.nStatusSeqOffset + 133, Globals.airframe, 0);
            }
            Seq.DrawCustomSequence(Globals.nStatusSeqOffset + 35, (Globals.inita + 128 & 0x7FF) >> 8, Globals.inita >= 128 && Globals.inita <= 892 ? 1 : 0, 0, 0, 0, 0);
            Seq.DrawStatusSequence(Globals.nStatusSeqOffset + 44, nDigit[2], 0);
            Seq.DrawStatusSequence(Globals.nStatusSeqOffset + 45, nDigit[1], 0);
            Seq.DrawStatusSequence(Globals.nStatusSeqOffset + 46, nDigit[0], 0);
        } else if (gView == 1) {
            renderer.rotatesprite(0x420000, 0xB30000, 65536, 0, 9218, 0, 0, 266);
            renderer.rotatesprite(0xFD0000, 0xB30000, 65536, 0, 9219, 0, 0, 522);
            Seq.DrawCustomSequence(Globals.nStatusSeqOffset + 1, Globals.nHealthFrame, 0, Globals.nHealthLevel, 0, 0, 512);
            Seq.DrawCustomSequence(Globals.nStatusSeqOffset + 129, Globals.nMagicFrame, 0, Globals.nMagicLevel, 0, 0, 256);
            Seq.DrawCustomSequence(Globals.nStatusSeqOffset + 125, 0, 0, 0, 0, 0, 512);
            if (Globals.nItemSeq >= 0) {
                Seq.DrawCustomSequence(Globals.nItemSeq + Globals.nStatusSeqOffset, Globals.nItemFrame, 0, 0, 0, 0, 256);
            }
            Seq.DrawCustomSequence(Globals.nStatusSeqOffset + 130, 0, 0, 0, 0, 0, 512);
            Seq.DrawCustomSequence(Globals.nStatusSeqOffset + 131, 0, 0, 0, 0, 0, 256);
            renderer.rotatesprite(0x4C0000, 0xBA0000, 65536, 0, 883, 0, 0, 266);
            View.DrawStatusAnims(true);
            if ((Globals.SectFlag[Globals.nPlayerViewSect[Globals.nLocalPlayer]] & 0x2000) != 0) {
                Seq.DrawCustomSequence(Globals.nStatusSeqOffset + 133, Globals.airframe, -7, 0, 0, 0, 256);
            }
            Seq.DrawCustomSequence(Globals.nStatusSeqOffset + 44, nDigit[2], -13, 0, 0, 0, 256);
            Seq.DrawCustomSequence(Globals.nStatusSeqOffset + 45, nDigit[1], -13, 0, 0, 0, 256);
            Seq.DrawCustomSequence(Globals.nStatusSeqOffset + 46, nDigit[0], -13, 0, 0, 0, 256);
        }
        View.DrawItemTimer(300, 20, Globals.nLocalPlayer);
        if (Main.cfg.gShowMessages) {
            if (Globals.nSnakeCam < 0) {
                if (Globals.message_timer != 0) {
                    if (Objects.equals(Globals.message_text, "or \"enter\" to load last saved game")) {
                        Main.game.getFont(2).drawText(renderer, 0, 5, "Press \"use\" to restart the level", 2.0f, 0, 0, TextAlign.Left, Transparent.None, true);
                        Main.game.getFont(2).drawText(renderer, 0, 25, "or \"enter\" to load last saved game", 2.0f, 0, 0, TextAlign.Left, Transparent.None, true);
                    } else {
                        Main.game.getFont(2).drawText(renderer, 0, 5, Globals.message_text, 2.0f, 0, 0, TextAlign.Left, Transparent.None, true);
                    }
                }
            } else {
                Main.game.getFont(2).drawTextScaled(renderer, 2, 5, "S E R P E N T   C A M", 2.0f, 0, 0, TextAlign.Left, Transparent.None, ConvertType.Normal, true);
            }
        }
        if (Main.cfg.gCrosshair) {
            int col = 187;
            int xdim = renderer.getWidth();
            int ydim = renderer.getHeight();
            renderer.drawline256(xdim - Pragmas.mulscale(Main.cfg.gCrossSize, 16L, 16) << 11, ydim << 11, xdim - Pragmas.mulscale(Main.cfg.gCrossSize, 4L, 16) << 11, ydim << 11, col);
            renderer.drawline256(xdim + Pragmas.mulscale(Main.cfg.gCrossSize, 4L, 16) << 11, ydim << 11, xdim + Pragmas.mulscale(Main.cfg.gCrossSize, 16L, 16) << 11, ydim << 11, col);
            renderer.drawline256(xdim << 11, ydim - Pragmas.mulscale(Main.cfg.gCrossSize, 16L, 16) << 11, xdim << 11, ydim - Pragmas.mulscale(Main.cfg.gCrossSize, 4L, 16) << 11, col);
            renderer.drawline256(xdim << 11, ydim + Pragmas.mulscale(Main.cfg.gCrossSize, 4L, 16) << 11, xdim << 11, ydim + Pragmas.mulscale(Main.cfg.gCrossSize, 16L, 16) << 11, col);
        }
        View.RefreshStatus();
    }

    private static void DrawItemTimer(int posx, int posy, int plr) {
        Renderer renderer = Main.game.getRenderer();
        for (int i = 0; i < 5; ++i) {
            int value = View.ItemTimer(i, plr);
            if (value <= 0) continue;
            int tile = gItemPic[i];
            ArtEntry pic = Main.engine.getTile(tile);
            int x = posx - pic.getWidth() / 8;
            int y = posy - pic.getHeight() / 8;
            renderer.rotatesprite(x << 16, y << 16, 32768, 0, gItemPic[i], 0, 0, 522);
            int offs = Strhandler.Bitoa(value, statbuffer);
            Strhandler.buildString(statbuffer, offs, "%");
            Main.game.getFont(2).drawTextScaled(renderer, x, posy + pic.getHeight() / 8 + 4, statbuffer, 0.5f, 24, 0, TextAlign.Center, Transparent.None, ConvertType.AlignRight, true);
            posy += 25;
        }
    }

    private static int ItemTimer(int num, int plr) {
        switch (num) {
            case 0: {
                return Globals.PlayerList[plr].invisibility * 100 / 900;
            }
            case 1: {
                return Globals.nPlayerDouble[plr] * 100 / 1350;
            }
            case 2: {
                return Globals.PlayerList[plr].AirMaskAmount * 100 / 1350;
            }
            case 3: {
                return Globals.nPlayerInvisible[plr] * 100 / 900;
            }
            case 4: {
                return Globals.nPlayerTorch[plr] * 100 / 900;
            }
        }
        return -1;
    }

    public static void DrawStatusAnims(boolean nCustomHud) {
        int a1 = Globals.nFirstAnim;
        while (a1 != -1) {
            int v2 = Globals.StatusAnim[a1].field_0 + Globals.nStatusSeqOffset;
            if (nCustomHud) {
                int stat = 0;
                int xoffs = 0;
                switch (Globals.StatusAnim[a1].field_0) {
                    case 36: 
                    case 37: {
                        xoffs = 12;
                        stat = 512;
                        break;
                    }
                    case 38: 
                    case 39: {
                        xoffs = 9;
                        stat = 512;
                        break;
                    }
                    case 40: 
                    case 41: {
                        xoffs = 7;
                        stat = 512;
                        break;
                    }
                    case 42: 
                    case 43: {
                        xoffs = 3;
                        stat = 512;
                        break;
                    }
                    case 4: 
                    case 7: 
                    case 10: 
                    case 13: 
                    case 19: 
                    case 145: 
                    case 147: 
                    case 149: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 155: {
                        stat = 512;
                        break;
                    }
                    case 132: {
                        xoffs = -7;
                    }
                    case 156: 
                    case 158: 
                    case 160: 
                    case 162: 
                    case 164: 
                    case 166: {
                        stat = 256;
                        break;
                    }
                    default: {
                        Console.out.println("Anim " + Globals.StatusAnim[a1].field_0, OsdColor.RED);
                    }
                }
                Seq.DrawCustomSequence(v2, Globals.StatusAnim[a1].field_2, xoffs, 0, 0, 0, stat);
            } else {
                Seq.DrawStatusSequence(v2, Globals.StatusAnim[a1].field_2, 0);
            }
            if (Globals.StatusAnim[a1].field_2 >= Seq.SeqSize[v2] - 1 && (StatusAnim.StatusAnimFlags[a1] & 0x10) == 0) {
                --Globals.StatusAnim[a1].field_4;
                if (Globals.StatusAnim[a1].field_4 <= 0) {
                    View.DestroyStatusAnim(a1);
                }
            }
            a1 = Globals.StatusAnim[a1].field_6;
        }
    }

    public static void DestroyStatusAnim(int result) {
        byte v1 = Globals.StatusAnim[result].field_6;
        byte v2 = Globals.StatusAnim[result].field_7;
        if (v2 >= 0) {
            Globals.StatusAnim[Globals.StatusAnim[result].field_7].field_6 = v1;
        }
        if (v1 >= 0) {
            Globals.StatusAnim[v1].field_7 = v2;
        }
        if (result == Globals.nFirstAnim) {
            Globals.nFirstAnim = v1;
        }
        if (result == Globals.nLastAnim) {
            Globals.nLastAnim = v2;
        }
        int v3 = Globals.nAnimsFree_X_1 + 1;
        StatusAnim.StatusAnimsFree[Globals.nAnimsFree_X_1] = (byte)result;
        Globals.nAnimsFree_X_1 = v3;
    }

    public static void analyzesprites(int smoothratio) {
        Renderer renderer = Main.game.getRenderer();
        RenderedSpriteList renderedSpriteList = renderer.getRenderedSprites();
        for (int i = 0; i < renderedSpriteList.getSize(); ++i) {
            Sector sec;
            Interpolation.ILoc oldLoc;
            int enemy;
            Sprite pTSprite = (Sprite)renderedSpriteList.get(i);
            if (pTSprite.getOwner() == -1) continue;
            if ((pTSprite.getPicnum() == 338 || pTSprite.getPicnum() == 350) && (pTSprite.getCstat() & 0x80) == 0) {
                pTSprite.setCstat(pTSprite.getCstat() | 0x80);
                pTSprite.setZ(pTSprite.getZ() - (Main.engine.getTile(pTSprite.getPicnum()).getHeight() * pTSprite.getYrepeat() << 1));
            }
            if (Globals.nSnakeCam >= 0 && (enemy = Snake.SnakeList[Globals.nSnakeCam].nTarget) > -1 && pTSprite.getOwner() == enemy && (Globals.totalmoves & 1) == 0) {
                pTSprite.setPal(5);
            }
            if ((oldLoc = Main.game.pInt.getsprinterpolate(pTSprite.getOwner())) != null) {
                int x = oldLoc.x;
                int y = oldLoc.y;
                int z = oldLoc.z;
                short nAngle = oldLoc.ang;
                nAngle = (short)(nAngle + (short)Pragmas.mulscale((pTSprite.getAng() - oldLoc.ang + 1024 & 0x7FF) - 1024, smoothratio, 16));
                pTSprite.setX(x += Pragmas.mulscale(pTSprite.getX() - oldLoc.x, smoothratio, 16));
                pTSprite.setY(y += Pragmas.mulscale(pTSprite.getY() - oldLoc.y, smoothratio, 16));
                pTSprite.setZ(z += Pragmas.mulscale(pTSprite.getZ() - oldLoc.z, smoothratio, 16));
                pTSprite.setAng(nAngle);
            }
            if ((sec = Main.boardService.getSector(pTSprite.getSectnum())) == null) continue;
            int shade = sec.getFloorshade() + 10;
            if ((sec.getCeilingstat() & 1) != 0) {
                shade = sec.getCeilingshade() + 10;
            }
            pTSprite.setShade((byte)Gameutils.BClipRange(pTSprite.getShade() + shade, -127, 127));
        }
        int nPlayer = Globals.PlayerList[Globals.nLocalPlayer].spriteId;
        int v29 = 20;
        int v31 = 30000;
        Sprite pPlayer = Main.boardService.getSprite(nPlayer);
        if (pPlayer == null) {
            return;
        }
        Globals.besttarget = -1;
        int px = pPlayer.getX();
        int py = pPlayer.getY();
        int pz = pPlayer.getZ() - Sprites.GetSpriteHeight(nPlayer) / 2;
        short nSector = pPlayer.getSectnum();
        int pang = 2048 - pPlayer.getAng() & 0x7FF;
        int spr = renderedSpriteList.getSize();
        while (--spr >= 0) {
            int sin;
            Sprite pTSprite = (Sprite)renderedSpriteList.get(spr);
            short nOwner = pTSprite.getOwner();
            Sprite pSprite = Main.boardService.getSprite(nOwner);
            if (pSprite == null) continue;
            if (!(Globals.bCamera || nOwner != nPlayer && nOwner != Globals.nDoppleSprite[Globals.nLocalPlayer])) {
                pTSprite.setOwner(-1);
                continue;
            }
            if (pSprite.getStatnum() <= 0) continue;
            RunList.SignalRun(pSprite.getLotag() - 1, 0x90000 | spr);
            if (pSprite.getStatnum() >= 150 || (pSprite.getCstat() & 0x101) == 0 || nOwner == nPlayer) continue;
            int dx = pSprite.getX() - px;
            int dy = pSprite.getY() - py;
            int cos = EngineUtils.cos(pang);
            int v17 = Pragmas.klabs(cos * dx - (sin = EngineUtils.sin(pang)) * dy >> 14);
            if (v17 == 0) continue;
            int v20 = 32 * Pragmas.klabs(sin * dx + dy * cos >> 14) / v17;
            if (v17 >= 1000 || v17 >= v31 || v20 >= 10) {
                int v22;
                if (v17 >= 30000 || (v22 = v29 - v20) <= 3 && (v17 >= v31 || Pragmas.klabs(v22) >= 5)) continue;
                v29 = v20;
                v31 = v17;
                Globals.besttarget = nOwner;
                continue;
            }
            v29 = v20;
            v31 = v17;
            Globals.besttarget = nOwner;
        }
        Sprite pBest = Main.boardService.getSprite(Globals.besttarget);
        if (pBest != null) {
            Globals.nCreepyTimer = 180;
            if (!Main.engine.cansee(px, py, pz, nSector, pBest.getX(), pBest.getY(), pBest.getZ() - Sprites.GetSpriteHeight(Globals.besttarget), pBest.getSectnum())) {
                Globals.besttarget = -1;
            }
        }
    }

    public static void viewDrawStats(int x, int y, int zoom) {
        if (Main.cfg.gShowStat == 0 || Main.cfg.gShowStat == 2 && nOverhead == 0) {
            return;
        }
        Renderer renderer = Main.game.getRenderer();
        float viewzoom = (float)zoom / 65536.0f;
        Font f = Main.game.getFont(2);
        Strhandler.buildString(statbuffer, 0, "K: ");
        int alignx = f.getWidth(statbuffer, viewzoom);
        int yoffset = (int)(2.5f * (float)f.getSize() * viewzoom);
        int staty = y -= yoffset;
        f.drawTextScaled(renderer, x, staty, statbuffer, viewzoom, 0, 20, TextAlign.Left, Transparent.None, ConvertType.AlignLeft, true);
        int offs = Strhandler.Bitoa(Globals.nCreaturesMax - Globals.nCreaturesLeft, statbuffer);
        Strhandler.buildString(statbuffer, offs, " / ", Globals.nCreaturesMax);
        f.drawTextScaled(renderer, x + (alignx + 2), staty, statbuffer, viewzoom, 0, 15, TextAlign.Left, Transparent.None, ConvertType.AlignLeft, true);
        staty = y + (int)(8.0f * viewzoom);
        Strhandler.buildString(statbuffer, 0, "T: ");
        f.drawTextScaled(renderer, x, staty, statbuffer, viewzoom, 0, 20, TextAlign.Left, Transparent.None, ConvertType.AlignLeft, true);
        alignx = f.getWidth(statbuffer, viewzoom);
        int sec = Globals.totalmoves / 30 % 60;
        int minutes = Globals.totalmoves / 1800 % 60;
        int hours = Globals.totalmoves / 108000 % 60;
        offs = Strhandler.Bitoa(hours, statbuffer, 2);
        offs = Strhandler.buildString(statbuffer, offs, ":", minutes, 2);
        Strhandler.buildString(statbuffer, offs, ":", sec, 2);
        f.drawTextScaled(renderer, x + (alignx + 2), staty, statbuffer, viewzoom, 0, 15, TextAlign.Left, Transparent.None, ConvertType.AlignLeft, true);
    }
}

