/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck.Factory;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.Arrays;
import ru.m210projects.Build.Architecture.common.audio.SoundData;
import ru.m210projects.Build.Architecture.common.audio.Source;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.LittleEndian;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Redneck.Actors;
import ru.m210projects.Redneck.Globals;
import ru.m210projects.Redneck.Input;
import ru.m210projects.Redneck.Main;
import ru.m210projects.Redneck.Menus.NetworkMenu;
import ru.m210projects.Redneck.Player;
import ru.m210projects.Redneck.Premap;
import ru.m210projects.Redneck.RSector;
import ru.m210projects.Redneck.Screen;
import ru.m210projects.Redneck.Sounds;
import ru.m210projects.Redneck.Types.GameInfo;
import ru.m210projects.Redneck.Types.PLocation;
import ru.m210projects.Redneck.Types.PlayerStruct;
import ru.m210projects.Redneck.Types.SafeLoader;
import ru.m210projects.Redneck.View;

public class RRNetwork
extends BuildNet {
    public static final byte kPacketMessage = 4;
    public static final byte kPacketSound = 5;
    public static final byte kPacketProfile = 6;
    public static final byte kPacketContentRequest = 8;
    public static final byte kPacketContentAnswer = 9;
    public static final byte kPacketPlayer = 10;
    public final int nNetVersion = 500;
    public int PlayerSyncRequest = -1;
    public int PlayerSyncTrail = -1;
    public final PLocation[] predictFifo = new PLocation[256];
    public final PLocation predict = new PLocation();
    public final PLocation predictOld = new PLocation();
    public final byte[] gContentFound = new byte[16];
    public final Main app;
    private final char[] recbuf = new char[80];

    public RRNetwork(Main app) {
        super(app);
        this.app = app;
        for (int i = 0; i < 256; ++i) {
            this.predictFifo[i] = new PLocation();
        }
        Arrays.fill(this.gContentFound, (byte)-1);
    }

    @Override
    public BuildNet.NetInput newInstance() {
        return new Input();
    }

    @Override
    public int GetPackets(byte[] p, int ptr, int len, int nPlayer) {
        switch (p[ptr++]) {
            case 9: {
                this.gContentFound[nPlayer] = p[ptr];
                return 1;
            }
            case 10: {
                int num = this.packbuf[ptr++];
                int trail = LittleEndian.getInt(p, ptr);
                this.PlayerSyncRequest = num;
                this.PlayerSyncTrail = trail;
                break;
            }
            case 8: {
                int found = 0;
                try (ByteArrayInputStream is = new ByteArrayInputStream(p, ptr + 4, len);){
                    boolean isAddon = StreamUtils.readBoolean(is);
                    String path = StreamUtils.readDataString(is);
                    long crc32 = StreamUtils.readLong(is);
                    FileEntry fil = Directory.DUMMY_ENTRY;
                    GameInfo ini = null;
                    if (isAddon) {
                        boolean isPacked = StreamUtils.readBoolean(is);
                        String addonPackedIniName = null;
                        if (isPacked) {
                            addonPackedIniName = StreamUtils.readDataString(is);
                        }
                        ini = SafeLoader.findAddon(path, addonPackedIniName);
                    } else {
                        fil = this.game.getCache().getGameDirectory().getEntry(FileUtils.getPath(path, new String[0]));
                    }
                    if (fil.exists() || ini != null) {
                        NetworkMenu network = (NetworkMenu)this.app.menu.mMenus[11];
                        if (ini != null) {
                            long mycrc = ini.getEpisodeEntry().getFileEntry().getChecksum();
                            if (mycrc == crc32) {
                                found = 1;
                                network.setEpisode(ini);
                            } else {
                                found = 2;
                                Console.out.println("Player" + nPlayer + " - " + Globals.ud.user_name[nPlayer] + " tried to set user content. User content found, but has a different checksum!", OsdColor.RED);
                                Console.out.println("Make sure that you have the same content: " + File.separator + path, OsdColor.RED);
                                if (!Console.out.isShowing()) {
                                    Console.out.onToggle();
                                }
                            }
                        } else if (fil.exists() && fil.isExtension("map")) {
                            long mycrc = fil.getChecksum();
                            if (mycrc == crc32) {
                                found = 1;
                                network.setMap(fil);
                            } else {
                                found = 2;
                                Console.out.println("Player" + nPlayer + " - " + Globals.ud.user_name[nPlayer] + " tried to set user content. User content found, but has a different checksum!", OsdColor.RED);
                                Console.out.println("Make sure that you have the same content: " + File.separator + path, OsdColor.RED);
                                if (!Console.out.isShowing()) {
                                    Console.out.onToggle();
                                }
                            }
                        }
                    } else {
                        Console.out.println("Player" + nPlayer + " - " + Globals.ud.user_name[nPlayer] + " tried to set user content. User content not found!", OsdColor.RED);
                        Console.out.println("Make sure that you have content at the same path: " + File.separator + path, OsdColor.RED);
                        if (!Console.out.isShowing()) {
                            Console.out.onToggle();
                        }
                    }
                }
                catch (Exception e) {
                    Console.out.println(e.toString(), OsdColor.RED);
                }
                this.packbuf[0] = 9;
                this.packbuf[1] = found;
                Mmulti.sendpacket(nPlayer, this.packbuf, 2);
                return 1;
            }
            case -4: {
                this.retransmit(nPlayer, this.packbuf, len);
                ptr = 5;
                int nCheckVersion = LittleEndian.getInt(p, ptr);
                Globals.pNetInfo.set(p, ptr += 4);
                short i = Mmulti.connecthead;
                while (i >= 0) {
                    Premap.resetweapons(i);
                    Premap.resetinventory(i);
                    i = Mmulti.connectpoint2[i];
                }
                if (nCheckVersion != 500) {
                    this.NetDisconnect(Mmulti.myconnectindex);
                    throw new AssertException("These versions of Blood cannot play together.");
                }
                if (!this.WaitForAllPlayers(0)) break;
                Main.gGameScreen.newgame(true, ((NetworkMenu)this.app.menu.mMenus[11]).getFile(), Globals.pNetInfo.nEpisode, Globals.pNetInfo.nLevel, Globals.pNetInfo.nDifficulty);
                break;
            }
            case 7: {
                return this.GetDisconnectPacket(p, ptr, len, nPlayer, nDelete -> {
                    Main.gDemoScreen.onStopRecord();
                    Globals.ud.multimode = Mmulti.numplayers - 1;
                    if (this.game.isCurrentScreen(Main.gGameScreen)) {
                        Player.quickkill(Globals.ps[nDelete]);
                        Main.engine.deletesprite(Globals.ps[nDelete].i);
                    }
                    Strhandler.buildString(Globals.buf, 0, Globals.ud.user_name[nDelete], " is history!");
                    Screen.vscrn(Globals.ud.screen_size);
                    View.adduserquote(Globals.buf);
                });
            }
            case 5: {
                Source voice;
                SoundData data;
                this.retransmit(nPlayer, this.packbuf, len);
                if (Main.cfg.isNoSound() || Globals.ud.lockout == 1 || Main.RTS_File == null || Main.RTS_File.getSize() == 0) break;
                Entry entry = Main.RTS_File.getEntry(this.packbuf[1]);
                if (entry.exists() && (data = Sounds.audio.getSoundDecoder("VOC").decode(entry)) != null && (voice = Sounds.newSound(data.getData(), data.getRate(), data.getBits(), 255)) != null) {
                    voice.play(1.0f);
                }
                Sounds.rtsplaying = (char)7;
                break;
            }
            case 4: {
                this.retransmit(nPlayer, this.packbuf, len);
                for (int i = 0; i < len - 2; ++i) {
                    this.recbuf[i] = (char)this.packbuf[i + 2];
                }
                this.recbuf[len - 2] = '\u0000';
                View.adduserquote(this.recbuf);
                Sounds.sound(243);
                break;
            }
            case 6: {
                this.retransmit(nPlayer, this.packbuf, len);
                byte nP = this.packbuf[1];
                len = 0;
                int i = 3;
                while (this.packbuf[i] != 0) {
                    ++len;
                    ++i;
                }
                Globals.ud.user_name[nP] = new String(this.packbuf, 3, len);
                int j = ++i;
                while (i - j < 10) {
                    Globals.ud.wchoice[nP][i - j] = this.packbuf[i];
                    ++i;
                }
                Globals.ps[nP].aim_mode = this.packbuf[i++];
                Globals.ps[nP].auto_aim = this.packbuf[i];
                break;
            }
            case -1: {
                this.game.gExit = true;
            }
        }
        return 0;
    }

    @Override
    public void UpdatePrediction(BuildNet.NetInput input) {
        int nwall;
        Wall hwp;
        int i;
        Sprite hsp;
        int k;
        boolean shrunk;
        Input syn = (Input)input;
        PlayerStruct p = Globals.ps[Mmulti.myconnectindex];
        Sprite psp = Main.boardService.getSprite(p.i);
        if (psp == null) {
            return;
        }
        short backcstat = psp.getCstat();
        psp.setCstat(psp.getCstat() & 0xFFFFFEFE);
        int sb_snum = syn.bits;
        int psect = this.predict.sectnum;
        Sector psec = Main.boardService.getSector(psect);
        if (psec == null) {
            return;
        }
        short psectlotag = psec.getLotag();
        boolean spritebridge = false;
        if (psectlotag == 848 && psec.getFloorpicnum() == 1045) {
            psectlotag = 1;
        }
        int clipdist = 64;
        if (psectlotag == 857) {
            clipdist = 1;
        }
        boolean bl = shrunk = psp.getYrepeat() < 8;
        if (!Globals.ud.clipping && psec.getFloorpicnum() == 1089) {
            this.predict.x = this.predictOld.x;
            this.predict.y = this.predictOld.y;
        }
        this.predictOld.copy(this.predict);
        Main.engine.getzrange(this.predict.x, this.predict.y, this.predict.z, psect, 163, 65537);
        if (p.OnMotorcycle && psp.getExtra() > 0) {
            boolean var4 = false;
            boolean var5 = false;
            boolean var1 = false;
            boolean var3 = false;
            if ((sb_snum & 2) != 0) {
                var1 = true;
                sb_snum &= 0xFFFFFFFD;
            }
            if ((sb_snum & 1) != 0) {
                sb_snum &= 0xFFFFFFFE;
            }
            if ((sb_snum & 8) != 0) {
                sb_snum &= 0xFFFFFFF7;
                var3 = true;
            }
            if ((sb_snum & 0x10) != 0) {
                var4 = true;
                sb_snum &= 0xFFFFFFEF;
            }
            if ((sb_snum & 0x40) != 0) {
                var5 = true;
                sb_snum &= 0xFFFFFFBF;
            }
            if (p.on_ground && var3 && p.CarSpeed <= 0 && !var1) {
                p.CarSpeed = (short)-15;
                boolean swap = var5;
                var5 = var4;
                var4 = swap;
            }
            if (p.CarSpeed >= 20 && p.on_ground && (var4 || var5)) {
                int angvel = (int)(this.predict.ang - 510.0f);
                if (var4) {
                    angvel = (int)(this.predict.ang + 510.0f);
                }
                int dang = 350;
                if (!var4) {
                    dang = -350;
                }
                if (p.CarVar5 != 0 || p.CarVar4 != 0 || p.NotOnWater == 0) {
                    int speed = 4 * p.CarSpeed;
                    if (p.CarVar4 != 0) {
                        speed = 8 * p.CarSpeed;
                    }
                    if (p.CarVar6 != 0) {
                        this.predict.xvel += (speed >> 5) * 16 * EngineUtils.sin(angvel + 512 & 0x7FF);
                        this.predict.yvel += (speed >> 5) * 16 * EngineUtils.sin(angvel & 0x7FF);
                        this.predict.ang = (short)this.predict.ang - (dang >> 2) & 0x7FF;
                    } else {
                        this.predict.xvel += (speed >> 7) * 16 * EngineUtils.sin(angvel + 512 & 0x7FF);
                        this.predict.yvel += (speed >> 7) * 16 * EngineUtils.sin(angvel & 0x7FF);
                        this.predict.ang = (short)this.predict.ang - (dang >> 6) & 0x7FF;
                    }
                } else if (p.CarVar6 != 0) {
                    this.predict.xvel += (p.CarSpeed >> 5) * 16 * EngineUtils.sin(angvel + 512 & 0x7FF);
                    this.predict.yvel += (p.CarSpeed >> 5) * 16 * EngineUtils.sin(angvel & 0x7FF);
                    this.predict.ang = (short)this.predict.ang - (dang >> 4) & 0x7FF;
                } else {
                    this.predict.xvel += (p.CarSpeed >> 7) * 16 * EngineUtils.sin(angvel + 512 & 0x7FF);
                    this.predict.yvel += (p.CarSpeed >> 7) * 16 * EngineUtils.sin(angvel & 0x7FF);
                    this.predict.ang = (short)this.predict.ang - (dang >> 4) & 0x7FF;
                }
            }
        } else if (p.OnBoat && psp.getExtra() > 0) {
            boolean var5 = false;
            boolean var6 = false;
            if ((sb_snum & 1) != 0) {
                sb_snum &= 0xFFFFFFFE;
            }
            if ((sb_snum & 2) != 0) {
                sb_snum &= 0xFFFFFFFD;
            }
            if ((sb_snum & 8) != 0) {
                sb_snum &= 0xFFFFFFF7;
            }
            if ((sb_snum & 0x10) != 0) {
                var5 = true;
                sb_snum &= 0xFFFFFFEF;
            }
            if ((sb_snum & 0x40) != 0) {
                var6 = true;
                sb_snum &= 0xFFFFFFBF;
            }
            if (p.CarSpeed > 0 && p.on_ground && (var5 || var6)) {
                int angvel = (int)(this.predict.ang - 510.0f);
                if (var5) {
                    angvel = (int)(this.predict.ang + 510.0f);
                }
                int dang = 350;
                if (!var5) {
                    dang = -350;
                }
                int speed = 4 * p.CarSpeed;
                if (p.CarVar6 != 0) {
                    this.predict.xvel += (speed >> 6) * 16 * EngineUtils.sin(angvel + 512 & 0x7FF);
                    this.predict.yvel += (speed >> 6) * 16 * EngineUtils.sin(angvel & 0x7FF);
                    this.predict.ang = (short)this.predict.ang - (dang >> 5) & 0x7FF;
                } else {
                    this.predict.xvel += (speed >> 7) * 16 * EngineUtils.sin(angvel + 512 & 0x7FF);
                    this.predict.yvel += (speed >> 7) * 16 * EngineUtils.sin(angvel & 0x7FF);
                    this.predict.ang = (short)this.predict.ang - (dang >> 6) & 0x7FF;
                }
            }
        }
        if (clipdist == 64) {
            Main.engine.getzrange(this.predict.x, this.predict.y, this.predict.z, psect, 163, 65537);
        } else {
            Main.engine.getzrange(this.predict.x, this.predict.y, this.predict.z, psect, 4, 65537);
        }
        int cz = Engine.zr_ceilz;
        int hz = Engine.zr_ceilhit;
        int fz = Engine.zr_florz;
        int lz = Engine.zr_florhit;
        int j = Main.engine.getflorzofslope(psect, this.predict.x, this.predict.y);
        if ((lz & 0xC0000000) == 0x40000000 && psectlotag == 1 && Pragmas.klabs(this.predict.z - j) > 14336) {
            psectlotag = 0;
        }
        if (p.aim_mode == 0 && this.predict.onground && psectlotag != 2 && (psec.getFloorstat() & 2) != 0) {
            int x = (int)((double)this.predict.x + Gameutils.BCosAngle(Gameutils.BClampAngle(this.predict.ang)) / 32.0);
            int y = (int)((double)this.predict.y + Gameutils.BSinAngle(Gameutils.BClampAngle(this.predict.ang)) / 32.0);
            int tempsect = psect;
            if ((tempsect = Main.engine.updatesector(x, y, tempsect)) >= 0) {
                k = Main.engine.getflorzofslope(psect, x, y);
                if (psect == tempsect) {
                    this.predict.horizoff += Pragmas.mulscale(j - k, 160L, 16);
                } else if (Pragmas.klabs(Main.engine.getflorzofslope(tempsect, x, y) - k) <= 1024) {
                    this.predict.horizoff += Pragmas.mulscale(j - k, 160L, 16);
                }
            }
        }
        if (this.predict.horizoff > 0) {
            this.predict.horizoff -= (this.predict.horizoff >> 3) + 1;
        } else if (this.predict.horizoff < 0) {
            PLocation var5 = this.predict;
            var5.horizoff = var5.horizoff + ((-this.predict.horizoff >> 3) + 1);
        }
        if ((hz & 0xE0000000) == -1073741824 && (hsp = Main.boardService.getSprite(hz &= 0x1FFFFFFF)) != null) {
            if (hsp.getStatnum() == 1 && hsp.getExtra() >= 0) {
                cz = Main.engine.getceilzofslope(psect, this.predict.x, this.predict.y);
            }
            if (hsp.getPicnum() == 3587 && p.field_280 == 0 && (sb_snum & 1) != 0) {
                cz = p.truecz;
            }
        }
        if ((lz & 0xE0000000) == -1073741824 && (hsp = Main.boardService.getSprite(j = lz & 0x1FFFFFFF)) != null) {
            if ((hsp.getCstat() & 0x21) == 33) {
                psectlotag = 0;
                spritebridge = true;
            }
            if (Actors.badguy(hsp) && hsp.getXrepeat() > 24 && Pragmas.klabs(psp.getZ() - hsp.getZ()) < 21504) {
                j = EngineUtils.getAngle(hsp.getX() - this.predict.x, hsp.getY() - this.predict.y);
                this.predict.xvel -= EngineUtils.sin(j + 512 & 0x7FF) << 4;
                this.predict.yvel -= EngineUtils.sin(j & 0x7FF) << 4;
            }
            if (hsp.getPicnum() == 3587 && p.field_280 == 0 && (sb_snum & 2) != 0) {
                cz = hsp.getZ();
                fz = cz + 1024;
            }
        }
        if (psp.getExtra() <= 0) {
            int sect;
            if (psectlotag == 2) {
                if (p.on_warping_sector == 0 && Pragmas.klabs(this.predict.z - fz) > 5120) {
                    this.predict.z += 348;
                }
                Main.engine.clipmove(this.predict.x, this.predict.y, this.predict.z, this.predict.sectnum, 0L, 0L, 164, 1024, 1024, 65537);
                if (Engine.clipmove_sectnum != -1) {
                    this.predict.x = Engine.clipmove_x;
                    this.predict.y = Engine.clipmove_y;
                    this.predict.z = Engine.clipmove_z;
                    this.predict.sectnum = Engine.clipmove_sectnum;
                }
            }
            if ((sect = Main.engine.updatesector(this.predict.x, this.predict.y, this.predict.sectnum)) != -1) {
                this.predict.sectnum = sect;
            }
            Main.engine.pushmove(this.predict.x, this.predict.y, this.predict.z, this.predict.sectnum, 128, 1024, 5120, 65537);
            if (Engine.pushmove_sectnum != -1) {
                this.predict.x = Engine.pushmove_x;
                this.predict.y = Engine.pushmove_y;
                this.predict.z = Engine.pushmove_z;
                this.predict.sectnum = Engine.pushmove_sectnum;
            }
            this.predict.horiz = 100.0f;
            this.predict.horizoff = 0;
            this.predictFifo[this.gPredictTail & 0xFF].copy(this.predict);
            ++this.gPredictTail;
            psp.setCstat(backcstat);
            return;
        }
        int doubvel = 4;
        if (p.on_crane < 0) {
            if (p.one_eighty_count < 0) {
                this.predict.ang += 128.0f;
            }
            i = 40;
            if (psectlotag == 2) {
                this.predict.jumpingcounter = 0;
                if ((sb_snum & 1) != 0 && !p.OnMotorcycle && !p.OnBoat) {
                    if (this.predict.zvel > 0) {
                        this.predict.zvel = 0;
                    }
                    this.predict.zvel -= 348;
                    if (this.predict.zvel < -1536) {
                        this.predict.zvel = -1536;
                    }
                } else if ((sb_snum & 2) != 0 && !p.OnMotorcycle && !p.OnBoat) {
                    if (this.predict.zvel < 0) {
                        this.predict.zvel = 0;
                    }
                    this.predict.zvel += 348;
                    if (this.predict.zvel > 1536) {
                        this.predict.zvel = 1536;
                    }
                } else if (p.OnMotorcycle) {
                    if (this.predict.zvel < 0) {
                        this.predict.zvel = 0;
                    }
                    this.predict.zvel += 348;
                    if (this.predict.zvel > 1536) {
                        this.predict.zvel = 1536;
                    }
                } else {
                    if (this.predict.zvel < 0) {
                        this.predict.zvel += 256;
                        if (this.predict.zvel > 0) {
                            this.predict.zvel = 0;
                        }
                    }
                    if (this.predict.zvel > 0) {
                        this.predict.zvel -= 256;
                        if (this.predict.zvel < 0) {
                            this.predict.zvel = 0;
                        }
                    }
                }
                if (this.predict.zvel > 2048) {
                    this.predict.zvel >>= 1;
                }
                this.predict.z += this.predict.zvel;
                if (this.predict.z > fz - 3840) {
                    this.predict.z += fz - 3840 - this.predict.z >> 1;
                }
                if (this.predict.z < cz + 1024) {
                    this.predict.z = cz + 1024;
                    this.predict.zvel = 0;
                }
            } else if (p.jetpack_on != 0) {
                this.predict.onground = false;
                this.predict.jumpingcounter = 0;
                this.predict.hardlanding = 0;
                if (p.jetpack_on < 11) {
                    this.predict.z -= p.jetpack_on << 7;
                }
                j = shrunk ? 512 : 2048;
                if ((sb_snum & 1) != 0) {
                    this.predict.z -= j;
                }
                if ((sb_snum & 2) != 0) {
                    this.predict.z += j;
                }
                if (this.predict.z > fz - ((k = !shrunk && psectlotag == 0 ? 32 : 16) << 8)) {
                    this.predict.z += fz - (k << 8) - this.predict.z >> 1;
                }
                if (this.predict.z < cz + 4608) {
                    this.predict.z = cz + 4608;
                }
            } else {
                if (psectlotag == 1 && p.spritebridge == 0) {
                    i = !shrunk ? 34 : 12;
                }
                if (this.predict.z < fz - (i << 8) && !RSector.floorspace(psect) && !RSector.ceilingspace(psect)) {
                    if ((sb_snum & 3) == 0 && this.predict.onground && (psec.getFloorstat() & 2) != 0 && this.predict.z >= fz - (i << 8) - 4096) {
                        this.predict.z = fz - (i << 8);
                    } else {
                        this.predict.onground = false;
                        this.predict.zvel = (p.OnMotorcycle || p.OnBoat) && fz - (i << 9) > this.predict.z ? (p.CarOnGround ? (this.predict.zvel -= (p.CarSpeed >> 4) * Globals.currentGame.getCON().gc) : (this.predict.zvel += 120 - p.CarSpeed + Globals.currentGame.getCON().gc - 80)) : (this.predict.zvel += Globals.currentGame.getCON().gc + 80);
                        if (this.predict.zvel >= 6144) {
                            this.predict.zvel = 6144;
                        }
                    }
                } else {
                    if (psectlotag != 1 && !this.predict.onground && this.predict.zvel > 3072) {
                        this.predict.hardlanding = (byte)(this.predict.zvel >> 10);
                    }
                    this.predict.onground = true;
                    if (i == 40) {
                        k = fz - (i << 8) - this.predict.z >> 1;
                        if (Pragmas.klabs(k) < 256) {
                            k = 0;
                        }
                        this.predict.z += k;
                        this.predict.zvel -= 768;
                        if (this.predict.zvel < 0) {
                            this.predict.zvel = 0;
                        }
                    } else if (this.predict.jumpingcounter == 0) {
                        this.predict.z += fz - (i << 7) - this.predict.z >> 1;
                        if (p.on_warping_sector == 0 && this.predict.z > fz - 4096) {
                            this.predict.z = fz - 4096;
                            this.predict.zvel >>= 1;
                        }
                    }
                    if ((sb_snum & 2) != 0 && !p.OnMotorcycle && !p.OnBoat) {
                        this.predict.z += 2816;
                    }
                    if ((sb_snum & 1) == 0 && this.predict.jumpingtoggle == 1 && !p.OnMotorcycle && !p.OnBoat) {
                        this.predict.jumpingtoggle = 0;
                    } else if ((sb_snum & 1) != 0 && this.predict.jumpingtoggle == 0 && this.predict.jumpingcounter == 0 && fz - cz > 14336) {
                        this.predict.jumpingcounter = 1;
                        this.predict.jumpingtoggle = 1;
                    }
                    if (this.predict.jumpingcounter != 0 && (sb_snum & 1) == 0) {
                        this.predict.jumpingcounter = 0;
                    }
                }
                if (this.predict.jumpingcounter != 0) {
                    if ((sb_snum & 1) == 0 && this.predict.jumpingtoggle == 1 && !p.OnMotorcycle && !p.OnBoat) {
                        this.predict.jumpingtoggle = 0;
                    }
                    if (this.predict.jumpingcounter < 768) {
                        this.predict.zvel -= EngineUtils.sin(1920 + this.predict.jumpingcounter & 0x7FF) / 12;
                        this.predict.jumpingcounter += 180;
                        this.predict.onground = false;
                    } else {
                        this.predict.jumpingcounter = 0;
                        this.predict.zvel = 0;
                    }
                }
                this.predict.z += this.predict.zvel;
                if (this.predict.z < cz + 1024) {
                    this.predict.jumpingcounter = 0;
                    if (this.predict.zvel < 0) {
                        this.predict.yvel = 0;
                        this.predict.xvel = 0;
                    }
                    this.predict.zvel = 128;
                    this.predict.z = cz + 1024;
                }
            }
            if (p.fist_incs != 0 || p.transporter_hold > 2 || this.predict.hardlanding != 0 || p.access_incs > 0 || p.knee_incs > 0 || p.curr_weapon == 8 && p.kickback_pic > 1 && p.kickback_pic < 4) {
                doubvel = 0;
                this.predict.xvel = 0;
                this.predict.yvel = 0;
            } else if (syn.avel != 0.0f) {
                long tempang = (long)(syn.avel * 2.0f);
                this.predict.ang = psectlotag == 2 ? (this.predict.ang += (float)((tempang - (tempang >> 3)) * (long)Pragmas.ksgn(doubvel))) : (this.predict.ang += (float)(tempang * (long)Pragmas.ksgn(doubvel)));
                this.predict.ang = Gameutils.BClampAngle(this.predict.ang);
            }
            if (this.predict.xvel != 0 || this.predict.yvel != 0 || syn.fvel != 0 || syn.svel != 0) {
                if (p.jetpack_on == 0 && p.moonshine_amount > 0 && p.moonshine_amount < 400) {
                    doubvel <<= 1;
                }
                this.predict.xvel += syn.fvel * doubvel << 6;
                this.predict.yvel += syn.svel * doubvel << 6;
                if (psectlotag == 2) {
                    this.predict.xvel = Pragmas.mulscale(this.predict.xvel, Globals.currentGame.getCON().dukefriction - 5120, 16);
                    this.predict.yvel = Pragmas.mulscale(this.predict.yvel, Globals.currentGame.getCON().dukefriction - 5120, 16);
                } else {
                    this.predict.xvel = Pragmas.mulscale(this.predict.xvel, Globals.currentGame.getCON().dukefriction, 16);
                    this.predict.yvel = Pragmas.mulscale(this.predict.yvel, Globals.currentGame.getCON().dukefriction, 16);
                }
                switch (psec.getFloorpicnum()) {
                    case 7889: {
                        if (p.OnMotorcycle || p.boot_amount > 0) break;
                        this.predict.xvel = Pragmas.mulscale(this.predict.xvel, Globals.currentGame.getCON().dukefriction, 16);
                        this.predict.yvel = Pragmas.mulscale(this.predict.yvel, Globals.currentGame.getCON().dukefriction, 16);
                        break;
                    }
                    case 2702: 
                    case 3073: {
                        if (p.OnMotorcycle) {
                            if (!p.on_ground) break;
                            this.predict.xvel = Pragmas.mulscale(this.predict.xvel, Globals.currentGame.getCON().dukefriction - 6144, 16);
                            this.predict.yvel = Pragmas.mulscale(this.predict.yvel, Globals.currentGame.getCON().dukefriction - 6144, 16);
                            break;
                        }
                        if (p.boot_amount > 0) break;
                        this.predict.xvel = Pragmas.mulscale(this.predict.xvel, Globals.currentGame.getCON().dukefriction - 6144, 16);
                        this.predict.yvel = Pragmas.mulscale(this.predict.yvel, Globals.currentGame.getCON().dukefriction - 6144, 16);
                    }
                }
                if (Pragmas.klabs(this.predict.xvel) < 2048 && Pragmas.klabs(this.predict.yvel) < 2048) {
                    this.predict.yvel = 0;
                    this.predict.xvel = 0;
                }
                if (shrunk) {
                    this.predict.xvel = Pragmas.mulscale(this.predict.xvel, Globals.currentGame.getCON().dukefriction - (Globals.currentGame.getCON().dukefriction >> 1) + (Globals.currentGame.getCON().dukefriction >> 2), 16);
                    this.predict.yvel = Pragmas.mulscale(this.predict.yvel, Globals.currentGame.getCON().dukefriction - (Globals.currentGame.getCON().dukefriction >> 1) + (Globals.currentGame.getCON().dukefriction >> 2), 16);
                }
            }
        }
        i = psectlotag == 1 || spritebridge ? 1024 : 5120;
        j = Main.engine.clipmove(this.predict.x, this.predict.y, this.predict.z, this.predict.sectnum, this.predict.xvel, this.predict.yvel, 164, 1024, i, 65537);
        if (Engine.clipmove_sectnum != -1) {
            this.predict.x = Engine.clipmove_x;
            this.predict.y = Engine.clipmove_y;
            this.predict.z = Engine.clipmove_z;
            this.predict.sectnum = Engine.clipmove_sectnum;
        }
        if ((j & 0xE0000000) == Integer.MIN_VALUE && (hwp = Main.boardService.getWall(nwall = j & 0x1FFFFFFF)) != null && !p.OnMotorcycle && !p.OnBoat && hwp.getLotag() >= 40 && hwp.getLotag() <= 44) {
            Main.engine.pushmove(this.predict.x, this.predict.y, this.predict.z, this.predict.sectnum, 172, 1024, 1024, 65537);
            if (Engine.pushmove_sectnum != -1) {
                this.predict.x = Engine.pushmove_x;
                this.predict.y = Engine.pushmove_y;
                this.predict.z = Engine.pushmove_z;
                this.predict.sectnum = Engine.pushmove_sectnum;
            }
        }
        if (clipdist == 64) {
            Main.engine.pushmove(this.predict.x, this.predict.y, this.predict.z, this.predict.sectnum, 128, 1024, 1024, 65537);
        } else {
            Main.engine.pushmove(this.predict.x, this.predict.y, this.predict.z, this.predict.sectnum, 16, 1024, 1024, 65537);
        }
        if (Engine.pushmove_sectnum != -1) {
            this.predict.x = Engine.pushmove_x;
            this.predict.y = Engine.pushmove_y;
            this.predict.z = Engine.pushmove_z;
            this.predict.sectnum = Engine.pushmove_sectnum;
        }
        if (p.jetpack_on == 0 && psectlotag != 1 && psectlotag != 2 && shrunk) {
            this.predict.z += 7680;
        }
        if ((sb_snum & 0x40000) != 0 || this.predict.hardlanding != 0) {
            this.predict.returntocenter = (byte)9;
        }
        if ((sb_snum & 0x2000) != 0) {
            this.predict.returntocenter = (byte)9;
            if ((sb_snum & 0x20) != 0) {
                this.predict.horiz += 6.0f;
            }
            this.predict.horiz += 6.0f;
        } else if ((sb_snum & 0x4000) != 0) {
            this.predict.returntocenter = (byte)9;
            if ((sb_snum & 0x20) != 0) {
                this.predict.horiz -= 6.0f;
            }
            this.predict.horiz -= 6.0f;
        } else if ((sb_snum & 8) != 0 && !p.OnMotorcycle && !p.OnBoat) {
            if ((sb_snum & 0x20) != 0) {
                this.predict.horiz += 6.0f;
            }
            this.predict.horiz += 6.0f;
        } else if ((sb_snum & 0x10) != 0 && !p.OnMotorcycle && !p.OnBoat) {
            if ((sb_snum & 0x20) != 0) {
                this.predict.horiz -= 6.0f;
            }
            this.predict.horiz -= 6.0f;
        }
        if (this.predict.returntocenter > 0 && (sb_snum & 0x2000) == 0 && (sb_snum & 0x4000) == 0) {
            this.predict.returntocenter = (byte)(this.predict.returntocenter - 1);
            this.predict.horiz += 33.0f - this.predict.horiz / 3.0f;
        }
        if (p.aim_mode != 0) {
            this.predict.horiz += syn.horz / 2.0f;
        } else {
            if (this.predict.horiz > 95.0f && this.predict.horiz < 105.0f) {
                this.predict.horiz = 100.0f;
            }
            if (this.predict.horizoff > -5 && this.predict.horizoff < 5) {
                this.predict.horizoff = 0;
            }
        }
        if (this.predict.hardlanding > 0) {
            this.predict.hardlanding = (byte)(this.predict.hardlanding - 1);
            this.predict.horiz -= (float)(this.predict.hardlanding << 4);
        }
        if (this.predict.horiz > 299.0f) {
            this.predict.horiz = 299.0f;
        } else if (this.predict.horiz < -99.0f) {
            this.predict.horiz = -99.0f;
        }
        if (p.knee_incs > 0) {
            this.predict.horiz -= 48.0f;
            this.predict.returntocenter = (byte)9;
        }
        this.predictFifo[this.gPredictTail & 0xFF].copy(this.predict);
        ++this.gPredictTail;
        psp.setCstat(backcstat);
    }

    @Override
    public void CorrectPrediction() {
        if (Mmulti.numplayers < 2) {
            return;
        }
        PLocation pFifo = this.predictFifo[this.gNetFifoTail - 1 & 0xFF];
        PlayerStruct p = Globals.ps[Mmulti.myconnectindex];
        if (pFifo.ang == p.ang && pFifo.horiz == p.horiz && pFifo.x == p.posx && pFifo.y == p.posy && pFifo.z == p.posz && pFifo.lookang == p.look_ang && pFifo.rotscrnang == p.rotscrnang) {
            return;
        }
        this.predict.reset();
        this.predictOld.copy(p.prevView);
        this.gPredictTail = this.gNetFifoTail;
        while (this.gPredictTail < this.gNetFifoHead[Mmulti.myconnectindex]) {
            this.UpdatePrediction(this.gFifoInput[this.gPredictTail & 0xFF][Mmulti.myconnectindex]);
        }
    }

    @Override
    public void CalcChecksum() {
        Sprite psp;
        if ((Mmulti.numplayers >= 2 || Globals.mFakeMultiplayer) && (this.gNetFifoTail & 7) == 7) {
            Arrays.fill(this.gChecksum, 0);
            this.gChecksum[0] = Main.engine.getrand();
            int i = Mmulti.connecthead;
            while (i >= 0) {
                psp = Main.boardService.getSprite(Globals.ps[i].i);
                this.gChecksum[1] = this.gChecksum[1] ^ (int)this.checksum(Globals.ps[i]);
                if (psp != null) {
                    this.gChecksum[2] = this.gChecksum[2] ^ (int)this.checksum(psp);
                }
                i = Mmulti.connectpoint2[i];
            }
            for (i = 0; i < this.gChecksum.length; ++i) {
                LittleEndian.putInt(this.gCheckFifo[Mmulti.myconnectindex], 16 * (this.gCheckHead[Mmulti.myconnectindex] & 0xFF) + 4 * i, this.gChecksum[i]);
            }
            short s = Mmulti.myconnectindex;
            this.gCheckHead[s] = this.gCheckHead[s] + 1;
        }
        if (this.PlayerSyncRequest != -1) {
            if (Mmulti.myconnectindex != Mmulti.connecthead && this.gNetFifoTail < this.PlayerSyncTrail) {
                return;
            }
            int pnum = this.PlayerSyncRequest;
            psp = Main.boardService.getSprite(Globals.ps[pnum].i);
            Console.out.println("Player: " + pnum);
            Console.out.println(Globals.ps[pnum].toString());
            if (psp != null) {
                Console.out.println("Sprite: ");
                Console.out.println(psp.toString());
            }
            Console.out.println("gNetFifoTail: " + this.gNetFifoTail);
            this.PlayerSyncTrail = -1;
            this.PlayerSyncRequest = -1;
        }
    }

    @Override
    public void NetDisconnect(int nPlayer) {
        super.NetDisconnect(nPlayer);
        this.app.Disconnect();
    }

    public boolean WaitForContentCheck(byte[] contentPacket, int timeout) {
        int i;
        Arrays.fill(this.gContentFound, (byte)-1);
        if (Mmulti.numplayers < 2) {
            return true;
        }
        this.WaitForSend();
        this.packbuf[0] = 8;
        int len = Math.min(contentPacket.length, 250);
        LittleEndian.putInt(this.packbuf, 1, len);
        System.arraycopy(contentPacket, 0, this.packbuf, 5, len);
        this.sendtoall(this.packbuf, len + 5);
        this.gContentFound[Mmulti.myconnectindex] = 1;
        long starttime = System.currentTimeMillis();
        block0: do {
            long time = System.currentTimeMillis() - starttime;
            if (timeout != 0 && time > (long)timeout) {
                Console.out.println("Connection timed out!", OsdColor.YELLOW);
                return false;
            }
            this.GetPackets();
            i = Mmulti.connecthead;
            while (i >= 0 && this.gContentFound[i] != -1) {
                if (Mmulti.myconnectindex != Mmulti.connecthead) {
                    i = -1;
                    continue block0;
                }
                i = Mmulti.connectpoint2[i];
            }
        } while (i >= 0);
        i = Mmulti.connecthead;
        while (i >= 0) {
            if (this.gContentFound[i] != 1) {
                return false;
            }
            i = Mmulti.connectpoint2[i];
        }
        return true;
    }

    public void getnames() {
        Globals.ud.user_name[Mmulti.myconnectindex] = Main.cfg.getpName();
        byte[] buf = new byte[256];
        if (Mmulti.numplayers > 1) {
            int i;
            buf[0] = 6;
            buf[1] = (byte)Mmulti.myconnectindex;
            buf[2] = -109;
            int l = 3;
            char[] name = Strhandler.toCharArray(Main.cfg.getpName());
            for (i = 0; i < Main.cfg.getpName().length() && name[i] != '\u0000'; ++i) {
                buf[l++] = (byte)name[i];
            }
            buf[l++] = 0;
            for (i = 0; i < 10; ++i) {
                Globals.ud.wchoice[Mmulti.myconnectindex][i] = Globals.ud.wchoice[0][i];
                buf[l++] = (byte)Globals.ud.wchoice[0][i];
            }
            buf[l++] = (byte)Globals.ps[Mmulti.myconnectindex].aim_mode;
            buf[l++] = (byte)Globals.ps[Mmulti.myconnectindex].auto_aim;
            this.WaitForSend();
            this.sendtoall(buf, l);
            this.GetPackets();
        }
    }

    public void SendMessage(int sendmessagecommand, char[] buf, int len) {
        if (sendmessagecommand != -1 || Globals.ud.multimode < 3) {
            Globals.tempbuf[0] = 4;
            Globals.tempbuf[2] = 0;
            this.recbuf[0] = '\u0000';
            if (Globals.ud.multimode < 3) {
                sendmessagecommand = 2;
            }
            int pos = Strhandler.buildString(this.recbuf, 0, Globals.ud.user_name[Mmulti.myconnectindex], ": ");
            System.arraycopy(buf, 0, this.recbuf, pos, len);
            this.recbuf[pos += len] = '\u0000';
            for (int i = 0; i < this.recbuf.length; ++i) {
                Globals.tempbuf[2 + i] = (byte)this.recbuf[i];
            }
            if (sendmessagecommand >= Globals.ud.multimode) {
                Globals.tempbuf[1] = -1;
                this.sendtoall(Globals.tempbuf, pos + 2);
                View.adduserquote(this.recbuf);
                View.quotebotgoal = View.quotebot += 8;
            } else if (sendmessagecommand >= 0) {
                Globals.tempbuf[1] = (byte)sendmessagecommand;
                if (Mmulti.myconnectindex != Mmulti.connecthead) {
                    sendmessagecommand = Mmulti.connecthead;
                }
                Mmulti.sendpacket(sendmessagecommand, Globals.tempbuf, pos + 2);
            }
        }
    }

    @Override
    public void ComputerInput(int i) {
        if (Globals.ud.playerai != 0) {
            Player.computergetinput(i, (Input)this.gFifoInput[this.gNetFifoHead[i] & 0xFF][i]);
        }
    }
}

