/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import ru.m210projects.Build.Board;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.Tools.SaveManager;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Redneck.Actors;
import ru.m210projects.Redneck.Animate;
import ru.m210projects.Redneck.Factory.RRRenderer;
import ru.m210projects.Redneck.Globals;
import ru.m210projects.Redneck.Main;
import ru.m210projects.Redneck.Menus.MenuCorruptGame;
import ru.m210projects.Redneck.Player;
import ru.m210projects.Redneck.Premap;
import ru.m210projects.Redneck.RSector;
import ru.m210projects.Redneck.ResourceHandler;
import ru.m210projects.Redneck.Screen;
import ru.m210projects.Redneck.Sounds;
import ru.m210projects.Redneck.Types.ANIMATION;
import ru.m210projects.Redneck.Types.GameInfo;
import ru.m210projects.Redneck.Types.LSInfo;
import ru.m210projects.Redneck.Types.SafeLoader;
import ru.m210projects.Redneck.Types.Weaponhit;
import ru.m210projects.Redneck.View;
import ru.m210projects.Redneck.filehandle.EpisodeEntry;

public class LoadSave {
    public static final String savsign = "RGDX";
    public static final int gdxSave = 100;
    public static final int currentGdxSave = 103;
    public static final int SAVETIME = 8;
    public static final int SAVENAME = 32;
    public static final int SAVESCREENSHOTSIZE = 16000;
    public static final char[] filenum = new char[4];
    public static boolean gQuickSaving;
    public static boolean gAutosaveRequest;
    public static final LSInfo lsInf;
    public static FileEntry lastload;
    public static int quickslot;
    public static final SafeLoader loader;

    public static void FindSaves(Directory dir) {
        for (Entry file : dir) {
            if (!file.isExtension("sav") || !(file instanceof FileEntry)) continue;
            try {
                InputStream is = file.getInputStream();
                try {
                    short nVersion;
                    String signature = StreamUtils.readString(is, 4);
                    if (signature.isEmpty() || !signature.equals(savsign) || (nVersion = StreamUtils.readShort(is)) < 100) continue;
                    long time = StreamUtils.readLong(is);
                    String savname = StreamUtils.readString(is, 32);
                    Main.game.pSavemgr.add(savname, time, (FileEntry)file);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        Main.game.pSavemgr.sort();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int lsReadLoadData(FileEntry file) {
        if (file.exists()) {
            ArtEntry pic = Main.engine.getTile(SaveManager.Screenshot);
            if (!(pic instanceof DynamicArtEntry) || !pic.exists()) {
                pic = Main.engine.allocatepermanenttile(SaveManager.Screenshot, 160, 100);
            }
            try (InputStream is = file.getInputStream();){
                int nVersion = LoadSave.checkSave(is) & 0xFFFF;
                lsInf.clear();
                if (nVersion == 103) {
                    LoadSave.lsInf.date = Main.game.date.getDate(StreamUtils.readLong(is));
                    StreamUtils.skip(is, 32);
                    lsInf.read(is);
                    if (is.available() <= 16000) {
                        int n = -1;
                        return n;
                    }
                    ((DynamicArtEntry)pic).copyData(StreamUtils.readBytes(is, 16000));
                    LoadSave.lsInf.addonfile = null;
                    if (StreamUtils.readBoolean(is)) {
                        boolean isPacked = StreamUtils.readBoolean(is);
                        String fullname = StreamUtils.readDataString(is);
                        String ininame = FileUtils.getPath(fullname, new String[0]).getFileName().toString();
                        if (isPacked) {
                            ininame = ininame + ":" + FileUtils.getPath(StreamUtils.readDataString(is), new String[0]).getFileName().toString();
                        }
                        if (!ininame.isEmpty()) {
                            LoadSave.lsInf.addonfile = "File: " + ininame;
                        }
                    }
                    int n = 1;
                    return n;
                }
                LoadSave.lsInf.info = "Incompatible ver. " + nVersion + " != " + 103;
                int n = -1;
                return n;
            }
            catch (Exception e) {
                Console.out.println(e.toString(), OsdColor.RED);
            }
        }
        lsInf.clear();
        return -1;
    }

    public static String makeNum(int num) {
        LoadSave.filenum[3] = (char)(num % 10 + 48);
        LoadSave.filenum[2] = (char)(num / 10 % 10 + 48);
        LoadSave.filenum[1] = (char)(num / 100 % 10 + 48);
        LoadSave.filenum[0] = (char)(num / 1000 % 10 + 48);
        return new String(filenum);
    }

    public static int checkSave(InputStream is) throws IOException {
        String signature = StreamUtils.readString(is, 4);
        if (!signature.equals(savsign)) {
            return 0;
        }
        return StreamUtils.readShort(is);
    }

    public static void savegame(Directory dir, String savename, String filename) {
        block10: {
            if (Actors.isPsychoSkill()) {
                View.FTA(53, Globals.ps[Mmulti.myconnectindex]);
                return;
            }
            FileEntry file = dir.getEntry(filename);
            if (file.exists() && !file.delete()) {
                View.addmessage("Game not saved. Access denied!");
                return;
            }
            Path path = dir.getPath().resolve(filename);
            try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
                long time = Main.game.date.getCurrentDate();
                LoadSave.save(os, savename, time);
                file = dir.addEntry(path);
                if (file.exists()) {
                    Main.game.pSavemgr.add(savename, time, file);
                    lastload = file;
                    View.addmessage("GAME SAVED");
                    break block10;
                }
                throw new FileNotFoundException(filename);
            }
            catch (Exception e) {
                View.addmessage("Game not saved! " + e);
            }
        }
    }

    public static void MapSave(OutputStream os) throws IOException {
        if (Globals.boardfilename != null && Globals.boardfilename.exists()) {
            if (Globals.boardfilename instanceof FileEntry) {
                StreamUtils.writeString(os, ((FileEntry)Globals.boardfilename).getPath().toString(), 144);
            } else {
                StreamUtils.writeString(os, Globals.boardfilename.getName(), 144);
            }
        } else {
            StreamUtils.writeString(os, "", 144);
        }
        Board board = Main.boardService.getBoard();
        Sector[] sectors = board.getSectors();
        StreamUtils.writeInt(os, sectors.length);
        for (Sector s : sectors) {
            s.writeObject(os);
        }
        Wall[] walls = board.getWalls();
        StreamUtils.writeInt(os, walls.length);
        for (Wall wal : walls) {
            wal.writeObject(os);
        }
        List<Sprite> sprites = board.getSprites();
        StreamUtils.writeInt(os, sprites.size());
        for (Sprite s : sprites) {
            s.writeObject(os);
        }
        StreamUtils.writeInt(os, Premap.rorcnt);
        for (int i = 0; i < 16; ++i) {
            StreamUtils.writeShort(os, Premap.rorsector[i]);
            StreamUtils.writeByte(os, Premap.rortype[i]);
        }
    }

    public static void StuffSave(OutputStream os) throws IOException {
        int i;
        StreamUtils.writeShort(os, Globals.numcyclers);
        for (i = 0; i < 256; ++i) {
            for (int j = 0; j < 6; ++j) {
                StreamUtils.writeShort(os, Globals.cyclers[i][j]);
            }
        }
        for (i = 0; i < 16; ++i) {
            Globals.ps[i].writeObject(os);
        }
        for (i = 0; i < 16; ++i) {
            Globals.po[i].writeObject(os);
        }
        StreamUtils.writeShort(os, Globals.numanimwalls);
        for (i = 0; i < 512; ++i) {
            StreamUtils.writeShort(os, Globals.animwall[i].wallnum);
            StreamUtils.writeInt(os, Globals.animwall[i].tag);
        }
        for (i = 0; i < 2048; ++i) {
            StreamUtils.writeInt(os, Globals.msx[i]);
        }
        for (i = 0; i < 2048; ++i) {
            StreamUtils.writeInt(os, Globals.msy[i]);
        }
        StreamUtils.writeShort(os, Globals.spriteqloc);
        StreamUtils.writeShort(os, Globals.currentGame.getCON().spriteqamount);
        for (i = 0; i < 1024; ++i) {
            StreamUtils.writeShort(os, Globals.spriteq[i]);
        }
        StreamUtils.writeShort(os, Globals.mirrorcnt);
        for (i = 0; i < 64; ++i) {
            StreamUtils.writeShort(os, Globals.mirrorwall[i]);
        }
        for (i = 0; i < 64; ++i) {
            StreamUtils.writeShort(os, Globals.mirrorsector[i]);
        }
        Engine.show2dsector.writeObject(os);
        Premap.shadeEffect.writeObject(os);
        StreamUtils.writeInt(os, Premap.numjaildoors);
        for (i = 0; i < 32; ++i) {
            StreamUtils.writeInt(os, Premap.jailspeed[i]);
            StreamUtils.writeInt(os, Premap.jaildistance[i]);
            StreamUtils.writeShort(os, Premap.jailsect[i]);
            StreamUtils.writeShort(os, Premap.jaildirection[i]);
            StreamUtils.writeShort(os, Premap.jailunique[i]);
            StreamUtils.writeShort(os, Premap.jailsound[i]);
            StreamUtils.writeShort(os, Premap.jailstatus[i]);
            StreamUtils.writeInt(os, Premap.jailcount2[i]);
        }
        StreamUtils.writeInt(os, Premap.numminecart);
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeInt(os, Premap.minespeed[i]);
            StreamUtils.writeInt(os, Premap.minefulldist[i]);
            StreamUtils.writeInt(os, Premap.minedistance[i]);
            StreamUtils.writeShort(os, Premap.minechild[i]);
            StreamUtils.writeShort(os, Premap.mineparent[i]);
            StreamUtils.writeShort(os, Premap.minedirection[i]);
            StreamUtils.writeShort(os, Premap.minesound[i]);
            StreamUtils.writeShort(os, Premap.minestatus[i]);
        }
        StreamUtils.writeInt(os, Premap.numtorcheffects);
        for (i = 0; i < 64; ++i) {
            StreamUtils.writeShort(os, Premap.torchsector[i]);
            StreamUtils.writeByte(os, Premap.torchshade[i]);
            StreamUtils.writeShort(os, Premap.torchflags[i]);
        }
        StreamUtils.writeInt(os, Premap.numlightnineffects);
        for (i = 0; i < 64; ++i) {
            StreamUtils.writeShort(os, Premap.lightninsector[i]);
            StreamUtils.writeShort(os, Premap.lightninshade[i]);
        }
        StreamUtils.writeInt(os, Premap.numambients);
        for (i = 0; i < 64; ++i) {
            StreamUtils.writeShort(os, Premap.ambienttype[i]);
            StreamUtils.writeShort(os, Premap.ambientid[i]);
            StreamUtils.writeShort(os, Premap.ambienthitag[i]);
        }
        StreamUtils.writeInt(os, Premap.numgeomeffects);
        for (i = 0; i < 64; ++i) {
            StreamUtils.writeShort(os, Premap.geomsector[i]);
            StreamUtils.writeShort(os, Premap.geoms1[i]);
            StreamUtils.writeInt(os, Premap.geomx1[i]);
            StreamUtils.writeInt(os, Premap.geomy1[i]);
            StreamUtils.writeInt(os, Premap.geomz1[i]);
            StreamUtils.writeShort(os, Premap.geoms2[i]);
            StreamUtils.writeInt(os, Premap.geomx2[i]);
            StreamUtils.writeInt(os, Premap.geomy2[i]);
            StreamUtils.writeInt(os, Premap.geomz2[i]);
        }
        StreamUtils.writeShort(os, (short)Actors.UFO_SpawnCount);
        StreamUtils.writeShort(os, (short)Actors.UFO_SpawnTime);
        StreamUtils.writeShort(os, (short)Actors.UFO_SpawnHulk);
        StreamUtils.writeShort(os, 0);
        StreamUtils.writeShort(os, 0);
        StreamUtils.writeByte(os, (byte)(Premap.plantProcess ? 1 : 0));
        StreamUtils.writeShort(os, Globals.BellTime);
        StreamUtils.writeInt(os, Globals.BellSound);
        StreamUtils.writeShort(os, Globals.word_119BE0);
        StreamUtils.writeInt(os, Globals.WindDir);
        StreamUtils.writeInt(os, Globals.WindTime);
        StreamUtils.writeInt(os, Globals.mamaspawn_count);
        StreamUtils.writeInt(os, Globals.fakebubba_spawn);
        StreamUtils.writeInt(os, Globals.dword_119C08);
    }

    /*
     * WARNING - void declaration
     */
    public static void ConSave(OutputStream os) throws IOException {
        void var1_3;
        StreamUtils.writeInt(os, Globals.currentGame.getCON().actortype.length);
        for (short s : Globals.currentGame.getCON().actortype) {
            StreamUtils.writeByte(os, (byte)s);
        }
        StreamUtils.writeInt(os, 20460L);
        boolean bl = false;
        while (var1_3 < 20460) {
            StreamUtils.writeInt(os, Globals.currentGame.getCON().script[var1_3]);
            ++var1_3;
        }
        StreamUtils.writeInt(os, Globals.currentGame.getCON().actorscrptr.length);
        for (int i : Globals.currentGame.getCON().actorscrptr) {
            StreamUtils.writeInt(os, i);
        }
        StreamUtils.writeInt(os, Globals.hittype.length);
        for (Weaponhit weaponhit : Globals.hittype) {
            weaponhit.writeObject(os);
        }
    }

    public static void GameInfoSave(OutputStream os) throws IOException {
        int i;
        StreamUtils.writeShort(os, Engine.pskybits);
        RRRenderer renderer = Main.game.getRenderer();
        StreamUtils.writeInt(os, renderer.getParallaxScale());
        for (i = 0; i < 256; ++i) {
            StreamUtils.writeShort(os, Engine.pskyoff[i]);
        }
        StreamUtils.writeShort(os, Globals.earthquaketime);
        StreamUtils.writeShort(os, (short)Globals.ud.from_bonus);
        StreamUtils.writeShort(os, (short)Globals.ud.secretlevel);
        StreamUtils.writeByte(os, Globals.ud.respawn_monsters ? 1 : 0);
        StreamUtils.writeByte(os, Globals.ud.respawn_items ? 1 : 0);
        StreamUtils.writeByte(os, Globals.ud.respawn_inventory ? 1 : 0);
        StreamUtils.writeByte(os, Globals.ud.god ? 1 : 0);
        StreamUtils.writeInt(os, Globals.ud.auto_run);
        StreamUtils.writeInt(os, Globals.ud.crosshair);
        StreamUtils.writeByte(os, Globals.ud.monsters_off ? 1 : 0);
        StreamUtils.writeInt(os, Globals.ud.last_level);
        StreamUtils.writeInt(os, Globals.ud.eog);
        StreamUtils.writeInt(os, Globals.ud.coop);
        StreamUtils.writeInt(os, Globals.ud.marker);
        StreamUtils.writeInt(os, Globals.ud.ffire);
        StreamUtils.writeShort(os, Globals.camsprite);
        StreamUtils.writeShort(os, Mmulti.connecthead);
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeShort(os, Mmulti.connectpoint2[i]);
        }
        StreamUtils.writeShort(os, Globals.numplayersprites);
        for (i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                StreamUtils.writeShort(os, Globals.frags[i][j]);
            }
        }
        StreamUtils.writeInt(os, Main.engine.getrand());
        StreamUtils.writeShort(os, Globals.global_random);
    }

    public static void AnimationSave(OutputStream os) throws IOException {
        for (int i = 0; i < 512; ++i) {
            StreamUtils.writeShort(os, Animate.gAnimationData[i].id);
            StreamUtils.writeByte(os, Animate.gAnimationData[i].type);
            StreamUtils.writeInt(os, Animate.gAnimationData[i].goal);
            StreamUtils.writeInt(os, Animate.gAnimationData[i].vel);
            StreamUtils.writeShort(os, Animate.gAnimationData[i].sect);
        }
        StreamUtils.writeInt(os, Animate.gAnimationCount);
    }

    public static void SaveVersion(OutputStream os, int nVersion) throws IOException {
        StreamUtils.writeString(os, savsign);
        StreamUtils.writeShort(os, nVersion);
    }

    public static void SaveHeader(OutputStream os, String savename, long time) throws IOException {
        LoadSave.SaveVersion(os, 103);
        StreamUtils.writeLong(os, time);
        StreamUtils.writeString(os, savename, 32);
        StreamUtils.writeInt(os, Globals.ud.multimode);
        StreamUtils.writeInt(os, Globals.ud.volume_number);
        StreamUtils.writeInt(os, Globals.ud.level_number);
        StreamUtils.writeInt(os, Globals.ud.player_skill);
    }

    public static void SaveScreenshot(OutputStream os) throws IOException {
        if (Main.gGameScreen.captBuffer != null) {
            StreamUtils.writeBytes(os, Main.gGameScreen.captBuffer);
        } else {
            StreamUtils.writeBytes(os, new byte[16000]);
        }
        Main.gGameScreen.captBuffer = null;
    }

    public static void SaveGDXBlock(OutputStream os) throws IOException {
        LoadSave.SaveScreenshot(os);
        int warp_on = 0;
        if (Main.mUserFlag == Main.UserFlag.Addon) {
            warp_on = 1;
        }
        if (Main.mUserFlag == Main.UserFlag.UserMap) {
            warp_on = 2;
        }
        StreamUtils.writeByte(os, warp_on);
        if (warp_on == 1) {
            if (Globals.currentGame != null) {
                EpisodeEntry episodeEntry = Globals.currentGame.getEpisodeEntry();
                boolean isPacked = episodeEntry.isPackageEpisode();
                StreamUtils.writeBoolean(os, isPacked);
                StreamUtils.writeDataString(os, episodeEntry.getFileEntry().getRelativePath().toString());
                if (isPacked) {
                    StreamUtils.writeDataString(os, episodeEntry.getConFile().getName());
                }
            } else {
                StreamUtils.writeBoolean(os, false);
                StreamUtils.writeInt(os, 0L);
            }
        }
    }

    public static void save(OutputStream os, String savename, long time) throws IOException {
        LoadSave.SaveHeader(os, savename, time);
        LoadSave.SaveGDXBlock(os);
        LoadSave.MapSave(os);
        LoadSave.StuffSave(os);
        LoadSave.ConSave(os);
        LoadSave.AnimationSave(os);
        LoadSave.GameInfoSave(os);
        os.flush();
        System.gc();
    }

    public static void quicksave() {
        if (Mmulti.numplayers > 1 || Globals.mFakeMultiplayer) {
            return;
        }
        Sprite psp = Main.boardService.getSprite(Globals.ps[Mmulti.myconnectindex].i);
        if (psp != null && psp.getExtra() > 0) {
            gQuickSaving = true;
        }
    }

    public static boolean canLoad(FileEntry fil) {
        if (fil.exists()) {
            boolean bl;
            block11: {
                InputStream is = fil.getInputStream();
                try {
                    int nVersion = LoadSave.checkSave(is) & 0xFFFF;
                    if (nVersion != 103 && nVersion >= 100) {
                        GameInfo addon = loader.LoadGDXHeader(is);
                        if (LoadSave.loader.level_number <= 11 && LoadSave.loader.volume_number < 3 && LoadSave.loader.player_skill >= 0 && LoadSave.loader.player_skill < 5 && LoadSave.loader.warp_on != 2) {
                            MenuCorruptGame menu = LoadSave.getMenuCorruptGame(addon);
                            Main.game.menu.mOpen(menu, -1);
                        }
                    }
                    boolean bl2 = bl = nVersion == 103;
                    if (is == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                is.close();
            }
            return bl;
        }
        return false;
    }

    @NotNull
    private static MenuCorruptGame getMenuCorruptGame(GameInfo addon) {
        MenuCorruptGame menu = (MenuCorruptGame)Main.game.menu.mMenus[17];
        menu.setRunnable(() -> {
            GameInfo game = addon != null ? addon : Globals.defGame;
            int nEpisode = LoadSave.loader.volume_number;
            int nLevel = LoadSave.loader.level_number;
            int nSkill = LoadSave.loader.player_skill - 1;
            Main.gGameScreen.newgame(false, game, nEpisode, nLevel, nSkill);
        });
        MenuCorruptGame menuCorruptGame = menu;
        if (menuCorruptGame == null) {
            LoadSave.$$$reportNull$$$0(0);
        }
        return menuCorruptGame;
    }

    public static void quickload() {
        if (Mmulti.numplayers > 1 || Globals.mFakeMultiplayer) {
            return;
        }
        if (Actors.isPsychoSkill()) {
            View.FTA(53, Globals.ps[Mmulti.myconnectindex]);
            return;
        }
        FileEntry loadFile = Main.game.pSavemgr.getLast();
        if (LoadSave.canLoad(loadFile)) {
            Main.game.changeScreen(Main.gLoadingScreen.setTitle(loadFile.getName()));
            Main.gLoadingScreen.init(() -> {
                if (!LoadSave.loadgame(loadFile)) {
                    Main.game.setPrevScreen();
                }
            });
        }
    }

    public static void AnimationLoad(SafeLoader bb) {
        int i;
        for (i = 0; i < 512; ++i) {
            Animate.gAnimationData[i].id = bb.gAnimationData[i].id;
            Animate.gAnimationData[i].type = bb.gAnimationData[i].type;
            Animate.gAnimationData[i].ptr = bb.gAnimationData[i].ptr;
            Animate.gAnimationData[i].goal = bb.gAnimationData[i].goal;
            Animate.gAnimationData[i].vel = bb.gAnimationData[i].vel;
            Animate.gAnimationData[i].sect = bb.gAnimationData[i].sect;
        }
        Animate.gAnimationCount = bb.gAnimationCount;
        block6: for (i = Animate.gAnimationCount - 1; i >= 0; --i) {
            ANIMATION gAnm = Animate.gAnimationData[i];
            Object object = gAnm.ptr = Animate.getobject(gAnm.id, gAnm.type);
            switch (gAnm.type) {
                case 1: 
                case 2: {
                    Main.game.pInt.setwallinterpolate(gAnm.id, (Wall)object);
                    continue block6;
                }
                case 4: {
                    Main.game.pInt.setfloorinterpolate(gAnm.id, (Sector)object);
                    continue block6;
                }
                case 8: {
                    Main.game.pInt.setceilinterpolate(gAnm.id, (Sector)object);
                }
            }
        }
    }

    public static void ConLoad(SafeLoader loader) {
        System.arraycopy(loader.actortype.items, 0, Globals.currentGame.getCON().actortype, 0, loader.actortype.size);
        System.arraycopy(loader.script, 0, Globals.currentGame.getCON().script, 0, 20460);
        System.arraycopy(loader.actorscrptr.items, 0, Globals.currentGame.getCON().actorscrptr, 0, loader.actorscrptr.size);
        for (int i = 0; i < loader.hittype.size; ++i) {
            Globals.hittype[i].set(((Weaponhit[])loader.hittype.items)[i]);
        }
    }

    public static void GameInfoLoad(SafeLoader bb) {
        Engine.pskybits = bb.pskybits;
        RRRenderer renderer = Main.game.getRenderer();
        renderer.setParallaxScale(bb.parallaxyscale);
        System.arraycopy(bb.pskyoff, 0, Engine.pskyoff, 0, 256);
        System.arraycopy(Engine.pskyoff, 0, Engine.zeropskyoff, 0, 256);
        Globals.earthquaketime = bb.earthquaketime;
        Globals.ud.from_bonus = bb.from_bonus;
        Globals.ud.secretlevel = bb.secretlevel;
        Globals.ud.respawn_monsters = bb.respawn_monsters;
        Globals.ud.respawn_items = bb.respawn_items;
        Globals.ud.respawn_inventory = bb.respawn_inventory;
        Globals.ud.god = bb.god;
        Globals.ud.auto_run = bb.auto_run;
        Globals.ud.crosshair = bb.crosshair;
        Globals.ud.monsters_off = bb.monsters_off;
        Globals.ud.last_level = bb.last_level;
        Globals.ud.eog = bb.eog;
        Globals.ud.coop = bb.coop;
        Globals.ud.marker = bb.marker;
        Globals.ud.ffire = bb.ffire;
        Globals.camsprite = bb.camsprite;
        Mmulti.connecthead = bb.connecthead;
        System.arraycopy(bb.connectpoint2, 0, Mmulti.connectpoint2, 0, 16);
        Globals.numplayersprites = bb.numplayersprites;
        for (int i = 0; i < 16; ++i) {
            System.arraycopy(bb.frags[i], 0, Globals.frags[i], 0, 16);
        }
        Main.engine.srand(bb.randomseed);
        Globals.global_random = bb.global_random;
    }

    public static void StuffLoad(SafeLoader bb) {
        int i;
        Globals.numcyclers = bb.numcyclers;
        for (i = 0; i < 256; ++i) {
            System.arraycopy(bb.cyclers[i], 0, Globals.cyclers[i], 0, 6);
        }
        for (i = 0; i < 16; ++i) {
            Globals.ps[i].copy(bb.ps[i]);
        }
        for (i = 0; i < 16; ++i) {
            Globals.po[i].copy(bb.po[i]);
        }
        Globals.numanimwalls = bb.numanimwalls;
        for (i = 0; i < 512; ++i) {
            Globals.animwall[i].wallnum = bb.animwall[i].wallnum;
            Globals.animwall[i].tag = bb.animwall[i].tag;
        }
        System.arraycopy(bb.msx, 0, Globals.msx, 0, 2048);
        System.arraycopy(bb.msy, 0, Globals.msy, 0, 2048);
        Globals.spriteqloc = bb.spriteqloc;
        Globals.currentGame.getCON().spriteqamount = bb.spriteqamount;
        System.arraycopy(bb.spriteq, 0, Globals.spriteq, 0, 1024);
        Globals.mirrorcnt = bb.mirrorcnt;
        System.arraycopy(bb.mirrorwall, 0, Globals.mirrorwall, 0, 64);
        System.arraycopy(bb.mirrorsector, 0, Globals.mirrorsector, 0, 64);
        Engine.show2dsector.copy(bb.show2dsector);
        Premap.shadeEffect.copy(bb.shadeEffect);
        Premap.numjaildoors = bb.numjaildoors;
        for (i = 0; i < 32; ++i) {
            Premap.jailspeed[i] = bb.jailspeed[i];
            Premap.jaildistance[i] = bb.jaildistance[i];
            Premap.jailsect[i] = bb.jailsect[i];
            Premap.jaildirection[i] = bb.jaildirection[i];
            Premap.jailunique[i] = bb.jailunique[i];
            Premap.jailsound[i] = bb.jailsound[i];
            Premap.jailstatus[i] = bb.jailstatus[i];
            Premap.jailcount2[i] = bb.jailcount2[i];
        }
        Premap.numminecart = bb.numminecart;
        for (i = 0; i < 16; ++i) {
            Premap.minespeed[i] = bb.minespeed[i];
            Premap.minefulldist[i] = bb.minefulldist[i];
            Premap.minedistance[i] = bb.minedistance[i];
            Premap.minechild[i] = bb.minechild[i];
            Premap.mineparent[i] = bb.mineparent[i];
            Premap.minedirection[i] = bb.minedirection[i];
            Premap.minesound[i] = bb.minesound[i];
            Premap.minestatus[i] = bb.minestatus[i];
        }
        Premap.numtorcheffects = bb.numtorcheffects;
        for (i = 0; i < 64; ++i) {
            Premap.torchsector[i] = bb.torchsector[i];
            Premap.torchshade[i] = bb.torchshade[i];
            Premap.torchflags[i] = bb.torchflags[i];
        }
        Premap.numlightnineffects = bb.numlightnineffects;
        for (i = 0; i < 64; ++i) {
            Premap.lightninsector[i] = bb.lightninsector[i];
            Premap.lightninshade[i] = bb.lightninshade[i];
        }
        Premap.numambients = bb.numambients;
        for (i = 0; i < 64; ++i) {
            Premap.ambienttype[i] = bb.ambienttype[i];
            Premap.ambientid[i] = bb.ambientid[i];
            Premap.ambienthitag[i] = bb.ambienthitag[i];
        }
        Premap.numgeomeffects = bb.numgeomeffects;
        for (i = 0; i < 64; ++i) {
            Premap.geomsector[i] = bb.geomsector[i];
            Premap.geoms1[i] = bb.geoms1[i];
            Premap.geomx1[i] = bb.geomx1[i];
            Premap.geomy1[i] = bb.geomy1[i];
            Premap.geomz1[i] = bb.geomz1[i];
            Premap.geoms2[i] = bb.geoms2[i];
            Premap.geomx2[i] = bb.geomx2[i];
            Premap.geomy2[i] = bb.geomy2[i];
            Premap.geomz2[i] = bb.geomz2[i];
        }
        Actors.UFO_SpawnCount = bb.UFO_SpawnCount;
        Actors.UFO_SpawnTime = bb.UFO_SpawnTime;
        Actors.UFO_SpawnHulk = bb.UFO_SpawnHulk;
        ResourceHandler.InitSpecialTextures();
        Actors.BowlReset();
        Premap.plantProcess = bb.plantProcess;
        Globals.BellTime = bb.BellTime;
        Globals.BellSound = bb.BellSound;
        Globals.word_119BE0 = bb.word_119BE0;
        Globals.WindDir = bb.WindDir;
        Globals.WindTime = bb.WindTime;
        Globals.mamaspawn_count = bb.mamaspawn_count;
        Globals.fakebubba_spawn = bb.fakebubba_spawn;
        Globals.dword_119C08 = bb.dword_119C08;
    }

    public static void MapLoad(SafeLoader bb) {
        Globals.boardfilename = LoadSave.loader.boardfilename;
        Main.boardService.setBoard(new Board(null, LoadSave.loader.sector, LoadSave.loader.wall, LoadSave.loader.sprite));
        Premap.rorcnt = bb.rorcnt;
        System.arraycopy(bb.rorsector, 0, Premap.rorsector, 0, 16);
        System.arraycopy(bb.rortype, 0, Premap.rortype, 0, 16);
    }

    public static void LoadGDXBlock() {
        if (LoadSave.loader.warp_on == 0) {
            Main.mUserFlag = Main.UserFlag.None;
        }
        if (LoadSave.loader.warp_on == 1) {
            Main.mUserFlag = Main.UserFlag.Addon;
        }
        if (LoadSave.loader.warp_on == 2) {
            Main.mUserFlag = Main.UserFlag.UserMap;
        }
        if (Main.mUserFlag == Main.UserFlag.Addon) {
            GameInfo ini = LoadSave.loader.addon;
            ResourceHandler.checkEpisodeResources(ini);
        } else {
            ResourceHandler.resetEpisodeResources();
        }
    }

    public static boolean checkfile(InputStream is) throws IOException {
        int nVersion = LoadSave.checkSave(is);
        if (nVersion != 103) {
            return false;
        }
        return loader.load(is);
    }

    public static void load() {
        Main.gDemoScreen.onLoad();
        Globals.ud.multimode = LoadSave.loader.multimode;
        Globals.ud.volume_number = LoadSave.loader.volume_number;
        Globals.ud.level_number = LoadSave.loader.level_number;
        Globals.ud.player_skill = LoadSave.loader.player_skill;
        LoadSave.LoadGDXBlock();
        LoadSave.MapLoad(loader);
        LoadSave.StuffLoad(loader);
        LoadSave.ConLoad(loader);
        LoadSave.AnimationLoad(loader);
        LoadSave.GameInfoLoad(loader);
        if (View.over_shoulder_on != 0) {
            View.cameradist = 0;
            View.cameraclock = 0;
            View.over_shoulder_on = 1;
        }
        Globals.screenpeek = Mmulti.myconnectindex;
        if (Globals.ps[Mmulti.myconnectindex].fogtype == 2) {
            Main.engine.getPaletteManager().applyfog(2);
        } else {
            Main.engine.getPaletteManager().applyfog(0);
        }
        if (Globals.ud.lockout == 0) {
            for (int x = 0; x < Globals.numanimwalls; ++x) {
                Wall wal = Main.boardService.getWall(Globals.animwall[x].wallnum);
                if (wal == null || wal.getExtra() < 0) continue;
                wal.setPicnum(wal.getExtra());
            }
        }
        block5: for (ListNode<Sprite> n = Main.boardService.getStatNode(3); n != null; n = n.getNext()) {
            Sprite sp = n.get();
            switch (sp.getLotag()) {
                case 17: 
                case 25: 
                case 31: 
                case 32: {
                    Main.game.pInt.setfheinuminterpolate(sp.getSectnum(), Main.boardService.getSector(sp.getSectnum()));
                    continue block5;
                }
                case 0: 
                case 5: 
                case 6: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 26: 
                case 30: {
                    RSector.setsectinterpolate(n.getIndex());
                }
            }
        }
        View.fta = 0;
        Globals.everyothertime = '\u0000';
        Main.game.doPrecache(() -> {
            Entry file;
            ResourceHandler.InitSpecialTextures();
            Sounds.clearsoundlocks();
            Sounds.userMusicEntry = null;
            if (Globals.boardfilename != null && (file = Globals.boardfilename).exists()) {
                Sounds.sndCheckMusic(file);
            }
            Globals.musicvolume = Globals.ud.volume_number;
            Globals.musiclevel = Globals.ud.level_number;
            Sounds.sndPlayMusic(Globals.currentGame.getCON().music_fn[Globals.ud.volume_number][Globals.ud.level_number]);
            if (Globals.ps[Mmulti.myconnectindex].jetpack_on != 0) {
                Sounds.spritesound(50, Globals.ps[Mmulti.myconnectindex].i);
            }
            Player.setpal(Globals.ps[Mmulti.myconnectindex]);
            Screen.vscrn(Globals.ud.screen_size);
            Sounds.setReverb(false, 0.0f);
            Main.game.net.predict.reset();
            Main.game.gPaused = false;
            Main.game.nNetMode = BuildGame.NetMode.Single;
            Sector sec = Main.boardService.getSector(Globals.ps[Mmulti.myconnectindex].one_parallax_sectnum);
            if (sec != null) {
                Premap.setupbackdrop(sec.getCeilingpicnum());
            }
            Main.game.changeScreen(Main.gGameScreen);
            Main.game.pNet.ResetTimers();
            Main.game.pNet.WaitForAllPlayers(0);
            Main.game.pNet.ready2send = true;
            Sounds.StopAllSounds();
            System.gc();
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean loadgame(FileEntry fil) {
        if (fil.exists()) {
            try (InputStream is = fil.getInputStream();){
                Console.out.println("debug: start loadgame()", OsdColor.BLUE);
                boolean status = LoadSave.checkfile(is);
                if (status) {
                    LoadSave.load();
                    if (lastload == null || !lastload.exists()) {
                        lastload = fil;
                    }
                    if (loader.getMessage() != null) {
                        View.addmessage(loader.getMessage());
                    }
                    boolean bl2 = true;
                    return bl2;
                }
                View.addmessage("Incompatible version of saved game found!");
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                Console.out.println(e.toString(), OsdColor.RED);
            }
        }
        View.addmessage("Can't access to file or file not found!");
        return false;
    }

    static {
        lsInf = new LSInfo();
        quickslot = 0;
        loader = new SafeLoader();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ru/m210projects/Redneck/LoadSave", "getMenuCorruptGame"));
    }
}

