/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.ScreenAdapter;
import com.badlogic.gdx.utils.ByteArray;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import ru.m210projects.Build.Architecture.MessageType;
import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.LogSender;
import ru.m210projects.Build.Pattern.ScreenAdapters.DefaultPrecacheScreen;
import ru.m210projects.Build.Pattern.ScreenAdapters.MessageScreen;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.listeners.PrecacheListener;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Types.LittleEndian;
import ru.m210projects.Build.filehandle.CacheResourceMap;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.input.GameProcessor;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.CommandResponse;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.osd.commands.OsdCallback;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Redneck.Animate;
import ru.m210projects.Redneck.Config;
import ru.m210projects.Redneck.Factory.RRDummyRenderer;
import ru.m210projects.Redneck.Factory.RREngine;
import ru.m210projects.Redneck.Factory.RRFactory;
import ru.m210projects.Redneck.Factory.RRGameProcessor;
import ru.m210projects.Redneck.Factory.RRMenuHandler;
import ru.m210projects.Redneck.Factory.RRNetwork;
import ru.m210projects.Redneck.Factory.RRRenderer;
import ru.m210projects.Redneck.Fonts.GameFont;
import ru.m210projects.Redneck.Fonts.MenuFont;
import ru.m210projects.Redneck.Gamedef;
import ru.m210projects.Redneck.Globals;
import ru.m210projects.Redneck.LoadSave;
import ru.m210projects.Redneck.Menus.GameMenu;
import ru.m210projects.Redneck.Menus.MainMenu;
import ru.m210projects.Redneck.Menus.MenuCorruptGame;
import ru.m210projects.Redneck.Menus.RMenuMultiplayer;
import ru.m210projects.Redneck.Menus.TrackPlayerMenu;
import ru.m210projects.Redneck.Player;
import ru.m210projects.Redneck.Premap;
import ru.m210projects.Redneck.ResourceHandler;
import ru.m210projects.Redneck.Screen;
import ru.m210projects.Redneck.Screens.AnmScreen;
import ru.m210projects.Redneck.Screens.DemoScreen;
import ru.m210projects.Redneck.Screens.DisconnectScreen;
import ru.m210projects.Redneck.Screens.EndScreen;
import ru.m210projects.Redneck.Screens.GameScreen;
import ru.m210projects.Redneck.Screens.LoadingScreen;
import ru.m210projects.Redneck.Screens.MVEScreen;
import ru.m210projects.Redneck.Screens.MenuScreen;
import ru.m210projects.Redneck.Screens.NetScreen;
import ru.m210projects.Redneck.Screens.PrecacheScreen;
import ru.m210projects.Redneck.Screens.RRMessageScreen;
import ru.m210projects.Redneck.Screens.StatisticScreen;
import ru.m210projects.Redneck.Sounds;
import ru.m210projects.Redneck.Types.Animwalltype;
import ru.m210projects.Redneck.Types.PlayerOrig;
import ru.m210projects.Redneck.Types.PlayerStruct;
import ru.m210projects.Redneck.Types.Weaponhit;
import ru.m210projects.Redneck.filehandle.EpisodeEntry;
import ru.m210projects.Redneck.filehandle.rts.RTSFile;

public class Main
extends BuildGame {
    public static final String appdef = "rrgdx.def";
    public static AnmScreen gAnmScreen;
    public static MVEScreen gMveScreen;
    public static MenuScreen gMenuScreen;
    public static LoadingScreen gLoadingScreen;
    public static GameScreen gGameScreen;
    public static DemoScreen gDemoScreen;
    public static StatisticScreen gStatisticScreen;
    public static EndScreen gEndScreen;
    public static NetScreen gNetScreen;
    public static DisconnectScreen gDisconnectScreen;
    public static UserFlag mUserFlag;
    public static Main game;
    public static RREngine engine;
    public static BoardService boardService;
    public static Config cfg;
    public static RTSFile RTS_File;
    public RRMenuHandler menu;
    public RRNetwork net;
    private final Runnable rMenu = new Runnable(){

        @Override
        public void run() {
            Sounds.StopAllSounds();
            Globals.ud.level_number = 0;
            Globals.ud.multimode = 1;
            Globals.mFakeMultiplayer = false;
            if (!Main.this.menu.gShowMenu) {
                Main.this.menu.mOpen(Main.this.menu.mMenus[0], -1);
            }
            if (Mmulti.numplayers > 1 || Main.gDemoScreen.demofiles.isEmpty() || Main.cfg.gDemoSeq == 0 || !gDemoScreen.showDemo(Main.this.cache.getGameDirectory())) {
                Main.this.changeScreen(gMenuScreen);
            }
        }
    };
    public String mainGrp;

    public Main(List<String> args, GameConfig dcfg, String name, String version, boolean isRelease) throws IOException {
        super(args, dcfg, name, version, isRelease);
        game = this;
        cfg = (Config)dcfg;
        this.mainGrp = "redneck.grp";
    }

    public static boolean IsOriginalDemo() {
        ScreenAdapter screen = (ScreenAdapter)game.getScreen();
        if (screen instanceof DemoScreen) {
            return ((DemoScreen)screen).IsOriginalGame();
        }
        if (screen instanceof GameScreen) {
            return ((GameScreen)screen).IsOriginalGame();
        }
        return false;
    }

    @Override
    protected MessageScreen createMessage(String header, String text, MessageType type) {
        return new RRMessageScreen(this, header, text, type);
    }

    @Override
    public void onDropEntry(FileEntry entry) {
        if (!entry.isExtension("map")) {
            return;
        }
        Console.out.println("Start dropped map: " + entry.getName());
        gGameScreen.newgame(false, entry, 0, 0, Globals.ud.player_skill);
    }

    @Override
    @NotNull
    public RRRenderer getRenderer() {
        Renderer renderer = super.getRenderer();
        if (renderer instanceof RRRenderer) {
            RRRenderer rRRenderer = (RRRenderer)renderer;
            if (rRRenderer == null) {
                Main.$$$reportNull$$$0(0);
            }
            return rRRenderer;
        }
        return new RRDummyRenderer();
    }

    @Override
    public GameProcessor createGameProcessor() {
        return new RRGameProcessor(this);
    }

    @Override
    public RRGameProcessor getProcessor() {
        return (RRGameProcessor)super.getProcessor();
    }

    @Override
    public BuildFactory getFactory() {
        return new RRFactory(this);
    }

    @Override
    public boolean init() throws Exception {
        FileEntry filgdx;
        int i;
        this.net = (RRNetwork)this.pNet;
        boardService = engine.getBoardService();
        this.ConsoleInit();
        Gamedef.compilecons();
        ResourceHandler.InitSpecialTextures();
        this.InitUserDefs();
        Entry rtsEntry = this.cache.getEntry(Globals.ud.rtsname, true);
        if (rtsEntry.exists()) {
            RTSFile rts = new RTSFile(Globals.ud.rtsname, rtsEntry::getInputStream);
            if (rts.getSize() != 0) {
                Console.out.println("Using .RTS file:" + Globals.ud.rtsname);
                RTS_File = rts;
            }
        }
        Sounds.SoundStartup();
        Sounds.searchCDtracks();
        Animate.initanimations();
        LoadSave.FindSaves(this.getUserDirectory());
        for (i = 0; i < 16; ++i) {
            Globals.ps[i] = new PlayerStruct();
            Globals.po[i] = new PlayerOrig();
        }
        Player.InitPlayers();
        for (i = 0; i < 512; ++i) {
            Globals.animwall[i] = new Animwalltype();
        }
        for (i = 0; i < Engine.MAXSPRITES; ++i) {
            Globals.hittype[i] = new Weaponhit();
        }
        Console.out.println("Initializing def-scripts...");
        this.cache.loadGdxDef(this.baseDef, appdef, "rrgdx.dat");
        Directory gameDir = this.cache.getGameDirectory();
        if (cfg.isAutoloadFolder()) {
            Console.out.println("Initializing autoload folder");
            block12: for (Entry file : gameDir.getDirectory(gameDir.getEntry("autoload"))) {
                switch (file.getExtension()) {
                    case "PK3": 
                    case "ZIP": {
                        Group group = this.cache.newGroup(file);
                        Entry def = group.getEntry(appdef);
                        if (!def.exists()) continue block12;
                        this.cache.addGroup(group, CacheResourceMap.CachePriority.NORMAL);
                        this.baseDef.loadScript(file.getName(), def);
                        break;
                    }
                    case "DEF": {
                        this.baseDef.loadScript(file);
                    }
                }
            }
        }
        if ((filgdx = gameDir.getEntry(appdef)).exists()) {
            this.baseDef.loadScript(filgdx);
        }
        this.setDefs(this.baseDef);
        gAnmScreen = new AnmScreen(this);
        gMveScreen = new MVEScreen(this);
        gLoadingScreen = new LoadingScreen(this);
        gGameScreen = new GameScreen(this);
        gDemoScreen = new DemoScreen(this);
        gStatisticScreen = new StatisticScreen(this);
        gEndScreen = new EndScreen();
        gNetScreen = new NetScreen(this);
        gDisconnectScreen = new DisconnectScreen(this);
        this.menu.mMenus[18] = new TrackPlayerMenu();
        this.menu.mMenus[0] = new MainMenu(this);
        this.menu.mMenus[1] = new GameMenu(this);
        this.menu.mMenus[17] = new MenuCorruptGame(this);
        gMenuScreen = new MenuScreen(this);
        gDemoScreen.checkDemoEntry(gameDir);
        return true;
    }

    @Override
    public boolean setDefs(DefScript script) {
        if (super.setDefs(script)) {
            ((GameFont)this.getFont(1)).update();
            ((MenuFont)this.getFont(2)).update();
            return true;
        }
        return false;
    }

    @Override
    public void show() {
        if (!this.args.isEmpty()) {
            this.parseArgumentsCommon();
            String netmode = this.args.getOrDefault("-netmode", "");
            String players = this.args.getOrDefault("-players", "");
            this.args.clear();
            if (!netmode.isEmpty()) {
                Console.out.println("Starting multiplayer as " + netmode, OsdColor.YELLOW);
                if (netmode.equalsIgnoreCase("master")) {
                    String[] param = new String[]{"-n0:" + (players.isEmpty() ? Integer.valueOf(2) : players), "-p " + cfg.getPort()};
                    ((RMenuMultiplayer)this.menu.mMenus[12]).getMenuCreate(this).createGame(0, false, param);
                    return;
                }
                if (netmode.equalsIgnoreCase("slave")) {
                    String[] param = new String[]{"-n0", cfg.getmAddress(), "-p " + cfg.getPort()};
                    ((RMenuMultiplayer)this.menu.mMenus[12]).getMenuJoin(this).joinGame(param);
                    return;
                }
            }
        }
        Globals.uGameFlags = 0;
        if (ResourceHandler.usecustomarts) {
            ResourceHandler.resetEpisodeResources();
        }
        gDemoScreen.onStopRecord();
        if (Globals.currentGame.getCON().type == 2 && gMveScreen.init("redint.mve")) {
            gMveScreen.setCallback(this.rMenu);
            this.changeScreen(gMveScreen.escSkipping(true));
        } else if (gAnmScreen.init("rr_intro.anm", 0)) {
            gAnmScreen.setCallback(() -> {
                if (gAnmScreen.init("redneck.anm", 1)) {
                    gAnmScreen.setCallback(() -> {
                        if (gAnmScreen.init("xatlogo.anm", 2)) {
                            this.changeScreen(gAnmScreen.setCallback(this.rMenu).escSkipping(false));
                        }
                    });
                    this.changeScreen(gAnmScreen.escSkipping(false));
                }
            }).setSkipping(this.rMenu);
            this.changeScreen(gAnmScreen.escSkipping(false));
        } else {
            this.changeScreen(gLoadingScreen);
            Gdx.app.postRunnable(this.rMenu);
        }
    }

    @Override
    public DefaultPrecacheScreen getPrecacheScreen(Runnable readyCallback, PrecacheListener listener) {
        return new PrecacheScreen(readyCallback, listener);
    }

    public void InitUserDefs() {
        Globals.ud.setDefaults(cfg);
        Globals.ud.god = false;
        Globals.ud.cashman = 0;
        Globals.ud.player_skill = 2;
    }

    public void ConsoleInit() {
        Console.out.println("Initializing on-screen display system");
        Console.out.getPrompt().setVersion(this.getTitle(), OsdColor.YELLOW, 10);
        Console.out.registerCommand(new OsdCallback("restart", "restart", argv -> {
            Premap.LeaveMap();
            return CommandResponse.SILENT_RESPONSE;
        }));
        Console.out.registerCommand(new OsdCallback("net_player", "net_player", argv -> {
            if (argv.length != 1) {
                Console.out.println("net_player: num");
                return CommandResponse.SILENT_RESPONSE;
            }
            try {
                String num = argv[0];
                int pnum = Integer.parseInt(num);
                int p = Main.game.net.PutPacketByte(Premap.packbuf, 0, 10);
                p = Main.game.net.PutPacketByte(Premap.packbuf, p, pnum);
                int trail = Main.game.net.gNetFifoTail;
                if (Mmulti.myconnectindex == Mmulti.connecthead) {
                    ++trail;
                }
                LittleEndian.putInt(Premap.packbuf, p, trail);
                Main.game.net.PlayerSyncRequest = pnum;
                Main.game.net.sendtoall(Premap.packbuf, p += 4);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return CommandResponse.SILENT_RESPONSE;
        }));
        Console.out.registerCommand(new OsdCallback("quicksave", "quicksave: performs a quick save", argv -> {
            if (Globals.ud.multimode != 1 || Mmulti.numplayers > 1) {
                Console.out.println("quicksave: Single player only");
                return CommandResponse.SILENT_RESPONSE;
            }
            if (this.isCurrentScreen(gGameScreen)) {
                LoadSave.quicksave();
            } else {
                Console.out.println("quicksave: not in a game");
            }
            return CommandResponse.SILENT_RESPONSE;
        }));
        Console.out.registerCommand(new OsdCallback("quickload", "quickload: performs a quick load", argv -> {
            if (Globals.ud.multimode != 1 || Mmulti.numplayers > 1) {
                Console.out.println("quickload: Single player only");
                return CommandResponse.SILENT_RESPONSE;
            }
            if (this.isCurrentScreen(gGameScreen)) {
                LoadSave.quickload();
            } else {
                Console.out.println("quickload: not in a game");
            }
            return CommandResponse.SILENT_RESPONSE;
        }));
    }

    public void Disconnect() {
        gDemoScreen.onStopRecord();
        if (gDisconnectScreen != null) {
            this.changeScreen(gDisconnectScreen);
        }
    }

    @Override
    public void resize(int width, int height) {
        super.resize(width, height);
        Screen.gViewYScaled = (height << 16) / 200;
    }

    @Override
    public void dispose() {
        gDemoScreen.onStopRecord();
        super.dispose();
    }

    @Override
    public LogSender getLogSender() {
        return new LogSender(this){

            @Override
            public byte[] reportData() {
                byte[] out;
                String text = "Mapname: " + Globals.boardfilename;
                text = text + "\r\n";
                text = text + "UserFlag: " + (Object)((Object)mUserFlag);
                text = text + "\r\n";
                if (mUserFlag == UserFlag.Addon && Globals.currentGame != null) {
                    try {
                        EpisodeEntry addon = Globals.currentGame.getEpisodeEntry();
                        text = text + "Episode filename: " + addon.getHashKey() + "\r\n";
                        text = text + "Episode title: " + Globals.currentGame.title + "\r\n";
                        text = text + "Episode name: " + Globals.currentGame.getCurrentEpisode() + "\r\n";
                        text = text + "\r\n";
                    }
                    catch (Exception e) {
                        text = text + "Episode filename get error \r\n";
                    }
                }
                text = text + "volume " + (Globals.ud.volume_number + 1);
                text = text + "\r\n";
                text = text + "level " + (Globals.ud.level_number + 1);
                text = text + "\r\n";
                text = text + "nDifficulty: " + Globals.ud.player_skill;
                text = text + "\r\n";
                text = text + "PlayerX: " + Globals.ps[Mmulti.myconnectindex].posx;
                text = text + "\r\n";
                text = text + "PlayerY: " + Globals.ps[Mmulti.myconnectindex].posy;
                text = text + "\r\n";
                text = text + "PlayerZ: " + Globals.ps[Mmulti.myconnectindex].posz;
                text = text + "\r\n";
                text = text + "PlayerAng: " + Globals.ps[Mmulti.myconnectindex].ang;
                text = text + "\r\n";
                text = text + "PlayerHoriz: " + Globals.ps[Mmulti.myconnectindex].horiz;
                text = text + "\r\n";
                text = text + "PlayerSect: " + Globals.ps[Mmulti.myconnectindex].cursectnum;
                text = text + "\r\n";
                if (mUserFlag == UserFlag.UserMap && Globals.boardfilename != null && Globals.boardfilename.exists()) {
                    ByteArray array = new ByteArray();
                    byte[] data = Globals.boardfilename.getBytes();
                    text = text + "\r\n<------Start Map data------->\r\n";
                    array.addAll(text.getBytes());
                    array.addAll(data);
                    array.addAll("\r\n<------End Map data------->\r\n".getBytes());
                    out = Arrays.copyOf(array.items, array.size);
                } else {
                    out = text.getBytes();
                }
                return out;
            }
        };
    }

    static {
        mUserFlag = UserFlag.None;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ru/m210projects/Redneck/Main", "getRenderer"));
    }

    public static enum UserFlag {
        None,
        UserMap,
        Addon;

    }
}

