/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck.Menus;

import java.util.List;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuFileBrowser;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Redneck.Main;
import ru.m210projects.Redneck.Menus.DifficultyMenu;
import ru.m210projects.Redneck.Menus.NetworkMenu;
import ru.m210projects.Redneck.Menus.NewAddonMenu;
import ru.m210projects.Redneck.Menus.RRTitle;
import ru.m210projects.Redneck.ResourceHandler;
import ru.m210projects.Redneck.Sounds;
import ru.m210projects.Redneck.Types.GameInfo;
import ru.m210projects.Redneck.filehandle.EpisodeEntry;

public class RUserContent
extends BuildMenu {
    private final Main app;
    private final MenuFileBrowser list;
    public boolean showmain;

    public RUserContent(Main app) {
        super(app.pMenu);
        this.app = app;
        RRTitle title = new RRTitle("User Content");
        int width = 240;
        this.list = new MenuFileBrowser(app, app.getFont(0), app.getFont(1), app.getFont(0), 40, 45, width, 1, 14, 2542){

            @Override
            public void init() {
                this.registerExtension("map", 0, 0);
                this.registerExtension("grp", 2, 1);
                this.registerExtension("zip", 2, 1);
                this.registerExtension("pk3", 2, 1);
                this.registerExtension("con", 2, 1);
                this.registerExtension("dmo", 1, -1);
            }

            @Override
            public void handleFile(FileEntry fil) {
                switch (fil.getExtension()) {
                    case "MAP": {
                        this.addFile(fil);
                        break;
                    }
                    case "DMO": {
                        if (RUserContent.this.showmain || !Main.gDemoScreen.isDemoFile(fil)) break;
                        this.addFile(fil);
                        break;
                    }
                    case "GRP": 
                    case "ZIP": 
                    case "PK3": {
                        if (!RUserContent.this.showmain && fil.getName().equalsIgnoreCase(Main.game.mainGrp)) break;
                        for (EpisodeEntry entry : ResourceHandler.episodeManager.getEpisodeEntries(fil)) {
                            this.addFile((FileEntry)((Object)entry));
                        }
                        break;
                    }
                }
            }

            @Override
            public void invoke(FileEntry fil) {
                switch (fil.getExtension()) {
                    case "MAP": {
                        RUserContent.this.launchMap(fil);
                        break;
                    }
                    case "CON": 
                    case "GRP": 
                    case "ZIP": 
                    case "PK3": {
                        if (!(fil instanceof EpisodeEntry)) break;
                        RUserContent.this.launchEpisode(ResourceHandler.episodeManager.getEpisode((EpisodeEntry)((Object)fil)));
                        break;
                    }
                    case "DMO": {
                        Directory parent = fil.getParent();
                        List<Entry> demoList = Main.gDemoScreen.checkDemoEntry(parent);
                        Main.gDemoScreen.nDemonum = demoList.indexOf(fil);
                        Main.gDemoScreen.showDemo(fil, null);
                        this.app.pMenu.mClose();
                    }
                }
            }

            @Override
            public void handleDirectory(Directory dir) {
                if (this.app.pMenu.gShowMenu) {
                    Sounds.sound(2);
                }
                for (EpisodeEntry entry : ResourceHandler.episodeManager.getEpisodeEntries(dir.getDirectoryEntry())) {
                    this.addFile(entry.getFileEntry());
                }
            }

            @Override
            public void drawHeader(Renderer renderer, int x1, int x2, int y) {
                this.topFont.drawTextScaled(renderer, x1, y, this.dirs, 1.0f, -32, this.topPal, TextAlign.Left, Transparent.None, ConvertType.Normal, true);
                this.topFont.drawTextScaled(renderer, x2, y, this.ffs, 1.0f, -32, this.topPal, TextAlign.Left, Transparent.None, ConvertType.Normal, true);
            }

            @Override
            public void drawPath(Renderer renderer, int x, int y, String path) {
                super.drawPath(renderer, x, y, this.path);
            }
        };
        this.list.topPal = 10;
        this.list.pathPal = 10;
        this.list.listPal = 12;
        this.list.backgroundPal = 4;
        this.addItem(title, false);
        this.addItem(this.list, true);
    }

    public boolean mFromNetworkMenu() {
        return this.app.menu.getLastMenu() == this.app.menu.mMenus[11];
    }

    public void setShowMain(boolean show) {
        this.showmain = show;
        if (Main.game.getCache().isGameDirectory(this.list.getDirectory())) {
            this.list.refreshList();
        }
    }

    private void launchEpisode(GameInfo game) {
        if (game == null) {
            return;
        }
        if (this.mFromNetworkMenu()) {
            NetworkMenu network = (NetworkMenu)this.app.menu.mMenus[11];
            network.setEpisode(game);
            this.app.menu.mMenuBack();
            return;
        }
        NewAddonMenu next = (NewAddonMenu)this.app.menu.mMenus[14];
        next.setEpisode(game);
        this.app.menu.mOpen(next, -1);
    }

    private void launchMap(FileEntry file) {
        if (file == null) {
            return;
        }
        if (this.mFromNetworkMenu()) {
            NetworkMenu network = (NetworkMenu)this.app.menu.mMenus[11];
            network.setMap(file);
            this.app.menu.mMenuBack();
            return;
        }
        DifficultyMenu next = (DifficultyMenu)this.app.menu.mMenus[4];
        next.setMap(file);
        this.app.menu.mOpen(next, -1);
    }
}

