/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck.Menus;

import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuSlider;
import ru.m210projects.Build.Pattern.MenuItems.MenuSwitch;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Redneck.Factory.RRRenderer;
import ru.m210projects.Redneck.Main;
import ru.m210projects.Redneck.Menus.RRTitle;
import ru.m210projects.Redneck.Sounds;

public class TrackPlayerMenu
extends BuildMenu {
    public TrackPlayerMenu() {
        super(Main.game.pMenu);
        this.addItem(new RRTitle("8 Track Player"), false);
        this.addItem(new TrackItem(160, 90), true);
        this.addItem(new PowerSwitch(74, 109), false);
        this.addItem(new MenuSlider(Main.game.pSlider, "Music volume", Main.game.getFont(1), 45, 140, 230, (int)(Main.cfg.getMusicVolume() * 256.0f), 0, 256, 8, (handler, pItem) -> {
            MenuSlider slider = (MenuSlider)pItem;
            Main.cfg.setMusicVolume((float)slider.value / 256.0f);
        }, false){

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(!Main.cfg.isMuteMusic());
                super.draw(handler);
            }
        }, false);
        this.addItem(new MenuSwitch("Shuffle", Main.game.getFont(1), 45, 155, 230, Main.cfg.gShuffleMusic, (handler, pItem) -> {
            MenuSwitch sw = (MenuSwitch)pItem;
            Main.cfg.gShuffleMusic = sw.value;
        }, null, null){

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(!Main.cfg.isMuteMusic());
                super.draw(handler);
            }
        }, false);
    }

    private static class TrackItem
    extends MenuItem {
        final int x;
        final int y;
        final int[] tx;
        final int[] ty;
        int TrackFocus = -1;

        public TrackItem(int x, int y) {
            super(null, null);
            this.x = x;
            this.y = y;
            this.flags = 7;
            this.tx = new int[]{x - 101, x - 70, x - 41, x - 12};
            this.ty = new int[]{y - 33, y - 18};
        }

        @Override
        public void draw(MenuHandler handler) {
            RRRenderer renderer = Main.game.getRenderer();
            renderer.rotatesprite(this.x << 16, this.y << 16, 48000, 0, 370, 0, 0, 10);
            if (!Main.cfg.isMuteMusic()) {
                int num;
                if (Sounds.currMusic != null && Sounds.currMusic.isPlaying() && (num = Sounds.currTrack) >= 0 && num < 8) {
                    renderer.rotatesprite(this.tx[num % 4] << 16, this.ty[num / 4 & 1] << 16, 48000, 0, 371, 0, 0, 26);
                }
                if (this.TrackFocus != -1 && (Main.engine.getTotalClock() & 0x10) != 0 && this.isFocused()) {
                    renderer.rotatesprite(this.tx[this.TrackFocus % 4] << 16, this.ty[this.TrackFocus / 4 & 1] << 16, 48000, 0, 371, 0, 0, 26);
                }
            }
            if (this.isFocused()) {
                renderer.rotatesprite(this.x - 136 << 16, this.y + Main.engine.getTile(512).getHeight() - 40 << 16, 8192, 0, 896 + (Main.engine.getTotalClock() >> 3 & 0xF), 8 - (Main.engine.getTotalClock() & 0x3F), 0, 10);
            }
        }

        private void changeTrack(int num) {
            if (num != -1 && !Sounds.sndPlayTrack(num)) {
                Console.out.println("Music track not found!");
            }
        }

        @Override
        public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
            switch (opt) {
                case LMB: 
                case ENTER: {
                    if ((this.flags & 4) == 0) {
                        return false;
                    }
                    Sounds.sound(2);
                    this.changeTrack(this.TrackFocus);
                    break;
                }
                case LEFT: {
                    if ((this.flags & 4) == 0) {
                        return false;
                    }
                    Sounds.sound(335);
                    --this.TrackFocus;
                    this.TrackFocus &= 7;
                    break;
                }
                case RIGHT: {
                    if ((this.flags & 4) == 0) {
                        return false;
                    }
                    Sounds.sound(335);
                    ++this.TrackFocus;
                    this.TrackFocus &= 7;
                    break;
                }
                case UP: {
                    int line = this.TrackFocus / 4;
                    if (!Main.cfg.isMuteMusic() && line == 1) {
                        this.TrackFocus -= 4;
                        this.TrackFocus &= 7;
                        break;
                    }
                    this.m_pMenu.mNavUp();
                    break;
                }
                case DW: {
                    int line = this.TrackFocus / 4;
                    if (!Main.cfg.isMuteMusic() && line == 0) {
                        this.TrackFocus += 4;
                        this.TrackFocus &= 7;
                        break;
                    }
                    this.m_pMenu.mNavDown();
                    break;
                }
                default: {
                    return this.m_pMenu.mNavigation(opt);
                }
            }
            return false;
        }

        @Override
        public boolean mouseAction(int mx, int my) {
            for (int i = 0; i < 4; ++i) {
                if (mx <= this.tx[i] || mx >= this.tx[i] + 10) continue;
                for (int j = 0; j < 2; ++j) {
                    if (my <= this.ty[j] || my >= this.ty[j] + 10) continue;
                    this.TrackFocus = i + 4 * j;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void open() {
            this.TrackFocus = Sounds.currTrack;
        }

        @Override
        public void close() {
        }
    }

    private static class PowerSwitch
    extends MenuSwitch {
        public PowerSwitch(int x, int y) {
            super(null, null, x, y, 320, Main.cfg.isMuteMusic(), null, null, null);
        }

        @Override
        public void draw(MenuHandler handler) {
            RRRenderer renderer = Main.game.getRenderer();
            if (Main.cfg.isMuteMusic()) {
                renderer.rotatesprite(this.x << 16, this.y << 16, 48000, 0, 372, 0, 0, 10);
            } else {
                renderer.rotatesprite(this.x << 16, this.y << 16, 48000, 0, 373, 0, 0, 10);
            }
            if (this.isFocused()) {
                renderer.rotatesprite(this.x - 50 << 16, this.y + Main.engine.getTile(512).getHeight() - 20 << 16, 8192, 0, 896 + (Main.engine.getTotalClock() >> 3 & 0xF), 8 - (Main.engine.getTotalClock() & 0x3F), 0, 10);
            }
        }

        @Override
        public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
            switch (opt) {
                case LMB: 
                case ENTER: {
                    if ((this.flags & 4) == 0) {
                        return false;
                    }
                    Main.cfg.setMuteMusic(!Main.cfg.isMuteMusic());
                    Sounds.sound(0);
                    break;
                }
                default: {
                    return this.m_pMenu.mNavigation(opt);
                }
            }
            return false;
        }

        @Override
        public boolean mouseAction(int mx, int my) {
            if (mx > this.x - 15 && mx < this.x + 15) {
                return my > this.y - 15 && my < this.y + 10;
            }
            return false;
        }
    }
}

