/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck.Screens;

import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.ScreenAdapters.MovieScreen;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;
import ru.m210projects.Redneck.Globals;
import ru.m210projects.Redneck.Sounds;
import ru.m210projects.Redneck.filehandle.AnimFile;

public class AnmScreen
extends MovieScreen {
    private int lastanimhack;

    public AnmScreen(BuildGame game) {
        super(game, Globals.TILE_ANIM);
        this.nFlags |= 4;
    }

    public static void logoanimsounds(int fr, int num) {
        switch (num) {
            case 0: {
                if (fr != 1) break;
                Sounds.sound(29);
                break;
            }
            case 1: {
                if (fr != 1) break;
                Sounds.sound(478);
                break;
            }
            case 2: {
                if (fr != 1) break;
                Sounds.sound(479);
                break;
            }
            case 5: {
                if (fr != 1 || Globals.currentGame.getCON().type == 1) break;
                Sounds.sound(35);
                break;
            }
            case 6: {
                if (fr != 1 || Globals.currentGame.getCON().type == 1) break;
                Sounds.sound(82);
            }
        }
    }

    public boolean init(String fn, int t) {
        if (this.isInited()) {
            return false;
        }
        if (!this.open(fn)) {
            return false;
        }
        this.lastanimhack = t;
        this.frame = 1;
        return true;
    }

    @Override
    protected boolean play() {
        Renderer renderer = this.game.getRenderer();
        if (this.mvfil != null) {
            if (this.LastMS == -1L) {
                this.LastMS = this.engine.getCurrentTimeMillis();
            }
            DynamicArtEntry pic = (DynamicArtEntry)this.engine.getTile(this.TILE_MOVIE);
            long ms = this.engine.getCurrentTimeMillis();
            long dt = ms - this.LastMS;
            this.mvtime += dt;
            float tick = this.mvfil.getRate();
            int numFrames = this.mvfil.getFrames();
            if ((float)this.mvtime >= tick) {
                if (this.frame < numFrames) {
                    pic.copyData(this.DoDrawFrame(this.frame));
                    ++this.frame;
                }
                this.mvtime -= (long)tick;
            }
            this.LastMS = ms;
            if (pic.getWidth() <= 0) {
                return false;
            }
            if (pic.getBytes() != null) {
                renderer.rotatesprite(this.nPosX << 16, this.nPosY << 16, this.nScale, 512, this.TILE_MOVIE, 0, 0, this.nFlags);
            }
            return this.frame < numFrames;
        }
        return false;
    }

    @Override
    protected MovieScreen.MovieFile GetFile(String file) {
        Entry entry = this.game.getCache().getEntry(file, true);
        if (!entry.exists()) {
            return null;
        }
        float rate = 1000.0f;
        if (file.equalsIgnoreCase("redneck.anm")) {
            rate = 700.0f;
        }
        if (file.equalsIgnoreCase("rr_outro.anm")) {
            rate = 1200.0f;
        }
        if (file.startsWith("lvl")) {
            rate = 2000.0f;
        }
        return new AnimFile(entry.getBytes(), rate);
    }

    @Override
    protected void StopAllSounds() {
        Sounds.StopAllSounds();
        Sounds.sndStopMusic();
    }

    @Override
    protected byte[] DoDrawFrame(int frame) {
        AnmScreen.logoanimsounds(frame, this.lastanimhack);
        return this.mvfil.getFrame(frame);
    }

    @Override
    protected Font GetFont() {
        return this.game.getFont(0);
    }

    @Override
    protected void DrawEscText(Font font, int pal) {
        Renderer renderer = this.game.getRenderer();
        int shade = 16 + Pragmas.mulscale(16L, EngineUtils.sin(20 * this.engine.getTotalClock() & 0x7FF), 16);
        font.drawTextScaled(renderer, 160, 5, "Press ESC to skip", 1.0f, shade, pal, TextAlign.Center, Transparent.None, ConvertType.Normal, true);
    }
}

