/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck.Types;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Redneck.Gamedef;
import ru.m210projects.Redneck.Globals;
import ru.m210projects.Redneck.Main;
import ru.m210projects.Redneck.Types.EpisodeInfo;
import ru.m210projects.Redneck.Types.MapInfo;
import ru.m210projects.Redneck.Types.Script;
import ru.m210projects.Redneck.filehandle.EpisodeEntry;

public class GameInfo {
    public String title;
    private final EpisodeEntry file;
    public final EpisodeInfo[] episodes;
    public final String[] skillnames;
    public int nEpisodes;
    private Script ConScr;
    private int textptr;

    public GameInfo(EpisodeEntry entry) throws Exception {
        this.file = entry;
        this.title = entry.getName();
        this.skillnames = new String[5];
        this.episodes = new EpisodeInfo[3];
        this.nEpisodes = 0;
        LinkedHashMap<String, Group> cachedGroups = new LinkedHashMap<String, Group>();
        for (Entry scriptEntry : entry.getIncludes()) {
            byte[] data = Gamedef.preparescript(scriptEntry.getBytes());
            this.findSkillNames(data);
            this.findVolumes(data);
            this.findMaps(data);
            Group parent = scriptEntry.getParent();
            cachedGroups.put(parent.getName(), parent);
        }
        this.checkEpisodes(cachedGroups);
    }

    public String toString() {
        return this.file.getHashKey();
    }

    public EpisodeEntry getEpisodeEntry() {
        return this.file;
    }

    public Script getCON() {
        return this.ConScr;
    }

    public void setCON(Script con) {
        this.ConScr = con;
    }

    public EpisodeInfo getCurrentEpisode() {
        if (Globals.ud.volume_number < this.episodes.length) {
            return this.episodes[Globals.ud.volume_number];
        }
        return null;
    }

    private Entry findMap(Path mapPath, Map<String, Group> groups) {
        for (Group group : groups.values()) {
            Entry mapEntry = group.getEntry(mapPath);
            if (!mapEntry.exists()) continue;
            return mapEntry;
        }
        HashMap<String, Group> extraGroups = new HashMap<String, Group>();
        for (Group group : groups.values()) {
            if (Main.game.getCache().isGameDirectory(group)) continue;
            for (Entry entry : group.getEntries()) {
                if (groups.containsKey(entry.getName()) || !entry.isExtension("pk3") && !entry.isExtension("zip") && !entry.isExtension("grp") && !entry.isExtension("rff")) continue;
                Group extraGroup = Main.game.getCache().newGroup(entry);
                extraGroups.put(entry.getName(), extraGroup);
                Entry mapEntry = extraGroup.getEntry(mapPath);
                if (!mapEntry.exists()) continue;
                groups.putAll(extraGroups);
                return mapEntry;
            }
        }
        groups.putAll(extraGroups);
        return Directory.DUMMY_ENTRY;
    }

    private void checkEpisodes(Map<String, Group> cachedGroups) throws Exception {
        int sum = 0;
        for (int e = 0; e < this.nEpisodes; ++e) {
            EpisodeInfo episodeInfo = this.episodes[e];
            if (episodeInfo == null) continue;
            int presenceCount = 0;
            for (int i = 0; i < episodeInfo.nMaps; ++i) {
                MapInfo mapInfo = episodeInfo.getMapInfo(i);
                if (mapInfo == null) continue;
                Entry mapEntry = this.findMap(mapInfo.getPath(), cachedGroups);
                if (mapEntry.exists()) {
                    ++presenceCount;
                    continue;
                }
                mapInfo.clear();
                break;
            }
            episodeInfo.nMaps = presenceCount;
            sum += episodeInfo.nMaps;
        }
        if (sum == 0) {
            throw new Exception("Maps in addon are not found");
        }
        if (Globals.defGame != null && this.skillnames[0] == null) {
            Console.out.println("Appling default skill names for " + this.title);
            for (int i = 0; i < Globals.defGame.getCON().nSkills; ++i) {
                this.skillnames[i] = new String(Globals.defGame.getCON().skill_names[i]).trim();
            }
        }
    }

    private void findVolumes(byte[] buf) {
        int index = -1;
        while ((index = Strhandler.indexOf("definevolumename ", buf, index + 1)) != -1) {
            this.textptr = index + 16;
            Integer j = this.transnum(buf);
            if (j == null) continue;
            while (buf[this.textptr] == 32) {
                ++this.textptr;
            }
            int i = 0;
            int startptr = this.textptr;
            while (buf[this.textptr + i] != 10) {
                ++i;
            }
            String title = new String(buf, startptr, i - 1).toUpperCase();
            if (this.episodes[j] != null) {
                this.episodes[j.intValue()].Title = title;
            } else {
                this.episodes[j.intValue()] = new EpisodeInfo(title);
            }
            this.nEpisodes = Math.max(this.nEpisodes, j + 1);
        }
    }

    private void findMaps(byte[] buf) {
        int index = -1;
        while ((index = Strhandler.indexOf("definelevelname ", buf, index + 1)) != -1) {
            Integer mapnum;
            this.textptr = index + 15;
            Integer epnum = this.transnum(buf);
            if (epnum == null || (mapnum = this.transnum(buf)) == null) continue;
            while (buf[this.textptr] == 32) {
                ++this.textptr;
            }
            int i = 0;
            int ptr = this.textptr;
            while (buf[this.textptr] != 32 && buf[this.textptr] != 10) {
                ++this.textptr;
                ++i;
            }
            Path path = FileUtils.getPath(new String(buf, ptr, i), new String[0]);
            if (this.episodes[epnum] == null) {
                this.episodes[epnum.intValue()] = new EpisodeInfo("Episode " + epnum);
                this.nEpisodes = Math.max(this.nEpisodes, epnum + 1);
            }
            while (buf[this.textptr] == 32) {
                ++this.textptr;
            }
            int partime = ((buf[this.textptr] - 48) * 10 + (buf[this.textptr + 1] - 48)) * 26 * 60 + ((buf[this.textptr + 3] - 48) * 10 + (buf[this.textptr + 4] - 48)) * 26;
            this.textptr += 5;
            while (buf[this.textptr] == 32) {
                ++this.textptr;
            }
            int designertime = ((buf[this.textptr] - 48) * 10 + (buf[this.textptr + 1] - 48)) * 26 * 60 + ((buf[this.textptr + 3] - 48) * 10 + (buf[this.textptr + 4] - 48)) * 26;
            this.textptr += 5;
            while (buf[this.textptr] == 32) {
                ++this.textptr;
            }
            i = 0;
            while (buf[this.textptr + i] != 10) {
                ++i;
            }
            String title = new String(buf, this.textptr, i - 1);
            this.episodes[epnum].setMapInfo(mapnum, new MapInfo(path, title, partime, designertime));
            this.episodes[epnum.intValue()].nMaps = Math.max(this.episodes[epnum.intValue()].nMaps, mapnum + 1);
        }
    }

    private void findSkillNames(byte[] buf) {
        int index = -1;
        int size = 0;
        while ((index = Strhandler.indexOf("defineskillname ", buf, index + 1)) != -1) {
            this.textptr = index + 15;
            Integer j = this.transnum(buf);
            if (j == null) continue;
            while (buf[this.textptr] == 32) {
                ++this.textptr;
            }
            int i = 0;
            while (buf[this.textptr + i] != 10) {
                ++i;
            }
            this.skillnames[j.intValue()] = new String(buf, this.textptr, i - 1).toUpperCase();
            size = Math.max(size, j + 1);
        }
    }

    private Integer transnum(byte[] text) {
        int i;
        char[] tempbuf = new char[2048];
        while (!Gamedef.isaltok(text[this.textptr])) {
            ++this.textptr;
            if (text[this.textptr] != 0) continue;
            return null;
        }
        int l = 0;
        while (Gamedef.isaltok(text[this.textptr + l])) {
            tempbuf[l] = (char)text[this.textptr + l];
            ++l;
        }
        tempbuf[l] = '\u0000';
        for (i = 0; i < 147; ++i) {
            if (Strhandler.Bstrcmp(Gamedef.label, Gamedef.labelcnt << 6, Gamedef.keyw[i], 0) != 0) continue;
            ++Gamedef.error;
            Console.out.println("  * ERROR! Symbol '" + Gamedef.label[Gamedef.labelcnt << 6] + "' is a key word.");
            this.textptr += l;
        }
        for (i = 0; i < Gamedef.labelcnt; ++i) {
            if (Strhandler.Bstrcmp(tempbuf, 0, Gamedef.label, i << 6) != 0) continue;
            this.textptr += l;
            return Gamedef.labelcode.get(i);
        }
        if (!Character.isDigit(text[this.textptr]) && text[this.textptr] != 45) {
            Console.out.println("  * ERROR! Parameter '" + new String(tempbuf, 0, l) + "' is undefined.");
            ++Gamedef.error;
            this.textptr += l;
            return null;
        }
        String number = new String(text, this.textptr, l);
        this.textptr += l;
        return Integer.parseInt(number);
    }
}

