/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck.filehandle;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Pattern.ScreenAdapters.MovieScreen;
import ru.m210projects.Build.Types.LittleEndian;

public class AnimFile
implements MovieScreen.MovieFile {
    final Header lpheader;
    final Descriptor[] LpArray;
    int curlpnum;
    Descriptor curlp;
    final byte[] imagebuffer = new byte[65536];
    final byte[] buffer;
    final byte[] pal;
    int currentframe;
    int thepage;
    final float rate;

    public AnimFile(byte[] data, float rate) {
        int i;
        this.LpArray = new Descriptor[256];
        this.pal = new byte[768];
        this.rate = rate;
        this.buffer = data;
        this.curlpnum = 65535;
        this.currentframe = -1;
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        this.lpheader = new Header(bb);
        bb.position(bb.position() + 128);
        for (i = 0; i < 768; i += 3) {
            this.pal[i + 2] = bb.get();
            this.pal[i + 1] = bb.get();
            this.pal[i] = bb.get();
            bb.get();
        }
        for (i = 0; i < 256; ++i) {
            this.LpArray[i] = new Descriptor(bb);
        }
    }

    private void drawframe(int framenumber) {
        int pagenumber = this.findpage(framenumber);
        int offset = this.loadpage(pagenumber);
        try {
            this.renderframe(framenumber, offset);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private int findpage(int framenumber) {
        int i;
        for (i = 0; i < this.lpheader.nLps; ++i) {
            if (this.LpArray[i].baseRecord > framenumber || this.LpArray[i].baseRecord + this.LpArray[i].nRecords <= framenumber) continue;
            return i;
        }
        return i;
    }

    private int loadpage(int pagenumber) {
        if (this.curlpnum != pagenumber) {
            this.curlpnum = pagenumber;
            this.curlp = this.LpArray[pagenumber];
            this.thepage = 2816 + pagenumber * 65536 + 8;
        }
        return this.thepage;
    }

    private void renderframe(int framenumber, int pagepointer) {
        int offset = 0;
        int destframe = framenumber - this.curlp.baseRecord;
        for (int i = 0; i < 2 * destframe; i += 2) {
            offset += LittleEndian.getUShort(this.buffer, i + pagepointer);
        }
        pagepointer = this.buffer[(pagepointer += this.curlp.nRecords * 2 + offset) + 1] != 0 ? (pagepointer += 4 + (this.buffer[pagepointer + 1] + (this.buffer[pagepointer + 1] & 1))) : (pagepointer += 4);
        this.CPlayRunSkipDump(pagepointer, this.imagebuffer);
    }

    private void CPlayRunSkipDump(int srcPtr, byte[] dst) {
        int dstP = 0;
        while (true) {
            byte pixel;
            int wordCnt;
            byte cnt;
            if ((cnt = this.buffer[srcPtr++]) > 0) {
                do {
                    dst[dstP++] = this.buffer[srcPtr++];
                } while ((cnt = (byte)(cnt - 1)) != 0);
                continue;
            }
            if (cnt == 0) {
                wordCnt = this.buffer[srcPtr++] & 0xFF;
                pixel = this.buffer[srcPtr++];
                do {
                    dst[dstP++] = pixel;
                } while (--wordCnt != 0);
                continue;
            }
            if ((cnt = (byte)(cnt + 128)) == 0) {
                wordCnt = LittleEndian.getUShort(this.buffer, srcPtr);
                srcPtr += 2;
                if (wordCnt == 0) break;
                if ((short)wordCnt < 0) {
                    if ((wordCnt -= 32768) >= 16384) {
                        wordCnt -= 16384;
                        pixel = this.buffer[srcPtr++];
                        do {
                            dst[dstP++] = pixel;
                        } while (--wordCnt != 0);
                        continue;
                    }
                    do {
                        dst[dstP++] = this.buffer[srcPtr++];
                    } while (--wordCnt != 0);
                    continue;
                }
                dstP += wordCnt;
                continue;
            }
            dstP += cnt;
        }
    }

    @Override
    public byte[] getPalette() {
        return this.pal;
    }

    @Override
    public int getFrames() {
        return this.lpheader.nRecords;
    }

    @Override
    public float getRate() {
        return this.rate / (float)this.lpheader.framesPerSecond;
    }

    @Override
    public byte[] getFrame(int framenumber) {
        if (this.currentframe != -1 && this.currentframe <= framenumber) {
            for (int cnt = this.currentframe; cnt < framenumber; ++cnt) {
                this.drawframe(cnt);
            }
        } else {
            for (int cnt = 0; cnt < framenumber; ++cnt) {
                this.drawframe(cnt);
            }
        }
        this.currentframe = framenumber;
        return this.imagebuffer;
    }

    @Override
    public int getWidth() {
        return 320;
    }

    @Override
    public int getHeight() {
        return 200;
    }

    @Override
    public void close() {
    }

    @Override
    public void playAudio() {
    }

    private static class Descriptor {
        final int baseRecord;
        final int nRecords;

        public Descriptor(ByteBuffer bb) {
            this.baseRecord = bb.getShort() & 0xFFFF;
            this.nRecords = bb.getShort() & 0xFFFF;
            bb.getShort();
        }
    }

    private static class Header {
        final int nLps;
        final int nRecords;
        final byte[] recordTypes;
        final int framesPerSecond;

        public Header(ByteBuffer bb) {
            bb.getInt();
            bb.getShort();
            this.nLps = bb.getShort() & 0xFFFF;
            this.nRecords = bb.getInt();
            bb.getShort();
            bb.getShort();
            bb.getInt();
            bb.getShort();
            bb.getShort();
            bb.get();
            bb.get();
            bb.get();
            bb.get();
            bb.get();
            bb.get();
            bb.get();
            bb.get();
            this.recordTypes = new byte[32];
            bb.get(this.recordTypes);
            bb.getInt();
            this.framesPerSecond = bb.getShort() & 0xFFFF;
            bb.position(bb.position() + 58);
        }
    }
}

