/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck.filehandle;

import java.io.InputStream;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Redneck.Input;
import ru.m210projects.Redneck.Premap;
import ru.m210projects.Redneck.Types.GameInfo;
import ru.m210projects.Redneck.Types.SafeLoader;
import ru.m210projects.Redneck.filehandle.LZWInputStream;

public class DemoFile {
    public int rcnt = 0;
    public Input[][] recsync;
    public int reccnt;
    public int version;
    public int volume_number;
    public int level_number;
    public int player_skill;
    public int coop;
    public int ffire;
    public int multimode;
    public boolean monsters_off;
    public boolean respawn_monsters;
    public boolean respawn_items;
    public boolean respawn_inventory;
    public int playerai;
    public final String[] user_name = new String[16];
    public String boardfilename;
    public final int[] aim_mode = new int[16];
    public final int[] auto_aim = new int[16];
    public Premap.PlayerInfo[] playerInfos = new Premap.PlayerInfo[16];
    public GameInfo addon;

    public DemoFile(InputStream is) throws Exception {
        int i;
        this.reccnt = StreamUtils.readInt(is);
        this.version = StreamUtils.readUnsignedByte(is);
        if (this.version != 108 && this.version != 147) {
            throw new Exception("Wrong version!");
        }
        if (this.reccnt == 0) {
            throw new Exception("reccnt == 0");
        }
        this.volume_number = StreamUtils.readUnsignedByte(is);
        this.level_number = StreamUtils.readUnsignedByte(is);
        this.player_skill = StreamUtils.readUnsignedByte(is);
        this.coop = StreamUtils.readUnsignedByte(is);
        this.ffire = StreamUtils.readUnsignedByte(is);
        this.multimode = StreamUtils.readShort(is);
        this.monsters_off = StreamUtils.readShort(is) == 1;
        this.respawn_monsters = StreamUtils.readInt(is) == 1;
        this.respawn_items = StreamUtils.readInt(is) == 1;
        this.respawn_inventory = StreamUtils.readInt(is) == 1;
        this.playerai = StreamUtils.readInt(is);
        for (i = 0; i < 16; ++i) {
            this.user_name[i] = StreamUtils.readString(is, 32);
        }
        if (this.version == 147) {
            boolean isPacked = StreamUtils.readBoolean(is);
            String addonFileName = StreamUtils.readDataString(is).toLowerCase();
            String addonPackedConName = null;
            if (isPacked) {
                addonPackedConName = StreamUtils.readDataString(is).toLowerCase();
            }
            this.addon = SafeLoader.findAddon(addonFileName, addonPackedConName);
            for (int i2 = 0; i2 < this.multimode; ++i2) {
                this.playerInfos[i2] = new Premap.PlayerInfo();
                this.playerInfos[i2].readObject(is);
            }
        }
        for (i = 0; i < this.multimode; ++i) {
            this.aim_mode[i] = StreamUtils.readUnsignedByte(is);
            if (this.version < 147) continue;
            this.auto_aim[i] = StreamUtils.readUnsignedByte(is);
        }
        this.recsync = new Input[this.reccnt][16];
        LZWInputStream lis = new LZWInputStream(is, Input.sizeof(this.version) * this.multimode);
        for (int c = 0; c < this.reccnt; ++c) {
            for (int i3 = 0; i3 < this.multimode; ++i3) {
                this.recsync[c][i3] = new Input().readObject(lis, this.version);
            }
        }
    }
}

