/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck.filehandle;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import ru.m210projects.Build.filehandle.StreamUtils;

public class LZWOutputStream
extends OutputStream {
    private static final int LZWSIZE = 16385;
    private final byte[] lzwbuf1;
    private final byte[] lzwbuf4;
    private final byte[] lzwbuf5;
    private final short[] lzwbuf2;
    private final short[] lzwbuf3;
    private final byte[] blockBuffer;
    private final OutputStream os;
    private int blockPos;
    private int pos;

    public LZWOutputStream(OutputStream os, int blockSize) {
        this.os = os;
        this.blockBuffer = new byte[blockSize];
        this.blockPos = 0;
        this.lzwbuf1 = new byte[17409];
        this.lzwbuf2 = new short[17409];
        this.lzwbuf3 = new short[17409];
        this.lzwbuf4 = new byte[16385];
        this.lzwbuf5 = new byte[17409];
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        Arrays.fill(this.blockBuffer, (byte)0);
    }

    private void flushBuffer() throws IOException {
        if (this.pos > 0) {
            int len = this.lzwcompress(this.lzwbuf4, this.pos, this.lzwbuf5);
            StreamUtils.writeShort(this.os, len);
            StreamUtils.writeBytes(this.os, this.lzwbuf5, len);
            this.pos = 0;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.lzwbuf4[this.blockPos + this.pos] = (byte)(b - this.blockBuffer[this.blockPos]);
        this.blockBuffer[this.blockPos++] = (byte)b;
        if (this.blockPos >= this.blockBuffer.length) {
            this.pos += this.blockBuffer.length;
            this.blockPos = 0;
        }
        if (this.pos > 16385 - this.blockBuffer.length) {
            this.flushBuffer();
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.os.close();
    }

    private int lzwcompress(byte[] lzwinbuf, int uncompleng, byte[] lzwoutbuf) {
        int intptr;
        short addr;
        for (int i = 255; i >= 0; --i) {
            this.lzwbuf1[i] = (byte)i;
            this.lzwbuf3[i] = (short)(i + 1 & 0xFF);
        }
        Arrays.fill(this.lzwbuf2, 0, 256, (short)-1);
        Arrays.fill(lzwoutbuf, 0, uncompleng + 15 + 3, (byte)0);
        ByteBuffer outbuf = ByteBuffer.wrap(lzwoutbuf);
        outbuf.order(ByteOrder.LITTLE_ENDIAN);
        short addrcnt = 256;
        int bytecnt1 = 0;
        int bitcnt = 32;
        int numbits = 8;
        short oneupnumbits = 256;
        do {
            addr = (short)(lzwinbuf[bytecnt1] & 0xFF);
            while (++bytecnt1 != uncompleng) {
                if (this.lzwbuf2[addr] < 0) {
                    this.lzwbuf2[addr] = addrcnt;
                    break;
                }
                short newaddr = this.lzwbuf2[addr];
                while (this.lzwbuf1[newaddr] != lzwinbuf[bytecnt1]) {
                    short zx = this.lzwbuf3[newaddr];
                    if (zx < 0) {
                        this.lzwbuf3[newaddr] = addrcnt;
                        break;
                    }
                    newaddr = zx;
                }
                if (this.lzwbuf3[newaddr] == addrcnt) break;
                addr = newaddr;
            }
            this.lzwbuf1[addrcnt] = lzwinbuf[bytecnt1];
            this.lzwbuf2[addrcnt] = -1;
            this.lzwbuf3[addrcnt] = -1;
            intptr = outbuf.getInt(bitcnt >> 3);
            outbuf.putInt(bitcnt >> 3, intptr | addr << (bitcnt & 7));
            bitcnt += numbits;
            if ((addr & (oneupnumbits >> 1) - 1) > (addrcnt - 1 & (oneupnumbits >> 1) - 1)) {
                --bitcnt;
            }
            if ((addrcnt = (short)(addrcnt + 1)) <= oneupnumbits) continue;
            ++numbits;
            oneupnumbits <<= 1;
        } while (bytecnt1 < uncompleng && bitcnt < uncompleng << 3);
        intptr = outbuf.getInt(bitcnt >> 3);
        outbuf.putInt(bitcnt >> 3, intptr | addr << (bitcnt & 7));
        bitcnt += numbits;
        if ((addr & (oneupnumbits >> 1) - 1) > (addrcnt - 1 & (oneupnumbits >> 1) - 1)) {
            --bitcnt;
        }
        outbuf.putShort(0, (short)uncompleng);
        if (bitcnt + 7 >> 3 < uncompleng) {
            outbuf.putShort(2, addrcnt);
            return bitcnt + 7 >> 3;
        }
        outbuf.putShort(2, (short)0);
        for (int i = 0; i < uncompleng; ++i) {
            outbuf.put(i + 4, lzwinbuf[i]);
        }
        return uncompleng + 4;
    }
}

