/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck.filehandle;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import ru.m210projects.Build.Pattern.ScreenAdapters.MovieScreen;
import ru.m210projects.Build.Types.LittleEndian;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Redneck.Main;

public class MVEFile
implements MovieScreen.MovieFile {
    private static final int CHUNK_INIT_AUDIO = 0;
    private static final int CHUNK_AUDIO_ONLY = 1;
    private static final int CHUNK_INIT_VIDEO = 2;
    private static final int CHUNK_VIDEO = 3;
    private static final int CHUNK_SHUTDOWN = 4;
    private static final int CHUNK_END = 5;
    private static final int CHUNK_DONE = 65532;
    private static final int CHUNK_EOF = 65534;
    private static final int CHUNK_BAD = 65535;
    private static final int OPCODE_END_OF_STREAM = 0;
    private static final int OPCODE_END_OF_CHUNK = 1;
    private static final int OPCODE_CREATE_TIMER = 2;
    private static final int OPCODE_INIT_AUDIO_BUFFERS = 3;
    private static final int OPCODE_START_STOP_AUDIO = 4;
    private static final int OPCODE_INIT_VIDEO_BUFFERS = 5;
    private static final int OPCODE_VIDEO_DATA_06 = 6;
    private static final int OPCODE_SEND_BUFFER = 7;
    private static final int OPCODE_AUDIO_FRAME = 8;
    private static final int OPCODE_SILENCE_FRAME = 9;
    private static final int OPCODE_INIT_VIDEO_MODE = 10;
    private static final int OPCODE_CREATE_GRADIENT = 11;
    private static final int OPCODE_SET_PALETTE = 12;
    private static final int OPCODE_SET_PALETTE_COMPRESSED = 13;
    private static final int OPCODE_SET_SKIP_MAP = 14;
    private static final int OPCODE_SET_DECODING_MAP = 15;
    private static final int OPCODE_VIDEO_DATA_10 = 16;
    private static final int OPCODE_VIDEO_DATA_11 = 17;
    private static final int OPCODE_UNKNOWN_12 = 18;
    private static final int OPCODE_UNKNOWN_13 = 19;
    private static final int OPCODE_UNKNOWN_14 = 20;
    private static final int OPCODE_UNKNOWN_15 = 21;
    private static final int AV_CODEC_ID_NONE = -1;
    private static final int AV_CODEC_ID_INTERPLAY_DPCM = 1;
    private static final int AV_CODEC_ID_PCM_S16LE = 2;
    private static final int AV_CODEC_ID_PCM_U8 = 3;
    private static final int VIDEO_DELTA_FRAME = 1;
    private static final byte[] signature = "Interplay MVE File\u001a\u0000".getBytes();
    private static final byte[] magic = new byte[]{26, 0, 0, 1, 51, 17};
    private static final int[] interplay_dpcm_delta_table = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 47, 51, 56, 61, 66, 72, 79, 86, 94, 102, 112, 122, 133, 145, 158, 173, 189, 206, 225, 245, 267, 292, 318, 348, 379, 414, 452, 493, 538, 587, 640, 699, 763, 832, 908, 991, 1081, 1180, 1288, 1405, 1534, 1673, 1826, 1993, 2175, 2373, 2590, 2826, 3084, 3365, 3672, 4008, 4373, 4772, 5208, 5683, 6202, 6767, 7385, 8059, 8794, 9597, 10472, 11428, 12471, 13609, 14851, 16206, 17685, 19298, 21060, 22981, 25078, 27367, 29864, 32589, -29973, -26728, -23186, -19322, -15105, -10503, -5481, -1, 1, 1, 5481, 10503, 15105, 19322, 23186, 26728, 29973, -32589, -29864, -27367, -25078, -22981, -21060, -19298, -17685, -16206, -14851, -13609, -12471, -11428, -10472, -9597, -8794, -8059, -7385, -6767, -6202, -5683, -5208, -4772, -4373, -4008, -3672, -3365, -3084, -2826, -2590, -2373, -2175, -1993, -1826, -1673, -1534, -1405, -1288, -1180, -1081, -991, -908, -832, -763, -699, -640, -587, -538, -493, -452, -414, -379, -348, -318, -292, -267, -245, -225, -206, -189, -173, -158, -145, -133, -122, -112, -102, -94, -86, -79, -72, -66, -61, -56, -51, -47, -43, -42, -41, -40, -39, -38, -37, -36, -35, -34, -33, -32, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, -5, -4, -3, -2, -1};
    private int audio_type;
    private int audio_channels;
    private int audio_bits;
    private int audio_frame_count;
    private int width;
    private int height;
    private int frame_pts_inc;
    private int video_bpp;
    private byte frame_format;
    private final byte[] palette = new byte[768];
    private boolean hasPalette;
    private boolean send_buffer;
    private int audio_chunk_offset;
    private int audio_chunk_size;
    private int skip_map_chunk_offset;
    private short skip_map_chunk_size;
    private int decode_map_chunk_offset;
    private short decode_map_chunk_size;
    private int video_chunk_offset;
    private short video_chunk_size;
    private int next_chunk_offset;
    private final FramePacket pkt = new FramePacket();
    private int video_pts;
    private int back_buf1;
    private int back_buf2;
    private byte[] buffer;
    private byte[] frame;
    private int max_block_offset;
    private final MVEInputStream is;

    public MVEFile(String file) throws IOException {
        Entry entry = Main.game.getCache().getEntry(file, true);
        if (!entry.exists()) {
            throw new FileNotFoundException();
        }
        InputStream entryInputStream = entry.getInputStream();
        this.is = entryInputStream instanceof FileInputStream ? new MVEInputStream((FileInputStream)entryInputStream) : new MVEInputStream(entryInputStream, (int)entry.getSize());
        byte[] signatureData = StreamUtils.readBytes((InputStream)this.is, 20);
        if (!Arrays.equals(signatureData, signature)) {
            throw new RuntimeException("Wrong signature " + new String(signatureData) + " != " + new String(signature));
        }
        if (!Arrays.equals(StreamUtils.readBytes((InputStream)this.is, 6), magic)) {
            throw new RuntimeException("Wrong file version");
        }
        this.next_chunk_offset = this.is.getPosition();
        if (this.process_chunk(this.is) != 2) {
            throw new RuntimeException("AVERROR_INVALIDDATA");
        }
        StreamUtils.skip(this.is, 2);
        short chunk_type = StreamUtils.readShort(this.is);
        if (chunk_type == 3) {
            this.audio_type = 0;
        } else if (this.process_chunk(this.is) != 0) {
            throw new RuntimeException("AVERROR_INVALIDDATA");
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public boolean update() {
        try {
            return this.process_chunk(this.is) == 65532;
        }
        catch (Exception e) {
            Console.out.println("MVE update error: " + e, OsdColor.RED);
            return false;
        }
    }

    @Override
    public byte[] getPalette() {
        if (this.hasPalette) {
            return this.palette;
        }
        return null;
    }

    @Override
    public int getFrames() {
        return 0x7FFFFFFE;
    }

    @Override
    public float getRate() {
        float rate = this.frame_pts_inc;
        if (rate == 0.0f) {
            rate = 1000.0f;
        }
        return rate / 2000.0f;
    }

    @Override
    public byte[] getFrame(int num) {
        if (this.frame != null) {
            Arrays.fill(this.frame, (byte)0);
        }
        if (this.pkt.video_chunk_data == null) {
            return this.frame;
        }
        if (!this.decode()) {
            return this.frame;
        }
        System.arraycopy(this.buffer, this.back_buf1, this.frame, 0, this.frame.length);
        return this.frame;
    }

    @Override
    public void close() {
        try {
            this.is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void playAudio() {
    }

    private int process_chunk(MVEInputStream is) throws IOException {
        int chunk_type = this.load_ipmovie_packet(is);
        if (chunk_type != 65532) {
            return chunk_type;
        }
        int chunk_size = StreamUtils.readShort(is);
        chunk_type = StreamUtils.readShort(is);
        switch (chunk_type) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                chunk_type = 65535;
            }
        }
        block29: while (chunk_size > 0 && chunk_type != 65535) {
            short opcode_size = StreamUtils.readShort(is);
            int opcode_type = StreamUtils.readUnsignedByte(is);
            int opcode_version = StreamUtils.readUnsignedByte(is);
            chunk_size -= 4;
            chunk_size -= opcode_size;
            switch (opcode_type) {
                case 0: {
                    StreamUtils.skip(is, opcode_size);
                    continue block29;
                }
                case 1: {
                    StreamUtils.skip(is, opcode_size);
                    continue block29;
                }
                case 2: {
                    if (opcode_version > 0 || opcode_size != 6) {
                        System.err.println("bad create_timer opcode");
                        chunk_type = 65535;
                        continue block29;
                    }
                    this.frame_pts_inc = StreamUtils.readInt(is);
                    this.frame_pts_inc *= StreamUtils.readShort(is);
                    continue block29;
                }
                case 3: {
                    if (opcode_version > 1 || opcode_size > 10 || opcode_size < 6) {
                        System.err.println("bad init_audio_buffers opcode\n");
                        chunk_type = 65535;
                        continue block29;
                    }
                    byte[] scratch = StreamUtils.readBytes((InputStream)is, opcode_size);
                    int audio_sample_rate = LittleEndian.getUShort(scratch, 4);
                    int audio_flags = LittleEndian.getUShort(scratch, 2);
                    this.audio_channels = (audio_flags & 1) + 1;
                    this.audio_bits = ((audio_flags >> 1 & 1) + 1) * 8;
                    if (opcode_version == 1 && (audio_flags & 4) != 0) {
                        this.audio_type = 1;
                        continue block29;
                    }
                    if (this.audio_bits == 16) {
                        this.audio_type = 2;
                        continue block29;
                    }
                    this.audio_type = 3;
                    continue block29;
                }
                case 4: {
                    StreamUtils.skip(is, opcode_size);
                    continue block29;
                }
                case 5: {
                    if (opcode_version > 2 || opcode_size > 8 || opcode_size < 4 || opcode_version == 2 && opcode_size < 8) {
                        System.err.println("bad init_video_buffers opcode");
                        chunk_type = 65535;
                        continue block29;
                    }
                    this.width = StreamUtils.readShort(is) * 8;
                    this.height = StreamUtils.readShort(is) * 8;
                    if (opcode_version == 2) {
                        StreamUtils.readShort(is);
                    }
                    this.video_bpp = opcode_version < 2 || StreamUtils.readShort(is) == 0 ? 8 : 16;
                    int size = this.width * this.height * (this.video_bpp == 8 ? 1 : 2);
                    this.buffer = new byte[2 * size];
                    this.back_buf1 = 0;
                    this.back_buf2 = size;
                    this.max_block_offset = (this.height - 7) * this.width - 8;
                    this.frame = new byte[size];
                    continue block29;
                }
                case 10: {
                    StreamUtils.skip(is, opcode_size);
                    continue block29;
                }
                case 7: {
                    StreamUtils.skip(is, opcode_size);
                    this.send_buffer = true;
                    continue block29;
                }
                case 8: {
                    this.audio_chunk_offset = is.getPosition();
                    this.audio_chunk_size = opcode_size;
                    StreamUtils.skip(is, opcode_size);
                    continue block29;
                }
                case 9: {
                    StreamUtils.skip(is, opcode_size);
                    continue block29;
                }
                case 11: {
                    StreamUtils.skip(is, opcode_size);
                    continue block29;
                }
                case 13: {
                    StreamUtils.skip(is, opcode_size);
                    continue block29;
                }
                case 14: {
                    this.skip_map_chunk_offset = is.getPosition();
                    this.skip_map_chunk_size = opcode_size;
                    StreamUtils.skip(is, opcode_size);
                    continue block29;
                }
                case 15: {
                    this.decode_map_chunk_offset = is.getPosition();
                    this.decode_map_chunk_size = opcode_size;
                    StreamUtils.skip(is, opcode_size);
                    continue block29;
                }
                case 6: {
                    this.frame_format = (byte)6;
                    this.video_chunk_offset = is.getPosition();
                    this.video_chunk_size = opcode_size;
                    StreamUtils.skip(is, opcode_size);
                    continue block29;
                }
                case 16: {
                    this.frame_format = (byte)16;
                    this.video_chunk_offset = is.getPosition();
                    this.video_chunk_size = opcode_size;
                    StreamUtils.skip(is, opcode_size);
                    continue block29;
                }
                case 17: {
                    this.frame_format = (byte)17;
                    this.video_chunk_offset = is.getPosition();
                    this.video_chunk_size = opcode_size;
                    StreamUtils.skip(is, opcode_size);
                    continue block29;
                }
                case 12: {
                    if (opcode_size > 772 || opcode_size < 4) {
                        System.err.println("demux_ipmovie: set_palette opcode with invalid size");
                        chunk_type = 65535;
                        continue block29;
                    }
                    int first_color = StreamUtils.readShort(is) & 0xFF;
                    int last_color = first_color + (StreamUtils.readShort(is) & 0xFF) - 1;
                    if (last_color > 255 || (last_color - first_color + 1) * 3 + 4 > opcode_size) {
                        System.err.println("demux_ipmovie: set_palette indexes out of range (" + first_color + " . " + last_color + ")");
                        chunk_type = 65535;
                        continue block29;
                    }
                    for (int i = first_color; i <= last_color; ++i) {
                        this.palette[3 * i] = (byte)(StreamUtils.readUnsignedByte(is) * 4);
                        this.palette[3 * i + 1] = (byte)(StreamUtils.readUnsignedByte(is) * 4);
                        this.palette[3 * i + 2] = (byte)(StreamUtils.readUnsignedByte(is) * 4);
                    }
                    this.hasPalette = true;
                    continue block29;
                }
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    StreamUtils.skip(is, opcode_size);
                    continue block29;
                }
            }
            chunk_type = 65535;
        }
        this.next_chunk_offset = is.getPosition();
        if (chunk_type == 3 || chunk_type == 1) {
            chunk_type = this.load_ipmovie_packet(is);
        }
        return chunk_type;
    }

    private int load_ipmovie_packet(MVEInputStream is) throws IOException {
        int chunk_type;
        if (this.audio_chunk_offset != 0 && this.audio_channels != 0 && this.audio_bits != 0) {
            if (this.audio_type == -1) {
                System.err.println("Can not read audio packet before audio codec is known");
                return 65535;
            }
            if (this.audio_type != 1) {
                this.audio_chunk_offset += 6;
                this.audio_chunk_size -= 6;
            }
            is.setPosition(this.audio_chunk_offset);
            this.audio_chunk_offset = 0;
            if (is.available() < this.audio_chunk_size) {
                return 65534;
            }
            this.pkt.audio_chunk_data = StreamUtils.readBytes((InputStream)is, this.audio_chunk_size);
            this.pkt.pts = this.audio_frame_count;
            this.audio_frame_count = this.audio_type != 1 ? (this.audio_frame_count += this.audio_chunk_size / this.audio_channels / (this.audio_bits / 8)) : (this.audio_frame_count += (this.audio_chunk_size - 6 - this.audio_channels) / this.audio_channels);
            chunk_type = 3;
        } else if (this.frame_format != 0) {
            this.pkt.video_chunk_data = new byte[this.video_chunk_size];
            this.pkt.decode_map_chunk_data = new byte[this.decode_map_chunk_size];
            this.pkt.skip_map_chunk_data = new byte[this.skip_map_chunk_size];
            if (this.hasPalette) {
                this.pkt.palette = new byte[768];
                System.arraycopy(this.palette, 0, this.pkt.palette, 0, 768);
                this.hasPalette = false;
            }
            this.pkt.frame_format = this.frame_format;
            this.pkt.send_buffer = this.send_buffer;
            this.pkt.video_chunk_size = this.video_chunk_size;
            this.pkt.decode_map_chunk_size = this.decode_map_chunk_size;
            this.pkt.skip_map_chunk_size = this.skip_map_chunk_size;
            this.frame_format = 0;
            this.send_buffer = false;
            this.pkt.pos = this.video_chunk_offset;
            is.setPosition(this.video_chunk_offset);
            this.video_chunk_offset = 0;
            if (is.available() < this.video_chunk_size) {
                return 65534;
            }
            this.pkt.video_chunk_data = StreamUtils.readBytes((InputStream)is, this.video_chunk_size);
            if (this.decode_map_chunk_size != 0) {
                this.pkt.pos = this.decode_map_chunk_offset;
                is.setPosition(this.decode_map_chunk_offset);
                this.decode_map_chunk_offset = 0;
                if (is.available() < this.decode_map_chunk_size) {
                    return 65534;
                }
                this.pkt.decode_map_chunk_data = StreamUtils.readBytes((InputStream)is, this.decode_map_chunk_size);
            }
            if (this.skip_map_chunk_size != 0) {
                this.pkt.pos = this.skip_map_chunk_offset;
                is.setPosition(this.skip_map_chunk_offset);
                this.skip_map_chunk_offset = 0;
                if (is.available() < this.skip_map_chunk_size) {
                    return 65534;
                }
                this.pkt.skip_map_chunk_data = StreamUtils.readBytes((InputStream)is, this.skip_map_chunk_size);
            }
            this.video_chunk_size = 0;
            this.decode_map_chunk_size = 0;
            this.skip_map_chunk_size = 0;
            this.pkt.pts = this.video_pts;
            this.video_pts += this.frame_pts_inc;
            chunk_type = 3;
        } else {
            is.setPosition(this.next_chunk_offset);
            chunk_type = 65532;
        }
        return chunk_type;
    }

    private boolean decode() {
        ByteBuffer bb = ByteBuffer.wrap(this.pkt.video_chunk_data).order(ByteOrder.LITTLE_ENDIAN);
        bb.getShort();
        bb.getShort();
        bb.getShort();
        bb.getShort();
        bb.getShort();
        bb.getShort();
        int flags = bb.getShort() & 0xFFFF;
        if ((flags & 1) != 0) {
            int temp = this.back_buf1;
            this.back_buf1 = this.back_buf2;
            this.back_buf2 = temp;
        }
        if (this.video_bpp == 16) {
            throw new UnsupportedOperationException("video_bpp == 16");
        }
        bb.limit(this.pkt.video_chunk_size);
        boolean dec = this.decode_frame8(bb);
        return dec;
    }

    private boolean decode_frame8(ByteBuffer data) {
        boolean rc = true;
        int index = 0;
        int xx = this.width >> 3;
        int yy = this.height >> 3;
        int frameptr = this.back_buf1;
        for (int y = 0; y < yy; ++y) {
            for (int x = 0; x < xx; ++x) {
                int opcode = index & true ? (this.pkt.decode_map_chunk_data[index >> 1] & 0xFF) >> 4 : this.pkt.decode_map_chunk_data[index >> 1] & 0xF;
                ++index;
                switch (opcode) {
                    case 0: {
                        rc = this.copy_block(frameptr, frameptr + (this.back_buf2 - this.back_buf1), 0);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        rc = this.decode_0x2(frameptr, data);
                        break;
                    }
                    case 3: {
                        rc = this.decode_0x3(frameptr, data);
                        break;
                    }
                    case 4: {
                        rc = this.decode_0x4(frameptr, data);
                        break;
                    }
                    case 5: {
                        rc = this.decode_0x5(frameptr, data);
                        break;
                    }
                    case 6: {
                        rc = false;
                        break;
                    }
                    case 7: {
                        rc = this.decode_0x7(frameptr, data);
                        break;
                    }
                    case 8: {
                        rc = this.decode_0x8(frameptr, data);
                        break;
                    }
                    case 9: {
                        rc = this.decode_0x9(frameptr, data);
                        break;
                    }
                    case 10: {
                        rc = this.decode_0xa(frameptr, data);
                        break;
                    }
                    case 11: {
                        rc = this.decode_0xb(frameptr, data);
                        break;
                    }
                    case 12: {
                        rc = this.decode_0xc(frameptr, data);
                        break;
                    }
                    case 13: {
                        rc = this.decode_0xd(frameptr, data);
                        break;
                    }
                    case 14: {
                        rc = this.decode_0xe(frameptr, data);
                        break;
                    }
                    case 15: {
                        rc = this.decode_0xf(frameptr, data);
                    }
                }
                if (!rc) {
                    return false;
                }
                frameptr += 8;
            }
            frameptr += 7 * this.width;
        }
        return true;
    }

    private boolean copy_block(int frameptr, int src_offset, int offset) {
        long frame_offset = frameptr - this.back_buf1 + offset;
        if (frame_offset < 0L) {
            Console.out.println("frame offset < 0 (" + frame_offset + ")", OsdColor.RED);
            return false;
        }
        if (frame_offset > (long)this.max_block_offset) {
            Console.out.println("frame offset above limit (" + frame_offset + " > " + this.max_block_offset + ")", OsdColor.RED);
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            System.arraycopy(this.buffer, src_offset, this.buffer, frameptr, 8);
            frameptr += this.width;
            src_offset += this.width;
        }
        return true;
    }

    private boolean decode_0x2(int frame, ByteBuffer data) {
        int y;
        int x;
        if (!data.hasRemaining()) {
            return false;
        }
        int B = data.get() & 0xFF;
        if (B < 56) {
            x = 8 + B % 7;
            y = B / 7;
        } else {
            x = -14 + (B - 56) % 29;
            y = 8 + (B - 56) / 29;
        }
        int offset = y * this.width + x;
        return this.copy_block(frame, frame + offset, offset);
    }

    private boolean decode_0x3(int frame, ByteBuffer data) {
        int y;
        int x;
        if (!data.hasRemaining()) {
            return false;
        }
        int B = data.get() & 0xFF;
        if (B < 56) {
            x = -(8 + B % 7);
            y = -(B / 7);
        } else {
            x = -(-14 + (B - 56) % 29);
            y = -(8 + (B - 56) / 29);
        }
        int offset = y * this.width + x;
        return this.copy_block(frame, frame + offset, offset);
    }

    private boolean decode_0x4(int frame, ByteBuffer data) {
        if (!data.hasRemaining()) {
            return false;
        }
        int B = data.get() & 0xFF;
        int x = -8 + (B & 0xF);
        int y = -8 + (B >> 4 & 0xF);
        int offset = y * this.width + x;
        return this.copy_block(frame, frame + (this.back_buf2 - this.back_buf1) + offset, offset);
    }

    private boolean decode_0x5(int frame, ByteBuffer data) {
        if (data.remaining() < 2) {
            return false;
        }
        byte x = data.get();
        byte y = data.get();
        int offset = y * this.width + x;
        return this.copy_block(frame, frame + (this.back_buf2 - this.back_buf1) + offset, offset);
    }

    private boolean decode_0x7(int frame, ByteBuffer data) {
        if (data.remaining() < 4) {
            return false;
        }
        byte[] P = new byte[2];
        data.get(P);
        if ((P[0] & 0xFF) <= (P[1] & 0xFF)) {
            for (int y = 0; y < 8; ++y) {
                for (int flags = data.get() & 0xFF | 0x100; flags != 1; flags >>= 1) {
                    this.buffer[frame++] = P[flags & 1];
                }
                frame += this.width - 8;
            }
        } else {
            int flags = data.getShort();
            for (int y = 0; y < 8; y += 2) {
                int x = 0;
                while (x < 8) {
                    byte by = P[flags & 1];
                    this.buffer[frame + x + 1 + this.width] = by;
                    this.buffer[frame + x + this.width] = by;
                    this.buffer[frame + x + 1] = by;
                    this.buffer[frame + x] = by;
                    x += 2;
                    flags >>= 1;
                }
                frame += this.width * 2;
            }
        }
        return true;
    }

    private boolean decode_0x8(int frame, ByteBuffer data) {
        byte[] P = new byte[8];
        int flags = 0;
        if (data.remaining() < 12) {
            return false;
        }
        data.get(P, 0, 2);
        if ((P[0] & 0xFF) <= (P[1] & 0xFF)) {
            for (int y = 0; y < 16; ++y) {
                if ((y & 3) == 0) {
                    if (y != 0) {
                        data.get(P, 0, 2);
                    }
                    flags = data.getShort();
                }
                int x = 0;
                while (x < 4) {
                    this.buffer[frame++] = P[flags & 1];
                    ++x;
                    flags >>= 1;
                }
                frame += this.width - 4;
                if (y != 7) continue;
                frame -= 8 * this.width - 4;
            }
        } else {
            flags = data.getInt();
            data.get(P, 2, 2);
            if ((P[2] & 0xFF) <= (P[3] & 0xFF)) {
                for (int y = 0; y < 16; ++y) {
                    int x = 0;
                    while (x < 4) {
                        this.buffer[frame++] = P[flags & 1];
                        ++x;
                        flags >>= 1;
                    }
                    frame += this.width - 4;
                    if (y != 7) continue;
                    frame -= 8 * this.width - 4;
                    P[0] = P[2];
                    P[1] = P[3];
                    flags = data.getInt();
                }
            } else {
                for (int y = 0; y < 8; ++y) {
                    if (y == 4) {
                        P[0] = P[2];
                        P[1] = P[3];
                        flags = data.getInt();
                    }
                    int x = 0;
                    while (x < 8) {
                        this.buffer[frame++] = P[flags & 1];
                        ++x;
                        flags >>= 1;
                    }
                    frame += this.width - 8;
                }
            }
        }
        return true;
    }

    private boolean decode_0x9(int frame, ByteBuffer data) {
        if (data.remaining() < 8) {
            return false;
        }
        byte[] P = new byte[4];
        data.get(P);
        if ((P[0] & 0xFF) <= (P[1] & 0xFF)) {
            if ((P[2] & 0xFF) <= (P[3] & 0xFF)) {
                for (int y = 0; y < 8; ++y) {
                    int flags = data.getShort();
                    int x = 0;
                    while (x < 8) {
                        this.buffer[frame++] = P[flags & 3];
                        ++x;
                        flags >>= 2;
                    }
                    frame += this.width - 8;
                }
            } else {
                int flags = data.getInt();
                for (int y = 0; y < 8; y += 2) {
                    int x = 0;
                    while (x < 8) {
                        byte by = P[flags & 3];
                        this.buffer[frame + x + 1 + this.width] = by;
                        this.buffer[frame + x + this.width] = by;
                        this.buffer[frame + x + 1] = by;
                        this.buffer[frame + x] = by;
                        x += 2;
                        flags >>= 2;
                    }
                    frame += this.width * 2;
                }
            }
        } else {
            long flags = data.getLong();
            if ((P[2] & 0xFF) <= (P[3] & 0xFF)) {
                for (int y = 0; y < 8; ++y) {
                    int x = 0;
                    while (x < 8) {
                        byte by = P[(int)(flags & 3L)];
                        this.buffer[frame + x + 1] = by;
                        this.buffer[frame + x] = by;
                        x += 2;
                        flags >>= 2;
                    }
                    frame += this.width;
                }
            } else {
                for (int y = 0; y < 8; y += 2) {
                    int x = 0;
                    while (x < 8) {
                        byte by = P[(int)(flags & 3L)];
                        this.buffer[frame + x + this.width] = by;
                        this.buffer[frame + x] = by;
                        ++x;
                        flags >>= 2;
                    }
                    frame += this.width * 2;
                }
            }
        }
        return true;
    }

    private boolean decode_0xa(int frame, ByteBuffer data) {
        byte[] P = new byte[8];
        if (data.remaining() < 16) {
            return false;
        }
        data.get(P, 0, 4);
        if ((P[0] & 0xFF) <= (P[1] & 0xFF)) {
            int flags = 0;
            for (int y = 0; y < 16; ++y) {
                if ((y & 3) == 0) {
                    if (y != 0) {
                        data.get(P, 0, 4);
                    }
                    flags = data.getInt();
                }
                int x = 0;
                while (x < 4) {
                    this.buffer[frame++] = P[flags & 3];
                    ++x;
                    flags >>= 2;
                }
                frame += this.width - 4;
                if (y != 7) continue;
                frame -= 8 * this.width - 4;
            }
        } else {
            long flags = data.getLong();
            data.get(P, 4, 4);
            boolean vert = (P[4] & 0xFF) <= (P[5] & 0xFF);
            for (int y = 0; y < 16; ++y) {
                int x = 0;
                while (x < 4) {
                    this.buffer[frame++] = P[(int)(flags & 3L)];
                    ++x;
                    flags >>= 2;
                }
                if (vert) {
                    frame += this.width - 4;
                    if (y == 7) {
                        frame -= 8 * this.width - 4;
                    }
                } else if ((y & 1) != 0) {
                    frame += this.width - 8;
                }
                if (y != 7) continue;
                System.arraycopy(P, 4, P, 0, 4);
                flags = data.getLong();
            }
        }
        return true;
    }

    private boolean decode_0xb(int frame, ByteBuffer data) {
        if (data.remaining() < 64) {
            return false;
        }
        for (int y = 0; y < 8; ++y) {
            data.get(this.buffer, frame, 8);
            frame += this.width;
        }
        return true;
    }

    private boolean decode_0xc(int frame, ByteBuffer data) {
        if (data.remaining() < 16) {
            return false;
        }
        for (int y = 0; y < 8; y += 2) {
            for (int x = 0; x < 8; x += 2) {
                byte by = data.get();
                this.buffer[frame + this.width + x + 1] = by;
                this.buffer[frame + this.width + x] = by;
                this.buffer[frame + x + 1] = by;
                this.buffer[frame + x] = by;
            }
            frame += this.width * 2;
        }
        return true;
    }

    private boolean decode_0xd(int frame, ByteBuffer data) {
        if (data.remaining() < 4) {
            return false;
        }
        byte[] P = new byte[2];
        for (int y = 0; y < 8; ++y) {
            if ((y & 3) == 0) {
                data.get(P);
            }
            Arrays.fill(this.buffer, frame, frame + 4, P[0]);
            Arrays.fill(this.buffer, frame + 4, frame + 8, P[1]);
            frame += this.width;
        }
        return true;
    }

    private boolean decode_0xe(int frame, ByteBuffer data) {
        if (data.remaining() < 1) {
            return false;
        }
        byte pix = data.get();
        for (int y = 0; y < 8; ++y) {
            Arrays.fill(this.buffer, frame, frame + 8, pix);
            frame += this.width;
        }
        return true;
    }

    private boolean decode_0xf(int frame, ByteBuffer data) {
        if (data.remaining() < 2) {
            return false;
        }
        byte[] P = new byte[2];
        data.get(P);
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 4; ++x) {
                this.buffer[frame++] = P[y & 1];
                this.buffer[frame++] = P[y & 1 ^ 1];
            }
            frame += this.width - 8;
        }
        return true;
    }

    public static class FramePacket {
        public int pts;
        public byte frame_format;
        public boolean send_buffer;
        public short video_chunk_size;
        public byte[] video_chunk_data;
        public short decode_map_chunk_size;
        public byte[] decode_map_chunk_data;
        public short skip_map_chunk_size;
        public byte[] skip_map_chunk_data;
        public byte[] audio_chunk_data;
        public byte[] palette;
        public int pos;
    }

    private static class MVEInputStream
    extends BufferedInputStream {
        private int pos = 0;
        private final boolean seekSupport;

        public MVEInputStream(FileInputStream in) {
            super(in);
            this.seekSupport = true;
        }

        public MVEInputStream(InputStream in, int fileSize) {
            super(in, fileSize);
            this.seekSupport = false;
        }

        @Override
        public synchronized int read() throws IOException {
            int data = super.read();
            if (data != -1) {
                ++this.pos;
                return data;
            }
            return -1;
        }

        @Override
        public synchronized int read(byte @NotNull [] b, int off, int len) throws IOException {
            int n;
            if (b == null) {
                MVEInputStream.$$$reportNull$$$0(0);
            }
            if ((n = super.read(b, off, len)) != -1) {
                this.pos += n;
            }
            return n;
        }

        @Override
        public synchronized long skip(long n) throws IOException {
            long len;
            long result = 0L;
            do {
                len = super.skip(n);
                this.pos += (int)len;
                result += len;
            } while ((n -= len) > 0L);
            return result;
        }

        public synchronized int getPosition() {
            return this.pos;
        }

        public synchronized void setPosition(int position) throws IOException {
            if (position >= this.pos) {
                StreamUtils.skip(this, position - this.pos);
            } else {
                int readBufferSegment = this.pos / this.buf.length;
                int newBufferSegment = position / this.buf.length;
                int offset = this.pos - position;
                if (readBufferSegment == newBufferSegment && ((BufferedInputStream)this).pos - offset > 0) {
                    ((BufferedInputStream)this).pos -= offset;
                    this.pos = position;
                    return;
                }
                if (this.seekSupport) {
                    int newPos = newBufferSegment * this.buf.length;
                    ((FileInputStream)this.in).getChannel().position(newPos);
                    this.count = this.in.read(this.buf);
                    ((BufferedInputStream)this).pos = 0;
                    this.pos = newPos;
                    this.setPosition(position);
                } else {
                    throw new UnsupportedOperationException();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "ru/m210projects/Redneck/filehandle/MVEFile$MVEInputStream", "read"));
        }
    }
}

