/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck.filehandle.rts;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.EntryInputStream;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.InputStreamProvider;

public class LumpInfo
implements Entry {
    private final String name;
    private final InputStreamProvider provider;
    private final int offset;
    private final int size;
    private byte[] cache;
    Group parent;

    public LumpInfo(InputStreamProvider provider, String name, int offset, int size) {
        this.provider = provider;
        this.offset = offset;
        this.size = size;
        this.name = name;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream is = this.provider.newInputStream();
        if (is.skip(this.offset) != (long)this.offset) {
            throw new EOFException();
        }
        return new EntryInputStream(is, this.size);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExtension() {
        return "";
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public Group getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Group parent) {
        this.parent = parent;
    }

    @Override
    public byte[] getBytes() {
        if (this.cache == null) {
            this.cache = Entry.super.getBytes();
        }
        return this.cache;
    }
}

