/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Tekwar;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.stream.IntStream;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.settings.ConfigContext;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Build.settings.GameKeys;
import ru.m210projects.Build.settings.InputContext;
import ru.m210projects.Build.settings.Properties;
import ru.m210projects.Tekwar.View;

public class Config
extends GameConfig {
    public static final int[] defclassickeys = new int[]{19, 20, 21, 22, 0, 57, 55, 74, 52, 31, 59, 62, 129, 75, 74, 92, 93, 61, 70, 69, 41, 49, 111, 68, 66, 3, 46, 33, 36, 35, 48, 47, 37, 76, 131, 132, 133, 134, 135, 136, 139, 140, 141, 142, 8, 9, 10, 11, 12, 13, 14, 15};
    public static final int TOGGLE_TIME = 0;
    public static final int TOGGLE_SCORE = 1;
    public static final int TOGGLE_REARVIEW = 2;
    public static final int TOGGLE_UPRT = 3;
    public static final int TOGGLE_HEALTH = 4;
    public static final int TOGGLE_INVENTORY = 5;
    public int weaponIndex = -1;
    public static final int[] defkeys = new int[]{51, 47, 21, 22, 67, 57, 29, 32, 62, 129, 59, 33, 0, 75, 74, 92, 93, 61, 70, 69, 41, 49, 111, 68, 66, 3, 46, 0, 36, 35, 48, 0, 37, 76, 131, 132, 133, 134, 135, 136, 139, 140, 141, 142, 8, 9, 10, 11, 12, 13, 14, 15};
    public boolean gCrosshair = true;
    public boolean gHeadBob = true;
    public boolean gAutoRun = true;
    public boolean showMessages = false;
    public int gHUDSize = 65536;
    public int gStatSize = 65536;
    public int gCrossSize = 65536;
    public int gShowStat = 1;
    public boolean showCutscenes = true;
    public int showMapInfo = 1;
    public boolean gSaveWeapons = false;
    public final boolean[] toggles = new boolean[]{false, false, false, true, true, true};
    public int gOverlayMap = 2;

    public Config(Path path) {
        super(path);
    }

    public GameKey[] getKeyMap() {
        return new GameKey[]{GameKeys.Move_Forward, GameKeys.Move_Backward, GameKeys.Turn_Left, GameKeys.Turn_Right, GameKeys.Turn_Around, GameKeys.Open, GameKeys.Run, GameKeys.Strafe, GameKeys.Weapon_Fire, GameKeys.Jump, GameKeys.Crouch, GameKeys.Look_Up, GameKeys.Look_Down, GameKeys.Strafe_Left, GameKeys.Strafe_Right, GameKeys.Map_Toggle, TekKeys.Throw_Item, GameKeys.Enlarge_Screen, GameKeys.Shrink_Screen, GameKeys.Send_Message, TekKeys.Aim_Center, TekKeys.Rearview, TekKeys.Prepared_Item, TekKeys.Health_Meter, TekKeys.Toggle_Crosshair, TekKeys.Elapsed_Time, TekKeys.Score, TekKeys.Inventory, TekKeys.Weapon_1, TekKeys.Weapon_2, TekKeys.Weapon_3, TekKeys.Weapon_4, TekKeys.Weapon_5, TekKeys.Weapon_6, TekKeys.Weapon_7, TekKeys.Weapon_8, GameKeys.Next_Weapon, GameKeys.Previous_Weapon, TekKeys.Holster_Weapon, GameKeys.Mouse_Aiming, GameKeys.Show_Console, TekKeys.Show_HelpScreen, TekKeys.Show_SaveMenu, TekKeys.Show_LoadMenu, TekKeys.Show_SoundSetup, TekKeys.Show_Options, TekKeys.Quicksave, TekKeys.Quickload, TekKeys.Quit, TekKeys.Gamma, TekKeys.Make_Screenshot, GameKeys.Menu_Toggle};
    }

    @Override
    protected InputContext createDefaultInputContext() {
        return new InputContext(this.getKeyMap(), defkeys, defclassickeys){

            @Override
            protected void clearInput() {
                super.clearInput();
                Config.this.weaponIndex = IntStream.range(0, this.keymap.length).filter(i -> this.keymap[i].equals(TekKeys.Weapon_1)).findFirst().orElse(-1);
            }

            @Override
            public void resetInput(boolean classicKeys) {
                super.resetInput(classicKeys);
                this.primarykeys[2][TekKeys.Holster_Weapon.getNum()] = 227;
                this.primarykeys[2][GameKeys.Jump.getNum()] = 228;
            }
        };
    }

    @Override
    protected ConfigContext createDefaultGameContext() {
        return new ConfigContext(){

            @Override
            public void load(Properties prop) {
                if (prop.setContext("Options")) {
                    Config.this.gHUDSize = prop.getIntValue("HUDSize", Config.this.gHUDSize);
                    Config.this.gCrosshair = prop.getBooleanValue("Crosshair", Config.this.gCrosshair);
                    Config.this.showMessages = prop.getBooleanValue("Show_Messages", Config.this.showMessages);
                    Config.this.gAutoRun = prop.getBooleanValue("AutoRun", Config.this.gAutoRun);
                    Config.this.gHeadBob = prop.getBooleanValue("HeadBobbing", Config.this.gHeadBob);
                    Config.this.gStatSize = Math.max(16384, prop.getIntValue("StatSize", Config.this.gStatSize));
                    Config.this.gCrossSize = Math.max(16384, prop.getIntValue("CrossSize", Config.this.gCrossSize));
                    Config.this.gShowStat = prop.getIntValue("ShowStat", Config.this.gShowStat);
                    Config.this.showCutscenes = prop.getBooleanValue("showCutscenes", Config.this.showCutscenes);
                    Config.this.showMapInfo = prop.getIntValue("showMapInfo", Config.this.showMapInfo);
                    Config.this.gOverlayMap = prop.getIntValue("OverlayMap", Config.this.gOverlayMap);
                    Config.this.gSaveWeapons = prop.getBooleanValue("Save_weapons", Config.this.gSaveWeapons);
                    Config.this.toggles[2] = prop.getBooleanValue("Rearview", Config.this.toggles[2]);
                    Config.this.toggles[3] = prop.getBooleanValue("Prepared_Item", Config.this.toggles[3]);
                    Config.this.toggles[4] = prop.getBooleanValue("Health_Meter", Config.this.toggles[4]);
                    Config.this.toggles[0] = prop.getBooleanValue("Elapsed_Time", Config.this.toggles[0]);
                    Config.this.toggles[1] = prop.getBooleanValue("Score", Config.this.toggles[1]);
                    Config.this.toggles[5] = prop.getBooleanValue("Inventory", Config.this.toggles[5]);
                    View.rvmoving = Config.this.toggles[2] ? 1 : 0;
                    View.wpmoving = Config.this.toggles[3] ? 1 : 0;
                    View.hcmoving = Config.this.toggles[4] ? 1 : 0;
                }
            }

            @Override
            public void save(OutputStream os) throws IOException {
                this.putString(os, "[Options]\r\n");
                this.putInteger(os, "HUDSize", Config.this.gHUDSize);
                this.putBoolean(os, "Crosshair", Config.this.gCrosshair);
                this.putBoolean(os, "Show_Messages", Config.this.showMessages);
                this.putBoolean(os, "AutoRun", Config.this.gAutoRun);
                this.putBoolean(os, "HeadBobbing", Config.this.gHeadBob);
                this.putString(os, "AdultPassword = \"\"\r\n");
                this.putInteger(os, "StatSize", Config.this.gStatSize);
                this.putInteger(os, "CrossSize", Config.this.gCrossSize);
                this.putInteger(os, "ShowStat", Config.this.gShowStat);
                this.putBoolean(os, "showCutscenes", Config.this.showCutscenes);
                this.putInteger(os, "showMapInfo", Config.this.showMapInfo);
                this.putInteger(os, "OverlayMap", Config.this.gOverlayMap);
                this.putBoolean(os, "Save_weapons", Config.this.gSaveWeapons);
                this.putBoolean(os, "Rearview", Config.this.toggles[2]);
                this.putBoolean(os, "Prepared_Item", Config.this.toggles[3]);
                this.putBoolean(os, "Health_Meter", Config.this.toggles[4]);
                this.putBoolean(os, "Elapsed_Time", Config.this.toggles[0]);
                this.putBoolean(os, "Score", Config.this.toggles[1]);
                this.putBoolean(os, "Inventory", Config.this.toggles[5]);
            }
        };
    }

    public static enum TekKeys implements GameKey
    {
        Throw_Item,
        Aim_Center,
        Rearview,
        Prepared_Item,
        Health_Meter,
        Toggle_Crosshair,
        Elapsed_Time,
        Score,
        Inventory,
        Holster_Weapon,
        Show_HelpScreen,
        Show_SaveMenu,
        Show_LoadMenu,
        Show_SoundSetup,
        Show_Options,
        Quicksave,
        Quickload,
        Quit,
        Gamma,
        Make_Screenshot,
        Weapon_1,
        Weapon_2,
        Weapon_3,
        Weapon_4,
        Weapon_5,
        Weapon_6,
        Weapon_7,
        Weapon_8;


        @Override
        public int getNum() {
            return GameKeys.values().length + this.ordinal();
        }

        @Override
        public String getName() {
            return this.name();
        }
    }
}

