/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Tekwar.Factory;

import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.DefaultMapSettings;
import ru.m210projects.Build.Render.IOverheadMapSettings;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Tekwar.Main;
import ru.m210projects.Tekwar.Player;
import ru.m210projects.Tekwar.View;

public class TekMapSettings
extends DefaultMapSettings {
    public TekMapSettings(BoardService boardService) {
        super(boardService);
    }

    @Override
    public int getWallColor(int w, int s) {
        Wall wal = this.boardService.getWall(w);
        if (wal == null) {
            return 0;
        }
        Sector nextsec = this.boardService.getSector(wal.getNextsector());
        if (nextsec != null) {
            return 232;
        }
        return 239;
    }

    @Override
    public boolean isWallVisible(int w, int s) {
        Wall wal = this.boardService.getWall(w);
        if (View.gViewMode == 4 && wal != null && wal.getNextsector() != 0) {
            Wall nextwal;
            short k = wal.getNextwall();
            if (k < 0) {
                return false;
            }
            if (!Engine.show2dwall.getBit(w)) {
                return false;
            }
            if (k > w && Engine.show2dwall.getBit(k)) {
                return false;
            }
            Sector nextsec = this.boardService.getSector(wal.getNextsector());
            Sector sec = this.boardService.getSector(s);
            if (nextsec == null || sec == null) {
                return false;
            }
            if (nextsec.getCeilingz() == sec.getCeilingz() && nextsec.getFloorz() == sec.getFloorz() && (nextwal = this.boardService.getWall(wal.getNextwall())) != null && ((wal.getCstat() | nextwal.getCstat()) & 0x30) == 0) {
                return false;
            }
            if (sec.getFloorz() != sec.getCeilingz() && nextsec.getFloorz() != nextsec.getCeilingz() && (nextwal = this.boardService.getWall(wal.getNextwall())) != null && ((wal.getCstat() | nextwal.getCstat()) & 0x30) == 0 && sec.getFloorz() == nextsec.getFloorz()) {
                return false;
            }
            if (sec.getFloorpicnum() != nextsec.getFloorpicnum()) {
                return false;
            }
            return sec.getFloorshade() == nextsec.getFloorshade();
        }
        return true;
    }

    @Override
    public boolean isSpriteVisible(IOverheadMapSettings.MapView view, int index) {
        if (view == IOverheadMapSettings.MapView.Polygons) {
            return false;
        }
        Sprite sp = this.boardService.getSprite(index);
        if (sp == null) {
            return false;
        }
        switch (sp.getCstat() & 0x30) {
            case 0: {
                return true;
            }
            case 16: {
                return true;
            }
            case 32: {
                return View.gViewMode == 2;
            }
        }
        return true;
    }

    @Override
    public int getPlayerPicnum(int player) {
        if (View.gViewMode == 2) {
            return -1;
        }
        int spr = this.getPlayerSprite(player);
        Sprite psp = this.boardService.getSprite(spr);
        return psp != null ? (int)psp.getPicnum() : -1;
    }

    @Override
    public int getSpriteColor(int s) {
        Sprite spr = this.boardService.getSprite(s);
        if (s == Player.gPlayer[Main.screenpeek].playersprite) {
            return 31;
        }
        if (spr != null && (spr.getCstat() & 1) != 0) {
            return 248;
        }
        return 56;
    }

    @Override
    public int getPlayerSprite(int player) {
        return Player.gPlayer[player].playersprite;
    }

    @Override
    public int getViewPlayer() {
        return Main.screenpeek;
    }
}

