/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Tekwar.Factory;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.IOverheadMapSettings;
import ru.m210projects.Build.Render.Polymost.Polymost;
import ru.m210projects.Build.Render.Polymost.Polymost2D;
import ru.m210projects.Build.Render.Types.ScreenFade;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Tekwar.Factory.TekMapSettings;
import ru.m210projects.Tekwar.Factory.TekRenderer;
import ru.m210projects.Tekwar.Main;
import ru.m210projects.Tekwar.View;

public class TekPolymost
extends Polymost
implements TekRenderer {
    public TekPolymost(GameConfig config) {
        super(config);
    }

    @Override
    protected Polymost2D allocOrphoRenderer(Engine engine) {
        return new Polymost2D(this, (IOverheadMapSettings)new TekMapSettings(engine.getBoardService()));
    }

    private void renderScreenFade() {
        this.gl.glBegin(4);
        for (int i = 0; i < 6; i += 2) {
            this.gl.glVertex2f(vertices[i], vertices[i + 1]);
        }
        this.gl.glEnd();
    }

    @Override
    public void scrSetDac() {
        if (this.config.isPaletteEmulation()) {
            TekRenderer.super.scrSetDac();
            return;
        }
        if (Main.game.menu.gShowMenu) {
            return;
        }
        boolean hasShader = this.beginShowFade();
        for (ScreenFade fade : View.SCREEN_DAC_ARRAY) {
            this.showScreenFade(fade);
        }
        this.endShowFade(hasShader);
    }

    @Override
    public void showScreenFade(ScreenFade screenFade) {
        int intensive = screenFade.getIntensive();
        if (intensive == 0) {
            return;
        }
        if (intensive > 32) {
            intensive = 32;
        }
        int g = 0;
        int b = 0;
        switch (screenFade.getName()) {
            case "PICKUP": {
                int r = g = (int)Math.min(1.5f * ((float)intensive + (intensive < 10 ? (float)intensive / 2.0f : 0.0f)), 255.0f);
                int a = Math.min(intensive + 32, 255);
                this.gl.glBlendFunc(774, 771);
                this.gl.glColor4ub(r, g, b, a);
                this.renderScreenFade();
                this.gl.glBlendFunc(771, 771);
                this.gl.glColor4ub(r, g, 0, 0);
                this.renderScreenFade();
                break;
            }
            case "DAMAGE": {
                int a;
                int r = a = (int)Math.min(3.5f * ((float)intensive + (intensive < 10 ? (float)intensive / 2.0f : 0.0f)), 255.0f);
                this.gl.glBlendFunc(774, 771);
                this.gl.glColor4ub(r, g, b, a);
                this.renderScreenFade();
                this.gl.glBlendFunc(771, 771);
                this.gl.glColor4ub(r, 0, 0, 0);
                this.renderScreenFade();
            }
        }
    }
}

