/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Tekwar.Menus;

import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.SliderDrawable;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Tekwar.Factory.TekRenderer;
import ru.m210projects.Tekwar.Main;

public class TekSliderDrawable
extends SliderDrawable {
    protected final BuildGame app;

    public TekSliderDrawable(BuildGame app) {
        this.app = app;
    }

    @Override
    public void drawSliderBackground(int x, int y, int shade, int pal) {
        if (pal == 4) {
            pal = 0;
        }
        Renderer renderer = this.app.getRenderer();
        renderer.rotatesprite(x - 6 << 16, y - 2 << 16, 32768, 0, 1569, shade, pal, 26);
    }

    @Override
    public void drawSlider(int x, int y, int shade, int pal) {
        TekRenderer renderer = Main.game.getRenderer();
        renderer.rotatesprite(x - 1 << 16, y - 2 << 16, 32768, 0, 1574, shade, pal, 26);
    }

    @Override
    public int getSliderWidth() {
        return 3;
    }

    @Override
    public int getSliderRange() {
        return 58;
    }

    @Override
    public int getScrollerHeight() {
        return 3;
    }

    @Override
    public int getScrollerWidth() {
        return 8;
    }

    @Override
    public void drawScrollerBackground(int x, int y, int height, int shade, int pal) {
        height -= 12;
        int ang = 512;
        int sy = y + 4;
        TekRenderer renderer = Main.game.getRenderer();
        int xdim = renderer.getWidth();
        int ydim = renderer.getHeight();
        renderer.rotatesprite(x + 7 << 16, y - 5 << 16, 32768, ang, 1569, 8, 0, 26, 0, 0, xdim - 1, Gameutils.coordsConvertYScaled(sy));
        ArtEntry pic = this.app.pEngine.getTile(1569);
        int dy = pic.getWidth() / 2 - 17;
        int posy = sy;
        for (int clen = height; clen > 0; clen -= dy) {
            if (dy > clen) {
                dy = clen;
            }
            renderer.rotatesprite(x + 7 << 16, posy - 9 << 16, 32768, ang, 1569, 8, 0, 26, 0, Gameutils.coordsConvertYScaled(posy), xdim - 1, Gameutils.coordsConvertYScaled(posy + dy));
            posy += dy;
        }
        int y2 = sy + height;
        renderer.rotatesprite(x + 7 << 16, y2 - pic.getWidth() / 2 + 13 << 16, 32768, ang, 1569, 8, 0, 26, 0, Gameutils.coordsConvertYScaled(y2), xdim - 1, ydim - 1);
    }

    @Override
    public void drawScroller(int x, int y, int shade, int pal) {
        TekRenderer renderer = Main.game.getRenderer();
        renderer.rotatesprite(x + 7 << 16, y << 16, 32768, 512, 1574, shade, pal, 26);
    }
}

