/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Tekwar.Screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.ScreenAdapter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;
import ru.m210projects.Build.input.GameProcessor;
import ru.m210projects.Build.input.InputListener;
import ru.m210projects.BuildSmacker.SMKFile;
import ru.m210projects.Tekwar.Factory.TekRenderer;
import ru.m210projects.Tekwar.Main;
import ru.m210projects.Tekwar.Screens.CreditsScreen;
import ru.m210projects.Tekwar.Teksnd;

public abstract class SmkMenu
extends ScreenAdapter
implements InputListener {
    private final int kSMKTile = Engine.MAXTILES - 3;
    protected int currmission;
    protected MessageType message = MessageType.NONE;
    protected final Main game;
    private SMKFile smkfil;
    private Runnable chooseCallback;
    private float delayclock;
    private float helpclock;
    private boolean rebuild;

    public SmkMenu(Main game) {
        this.game = game;
    }

    public abstract int skip();

    public abstract void keyUp();

    public abstract void keyDown();

    public abstract void keyLeft();

    public abstract void keyRight();

    public abstract void loadGame();

    public abstract String init();

    public abstract void rebuildFrame();

    public abstract boolean mouseHandler(int var1, int var2);

    public void setCallback(Runnable chooseCallback) {
        this.chooseCallback = chooseCallback;
    }

    @Override
    public synchronized void show() {
        this.rebuild = true;
        this.delayclock = 0.0f;
        this.helpclock = 0.0f;
        this.message = MessageType.NONE;
        Gdx.input.setCursorCatched(false);
        this.init(this.init());
    }

    @Override
    public void hide() {
        if (this.smkfil == null) {
            return;
        }
        Gdx.input.setCursorCatched(true);
        this.smkfil = null;
    }

    @Override
    public synchronized void render(float delta) {
        if (this.smkfil == null) {
            return;
        }
        if (this.rebuild || this.mouseHandler(Gdx.input.getX(), Gdx.input.getY())) {
            this.rebuildFrame();
            DynamicArtEntry pic = (DynamicArtEntry)this.game.pEngine.getTile(this.kSMKTile);
            pic.copyData(this.smkfil.getVideoBuffer().array());
            this.rebuild = false;
        }
        this.DrawMenu();
        this.game.pEngine.nextpage(delta);
    }

    private void keyhandler(int keyCode) {
        int mission = this.skip();
        if (mission != -1) {
            return;
        }
        if (this.message == MessageType.EXIT) {
            if (keyCode == 53 || keyCode == 96) {
                this.game.changeScreen(new CreditsScreen());
            }
            if (keyCode == 42 || keyCode == 111 || keyCode == 108) {
                this.resetStatus();
            }
            return;
        }
        if (this.delayclock > 0.0f) {
            return;
        }
        this.helpclock += Gdx.graphics.getDeltaTime();
        if (this.helpclock > 8.0f && this.message != MessageType.HELP) {
            this.HelpMessage();
        }
        if (keyCode == 36) {
            this.HelpMessage();
        } else if (keyCode == 111 || keyCode == 108) {
            if (this.message == MessageType.HELP) {
                this.resetStatus();
            } else {
                this.ExitMessage();
            }
        } else if (keyCode == 21 || keyCode == 240) {
            this.message = MessageType.NONE;
            this.keyLeft();
            this.helpclock = 0.0f;
            this.rebuild = true;
        } else if (keyCode == 22 || keyCode == 238) {
            this.message = MessageType.NONE;
            this.keyRight();
            this.helpclock = 0.0f;
            this.rebuild = true;
        } else if (keyCode == 19 || keyCode == 237) {
            this.message = MessageType.NONE;
            this.keyUp();
            this.helpclock = 0.0f;
            this.rebuild = true;
        } else if (keyCode == 20 || keyCode == 239) {
            this.message = MessageType.NONE;
            this.keyDown();
            this.helpclock = 0.0f;
            this.rebuild = true;
        } else if (keyCode == 40) {
            this.loadGame();
            if (this.chooseCallback != null) {
                this.chooseCallback.run();
            }
        } else if (keyCode == 66 || keyCode == 62 || keyCode == 96) {
            this.helpclock = 0.0f;
            this.rebuild = true;
            if (this.chooseCallback != null) {
                this.chooseCallback.run();
            }
        }
    }

    @Override
    public void processInput(GameProcessor processor) {
        if (this.delayclock > 0.0f) {
            this.delayclock = Gameutils.BClipLow(this.delayclock - Gdx.graphics.getDeltaTime(), 0);
            if (this.delayclock == 0.0f) {
                this.resetStatus();
            }
        }
    }

    protected void DrawFrame(int fn) {
        if (this.smkfil != null && fn < this.smkfil.getFrames()) {
            this.smkfil.setFrame(fn - 1);
        }
    }

    protected void resetStatus() {
        this.helpclock = 0.0f;
        this.message = MessageType.NONE;
        this.rebuild = true;
    }

    protected void AccessWarning() {
        Teksnd.playsound(55, 0, 0, 0, 1);
        this.message = MessageType.ACCESS;
        this.delayclock = 1.0f;
        this.rebuild = true;
    }

    protected void HelpMessage() {
        this.message = MessageType.HELP;
        Teksnd.playsound(110, 0, 0, 0, 1);
        this.rebuild = true;
    }

    protected void ExitMessage() {
        this.message = MessageType.EXIT;
        Teksnd.playsound(110, 0, 0, 0, 1);
        this.rebuild = true;
    }

    private void init(String name) {
        Entry entry = this.game.cache.getEntry(name, true);
        if (!entry.exists()) {
            return;
        }
        ByteBuffer bb = ByteBuffer.wrap(entry.getBytes());
        bb.order(ByteOrder.LITTLE_ENDIAN);
        try {
            this.smkfil = new SMKFile(bb);
        }
        catch (Exception e) {
            return;
        }
        this.smkfil.setEnable(SMKFile.Track.All, SMKFile.Track.Video.mask());
        ArtEntry dst = Main.engine.getTile(this.kSMKTile);
        if (!(dst instanceof DynamicArtEntry && dst.exists() && dst.getWidth() == this.smkfil.getHeight() && dst.getHeight() == this.smkfil.getWidth() || (dst = Main.engine.allocatepermanenttile(this.kSMKTile, this.smkfil.getHeight(), this.smkfil.getWidth())).exists())) {
            this.skip();
            return;
        }
        ((DynamicArtEntry)dst).clearData();
    }

    private void DrawMenu() {
        TekRenderer renderer = this.game.getRenderer();
        renderer.clearview(0);
        if (this.smkfil == null) {
            return;
        }
        int xdim = renderer.getWidth();
        int ydim = renderer.getHeight();
        renderer.setview(0, 0, xdim - 1, ydim - 1);
        ArtEntry pic = this.game.pEngine.getTile(406);
        if (pic.exists() && pic.getWidth() != 0) {
            int frames = xdim / pic.getWidth();
            int x = 160;
            for (int i = 0; i <= frames; ++i) {
                renderer.rotatesprite(x << 16, 0x640000, 65536, 0, 406, 0, 0, 266, 0, 0, xdim - 1, ydim - 1);
                x += pic.getWidth();
            }
        }
        pic = this.game.pEngine.getTile(this.kSMKTile);
        renderer.rotatesprite(xdim << 15, ydim << 15, Pragmas.divscale(ydim, pic.getWidth(), 16), 512, this.kSMKTile, 0, 0, 12);
        this.game.menu.mDrawMouse(Gdx.input.getX(), Gdx.input.getY());
    }

    @Override
    public boolean keyDown(int keycode) {
        this.keyhandler(keycode);
        return false;
    }

    protected static enum MessageType {
        NONE(-1),
        EXIT(1),
        ACCESS(2),
        HELP(3);

        private int num;

        private MessageType(int num) {
            this.num = num;
        }

        public int get() {
            return this.num;
        }

        public void set(int num) {
            this.num = num;
        }
    }
}

