/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Tekwar;

import java.util.Arrays;
import ru.m210projects.Build.Board;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Types.BuildPos;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Tekwar.Animate;
import ru.m210projects.Tekwar.Factory.TekRenderer;
import ru.m210projects.Tekwar.Globals;
import ru.m210projects.Tekwar.Main;
import ru.m210projects.Tekwar.Player;
import ru.m210projects.Tekwar.Tekchng;
import ru.m210projects.Tekwar.Tekgun;
import ru.m210projects.Tekwar.Tekmap;
import ru.m210projects.Tekwar.Tekstat;
import ru.m210projects.Tekwar.Tektag;
import ru.m210projects.Tekwar.Types.SpriteXT;
import ru.m210projects.Tekwar.Types.Startspottype;
import ru.m210projects.Tekwar.View;

public class Tekprep {
    public static final int MAXSTARTSPOTS = 16;
    public static final SpriteXT[] spriteXT = new SpriteXT[Engine.MAXSPRITES];
    public static int startx;
    public static int starty;
    public static int startz;
    public static int starta;
    public static int starts;
    public static final int[] subwaysound;
    static int firsttimethru;
    static int switchlevelsflag;
    static int startspotcnt;
    static final Startspottype[] startspot;
    static final short[] dieframe;
    static final boolean RESETSCORE = false;

    public static void tekpreinit() {
        Main.game.getCache().getEntry("lookup.dat", true).load(is -> {
            int num_tables = StreamUtils.readUnsignedByte(is);
            for (int j = 0; j < num_tables; ++j) {
                int lookup_num = StreamUtils.readUnsignedByte(is);
                Main.engine.getPaletteManager().makePalookup(lookup_num, StreamUtils.readBytes(is, 256), 0, 0, 0, 1);
            }
        });
        if (Main.game.nNetMode == BuildGame.NetMode.Multiplayer) {
            Main.game.getCache().getEntry("nlookup.dat", true).load(is -> {
                int num_tables = StreamUtils.readUnsignedByte(is);
                for (int j = 0; j < num_tables; ++j) {
                    int lookup_num = StreamUtils.readUnsignedByte(is);
                    Main.engine.getPaletteManager().makePalookup(lookup_num, StreamUtils.readBytes(is, 256), 0, 0, 0, 1);
                }
            });
        }
        Engine.pskyoff[0] = 0;
        Engine.pskyoff[1] = 1;
        Engine.pskyoff[2] = 2;
        Engine.pskyoff[3] = 3;
        Engine.pskybits = (short)2;
        Engine.parallaxtype = 1;
        TekRenderer renderer = Main.game.getRenderer();
        renderer.setParallaxOffset(112);
        if (Main.game.nNetMode == BuildGame.NetMode.Multiplayer) {
            Globals.gDifficulty = 2;
        }
    }

    public static void initplayersprite(short snum) {
        if (Player.gPlayer[snum].playersprite >= 0) {
            return;
        }
        int i = Tekstat.jsinsertsprite(Player.gPlayer[snum].cursectnum, 8);
        Sprite spr2 = Main.boardService.getSprite(i);
        if (spr2 == null) {
            Console.out.println("initplayersprite: jsinsertsprite on player " + snum + " failed", OsdColor.RED);
            return;
        }
        Player.gPlayer[snum].playersprite = (short)i;
        spr2.setX(Player.gPlayer[snum].posx);
        spr2.setY(Player.gPlayer[snum].posy);
        spr2.setZ(Player.gPlayer[snum].posz + (Globals.KENSPLAYERHEIGHT << 8));
        spr2.setCstat(257);
        spr2.setShade(0);
        if (Main.game.nNetMode != BuildGame.NetMode.Multiplayer) {
            spr2.setPal(0);
        } else {
            spr2.setPal((byte)(snum + 16));
        }
        spr2.setClipdist(32);
        spr2.setXrepeat(24);
        spr2.setYrepeat(24);
        spr2.setXoffset(0);
        spr2.setYoffset(0);
        spr2.setPicnum(999);
        spr2.setAng((short)Player.gPlayer[snum].ang);
        spr2.setXvel(0);
        spr2.setYvel(0);
        spr2.setZvel(0);
        spr2.setOwner((short)(snum + 4096));
        spr2.setSectnum(Player.gPlayer[snum].cursectnum);
        spr2.setStatnum(8);
        spr2.setLotag(0);
        spr2.setHitag(0);
        spr2.setExtra(-1);
        Player.gPlayer[snum].pInput.reset();
        Tekprep.tekrestoreplayer(snum);
    }

    public static void tekrestoreplayer(short snum) {
        View.resetEffects();
        Main.engine.setsprite(Player.gPlayer[snum].playersprite, Player.gPlayer[snum].posx, Player.gPlayer[snum].posy, Player.gPlayer[snum].posz + (Globals.KENSPLAYERHEIGHT << 8));
        Sprite spr = Main.boardService.getSprite(Player.gPlayer[snum].playersprite);
        if (spr == null) {
            return;
        }
        spr.setAng((int)Player.gPlayer[snum].ang);
        spr.setXrepeat(24);
        spr.setYrepeat(24);
        Player.gPlayer[snum].horiz = 100.0f;
        Player.gPlayer[snum].health = 1000;
        Player.gPlayer[snum].fireseq = 0;
        Tekgun.restockammo(snum);
        Tekchng.stun[snum] = 1000;
        Tekchng.fallz[snum] = 0;
        Player.gPlayer[snum].drawweap = 0;
        Player.gPlayer[snum].invredcards = 0;
        Player.gPlayer[snum].invbluecards = 0;
        Player.gPlayer[snum].invaccutrak = 0;
        Tekprep.dieframe[snum] = 0;
        if (Main.game.nNetMode == BuildGame.NetMode.Multiplayer) {
            Player.gPlayer[snum].weapons = 0;
            Player.gPlayer[snum].weapons = Tektag.flags32[2] | Tektag.flags32[3];
        } else {
            Player.gPlayer[snum].weapons = 0;
            Player.gPlayer[snum].weapons = Main.TEKDEMO ? Tektag.flags32[1] | Tektag.flags32[2] : Tektag.flags32[1] | Tektag.flags32[2] | Tektag.flags32[3];
        }
    }

    public static boolean prepareboard(Entry daboardfilename) {
        try {
            Sector sec;
            Wall wal;
            int i;
            Board board = Main.engine.loadboard(daboardfilename);
            BuildPos out = board.getPos();
            startx = out.x;
            starty = out.y;
            startz = out.z;
            starta = out.ang;
            starts = out.sectnum;
            Main.boardfilename = daboardfilename;
            Tekstat.initsprites();
            if (firsttimethru != 0) {
                Main.engine.srand(17);
            }
            Animate.gAnimationCount = 0;
            View.gViewMode = (byte)3;
            View.zoom = 768;
            for (i = 0; i < 16; ++i) {
                Player.gPlayer[i].posx = startx;
                Player.gPlayer[i].posy = starty;
                Player.gPlayer[i].posz = startz;
                Player.gPlayer[i].ang = starta;
                Player.gPlayer[i].cursectnum = (short)starts;
                Player.gPlayer[i].ocursectnum = (short)starts;
                Player.gPlayer[i].horiz = 100.0f;
                Player.gPlayer[i].lastchaingun = 0;
                Player.gPlayer[i].health = 100;
                Player.gPlayer[i].numbombs = (short)-1;
                Player.gPlayer[i].deaths = 0;
                Player.gPlayer[i].playersprite = (short)-1;
                Player.gPlayer[i].saywatchit = -1;
            }
            if (firsttimethru != 0) {
                for (i = 0; i < 16; ++i) {
                    Player.gPlayer[i].pInput.reset();
                }
            }
            for (i = 0; i < 16; ++i) {
                Tektag.waterfountainwall[i] = -1;
                Tektag.waterfountaincnt[i] = 0;
                Tektag.slimesoundcnt[i] = 0;
            }
            for (i = 0; i < 16; ++i) {
                Player.gPlayer[i].updategun = 1;
            }
            Tektag.warpsectorcnt = 0;
            Tektag.xpanningsectorcnt = 0;
            Tektag.floorpanningcnt = 0;
            Tektag.dragsectorcnt = 0;
            Tektag.swingcnt = 0;
            Tektag.revolvecnt = 0;
            Tektag.subwaytrackcnt = 0;
            for (i = 0; i < 4; ++i) {
                Tekprep.subwaysound[i] = -1;
            }
            block18: for (i = 0; i < Main.boardService.getSectorCount(); ++i) {
                Sector sec2 = Main.boardService.getSector(i);
                if (sec2 == null || sec2.getWallNode() == null) continue;
                Wall firstwall = sec2.getWallNode().get();
                switch (sec2.getLotag()) {
                    case 4: {
                        if (Tektag.floorpanningcnt >= 64) continue block18;
                        short s = Tektag.floorpanningcnt;
                        Tektag.floorpanningcnt = (short)(s + 1);
                        Tektag.floorpanninglist[s] = (short)i;
                        continue block18;
                    }
                    case 5060: {
                        if (Main.game.nNetMode != BuildGame.NetMode.Multiplayer) continue block18;
                        sec2.setLotag(0);
                        continue block18;
                    }
                    case 25: {
                        if (Tekmap.singlemapmode == '\u0000' && Tekmap.generalplay == '\u0000' && Main.game.nNetMode != BuildGame.NetMode.Multiplayer) continue block18;
                        sec2.setLotag(0);
                        continue block18;
                    }
                    case 10: {
                        if (Tekmap.generalplay != '\u0000' || Main.game.nNetMode == BuildGame.NetMode.Multiplayer || Tektag.warpsectorcnt >= 64) continue block18;
                        short s = Tektag.warpsectorcnt;
                        Tektag.warpsectorcnt = (short)(s + 1);
                        Tektag.warpsectorlist[s] = (short)i;
                        continue block18;
                    }
                    case 11: {
                        short s = Tektag.xpanningsectorcnt;
                        Tektag.xpanningsectorcnt = (short)(s + 1);
                        Tektag.xpanningsectorlist[s] = (short)i;
                        continue block18;
                    }
                    case 12: {
                        Sector nextSec;
                        Wall wall3;
                        ListNode<Wall> wn3;
                        int dax = Integer.MAX_VALUE;
                        int day = Integer.MAX_VALUE;
                        int dax2 = Integer.MIN_VALUE;
                        int day2 = Integer.MIN_VALUE;
                        Wall kwall = null;
                        for (wn3 = sec2.getWallNode(); wn3 != null; wn3 = wn3.getNext()) {
                            wall3 = wn3.get();
                            if (wall3.getX() < dax) {
                                dax = wall3.getX();
                            }
                            if (wall3.getY() < day) {
                                day = wall3.getY();
                            }
                            if (wall3.getX() > dax2) {
                                dax2 = wall3.getX();
                            }
                            if (wall3.getY() > day2) {
                                day2 = wall3.getY();
                            }
                            if (wall3.getLotag() != 3) continue;
                            kwall = wall3;
                        }
                        if (kwall != null) {
                            if (kwall.getX() == dax) {
                                Tektag.dragxdir[Tektag.dragsectorcnt] = -16;
                            }
                            if (kwall.getY() == day) {
                                Tektag.dragydir[Tektag.dragsectorcnt] = -16;
                            }
                            if (kwall.getX() == dax2) {
                                Tektag.dragxdir[Tektag.dragsectorcnt] = 16;
                            }
                            if (kwall.getY() == day2) {
                                Tektag.dragydir[Tektag.dragsectorcnt] = 16;
                            }
                        }
                        if ((nextSec = Main.boardService.getSector(firstwall.getNextsector())) == null) continue block18;
                        Tektag.dragx1[Tektag.dragsectorcnt] = Integer.MAX_VALUE;
                        Tektag.dragy1[Tektag.dragsectorcnt] = Integer.MAX_VALUE;
                        Tektag.dragx2[Tektag.dragsectorcnt] = Integer.MIN_VALUE;
                        Tektag.dragy2[Tektag.dragsectorcnt] = Integer.MIN_VALUE;
                        for (ListNode<Wall> wn2 = nextSec.getWallNode(); wn2 != null; wn2 = wn2.getNext()) {
                            Wall wall2 = wn2.get();
                            if (wall2.getX() < Tektag.dragx1[Tektag.dragsectorcnt]) {
                                Tektag.dragx1[Tektag.dragsectorcnt] = wall2.getX();
                            }
                            if (wall2.getY() < Tektag.dragy1[Tektag.dragsectorcnt]) {
                                Tektag.dragy1[Tektag.dragsectorcnt] = wall2.getY();
                            }
                            if (wall2.getX() > Tektag.dragx2[Tektag.dragsectorcnt]) {
                                Tektag.dragx2[Tektag.dragsectorcnt] = wall2.getX();
                            }
                            if (wall2.getY() <= Tektag.dragy2[Tektag.dragsectorcnt]) continue;
                            Tektag.dragy2[Tektag.dragsectorcnt] = wall2.getY();
                        }
                        short s = Tektag.dragsectorcnt;
                        Tektag.dragx1[s] = Tektag.dragx1[s] + (firstwall.getX() - dax);
                        short s2 = Tektag.dragsectorcnt;
                        Tektag.dragy1[s2] = Tektag.dragy1[s2] + (firstwall.getY() - day);
                        short s3 = Tektag.dragsectorcnt;
                        Tektag.dragx2[s3] = Tektag.dragx2[s3] - (dax2 - firstwall.getX());
                        short s4 = Tektag.dragsectorcnt;
                        Tektag.dragy2[s4] = Tektag.dragy2[s4] - (day2 - firstwall.getY());
                        Tektag.dragfloorz[Tektag.dragsectorcnt] = sec2.getFloorz();
                        short s5 = Tektag.dragsectorcnt;
                        Tektag.dragsectorcnt = (short)(s5 + 1);
                        Tektag.dragsectorlist[s5] = (short)i;
                        continue block18;
                    }
                    case 13: {
                        for (ListNode<Wall> wn = sec2.getWallNode(); wn != null; wn = wn.getNext()) {
                            Wall wall = wn.get();
                            if (wall.getLotag() != 4) continue;
                            Wall wal4 = wall.getWall2().getWall2().getWall2().getWall2();
                            if (wall.getX() == wal4.getX() && wall.getY() == wal4.getY()) {
                                Tektag.swingwall[Tektag.swingcnt][0] = (short)wn.getIndex();
                                Tektag.swingwall[Tektag.swingcnt][1] = wall.getPoint2();
                                Tektag.swingwall[Tektag.swingcnt][2] = wall.getWall2().getPoint2();
                                Tektag.swingwall[Tektag.swingcnt][3] = wall.getWall2().getWall2().getPoint2();
                                Tektag.swingangopen[Tektag.swingcnt] = 1536;
                                Tektag.swingangclosed[Tektag.swingcnt] = 0;
                                Tektag.swingangopendir[Tektag.swingcnt] = -1;
                            } else {
                                Tektag.swingwall[Tektag.swingcnt][0] = wall.getPoint2();
                                Tektag.swingwall[Tektag.swingcnt][1] = (short)wn.getIndex();
                                Tektag.swingwall[Tektag.swingcnt][2] = (short)Main.engine.lastwall(wn.getIndex());
                                Tektag.swingwall[Tektag.swingcnt][3] = (short)Main.engine.lastwall(Tektag.swingwall[Tektag.swingcnt][2]);
                                Tektag.swingwall[Tektag.swingcnt][4] = (short)Main.engine.lastwall(Tektag.swingwall[Tektag.swingcnt][3]);
                                Tektag.swingangopen[Tektag.swingcnt] = 512;
                                Tektag.swingangclosed[Tektag.swingcnt] = 0;
                                Tektag.swingangopendir[Tektag.swingcnt] = 1;
                            }
                            for (int k = 0; k < 4; ++k) {
                                Wall swingWall = Main.boardService.getWall(Tektag.swingwall[Tektag.swingcnt][k]);
                                if (swingWall == null) continue;
                                Tektag.swingx[Tektag.swingcnt][k] = swingWall.getX();
                                Tektag.swingy[Tektag.swingcnt][k] = swingWall.getY();
                            }
                            Tektag.swingsector[Tektag.swingcnt] = (short)i;
                            Tektag.swingang[Tektag.swingcnt] = Tektag.swingangclosed[Tektag.swingcnt];
                            Tektag.swinganginc[Tektag.swingcnt] = 0;
                            Tektag.swingcnt = (short)(Tektag.swingcnt + 1);
                        }
                        continue block18;
                    }
                    case 14: {
                        Wall wall;
                        ListNode<Wall> wn;
                        Wall wall3;
                        ListNode<Wall> wn3;
                        int dax = 0;
                        int day = 0;
                        short startwall = sec2.getWallptr();
                        short endwall = (short)(startwall + sec2.getWallnum() - 1);
                        for (wn = sec2.getWallNode(); wn != null; wn = wn.getNext()) {
                            wall = wn.get();
                            dax += wall.getX();
                            day += wall.getY();
                        }
                        Tektag.revolvepivotx[Tektag.revolvecnt] = dax / (endwall - startwall + 1);
                        Tektag.revolvepivoty[Tektag.revolvecnt] = day / (endwall - startwall + 1);
                        int k = 0;
                        for (wn3 = sec2.getWallNode(); wn3 != null; wn3 = wn3.getNext()) {
                            wall3 = wn3.get();
                            Tektag.revolvex[Tektag.revolvecnt][k] = wall3.getX();
                            Tektag.revolvey[Tektag.revolvecnt][k] = wall3.getY();
                            ++k;
                        }
                        Tektag.revolvesector[Tektag.revolvecnt] = (short)i;
                        Tektag.revolveang[Tektag.revolvecnt] = 0;
                        Tektag.revolvecnt = (short)(Tektag.revolvecnt + 1);
                        continue block18;
                    }
                    case 15: {
                        int j;
                        Wall wall;
                        ListNode<Wall> wn;
                        Tektag.subwaytracksector[Tektag.subwaytrackcnt][0] = (short)i;
                        Tektag.subwaystopcnt[Tektag.subwaytrackcnt] = 0;
                        int dax = Integer.MAX_VALUE;
                        int day = Integer.MAX_VALUE;
                        int dax2 = Integer.MIN_VALUE;
                        int day2 = Integer.MIN_VALUE;
                        for (wn = sec2.getWallNode(); wn != null; wn = wn.getNext()) {
                            wall = wn.get();
                            if (wall.getX() < dax) {
                                dax = wall.getX();
                            }
                            if (wall.getY() < day) {
                                day = wall.getY();
                            }
                            if (wall.getX() > dax2) {
                                dax2 = wall.getX();
                            }
                            if (wall.getY() <= day2) continue;
                            day2 = wall.getY();
                        }
                        for (wn = sec2.getWallNode(); wn != null; wn = wn.getNext()) {
                            wall = wn.get();
                            if (wall.getLotag() != 5) continue;
                            if (wall.getX() > dax && wall.getY() > day && wall.getX() < dax2 && wall.getY() < day2) {
                                Tektag.subwayx[Tektag.subwaytrackcnt] = wall.getX();
                                continue;
                            }
                            Tektag.subwaystop[Tektag.subwaytrackcnt][Tektag.subwaystopcnt[Tektag.subwaytrackcnt]] = wall.getX();
                            if (Tekmap.accessiblemap(wall.getHitag()) == 0) {
                                Tektag.subwaystop[Tektag.subwaytrackcnt][Tektag.subwaystopcnt[Tektag.subwaytrackcnt]] = 0;
                            }
                            short s = Tektag.subwaytrackcnt;
                            Tektag.subwaystopcnt[s] = Tektag.subwaystopcnt[s] + 1;
                        }
                        for (j = 0; j < Tektag.subwaystopcnt[Tektag.subwaytrackcnt]; ++j) {
                            if (Tektag.subwaystop[Tektag.subwaytrackcnt][j] != 0) continue;
                            for (int l = j + 1; l < Tektag.subwaystopcnt[Tektag.subwaytrackcnt]; ++l) {
                                if (Tektag.subwaystop[Tektag.subwaytrackcnt][l] == 0) continue;
                                Tektag.subwaystop[Tektag.subwaytrackcnt][j] = Tektag.subwaystop[Tektag.subwaytrackcnt][l];
                                Tektag.subwaystop[Tektag.subwaytrackcnt][l] = 0;
                                l = Tektag.subwaystopcnt[Tektag.subwaytrackcnt];
                            }
                        }
                        Tektag.subwaystopcnt[Tektag.subwaytrackcnt] = 0;
                        while (Tektag.subwaystop[Tektag.subwaytrackcnt][Tektag.subwaystopcnt[Tektag.subwaytrackcnt]] != 0) {
                            short s = Tektag.subwaytrackcnt;
                            Tektag.subwaystopcnt[s] = Tektag.subwaystopcnt[s] + 1;
                        }
                        for (j = 1; j < Tektag.subwaystopcnt[Tektag.subwaytrackcnt]; ++j) {
                            for (int k = 0; k < j; ++k) {
                                if (Tektag.subwaystop[Tektag.subwaytrackcnt][j] >= Tektag.subwaystop[Tektag.subwaytrackcnt][k]) continue;
                                int s = Tektag.subwaystop[Tektag.subwaytrackcnt][j];
                                Tektag.subwaystop[Tektag.subwaytrackcnt][j] = Tektag.subwaystop[Tektag.subwaytrackcnt][k];
                                Tektag.subwaystop[Tektag.subwaytrackcnt][k] = s;
                            }
                        }
                        Tektag.subwaygoalstop[Tektag.subwaytrackcnt] = 0;
                        for (j = 0; j < Tektag.subwaystopcnt[Tektag.subwaytrackcnt]; ++j) {
                            if (Math.abs(Tektag.subwaystop[Tektag.subwaytrackcnt][j] - Tektag.subwayx[Tektag.subwaytrackcnt]) >= Math.abs(Tektag.subwaystop[Tektag.subwaytrackcnt][Tektag.subwaygoalstop[Tektag.subwaytrackcnt]] - Tektag.subwayx[Tektag.subwaytrackcnt])) continue;
                            Tektag.subwaygoalstop[Tektag.subwaytrackcnt] = j;
                        }
                        Tektag.subwaytrackx1[Tektag.subwaytrackcnt] = dax;
                        Tektag.subwaytracky1[Tektag.subwaytrackcnt] = day;
                        Tektag.subwaytrackx2[Tektag.subwaytrackcnt] = dax2;
                        Tektag.subwaytracky2[Tektag.subwaytrackcnt] = day2;
                        Tektag.subwaynumsectors[Tektag.subwaytrackcnt] = 1;
                        for (j = 0; j < Main.boardService.getSectorCount(); ++j) {
                            Wall firstwall2;
                            Sector sec22;
                            if (j == i || (sec22 = Main.boardService.getSector(j)) == null || sec22.getWallNode() == null || (firstwall2 = sec22.getWallNode().get()).getX() <= Tektag.subwaytrackx1[Tektag.subwaytrackcnt] || firstwall2.getY() <= Tektag.subwaytracky1[Tektag.subwaytrackcnt] || firstwall2.getX() >= Tektag.subwaytrackx2[Tektag.subwaytrackcnt] || firstwall2.getY() >= Tektag.subwaytracky2[Tektag.subwaytrackcnt]) continue;
                            if (sec22.getLotag() == 16) {
                                sec22.setLotag(17);
                            }
                            if (sec22.getFloorz() != sec2.getFloorz()) {
                                sec22.setCeilingstat(sec22.getCeilingstat() | 0x40);
                                sec22.setFloorstat(sec22.getFloorstat() | 0x40);
                            }
                            Tektag.subwaytracksector[Tektag.subwaytrackcnt][Tektag.subwaynumsectors[Tektag.subwaytrackcnt]] = (short)j;
                            short s = Tektag.subwaytrackcnt;
                            Tektag.subwaynumsectors[s] = (short)(Tektag.subwaynumsectors[s] + 1);
                        }
                        Tektag.subwayvel[Tektag.subwaytrackcnt] = 32;
                        Tektag.subwaypausetime[Tektag.subwaytrackcnt] = 720;
                        Tektag.subwaytrackcnt = (short)(Tektag.subwaytrackcnt + 1);
                    }
                }
            }
            Tektag.ypanningwallcnt = 0;
            for (i = 0; i < Main.boardService.getWallCount(); ++i) {
                wal = Main.boardService.getWall(i);
                if (wal == null || wal.getLotag() != 1) continue;
                short s = Tektag.ypanningwallcnt;
                Tektag.ypanningwallcnt = (short)(s + 1);
                Tektag.ypanningwalllist[s] = (short)i;
            }
            Tektag.rotatespritecnt = 0;
            startspotcnt = 0;
            for (i = 0; i < Engine.MAXSPRITES; ++i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) continue;
                if (spr.getPicnum() == 331) {
                    if (startspotcnt < 16) {
                        if (startspot[startspotcnt] == null) {
                            Tekprep.startspot[Tekprep.startspotcnt] = new Startspottype();
                        }
                        Tekprep.startspot[Tekprep.startspotcnt].x = spr.getX();
                        Tekprep.startspot[Tekprep.startspotcnt].y = spr.getY();
                        Tekprep.startspot[Tekprep.startspotcnt].z = spr.getZ();
                        Tekprep.startspot[Tekprep.startspotcnt].sectnum = spr.getSectnum();
                        ++startspotcnt;
                    }
                    Tekstat.jsdeletesprite((short)i);
                    continue;
                }
                if (spr.getLotag() == 3) {
                    short s = Tektag.rotatespritecnt;
                    Tektag.rotatespritecnt = (short)(s + 1);
                    Tektag.rotatespritelist[s] = (short)i;
                    continue;
                }
                if (Main.game.nNetMode != BuildGame.NetMode.Multiplayer || spr.getLotag() != 1009) continue;
                Tekstat.jsdeletesprite((short)i);
            }
            if (startspotcnt == 0 && Main.game.nNetMode == BuildGame.NetMode.Multiplayer) {
                System.err.println("no net startspots");
            }
            Arrays.fill(Engine.show2dsector.getArray(), (byte)-1);
            Arrays.fill(Engine.show2dwall.getArray(), (byte)-1);
            Engine.automapping = 0;
            for (i = 0; i < Engine.MAXSECTORS; ++i) {
                Sector sec2 = Main.boardService.getSector(i);
                if (sec2 == null || sec2.getLotag() != 9901) continue;
                Engine.show2dsector.clearBit(i);
                for (ListNode<Wall> wn = sec2.getWallNode(); wn != null; wn = wn.getNext()) {
                    Wall wall = wn.get();
                    Engine.show2dwall.clearBit(wn.getIndex());
                    if (wall.getNextwall() == -1) continue;
                    Engine.show2dwall.clearBit(wall.getNextwall());
                }
            }
            for (i = 0; i < Engine.MAXWALLS; ++i) {
                wal = Main.boardService.getWall(i);
                if (wal == null || wal.getLotag() != 9900) continue;
                Engine.show2dwall.clearBit(i);
            }
            if (firsttimethru != 0) {
                Main.lockclock = 0;
            }
            if (Main.game.nNetMode == BuildGame.NetMode.Multiplayer) {
                firsttimethru = 0;
            }
            Tektag.tekpreptags();
            Tekstat.initspriteXTs();
            if (Tekmap.currentmapno == 0 && (sec = Main.boardService.getSector(333)) != null && sec.getLotag() == 5020 && sec.getHitag() == 901) {
                sec.setLotag(0);
                sec.setHitag(0);
            }
            return true;
        }
        catch (Exception e) {
            Console.out.println("Load map exception: " + e);
            if (e.getMessage() != null) {
                Main.game.GameMessage("Load map exception:\n" + e.getMessage());
            } else {
                Main.game.GameMessage("Can't load the map " + daboardfilename);
            }
            return false;
        }
    }

    static {
        subwaysound = new int[4];
        firsttimethru = 1;
        startspot = new Startspottype[16];
        dieframe = new short[16];
    }
}

