/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Tekwar;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import ru.m210projects.Build.Architecture.common.audio.AudioChannel;
import ru.m210projects.Build.Architecture.common.audio.BuildAudio;
import ru.m210projects.Build.Architecture.common.audio.Source;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Script.CueScript;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.grp.GrpEntry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Tekwar.Main;
import ru.m210projects.Tekwar.Player;
import ru.m210projects.Tekwar.Tektag;
import ru.m210projects.Tekwar.Types.HmiEntry;
import ru.m210projects.Tekwar.Types.Songtype;
import ru.m210projects.Tekwar.Types.Soundtype;
import ru.m210projects.Tekwar.Types.TekGroup;

public class Teksnd {
    public static final int MAXSOUNDS = 256;
    public static final int TOTALSOUNDS = 208;
    public static final int AVAILMODES = 3;
    public static final int SONGSPERLEVEL = 3;
    public static final int NUMLEVELS = 7;
    public static final int AMBUPDATEDIST = 4000;
    public static final List<Entry> cdTrackEntries = new ArrayList<Entry>();
    public static TekGroup fhsongs = null;
    public static Songtype songptr;
    public static int totalsongsperlevel;
    public static TekGroup fhsounds;
    public static final ByteBuffer[] pSfx;
    public static final Soundtype[] dsoundptr;
    public static int currTrack;
    public static Entry currSong;
    public static BuildAudio audio;

    public static void searchCDtracks() {
        cdTrackEntries.clear();
        Directory gameDir = Main.game.getCache().getGameDirectory();
        for (Entry file : gameDir) {
            if (!file.isExtension("cue")) continue;
            CueScript cueScript = new CueScript(file.getName(), file);
            for (String track : cueScript.getTracks()) {
                Entry entry = Main.game.getCache().getEntry(track, true);
                if (!entry.exists()) continue;
                cdTrackEntries.add(entry);
            }
            if (cdTrackEntries.isEmpty()) continue;
            break;
        }
        if (cdTrackEntries.isEmpty()) {
            for (Entry file : gameDir) {
                if (!file.isExtension("ogg")) continue;
                cdTrackEntries.add(file);
            }
        }
        if (!cdTrackEntries.isEmpty()) {
            Console.out.println(cdTrackEntries.size() + " cd tracks found...");
        } else {
            Console.out.println("Cd tracks not found.");
        }
    }

    public static void sndInit() {
        Main.tekcfg.setAudioDriver(Main.tekcfg.getAudioDriver());
        Main.tekcfg.setMidiDevice(Main.tekcfg.getMidiDevice());
        audio = Main.tekcfg.getAudio();
        if (fhsongs == null) {
            Teksnd.setupmidi();
        }
        if (fhsounds == null) {
            Teksnd.setupdigi();
        }
    }

    public static Entry getMusicEntry(int index) {
        if (fhsongs != null) {
            return fhsongs.getEntry(index);
        }
        return Directory.DUMMY_ENTRY;
    }

    public static Entry getSoundEntry(int index) {
        if (fhsounds != null) {
            return fhsounds.getEntry(index);
        }
        return Directory.DUMMY_ENTRY;
    }

    public static void sndHandlePause(boolean gPaused) {
        if (gPaused) {
            if (Teksnd.songptr.handle != null) {
                Teksnd.songptr.handle.pause();
            }
            Teksnd.stopallsounds();
        } else if (!Main.tekcfg.isMuteMusic() && Teksnd.songptr.handle != null) {
            Teksnd.songptr.handle.play();
        }
    }

    public static void sndStopMusic() {
        if (Teksnd.songptr.handle != null) {
            Teksnd.songptr.handle.stop();
            Teksnd.songptr.handle = null;
        }
        currTrack = -1;
        currSong = Directory.DUMMY_ENTRY;
    }

    public static void setupmidi() {
        Entry songsEntry = Main.game.getCache().getEntry("SONGS", true);
        try {
            fhsongs = new TekGroup("SONGS", songsEntry::getInputStream, HmiEntry.class);
        }
        catch (IOException e) {
            Console.out.println("setupmidi: cant open songs", OsdColor.RED);
        }
        songptr = new Songtype();
        totalsongsperlevel = 9;
    }

    public static void menusong(int insubway) {
        int index = 63;
        if (insubway != 0) {
            index = 66;
        }
        Teksnd.songptr.entry = Teksnd.getMusicEntry(index += 2);
        Teksnd.playsong();
    }

    public static boolean playCDtrack(int nTrack) {
        Music newHandle;
        if (Main.game.isCurrentScreen(Main.gMissionScreen) || Main.tekcfg.getMusicType() == 0 || nTrack < 0) {
            return false;
        }
        nTrack = Gameutils.BClipRange(nTrack, 1, cdTrackEntries.size());
        if (Teksnd.songptr.handle != null && Teksnd.songptr.handle.isPlaying() && currTrack == nTrack) {
            return true;
        }
        if (cdTrackEntries.get(nTrack - 1) != null && (newHandle = Teksnd.newMusic(cdTrackEntries.get(nTrack - 1))) != null) {
            Teksnd.sndStopMusic();
            Teksnd.songptr.handle = newHandle;
            currTrack = nTrack;
            newHandle.setLooping(true);
            newHandle.play();
            return true;
        }
        return false;
    }

    private static Music newMusic(Entry entry) {
        return audio.newMusic(entry);
    }

    public static void startmusic(int level) {
        if (level > 6) {
            return;
        }
        int index = totalsongsperlevel * level;
        Teksnd.songptr.entry = Teksnd.getMusicEntry(index);
        Teksnd.playsong();
    }

    public static void playsong() {
        if (Main.tekcfg.isMuteMusic()) {
            return;
        }
        if (!cdTrackEntries.isEmpty() && Teksnd.playCDtrack((int)(Math.random() * (double)cdTrackEntries.size()))) {
            return;
        }
        if (!Teksnd.songptr.entry.exists()) {
            return;
        }
        if (currSong.equals(Teksnd.songptr.entry)) {
            return;
        }
        Teksnd.sndStopMusic();
        Teksnd.songptr.handle = Teksnd.newMusic(Teksnd.songptr.entry);
        if (Teksnd.songptr.handle != null) {
            currSong = Teksnd.songptr.entry;
            Teksnd.songptr.handle.setLooping(true);
            Teksnd.songptr.handle.play();
        }
    }

    public static void setupdigi() {
        Entry soundsEntry = Main.game.getCache().getEntry("sounds", true);
        try {
            fhsounds = new TekGroup("sounds", soundsEntry::getInputStream, GrpEntry.class);
        }
        catch (IOException e) {
            Console.out.println("setupdigi: cant open sounds", OsdColor.RED);
        }
        for (int i = 0; i < 256; ++i) {
            Teksnd.dsoundptr[i] = new Soundtype();
            Teksnd.dsoundptr[i].type = (short)2;
            Teksnd.dsoundptr[i].sndnum = -1;
        }
    }

    public static void updatesounds(int snum) {
        if (Main.tekcfg.isNoSound()) {
            return;
        }
        audio.setListener(Player.gPlayer[snum].posx, Player.gPlayer[snum].posz >> 4, Player.gPlayer[snum].posy, (int)Player.gPlayer[snum].ang);
        for (int i = 0; i < 256; ++i) {
            if (Teksnd.dsoundptr[i].hVoice == null || (Teksnd.dsoundptr[i].type & 0x85) != 0) continue;
            if (Teksnd.dsoundptr[i].loop > 0.0f) {
                Teksnd.dsoundptr[i].loop -= Gdx.graphics.getDeltaTime();
                if (Teksnd.dsoundptr[i].loop <= 0.0f) {
                    Teksnd.stopsound(i);
                    return;
                }
            }
            int dist = Math.abs(Player.gPlayer[snum].posx - Teksnd.dsoundptr[i].x) + Math.abs(Player.gPlayer[snum].posy - Teksnd.dsoundptr[i].y);
            int vol = 39000 - (dist << 2);
            if (Teksnd.dsoundptr[i].type == 96) {
                vol = dist < 4000 ? 32000 - (dist << 3) : 0;
            } else if (dist < 1500) {
                vol = Short.MAX_VALUE;
            } else if (dist > 8500) {
                vol = 7936;
            }
            vol = Gameutils.BClipRange((int)((float)vol / 32767.0f * 255.0f), 0, 255);
            Teksnd.dsoundptr[i].hVoice.setVolume((float)vol / 255.0f);
        }
    }

    public static int playsound(int sn, int sndx, int sndy, int loop, int type) {
        int i;
        if (Main.tekcfg.isNoSound() || sn < 0 || sn >= 208) {
            return -1;
        }
        for (i = 0; i < 256; ++i) {
            if (Teksnd.dsoundptr[i].hVoice == null || Teksnd.dsoundptr[i].hVoice.isActive()) continue;
            Teksnd.stopsound(i);
        }
        if ((type & 0x168) != 0) {
            for (i = 0; i < 256; ++i) {
                if (Teksnd.dsoundptr[i].hVoice == null || Teksnd.dsoundptr[i].hVoice != null && !Teksnd.dsoundptr[i].hVoice.isActive() || Teksnd.dsoundptr[i].sndnum != sn) continue;
                if ((type & 0x100) != 0) {
                    Teksnd.stopsound(i);
                }
                return -1;
            }
        }
        int sound = 0;
        while (Teksnd.dsoundptr[sound].hVoice != null && Teksnd.dsoundptr[sound].hVoice.isActive()) {
            if (++sound != 256) continue;
            return -1;
        }
        Teksnd.dsoundptr[sound].type = (short)type;
        Teksnd.dsoundptr[sound].x = sndx;
        Teksnd.dsoundptr[sound].y = sndy;
        if (pSfx[sn] == null) {
            Entry entry = Teksnd.getSoundEntry(sn);
            if (!entry.exists()) {
                Console.out.println("playsound: bad read of digilist", OsdColor.RED);
            }
            ByteBuffer buf = ByteBuffer.allocateDirect((int)entry.getSize());
            buf.order(ByteOrder.LITTLE_ENDIAN);
            buf.put(entry.getBytes());
            Teksnd.pSfx[sn] = buf;
        }
        pSfx[sn].rewind();
        int vol = Short.MAX_VALUE;
        if ((type & 1) == 0) {
            int dist = Math.abs(Player.gPlayer[Main.screenpeek].posx - sndx) + Math.abs(Player.gPlayer[Main.screenpeek].posy - sndy);
            if ((type & 0x60) != 0 || (type & 0x80) != 0) {
                vol = dist < 4000 ? 32000 - (dist << 3) : 0;
            } else if ((type & 1) == 0) {
                vol = 39000 - (dist << 2);
                if (dist < 1500) {
                    vol = Short.MAX_VALUE;
                } else if (dist > 8500) {
                    vol = sn >= 151 ? 0 : 7936;
                }
            }
        }
        vol = Gameutils.BClipRange((int)((float)vol / 32767.0f * 255.0f), 1, 255);
        Teksnd.dsoundptr[sound].loop = loop;
        Teksnd.dsoundptr[sound].hVoice = loop != 0 || (type & 0x60) != 0 || (type & 0x80) != 0 ? Teksnd.newSound(pSfx[sn], 11025, 8, 255) : Teksnd.newSound(pSfx[sn], 11025, 8, 80 * (vol + 1));
        if (Teksnd.dsoundptr[sound].hVoice != null) {
            if ((type & 1) == 0) {
                Teksnd.dsoundptr[sound].hVoice.setPosition(sndx, 0, sndy);
            }
            if (loop != 0) {
                Teksnd.dsoundptr[sound].hVoice.loop((float)vol / 255.0f);
            } else {
                Teksnd.dsoundptr[sound].hVoice.play((float)vol / 255.0f);
            }
        }
        Teksnd.dsoundptr[sound].sndnum = sn;
        return sound;
    }

    public static Source newSound(ByteBuffer buffer, int rate, int bits, int priority) {
        return (Source)audio.newSound(buffer, rate, bits, priority);
    }

    public static Source newSound(ByteBuffer buffer, int rate, int bits, int channel, int priority) {
        return (Source)audio.newSound(buffer, rate, bits, AudioChannel.parseChannel(channel), priority);
    }

    public static void stopallsounds() {
        for (int i = 0; i < 256; ++i) {
            Teksnd.stopsound(i);
        }
        audio.stopAllSounds();
        Tektag.loopinsound = -1;
        Tektag.baydoorloop = -1;
        Tektag.ambsubloop = -1;
    }

    public static void stopsound(int i) {
        if (Teksnd.dsoundptr[i].hVoice == null || i >= 208) {
            return;
        }
        if (Teksnd.dsoundptr[i].loop != 0.0f) {
            Teksnd.dsoundptr[i].loop = 0.0f;
        }
        Teksnd.dsoundptr[i].hVoice.stop();
        Teksnd.dsoundptr[i].hVoice = null;
        Teksnd.dsoundptr[i].type = (short)2;
        Teksnd.dsoundptr[i].sndnum = -1;
    }

    public static void updatevehiclesnds(int i, int sndx, int sndy) {
        if (i < 0 || i > 208) {
            return;
        }
        Teksnd.dsoundptr[i].x = sndx;
        Teksnd.dsoundptr[i].y = sndy;
        int dist = Math.abs(Player.gPlayer[Main.screenpeek].posx - sndx) + Math.abs(Player.gPlayer[Main.screenpeek].posy - sndy);
        int vol = Short.MAX_VALUE - (dist << 2);
        if (dist < 1000) {
            vol = Short.MAX_VALUE;
        } else if (dist > 9000) {
            vol = 0;
        }
        vol = Gameutils.BClipRange((int)((float)vol / 32767.0f * 255.0f), 0, 255);
        if (Teksnd.dsoundptr[i].hVoice != null) {
            Teksnd.dsoundptr[i].hVoice.setPosition(sndx, 0, sndy);
            Teksnd.dsoundptr[i].hVoice.setVolume((float)vol / 255.0f);
        }
    }

    static {
        fhsounds = null;
        pSfx = new ByteBuffer[208];
        dsoundptr = new Soundtype[256];
        currTrack = -1;
        currSong = Directory.DUMMY_ENTRY;
    }
}

