/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Tekwar;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Tekwar.Globals;
import ru.m210projects.Tekwar.Main;
import ru.m210projects.Tekwar.Player;
import ru.m210projects.Tekwar.Tekchng;
import ru.m210projects.Tekwar.Tekgun;
import ru.m210projects.Tekwar.Tekmap;
import ru.m210projects.Tekwar.Tekprep;
import ru.m210projects.Tekwar.Teksnd;
import ru.m210projects.Tekwar.Tekspr;
import ru.m210projects.Tekwar.Tektag;
import ru.m210projects.Tekwar.View;

public class Tekstat {
    public static final int MAXFRAMES = 8;
    public static final boolean NOSHOWSPRITES = false;
    public static final int SPR_LOTAG_SPAWNCHASE = 2000;
    public static final int SPR_LOTAG_MORPH = 2003;
    public static final int SPR_LOTAG_PICKUP = 2004;
    public static final int SECT_LOTAG_TRIGGERSPRITE = 5020;
    public static final int SECT_LOTAG_SHOWMESSAGE = 5030;
    public static final int SECT_LOTAG_NOSTANDING = 5040;
    public static final int SECT_LOTAG_OFFLIMITS_CIVILLIAN = 5050;
    public static final int SECT_LOTAG_OFFLIMITS_ALL = 5055;
    public static final int SECT_LOTAG_CLIMB = 5060;
    public static final int DONTBOTHERDISTANCE = 20480;
    public static final int HEARGUNSHOTDIST = 10240;
    public static final short INANIMATE = 0;
    public static final short PLAYER = 8;
    public static final short INACTIVE = 100;
    public static final short STANDING = 201;
    public static final short AMBUSH = 202;
    public static final short GUARD = 203;
    public static final short STALK = 204;
    public static final short FLEE = 205;
    public static final short CHASE = 206;
    public static final short PATROL = 207;
    public static final short STROLL = 209;
    public static final short VIRUS = 250;
    public static final short PLRVIRUS = 255;
    public static final short ATTACK = 300;
    public static final short DEATH = 301;
    public static final short PAIN = 302;
    public static final short TWITCH = 303;
    public static final short MORPH = 304;
    public static final short SQUAT = 305;
    public static final short UNSQUAT = 306;
    public static final short DODGE = 309;
    public static final short UNDODGE = 310;
    public static final short HIDE = 311;
    public static final short UNHIDE = 312;
    public static final short DELAYEDATTACK = 313;
    public static final short MIRRORMAN1 = 320;
    public static final short MIRRORMAN2 = 321;
    public static final short FLOATING = 322;
    public static final short PROJHIT = 400;
    public static final short PROJECTILE = 401;
    public static final short TOSS = 402;
    public static final short PINBALL = 403;
    public static final short DROPSIES = 406;
    public static final short RUNTHRU = 407;
    public static final short BLOODFLOW = 408;
    public static final short FLY = 500;
    public static final short RODENT = 502;
    public static final short TIMEBOMB = 602;
    public static final short STACKED = 610;
    public static final short FALL = 611;
    public static final short GENEXPLODE1 = 800;
    public static final short GENEXPLODE2 = 801;
    public static final short VANISH = 999;
    public static final int BOMBPROJECTILESTAT = 714;
    public static final int BOMBPROJECTILESTAT2 = 716;
    public static final int ENEMYCRITICALCONDITION = 25;
    public static final int AI_JUSTSHOTAT = 4;
    public static final int AI_CRITICAL = 8;
    public static final int AI_WASDRAWN = 16;
    public static final int AI_WASATTACKED = 32;
    public static final int AI_GAVEWARNING = 64;
    public static final int AI_ENCROACHMENT = 128;
    public static final int AI_DIDFLEESCREAM = 256;
    public static final int AI_DIDAMBUSHYELL = 512;
    public static final int AI_DIDHIDEPLEA = 1024;
    public static final int AI_TIMETODODGE = 2048;
    public static final int FX_HASREDCARD = 1;
    public static final int FX_HASBLUECARD = 2;
    public static final int FX_ANDROID = 4;
    public static final int FX_HOLOGRAM = 8;
    public static final int FX_NXTSTTPAIN = 32;
    public static final int FX_NXTSTTDEATH = 64;
    public static final int NO_PIC = 0;
    public static final int NORMALCLIP = 0;
    public static final int PROJECTILECLIP = 1;
    public static final int CLIFFCLIP = 2;
    public static final int MINATTACKDIST = 8192;
    public static final int CHASEATTDIST = 8192;
    public static final int GUARDATTDIST = 6144;
    public static final int STALKATTDIST = 8192;
    public static final int MAXBOBS = 32;
    public static final int HIDEDISTANCE = 4096;
    public static sectflashtype sectflash;
    public static Sprite pickup;
    public static int vadd;
    public static char ensfirsttime;
    public static int stackedcheck;
    public static int playerhit;
    static final int[] bobbing;
    static final short[] leftof;
    static final short[] rightof;

    public static int jsinsertsprite(int sect, int stat) {
        int j = Main.engine.insertsprite(sect, stat);
        Sprite spr = Main.boardService.getSprite(j);
        if (spr != null) {
            spr.setX(0);
            spr.setY(0);
            spr.setZ(0);
            spr.setCstat(0);
            spr.setShade(0);
            spr.setPal(0);
            spr.setClipdist(32);
            spr.setXrepeat(0);
            spr.setYrepeat(0);
            spr.setXoffset(0);
            spr.setYoffset(0);
            spr.setPicnum(0);
            spr.setAng(0);
            spr.setXvel(0);
            spr.setYvel(0);
            spr.setZvel(0);
            spr.setOwner(-1);
            spr.setLotag(0);
            spr.setHitag(0);
            spr.setExtra(-1);
        }
        return j;
    }

    public static void initsprites() {
        if (sectflash == null) {
            sectflash = new sectflashtype();
        }
        Tekstat.sectflash.sectnum = 0;
        Tekstat.sectflash.ovis = '\u0000';
        Tekstat.sectflash.step = 0;
    }

    public static void jsdeletesprite(int spritenum) {
        Sprite spr = Main.boardService.getSprite(spritenum);
        if (spr == null) {
            return;
        }
        short ext = spr.getExtra();
        if (Tekstat.validext(ext) != 0) {
            Tekprep.spriteXT[ext].set(0);
            Tekprep.spriteXT[ext].lock = '\u0000';
        }
        Main.engine.deletesprite(spritenum);
        spr.setExtra(-1);
    }

    public static int validext(int ext) {
        if (ext >= 0 && ext < Engine.MAXSPRITES) {
            return 1;
        }
        return 0;
    }

    public static void toss(short snum) {
        if (!Tekgun.validplayer(snum)) {
            throw new AssertException("toss: bad plrnum");
        }
        if (pickup.getPicnum() == 0) {
            return;
        }
        int j = Tekstat.jsinsertsprite(Player.gPlayer[snum].cursectnum, 402);
        Sprite spr2 = Main.boardService.getSprite(j);
        if (spr2 != null) {
            if (Player.gPlayer[snum].drawweap == 0) {
                spr2.setX((int)((double)Player.gPlayer[snum].posx + Gameutils.BCosAngle(Player.gPlayer[snum].ang + 2048.0f + 256.0f) / 64.0));
                spr2.setY((int)((double)Player.gPlayer[snum].posy + Gameutils.BSinAngle(Player.gPlayer[snum].ang + 2048.0f + 256.0f) / 64.0));
            } else {
                spr2.setX((int)((double)Player.gPlayer[snum].posx - Gameutils.BCosAngle(Player.gPlayer[snum].ang + 2048.0f + 256.0f) / 64.0));
                spr2.setY((int)((double)Player.gPlayer[snum].posy - Gameutils.BSinAngle(Player.gPlayer[snum].ang + 2048.0f + 256.0f) / 64.0));
            }
            spr2.setZ(Player.gPlayer[snum].posz + 1024);
            spr2.setCstat(pickup.getCstat());
            spr2.setShade(pickup.getShade());
            spr2.setPal(pickup.getPal());
            spr2.setClipdist(pickup.getClipdist());
            spr2.setXrepeat(pickup.getXrepeat());
            spr2.setYrepeat(pickup.getYrepeat());
            spr2.setXoffset(pickup.getXoffset());
            spr2.setYoffset(pickup.getYoffset());
            spr2.setAng((short)Player.gPlayer[snum].ang);
            switch (pickup.getPicnum()) {
                case 260: {
                    spr2.setPicnum(299);
                    break;
                }
                case 467: {
                    spr2.setPicnum(466);
                    break;
                }
                case 470: {
                    spr2.setPicnum(469);
                    break;
                }
                default: {
                    spr2.setPicnum(pickup.getPicnum());
                }
            }
            spr2.setXvel((short)(Gameutils.BCosAngle(Player.gPlayer[snum].ang + 2048.0f + 256.0f) / 64.0));
            spr2.setYvel((short)(Gameutils.BSinAngle(Player.gPlayer[snum].ang + 2048.0f + 256.0f) / 64.0));
            spr2.setZvel((short)(80 - (int)Player.gPlayer[snum].horiz << 6));
            spr2.setOwner((short)(snum + 4096));
            spr2.setSectnum(Player.gPlayer[snum].cursectnum);
            spr2.setLotag(0);
            spr2.setHitag(0);
            spr2.setExtra(pickup.getExtra());
        }
        pickup.reset((byte)0);
        pickup.setExtra(-1);
    }

    public static int pickupsprite(int sn) {
        if (pickup.getPicnum() != 0 || Main.game.nNetMode == BuildGame.NetMode.Multiplayer) {
            return 0;
        }
        Sprite spr = Main.boardService.getSprite(sn);
        if (spr == null) {
            return 0;
        }
        pickup.setPicnum(spr.getPicnum());
        pickup.setCstat(spr.getCstat());
        pickup.setShade(spr.getShade());
        pickup.setPal(spr.getPal());
        pickup.setClipdist(spr.getClipdist());
        pickup.setXrepeat(spr.getXrepeat());
        pickup.setYrepeat(spr.getYrepeat());
        pickup.setXoffset(spr.getXoffset());
        pickup.setYoffset(spr.getYoffset());
        pickup.setExtra(spr.getExtra());
        Tekstat.jsdeletesprite((short)sn);
        return 1;
    }

    public static void operatesprite(int dasprite) {
        Sprite spr = Main.boardService.getSprite(dasprite);
        if (spr == null) {
            return;
        }
        if (Main.game.nNetMode != BuildGame.NetMode.Multiplayer && spr.getLotag() == 2004) {
            int pu = Tekstat.pickupsprite(dasprite);
            switch (spr.getPicnum()) {
                case 260: {
                    if (pu == 0) break;
                    View.showmessage("LIVE RAT");
                    break;
                }
                case 467: 
                case 470: {
                    if (pu == 0) break;
                    View.showmessage("GRENADE");
                }
            }
            return;
        }
        switch (spr.getPicnum()) {
            case 1361: {
                Teksnd.playsound(99, spr.getX(), spr.getY(), 0, 8);
                break;
            }
            case 592: {
                Teksnd.playsound(121, spr.getX(), spr.getY(), 0, 8);
                break;
            }
        }
        short datag = spr.getLotag();
        switch (datag) {
            case 6: {
                if ((spr.getCstat() & 1) != 0) {
                    Tektag.setanimpic(spr.getPicnum(), 9, 4);
                } else {
                    Tektag.setanimpic(spr.getPicnum(), 9, -4);
                }
                spr.setCstat(spr.getCstat() ^ 0x101);
                break;
            }
            case 4: {
                if (Tekprep.switchlevelsflag == 0 || Main.game.nNetMode != BuildGame.NetMode.Multiplayer || spr.getPicnum() != 182 && spr.getPicnum() != 803) break;
                Teksnd.playsound(24, spr.getX(), spr.getY(), 0, 8);
            }
        }
    }

    public static void initspriteXTs() {
        Sprite spr;
        int i;
        pickup = new Sprite();
        pickup.setExtra(-1);
        switch (Globals.gDifficulty) {
            case 0: 
            case 1: {
                vadd = -1;
                break;
            }
            case 2: {
                vadd = 0;
                break;
            }
            case 3: {
                vadd = 3;
            }
        }
        block8: for (i = 0; i < Engine.MAXSPRITES; ++i) {
            spr = Main.boardService.getSprite(i);
            if (spr == null || spr.getExtra() == -1) continue;
            switch (Tekprep.spriteXT[spr.getExtra()].basestat) {
                case 203: 
                case 204: 
                case 206: {
                    spr.setXvel(spr.getXvel() + vadd);
                    if (spr.getXvel() < 0) {
                        spr.setXvel(0);
                    }
                    spr.setYvel(spr.getYvel() + vadd);
                    if (spr.getYvel() < 0) {
                        spr.setYvel(0);
                    }
                    spr.setZvel(spr.getZvel() + vadd);
                    if (spr.getZvel() >= 0) continue block8;
                    spr.setZvel(0);
                }
            }
        }
        if (Main.game.nNetMode == BuildGame.NetMode.Multiplayer) {
            for (i = 0; i < Engine.MAXSPRITES; ++i) {
                short ext;
                spr = Main.boardService.getSprite(i);
                if (spr == null || (ext = spr.getExtra()) == -1) continue;
                if (spr.getStatnum() != 206) {
                    Tekstat.jsdeletesprite((short)i);
                    continue;
                }
                if (Tekprep.spriteXT[ext].basestat == 206) continue;
                Tekstat.jsdeletesprite((short)i);
            }
        }
        if (Globals.noenemiesflag != 0) {
            for (i = 0; i < Engine.MAXSPRITES; ++i) {
                spr = Main.boardService.getSprite(i);
                if (spr == null || spr.getExtra() == -1) continue;
                Tekstat.jsdeletesprite((short)i);
            }
        }
        if (Globals.noguardflag != 0) {
            for (i = 0; i < Engine.MAXSPRITES; ++i) {
                spr = Main.boardService.getSprite(i);
                if (spr == null) continue;
                if (spr.getStatnum() == 203) {
                    Tekstat.jsdeletesprite((short)i);
                    continue;
                }
                if (spr.getExtra() == -1 || Tekprep.spriteXT[spr.getExtra()].basestat != 203) continue;
                Tekstat.jsdeletesprite((short)i);
            }
        }
        if (Globals.nostalkflag != 0) {
            for (i = 0; i < Engine.MAXSPRITES; ++i) {
                spr = Main.boardService.getSprite(i);
                if (spr == null) continue;
                if (spr.getStatnum() == 204) {
                    Tekstat.jsdeletesprite((short)i);
                    continue;
                }
                if (spr.getExtra() == -1 || Tekprep.spriteXT[spr.getExtra()].basestat != 204) continue;
                Tekstat.jsdeletesprite((short)i);
            }
        }
        if (Globals.nochaseflag != 0) {
            for (i = 0; i < Engine.MAXSPRITES; ++i) {
                spr = Main.boardService.getSprite(i);
                if (spr == null) continue;
                if (spr.getStatnum() == 206) {
                    Tekstat.jsdeletesprite((short)i);
                    continue;
                }
                if (spr.getExtra() == -1 || Tekprep.spriteXT[spr.getExtra()].basestat != 206) continue;
                Tekstat.jsdeletesprite((short)i);
            }
        }
        if (Globals.nostrollflag != 0) {
            for (i = 0; i < Engine.MAXSPRITES; ++i) {
                spr = Main.boardService.getSprite(i);
                if (spr == null) continue;
                if (spr.getStatnum() == 209) {
                    Tekstat.jsdeletesprite((short)i);
                    continue;
                }
                if (spr.getExtra() == -1 || Tekprep.spriteXT[spr.getExtra()].basestat != 209) continue;
                Tekstat.jsdeletesprite((short)i);
            }
        }
    }

    public static void sectortriggersprites(int snum) {
        short ext;
        int index;
        Sprite spr;
        ListNode<Sprite> nexti;
        boolean triggered = false;
        if (Main.game.nNetMode == BuildGame.NetMode.Multiplayer) {
            return;
        }
        if (!Tekgun.validplayer(snum)) {
            throw new AssertException("sectrtrgrsprts: bad plrnum");
        }
        Sector plrSec = Main.boardService.getSector(Player.gPlayer[snum].cursectnum);
        if (plrSec == null) {
            return;
        }
        if (plrSec.getLotag() == 5030) {
            if (plrSec.getHitag() == 0) {
                View.showmessage("AREA IS OFF-LIMITS");
            }
            return;
        }
        if (plrSec.getLotag() != 5020) {
            return;
        }
        ListNode<Sprite> i = Main.boardService.getStatNode(0);
        while (i != null) {
            nexti = i.getNext();
            if (i.get().getHitag() == plrSec.getHitag()) {
                Tekstat.triggersprite(i.getIndex());
                triggered = true;
            }
            i = nexti;
        }
        i = Main.boardService.getStatNode(202);
        while (i != null) {
            nexti = i.getNext();
            spr = i.get();
            index = i.getIndex();
            if (spr.getHitag() == plrSec.getHitag()) {
                ext = spr.getExtra();
                if (Tekstat.validext(ext) == 0) {
                    Tekstat.noextthrowerror(index, 300);
                }
                Tekprep.spriteXT[index].aimask |= 4;
                Tekstat.ambushyell(index, ext);
                triggered = true;
            }
            i = nexti;
        }
        i = Main.boardService.getStatNode(203);
        while (i != null) {
            nexti = i.getNext();
            spr = i.get();
            index = i.getIndex();
            if (spr.getHitag() == plrSec.getHitag() && (ext = spr.getExtra()) != -1) {
                Tekprep.spriteXT[ext].aimask &= 0xFFFFFFBF;
                Tekstat.givewarning(index, ext);
                Tekprep.spriteXT[ext].aimask |= 0x80;
                triggered = true;
            }
            i = nexti;
        }
        i = Main.boardService.getStatNode(201);
        while (i != null) {
            nexti = i.getNext();
            spr = i.get();
            index = i.getIndex();
            ext = spr.getExtra();
            if (Tekstat.validext(ext) == 0 || Tekprep.spriteXT[ext].basestat == 203) {
                if (spr.getHitag() == plrSec.getHitag()) {
                    Tekprep.spriteXT[ext].aimask &= 0xFFFFFFBF;
                }
                Tekstat.givewarning(index, ext);
                Tekprep.spriteXT[ext].aimask |= 0x80;
                triggered = true;
            }
            i = nexti;
        }
        if (triggered) {
            plrSec.setHitag(0);
        }
    }

    public static void triggersprite(int sn) {
        if (Main.game.nNetMode == BuildGame.NetMode.Multiplayer) {
            return;
        }
        Sprite spr = Main.boardService.getSprite(sn);
        if (spr == null || spr.getExtra() == -1) {
            return;
        }
        short datag = spr.getLotag();
        switch (datag) {
            case 2003: {
                break;
            }
            case 2000: {
                int j = Tekstat.jsinsertsprite(spr.getSectnum(), Tekprep.spriteXT[spr.getExtra()].basestat);
                Sprite spr2 = Main.boardService.getSprite(j);
                if (spr2 == null) break;
                int newext = Tekstat.mapXT(j);
                if (Tekstat.validext(newext) == 0) {
                    Tekstat.jsdeletesprite(j);
                    break;
                }
                spr2.setX(spr.getX() + (EngineUtils.sin(spr.getAng() + 512 & 0x7FF) >> 6));
                spr2.setY(spr.getY() + (EngineUtils.sin(spr.getAng() & 0x7FF) >> 6));
                spr2.setZ(spr.getZ());
                spr2.setCstat(257);
                spr2.setPicnum((short)Tekprep.spriteXT[spr.getExtra()].basepic);
                spr2.setShade(spr.getShade());
                spr2.setSectnum(spr.getSectnum());
                spr2.setXrepeat(spr.getXrepeat());
                spr2.setYrepeat(spr.getYrepeat());
                spr2.setAng(spr.getAng());
                spr2.setXvel(spr.getXvel());
                spr2.setYvel(spr.getYvel());
                spr2.setZvel(spr.getZvel());
                spr2.setOwner(-1);
                spr2.setLotag(0);
                spr2.setHitag(0);
                Tekprep.spriteXT[spr2.getExtra()].basestat = Tekprep.spriteXT[spr.getExtra()].basestat;
                Tekprep.spriteXT[spr2.getExtra()].basepic = Tekprep.spriteXT[spr.getExtra()].basepic;
                Tekprep.spriteXT[spr2.getExtra()].walkpic = Tekprep.spriteXT[spr.getExtra()].walkpic;
                Tekprep.spriteXT[spr2.getExtra()].standpic = Tekprep.spriteXT[spr.getExtra()].standpic;
                Tekprep.spriteXT[spr2.getExtra()].runpic = Tekprep.spriteXT[spr.getExtra()].runpic;
                Tekprep.spriteXT[spr2.getExtra()].attackpic = Tekprep.spriteXT[spr.getExtra()].attackpic;
                Tekprep.spriteXT[spr2.getExtra()].deathpic = Tekprep.spriteXT[spr.getExtra()].deathpic;
                Tekprep.spriteXT[spr2.getExtra()].morphpic = Tekprep.spriteXT[spr.getExtra()].morphpic;
                Tekprep.spriteXT[spr2.getExtra()].specialpic = Tekprep.spriteXT[spr.getExtra()].specialpic;
                spr.setLotag(0);
                spr.setHitag(0);
                Tekstat.clearXTpics(sn);
                break;
            }
            default: {
                Tekstat.newstatus(sn, Tekprep.spriteXT[spr.getExtra()].basestat);
            }
        }
    }

    public static boolean isaplayersprite(int sprnum) {
        Sprite spr = Main.boardService.getSprite(sprnum);
        if (spr == null) {
            return false;
        }
        short j = Mmulti.connecthead;
        while (j >= 0) {
            if (Player.gPlayer[j].playersprite == sprnum) {
                return true;
            }
            j = Mmulti.connectpoint2[j];
        }
        if (spr.getStatnum() == 8) {
            throw new AssertException("isplrspr: non plr has statnm 8");
        }
        return false;
    }

    public static void noextthrowerror(int i, int loc) {
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null) {
            return;
        }
        Console.out.println("sprite at " + spr.getX() + " ," + spr.getY() + "  no extension from  " + loc);
    }

    public static void newstatus(int sn, int seq) {
        Sprite spr = Main.boardService.getSprite(sn);
        if (spr == null) {
            return;
        }
        if (Tekstat.isaplayersprite(sn)) {
            return;
        }
        short ext = spr.getExtra();
        if (Tekstat.validext(ext) == 0) {
            Tekstat.noextthrowerror(sn, 0);
        }
        block0 : switch (seq) {
            case 0: {
                Main.engine.changespritestat(sn, 0);
                break;
            }
            case 100: {
                Main.engine.changespritestat(sn, 100);
                break;
            }
            case 322: {
                Main.game.pInt.setsprinterpolate(sn, spr);
                Sector sec = Main.boardService.getSector(spr.getSectnum());
                if (sec == null) break;
                if (sec.getLotag() == 4) {
                    int zoffs = 0;
                    if ((spr.getCstat() & 0x80) == 0) {
                        zoffs = -(Main.engine.getTile(spr.getPicnum()).getHeight() * spr.getYrepeat() << 1);
                    }
                    spr.setZ(sec.getFloorz() - zoffs);
                    spr.setLotag(0);
                    spr.setHitag(0);
                    spr.setXvel(1);
                    spr.setYvel(1);
                    Main.engine.changespritestat(sn, 322);
                    break;
                }
                Main.engine.getzrange(spr.getX(), spr.getY(), spr.getZ() - 1, spr.getSectnum(), spr.getClipdist() << 2, 65537);
                spr.setZ(Engine.zr_florz);
                Main.engine.changespritestat(sn, 100);
                break;
            }
            case 203: {
                int newpic = Tekprep.spriteXT[ext].walkpic;
                if (newpic == 0) break;
                Main.engine.changespritestat(sn, 203);
                spr.setLotag(0);
                spr.setPicnum(newpic);
                Tekprep.spriteXT[ext].basestat = (short)203;
                break;
            }
            case 207: {
                int newpic = Tekprep.spriteXT[ext].walkpic;
                if (newpic == 0) break;
                Main.engine.changespritestat(sn, 207);
                spr.setLotag(0);
                spr.setPicnum(newpic);
                Tekprep.spriteXT[ext].basestat = (short)207;
                break;
            }
            case 403: {
                int newpic = Tekprep.spriteXT[ext].walkpic;
                if (newpic == 0) break;
                Main.engine.changespritestat(sn, 403);
                spr.setPicnum(newpic);
                Tekprep.spriteXT[ext].basestat = (short)403;
                break;
            }
            case 209: {
                int newpic = Tekprep.spriteXT[ext].walkpic;
                if (newpic == 0) break;
                Main.engine.changespritestat(sn, 209);
                spr.setLotag(0);
                spr.setPicnum(newpic);
                Tekprep.spriteXT[ext].basestat = (short)209;
                break;
            }
            case 206: {
                int newpic = Tekprep.spriteXT[ext].runpic;
                if (newpic == 0) break;
                Main.engine.changespritestat(sn, 206);
                spr.setLotag(0);
                spr.setPicnum(newpic);
                Tekprep.spriteXT[ext].basestat = (short)206;
                break;
            }
            case 205: {
                int newpic = Tekprep.spriteXT[ext].runpic;
                if (newpic == 0) break;
                Main.engine.changespritestat(sn, 205);
                spr.setLotag(0);
                spr.setPicnum(newpic);
                break;
            }
            case 300: {
                int newpic = Tekprep.spriteXT[ext].attackpic;
                if (newpic == 0) break;
                Main.engine.changespritestat(sn, 300);
                spr.setPicnum(newpic);
                switch (Tekprep.spriteXT[ext].weapon) {
                    case '\u0001': 
                    case '\u0002': 
                    case '\u0003': 
                    case '\u0004': 
                    case '\u0005': {
                        spr.setLotag(32);
                        spr.setHitag(32);
                        break block0;
                    }
                }
                spr.setLotag(64);
                spr.setHitag(64);
                break;
            }
            case 313: {
                spr.setLotag(95);
                Main.engine.changespritestat(sn, 313);
                break;
            }
            case 204: {
                int newpic = Tekprep.spriteXT[ext].runpic;
                if (newpic == 0) break;
                Main.engine.changespritestat(sn, 204);
                spr.setLotag(0);
                spr.setPicnum(newpic);
                Tekprep.spriteXT[ext].basestat = (short)204;
                break;
            }
            case 305: {
                int newpic = Tekprep.spriteXT[ext].squatpic;
                if (newpic == 0) break;
                Main.engine.changespritestat(sn, 305);
                spr.setLotag(47);
                spr.setHitag(64);
                break;
            }
            case 306: {
                int newpic = Tekprep.spriteXT[ext].squatpic;
                if (newpic == 0) break;
                Main.engine.changespritestat(sn, 306);
                spr.setLotag(47);
                spr.setHitag(0);
                break;
            }
            case 309: {
                int newpic = Tekprep.spriteXT[ext].squatpic;
                if (newpic == 0) break;
                Main.engine.changespritestat(sn, 305);
                spr.setLotag(31);
                spr.setHitag(0);
                break;
            }
            case 310: {
                int newpic = Tekprep.spriteXT[ext].squatpic;
                if (newpic == 0) break;
                Main.engine.changespritestat(sn, 306);
                spr.setLotag(31);
                spr.setHitag(0);
                break;
            }
            case 311: {
                int newpic = Tekprep.spriteXT[ext].squatpic;
                if (newpic == 0) break;
                Main.engine.changespritestat(sn, 311);
                spr.setLotag(31);
                spr.setHitag(256);
                break;
            }
            case 312: {
                int newpic = Tekprep.spriteXT[ext].squatpic;
                if (newpic == 0) break;
                Main.engine.changespritestat(sn, 312);
                spr.setLotag(31);
                spr.setHitag(0);
                break;
            }
            case 302: {
                int newpic = Tekprep.spriteXT[ext].painpic;
                if (newpic == 0) break;
                Main.engine.changespritestat(sn, 302);
                spr.setPicnum(newpic);
                spr.setLotag(16);
                break;
            }
            case 201: {
                int newpic = Tekprep.spriteXT[ext].standpic;
                if (newpic == 0) break;
                spr.setPicnum(newpic);
                if (spr.getLotag() <= 0) {
                    spr.setLotag((short)(Tektag.krand_intercept("STAT1732") & 0x400));
                }
                Main.engine.changespritestat(sn, 201);
                break;
            }
            case 500: {
                int newpic = Tekprep.spriteXT[ext].runpic;
                if (newpic == 0) break;
                Main.engine.changespritestat(sn, 500);
                spr.setLotag(0);
                spr.setPicnum(newpic);
                Tekprep.spriteXT[ext].basestat = (short)500;
                break;
            }
            case 502: {
                int newpic = Tekprep.spriteXT[ext].runpic;
                if (newpic == 0) break;
                Main.engine.changespritestat(sn, 502);
                spr.setLotag(0);
                spr.setPicnum(newpic);
                Tekprep.spriteXT[ext].basestat = (short)502;
                break;
            }
            case 304: {
                if (Tekprep.spriteXT[ext].morphpic == 0) break;
                Main.engine.changespritestat(sn, 304);
                spr.setLotag(95);
                break;
            }
            case 301: {
                int newpic = Tekprep.spriteXT[ext].deathpic;
                spr.setCstat(spr.getCstat() & 0xFFFFFEFE);
                if (newpic != 0) {
                    Main.engine.changespritestat(sn, 301);
                    Tekstat.deathdropitem(sn);
                    spr.setLotag((short)((Main.engine.getTile(newpic).getAnimFrames() << 4) - 1));
                    spr.setHitag(spr.getLotag());
                    Tekstat.deathsounds(newpic, spr.getX(), spr.getY());
                    spr.setPicnum(newpic);
                    break;
                }
                Main.engine.changespritestat(sn, 100);
                break;
            }
        }
    }

    public static void deathsounds(int pic, int x, int y) {
        switch (pic) {
            case 390: 
            case 1019: 
            case 1135: 
            case 1791: 
            case 1933: 
            case 1980: 
            case 2085: 
            case 2165: 
            case 2295: 
            case 2415: 
            case 2455: 
            case 2550: 
            case 2662: 
            case 2712: 
            case 2792: 
            case 2850: 
            case 2910: 
            case 2978: 
            case 3041: {
                Teksnd.playsound(129 + Tekstat.RMOD4("STAT1378") + Tekstat.RMOD3("STAT1378") + Tekstat.RMOD3("STAT1378"), x, y, 0, 4);
                break;
            }
            case 1821: 
            case 1874: 
            case 2046: 
            case 2227: 
            case 2340: 
            case 2607: {
                Teksnd.playsound(139 + Tekstat.RMOD4("STAT1389") + Tekstat.RMOD3("STAT1389"), x, y, 0, 4);
                break;
            }
            case 794: {
                Teksnd.playsound(112 + Tekstat.RMOD2("STAT1392"), x, y, 0, 4);
                break;
            }
            case 570: {
                Teksnd.playsound(106, x, y, 0, 4);
                break;
            }
            case 609: {
                Teksnd.playsound(116 + Tekstat.RMOD2("STAT1398"), 0, 0, 0, 1);
                break;
            }
            case 3060: 
            case 3064: 
            case 3068: 
            case 3072: 
            case 3076: 
            case 3080: 
            case 3084: {
                Teksnd.playsound(207, x, y, 0, 4);
                break;
            }
            case 3973: {
                if (Tektag.krand_intercept("STAT1364") < Short.MAX_VALUE) {
                    Teksnd.playsound(148, x, y, 0, 4);
                    break;
                }
                Teksnd.playsound(149, x, y, 0, 4);
            }
        }
    }

    public static void deathdropitem(int sn) {
        int pic;
        if (Main.game.nNetMode == BuildGame.NetMode.Multiplayer) {
            return;
        }
        Sprite spr = Main.boardService.getSprite(sn);
        if (spr == null) {
            return;
        }
        short ext = spr.getExtra();
        if (Tekstat.validext(ext) == 0) {
            return;
        }
        if ((Tekprep.spriteXT[ext].fxmask & 1) != 0) {
            pic = 346;
            Tekprep.spriteXT[ext].fxmask &= 0xFFFFFFFE;
        } else if ((Tekprep.spriteXT[ext].fxmask & 2) != 0) {
            pic = 347;
            Tekprep.spriteXT[ext].fxmask &= 0xFFFFFFFD;
        } else {
            if ((Tekprep.spriteXT[ext].fxmask & 4) != 0) {
                View.showmessage("WAS AN ANDROID");
                return;
            }
            switch (Tekprep.spriteXT[ext].weapon) {
                case '\u0004': 
                case '\u0005': {
                    pic = 924;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        int j = Tekstat.jsinsertsprite(spr.getSectnum(), 406);
        Sprite spr2 = Main.boardService.getSprite(j);
        if (spr2 == null) {
            return;
        }
        Tekspr.fillsprite(j, spr.getX(), spr.getY(), spr.getZ() - (Main.engine.getTile(spr.getPicnum()).getHeight() << 6), 128, 0, 0, 12, 16, 16, 0, 0, pic, spr.getAng(), EngineUtils.sin(spr.getAng() + 2560 & 0x7FF) >> 6, EngineUtils.sin(spr.getAng() + 2048 & 0x7FF) >> 6, 30, sn + 4096, 0, 0);
        switch (spr2.getPicnum()) {
            case 924: {
                spr2.setXrepeat(spr2.getXrepeat() - 2);
                spr2.setYrepeat(spr2.getYrepeat() - 2);
                break;
            }
            case 346: 
            case 347: {
                spr2.setXrepeat(spr2.getXrepeat() >> 1);
                spr2.setYrepeat(spr2.getYrepeat() >> 1);
                break;
            }
        }
    }

    public static int mapXT(int sn) {
        Sprite spr = Main.boardService.getSprite(sn);
        if (spr == null) {
            return 0;
        }
        for (int i = 0; i < Engine.MAXSPRITES; ++i) {
            if (Tekprep.spriteXT[i].lock != '\u0000') continue;
            spr.setExtra(i);
            Tekprep.spriteXT[i].set(0);
            Tekprep.spriteXT[i].lock = (char)255;
            return i;
        }
        spr.setExtra(-1);
        return -1;
    }

    public static void clearXTpics(int sn) {
        Sprite spr = Main.boardService.getSprite(sn);
        if (spr == null) {
            return;
        }
        short extno = spr.getExtra();
        if (extno != -1) {
            Tekprep.spriteXT[extno].basepic = spr.getPicnum();
            Tekprep.spriteXT[extno].standpic = 0;
            Tekprep.spriteXT[extno].walkpic = 0;
            Tekprep.spriteXT[extno].runpic = 0;
            Tekprep.spriteXT[extno].attackpic = 0;
            Tekprep.spriteXT[extno].deathpic = 0;
            Tekprep.spriteXT[extno].painpic = 0;
            Tekprep.spriteXT[extno].squatpic = 0;
            Tekprep.spriteXT[extno].morphpic = 0;
            Tekprep.spriteXT[extno].specialpic = 0;
        }
    }

    public static void ambushyell(int sn, int ext) {
        Sprite spr = Main.boardService.getSprite(sn);
        if (spr == null) {
            return;
        }
        if (Tekstat.validext(ext) == 0) {
            return;
        }
        if ((Tekprep.spriteXT[ext].aimask & 0x200) != 0) {
            return;
        }
        switch (Tekprep.spriteXT[ext].basepic) {
            case 355: 
            case 1751: {
                Teksnd.playsound(151 + (Tektag.krand_intercept("STAT2603") & 6), spr.getX(), spr.getY(), 0, 1);
                Tekprep.spriteXT[ext].aimask |= 0x200;
                break;
            }
            case 1887: {
                Teksnd.playsound(202 + (Tektag.krand_intercept("STAT2607") & 2), spr.getX(), spr.getY(), 0, 1);
                Tekprep.spriteXT[ext].aimask |= 0x200;
            }
        }
    }

    public static void attachvirus(int i, int pic) {
        if (Main.game.nNetMode == BuildGame.NetMode.Multiplayer) {
            return;
        }
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null) {
            return;
        }
        if (spr.getStatnum() == 250 || spr.getStatnum() == 403) {
            return;
        }
        if (Tekstat.isanandroid(i) != 0 || Tekstat.isahologram(i) != 0) {
            return;
        }
        ListNode<Sprite> j = Main.boardService.getStatNode(250);
        while (j != null) {
            ListNode<Sprite> nextj = j.getNext();
            if (j.get().getOwner() == i) {
                return;
            }
            j = nextj;
        }
        int js = Tekstat.jsinsertsprite(spr.getSectnum(), 250);
        Sprite pSprite = Main.boardService.getSprite(js);
        if (pSprite == null) {
            return;
        }
        pSprite.setExtra(-1);
        pSprite.setX(spr.getX());
        pSprite.setY(spr.getY());
        pSprite.setZ(spr.getZ());
        pSprite.setXrepeat(20);
        pSprite.setYrepeat(20);
        pSprite.setCstat(0);
        pSprite.setShade(-28);
        pSprite.setPicnum(pic);
        pSprite.setLotag(Tektag.krand_intercept("STAT1216") & 0x280);
        pSprite.setHitag(0);
        pSprite.setOwner(i);
        if (pic == 450) {
            pSprite.setXrepeat(spr.getXrepeat());
            pSprite.setYrepeat((byte)(spr.getYrepeat() + 8));
            short ext = spr.getExtra();
            Teksnd.playsound(36, pSprite.getX(), pSprite.getY(), 0, 2);
            if (Tekstat.validext(ext) != 0) {
                Tekstat.newstatus(i, 403);
                if (spr.getStatnum() == 403) {
                    spr.setXvel(spr.getXvel() + 4);
                    spr.setYvel(spr.getYvel() + 4);
                }
            }
        } else {
            Teksnd.playsound(108, spr.getX(), spr.getY(), 0, 8);
        }
    }

    public static int playervirus(int pnum, int pic) {
        if (!Tekgun.validplayer(pnum)) {
            throw new AssertException("plrvrus: bad plrnum");
        }
        ListNode<Sprite> node = Main.boardService.getStatNode(255);
        while (node != null) {
            ListNode<Sprite> nextj = node.getNext();
            if (node.get().getOwner() == pnum) {
                return 0;
            }
            node = nextj;
        }
        int j = Tekstat.jsinsertsprite(Player.gPlayer[pnum].cursectnum, 255);
        Sprite spr = Main.boardService.getSprite(j);
        if (spr == null) {
            return 0;
        }
        spr.setExtra(-1);
        spr.setX(Player.gPlayer[pnum].posx);
        spr.setY(Player.gPlayer[pnum].posy);
        spr.setZ(Player.gPlayer[pnum].posz);
        spr.setXrepeat(18);
        spr.setYrepeat(40);
        spr.setCstat(0);
        spr.setShade(-28);
        spr.setPicnum((short)pic);
        spr.setLotag((short)(Tektag.krand_intercept("STAT1172") & 0x280));
        spr.setHitag(0);
        spr.setOwner((short)pnum);
        Teksnd.playsound(36, spr.getX(), spr.getY(), 0, 2);
        return 1;
    }

    public static int damagesprite(int hitsprite, int points) {
        Sprite spr = Main.boardService.getSprite(hitsprite);
        if (spr == null) {
            return 0;
        }
        if (Tekstat.isaplayersprite(hitsprite)) {
            return 0;
        }
        short ext = spr.getExtra();
        switch (spr.getStatnum()) {
            case 0: {
                if (Tekstat.validext(ext) != 0) {
                    Tekstat.newstatus(hitsprite, 301);
                }
                return 0;
            }
            case 800: {
                Main.engine.changespritestat(hitsprite, 100);
                Tekstat.genexplosion1(hitsprite);
                Tekstat.jsdeletesprite(hitsprite);
                return 0;
            }
            case 801: {
                Main.engine.changespritestat(hitsprite, 100);
                Tekstat.genexplosion2(hitsprite);
                Tekstat.jsdeletesprite(hitsprite);
                return 0;
            }
            case 100: 
            case 301: 
            case 302: 
            case 303: 
            case 322: 
            case 400: 
            case 401: 
            case 402: 
            case 407: {
                return 0;
            }
        }
        if (Globals.gDifficulty == 0) {
            points <<= 1;
        }
        if (Tekstat.validext(ext) != 0) {
            Tekprep.spriteXT[ext].hitpoints = Math.abs(points) > Tekprep.spriteXT[ext].hitpoints ? (byte)0 : (byte)(Tekprep.spriteXT[ext].hitpoints - (byte)points);
            Tekprep.spriteXT[ext].aimask |= 4;
            Tekprep.spriteXT[ext].aimask |= 0x800;
            Tekprep.spriteXT[ext].aimask |= 0x20;
            if (Tekprep.spriteXT[ext].hitpoints < 25) {
                Tekprep.spriteXT[ext].aimask |= 8;
            }
            if (Tekprep.spriteXT[ext].hitpoints <= 0) {
                Tekprep.spriteXT[ext].hitpoints = 0;
                Tekprep.spriteXT[ext].fxmask |= 0x40;
                return 1;
            }
            Tekprep.spriteXT[ext].fxmask |= 0x20;
        }
        return 0;
    }

    public static int playerhit(int hitsprite) {
        Sprite spr = Main.boardService.getSprite(hitsprite);
        if (spr == null) {
            return 0;
        }
        short j = Mmulti.connecthead;
        while (j >= 0) {
            if (Player.gPlayer[j].playersprite == hitsprite) {
                if (spr.getStatnum() != 8) {
                    throw new AssertException("plrhit: plrsprt lost sttnm 8");
                }
                playerhit = j;
                return 1;
            }
            j = Mmulti.connectpoint2[j];
        }
        return 0;
    }

    public static void sectorflash(short s) {
        if (Tekstat.sectflash.step != 0) {
            return;
        }
        Sector sec = Main.boardService.getSector(s);
        if (sec == null) {
            return;
        }
        Tekstat.sectflash.sectnum = s;
        Tekstat.sectflash.step = 1;
        Tekstat.sectflash.ovis = (char)(sec.getVisibility() & 0xFF);
    }

    public static void genexplosion1(int i) {
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null) {
            return;
        }
        int j = Tekstat.jsinsertsprite(spr.getSectnum(), 5);
        if (j != -1) {
            Tekspr.fillsprite(j, spr.getX(), spr.getY(), spr.getZ(), 0, -16, 0, 0, 64, 64, 0, 0, 957, spr.getAng(), EngineUtils.sin(spr.getAng() + 2560 & 0x7FF) >> 6, EngineUtils.sin(spr.getAng() + 2048 & 0x7FF) >> 6, 30, i + 4096, 24, 0);
            Teksnd.playsound(116 + Tekstat.RMOD2("STAT4534"), spr.getX(), spr.getY(), 0, 4);
        }
    }

    public static void genexplosion2(int i) {
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null) {
            return;
        }
        Tekstat.sectorflash(spr.getSectnum());
        Tekstat.checkblastarea(i);
        int j = Tekstat.jsinsertsprite(spr.getSectnum(), 5);
        if (j != -1) {
            Tekspr.fillsprite(j, spr.getX(), spr.getY(), spr.getZ() - (Main.engine.getTile(spr.getPicnum()).getHeight() << 3), 0, -16, 0, 0, 64, 64, 0, 0, 965, spr.getAng(), EngineUtils.sin(spr.getAng() + 2560 & 0x7FF) >> 6, EngineUtils.sin(spr.getAng() + 2048 & 0x7FF) >> 6, 30, i + 4096, 32, 0);
            Teksnd.playsound(114 + Tekstat.RMOD2("STAT4559"), spr.getX(), spr.getY(), 0, 4);
        }
    }

    public static int spewblood(int sn, int hitz) {
        Sprite spr = Main.boardService.getSprite(sn);
        if (spr == null) {
            return 0;
        }
        short ext = spr.getExtra();
        if (Main.game.nNetMode == BuildGame.NetMode.Multiplayer) {
            return 0;
        }
        if (Tekstat.validext(ext) == 0) {
            return 0;
        }
        if (Tekstat.isanandroid(sn) != 0 || Tekstat.isahologram(sn) != 0) {
            return 0;
        }
        switch (Tekprep.spriteXT[ext].basepic) {
            case 355: 
            case 1115: 
            case 1751: 
            case 1801: 
            case 1834: 
            case 1887: 
            case 1950: 
            case 2003: 
            case 2065: {
                int j = Tekstat.jsinsertsprite(spr.getSectnum(), 407);
                Sprite spr2 = Main.boardService.getSprite(j);
                if (spr2 == null) break;
                Tekspr.fillsprite(j, spr.getX(), spr.getY(), spr.getZ() - (Main.engine.getTile(spr.getPicnum()).getHeight() << 6), 128, 0, 0, 12, 16, 16, 0, 0, 327, spr.getAng(), EngineUtils.sin(spr.getAng() + 2560 & 0x7FF) >> 6, EngineUtils.sin(spr.getAng() + 2048 & 0x7FF) >> 6, 30, sn + 4096, 0, 0);
                spr2.setZ(hitz);
                spr2.setLotag((short)Main.engine.getTile(327).getAnimFrames());
                if (spr2.getLotag() > 8) {
                    spr2.setLotag(8);
                }
                if (spr2.getLotag() < 0) {
                    spr2.setLotag(0);
                }
                spr2.setHitag(0);
                return 1;
            }
        }
        return 0;
    }

    public static void checkblastarea(int sn) {
        Sprite spr = Main.boardService.getSprite(sn);
        if (spr == null) {
            return;
        }
        short sect = spr.getSectnum();
        short j = Mmulti.connecthead;
        while (j >= 0) {
            int xydist = Pragmas.klabs(spr.getX() - Player.gPlayer[j].posx) + Pragmas.klabs(spr.getY() - Player.gPlayer[j].posy);
            int zdist = Pragmas.klabs(spr.getZ() - Player.gPlayer[j].posz);
            if (xydist < 512 && zdist < 10240) {
                Tekchng.changehealth(j, -5000);
            } else if (xydist < 2048 && zdist < 20480) {
                Tekchng.changehealth(j, -800);
            } else if (xydist < 4096 && zdist < 40960) {
                Tekchng.changehealth(j, -200);
            }
            j = Mmulti.connectpoint2[j];
        }
        if (Main.game.nNetMode != BuildGame.NetMode.Multiplayer) {
            ListNode<Sprite> node = Main.boardService.getSectNode(sect);
            while (node != null) {
                ListNode<Sprite> next = node.getNext();
                int i = node.getIndex();
                Sprite spr2 = node.get();
                if (i != sn && !Tekstat.isaplayersprite(i)) {
                    switch (spr2.getStatnum()) {
                        case 8: 
                        case 100: 
                        case 301: 
                        case 407: 
                        case 714: 
                        case 716: {
                            break;
                        }
                        default: {
                            int xydist = Pragmas.klabs(spr.getX() - spr2.getX()) + Pragmas.klabs(spr.getY() - spr2.getY());
                            int zdist = Pragmas.klabs(spr.getZ() - spr2.getZ());
                            if (xydist >= 2560 || zdist >= 16384) break;
                            Tekstat.damagesprite(i, -500);
                        }
                    }
                }
                node = next;
            }
        }
    }

    public static int isahologram(int i) {
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null) {
            return 0;
        }
        short ext = spr.getExtra();
        if (Tekstat.validext(ext) != 0 && (Tekprep.spriteXT[ext].fxmask & 8) != 0) {
            return 1;
        }
        return 0;
    }

    public static int isanandroid(int i) {
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null) {
            return 0;
        }
        short ext = spr.getExtra();
        if (Tekstat.validext(ext) != 0 && (Tekprep.spriteXT[ext].fxmask & 4) != 0) {
            return 1;
        }
        return 0;
    }

    public static void playergunshot(int snum) {
        int dist;
        short ext;
        Sprite spr;
        ListNode<Sprite> nextj;
        if (!Tekgun.validplayer(snum)) {
            throw new AssertException("plgunsht: bad plrnum");
        }
        ListNode<Sprite> j = Main.boardService.getStatNode(209);
        while (j != null) {
            nextj = j.getNext();
            spr = j.get();
            ext = spr.getExtra();
            if (Tekstat.validext(ext) == 0) {
                Tekstat.noextthrowerror(j.getIndex(), 103);
            }
            if ((dist = Math.abs(spr.getX() - Player.gPlayer[snum].posx) + Math.abs(spr.getY() - Player.gPlayer[snum].posy)) < 10240) {
                Tekprep.spriteXT[ext].aimask |= 4;
            }
            j = nextj;
        }
        j = Main.boardService.getStatNode(201);
        while (j != null) {
            nextj = j.getNext();
            spr = j.get();
            ext = spr.getExtra();
            if (Tekstat.validext(ext) == 0) {
                Tekstat.noextthrowerror(j.getIndex(), 105);
            }
            if ((dist = Math.abs(spr.getX() - Player.gPlayer[snum].posx) + Math.abs(spr.getY() - Player.gPlayer[snum].posy)) < 10240) {
                Tekprep.spriteXT[ext].aimask |= 4;
            }
            j = nextj;
        }
        j = Main.boardService.getStatNode(203);
        while (j != null) {
            nextj = j.getNext();
            spr = j.get();
            ext = spr.getExtra();
            if (Tekstat.validext(ext) == 0) {
                Tekstat.noextthrowerror(j.getIndex(), 106);
            }
            if ((dist = Math.abs(spr.getX() - Player.gPlayer[snum].posx) + Math.abs(spr.getY() - Player.gPlayer[snum].posy)) < 10240) {
                Tekprep.spriteXT[ext].aimask |= 4;
            }
            j = nextj;
        }
    }

    public static void givewarning(int i, int ext) {
        if (Main.game.nNetMode == BuildGame.NetMode.Multiplayer) {
            return;
        }
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null) {
            return;
        }
        if (Tekstat.validext(ext) == 0) {
            return;
        }
        if ((Tekprep.spriteXT[ext].aimask & 0x40) != 0) {
            return;
        }
        int dist = Math.abs(Player.gPlayer[Main.screenpeek].posx - spr.getX()) + Math.abs(Player.gPlayer[Main.screenpeek].posy - spr.getY());
        if (dist > 5000) {
            return;
        }
        if (Tekprep.spriteXT[ext].basepic == 1115) {
            Teksnd.playsound(197 + (Tektag.krand_intercept("STAT2636") & 4), spr.getX(), spr.getY(), 0, 8);
            Tekprep.spriteXT[ext].aimask |= 0x40;
        }
    }

    public static void dosectorflash() {
        Sector sec = Main.boardService.getSector(Tekstat.sectflash.sectnum);
        if (sec == null) {
            return;
        }
        switch (Tekstat.sectflash.step) {
            case 0: {
                break;
            }
            case 1: {
                sec.setVisibility(0);
                Tekstat.sectflash.step = 2;
                break;
            }
            case 2: {
                sec.setVisibility(-128);
                Tekstat.sectflash.step = 3;
                break;
            }
            case 3: {
                sec.setVisibility(0);
                Tekstat.sectflash.step = 4;
                break;
            }
            case 4: {
                sec.setVisibility((byte)Tekstat.sectflash.ovis);
                Tekstat.sectflash.sectnum = 0;
                Tekstat.sectflash.ovis = '\u0000';
                Tekstat.sectflash.step = 0;
            }
        }
    }

    public static void splash(int i) {
        if (Main.game.nNetMode == BuildGame.NetMode.Multiplayer) {
            return;
        }
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null) {
            return;
        }
        int j = Tekstat.jsinsertsprite(spr.getSectnum(), 407);
        Sprite spr2 = Main.boardService.getSprite(j);
        if (spr2 != null) {
            Tekspr.fillsprite(j, spr.getX(), spr.getY(), spr.getZ(), 2, -13, 0, 32, 64, 64, 0, 0, 292, spr.getAng(), 0, 0, 0, i + 4096, 0, 0);
            spr2.setLotag((short)Main.engine.getTile(292).getAnimFrames());
            if (spr2.getLotag() > 8) {
                spr2.setLotag(8);
            }
            if (spr2.getLotag() < 0) {
                spr2.setLotag(0);
            }
            spr2.setHitag(0);
            Teksnd.playsound(11, spr2.getX(), spr2.getY(), 0, 4);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void statuslistcode() {
        int pz;
        int day;
        int dax;
        short prevsect;
        int prevx;
        short target;
        int mindist;
        int daz;
        int day2;
        int pnum;
        int day3;
        int dax2;
        int movestat;
        int index;
        ListNode<Sprite> nexti;
        ListNode<Sprite> i;
        Tekstat.dosectorflash();
        if (Main.lockclock - stackedcheck > 30) {
            stackedcheck = Main.lockclock;
            i = Main.boardService.getStatNode(610);
            while (i != null) {
                nexti = i.getNext();
                Sprite spr = i.get();
                index = i.getIndex();
                Sector sec = Main.boardService.getSector(spr.getSectnum());
                if (sec != null && spr.getZ() != sec.getFloorz()) {
                    short tempshort = spr.getCstat();
                    spr.setCstat(spr.getCstat() & 0xFFFFFFFE);
                    Main.engine.getzrange(spr.getX(), spr.getY(), spr.getZ() - 1, spr.getSectnum(), spr.getClipdist() << 2, 1);
                    spr.setCstat(tempshort);
                    if (spr.getZ() != Engine.zr_florz) {
                        spr.setHitag(0);
                        Main.engine.changespritestat(index, 611);
                    }
                }
                i = nexti;
            }
        }
        i = Main.boardService.getStatNode(999);
        while (i != null) {
            nexti = i.getNext();
            int index2 = i.getIndex();
            Tekstat.jsdeletesprite(index2);
            i = nexti;
        }
        i = Main.boardService.getStatNode(611);
        while (i != null) {
            nexti = i.getNext();
            Sprite spr = i.get();
            index = i.getIndex();
            Main.game.pInt.setsprinterpolate(index, spr);
            spr.setZ(spr.getZ() + 6144);
            short tempshort = spr.getCstat();
            spr.setCstat(spr.getCstat() & 0xFFFFFFFE);
            Main.engine.getzrange(spr.getX(), spr.getY(), spr.getZ() - 1, spr.getSectnum(), spr.getClipdist() << 2, 1);
            spr.setCstat(tempshort);
            Sector sec = Main.boardService.getSector(spr.getSectnum());
            if (sec != null && spr.getZ() >= Engine.zr_florz) {
                spr.setZ(Engine.zr_florz);
                if (Engine.zr_florz < sec.getFloorz()) {
                    Main.engine.changespritestat(index, 610);
                } else {
                    Main.engine.changespritestat(index, 0);
                }
            }
            i = nexti;
        }
        i = Main.boardService.getStatNode(3);
        while (i != null) {
            nexti = i.getNext();
            Sprite spr = i.get();
            index = i.getIndex();
            Main.game.pInt.setsprinterpolate(index, spr);
            spr.setZ(spr.getZ() - 24);
            spr.setLotag(spr.getLotag() - 3);
            if (spr.getLotag() < 0) {
                Tekstat.jsdeletesprite(index);
            }
            i = nexti;
        }
        i = Main.boardService.getStatNode(5);
        while (i != null) {
            nexti = i.getNext();
            Sprite spr = i.get();
            index = i.getIndex();
            spr.setLotag(spr.getLotag() - 3);
            if (spr.getLotag() < 0) {
                Tekstat.jsdeletesprite(index);
            }
            i = nexti;
        }
        i = Main.boardService.getStatNode(407);
        while (i != null) {
            nexti = i.getNext();
            Sprite spr = i.get();
            index = i.getIndex();
            spr.setHitag(spr.getHitag() + 1);
            if (spr.getHitag() >= 3) {
                spr.setPicnum(spr.getPicnum() + 1);
                spr.setHitag(0);
                spr.setLotag(spr.getLotag() - 1);
            }
            if (spr.getLotag() <= 0) {
                Tekstat.jsdeletesprite(index);
            }
            i = nexti;
        }
        i = Main.boardService.getStatNode(322);
        while (i != null) {
            nexti = i.getNext();
            Sprite spr = i.get();
            index = i.getIndex();
            int prevx2 = spr.getX();
            int prevy = spr.getY();
            int prevz = spr.getZ();
            short prevsect2 = spr.getSectnum();
            Main.game.pInt.setsprinterpolate(index, spr);
            spr.setHitag(spr.getHitag() + 1);
            if (spr.getHitag() >= 3) {
                spr.setLotag(spr.getLotag() + 1);
                if (spr.getLotag() >= 32) {
                    spr.setLotag(0);
                }
                spr.setZ(spr.getZ() + (bobbing[spr.getLotag()] << 4));
                spr.setHitag(0);
            }
            if (((movestat = Tekspr.floatmovesprite(index, dax2 = EngineUtils.sin(spr.getAng() + 512 & 0x7FF) * spr.getXvel() << 3, day3 = EngineUtils.sin(spr.getAng() & 0x7FF) * spr.getYvel() << 3, 1024, 1024, 0)) & 0xE0000000) == Integer.MIN_VALUE) {
                Main.engine.setsprite(index, prevx2, prevy, prevz);
                spr.setAng(Tekstat.walldeflect(movestat & 0x1FFFFFFF, spr.getAng()));
            } else if ((movestat & 0xE0000000) == -1073741824) {
                Main.engine.setsprite(index, prevx2, prevy, prevz);
                spr.setAng(Tekstat.spritedeflect(movestat & 0x1FFFFFFF));
            } else if (prevsect2 != spr.getSectnum()) {
                Main.engine.setsprite(index, prevx2, prevy, prevz);
                spr.setAng(Tekstat.arbitraryangle());
            }
            i = nexti;
        }
        i = Main.boardService.getStatNode(403);
        while (i != null) {
            nexti = i.getNext();
            Sprite spr = i.get();
            index = i.getIndex();
            short ext = spr.getExtra();
            if (Tekstat.validext(ext) == 0) {
                Tekstat.noextthrowerror(index, 19);
            }
            Tekprep.spriteXT[ext].target = 0;
            int prevx3 = spr.getX();
            int prevy = spr.getY();
            int prevz = spr.getZ();
            dax2 = EngineUtils.sin(spr.getAng() + 512 & 0x7FF) * spr.getXvel() << 3;
            movestat = Tekspr.flymovesprite(index, dax2, day3 = EngineUtils.sin(spr.getAng() & 0x7FF) * spr.getYvel() << 3, 1024, 1024, 0);
            if ((movestat & 0xE0000000) == Integer.MIN_VALUE) {
                Main.engine.setsprite(index, prevx3, prevy, prevz);
                spr.setAng(Tekstat.walldeflect(movestat & 0x1FFFFFFF, spr.getAng()));
                movestat = Tekspr.flymovesprite(index, dax2, day3, 1024, 1024, 0);
            } else if ((movestat & 0xE0000000) == -1073741824) {
                int hitsprite = movestat & 0x1FFFFFFF;
                Main.engine.setsprite(index, prevx3, prevy, prevz);
                int hit = Tekstat.playerhit(hitsprite);
                pnum = playerhit;
                if (hit != 0) {
                    Tekprep.spriteXT[ext].target = pnum;
                    Tekstat.newstatus(index, 300);
                } else {
                    spr.setAng(Tekstat.spritedeflect(hitsprite));
                    movestat = Tekspr.flymovesprite(index, dax2, day3, 1024, 1024, 0);
                }
            }
            if (movestat != 0) {
                spr.setAng(Tekstat.arbitraryangle());
            }
            i = nexti;
        }
        i = Main.boardService.getStatNode(602);
        while (i != null) {
            nexti = i.getNext();
            Sprite spr = i.get();
            index = i.getIndex();
            spr.setHitag(spr.getHitag() - 1);
            if (spr.getHitag() <= 0) {
                Sector sec = Main.boardService.getSector(spr.getSectnum());
                if (sec != null && sec.getLotag() == 4) {
                    Tekstat.splash(index);
                }
                Main.engine.changespritestat(index, 100);
                Tekstat.genexplosion2(index);
                Tekstat.jsdeletesprite(index);
            }
            i = nexti;
        }
        i = Main.boardService.getStatNode(408);
        while (i != null) {
            nexti = i.getNext();
            Sprite spr = i.get();
            index = i.getIndex();
            spr.setHitag(spr.getHitag() + 1);
            if (spr.getHitag() >= 18) {
                spr.setPicnum(spr.getPicnum() + 1);
                spr.setHitag(0);
                spr.setLotag(spr.getLotag() + 1);
            }
            if (spr.getLotag() == 5) {
                Main.engine.changespritestat(index, 0);
            }
            i = nexti;
        }
        i = Main.boardService.getStatNode(406);
        while (i != null) {
            int dist;
            boolean dropsiescontinue = false;
            nexti = i.getNext();
            Sprite spr = i.get();
            int index3 = i.getIndex();
            int dax3 = spr.getXvel() * 3 << 7;
            day2 = spr.getYvel() * 3 << 7;
            daz = 0;
            Tekspr.movesprite(index3, dax3, day2, daz, 1024, 1024, 1);
            spr.setZ(spr.getZ() + spr.getZvel());
            spr.setZvel(spr.getZvel() + 12);
            ArtEntry pic = Main.engine.getTile(spr.getPicnum());
            if (spr.getZ() < Engine.zr_ceilz + (pic.getHeight() / 2 << 6)) {
                spr.setZ(Engine.zr_ceilz + (pic.getHeight() / 2 << 6));
                spr.setZvel((short)(-(spr.getZvel() >> 1)));
            }
            if (spr.getZ() > Engine.zr_florz - (pic.getHeight() / 2 << 6)) {
                spr.setZ(Engine.zr_florz - (pic.getHeight() / 2 << 6));
                spr.setZvel((short)(-(spr.getZvel() >> 1)));
            }
            if ((dist = (dax3 = (int)spr.getXvel()) * dax3 + (day2 = (int)spr.getYvel()) * day2) < 46000) {
                Sector sec = Main.boardService.getSector(spr.getSectnum());
                if (sec != null) {
                    if (sec.getLotag() == 4) {
                        int zoffs = 0;
                        if ((spr.getCstat() & 0x80) == 0) {
                            zoffs = -(pic.getHeight() * spr.getYrepeat() << 1);
                        }
                        spr.setZ(sec.getFloorz() - zoffs);
                        Main.engine.changespritestat(index3, 322);
                        spr.setLotag(0);
                        spr.setHitag(0);
                        spr.setXvel(1);
                        spr.setYvel(1);
                    } else {
                        Main.engine.changespritestat(index3, 0);
                    }
                    spr.setZ(sec.getFloorz());
                    spr.setZ(spr.getZ() - (pic.getHeight() / 2 << 6));
                }
                dropsiescontinue = true;
            }
            if (!dropsiescontinue && Pragmas.mulscale(Tektag.krand_intercept("STAT2934"), dist, 30) == 0) {
                spr.setXvel(spr.getXvel() - Pragmas.ksgn(spr.getXvel()));
                spr.setYvel(spr.getYvel() - Pragmas.ksgn(spr.getYvel()));
                spr.setZvel(spr.getZvel() - Pragmas.ksgn(spr.getZvel()));
            }
            i = nexti;
        }
        i = Main.boardService.getStatNode(7);
        while (i != null) {
            nexti = i.getNext();
            Sprite spr = i.get();
            int index4 = i.getIndex();
            Main.game.pInt.setsprinterpolate(index4, spr);
            spr.setX(spr.getX() + (spr.getXvel() * 3 >> 4));
            spr.setY(spr.getY() + (spr.getYvel() * 3 >> 4));
            spr.setZ(spr.getZ() + (spr.getZvel() * 3 >> 4));
            spr.setZvel(spr.getZvel() + 384);
            Sector sec = Main.boardService.getSector(spr.getSectnum());
            if (sec != null) {
                if (spr.getZ() < sec.getCeilingz() + 1024) {
                    spr.setZ(sec.getCeilingz() + 1024);
                    spr.setZvel((short)(-(spr.getZvel() >> 1)));
                }
                if (spr.getZ() > sec.getFloorz() - 1024) {
                    spr.setZ(sec.getFloorz() - 1024);
                    spr.setZvel((short)(-(spr.getZvel() >> 1)));
                }
            }
            spr.setXrepeat((byte)(spr.getLotag() >> 2));
            spr.setYrepeat((byte)(spr.getLotag() >> 2));
            spr.setLotag(spr.getLotag() - 3);
            if (spr.getLotag() < 0) {
                Tekstat.jsdeletesprite(index4);
            }
            i = nexti;
        }
        i = Main.boardService.getStatNode(402);
        while (i != null) {
            short ext;
            int hitsprite;
            Sprite spr2;
            int dax4;
            boolean tosscontinue = false;
            nexti = i.getNext();
            Sprite spr = i.get();
            int index5 = i.getIndex();
            int movestat2 = Tekspr.kenmovesprite(index5, dax4 = spr.getXvel() * 3 << 11, day2 = spr.getYvel() * 3 << 11, daz = 0, 1024, 1024, 1);
            if ((movestat2 & 0xE0000000) == -1073741824 && (spr2 = Main.boardService.getSprite(hitsprite = movestat2 & 0x1FFFFFFF)) != null && Tekstat.validext(ext = spr2.getExtra()) != 0 && Tekprep.spriteXT[ext].deathpic != 0 && spr2.getStatnum() == 0) {
                Tekstat.damagesprite(hitsprite, 20);
            }
            spr.setZ(spr.getZ() + spr.getZvel());
            spr.setZvel(spr.getZvel() + 96);
            ArtEntry pic = Main.engine.getTile(423);
            if (spr.getZ() < Engine.zr_ceilz + (pic.getHeight() << 6)) {
                spr.setZ(Engine.zr_ceilz + (pic.getHeight() << 6));
                spr.setZvel((short)(-(spr.getZvel() >> 1)));
            }
            if (spr.getZ() > Engine.zr_florz - (pic.getHeight() << 4)) {
                switch (Engine.zr_florhit & 0xE0000000) {
                    case -1073741824: {
                        int hitsprite2 = Engine.zr_florhit & 0x1FFFFFFF;
                        Sprite spr22 = Main.boardService.getSprite(hitsprite2);
                        if (spr22 == null) break;
                        int hit = Tekstat.playerhit(hitsprite2);
                        pnum = playerhit;
                        if (hit != 0) {
                            Tekchng.changehealth(pnum, -40);
                            break;
                        }
                        if (spr22.getExtra() == -1) break;
                        Teksnd.playsound(107, spr22.getX(), spr22.getY(), 0, 4);
                        Tekstat.damagesprite(hitsprite2, 10);
                        break;
                    }
                    case 0x40000000: {
                        Sector hitSector = Main.boardService.getSector(Engine.zr_florhit & 0x1FFFFFFF);
                        if (hitSector == null || hitSector.getLotag() != 4 || spr.getPicnum() == 299) break;
                        int zoffs = 0;
                        if ((spr.getCstat() & 0x80) == 0) {
                            zoffs = -(Main.engine.getTile(spr.getPicnum()).getHeight() * spr.getYrepeat() << 1);
                        }
                        Main.game.pInt.setsprinterpolate(index5, spr);
                        Sector sec = Main.boardService.getSector(spr.getSectnum());
                        if (sec != null) {
                            spr.setZ(sec.getFloorz() - zoffs);
                        }
                        Tekstat.splash(index5);
                        switch (spr.getPicnum()) {
                            case 466: {
                                spr.setPicnum(467);
                                spr.setHitag((short)(Tektag.krand_intercept("STAT3031") & 0xFF));
                                Main.engine.changespritestat(index5, 602);
                                break;
                            }
                            case 469: {
                                spr.setHitag((short)(Tektag.krand_intercept("STAT3035") & 0xFF));
                                spr.setPicnum(470);
                                Main.engine.changespritestat(index5, 602);
                                break;
                            }
                            default: {
                                spr.setLotag(0);
                                spr.setHitag(0);
                                spr.setXvel(1);
                                spr.setYvel(1);
                                Main.engine.changespritestat(index5, 322);
                            }
                        }
                        tosscontinue = true;
                        break;
                    }
                }
                if (!tosscontinue) {
                    Main.game.pInt.setsprinterpolate(index5, spr);
                    spr.setZ(Engine.zr_florz - (pic.getHeight() << 4));
                    spr.setZvel((short)(-(spr.getZvel() >> 1)));
                    spr.setHitag(spr.getHitag() + 1);
                }
            }
            if (!tosscontinue) {
                dax4 = spr.getXvel();
                day2 = spr.getYvel();
                int dist = dax4 * dax4 + day2 * day2;
                if (Pragmas.mulscale(Tektag.krand_intercept("STAT3057"), dist, 30) == 0) {
                    spr.setXvel(spr.getXvel() - Pragmas.ksgn(spr.getXvel()));
                    spr.setYvel(spr.getYvel() - Pragmas.ksgn(spr.getYvel()));
                    spr.setZvel(spr.getZvel() - Pragmas.ksgn(spr.getZvel()));
                }
                if (spr.getHitag() >= 3) {
                    switch (spr.getPicnum()) {
                        case 299: {
                            ext = spr.getExtra();
                            if (Tekstat.validext(ext) == 0) {
                                Tekstat.jsdeletesprite(index5);
                                break;
                            }
                            Main.game.pInt.setsprinterpolate(index5, spr);
                            Sector sec = Main.boardService.getSector(spr.getSectnum());
                            if (sec != null) {
                                spr.setZ(sec.getFloorz());
                            }
                            spr.setAng(Tekstat.arbitraryangle());
                            spr.setPicnum(260);
                            Tekprep.spriteXT[ext].basestat = (short)502;
                            Tekstat.newstatus(index5, 502);
                            spr.setXvel(4);
                            spr.setYvel(4);
                            spr.setZvel(0);
                            spr.setLotag(2004);
                            spr.setHitag(0);
                            break;
                        }
                        case 466: {
                            spr.setPicnum(467);
                            spr.setHitag((short)(Tektag.krand_intercept("STAT3083") & 0xFF));
                            Main.engine.changespritestat(index5, 602);
                            break;
                        }
                        case 469: {
                            spr.setPicnum(470);
                            spr.setHitag((short)(Tektag.krand_intercept("STAT3088") & 0xFF));
                            Main.engine.changespritestat(index5, 602);
                            break;
                        }
                        default: {
                            spr.setXvel(0);
                            spr.setYvel(0);
                            spr.setZvel(0);
                            spr.setLotag(2004);
                            Sector sec = Main.boardService.getSector(spr.getSectnum());
                            if (sec == null) break;
                            if (Engine.zr_florz != sec.getFloorz()) {
                                Main.game.pInt.setsprinterpolate(index5, spr);
                                spr.setZ(Engine.zr_florz);
                                Main.engine.changespritestat(index5, 610);
                                break;
                            }
                            Main.engine.changespritestat(index5, 0);
                            break;
                        }
                    }
                }
            }
            i = nexti;
        }
        i = Main.boardService.getStatNode(202);
        while (i != null) {
            boolean ambushcontinue = false;
            nexti = i.getNext();
            Sprite spr = i.get();
            int index6 = i.getIndex();
            short ext = spr.getExtra();
            if (Tekstat.validext(ext) == 0) {
                Tekstat.noextthrowerror(index6, 1);
            }
            mindist = Integer.MAX_VALUE;
            target = Mmulti.connecthead;
            short p = Mmulti.connecthead;
            while (p >= 0) {
                int dist = Math.abs(spr.getX() - Player.gPlayer[p].posx) + Math.abs(spr.getY() - Player.gPlayer[p].posy);
                if (dist < mindist) {
                    mindist = dist;
                    target = p;
                }
                p = Mmulti.connectpoint2[p];
            }
            if (mindist > 20480) {
                ambushcontinue = true;
            }
            if (!ambushcontinue) {
                Tekprep.spriteXT[ext].target = target;
                if ((Tekprep.spriteXT[index6].aimask & 4) != 0 || Tekstat.isvisible(index6, target)) {
                    if (Tekprep.spriteXT[ext].morphpic != 0) {
                        Tekstat.newstatus(index6, 304);
                    } else {
                        Tekstat.ambushyell(index6, spr.getExtra());
                        Tekstat.newstatus(index6, Tekprep.spriteXT[ext].basestat);
                    }
                }
            }
            Tekprep.spriteXT[ext].aimask &= 0xFFFFFFFB;
            Tekprep.spriteXT[ext].aimask &= 0xFFFFFFEF;
            i = nexti;
        }
        i = Main.boardService.getStatNode(204);
        while (i != null) {
            block302: {
                Sector sec;
                short prevsect3;
                int prevz;
                int prevy;
                int prevx4;
                int index7;
                Sprite spr;
                block304: {
                    int movestat3;
                    int day4;
                    int daang;
                    block303: {
                        boolean stalkcontinue = false;
                        nexti = i.getNext();
                        spr = i.get();
                        index7 = i.getIndex();
                        short ext = spr.getExtra();
                        if (Tekstat.validext(ext) == 0) {
                            Tekstat.noextthrowerror(index7, 2);
                        }
                        mindist = Integer.MAX_VALUE;
                        target = Mmulti.connecthead;
                        short p = Mmulti.connecthead;
                        while (p >= 0) {
                            int dist = Math.abs(spr.getX() - Player.gPlayer[p].posx) + Math.abs(spr.getY() - Player.gPlayer[p].posy);
                            if (dist < mindist) {
                                mindist = dist;
                                target = p;
                            }
                            p = Mmulti.connectpoint2[p];
                        }
                        if (mindist > 20480) {
                            stalkcontinue = true;
                        }
                        if (stalkcontinue) break block302;
                        Tekprep.spriteXT[ext].target = target;
                        int targx = Player.gPlayer[target].posx;
                        int targy = Player.gPlayer[target].posy;
                        prevx4 = spr.getX();
                        prevy = spr.getY();
                        prevz = spr.getZ();
                        prevsect3 = spr.getSectnum();
                        daang = EngineUtils.getAngle(targx - spr.getX(), targy - spr.getY()) & 0x7FF;
                        if ((Tekprep.spriteXT[ext].aimask & 0x10) == 0) break block303;
                        if ((spr.getAng() + 2048 - daang & 0x7FF) < 1024) {
                            spr.setAng((short)(spr.getAng() + 2048 - 6 & 0x7FF));
                        } else {
                            spr.setAng((short)(spr.getAng() + 6 & 0x7FF));
                        }
                        if (Tekstat.RMOD16("STAT3291") == 0) {
                            Tekstat.attackifclose(index7, target, mindist);
                        }
                        if (spr.getStatnum() != 300) {
                            int dax5 = EngineUtils.sin(spr.getAng() + 512 & 0x7FF) * spr.getXvel() << 3;
                            day4 = EngineUtils.sin(spr.getAng() & 0x7FF) * spr.getYvel() << 3;
                            movestat3 = Tekspr.movesprite(index7, dax5, day4, 0, 1024, 1024, 2);
                            switch (movestat3 & 0xE0000000) {
                                case -2147483648: {
                                    spr.setAng(Tekstat.walldeflect(movestat3 & 0x1FFFFFFF, spr.getAng()));
                                    break;
                                }
                                case -1073741824: {
                                    spr.setAng(Tekstat.spritedeflect(movestat3 & 0x1FFFFFFF));
                                    break;
                                }
                                case 0x40000000: {
                                    spr.setAng(Tekstat.arbitraryangle());
                                    break;
                                }
                            }
                            if (movestat3 != 0 && (movestat3 = Tekspr.movesprite(index7, dax5 = EngineUtils.sin(spr.getAng() + 512 & 0x7FF) * spr.getXvel() << 3, day4 = EngineUtils.sin(spr.getAng() & 0x7FF) * spr.getYvel() << 3, 0, 1024, 1024, 2)) != 0) {
                                spr.setAng(Tekstat.arbitraryangle());
                            }
                        }
                        break block304;
                    }
                    if ((spr.getAng() + 2048 - daang & 0x7FF) < 1024) {
                        spr.setAng((short)(spr.getAng() + 2048 - 6 & 0x7FF));
                    } else {
                        spr.setAng((short)(spr.getAng() + 6 & 0x7FF));
                    }
                    int dax6 = EngineUtils.sin(spr.getAng() + 512 & 0x7FF) * spr.getXvel() << 4;
                    day4 = EngineUtils.sin(spr.getAng() & 0x7FF) * spr.getYvel() << 4;
                    movestat3 = Tekspr.movesprite(index7, dax6, day4, 0, 1024, 1024, 2);
                    switch (movestat3 & 0xE0000000) {
                        case -2147483648: {
                            Tekstat.newstatus(index7, 305);
                            spr.setAng(Tekstat.walldeflect(movestat3 & 0x1FFFFFFF, spr.getAng()));
                            break;
                        }
                        case -1073741824: {
                            Tekstat.newstatus(index7, 305);
                            spr.setAng(Tekstat.spritedeflect(movestat3 & 0x1FFFFFFF));
                            break;
                        }
                        case 0x40000000: {
                            spr.setAng(Tekstat.arbitraryangle());
                            break;
                        }
                    }
                    if (movestat3 != 0 && (movestat3 = Tekspr.movesprite(index7, dax6 = EngineUtils.sin(spr.getAng() + 512 & 0x7FF) * spr.getXvel() << 3, day4 = EngineUtils.sin(spr.getAng() & 0x7FF) * spr.getYvel() << 3, 0, 1024, 1024, 2)) != 0) {
                        spr.setAng(Tekstat.arbitraryangle());
                    }
                }
                if (spr.getSectnum() != prevsect3 && (sec = Main.boardService.getSector(spr.getSectnum())) != null) {
                    if (sec.getLotag() == 5055) {
                        Main.engine.setsprite(index7, prevx4, prevy, prevz);
                        spr.setAng(Tekstat.arbitraryangle());
                    } else {
                        Tekstat.enemynewsector(index7);
                    }
                }
            }
            Tekprep.spriteXT[ext].aimask &= 0xFFFFFFFB;
            Tekprep.spriteXT[ext].aimask &= 0xFFFFFFEF;
            i = nexti;
        }
        ListNode<Sprite> node = Main.boardService.getStatNode(206);
        while (node != null) {
            block306: {
                Sector sec;
                int prevz;
                int prevy;
                int index8;
                Sprite spr;
                block309: {
                    int movestat4;
                    int day5;
                    block308: {
                        int daang;
                        int targsect;
                        int targz;
                        int targy;
                        int targx;
                        int dist;
                        block307: {
                            short ext;
                            block305: {
                                nexti = node.getNext();
                                spr = node.get();
                                index8 = node.getIndex();
                                ext = spr.getExtra();
                                if (Tekstat.validext(ext) == 0) {
                                    Tekstat.noextthrowerror(index8, 3);
                                }
                                mindist = Integer.MAX_VALUE;
                                target = Mmulti.connecthead;
                                short p = Mmulti.connecthead;
                                while (p >= 0) {
                                    int dist2 = Math.abs(spr.getX() - Player.gPlayer[p].posx) + Math.abs(spr.getY() - Player.gPlayer[p].posy);
                                    if (dist2 < mindist) {
                                        mindist = dist2;
                                        target = p;
                                    }
                                    p = Mmulti.connectpoint2[p];
                                }
                                if (mindist <= 20480) break block305;
                                Tekprep.spriteXT[ext].aimask &= 0xFFFFFFFB;
                                Tekprep.spriteXT[ext].aimask &= 0xFFFFFFEF;
                                break block306;
                            }
                            dist = mindist;
                            Tekprep.spriteXT[ext].target = target;
                            targx = Player.gPlayer[target].posx;
                            targy = Player.gPlayer[target].posy;
                            targz = Player.gPlayer[target].posz;
                            targsect = Player.gPlayer[target].cursectnum;
                            prevx = spr.getX();
                            prevy = spr.getY();
                            prevz = spr.getZ();
                            prevsect = spr.getSectnum();
                            daang = EngineUtils.getAngle(targx - spr.getX(), targy - spr.getY()) & 0x7FF;
                            if (Main.game.nNetMode == BuildGame.NetMode.Multiplayer || (Tekprep.spriteXT[ext].aimask & 8) == 0 || (Tekprep.spriteXT[ext].fxmask & 0xC) != 0) break block307;
                            spr.setAng((short)(daang + 1024 & 0x7FF));
                            Tekstat.newstatus(index8, 205);
                            if (spr.getStatnum() != 205) break block307;
                            Tekprep.spriteXT[ext].aimask &= 0xFFFFFFFB;
                            Tekprep.spriteXT[ext].aimask &= 0xFFFFFFEF;
                            break block306;
                        }
                        boolean seecan = false;
                        if (spr.getSectnum() >= 0 && targsect >= 0 && Main.engine.cansee(targx, targy, targz, targsect, spr.getX(), spr.getY(), spr.getZ() - (Main.engine.getTile(spr.getPicnum()).getHeight() << 6), spr.getSectnum())) {
                            seecan = true;
                        }
                        if ((spr.getAng() + 2048 - daang & 0x7FF) < 1024) {
                            spr.setAng((short)(spr.getAng() + 2048 - 6 & 0x7FF));
                        } else {
                            spr.setAng((short)(spr.getAng() + 6 & 0x7FF));
                        }
                        if (!seecan) break block308;
                        if (Tekstat.RMOD4("STAT3427") == 0) {
                            Tekstat.attackifclose(index8, target, dist);
                        }
                        if (spr.getStatnum() != 300) {
                            int dax7 = EngineUtils.sin(spr.getAng() + 512 & 0x7FF) * spr.getXvel() << 3;
                            day5 = EngineUtils.sin(spr.getAng() & 0x7FF) * spr.getYvel() << 3;
                            movestat4 = Tekspr.movesprite(index8, dax7, day5, 0, 1024, 1024, 2);
                            switch (movestat4 & 0xE0000000) {
                                case -2147483648: {
                                    spr.setAng(Tekstat.walldeflect(movestat4 & 0x1FFFFFFF, spr.getAng()));
                                    break;
                                }
                                case -1073741824: {
                                    spr.setAng(Tekstat.spritedeflect(movestat4 & 0x1FFFFFFF));
                                    break;
                                }
                                case 0x40000000: {
                                    spr.setAng(Tekstat.arbitraryangle());
                                    break;
                                }
                            }
                            if (movestat4 != 0 && (movestat4 = Tekspr.movesprite(index8, dax7 = EngineUtils.sin(spr.getAng() + 512 & 0x7FF) * spr.getXvel() << 3, day5 = EngineUtils.sin(spr.getAng() & 0x7FF) * spr.getYvel() << 3, 0, 1024, 1024, 2)) != 0) {
                                spr.setAng(Tekstat.arbitraryangle());
                            }
                        }
                        break block309;
                    }
                    int dax8 = EngineUtils.sin(spr.getAng() + 512 & 0x7FF) * spr.getXvel() << 3;
                    day5 = EngineUtils.sin(spr.getAng() & 0x7FF) * spr.getYvel() << 3;
                    movestat4 = Tekspr.movesprite(index8, dax8, day5, 0, 1024, 1024, 2);
                    switch (movestat4 & 0xE0000000) {
                        case -2147483648: {
                            Tekstat.newstatus(index8, 305);
                            spr.setAng(Tekstat.walldeflect(movestat4 & 0x1FFFFFFF, spr.getAng()));
                            break;
                        }
                        case -1073741824: {
                            Tekstat.newstatus(index8, 305);
                            spr.setAng(Tekstat.spritedeflect(movestat4 & 0x1FFFFFFF));
                            break;
                        }
                        case 0x40000000: {
                            spr.setAng(Tekstat.arbitraryangle());
                            break;
                        }
                    }
                    if (movestat4 != 0 && (movestat4 = Tekspr.movesprite(index8, dax8 = EngineUtils.sin(spr.getAng() + 512 & 0x7FF) * spr.getXvel() << 3, day5 = EngineUtils.sin(spr.getAng() & 0x7FF) * spr.getYvel() << 3, 0, 1024, 1024, 2)) != 0) {
                        spr.setAng(Tekstat.arbitraryangle());
                    }
                }
                if (spr.getSectnum() != prevsect && (sec = Main.boardService.getSector(spr.getSectnum())) != null) {
                    if (sec.getLotag() == 5055) {
                        Main.engine.setsprite(index8, prevx, prevy, prevz);
                        spr.setAng(Tekstat.arbitraryangle());
                    } else {
                        Tekstat.enemynewsector(index8);
                    }
                }
                Tekprep.spriteXT[ext].aimask &= 0xFFFFFFFB;
                Tekprep.spriteXT[ext].aimask &= 0xFFFFFFEF;
            }
            node = nexti;
        }
        node = Main.boardService.getStatNode(203);
        while (node != null) {
            block311: {
                int prevz;
                int prevy;
                int index9;
                Sprite spr;
                block315: {
                    int movestat5;
                    int targsect;
                    int targz;
                    int targy;
                    int targx;
                    block314: {
                        short ext;
                        block313: {
                            int dist;
                            block312: {
                                block310: {
                                    nexti = node.getNext();
                                    spr = node.get();
                                    index9 = node.getIndex();
                                    ext = spr.getExtra();
                                    if (Tekstat.validext(ext) == 0) {
                                        Tekstat.noextthrowerror(index9, 4);
                                    }
                                    mindist = Integer.MAX_VALUE;
                                    target = Mmulti.connecthead;
                                    short p = Mmulti.connecthead;
                                    while (p >= 0) {
                                        int dist3 = Math.abs(spr.getX() - Player.gPlayer[p].posx) + Math.abs(spr.getY() - Player.gPlayer[p].posy);
                                        if (dist3 < mindist) {
                                            mindist = dist3;
                                            target = p;
                                        }
                                        p = Mmulti.connectpoint2[p];
                                    }
                                    if (mindist <= 20480) break block310;
                                    Tekprep.spriteXT[ext].aimask &= 0xFFFFFFFB;
                                    Tekprep.spriteXT[ext].aimask &= 0xFFFFFFEF;
                                    break block311;
                                }
                                dist = mindist;
                                Tekprep.spriteXT[ext].target = target;
                                targx = Player.gPlayer[target].posx;
                                targy = Player.gPlayer[target].posy;
                                targz = Player.gPlayer[target].posz;
                                targsect = Player.gPlayer[target].cursectnum;
                                prevx = spr.getX();
                                prevy = spr.getY();
                                prevz = spr.getZ();
                                prevsect = spr.getSectnum();
                                if ((Tekprep.spriteXT[ext].aimask & 4) == 0) break block312;
                                if (Main.engine.cansee(targx, targy, targz, targsect, spr.getX(), spr.getY(), spr.getZ() - (Main.engine.getTile(spr.getPicnum()).getHeight() << 7), spr.getSectnum())) {
                                    spr.setAng(EngineUtils.getAngle(targx - spr.getX(), targy - spr.getY()));
                                    Tekprep.spriteXT[ext].aimask |= 0x20;
                                }
                                Tekprep.spriteXT[ext].aimask &= 0xFFFFFFFB;
                                Tekprep.spriteXT[ext].aimask &= 0xFFFFFFEF;
                                break block311;
                            }
                            if (Player.gPlayer[target].drawweap == 0 || !Tekstat.isvisible(index9, target) || (Tekprep.spriteXT[ext].aimask & 0xA0) != 0) break block313;
                            Tekstat.givewarning(index9, ext);
                            spr.setAng(EngineUtils.getAngle(targx - spr.getX(), targy - spr.getY()));
                            spr.setPicnum((short)(Tekprep.spriteXT[ext].attackpic + 1));
                            if (dist < 1024) {
                                Tekstat.newstatus(index9, 300);
                            }
                            Tekprep.spriteXT[ext].aimask &= 0xFFFFFFFB;
                            Tekprep.spriteXT[ext].aimask &= 0xFFFFFFEF;
                            break block311;
                        }
                        spr.setPicnum((short)Tekprep.spriteXT[ext].basepic);
                        if ((Tekprep.spriteXT[ext].aimask & 0xA0) != 0) break block314;
                        Tekprep.spriteXT[ext].aimask &= 0xFFFFFFBF;
                        if (Tekstat.RMOD16("STAT3561") == 0) {
                            spr.setAng(EngineUtils.getAngle(targx - spr.getX(), targy - spr.getY()));
                            Tekstat.newstatus(index9, 201);
                            break block315;
                        } else {
                            dax = EngineUtils.sin(spr.getAng() + 512 & 0x7FF) * spr.getXvel() << 3;
                            movestat5 = Tekspr.movesprite(index9, dax, day = EngineUtils.sin(spr.getAng() & 0x7FF) * spr.getYvel() << 3, 0, 1024, 1024, 2);
                            if (movestat5 != 0) {
                                spr.setAng(Tekstat.arbitraryangle());
                            }
                        }
                        break block315;
                    }
                    if (Tekstat.RMOD4("STAT3575") == 0 && Main.engine.cansee(targx, targy, targz, targsect, spr.getX(), spr.getY(), spr.getZ() - (Main.engine.getTile(spr.getPicnum()).getHeight() << 7), spr.getSectnum())) {
                        spr.setAng(EngineUtils.getAngle(targx - spr.getX(), targy - spr.getY()));
                        Tekstat.newstatus(index9, 300);
                    } else {
                        dax = EngineUtils.sin(spr.getAng() + 512 & 0x7FF) * (spr.getXvel() + 2) << 3;
                        movestat5 = Tekspr.movesprite(index9, dax, day = EngineUtils.sin(spr.getAng() & 0x7FF) * (spr.getYvel() + 2) << 3, 0, 1024, 1024, 2);
                        if (movestat5 != 0) {
                            spr.setAng(Tekstat.arbitraryangle());
                        }
                    }
                }
                if (prevsect != spr.getSectnum()) {
                    Main.engine.setsprite(index9, prevx, prevy, prevz);
                    spr.setAng(Tekstat.arbitraryangle());
                }
                Tekprep.spriteXT[ext].aimask &= 0xFFFFFFFB;
                Tekprep.spriteXT[ext].aimask &= 0xFFFFFFEF;
            }
            node = nexti;
        }
        i = Main.boardService.getStatNode(205);
        while (i != null) {
            block316: {
                Sector sec;
                short prevsect4;
                int prevz;
                int prevy;
                int prevx5;
                int index10;
                Sprite spr;
                block317: {
                    block318: {
                        boolean fleecontinue = false;
                        nexti = i.getNext();
                        spr = i.get();
                        index10 = i.getIndex();
                        short ext = spr.getExtra();
                        if (Tekstat.validext(ext) == 0) {
                            Tekstat.noextthrowerror(index10, 5);
                        }
                        mindist = Integer.MAX_VALUE;
                        target = Mmulti.connecthead;
                        short p = Mmulti.connecthead;
                        while (p >= 0) {
                            int dist = Math.abs(spr.getX() - Player.gPlayer[p].posx) + Math.abs(spr.getY() - Player.gPlayer[p].posy);
                            if (dist < mindist) {
                                mindist = dist;
                                target = p;
                            }
                            p = Mmulti.connectpoint2[p];
                        }
                        if (Player.gPlayer[target].drawweap == 0 || mindist > 20480) {
                            Tekstat.newstatus(index10, Tekprep.spriteXT[ext].basestat);
                            fleecontinue = true;
                        }
                        if (fleecontinue) break block316;
                        Tekprep.spriteXT[ext].target = target;
                        int targx = Player.gPlayer[target].posx;
                        int targy = Player.gPlayer[target].posy;
                        int targz = Player.gPlayer[target].posz;
                        int targsect = Player.gPlayer[target].cursectnum;
                        prevx5 = spr.getX();
                        prevy = spr.getY();
                        prevz = spr.getZ();
                        prevsect4 = spr.getSectnum();
                        int FLEESPEED = 5;
                        dax = EngineUtils.sin(spr.getAng() + 512 & 0x7FF) * FLEESPEED << 3;
                        int movestat6 = Tekspr.movesprite(index10, dax, day = EngineUtils.sin(spr.getAng() & 0x7FF) * FLEESPEED << 3, 0, 1024, 1024, 2);
                        if (movestat6 == 0) break block317;
                        switch (movestat6 & 0xE0000000) {
                            case -2147483648: {
                                spr.setAng(Tekstat.walldeflect(movestat6 & 0x1FFFFFFF, spr.getAng()));
                                break;
                            }
                            case -1073741824: {
                                spr.setAng(Tekstat.spritedeflect(movestat6 & 0x1FFFFFFF));
                                break;
                            }
                            case 0x40000000: {
                                spr.setAng(Tekstat.arbitraryangle());
                                break;
                            }
                        }
                        if (!Main.engine.cansee(targx, targy, targz, targsect, spr.getX(), spr.getY(), spr.getZ() - (Main.engine.getTile(spr.getPicnum()).getHeight() << 7), spr.getSectnum())) break block318;
                        Tekstat.attackifclose(index10, target, mindist);
                        if (spr.getStatnum() != 300) {
                            int daang = EngineUtils.getAngle(targx - spr.getX(), targy - spr.getY());
                            spr.setAng((short)(daang + 1024 & 0x7FF));
                            movestat6 = Tekspr.movesprite(index10, dax, day, 0, 1024, 1024, 2);
                            if (movestat6 != 0 && Tekstat.RMOD2("STAT3663") != 0) {
                                Tekstat.newstatus(index10, 311);
                            }
                        }
                        break block317;
                    }
                    if (Tekstat.RMOD3("STAT3668") == 0) {
                        Tekstat.newstatus(index10, 311);
                    }
                }
                if (spr.getSectnum() != prevsect4 && (sec = Main.boardService.getSector(spr.getSectnum())) != null) {
                    if (sec.getLotag() == 5055) {
                        Main.engine.setsprite(index10, prevx5, prevy, prevz);
                        spr.setAng(Tekstat.arbitraryangle());
                    } else {
                        Tekstat.enemynewsector(index10);
                    }
                }
            }
            Tekprep.spriteXT[ext].aimask &= 0xFFFFFFFB;
            Tekprep.spriteXT[ext].aimask &= 0xFFFFFFEF;
            i = nexti;
        }
        node = Main.boardService.getStatNode(209);
        while (node != null) {
            nexti = node.getNext();
            Sprite spr = node.get();
            int index11 = node.getIndex();
            short ext = spr.getExtra();
            if (Tekstat.validext(ext) == 0) {
                Tekstat.noextthrowerror(index11, 6);
            }
            mindist = Integer.MAX_VALUE;
            target = Mmulti.connecthead;
            short p = Mmulti.connecthead;
            while (p >= 0) {
                int dist = Math.abs(spr.getX() - Player.gPlayer[p].posx) + Math.abs(spr.getY() - Player.gPlayer[p].posy);
                if (dist < mindist) {
                    mindist = dist;
                    target = p;
                }
                p = Mmulti.connectpoint2[p];
            }
            if (mindist > 20480) {
                Tekprep.spriteXT[ext].aimask &= 0xFFFFFFFB;
                Tekprep.spriteXT[ext].aimask &= 0xFFFFFFEF;
            } else {
                int daang;
                int dist = mindist;
                Tekprep.spriteXT[ext].target = target;
                int prevx6 = spr.getX();
                int prevy = spr.getY();
                int prevz = spr.getZ();
                short prevsect5 = spr.getSectnum();
                if ((Tekprep.spriteXT[ext].aimask & 4) != 0) {
                    Tekstat.attackifclose(index11, target, dist);
                    if (spr.getStatnum() != 300) {
                        daang = EngineUtils.getAngle(Player.gPlayer[target].posx - spr.getX(), Player.gPlayer[target].posy - spr.getY()) & 0x7FF;
                        spr.setAng(daang + 1024 & 0x7FF);
                        Tekstat.fleescream(index11, ext);
                        Tekstat.newstatus(index11, 205);
                    }
                    Tekprep.spriteXT[ext].aimask &= 0xFFFFFFFB;
                    Tekprep.spriteXT[ext].aimask &= 0xFFFFFFEF;
                } else if (Player.gPlayer[target].drawweap != 0 && Tekstat.isvisible(index11, target)) {
                    daang = EngineUtils.getAngle(Player.gPlayer[target].posx - spr.getX(), Player.gPlayer[target].posy - spr.getY()) & 0x7FF;
                    spr.setAng(daang + 1024 & 0x7FF);
                    if (dist < 4096) {
                        Tekstat.newstatus(index11, 311);
                    }
                    if (spr.getStatnum() == 311) {
                        Tekstat.hideplea(index11, ext);
                    } else {
                        Tekstat.fleescream(index11, ext);
                        Tekstat.newstatus(index11, 205);
                    }
                    Tekprep.spriteXT[ext].aimask &= 0xFFFFFFFB;
                    Tekprep.spriteXT[ext].aimask &= 0xFFFFFFEF;
                } else {
                    Sector sec;
                    int day6;
                    int dax9 = EngineUtils.sin(spr.getAng() + 512 & 0x7FF) * spr.getXvel() << 3;
                    int movestat7 = Tekspr.movesprite(index11, dax9, day6 = EngineUtils.sin(spr.getAng() & 0x7FF) * spr.getYvel() << 3, 0, 1024, 1024, 2);
                    if (movestat7 != 0 && (sec = Main.boardService.getSector(spr.getSectnum())) != null) {
                        if (Tekstat.RMOD10("STAT3757") == 0 && sec.getLotag() != 5040) {
                            spr.setAng((short)(spr.getAng() + 1024 & 0x7FF));
                            Tekstat.newstatus(index11, 201);
                        } else {
                            switch (movestat7 & 0xE0000000) {
                                case -2147483648: {
                                    spr.setAng(Tekstat.walldeflect(movestat7 & 0x1FFFFFFF, spr.getAng()));
                                    break;
                                }
                                case -1073741824: {
                                    spr.setAng(Tekstat.spritedeflect(movestat7 & 0x1FFFFFFF));
                                    break;
                                }
                                case 0x40000000: {
                                    spr.setAng(Tekstat.arbitraryangle());
                                    break;
                                }
                            }
                        }
                    }
                    if (spr.getSectnum() != prevsect5 && (sec = Main.boardService.getSector(spr.getSectnum())) != null) {
                        if (sec.getLotag() == 5050 || sec.getLotag() == 5055) {
                            Main.engine.setsprite(index11, prevx6, prevy, prevz);
                            spr.setAng(Tekstat.arbitraryangle());
                        } else {
                            Tekstat.enemynewsector(index11);
                        }
                    }
                    Tekprep.spriteXT[ext].aimask &= 0xFFFFFFFB;
                    Tekprep.spriteXT[ext].aimask &= 0xFFFFFFEF;
                }
            }
            node = nexti;
        }
        i = Main.boardService.getStatNode(500);
        while (i != null) {
            block319: {
                int index12;
                block320: {
                    int day7;
                    int dax10;
                    int movestat8;
                    boolean flycontinue = false;
                    nexti = i.getNext();
                    Sprite spr = i.get();
                    index12 = i.getIndex();
                    short ext = spr.getExtra();
                    if (Tekstat.validext(ext) == 0) {
                        Tekstat.noextthrowerror(index12, 7);
                    }
                    mindist = Integer.MAX_VALUE;
                    target = Mmulti.connecthead;
                    short p = Mmulti.connecthead;
                    while (p >= 0) {
                        int dist = Math.abs(spr.getX() - Player.gPlayer[p].posx) + Math.abs(spr.getY() - Player.gPlayer[p].posy);
                        if (dist < mindist) {
                            mindist = dist;
                            target = p;
                        }
                        p = Mmulti.connectpoint2[p];
                    }
                    if (mindist > 20480) {
                        flycontinue = true;
                    }
                    if (flycontinue) break block319;
                    Tekprep.spriteXT[ext].target = target;
                    if (Tekprep.spriteXT[ext].basepic != 562 && (movestat8 = Tekspr.flymovesprite(index12, dax10 = EngineUtils.sin(spr.getAng() + 512 & 0x7FF) * (spr.getXvel() << 1) << 3, day7 = EngineUtils.sin(spr.getAng() & 0x7FF) * (spr.getYvel() << 1) << 3, 1024, 1024, 0)) != 0) {
                        spr.setAng(Tekstat.arbitraryangle());
                    }
                    if (Player.gPlayer[target].cursectnum < 0 || !Main.engine.cansee(Player.gPlayer[target].posx, Player.gPlayer[target].posy, Player.gPlayer[target].posz, Player.gPlayer[target].cursectnum, spr.getX(), spr.getY(), spr.getZ() - (Main.engine.getTile(spr.getPicnum()).getHeight() << 7), spr.getSectnum())) break block319;
                    if (Tekprep.spriteXT[ext].weapon != '\u0000') break block320;
                    if (mindist < 5120) {
                        spr.setAng(EngineUtils.getAngle(Player.gPlayer[target].posx - spr.getX(), Player.gPlayer[target].posy - spr.getY()));
                    }
                    if (mindist < 1024) {
                        spr.setAng(EngineUtils.getAngle(Player.gPlayer[target].posx - spr.getX(), Player.gPlayer[target].posy - spr.getY()));
                        if (Tekstat.RMOD4("STAT3835") == 0) {
                            Tekstat.newstatus(index12, 300);
                        }
                    }
                    break block319;
                }
                Tekstat.attackifclose(index12, target, mindist);
            }
            Tekprep.spriteXT[ext].aimask &= 0xFFFFFFFB;
            Tekprep.spriteXT[ext].aimask &= 0xFFFFFFEF;
            i = nexti;
        }
        i = Main.boardService.getStatNode(502);
        while (i != null) {
            boolean rodentcontinue = false;
            nexti = i.getNext();
            Sprite spr = i.get();
            int index13 = i.getIndex();
            short ext = spr.getExtra();
            if (Tekstat.validext(ext) == 0) {
                Tekstat.noextthrowerror(index13, 3);
            }
            mindist = Integer.MAX_VALUE;
            target = Mmulti.connecthead;
            short p = Mmulti.connecthead;
            while (p >= 0) {
                int dist = Math.abs(spr.getX() - Player.gPlayer[p].posx) + Math.abs(spr.getY() - Player.gPlayer[p].posy);
                if (dist < mindist) {
                    mindist = dist;
                    target = p;
                }
                p = Mmulti.connectpoint2[p];
            }
            if (mindist > 20480) {
                rodentcontinue = true;
            }
            if (!rodentcontinue) {
                int daang = EngineUtils.getAngle(Player.gPlayer[target].posx - spr.getX(), Player.gPlayer[target].posy - spr.getY()) & 0x7FF;
                Tekprep.spriteXT[ext].target = target;
                if ((spr.getAng() + 2048 - daang & 0x7FF) < 1024) {
                    spr.setAng((short)(spr.getAng() + 2048 - 6 & 0x7FF));
                } else {
                    spr.setAng((short)(spr.getAng() + 6 & 0x7FF));
                }
                int dax11 = EngineUtils.sin(spr.getAng() + 512 & 0x7FF) * spr.getXvel() << 3;
                int day8 = EngineUtils.sin(spr.getAng() & 0x7FF) * spr.getYvel() << 3;
                int movestat9 = Tekspr.movesprite(index13, dax11, day8, 0, 1024, 1024, 2);
                switch (movestat9 & 0xE0000000) {
                    case -2147483648: {
                        spr.setAng(Tekstat.walldeflect(movestat9 & 0x1FFFFFFF, spr.getAng()));
                        break;
                    }
                    case -1073741824: {
                        spr.setAng(Tekstat.spritedeflect(movestat9 & 0x1FFFFFFF));
                        break;
                    }
                    case 0x40000000: {
                        spr.setAng(Tekstat.arbitraryangle());
                        break;
                    }
                }
            }
            Tekprep.spriteXT[ext].aimask &= 0xFFFFFFFB;
            Tekprep.spriteXT[ext].aimask &= 0xFFFFFFEF;
            i = nexti;
        }
        i = Main.boardService.getStatNode(201);
        while (i != null) {
            nexti = i.getNext();
            Sprite spr = i.get();
            int index14 = i.getIndex();
            short ext = spr.getExtra();
            if (Tekstat.validext(ext) == 0) {
                Tekstat.noextthrowerror(index14, 8);
            }
            int mindist2 = Integer.MAX_VALUE;
            short target2 = Mmulti.connecthead;
            short p = Mmulti.connecthead;
            while (p >= 0) {
                int dist = Math.abs(spr.getX() - Player.gPlayer[p].posx) + Math.abs(spr.getY() - Player.gPlayer[p].posy);
                if (dist < mindist2) {
                    mindist2 = dist;
                    target2 = p;
                }
                p = Mmulti.connectpoint2[p];
            }
            Sector sec = Main.boardService.getSector(spr.getSectnum());
            if (sec != null && sec.getLotag() == 5040) {
                spr.setLotag(0);
                spr.setHitag(0);
                spr.setPicnum((short)Tekprep.spriteXT[ext].basepic);
                Tekstat.newstatus(index14, Tekprep.spriteXT[ext].basestat);
            }
            if ((Tekprep.spriteXT[ext].aimask & 4) != 0) {
                spr.setLotag(0);
            }
            if ((Tekprep.spriteXT[ext].aimask & 0x80) != 0) {
                spr.setLotag(0);
            }
            if (Player.gPlayer[target2].drawweap != 0 && Tekstat.isvisible(index14, target2)) {
                spr.setLotag(0);
            }
            spr.setLotag(spr.getLotag() - 3);
            if (spr.getLotag() < 0) {
                spr.setLotag(0);
                Tekstat.newstatus(index14, Tekprep.spriteXT[ext].basestat);
            }
            Tekprep.spriteXT[ext].aimask &= 0xFFFFFFFB;
            Tekprep.spriteXT[ext].aimask &= 0xFFFFFFEF;
            i = nexti;
        }
        i = Main.boardService.getStatNode(300);
        while (i != null) {
            nexti = i.getNext();
            Sprite spr = i.get();
            int index15 = i.getIndex();
            short ext = spr.getExtra();
            if (Tekstat.validext(ext) == 0) {
                Tekstat.noextthrowerror(index15, 9);
            }
            if (spr.getLotag() == spr.getHitag()) {
                Tekstat.enemyshootgun(index15, spr.getX(), spr.getY(), spr.getZ(), spr.getAng(), 100, spr.getSectnum(), Tekprep.spriteXT[ext].weapon);
            }
            spr.setLotag(spr.getLotag() - 3);
            if (spr.getLotag() < 0) {
                spr.setLotag(0);
                if ((Tekprep.spriteXT[ext].aimask & 0x800) != 0) {
                    Tekprep.spriteXT[ext].aimask &= 0xFFFFF7FF;
                    Tekstat.newstatus(index15, 309);
                } else {
                    Tekstat.newstatus(index15, Tekprep.spriteXT[ext].basestat);
                }
            }
            Tekprep.spriteXT[ext].aimask &= 0xFFFFFFFB;
            Tekprep.spriteXT[ext].aimask &= 0xFFFFFFEF;
            i = nexti;
        }
        i = Main.boardService.getStatNode(313);
        while (i != null) {
            nexti = i.getNext();
            Sprite spr = i.get();
            int index16 = i.getIndex();
            short ext = spr.getExtra();
            if (Tekstat.validext(ext) == 0) {
                Tekstat.noextthrowerror(index16, 10);
            }
            spr.setLotag(spr.getLotag() - 3);
            if (spr.getLotag() < 0) {
                spr.setLotag(0);
                Tekstat.newstatus(index16, 300);
            }
            Tekprep.spriteXT[ext].aimask &= 0xFFFFFFFB;
            Tekprep.spriteXT[ext].aimask &= 0xFFFFFFEF;
            i = nexti;
        }
        i = Main.boardService.getStatNode(305);
        while (i != null) {
            Sector sec;
            nexti = i.getNext();
            Sprite spr = i.get();
            int index17 = i.getIndex();
            short ext = spr.getExtra();
            if (Tekstat.validext(ext) == 0) {
                Tekstat.noextthrowerror(index17, 11);
            }
            if ((sec = Main.boardService.getSector(spr.getSectnum())) != null && sec.getLotag() == 5040) {
                spr.setLotag(0);
                spr.setHitag(0);
                spr.setPicnum((short)Tekprep.spriteXT[ext].basepic);
                Tekstat.newstatus(index17, Tekprep.spriteXT[ext].basestat);
            }
            spr.setLotag(spr.getLotag() - 3);
            if (spr.getLotag() < 0) {
                spr.setHitag(spr.getHitag() - 3);
                if (spr.getHitag() < 0) {
                    spr.setLotag(0);
                    spr.setHitag(0);
                    Tekstat.newstatus(index17, 306);
                }
            } else {
                spr.setPicnum((short)(Tekprep.spriteXT[ext].squatpic + (47 - spr.getLotag() >> 4)));
            }
            Tekprep.spriteXT[ext].aimask &= 0xFFFFFFFB;
            Tekprep.spriteXT[ext].aimask &= 0xFFFFFFEF;
            i = nexti;
        }
        i = Main.boardService.getStatNode(306);
        while (i != null) {
            nexti = i.getNext();
            Sprite spr = i.get();
            int index18 = i.getIndex();
            short ext = spr.getExtra();
            if (Tekstat.validext(ext) == 0) {
                Tekstat.noextthrowerror(index18, 12);
            }
            spr.setLotag(spr.getLotag() - 3);
            if (spr.getLotag() < 0) {
                spr.setLotag(0);
                spr.setHitag(0);
                spr.setPicnum((short)Tekprep.spriteXT[ext].basepic);
                Tekstat.newstatus(index18, Tekprep.spriteXT[ext].basestat);
            } else {
                spr.setPicnum((short)(Tekprep.spriteXT[ext].squatpic + 2 - (47 - spr.getLotag() >> 4)));
            }
            Tekprep.spriteXT[ext].aimask &= 0xFFFFFFFB;
            Tekprep.spriteXT[ext].aimask &= 0xFFFFFFEF;
            i = nexti;
        }
        i = Main.boardService.getStatNode(311);
        while (i != null) {
            Sector sec;
            nexti = i.getNext();
            Sprite spr = i.get();
            int index19 = i.getIndex();
            short ext = spr.getExtra();
            if (Tekstat.validext(ext) == 0) {
                Tekstat.noextthrowerror(index19, 13);
            }
            if ((sec = Main.boardService.getSector(spr.getSectnum())) != null && sec.getLotag() == 5040) {
                spr.setLotag(0);
                spr.setHitag(0);
                spr.setPicnum((short)Tekprep.spriteXT[ext].basepic);
                Tekstat.newstatus(index19, Tekprep.spriteXT[ext].basestat);
            }
            if ((Tekprep.spriteXT[ext].aimask & 4) != 0) {
                spr.setLotag(0);
                spr.setHitag(0);
            }
            spr.setLotag(spr.getLotag() - 3);
            if (spr.getLotag() < 0) {
                spr.setHitag(spr.getHitag() - 3);
                if (spr.getHitag() < 0) {
                    spr.setLotag(0);
                    spr.setHitag(0);
                    Tekstat.newstatus(index19, 312);
                }
            } else {
                spr.setPicnum((short)(Tekprep.spriteXT[ext].squatpic + (47 - spr.getLotag() >> 4)));
            }
            Tekprep.spriteXT[ext].aimask &= 0xFFFFFFFB;
            Tekprep.spriteXT[ext].aimask &= 0xFFFFFFEF;
            i = nexti;
        }
        i = Main.boardService.getStatNode(312);
        while (i != null) {
            nexti = i.getNext();
            Sprite spr = i.get();
            int index20 = i.getIndex();
            short ext = spr.getExtra();
            if (Tekstat.validext(ext) == 0) {
                Tekstat.noextthrowerror(index20, 14);
            }
            spr.setLotag(spr.getLotag() - 3);
            if (spr.getLotag() < 0) {
                spr.setLotag(0);
                spr.setHitag(0);
                spr.setPicnum((short)Tekprep.spriteXT[ext].basepic);
                Tekstat.newstatus(index20, 205);
            } else {
                spr.setPicnum((short)(Tekprep.spriteXT[ext].squatpic + 2 - (47 - spr.getLotag() >> 4)));
            }
            Tekprep.spriteXT[ext].aimask &= 0xFFFFFFFB;
            Tekprep.spriteXT[ext].aimask &= 0xFFFFFFEF;
            i = nexti;
        }
        i = Main.boardService.getStatNode(302);
        while (i != null) {
            nexti = i.getNext();
            Sprite spr = i.get();
            int index21 = i.getIndex();
            short ext = spr.getExtra();
            if (Tekstat.validext(ext) == 0) {
                Tekstat.noextthrowerror(index21, 15);
            }
            spr.setLotag(spr.getLotag() - 3);
            if (spr.getLotag() < 0) {
                spr.setLotag(0);
                Tekstat.newstatus(index21, Tekprep.spriteXT[ext].basestat);
            }
            i = nexti;
        }
        i = Main.boardService.getStatNode(255);
        while (i != null) {
            nexti = i.getNext();
            Sprite spr = i.get();
            int index22 = i.getIndex();
            short host = spr.getOwner();
            if (!Tekgun.validplayer(host)) {
                throw new AssertException("plrvirus lost host");
            }
            Main.game.pInt.setsprinterpolate(index22, spr);
            spr.setX(Player.gPlayer[host].posx);
            spr.setY(Player.gPlayer[host].posy);
            spr.setZ(Player.gPlayer[host].posz + 2048);
            spr.setLotag(spr.getLotag() - 3);
            if (spr.getLotag() > 0 && (spr.getLotag() & 3) == 0 && Tekchng.changehealth(host, -64)) {
                spr.setLotag(0);
            }
            if (spr.getLotag() <= 0) {
                Tekchng.changehealth(host, -8192);
                if (host == Main.screenpeek) {
                    View.showmessage("BURNED");
                }
                Tekstat.jsdeletesprite(index22);
            }
            i = nexti;
        }
        i = Main.boardService.getStatNode(250);
        while (i != null) {
            nexti = i.getNext();
            Sprite spr = i.get();
            int index23 = i.getIndex();
            short host = spr.getOwner();
            Sprite hostSprite = Main.boardService.getSprite(host);
            if (hostSprite == null || hostSprite.getStatnum() >= 1024) {
                Tekstat.jsdeletesprite(index23);
                i = nexti;
                continue;
            }
            Main.game.pInt.setsprinterpolate(index23, spr);
            spr.setX(hostSprite.getX());
            spr.setY(hostSprite.getY());
            if (spr.getPicnum() == 450) {
                spr.setZ(hostSprite.getZ() - (Main.engine.getTile(hostSprite.getPicnum()).getHeight() << 4));
            } else {
                spr.setZ(hostSprite.getZ());
            }
            if (spr.getPicnum() == 450) {
                spr.setHitag(spr.getHitag() + 4);
                if (spr.getHitag() >= 24) {
                    hostSprite.setShade(hostSprite.getShade() + 1);
                    spr.setHitag(0);
                }
                if (hostSprite.getShade() > 12) {
                    Tekstat.damagesprite(host, 1024);
                    spr.setLotag(0);
                }
            } else {
                spr.setLotag(spr.getLotag() - 3);
                if (Tekstat.damagesprite(host, 4) == 1) {
                    Tekgun.killscore(host, Main.screenpeek, 0);
                    spr.setLotag(0);
                }
            }
            if (spr.getLotag() <= 0) {
                Tekstat.jsdeletesprite(index23);
            }
            i = nexti;
        }
        i = Main.boardService.getStatNode(301);
        while (i != null) {
            boolean deathcontinue = false;
            nexti = i.getNext();
            Sprite spr = i.get();
            int index24 = i.getIndex();
            short ext = spr.getExtra();
            if (Tekstat.validext(ext) == 0) {
                Tekstat.noextthrowerror(index24, 16);
            }
            if (Tekstat.isanandroid(index24) != 0) {
                Tekstat.androidexplosion(index24);
                Tekstat.jsdeletesprite(index24);
                View.showmessage("WAS AN ANDROID");
                deathcontinue = true;
            }
            if (!deathcontinue) {
                short targsect = spr.getSectnum();
                Sector targSec = Main.boardService.getSector(targsect);
                if (targSec != null && targSec.getLotag() != 4) {
                    Main.engine.getzrange(spr.getX(), spr.getY(), spr.getZ() - 1, spr.getSectnum(), spr.getClipdist() << 2, 65537);
                    Main.game.pInt.setsprinterpolate(index24, spr);
                    if (spr.getZ() < Engine.zr_florz) {
                        spr.setZ(spr.getZ() + 1024);
                    } else {
                        spr.setZ(Engine.zr_florz);
                    }
                }
                spr.setLotag(spr.getLotag() - 6);
                if (spr.getLotag() < 0) {
                    spr.setLotag(0);
                    Tekstat.tweakdeathdist(index24);
                    spr.setCstat(spr.getCstat() & 0xFFFE);
                    if (Tekstat.isahologram(index24) != 0) {
                        View.showmessage("WAS A HOLOGRAM");
                        Tekstat.jsdeletesprite(index24);
                    } else {
                        Tekmap.missionaccomplished(index24);
                        Tekstat.newstatus(index24, 322);
                    }
                } else {
                    spr.setPicnum((short)(Tekprep.spriteXT[ext].deathpic + (spr.getHitag() - spr.getLotag() >> 4)));
                }
            }
            i = nexti;
        }
        i = Main.boardService.getStatNode(320);
        while (i != null) {
            nexti = i.getNext();
            Sprite spr = i.get();
            int index25 = i.getIndex();
            int px = Player.gPlayer[Main.screenpeek].posx;
            int py = Player.gPlayer[Main.screenpeek].posy;
            pz = Player.gPlayer[Main.screenpeek].posz;
            if (px < -55326 || px > -52873 || py > 40521 || py < 36596) {
                i = nexti;
                continue;
            }
            int deltapy = py - 36596;
            if (Player.gPlayer[Main.screenpeek].drawweap != 0) {
                spr.setPicnum(1079);
            } else {
                spr.setPicnum(1074);
            }
            Main.game.pInt.setsprinterpolate(index25, spr);
            spr.setX(px);
            spr.setY(36596 - deltapy);
            spr.setZ(pz + 10752);
            spr.setAng((short)Gameutils.BClampAngle(Player.gPlayer[Main.screenpeek].ang + 1024.0f));
            i = nexti;
        }
        i = Main.boardService.getStatNode(321);
        while (i != null) {
            nexti = i.getNext();
            Sprite spr = i.get();
            int index26 = i.getIndex();
            int px = Player.gPlayer[Main.screenpeek].posx;
            int py = Player.gPlayer[Main.screenpeek].posy;
            pz = Player.gPlayer[Main.screenpeek].posz;
            if (px < -34792 || px > -32404 || py > 38980 || py < 35074) {
                i = nexti;
                continue;
            }
            int deltapy = 38980 - py;
            if (Player.gPlayer[Main.screenpeek].drawweap != 0) {
                spr.setPicnum(1079);
            } else {
                spr.setPicnum(1074);
            }
            Main.game.pInt.setsprinterpolate(index26, spr);
            spr.setX(px);
            spr.setY(38980 + deltapy);
            spr.setZ(pz + 10752);
            spr.setAng((short)Gameutils.BClampAngle(Player.gPlayer[Main.screenpeek].ang + 1024.0f));
            i = nexti;
        }
        i = Main.boardService.getStatNode(401);
        while (i != null) {
            int daz2;
            int day9;
            int dax12;
            nexti = i.getNext();
            Sprite spr = i.get();
            int index27 = i.getIndex();
            int hitobject = Tekspr.movesprite(index27, dax12 = spr.getXvel() * 3 << 11, day9 = spr.getYvel() * 3 << 11, daz2 = spr.getZvel() * 3 >> 2, 1024, 1024, 1);
            if (hitobject != 0) {
                if ((hitobject & 0xE0000000) == -1073741824) {
                    int hitsprite = hitobject & 0x1FFFFFFF;
                    int hit = Tekstat.playerhit(hitsprite);
                    int pnum2 = playerhit;
                    if (hit != 0) {
                        Tekgun.playerpainsound(pnum2);
                        Tekstat.enemywoundplayer(pnum2, 6);
                    } else {
                        Tekstat.damagesprite(hitsprite, Tekgun.tekgundamage(6));
                    }
                }
                Tekstat.jsdeletesprite(index27);
            }
            i = nexti;
        }
        int i1 = 0;
        while (true) {
            short ext;
            if (i1 >= Engine.MAXSPRITES) {
                Tekgun.gunstatuslistcode();
                return;
            }
            Sprite spr2 = Main.boardService.getSprite(i1);
            if (spr2 != null && Tekstat.validext(ext = spr2.getExtra()) != 0) {
                if ((Tekprep.spriteXT[ext].fxmask & 0x40) != 0) {
                    Tekprep.spriteXT[ext].fxmask &= 0xFFFFFFBF;
                    Tekstat.newstatus(i1, 301);
                } else if ((Tekprep.spriteXT[ext].fxmask & 0x20) != 0) {
                    Tekprep.spriteXT[ext].fxmask &= 0xFFFFFFDF;
                    Tekstat.newstatus(i1, 302);
                }
            }
            ++i1;
        }
    }

    public static void blastmark(int i) {
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null || spr.getStatnum() != 801) {
            return;
        }
        Sector sec = Main.boardService.getSector(spr.getSectnum());
        if (sec == null) {
            return;
        }
        switch (spr.getPicnum()) {
            case 175: 
            case 899: {
                break;
            }
            default: {
                return;
            }
        }
        int j = Tekstat.jsinsertsprite(spr.getSectnum(), 100);
        Sprite spr2 = Main.boardService.getSprite(j);
        if (spr2 != null) {
            Tekspr.fillsprite(j, spr.getX(), spr.getY(), sec.getFloorz(), 162, 4, 0, 0, 34, 34, 0, 0, 465, spr.getAng(), 0, 0, 30, i + 4096, 0, 0);
        }
    }

    public static void bombexplosion(int i) {
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null) {
            return;
        }
        int j = Tekstat.jsinsertsprite(spr.getSectnum(), 5);
        if (j != -1) {
            Tekspr.fillsprite(j, spr.getX(), spr.getY(), spr.getZ(), 0, -16, 0, 0, 34, 34, 0, 0, 460, spr.getAng(), EngineUtils.sin(spr.getAng() + 2560 & 0x7FF) >> 6, EngineUtils.sin(spr.getAng() + 2048 & 0x7FF) >> 6, 30, i + 4096, 32, 0);
            Teksnd.playsound(86, spr.getX(), spr.getY(), 0, 4);
        }
    }

    public static void forceexplosion(int i) {
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null) {
            return;
        }
        int j = Tekstat.jsinsertsprite(spr.getSectnum(), 5);
        if (j != -1) {
            Tekspr.fillsprite(j, spr.getX(), spr.getY(), spr.getZ(), 0, -4, 0, 32, 34, 34, 0, 0, 1332, spr.getAng(), 0, 0, 0, spr.getOwner(), 31, 0);
        }
        for (int k = 0; k < 6; ++k) {
            j = Tekstat.jsinsertsprite(spr.getSectnum(), 7);
            if (j == -1) continue;
            Tekspr.fillsprite(j, spr.getX(), spr.getY(), spr.getZ() + 8192, 2, -4, 0, 32, 24, 24, 0, 0, 1332, spr.getAng(), (Tektag.krand_intercept("STAT4497") & 0x1FF) - 256, (Tektag.krand_intercept("STAT4497") & 0x1FF) - 256, (Tektag.krand_intercept("STAT4497") & 0x4000) - 8192, spr.getOwner(), 96, 0);
        }
        Teksnd.playsound(104, spr.getX(), spr.getY(), 0, 2);
    }

    public static void enemywoundplayer(int plrhit, int guntype) {
        int damage;
        if (!Tekgun.validplayer(plrhit)) {
            return;
        }
        switch (guntype) {
            case 0: {
                damage = 64;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                damage = 128;
                break;
            }
            default: {
                damage = 256;
            }
        }
        switch (Globals.gDifficulty) {
            case 0: 
            case 1: {
                damage >>= 4;
                break;
            }
            case 2: {
                damage >>= 3;
                break;
            }
            case 3: {
                damage >>= 2;
            }
        }
        Tekchng.changehealth(plrhit, -damage);
    }

    public static void androidexplosion(int i) {
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null) {
            return;
        }
        int j = Tekstat.jsinsertsprite(spr.getSectnum(), 5);
        if (j != -1) {
            Tekspr.fillsprite(j, spr.getX(), spr.getY(), spr.getZ(), 0, -16, 0, 0, 34, 34, 0, 0, 456, spr.getAng(), EngineUtils.sin(spr.getAng() + 2560 & 0x7FF) >> 6, EngineUtils.sin(spr.getAng() + 2048 & 0x7FF) >> 6, 30, i + 4096, 32, 0);
        }
        Teksnd.playsound(145, spr.getX(), spr.getY(), 0, 4);
    }

    public static void tweakdeathdist(int i) {
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null) {
            return;
        }
        spr.setClipdist(spr.getClipdist() << 1);
        int dax = EngineUtils.sin(spr.getAng() + 512 & 0x7FF) * spr.getXvel() << 3;
        int day = EngineUtils.sin(spr.getAng() & 0x7FF) * spr.getYvel() << 3;
        Tekspr.movesprite((short)i, dax, day, 0, 1024, 1024, 2);
        if (spr.getExtra() == -1) {
            spr.setLotag(2004);
        }
    }

    public static int RMOD16(String s) {
        return Tektag.krand_intercept(s) & 0xF;
    }

    public static int RMOD10(String s) {
        return Tektag.krand_intercept(s) & 9;
    }

    public static int RMOD2(String s) {
        return Tektag.krand_intercept(s) > 32768 ? 1 : 0;
    }

    public static int RMOD3(String s) {
        return Tektag.krand_intercept(s) > 32768 ? 1 : Tektag.krand_intercept(s) >> 1 & 1;
    }

    public static int RMOD4(String s) {
        return Tektag.krand_intercept(s) >> 3 & 0xF & 3;
    }

    public static void enemynewsector(int i) {
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null) {
            return;
        }
        Sector sec = Main.boardService.getSector(spr.getSectnum());
        if (sec == null) {
            return;
        }
        short ext = spr.getExtra();
        if (Main.game.nNetMode == BuildGame.NetMode.Multiplayer) {
            return;
        }
        if (ensfirsttime == '\u0001') {
            ensfirsttime = '\u0000';
            return;
        }
        if (sec.getLotag() == 4) {
            Teksnd.playsound(11, spr.getX(), spr.getY(), 0, 2);
        }
        switch (sec.getHitag()) {
            case 1010: 
            case 1011: 
            case 1012: 
            case 1013: 
            case 1014: 
            case 1015: 
            case 1016: 
            case 1017: 
            case 1018: 
            case 1019: {
                if (Tekstat.isahologram(i) != 0) {
                    Tekstat.jsdeletesprite(i);
                    return;
                }
                if (Tekgun.tekexplodebody(i) != 0) {
                    Tekmap.missionaccomplished(i);
                }
                Teksnd.playsound(107, spr.getX(), spr.getY(), 0, 2);
                if (Tekstat.validext(ext) != 0) {
                    switch (Tekprep.spriteXT[ext].basepic) {
                        case 1950: {
                            Teksnd.playsound(129 + Tekstat.RMOD4("STAT2615") + Tekstat.RMOD3("STAT2615"), spr.getX(), spr.getY(), 0, 2);
                            break;
                        }
                        case 1801: {
                            Teksnd.playsound(139 + Tekstat.RMOD4("STAT2618") + Tekstat.RMOD3("STAT2618"), spr.getX(), spr.getY(), 0, 2);
                            break;
                        }
                        case 2003: {
                            Teksnd.playsound(129 + Tekstat.RMOD4("STAT2621") + Tekstat.RMOD3("STAT2621"), spr.getX(), spr.getY(), 0, 2);
                        }
                    }
                }
                Tekstat.jsdeletesprite(i);
                break;
            }
            default: {
                Tektag.operatesector(spr.getSectnum());
            }
        }
    }

    public static void attackifclose(int i, int snum, int dist) {
        int mindist;
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null) {
            return;
        }
        if (!Tekgun.validplayer(snum)) {
            throw new AssertException("atakifclse: bad plrnum");
        }
        if (Player.gPlayer[snum].health <= 0) {
            return;
        }
        short ext = spr.getExtra();
        if (Tekstat.validext(ext) == 0) {
            return;
        }
        switch (spr.getStatnum()) {
            case 206: {
                mindist = 8192;
                break;
            }
            case 203: 
            case 207: {
                mindist = 6144;
                break;
            }
            case 204: {
                mindist = 8192;
                break;
            }
            default: {
                mindist = 8192;
            }
        }
        switch (spr.getPicnum()) {
            case 260: {
                mindist = 1024;
                break;
            }
            case 303: {
                if (Tekstat.RMOD4("STAT1968") != 0) {
                    return;
                }
                mindist = 1024;
                if (dist > 1024) break;
                Main.game.pInt.setsprinterpolate(i, spr);
                spr.setZ(Player.gPlayer[snum].posz - 4096);
                break;
            }
        }
        if (dist < mindist) {
            spr.setAng(EngineUtils.getAngle(Player.gPlayer[snum].posx - spr.getX(), Player.gPlayer[snum].posy - spr.getY()));
            Tekstat.newstatus(i, 300);
        }
    }

    public static void hideplea(int sn, int ext) {
        Sprite spr = Main.boardService.getSprite(sn);
        if (spr == null) {
            return;
        }
        if ((Tekprep.spriteXT[ext].aimask & 0x400) != 0 && (Tektag.krand_intercept("STAT1383") & 1) != 0) {
            return;
        }
        switch (Tekprep.spriteXT[ext].basepic) {
            case 1950: {
                Teksnd.playsound(158 + (Tektag.krand_intercept("STAT1390") & 5), spr.getX(), spr.getY(), 0, 8);
                if ((Tektag.krand_intercept("STAT1391") & 1) == 0) break;
                Tekprep.spriteXT[ext].aimask |= 0x400;
                break;
            }
            case 1801: 
            case 2003: {
                Teksnd.playsound(187 + (Tektag.krand_intercept("STAT1397") & 5), spr.getX(), spr.getY(), 0, 8);
                if ((Tektag.krand_intercept("STAT1398") & 1) == 0) break;
                Tekprep.spriteXT[ext].aimask |= 0x400;
            }
        }
    }

    public static void fleescream(int sn, int ext) {
        Sprite spr = Main.boardService.getSprite(sn);
        if (spr == null) {
            return;
        }
        if (Tekstat.validext(ext) == 0) {
            return;
        }
        if ((Tekprep.spriteXT[ext].aimask & 0x100) != 0 && (Tektag.krand_intercept("STAT1417") & 1) != 0) {
            return;
        }
        switch (Tekprep.spriteXT[ext].basepic) {
            case 1950: {
                Teksnd.playsound(163 + (Tektag.krand_intercept("STAT1424") & 5), spr.getX(), spr.getY(), 0, 8);
                if ((Tektag.krand_intercept("STAT1425") & 1) == 0) break;
                Tekprep.spriteXT[ext].aimask |= 0x100;
                break;
            }
            case 1801: 
            case 2003: {
                switch (Tekstat.RMOD4("STAT1478")) {
                    case 0: 
                    case 2: {
                        Teksnd.playsound(175 + (Tektag.krand_intercept("STAT1434") & 0xB), spr.getX(), spr.getY(), 0, 8);
                        break;
                    }
                    default: {
                        Teksnd.playsound(125 + Tekstat.RMOD3("STAT1484"), spr.getX(), spr.getY(), 0, 8);
                    }
                }
                if ((Tektag.krand_intercept("STAT1440") & 1) == 0) break;
                Tekprep.spriteXT[ext].aimask |= 0x100;
            }
        }
    }

    public static int spritedeflect(int sn) {
        short angout;
        Sprite spr = Main.boardService.getSprite(sn);
        if (spr == null) {
            return 0;
        }
        block0 : switch (spr.getStatnum()) {
            case 0: 
            case 100: 
            case 202: {
                switch (Tekstat.RMOD2("STAT697 ")) {
                    case 0: {
                        angout = leftof[Tekstat.RMOD16("STAT")];
                        break block0;
                    }
                }
                angout = rightof[Tekstat.RMOD16("STAT")];
                break;
            }
            default: {
                angout = spr.getAng();
            }
        }
        return angout;
    }

    public static short arbitraryangle() {
        switch (Tekstat.RMOD4("STAT642 ")) {
            case 0: 
            case 1: {
                return leftof[Tekstat.RMOD16("STAT645 ")];
            }
        }
        return rightof[Tekstat.RMOD16("STAT648 ")];
    }

    public static int walldeflect(int wn, int angin) {
        int refract;
        int delta;
        Wall wal = Main.boardService.getWall(wn);
        if (wal == null) {
            return 0;
        }
        int wnorm = Tekgun.wallnormal(wal);
        int angout = wnorm + (delta = wnorm - (refract = angin + 1024 & 0x7FF));
        if (angout < 0) {
            angout += 2048;
        }
        return angout;
    }

    public static boolean isvisible(int i, int target) {
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null) {
            return false;
        }
        if (!Tekgun.validplayer(target)) {
            throw new AssertException("isvisible: bad targetnum");
        }
        if (Player.gPlayer[target].cursectnum >= 0 && EngineUtils.sin(spr.getAng() + 2560 & 0x7FF) * (Player.gPlayer[target].posx - spr.getX()) + EngineUtils.sin(spr.getAng() + 2048 & 0x7FF) * (Player.gPlayer[target].posy - spr.getY()) >= 0) {
            return Main.engine.cansee(Player.gPlayer[target].posx, Player.gPlayer[target].posy, Player.gPlayer[target].posz >> 1, Player.gPlayer[target].cursectnum, spr.getX(), spr.getY(), spr.getZ() - (Main.engine.getTile(spr.getPicnum()).getHeight() << 7), spr.getSectnum());
        }
        return false;
    }

    public static void enemygunshot(int sn) {
        int dist;
        short ext;
        Sprite spr2;
        ListNode<Sprite> nextj;
        Sprite spr = Main.boardService.getSprite(sn);
        if (spr == null) {
            return;
        }
        ListNode<Sprite> j = Main.boardService.getStatNode(209);
        while (j != null) {
            nextj = j.getNext();
            spr2 = j.get();
            ext = spr2.getExtra();
            if (Tekstat.validext(ext) == 0) {
                Tekstat.noextthrowerror(sn, 100);
            }
            if ((dist = Math.abs(spr.getX() - spr2.getX()) + Math.abs(spr.getY() - spr2.getY())) < 10240) {
                Tekprep.spriteXT[ext].aimask |= 4;
            }
            j = nextj;
        }
        j = Main.boardService.getStatNode(201);
        while (j != null) {
            nextj = j.getNext();
            spr2 = j.get();
            ext = spr2.getExtra();
            if (Tekstat.validext(ext) == 0) {
                Tekstat.noextthrowerror(sn, 101);
            }
            if (Tekprep.spriteXT[ext].basestat != 203 && (dist = Math.abs(spr.getX() - spr2.getX()) + Math.abs(spr.getY() - spr2.getY())) < 10240) {
                Tekprep.spriteXT[ext].aimask |= 4;
            }
            j = nextj;
        }
        j = Main.boardService.getStatNode(203);
        while (j != null) {
            nextj = j.getNext();
            if (j.getIndex() == sn) {
                j = nextj;
                continue;
            }
            spr2 = j.get();
            ext = spr2.getExtra();
            if (Tekstat.validext(ext) == 0) {
                Tekstat.noextthrowerror(sn, 102);
            }
            if ((dist = Math.abs(spr.getX() - spr2.getX()) + Math.abs(spr.getY() - spr2.getY())) < 10240) {
                Tekprep.spriteXT[ext].aimask |= 4;
            }
            j = nextj;
        }
    }

    public static void enemyshootgun(int sprnum, int x, int y, int z, short daang, int dahoriz, short dasectnum, char guntype) {
        Sprite spr = Main.boardService.getSprite(sprnum);
        if (spr == null) {
            return;
        }
        short ext = spr.getExtra();
        if (Tekstat.validext(ext) == 0) {
            throw new AssertException("enemyshootgun: bad ext");
        }
        int target = Tekprep.spriteXT[sprnum].target;
        if (!Tekgun.validplayer(target)) {
            return;
        }
        block0 : switch (guntype) {
            case '\u0000': {
                switch (Tekprep.spriteXT[ext].attackpic) {
                    case 280: {
                        break block0;
                    }
                    case 3910: {
                        Teksnd.playsound(31, x, y, 0, 4);
                        break block0;
                    }
                }
                Teksnd.playsound(147, x, y, 0, 4);
                break;
            }
            case '\u0001': 
            case '\u0002': 
            case '\u0003': 
            case '\u0004': {
                switch (Tekprep.spriteXT[ext].attackpic) {
                    case 3773: 
                    case 3800: 
                    case 3805: 
                    case 3810: 
                    case 3818: {
                        Teksnd.playsound(146, x, y, 0, 4);
                        break block0;
                    }
                    case 3850: 
                    case 3860: 
                    case 3890: 
                    case 3909: 
                    case 3952: 
                    case 4001: {
                        Teksnd.playsound(147, x, y, 0, 4);
                        break block0;
                    }
                    case 1771: {
                        Teksnd.playsound(96, x, y, 0, 4);
                        break block0;
                    }
                    case 1854: {
                        Teksnd.playsound(97, x, y, 0, 4);
                        break block0;
                    }
                    case 2023: {
                        Teksnd.playsound(98, x, y, 0, 4);
                        break block0;
                    }
                }
                Teksnd.playsound(95, x, y, 0, 4);
                break;
            }
            case '\u0005': 
            case '\u0006': 
            case '\u0007': 
            case '\b': {
                switch (Tekprep.spriteXT[ext].attackpic) {
                    case 3773: 
                    case 3800: 
                    case 3805: 
                    case 3810: 
                    case 3818: {
                        Teksnd.playsound(146, x, y, 0, 4);
                        break block0;
                    }
                    case 3850: 
                    case 3860: 
                    case 3890: 
                    case 3909: 
                    case 3952: 
                    case 4001: {
                        Teksnd.playsound(147, x, y, 0, 4);
                        break block0;
                    }
                }
                Teksnd.playsound(105, x, y, 0, 4);
                break;
            }
        }
        switch (guntype) {
            case '\u0000': {
                if (Math.abs(x - Player.gPlayer[target].posx) + Math.abs(y - Player.gPlayer[target].posy) < 1024 && Math.abs(z - Player.gPlayer[target].posz) < 12288) {
                    Tekgun.playerpainsound(target);
                    if ((Tekprep.spriteXT[ext].fxmask & 8) != 0) {
                        Teksnd.playsound(146, x, y, 0, 4);
                        Tekstat.enemywoundplayer(target, 0);
                    }
                    if ((Tekprep.spriteXT[ext].fxmask & 4) != 0) {
                        Tekstat.androidexplosion(sprnum);
                        Tekstat.enemywoundplayer(target, 6);
                        Tekstat.jsdeletesprite(sprnum);
                    } else {
                        Tekstat.enemywoundplayer(target, 0);
                    }
                }
                return;
            }
            case '\u0003': 
            case '\u0004': 
            case '\u0005': {
                int daz2 = 100 - dahoriz << 11;
                z = Player.gPlayer[target].posz;
                Main.engine.hitscan(x, y, z, dasectnum, EngineUtils.sin(daang + 2560 & 0x7FF), EngineUtils.sin(daang + 2048 & 0x7FF), daz2, Engine.pHitInfo, 0x1000040);
                int hitsect = Engine.pHitInfo.hitsect;
                int hitsprite = Engine.pHitInfo.hitsprite;
                int hitx = Engine.pHitInfo.hitx;
                int hity = Engine.pHitInfo.hity;
                int hitz = Engine.pHitInfo.hitz;
                if (hitsprite != -1) {
                    int hit = Tekstat.playerhit(hitsprite);
                    int pnum = playerhit;
                    if (hit != 0) {
                        Tekgun.playerpainsound(pnum);
                        Tekstat.enemywoundplayer(pnum, 3);
                        break;
                    }
                    Tekstat.damagesprite(hitsprite, Tekgun.tekgundamage(guntype));
                    break;
                }
                int j = Tekstat.jsinsertsprite(hitsect, 3);
                if (j == -1) break;
                Tekspr.fillsprite(j, hitx, hity, hitz + 2048, 2, -4, 0, 32, 16, 16, 0, 0, 427, daang, 0, 0, 0, sprnum + Engine.MAXSPRITES, 63, 0);
                break;
            }
            case '\u0006': {
                int j = Tekstat.jsinsertsprite(spr.getSectnum(), 401);
                Sprite spr2 = Main.boardService.getSprite(j);
                if (spr2 == null) break;
                spr2.setX(spr.getX());
                spr2.setY(spr.getY());
                if (Tekprep.spriteXT[ext].basestat == 500) {
                    spr2.setZ(spr.getZ());
                } else {
                    Sector sec = Main.boardService.getSector(spr.getSectnum());
                    if (sec != null) {
                        spr2.setZ(sec.getFloorz() - 8192);
                    }
                }
                spr2.setCstat(1);
                spr2.setPicnum(312);
                spr2.setShade(-32);
                spr2.setXrepeat(32);
                spr2.setYrepeat(32);
                spr2.setAng(spr.getAng());
                spr2.setXvel((short)(EngineUtils.sin(spr2.getAng() + 2560 & 0x7FF) >> 4));
                spr2.setYvel((short)(EngineUtils.sin(spr2.getAng() + 2048 & 0x7FF) >> 4));
                int discrim = EngineUtils.sqrt((Player.gPlayer[target].posx - spr2.getX()) * (Player.gPlayer[target].posx - spr2.getX()) + (Player.gPlayer[target].posy - spr2.getY()) * (Player.gPlayer[target].posy - spr2.getY()));
                if (discrim == 0) {
                    discrim = 1;
                }
                spr2.setZvel((short)((Player.gPlayer[target].posz + 2048 - spr2.getZ() << 9) / discrim));
                spr2.setOwner(sprnum);
                spr2.setClipdist(16);
                spr2.setLotag(0);
                spr2.setHitag(0);
                break;
            }
        }
        Tekstat.enemygunshot(sprnum);
    }

    static {
        ensfirsttime = '\u0001';
        bobbing = new int[]{0, 2, 4, 6, 8, 10, 12, 14, 16, 14, 12, 10, 8, 6, 4, 2, 0, -2, -4, -6, -8, -10, -12, -14, -16, -14, -12, -10, -8, -6, -4, -2};
        leftof = new short[]{1920, 0, 128, 256, 384, 512, 640, 768, 896, 1024, 1152, 1280, 1408, 1536, 1664, 1792, 1920};
        rightof = new short[]{128, 256, 384, 512, 640, 768, 896, 1024, 1152, 1280, 1408, 1536, 1664, 1792, 1920, 0, 128};
    }

    public static class sectflashtype {
        short sectnum;
        int step;
        char ovis;
    }
}

