/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.LONGp;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class Ai {
    public static final Animator InitActorAttack = new Animator(Ai::InitActorAttack);
    public static final Animator DoActorDecide = new Animator(Ai::DoActorDecide);
    public static final Animator InitActorRunToward = new Animator(Ai::InitActorRunToward);
    public static final Animator InitActorRunAway = new Animator(Ai::InitActorRunAway);
    public static final Animator InitActorDecide = new Animator(Ai::InitActorDecide);
    public static final Animator InitActorAlertNoise = new Animator(Ai::InitActorAlertNoise);
    public static final Animator InitActorAmbientNoise = new Animator(Ai::InitActorAmbientNoise);
    public static final Animator InitActorAttackNoise = new Animator(Ai::InitActorAttackNoise);
    public static final Animator InitActorDieNoise = new Animator(Ai::InitActorDieNoise);
    public static final Animator InitActorPainNoise = new Animator(Ai::InitActorPainNoise);
    public static final Animator InitActorExtra1Noise = new Animator(Ai::InitActorExtra1Noise);
    public static final Animator InitActorExtra2Noise = new Animator(Ai::InitActorExtra2Noise);
    public static final Animator InitActorExtra3Noise = new Animator(Ai::InitActorExtra3Noise);
    public static final Animator InitActorExtra4Noise = new Animator(Ai::InitActorExtra4Noise);
    public static final Animator InitActorExtra5Noise = new Animator(Ai::InitActorExtra5Noise);
    public static final Animator InitActorExtra6Noise = new Animator(Ai::InitActorExtra6Noise);
    public static final Animator InitActorMoveCloser = new Animator(Ai::InitActorMoveCloser);
    public static final Animator DoActorMoveCloser = new Animator(Ai::DoActorMoveCloser);
    public static final Animator DoActorAttack = new Animator(Ai::DoActorAttack);
    public static final Animator InitActorEvade = new Animator(Ai::InitActorEvade);
    public static final Animator InitActorWanderAround = new Animator(Ai::InitActorWanderAround);
    public static final Animator InitActorFindPlayer = new Animator(Ai::InitActorFindPlayer);
    public static final Animator InitActorDuck = new Animator(Ai::InitActorDuck);
    public static final Animator DoActorDuck = new Animator(Ai::DoActorDuck);
    public static final Animator DoActorMoveJump = new Animator(Ai::DoActorMoveJump);
    public static final Animator InitActorReposition = new Animator(Ai::InitActorReposition);
    public static final Animator DoActorReposition = new Animator(Ai::DoActorReposition);
    public static final Animator DoActorPause = new Animator(Ai::DoActorPause);
    public static final int SLOW_SPEED = 0;
    public static final int NORM_SPEED = 1;
    public static final int MID_SPEED = 2;
    public static final int FAST_SPEED = 3;
    public static final int TOWARD = 1;
    public static final int AWAY = -1;
    private static final int[] PlayerAbove = new int[]{MyTypes.BIT(5), MyTypes.BIT(6), MyTypes.BIT(2), MyTypes.BIT(7), MyTypes.BIT(14), MyTypes.BIT(12)};
    private static final int[] PlayerBelow = new int[]{MyTypes.BIT(3), MyTypes.BIT(6), MyTypes.BIT(7), MyTypes.BIT(14), MyTypes.BIT(12)};
    private static final int[] PlayerOnLevel = new int[]{MyTypes.BIT(8), MyTypes.BIT(9), MyTypes.BIT(7), MyTypes.BIT(10), MyTypes.BIT(14), MyTypes.BIT(12)};
    private static final int[] RunAwayTracks = new int[]{MyTypes.BIT(10), MyTypes.BIT(5), MyTypes.BIT(7), MyTypes.BIT(6), MyTypes.BIT(2), MyTypes.BIT(3), MyTypes.BIT(8), MyTypes.BIT(9), MyTypes.BIT(14), MyTypes.BIT(12)};
    private static final int[] WanderTracks = new int[]{MyTypes.BIT(8), MyTypes.BIT(9), MyTypes.BIT(11), MyTypes.BIT(3), MyTypes.BIT(2), MyTypes.BIT(7), MyTypes.BIT(6), MyTypes.BIT(5), MyTypes.BIT(10), MyTypes.BIT(14)};
    private static final short[][] toward_angle_delta = new short[][]{{-160, -384, 160, 384, -256, 256, -512, 512, -99}, {-384, -160, 384, 160, -256, 256, -512, 512, -99}, {160, 384, -160, -384, 256, -256, 512, -512, -99}, {384, 160, -384, -160, 256, -256, 512, -512, -99}};
    private static final short[][] away_angle_delta = new short[][]{{-768, 768, -640, 640, -896, 896, 1024, -99}, {768, -768, 640, -640, -896, 896, 1024, -99}, {896, -896, -768, 768, -640, 640, 1024, -99}, {896, -896, 768, -768, 640, -640, 1024, -99}};
    private static final int[] AwayDist = new int[]{17000, 20000, 26000, 26000, 26000, 32000, 32000, 42000};
    private static final int[] TowardDist = new int[]{10000, 15000, 20000, 20000, 25000, 30000, 35000, 40000};
    private static final int[] PlayerDist = new int[]{2000, 3000, 3000, 5000, 5000, 5000, 9000, 9000};
    public static final Decision[] GenericFlaming = new Decision[]{new Decision(30, InitActorAttack), new Decision(512, InitActorRunToward), new Decision(1024, InitActorRunAway)};

    public static void InitActorAttackNoise(int SpriteNum) {
        USER pUser = Gameutils.getUser(SpriteNum);
        if (pUser != null) {
            pUser.ActorActionFunc = DoActorDecide;
        }
    }

    public static void InitActorAmbientNoise(int SpriteNum) {
        USER pUser = Gameutils.getUser(SpriteNum);
        if (pUser != null) {
            pUser.ActorActionFunc = DoActorDecide;
        }
    }

    public static void InitActorAlertNoise(int SpriteNum) {
        USER pUser = Gameutils.getUser(SpriteNum);
        if (pUser != null) {
            pUser.ActorActionFunc = DoActorDecide;
        }
    }

    public static boolean ActorMoveHitReact(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return false;
        }
        switch (MyTypes.DTEST(u.moveSpriteReturn, -536870912)) {
            case -1073741824: {
                int HitSprite = Gameutils.NORM_HIT_INDEX(u.moveSpriteReturn);
                USER hu = Gameutils.getUser(HitSprite);
                if (hu == null || hu.PlayerP == -1) break;
                Ai.DoActorPickClosePlayer(SpriteNum);
                Animator action = Ai.ChooseAction(u.Personality.TouchTarget);
                if (action == null) break;
                action.animatorInvoke(SpriteNum);
                return true;
            }
        }
        return false;
    }

    public static int RandomRange(int range) {
        int value;
        if (range <= 0) {
            return 0;
        }
        int rand_num = Gameutils.RANDOM();
        if (rand_num == 65535) {
            --rand_num;
        }
        if ((value = (rand_num << 14) / (1073725440 / range)) >= range) {
            value = range - 1;
        }
        return value;
    }

    public static int StdRandomRange(int range) {
        int value;
        if (range <= 0) {
            return 0;
        }
        int rand_num = Gameutils.STD_RANDOM();
        if (rand_num == Short.MAX_VALUE) {
            --rand_num;
        }
        if ((value = (int)((long)(rand_num << 14) / (536854528L / (long)range))) >= range) {
            value = range - 1;
        }
        return value;
    }

    public static boolean ActorFlaming(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return false;
        }
        WangSprite fp = Main.boardService.getSprite(u.flame);
        if (fp != null) {
            int size = Gameutils.SPRITEp_SIZE_Z(sp) - MyTypes.DIV4(Gameutils.SPRITEp_SIZE_Z(sp));
            return Gameutils.SPRITEp_SIZE_Z(fp) > size;
        }
        return false;
    }

    public static void DoActorSetSpeed(int SpriteNum, int speed) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if (MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_RESTORE)) {
            return;
        }
        u.speed = (byte)speed;
        if (Ai.ActorFlaming(SpriteNum)) {
            sp.setXvel(u.Attrib.Speed[speed] + MyTypes.DIV2(u.Attrib.Speed[speed]));
        } else {
            sp.setXvel(u.Attrib.Speed[speed]);
        }
    }

    public static Animator ChooseAction(Decision[] decision) {
        int random_value = Gameutils.RANDOM_P2(32768) >> 5;
        for (int i = 0; i < 10; ++i) {
            if (random_value > decision[i].range) continue;
            return decision[i].action;
        }
        return null;
    }

    public static int ChooseActionNumber(short[] decision) {
        int random_value = Gameutils.RANDOM_P2(32768) >> 5;
        int i = 0;
        while (random_value > decision[i]) {
            ++i;
        }
        return i;
    }

    public static void DoActorNoise(Animator Action2, int SpriteNum) {
        if (Action2 == InitActorAmbientNoise) {
            Sound.PlaySpriteSound(SpriteNum, Attrib_Snds.attr_ambient, 1);
        } else if (Action2 == InitActorAlertNoise) {
            USER u = Gameutils.getUser(SpriteNum);
            if (u != null && !u.DidAlert) {
                Sound.PlaySpriteSound(SpriteNum, Attrib_Snds.attr_alert, 1);
            }
        } else if (Action2 == InitActorAttackNoise) {
            Sound.PlaySpriteSound(SpriteNum, Attrib_Snds.attr_attack, 1);
        } else if (Action2 == InitActorPainNoise) {
            Sound.PlaySpriteSound(SpriteNum, Attrib_Snds.attr_pain, 1);
        } else if (Action2 == InitActorDieNoise) {
            Sound.PlaySpriteSound(SpriteNum, Attrib_Snds.attr_die, 0);
        } else if (Action2 == InitActorExtra1Noise) {
            Sound.PlaySpriteSound(SpriteNum, Attrib_Snds.attr_extra1, 1);
        } else if (Action2 == InitActorExtra2Noise) {
            Sound.PlaySpriteSound(SpriteNum, Attrib_Snds.attr_extra2, 1);
        } else if (Action2 == InitActorExtra3Noise) {
            Sound.PlaySpriteSound(SpriteNum, Attrib_Snds.attr_extra3, 1);
        } else if (Action2 == InitActorExtra4Noise) {
            Sound.PlaySpriteSound(SpriteNum, Attrib_Snds.attr_extra4, 1);
        } else if (Action2 == InitActorExtra5Noise) {
            Sound.PlaySpriteSound(SpriteNum, Attrib_Snds.attr_extra5, 1);
        } else if (Action2 == InitActorExtra6Noise) {
            Sound.PlaySpriteSound(SpriteNum, Attrib_Snds.attr_extra6, 1);
        }
    }

    public static boolean CanSeePlayer(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return false;
        }
        int look_height = Gameutils.SPRITEp_TOS(sp);
        WangSprite target = Main.boardService.getSprite(u.tgt_sp);
        if (target == null) {
            return false;
        }
        return Rooms.FAFcansee(sp.getX(), sp.getY(), look_height, sp.getSectnum(), target.getX(), target.getY(), Gameutils.SPRITEp_UPPER(target), target.getSectnum());
    }

    public static boolean CanHitPlayer(int SpriteNum) {
        int zvect;
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return false;
        }
        int zhs = sp.getZ() - MyTypes.DIV2(Gameutils.SPRITEp_SIZE_Z(sp));
        WangSprite hp = Main.boardService.getSprite(u.tgt_sp);
        if (hp == null) {
            return false;
        }
        int ang = EngineUtils.getAngle(hp.getX() - sp.getX(), hp.getY() - sp.getY());
        int xvect = EngineUtils.sin(Gameutils.NORM_ANGLE(ang + 512));
        int yvect = EngineUtils.sin(Gameutils.NORM_ANGLE(ang));
        int zhh = hp.getZ() - MyTypes.DIV2(Gameutils.SPRITEp_SIZE_Z(hp));
        if (hp.getX() - sp.getX() != 0) {
            zvect = xvect * ((zhh - zhs) / (hp.getX() - sp.getX()));
        } else if (hp.getY() - sp.getY() != 0) {
            zvect = yvect * ((zhh - zhs) / (hp.getY() - sp.getY()));
        } else {
            return false;
        }
        Rooms.FAFhitscan(sp.getX(), sp.getY(), zhs, sp.getSectnum(), xvect, yvect, zvect, Engine.pHitInfo, Gameutils.CLIPMASK_MISSILE);
        if (Engine.pHitInfo.hitsect == -1) {
            return false;
        }
        return Engine.pHitInfo.hitsprite == u.tgt_sp;
    }

    public static void DoActorPickClosePlayer(int SpriteNum) {
        int near_dist;
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        int look_height = Gameutils.SPRITEp_TOS(sp);
        boolean found = false;
        if (u.ID != 1095 || Main.gNet.MultiGameType != WangNetwork.MultiGameTypes.MULTI_GAME_COOPERATIVE) {
            int dist;
            PlayerStr pp;
            u.tgt_sp = Game.Player[Mmulti.connecthead].PlayerSprite;
            if (MyTypes.TEST(u.Flags2, Gameutils.SPR2_DONT_TARGET_OWNER)) {
                short pnum = Mmulti.connecthead;
                while (pnum != -1) {
                    PlayerStr pp2 = Game.Player[pnum];
                    if (sp.getOwner() != pp2.PlayerSprite) {
                        u.tgt_sp = pp2.PlayerSprite;
                        break;
                    }
                    pnum = Mmulti.connectpoint2[pnum];
                }
            }
            near_dist = 42000;
            short pnum = Mmulti.connecthead;
            while (pnum != -1) {
                pp = Game.Player[pnum];
                if ((!MyTypes.TEST(u.Flags2, Gameutils.SPR2_DONT_TARGET_OWNER) || sp.getOwner() != pp.PlayerSprite && Weapon.PlayerTakeDamage(pp, SpriteNum)) && (dist = Gameutils.DISTANCE(sp.getX(), sp.getY(), pp.posx, pp.posy)) < near_dist) {
                    near_dist = dist;
                    u.tgt_sp = pp.PlayerSprite;
                }
                pnum = Mmulti.connectpoint2[pnum];
            }
            near_dist = 42000;
            pnum = Mmulti.connecthead;
            while (pnum != -1) {
                pp = Game.Player[pnum];
                if (!MyTypes.TEST(u.Flags2, Gameutils.SPR2_DONT_TARGET_OWNER) || sp.getOwner() != pp.PlayerSprite && Weapon.PlayerTakeDamage(pp, SpriteNum)) {
                    dist = Gameutils.DISTANCE(sp.getX(), sp.getY(), pp.posx, pp.posy);
                    Sprite psp = pp.getSprite();
                    if (psp != null && dist < near_dist && Rooms.FAFcansee(sp.getX(), sp.getY(), look_height, sp.getSectnum(), psp.getX(), psp.getY(), Gameutils.SPRITEp_UPPER(psp), psp.getSectnum())) {
                        near_dist = dist;
                        u.tgt_sp = pp.PlayerSprite;
                        found = true;
                    }
                }
                pnum = Mmulti.connectpoint2[pnum];
            }
        }
        if (!found && MyTypes.TEST(u.Flags2, Gameutils.SPR2_DONT_TARGET_OWNER)) {
            near_dist = 42000;
            ListNode<Sprite> node = Main.boardService.getStatNode(2);
            while (node != null) {
                USER ui;
                int i = node.getIndex();
                ListNode<Sprite> nexti = node.getNext();
                if (!(i == SpriteNum || (ui = Gameutils.getUser(i)) != null && MyTypes.TEST(ui.Flags, Gameutils.SPR_SUICIDE | Gameutils.SPR_DEAD))) {
                    Sprite s = node.get();
                    int dist = Gameutils.DISTANCE(sp.getX(), sp.getY(), s.getX(), s.getY());
                    if (dist < near_dist && Rooms.FAFcansee(sp.getX(), sp.getY(), look_height, sp.getSectnum(), s.getX(), s.getY(), Gameutils.SPRITEp_UPPER(s), s.getSectnum())) {
                        near_dist = dist;
                        u.tgt_sp = i;
                    }
                }
                node = nexti;
            }
        }
    }

    private static void DoActorDecide(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        Animator actor_action = Ai.DoActorActionDecide(SpriteNum);
        if (actor_action == InitActorAttack && u.WeaponNum == 0) {
            return;
        }
        USER tu = Gameutils.getUser(u.tgt_sp);
        if (actor_action == InitActorAttack && u.ID == 1095 && u.tgt_sp != -1 && tu != null && tu.PlayerP != -1) {
            if (sp.getOwner() == u.tgt_sp) {
                return;
            }
            if (!Weapon.PlayerTakeDamage(Game.Player[tu.PlayerP], SpriteNum)) {
                return;
            }
        }
        if (actor_action != InitActorDecide) {
            actor_action.animatorInvoke(SpriteNum);
        } else {
            Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Stand);
        }
    }

    public static int GetPlayerSpriteNum(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return 0;
        }
        short pnum = Mmulti.connecthead;
        while (pnum != -1) {
            PlayerStr pp = Game.Player[pnum];
            if (pp.PlayerSprite == u.tgt_sp) {
                return pp.PlayerSprite;
            }
            pnum = Mmulti.connectpoint2[pnum];
        }
        return 0;
    }

    public static int CloseRangeDist(Sprite sp1, Sprite sp2) {
        int clip1 = sp1.getClipdist();
        int clip2 = sp2.getClipdist();
        int DIST_CLOSE_RANGE = 400;
        return (clip1 << 2) + (clip2 << 2) + DIST_CLOSE_RANGE;
    }

    public static void DoActorOperate(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if (u.ID == 800 || u.ID == 3780 || u.ID == 4550) {
            return;
        }
        if (u.getRot() == u.ActorActionSet.Sit || u.getRot() == u.ActorActionSet.Stand) {
            return;
        }
        if ((u.WaitTics -= 6) > 0) {
            return;
        }
        Main.engine.neartag(sp.getX(), sp.getY(), sp.getZ() - MyTypes.DIV2(Gameutils.SPRITEp_SIZE_Z(sp)), sp.getSectnum(), sp.getAng(), Engine.neartag, 1024, 3);
        if (Engine.neartag.tagsector >= 0 && Engine.neartag.taghitdist < 1024 && Sector.OperateSector(Engine.neartag.tagsector, false)) {
            u.WaitTics = 240;
            Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Sit);
        }
    }

    public static Animator DoActorActionDecide(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        Animator action = InitActorDecide;
        if (u == null || sp == null) {
            return action;
        }
        u.Dist = 0;
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            return action;
        }
        if (Ai.ActorFlaming(SpriteNum)) {
            action = Ai.ChooseAction(GenericFlaming);
            return action;
        }
        boolean ICanSee = Ai.CanSeePlayer(SpriteNum);
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_ACTIVE)) {
            Ai.DoActorOperate(SpriteNum);
            WangSprite targetSpr = Main.boardService.getSprite(u.tgt_sp);
            if (targetSpr != null) {
                int dist = Game.Distance(sp.getX(), sp.getY(), targetSpr.getX(), targetSpr.getY());
                if (dist > 30000 && !ICanSee) {
                    Sprites.SetEnemyInactive(SpriteNum);
                    action = Ai.ChooseAction(u.Personality.LostTarget);
                    return action;
                }
                USER pu = Gameutils.getUser(Ai.GetPlayerSpriteNum(SpriteNum));
                if (dist < Ai.CloseRangeDist(sp, targetSpr) && ICanSee || pu != null && pu.WeaponNum == 0 && u.ID != 4320 && u.ID != 1580) {
                    action = u.ID == 4277 && MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_TRANSLUCENT) || MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_INVISIBLE) ? Ai.ChooseAction(u.Personality.Evasive) : Ai.ChooseAction(u.Personality.CloseRange);
                    return action;
                }
                if (Gameutils.FACING(sp, targetSpr) && MyTypes.TEST(u.Flags, Gameutils.SPR_ATTACKED) && ICanSee) {
                    if (MyTypes.TEST(u.Flags, Gameutils.SPR_TARGETED)) {
                        u.Flags &= ~Gameutils.SPR_TARGETED;
                        action = u.ActorActionSet.Duck != null && Gameutils.RANDOM_P2(262144) >> 8 < 100 ? InitActorDuck : (u.ID == 4277 && MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_TRANSLUCENT) || MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_INVISIBLE) ? Ai.ChooseAction(u.Personality.Evasive) : Ai.ChooseAction(u.Personality.Battle));
                    } else {
                        action = u.ID == 4277 && MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_TRANSLUCENT) || MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_INVISIBLE) ? Ai.ChooseAction(u.Personality.Evasive) : Ai.ChooseAction(u.Personality.Battle);
                    }
                    return action;
                }
                if (ICanSee) {
                    action = u.ID == 4277 && MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_TRANSLUCENT) || MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_INVISIBLE) ? Ai.ChooseAction(u.Personality.Evasive) : Ai.ChooseAction(u.Personality.Offense);
                    return action;
                }
                action = Ai.ChooseAction(u.Personality.LostTarget);
                return action;
            }
        } else {
            int dist;
            WangSprite targetSpr;
            if (sp.getHitag() != 1008) {
                Ai.DoActorPickClosePlayer(SpriteNum);
            }
            if ((targetSpr = Main.boardService.getSprite(u.tgt_sp)) != null && ((dist = Game.Distance(sp.getX(), sp.getY(), targetSpr.getX(), targetSpr.getY())) < 15000 || ICanSee)) {
                if (Gameutils.FACING(sp, targetSpr) && dist < 10000 || ICanSee) {
                    Ai.DoActorOperate(SpriteNum);
                    action = Ai.ChooseAction(u.Personality.Surprised);
                    if (!u.DidAlert && ICanSee) {
                        Ai.DoActorNoise(InitActorAlertNoise, SpriteNum);
                        u.DidAlert = true;
                    }
                } else {
                    Ai.DoActorNoise(Ai.ChooseAction(u.Personality.Broadcast), SpriteNum);
                }
                return action;
            }
        }
        return action;
    }

    public static void InitActorPainNoise(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u != null) {
            u.ActorActionFunc = DoActorDecide;
        }
    }

    public static void InitActorDecide(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        u.ActorActionFunc = DoActorDecide;
        DoActorDecide.animatorInvoke(SpriteNum);
    }

    public static void InitActorDieNoise(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u != null) {
            u.ActorActionFunc = DoActorDecide;
        }
    }

    public static void DoActorCantMoveCloser(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        u.track = Ai.FindTrackToPlayer(SpriteNum);
        if (u.track >= 0) {
            sp.setAng(EngineUtils.getAngle(Track.Track[u.track].TrackPoint[u.point].x - sp.getX(), Track.Track[u.track].TrackPoint[u.point].y - sp.getY()));
            Ai.DoActorSetSpeed(SpriteNum, 2);
            u.Flags |= Gameutils.SPR_FIND_PLAYER;
            u.ActorActionFunc = DoActorDecide;
            Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Run);
        } else {
            InitActorReposition.animatorInvoke(SpriteNum);
        }
    }

    public static void InitActorExtra1Noise(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u != null) {
            u.ActorActionFunc = DoActorDecide;
        }
    }

    public static int FindTrackToPlayer(int SpriteNum) {
        int size;
        int[] type;
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return -1;
        }
        int zdiff = Gameutils.SPRITEp_UPPER(Main.boardService.getSprite(u.tgt_sp)) - (sp.getZ() - Gameutils.SPRITEp_SIZE_Z(sp) + Gameutils.Z(8));
        if (Pragmas.klabs(zdiff) <= Gameutils.Z(20)) {
            type = PlayerOnLevel;
            size = PlayerOnLevel.length;
        } else if (zdiff < 0) {
            type = PlayerAbove;
            size = PlayerAbove.length;
        } else {
            type = PlayerBelow;
            size = PlayerBelow.length;
        }
        for (int i = 0; i < size; ++i) {
            int track = Track.ActorFindTrack(SpriteNum, 1, type[i], Game.tmp_ptr[0], Game.tmp_ptr[1]);
            if (track < 0) continue;
            u.point = Game.tmp_ptr[0].value;
            u.track_dir = Game.tmp_ptr[1].value;
            Track.Track[track].flags |= Gameutils.TF_TRACK_OCCUPIED;
            return track;
        }
        return -1;
    }

    public static void InitActorExtra2Noise(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u != null) {
            u.ActorActionFunc = DoActorDecide;
        }
    }

    public static int FindTrackAwayFromPlayer(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        for (int runAwayTrack : RunAwayTracks) {
            int track = Track.ActorFindTrack(SpriteNum, -1, runAwayTrack, Game.tmp_ptr[0], Game.tmp_ptr[1]);
            if (u == null || track < 0) continue;
            u.point = Game.tmp_ptr[0].value;
            u.track_dir = Game.tmp_ptr[1].value;
            Track.Track[track].flags |= Gameutils.TF_TRACK_OCCUPIED;
            return track;
        }
        return -1;
    }

    public static void InitActorExtra3Noise(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u != null) {
            u.ActorActionFunc = DoActorDecide;
        }
    }

    public static int FindWanderTrack(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        for (int wanderTrack : WanderTracks) {
            int track = Track.ActorFindTrack(SpriteNum, -1, wanderTrack, Game.tmp_ptr[0], Game.tmp_ptr[1]);
            if (u == null || track < 0) continue;
            u.point = Game.tmp_ptr[0].value;
            u.track_dir = Game.tmp_ptr[1].value;
            Track.Track[track].flags |= Gameutils.TF_TRACK_OCCUPIED;
            return track;
        }
        return -1;
    }

    public static void InitActorExtra4Noise(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u != null) {
            u.ActorActionFunc = DoActorDecide;
        }
    }

    public static void InitActorRunAway(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        u.ActorActionFunc = DoActorDecide;
        Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Run);
        u.track = Ai.FindTrackAwayFromPlayer(SpriteNum);
        if (u.track >= 0) {
            sp.setAng(Gameutils.NORM_ANGLE(EngineUtils.getAngle(Track.Track[u.track].TrackPoint[u.point].x - sp.getX(), Track.Track[u.track].TrackPoint[u.point].y - sp.getY())));
            Ai.DoActorSetSpeed(SpriteNum, 3);
            u.Flags |= Gameutils.SPR_RUN_AWAY;
        } else {
            u.Flags |= Gameutils.SPR_RUN_AWAY;
            InitActorReposition.animatorInvoke(SpriteNum);
        }
    }

    public static void InitActorExtra5Noise(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u != null) {
            u.ActorActionFunc = DoActorDecide;
        }
    }

    public static void InitActorRunToward(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        u.ActorActionFunc = DoActorDecide;
        Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Run);
        InitActorReposition.animatorInvoke(SpriteNum);
        Ai.DoActorSetSpeed(SpriteNum, 3);
    }

    public static void InitActorExtra6Noise(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u != null) {
            u.ActorActionFunc = DoActorDecide;
        }
    }

    public static boolean CHOOSE2(int value) {
        return Gameutils.RANDOM_P2(1024) < value;
    }

    public static void InitActorMoveCloser(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        u.ActorActionFunc = DoActorMoveCloser;
        if (u.getRot() != u.ActorActionSet.Run) {
            Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Run);
        }
        u.ActorActionFunc.animatorInvoke(SpriteNum);
    }

    public static void InitActorAttack(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        WangSprite tgtSpr = Main.boardService.getSprite(u.tgt_sp);
        if (tgtSpr != null) {
            USER tu = Gameutils.getUser(u.tgt_sp);
            if (tu != null && u.ID == 1095 && tu.PlayerP != -1) {
                if (sp.getOwner() == u.tgt_sp) {
                    return;
                }
                if (!Weapon.PlayerTakeDamage(Game.Player[tu.PlayerP], SpriteNum)) {
                    return;
                }
            }
            if (MyTypes.TEST(tgtSpr.getCstat(), Gameutils.CSTAT_SPRITE_TRANSLUCENT)) {
                Ai.InitActorRunAway(SpriteNum);
                return;
            }
            if (tu != null && tu.Health <= 0) {
                Ai.DoActorPickClosePlayer(SpriteNum);
                InitActorReposition.animatorInvoke(SpriteNum);
                return;
            }
            if (!Ai.CanHitPlayer(SpriteNum)) {
                InitActorReposition.animatorInvoke(SpriteNum);
                return;
            }
            if (tu != null && tu.PlayerP != -1 && MyTypes.TEST(Game.Player[tu.PlayerP].Flags, Gameutils.PF_DEAD)) {
                Ai.DoActorPickClosePlayer(SpriteNum);
                InitActorReposition.animatorInvoke(SpriteNum);
                return;
            }
            u.ActorActionFunc = DoActorAttack;
            sp.setAng(Gameutils.NORM_ANGLE(EngineUtils.getAngle(tgtSpr.getX() - sp.getX(), tgtSpr.getY() - sp.getY())));
            if (tu != null && u.ID == tu.ID && tu.PlayerP == -1) {
                Ai.InitActorRunAway(SpriteNum);
                return;
            }
        }
        if (u.ActorActionSet.Death2 != null && u.Health < 38 && Ai.CHOOSE2(100)) {
            u.ActorActionFunc = DoActorDecide;
            Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Death2);
            return;
        }
        u.ActorActionFunc.animatorInvoke(SpriteNum);
    }

    public static void InitActorEvade(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        u.ActorActionFunc = DoActorDecide;
        Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Run);
        u.track = Ai.FindTrackAwayFromPlayer(SpriteNum);
        if (u.track >= 0) {
            sp.setAng(Gameutils.NORM_ANGLE(EngineUtils.getAngle(Track.Track[u.track].TrackPoint[u.point].x - sp.getX(), Track.Track[u.track].TrackPoint[u.point].y - sp.getY())));
            Ai.DoActorSetSpeed(SpriteNum, 3);
            u.Flags &= ~Gameutils.SPR_RUN_AWAY;
        }
    }

    public static void DoActorMoveCloser(int SpriteNum) {
        int ny;
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        int nx = sp.getXvel() * EngineUtils.cos(Gameutils.NORM_ANGLE(sp.getAng())) >> 14;
        if (!Sprites.move_actor(SpriteNum, nx, ny = sp.getXvel() * EngineUtils.sin(Gameutils.NORM_ANGLE(sp.getAng())) >> 14, 0)) {
            if (Ai.ActorMoveHitReact(SpriteNum)) {
                return;
            }
            Ai.DoActorCantMoveCloser(SpriteNum);
            return;
        }
        Ai.DoActorNoise(Ai.ChooseAction(u.Personality.Broadcast), SpriteNum);
        if (u.DistCheck > 550) {
            u.DistCheck = 0;
            if (!Ai.CanSeePlayer(SpriteNum)) {
                Ai.InitActorDecide(SpriteNum);
                return;
            }
            WangSprite ts = Main.boardService.getSprite(u.tgt_sp);
            if (ts != null) {
                sp.setAng(EngineUtils.getAngle(ts.getX() - sp.getX(), ts.getY() - sp.getY()));
            }
        }
        if (u.Dist > 1536) {
            Ai.InitActorDecide(SpriteNum);
        }
    }

    private static int move_scan(int SpriteNum, int ang, int dist, LONGp stopx, LONGp stopy) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return 0;
        }
        int x = sp.getX();
        int y = sp.getY();
        int z = sp.getZ();
        short sang = sp.getAng();
        int loz = u.loz;
        int hiz = u.hiz;
        int lo_sp = u.lo_sp;
        int hi_sp = u.hi_sp;
        int lo_sectp = u.lo_sectp;
        int hi_sectp = u.hi_sectp;
        short ss = sp.getSectnum();
        sp.setAng(Gameutils.NORM_ANGLE(ang));
        int nx = dist * EngineUtils.sin(Gameutils.NORM_ANGLE(sp.getAng() + 512)) >> 14;
        int ny = dist * EngineUtils.sin(sp.getAng()) >> 14;
        int ret = Sprites.move_sprite(SpriteNum, nx, ny, 0, u.ceiling_dist, u.floor_dist, Gameutils.CLIPMASK_ACTOR, 1);
        stopx.value = sp.getX();
        stopy.value = sp.getY();
        sp.setX(x);
        sp.setY(y);
        sp.setZ(z);
        sp.setAng(sang);
        u.loz = loz;
        u.hiz = hiz;
        u.lo_sp = lo_sp;
        u.hi_sp = hi_sp;
        u.lo_sectp = lo_sectp;
        u.hi_sectp = hi_sectp;
        Main.engine.changespritesect(SpriteNum, ss);
        return ret;
    }

    private static int FindNewAngle(int SpriteNum, int dir, int DistToMove) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return 0;
        }
        if (Ai.ActorFlaming(SpriteNum)) {
            DistToMove = MyTypes.DIV4(DistToMove) + MyTypes.DIV8(DistToMove);
        }
        int oang = sp.getAng();
        WangSprite ts = Main.boardService.getSprite(u.tgt_sp);
        if (ts != null) {
            oang = Gameutils.NORM_ANGLE(EngineUtils.getAngle(ts.getX() - sp.getX(), ts.getY() - sp.getY()));
        }
        short[] adp = null;
        switch (dir) {
            case 1: {
                adp = toward_angle_delta[Gameutils.RANDOM_P2(1024) >> 8];
                break;
            }
            case -1: {
                adp = Ai.CanHitPlayer(SpriteNum) ? toward_angle_delta[Gameutils.RANDOM_P2(1024) >> 8] : away_angle_delta[Gameutils.RANDOM_P2(1024) >> 8];
            }
        }
        if (adp == null) {
            return 0;
        }
        int save_ang = -1;
        int save_dist = 500;
        int ptr = 0;
        while (adp[ptr] != -99) {
            block17: {
                int new_ang;
                block16: {
                    new_ang = Gameutils.NORM_ANGLE(oang + adp[ptr]);
                    if (MyTypes.TEST(u.Flags, Gameutils.SPR_NO_SCAREDZ | Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING | Gameutils.SPR_SWIMMING | Gameutils.SPR_DEAD)) break block16;
                    sp.setAng(new_ang);
                    boolean isDropAhead = Sprites.DropAhead(SpriteNum, u.lo_step);
                    sp.setAng(oang);
                    if (isDropAhead) break block17;
                }
                int ret = Ai.move_scan(SpriteNum, new_ang, DistToMove, Game.tmp_ptr[0], Game.tmp_ptr[1]);
                int stopx = Game.tmp_ptr[0].value;
                int stopy = Game.tmp_ptr[1].value;
                if (ret == 0) {
                    u.TargetDist = Game.Distance(sp.getX(), sp.getY(), stopx, stopy);
                    return new_ang;
                }
                int dist = Game.Distance(sp.getX(), sp.getY(), stopx, stopy);
                if (dist > save_dist) {
                    save_ang = new_ang;
                    save_dist = dist;
                }
            }
            ++ptr;
        }
        if (save_ang != -1) {
            u.TargetDist = save_dist;
            if (u.TargetDist > 4000) {
                u.TargetDist -= 3500;
            }
            sp.setAng(save_ang);
            return save_ang;
        }
        return -1;
    }

    public static void InitActorPause(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        u.ActorActionFunc = DoActorPause;
        u.ActorActionFunc.animatorInvoke(SpriteNum);
    }

    public static void AiSaveable() {
        Saveable.SaveData(InitActorDecide);
        Saveable.SaveData(DoActorDecide);
        Saveable.SaveData(InitActorAlertNoise);
        Saveable.SaveData(InitActorAmbientNoise);
        Saveable.SaveData(InitActorAttackNoise);
        Saveable.SaveData(InitActorPainNoise);
        Saveable.SaveData(InitActorDieNoise);
        Saveable.SaveData(InitActorExtra1Noise);
        Saveable.SaveData(InitActorExtra2Noise);
        Saveable.SaveData(InitActorExtra3Noise);
        Saveable.SaveData(InitActorExtra4Noise);
        Saveable.SaveData(InitActorExtra5Noise);
        Saveable.SaveData(InitActorExtra6Noise);
        Saveable.SaveData(InitActorMoveCloser);
        Saveable.SaveData(DoActorMoveCloser);
        Saveable.SaveData(InitActorRunAway);
        Saveable.SaveData(InitActorRunToward);
        Saveable.SaveData(InitActorAttack);
        Saveable.SaveData(DoActorAttack);
        Saveable.SaveData(InitActorEvade);
        Saveable.SaveData(InitActorWanderAround);
        Saveable.SaveData(InitActorFindPlayer);
        Saveable.SaveData(InitActorDuck);
        Saveable.SaveData(DoActorDuck);
        Saveable.SaveData(DoActorMoveJump);
        Saveable.SaveData(InitActorReposition);
        Saveable.SaveData(DoActorReposition);
        Saveable.SaveData(DoActorPause);
    }

    public static void DoActorAttack(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        Ai.DoActorNoise(Ai.ChooseAction(u.Personality.Broadcast), SpriteNum);
        int dist = Integer.MAX_VALUE;
        WangSprite ts = Main.boardService.getSprite(u.tgt_sp);
        if (ts != null) {
            dist = Gameutils.DISTANCE(sp.getX(), sp.getY(), ts.getX(), ts.getY());
        }
        USER pu = Gameutils.getUser(Ai.GetPlayerSpriteNum(SpriteNum));
        if (ts != null && u.ActorActionSet.CloseAttack[0] != null && dist < Ai.CloseRangeDist(sp, ts) || pu != null && pu.WeaponNum == 0) {
            int rand_num = Ai.ChooseActionNumber(u.ActorActionSet.CloseAttackPercent);
            Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.CloseAttack[rand_num]);
        } else {
            int rand_num = Ai.ChooseActionNumber(u.ActorActionSet.AttackPercent);
            Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Attack[rand_num]);
            u.ActorActionFunc = DoActorDecide;
        }
    }

    public static void InitActorWanderAround(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        u.ActorActionFunc = DoActorDecide;
        Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Run);
        Ai.DoActorPickClosePlayer(SpriteNum);
        u.track = Ai.FindWanderTrack(SpriteNum);
        if (u.track >= 0) {
            sp.setAng(EngineUtils.getAngle(Track.Track[u.track].TrackPoint[u.point].x - sp.getX(), Track.Track[u.track].TrackPoint[u.point].y - sp.getY()));
            Ai.DoActorSetSpeed(SpriteNum, 1);
        }
    }

    public static void InitActorFindPlayer(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        u.ActorActionFunc = DoActorDecide;
        Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Run);
        u.track = Ai.FindTrackToPlayer(SpriteNum);
        if (u.track >= 0) {
            sp.setAng(EngineUtils.getAngle(Track.Track[u.track].TrackPoint[u.point].x - sp.getX(), Track.Track[u.track].TrackPoint[u.point].y - sp.getY()));
            Ai.DoActorSetSpeed(SpriteNum, 2);
            u.Flags |= Gameutils.SPR_FIND_PLAYER;
            u.ActorActionFunc = DoActorDecide;
            Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Run);
        } else {
            InitActorReposition.animatorInvoke(SpriteNum);
        }
    }

    public static void InitActorDuck(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if (u.ActorActionSet.Duck == null) {
            u.ActorActionFunc = DoActorDecide;
            return;
        }
        u.ActorActionFunc = DoActorDuck;
        Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Duck);
        WangSprite ts = Main.boardService.getSprite(u.tgt_sp);
        if (ts != null) {
            int dist = Game.Distance(sp.getX(), sp.getY(), ts.getX(), ts.getY());
            u.WaitTics = dist > 8000 ? 190 : 60;
        }
        u.ActorActionFunc.animatorInvoke(SpriteNum);
    }

    public static void DoActorDuck(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u != null && (u.WaitTics -= 6) < 0) {
            Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Rise);
            u.ActorActionFunc = DoActorDecide;
            u.Flags &= ~Gameutils.SPR_TARGETED;
        }
    }

    public static void DoActorMoveJump(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        int nx = sp.getXvel() * EngineUtils.cos(Gameutils.NORM_ANGLE(sp.getAng())) >> 14;
        int ny = sp.getXvel() * EngineUtils.sin(Gameutils.NORM_ANGLE(sp.getAng())) >> 14;
        Sprites.move_actor(SpriteNum, nx, ny, 0);
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            Ai.InitActorDecide(SpriteNum);
        }
    }

    public static void InitActorReposition(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        u.Dist = 0;
        int rnum = Gameutils.RANDOM_P2(2048) >> 8;
        WangSprite ts = Main.boardService.getSprite(u.tgt_sp);
        int dist = Integer.MAX_VALUE;
        if (ts != null) {
            dist = Game.Distance(sp.getX(), sp.getY(), ts.getX(), ts.getY());
        }
        if (dist < PlayerDist[rnum] || MyTypes.TEST(u.Flags, Gameutils.SPR_RUN_AWAY)) {
            rnum = Gameutils.RANDOM_P2(2048) >> 8;
            int ang = Ai.FindNewAngle(SpriteNum, -1, AwayDist[rnum]);
            if (ang == -1) {
                u.Vis = 8;
                Ai.InitActorPause(SpriteNum);
                return;
            }
            sp.setAng(ang);
            Ai.DoActorSetSpeed(SpriteNum, 3);
            u.Flags &= ~Gameutils.SPR_RUN_AWAY;
        } else {
            rnum = Gameutils.RANDOM_P2(2048) >> 8;
            int ang = Ai.FindNewAngle(SpriteNum, 1, TowardDist[rnum]);
            if (ang == -1) {
                rnum = Gameutils.RANDOM_P2(2048) >> 8;
                ang = Ai.FindNewAngle(SpriteNum, -1, AwayDist[rnum]);
                if (ang == -1) {
                    u.Vis = 8;
                    Ai.InitActorPause(SpriteNum);
                    return;
                }
            } else if (Gameutils.RANDOM_P2(1024) < 512) {
                Ai.DoActorSetSpeed(SpriteNum, 1);
            } else {
                Ai.DoActorSetSpeed(SpriteNum, 2);
            }
            sp.setAng(ang);
        }
        u.ActorActionFunc = DoActorReposition;
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_SWIMMING)) {
            Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Run);
        }
        u.ActorActionFunc.animatorInvoke(SpriteNum);
    }

    public static void DoActorReposition(int SpriteNum) {
        int ny;
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        int nx = sp.getXvel() * EngineUtils.sin(Gameutils.NORM_ANGLE(sp.getAng() + 512)) >> 14;
        if (!Sprites.move_actor(SpriteNum, nx, ny = sp.getXvel() * EngineUtils.sin(Gameutils.NORM_ANGLE(sp.getAng())) >> 14, 0)) {
            if (Ai.ActorMoveHitReact(SpriteNum)) {
                return;
            }
            u.Vis = 6;
            Ai.InitActorPause(SpriteNum);
            return;
        }
        if (u.TargetDist < 50) {
            Ai.InitActorDecide(SpriteNum);
        }
    }

    public static void DoActorPause(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u != null && (u.Vis -= 6) < 0) {
            u.ActorActionFunc = DoActorDecide;
            u.Flags &= ~Gameutils.SPR_TARGETED;
        }
    }

    public static enum Attrib_Snds {
        attr_ambient,
        attr_alert,
        attr_attack,
        attr_pain,
        attr_die,
        attr_extra1,
        attr_extra2,
        attr_extra3,
        attr_extra4,
        attr_extra5,
        attr_extra6;

    }
}

