/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import com.badlogic.gdx.Gdx;
import java.util.List;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.Tools.Interpolation;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.RenderedSpriteList;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.Types.font.BitmapFont;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Wang.Cheats;
import ru.m210projects.Wang.Enemies.Sumo;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Inv;
import ru.m210projects.Wang.JPlayer;
import ru.m210projects.Wang.JSector;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Panel;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Quake;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Text;
import ru.m210projects.Wang.Type.INVENTORY_DATA;
import ru.m210projects.Wang.Type.LONGp;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.ParentalStruct;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.Sect_User;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Vis;
import ru.m210projects.Wang.Weapon;

public class Draw {
    public static final int INVISTILE = 6145;
    public static final int MINI_BAR_HEALTH_BOX_PIC = 2437;
    public static final int MINI_BAR_AMMO_BOX_PIC = 2437;
    public static final int MINI_BAR_INVENTORY_BOX_PIC = 2438;
    public static final int MINI_BAR_HEALTH_BOX_X = 4;
    private static final short[] RotTable8 = new short[]{0, 7, 6, 5, 4, 3, 2, 1};
    private static final short[] RotTable5 = new short[]{0, 1, 2, 3, 4, 3, 2, 1};
    private static final char[] txt_buffer = new char[256];
    private static final int DART_PIC = 2526;
    private static final int DART_REPEAT = 16;
    private static final short[] CompassPic = new short[]{2386, 2387, 2380, 2381, 2390, 2391, 2380, 2381, 2384, 2385, 2380, 2381, 2390, 2391, 2380, 2381, 2388, 2389, 2380, 2381, 2390, 2391, 2380, 2381, 2382, 2383, 2380, 2381, 2390, 2391, 2380, 2381};
    public static int gPlayerIndex = -1;
    public static final boolean[] bCopySpriteOffs = new boolean[Engine.MAXSPRITES];
    public static int dimensionmode;
    public static boolean ScrollMode2D;
    public static final boolean NoMeters = false;
    public static int gNameShowTime;
    public static int Follow_posx;
    public static int Follow_posy;
    public static int zoom;
    public static final ParentalStruct[] aVoxelArray;
    public static boolean OverlapDraw;
    public static final short[] CompassShade;
    private static final short[] viewWeaponTile;
    private static int ang;
    private static int lv_sectnum;
    private static int lv_x;
    private static int lv_y;
    private static int lv_z;

    public static void ShadeSprite(Sprite tsp) {
        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(tsp.getSectnum());
        if (sec == null) {
            return;
        }
        tsp.setShade((byte)(sec.getFloorshade() - 25));
        if (tsp.getShade() > -3) {
            tsp.setShade(-3);
        }
        if (tsp.getShade() < -30) {
            tsp.setShade(-30);
        }
    }

    public static int GetRotation(TSprite tsp, int viewx, int viewy) {
        USER tu = Gameutils.getUser(tsp.getOwner());
        if (tu == null || tu.RotNum == 0) {
            return 0;
        }
        int angle2 = EngineUtils.getAngle(tsp.getX() - viewx, tsp.getY() - viewy);
        int rotation = tsp.getAng() + 3072 + 128 - angle2 & 0x7FF;
        rotation = rotation >> 8 & 7;
        if (tu.RotNum == 5) {
            if (MyTypes.TEST(tu.Flags, Gameutils.SPR_XFLIP_TOGGLE)) {
                if (rotation <= 4) {
                    tsp.setCstat(tsp.getCstat() & ~Gameutils.CSTAT_SPRITE_XFLIP);
                } else {
                    rotation = 8 - rotation;
                    tsp.setCstat(tsp.getCstat() | Gameutils.CSTAT_SPRITE_XFLIP);
                }
            } else if (rotation > 3 || rotation == 0) {
                tsp.setCstat(tsp.getCstat() & ~Gameutils.CSTAT_SPRITE_XFLIP);
            } else {
                rotation = 8 - rotation;
                tsp.setCstat(tsp.getCstat() | Gameutils.CSTAT_SPRITE_XFLIP);
            }
            if (tu.ID == 5023 || tu.ID == 5032 || tu.ID == 2540 || tu.ID == 4594 || tu.ID == 4590 || tu.ID == 4604 || tu.ID == 4600) {
                tsp.setCstat(tsp.getCstat() & ~Gameutils.CSTAT_SPRITE_XFLIP);
            }
            return RotTable5[rotation];
        }
        return RotTable8[rotation];
    }

    public static void SetActorRotation(TSprite tsp, int viewx, int viewy) {
        USER tu = Gameutils.getUser(tsp.getOwner());
        if (tu == null || tu.RotNum == 0 || tu.getRot() == null) {
            return;
        }
        State State2 = tu.State;
        State StateStart = tu.StateStart;
        int StateOffset = State2.id - StateStart.id;
        int Rotation = Draw.GetRotation(tsp, viewx, viewy);
        if (Rotation >= 5) {
            return;
        }
        State2 = tu.getRot().getState(Rotation, StateOffset);
        tsp.setPicnum(State2.Pic);
    }

    public static int DoShadowFindGroundPoint(Sprite sp) {
        short save_cstat = sp.getCstat();
        sp.setCstat(sp.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        Rooms.FAFgetzrangepoint(sp.getX(), sp.getY(), sp.getZ(), sp.getSectnum(), Game.tmp_ptr[0], Game.tmp_ptr[1], Game.tmp_ptr[2], Game.tmp_ptr[3]);
        sp.setCstat(save_cstat);
        int loz = Game.tmp_ptr[2].value;
        int florhit = Game.tmp_ptr[3].value;
        switch (MyTypes.DTEST(florhit, -536870912)) {
            case -1073741824: {
                WangSprite hsp = Main.boardService.getSprite(Gameutils.NORM_HIT_INDEX(florhit));
                if (hsp == null) {
                    return loz;
                }
                if (MyTypes.TEST(hsp.getCstat(), Gameutils.CSTAT_SPRITE_FLOOR)) {
                    return loz;
                }
                short bak_cstat = hsp.getCstat();
                hsp.setCstat(hsp.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
                loz = Draw.DoShadowFindGroundPoint(sp);
                hsp.setCstat(bak_cstat);
            }
            case 0x40000000: {
                return loz;
            }
        }
        return loz;
    }

    public static void DoShadows(TSprite tsp, int viewx, int viewy, int viewz) {
        int yrepeat;
        int xrepeat;
        Renderer renderer = Main.game.getRenderer();
        RenderedSpriteList renderedSpriteList = renderer.getRenderedSprites();
        USER tu = Gameutils.getUser(tsp.getOwner());
        if (tu == null) {
            return;
        }
        int sectnum = Main.engine.updatesector(tsp.getX(), tsp.getY(), tsp.getSectnum());
        if (sectnum == -1 || renderedSpriteList.getSize() >= 1024) {
            return;
        }
        TSprite newtsp = (TSprite)renderedSpriteList.obtain();
        newtsp.set(tsp);
        newtsp.update(tsp.getX(), tsp.getY(), tsp.getZ(), sectnum);
        newtsp.setStatnum(1024);
        if (tsp.getYrepeat() >> 2 > 4) {
            xrepeat = newtsp.getXrepeat();
            yrepeat = (tsp.getYrepeat() >> 2) - Gameutils.SPRITEp_SIZE_Y(tsp) / 64 * 2;
        } else {
            xrepeat = newtsp.getXrepeat();
            yrepeat = newtsp.getYrepeat();
        }
        newtsp.setShade(127);
        newtsp.setCstat(newtsp.getCstat() | Gameutils.CSTAT_SPRITE_TRANSLUCENT);
        int loz = tu.loz;
        WangSprite losp = Main.boardService.getSprite(tu.lo_sp);
        if (losp != null && !MyTypes.TEST(losp.getCstat(), Gameutils.CSTAT_SPRITE_WALL | Gameutils.CSTAT_SPRITE_FLOOR)) {
            loz = Draw.DoShadowFindGroundPoint(tsp);
        }
        int camangle = EngineUtils.getAngle(viewx - tsp.getX(), viewy - tsp.getY());
        newtsp.setX(newtsp.getX() - Pragmas.mulscale(EngineUtils.sin(camangle + 512 & 0x7FF), 100L, 16));
        newtsp.setY(newtsp.getY() + Pragmas.mulscale(EngineUtils.sin(camangle + 1024 & 0x7FF), 100L, 16));
        newtsp.setZ(loz);
        if (viewz - loz > -Gameutils.Z(8)) {
            renderedSpriteList.removeLast();
            return;
        }
        int view_dist = Pragmas.klabs(loz - viewz) >> 8;
        view_dist = view_dist < 32 ? 256 / view_dist : 0;
        int ground_dist = Pragmas.klabs(loz - Gameutils.SPRITEp_BOS(tsp)) >> 8;
        ground_dist = MyTypes.DIV16(ground_dist);
        xrepeat = Math.max(xrepeat - ground_dist - view_dist, 4);
        yrepeat = Math.max(yrepeat - ground_dist - view_dist, 4);
        xrepeat = Math.min(xrepeat, 255);
        yrepeat = Math.min(yrepeat, 255);
        newtsp.setXrepeat(xrepeat);
        newtsp.setYrepeat(yrepeat);
    }

    public static void DoMotionBlur(Sprite tsp) {
        int nz;
        int dy;
        int ny;
        int dx;
        int nx;
        Renderer renderer = Main.game.getRenderer();
        USER tu = Gameutils.getUser(tsp.getOwner());
        if (tu == null || tsp.getXvel() == 0) {
            return;
        }
        ang = Gameutils.NORM_ANGLE(tsp.getAng() + 1024);
        int z_amt_per_pixel = MyTypes.TEST(tsp.getExtra(), Gameutils.SPRX_PLAYER_OR_ENEMY) ? (-tu.jump_speed * 6 << 16) / tsp.getXvel() : (-tsp.getZvel() << 16) / tsp.getXvel();
        switch (tu.motion_blur_dist) {
            case 64: {
                dx = nx = Gameutils.MOVEx(64, ang);
                dy = ny = Gameutils.MOVEy(64, ang);
                nz = z_amt_per_pixel * 64 >> 16;
                break;
            }
            case 128: {
                dx = nx = Gameutils.MOVEx(128, ang);
                dy = ny = Gameutils.MOVEy(128, ang);
                nz = z_amt_per_pixel * 128 >> 16;
                break;
            }
            case 256: {
                dx = nx = Gameutils.MOVEx(256, ang);
                dy = ny = Gameutils.MOVEy(256, ang);
                nz = z_amt_per_pixel * 256 >> 16;
                break;
            }
            case 512: {
                dx = nx = Gameutils.MOVEx(512, ang);
                dy = ny = Gameutils.MOVEy(512, ang);
                nz = z_amt_per_pixel * 512 >> 16;
                break;
            }
            default: {
                dx = nx = Gameutils.MOVEx(tu.motion_blur_dist, ang);
                dy = ny = Gameutils.MOVEy(tu.motion_blur_dist, ang);
                nz = 0;
            }
        }
        int dz = nz;
        int xrepeat = tsp.getXrepeat();
        int yrepeat = tsp.getYrepeat();
        int repeat_adj = 0;
        switch (MyTypes.DTEST(tu.Flags2, Gameutils.SPR2_BLUR_TAPER)) {
            case 0: {
                break;
            }
            case 16384: {
                repeat_adj = xrepeat / (tu.motion_blur_num * 2);
                break;
            }
            case 8192: {
                repeat_adj = xrepeat / tu.motion_blur_num;
            }
        }
        RenderedSpriteList renderedSpriteList = renderer.getRenderedSprites();
        for (int i = 0; i < tu.motion_blur_num; ++i) {
            if (renderedSpriteList.getSize() >= 1024) {
                return;
            }
            Sprite newsp = (Sprite)renderedSpriteList.obtain();
            newsp.set(tsp);
            newsp.setCstat(newsp.getCstat() | (Gameutils.CSTAT_SPRITE_TRANSLUCENT | Gameutils.CSTAT_SPRITE_TRANS_FLIP));
            newsp.setX(newsp.getX() + dx);
            newsp.setY(newsp.getY() + dy);
            dx += nx;
            dy += ny;
            newsp.setZ(newsp.getZ() + dz);
            dz += nz;
            newsp.setXrepeat(xrepeat);
            newsp.setYrepeat(yrepeat);
            xrepeat -= repeat_adj;
            yrepeat -= repeat_adj;
        }
    }

    public static void WarpCopySprite() {
        Renderer renderer = Main.game.getRenderer();
        RenderedSpriteList renderedSpriteList = renderer.getRenderedSprites();
        ListNode<Sprite> n = Main.boardService.getStatNode(63);
        while (n != null) {
            ListNode<Sprite> nsn = n.getNext();
            Sprite sp1 = n.get();
            short match = sp1.getLotag();
            ListNode<Sprite> n2 = Main.boardService.getStatNode(64);
            while (n2 != null) {
                ListNode<Sprite> nsn2 = n2.getNext();
                Sprite sp = n2.get();
                if (sp.getLotag() == match) {
                    Interpolation.ILoc oldLoc;
                    int zoff;
                    int yoff;
                    int xoff;
                    TSprite newtsp;
                    Sprite spr;
                    ListNode<Sprite> next_spnum;
                    int spnum;
                    short sect1 = sp1.getSectnum();
                    short sect2 = sp.getSectnum();
                    ListNode<Sprite> node = Main.boardService.getSectNode(sect1);
                    while (node != null) {
                        spnum = node.getIndex();
                        next_spnum = node.getNext();
                        spr = node.get();
                        if (spr != sp1 && spr.getPicnum() != 2307 && renderedSpriteList.getSize() < 1024) {
                            newtsp = (TSprite)renderedSpriteList.obtain();
                            newtsp.set(spr);
                            newtsp.setOwner(spnum);
                            newtsp.setStatnum(0);
                            xoff = sp1.getX() - newtsp.getX();
                            yoff = sp1.getY() - newtsp.getY();
                            zoff = sp1.getZ() - newtsp.getZ();
                            oldLoc = Main.game.pInt.getsprinterpolate(spnum);
                            if (oldLoc != null && !bCopySpriteOffs[spnum]) {
                                oldLoc.x += sp.getX() - sp1.getX();
                                oldLoc.y += sp.getY() - sp1.getY();
                                oldLoc.z += sp.getZ() - sp1.getZ();
                                Draw.bCopySpriteOffs[spnum] = true;
                            }
                            newtsp.update(sp.getX() - xoff, sp.getY() - yoff, sp.getZ() - zoff, sp.getSectnum());
                        }
                        node = next_spnum;
                    }
                    node = Main.boardService.getSectNode(sect2);
                    while (node != null) {
                        spnum = node.getIndex();
                        next_spnum = node.getNext();
                        spr = node.get();
                        if (spr != sp && spr.getPicnum() != 2307 && renderedSpriteList.getSize() < 1024) {
                            newtsp = (TSprite)renderedSpriteList.obtain();
                            newtsp.set(spr);
                            newtsp.setOwner(spnum);
                            newtsp.setStatnum(0);
                            xoff = sp.getX() - newtsp.getX();
                            yoff = sp.getY() - newtsp.getY();
                            zoff = sp.getZ() - newtsp.getZ();
                            oldLoc = Main.game.pInt.getsprinterpolate(spnum);
                            if (oldLoc != null && !bCopySpriteOffs[spnum]) {
                                oldLoc.x += sp.getX() - sp1.getX();
                                oldLoc.y += sp.getY() - sp1.getY();
                                oldLoc.z += sp.getZ() - sp1.getZ();
                                Draw.bCopySpriteOffs[spnum] = true;
                            }
                            newtsp.update(sp1.getX() - xoff, sp1.getY() - yoff, sp1.getZ() - zoff, sp1.getSectnum());
                        }
                        node = next_spnum;
                    }
                }
                n2 = nsn2;
            }
            n = nsn;
        }
    }

    public static void DoStarView(Sprite tsp, USER tu, int viewz) {
        int zdiff = viewz - tsp.getZ();
        if (Pragmas.klabs(zdiff) > Gameutils.Z(24)) {
            if (tu.StateStart == Weapon.s_StarStuck[0]) {
                tsp.setPicnum(Weapon.s_StarDownStuck[tu.State.id - Weapon.s_StarStuck[0].id].Pic);
            } else {
                tsp.setPicnum(Weapon.s_StarDown[tu.State.id - Weapon.s_Star[0].id].Pic);
            }
        }
        if (zdiff > 0) {
            tsp.setCstat(tsp.getCstat() | Gameutils.CSTAT_SPRITE_YFLIP);
        }
    }

    public static void analyzesprites(int viewx, int viewy, int viewz, boolean mirror, int smoothratio) {
        Renderer renderer = Main.game.getRenderer();
        PlayerStr pp = Game.Player[Game.screenpeek];
        Sprite psp = pp.getSprite();
        if (psp == null) {
            return;
        }
        ang = Gameutils.NORM_ANGLE(ang + 12);
        int smr4 = (int)((long)smoothratio + ((long)Sprites.MoveSkip4 << 16));
        int smr2 = smoothratio + ((Sprites.MoveSkip2 ? 1 : 0) << 16);
        RenderedSpriteList renderedSpriteList = renderer.getRenderedSprites();
        if (OverlapDraw) {
            Draw.PreDrawStackedWater();
        }
        for (int tSpriteNum = renderedSpriteList.getSize() - 1; tSpriteNum >= 0; --tSpriteNum) {
            ru.m210projects.Build.Types.Sector sec;
            TSprite tsp = (TSprite)renderedSpriteList.get(tSpriteNum);
            short SpriteNum = tsp.getOwner();
            if (SpriteNum == -1) continue;
            USER tu = Gameutils.getUser(SpriteNum);
            if (tsp.getStatnum() >= 47) {
                tsp.setOwner(-1);
                continue;
            }
            if (Main.cfg.ParentalLock) {
                if (Draw.aVoxelArray[tsp.getPicnum()].Parental == 6145) {
                    tsp.setOwner(-1);
                    tu = null;
                } else if (Draw.aVoxelArray[tsp.getPicnum()].Parental > 0) {
                    tsp.setPicnum(Draw.aVoxelArray[tsp.getPicnum()].Parental);
                }
            }
            if (mirror) {
                Main.game.pInt.dospriteinterp(tsp, smoothratio);
                Main.game.pIntSkip2.dospriteinterp(tsp, smoothratio);
                Main.game.pIntSkip4.dospriteinterp(tsp, smoothratio);
            }
            if (tu != null) {
                if (tsp.getStatnum() != 0) {
                    if (MyTypes.TEST(tu.Flags, Gameutils.SPR_SKIP4) && tsp.getStatnum() <= 9) {
                        tsp.setX(tu.ox + Pragmas.mulscale(tsp.getX() - tu.ox, smr4, 18));
                        tsp.setY(tu.oy + Pragmas.mulscale(tsp.getY() - tu.oy, smr4, 18));
                        tsp.setZ(tu.oz + Pragmas.mulscale(tsp.getZ() - tu.oz, smr4, 18));
                    }
                    if (MyTypes.TEST(tu.Flags, Gameutils.SPR_SKIP2) && tsp.getStatnum() <= 5) {
                        tsp.setX(tu.ox + Pragmas.mulscale(tsp.getX() - tu.ox, smr2, 17));
                        tsp.setY(tu.oy + Pragmas.mulscale(tsp.getY() - tu.oy, smr2, 17));
                        tsp.setZ(tu.oz + Pragmas.mulscale(tsp.getZ() - tu.oz, smr2, 17));
                    }
                }
                if (Main.cfg.Shadows && MyTypes.TEST(tu.Flags, Gameutils.SPR_SHADOW)) {
                    Draw.DoShadows(tsp, viewx, viewy, viewz);
                }
                if (Main.cfg.UseDarts && (tu.ID == 1793 || tsp.getPicnum() == 1793)) {
                    tsp.setPicnum(2519);
                    tsp.setXrepeat(27);
                    tsp.setYrepeat(29);
                }
                if (tu.ID == 2049) {
                    if (Main.cfg.UseDarts) {
                        tsp.setPicnum(2526);
                        tsp.setAng(Gameutils.NORM_ANGLE(tsp.getAng() - 512 - 24));
                        tsp.setXrepeat(16);
                        tsp.setYrepeat(16);
                        tsp.setCstat(tsp.getCstat() | Gameutils.CSTAT_SPRITE_WALL);
                    } else {
                        Draw.DoStarView(tsp, tu, viewz);
                    }
                } else if (tu.ID == 817) {
                    int fz = Main.engine.getflorzofslope(tsp.getSectnum(), tsp.getX(), tsp.getY());
                    if (tsp.getZ() > fz) {
                        tsp.setZ(fz);
                    }
                }
                if (tu.RotNum > 0) {
                    Draw.SetActorRotation(tsp, viewx, viewy);
                }
                if (tu.motion_blur_num != 0) {
                    Draw.DoMotionBlur(tsp);
                }
                if ((sec = Main.boardService.getSector(tsp.getSectnum())) == null) continue;
                if (tsp.getPal() != sec.getFloorpal()) {
                    if (sec.getFloorpal() == 0) {
                        tsp.setPal(tu.spal);
                    } else {
                        Sect_User sectu = Sector.getSectUser(tsp.getSectnum());
                        short pal = sec.getFloorpal();
                        boolean nosectpal = false;
                        if (sectu != null && MyTypes.TEST(sectu.flags, Gameutils.SECTFU_DONT_COPY_PALETTE)) {
                            pal = 0;
                            nosectpal = true;
                        }
                        if (tsp.getHitag() != Gameutils.SECTFU_DONT_COPY_PALETTE && tsp.getHitag() != 9999 && !nosectpal && pal != 1 && pal != 9 && pal != 5) {
                            tsp.setPal(pal);
                        } else {
                            tsp.setPal(tu.spal);
                        }
                    }
                }
                if (tsp.getHitag() == 9997) {
                    tsp.setPal(14);
                    WangSprite spr = Main.boardService.getSprite(SpriteNum);
                    if (spr != null) {
                        spr.setHitag(0);
                    }
                }
            }
            if (Main.cfg.UseDarts && tsp.getStatnum() == 43) {
                tsp.setPicnum(2526);
                tsp.setAng(Gameutils.NORM_ANGLE(tsp.getAng() - 512));
                tsp.setXrepeat(16);
                tsp.setYrepeat(16);
                tsp.setCstat(tsp.getCstat() | Gameutils.CSTAT_SPRITE_WALL);
            }
            JSector.JAnalyzeSprites(tsp);
            if (tu != null && tu.PlayerP != -1) {
                long dist;
                int ty;
                int tx;
                int angle;
                if (!MyTypes.TEST(tsp.getCstat(), Gameutils.CSTAT_SPRITE_TRANSLUCENT)) {
                    Draw.ShadeSprite(tsp);
                }
                if (Game.Player[Game.screenpeek].PlayerSprite == SpriteNum) {
                    pp = Game.Player[Game.screenpeek];
                    if (mirror || MyTypes.TEST(pp.Flags, Gameutils.PF_VIEW_FROM_OUTSIDE | Gameutils.PF_VIEW_FROM_CAMERA)) {
                        if (MyTypes.TEST(pp.Flags, Gameutils.PF_VIEW_FROM_OUTSIDE)) {
                            tsp.setCstat(tsp.getCstat() | Gameutils.CSTAT_SPRITE_TRANSLUCENT);
                        }
                        if (MyTypes.TEST(pp.Flags, Gameutils.PF_CLIMBING)) {
                            tsp.setX(pp.six + Gameutils.MOVEx(208, tsp.getAng()));
                            tsp.setY(pp.siy + Gameutils.MOVEy(208, tsp.getAng()));
                        } else {
                            tsp.setX(pp.six);
                            tsp.setY(pp.siy);
                        }
                        tsp.setZ(tsp.getZ() + pp.siz);
                        tsp.setAng(pp.siang);
                    } else {
                        tsp.setOwner(-1);
                    }
                }
                if (Pragmas.klabs(Pragmas.mulscale(angle = (1024 + EngineUtils.getAngle(tx = tsp.getX() - viewx, ty = tsp.getY() - viewy) - pp.getAnglei() & 0x7FF) - 1024, dist = (long)EngineUtils.qdist(tx, ty), 14)) < 4) {
                    int zTop;
                    int horizoff = 100 - pp.getHorizi();
                    long z1 = Pragmas.mulscale(dist, horizoff, 3) + viewz;
                    int zBot = zTop = tsp.getZ();
                    ArtEntry pic = Main.engine.getTile(tsp.getPicnum());
                    byte yoffs = pic.getOffsetY();
                    if (z1 < (long)(zBot += -yoffs * (tsp.getYrepeat() << 2)) && z1 > (long)(zTop -= (yoffs + pic.getHeight()) * (tsp.getYrepeat() << 2)) && Main.engine.cansee(viewx, viewy, viewz, psp.getSectnum(), tsp.getX(), tsp.getY(), tsp.getZ(), tsp.getSectnum())) {
                        gPlayerIndex = tu.PlayerP;
                    }
                }
            }
            switch (tsp.getStatnum()) {
                case 2: 
                case 3: 
                case 11: {
                    break;
                }
                default: {
                    int newshade = tsp.getShade();
                    if ((newshade += 6) > 127) {
                        newshade = 127;
                    }
                    tsp.setShade((byte)newshade);
                }
            }
            sec = Main.boardService.getSector(tsp.getSectnum());
            if (sec == null) continue;
            int newshade = tsp.getShade();
            newshade = MyTypes.TEST(sec.getCeilingstat(), Gameutils.CEILING_STAT_PLAX) ? (newshade += sec.getCeilingshade()) : (newshade += sec.getFloorshade());
            if (newshade > 127) {
                newshade = 127;
            }
            if (newshade < -128) {
                newshade = -128;
            }
            tsp.setShade(newshade);
            if (tsp.getHitag() == 9998) {
                tsp.setShade(127);
            }
            if (tsp.getHitag() == 9999) {
                tsp.setShade(-128);
            }
            if (pp.NightVision && MyTypes.TEST(tsp.getExtra(), Gameutils.SPRX_PLAYER_OR_ENEMY)) {
                if (tu != null && tu.ID == 2540) continue;
                tsp.setPal(32);
                tsp.setShade(-128);
            }
            if (tu == null || tu.PlayerP == -1 || !MyTypes.TEST(tu.Flags2, Gameutils.SPR2_VIS_SHADING)) continue;
            if (Game.Player[Game.screenpeek].PlayerSprite != SpriteNum && !MyTypes.TEST(Game.Player[tu.PlayerP].Flags, Gameutils.PF_VIEW_FROM_OUTSIDE)) {
                tsp.setCstat(tsp.getCstat() & ~Gameutils.CSTAT_SPRITE_TRANSLUCENT);
            }
            tsp.setShade((byte)(12 - Gameutils.STD_RANDOM_RANGE(30)));
        }
        Draw.WarpCopySprite();
    }

    private static void show_weapon(USER pp, Sprite tspr) {
        Renderer renderer = Main.game.getRenderer();
        RenderedSpriteList renderedSpriteList = renderer.getRenderedSprites();
        if (renderedSpriteList.getSize() >= 1024) {
            return;
        }
        int WeaponNum = pp.WeaponNum;
        if (viewWeaponTile[WeaponNum] == -1) {
            return;
        }
        Sprite pTEffect = (Sprite)renderedSpriteList.obtain();
        pTEffect.set(tspr);
        pTEffect.setZ(tspr.getZ() - 20480);
        pTEffect.setCstat(0);
        pTEffect.setAng(pTEffect.getAng() + 512);
        pTEffect.setAng(pTEffect.getAng() & 0x7FF);
        pTEffect.setPicnum(viewWeaponTile[WeaponNum]);
        pTEffect.setShade(tspr.getShade());
        pTEffect.setXrepeat(32);
        pTEffect.setYrepeat(32);
    }

    public static Sprite get_tsprite(int SpriteNum) {
        Renderer renderer = Main.game.getRenderer();
        RenderedSpriteList renderedSpriteList = renderer.getRenderedSprites();
        for (int tSpriteNum = renderedSpriteList.getSize() - 1; tSpriteNum >= 0; --tSpriteNum) {
            Sprite tsp = (Sprite)renderedSpriteList.get(tSpriteNum);
            if (tsp.getOwner() != SpriteNum) continue;
            return tsp;
        }
        return null;
    }

    public static void post_analyzesprites(int smoothratio) {
        Renderer renderer = Main.game.getRenderer();
        RenderedSpriteList renderedSpriteList = renderer.getRenderedSprites();
        for (int tSpriteNum = renderedSpriteList.getSize() - 1; tSpriteNum >= 0; --tSpriteNum) {
            TSprite tsp = (TSprite)renderedSpriteList.get(tSpriteNum);
            short SpriteNum = tsp.getOwner();
            if (SpriteNum == -1) continue;
            USER tu = Gameutils.getUser(SpriteNum);
            Main.game.pInt.dospriteinterp(tsp, smoothratio);
            Main.game.pIntSkip2.dospriteinterp(tsp, smoothratio);
            Main.game.pIntSkip4.dospriteinterp(tsp, smoothratio);
            if (tu == null) continue;
            if (tu.ID == 3212 && tu.Attach != -1) {
                Sprite atsp = Draw.get_tsprite(tu.Attach);
                if (atsp == null) continue;
                tsp.setX(atsp.getX());
                tsp.setY(atsp.getY());
                if (MyTypes.TEST(atsp.getExtra(), Gameutils.SPRX_BURNABLE)) {
                    atsp.setStatnum(1);
                    tsp.setStatnum(0);
                } else {
                    tsp.setStatnum(1024);
                }
            }
            if (tu.PlayerP == -1 || tu.PlayerP == Game.screenpeek || !Main.cfg.ShowWeapon || Main.gNet.MultiGameType == WangNetwork.MultiGameTypes.MULTI_GAME_NONE) continue;
            Draw.show_weapon(tu, tsp);
        }
    }

    public static void BackView(LONGp nx, LONGp ny, LONGp nz, LONGp vsect, LONGp nang, int horiz) {
        PlayerStr pp = Game.Player[Game.screenpeek];
        int ang = nang.value + pp.view_outside_dang;
        int vx = EngineUtils.sin(Gameutils.NORM_ANGLE(ang + 1536)) >> 3;
        int vy = EngineUtils.sin(Gameutils.NORM_ANGLE(ang + 1024)) >> 3;
        int vz = (horiz - 100) * 256;
        Sprite sp = pp.getSprite();
        if (sp == null) {
            return;
        }
        short bakcstat = sp.getCstat();
        sp.setCstat(sp.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        Main.engine.hitscan(nx.value, ny.value, nz.value, vsect.value, vx, vy, vz, Engine.pHitInfo, Gameutils.CLIPMASK_PLAYER);
        sp.setCstat(bakcstat);
        int hx = Engine.pHitInfo.hitx - nx.value;
        int hy = Engine.pHitInfo.hity - ny.value;
        if (Pragmas.klabs(vx) + Pragmas.klabs(vy) > Pragmas.klabs(hx) + Pragmas.klabs(hy)) {
            Wall hitWall = Main.boardService.getWall(Engine.pHitInfo.hitwall);
            if (hitWall != null) {
                vsect.value = Engine.pHitInfo.hitsect;
                int daang = EngineUtils.getAngle(hitWall.getWall2().getX() - hitWall.getX(), hitWall.getWall2().getY() - hitWall.getY());
                int i = vx * EngineUtils.sin(daang) + vy * EngineUtils.sin(Gameutils.NORM_ANGLE(daang + 1536));
                if (Pragmas.klabs(vx) > Pragmas.klabs(vy)) {
                    hx -= Pragmas.mulscale(vx, i, 28);
                } else {
                    hy -= Pragmas.mulscale(vy, i, 28);
                }
            } else if (Engine.pHitInfo.hitsprite == -1) {
                vsect.value = Engine.pHitInfo.hitsect;
                if (Pragmas.klabs(vx) > Pragmas.klabs(vy)) {
                    hx -= vx >> 5;
                } else {
                    hy -= vy >> 5;
                }
            } else {
                WangSprite hsp = Main.boardService.getSprite(Engine.pHitInfo.hitsprite);
                if (hsp != null && !MyTypes.TEST(hsp.getCstat(), Gameutils.CSTAT_SPRITE_WALL)) {
                    short flag_backup = hsp.getCstat();
                    hsp.setCstat(hsp.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
                    Draw.BackView(nx, ny, nz, vsect, nang, horiz);
                    hsp.setCstat(flag_backup);
                    return;
                }
                int daang = Gameutils.NORM_ANGLE(sp.getAng() - 512);
                int i = vx * EngineUtils.sin(daang) + vy * EngineUtils.sin(Gameutils.NORM_ANGLE(daang + 1536));
                if (Pragmas.klabs(vx) > Pragmas.klabs(vy)) {
                    hx -= Pragmas.mulscale(vx, i, 28);
                } else {
                    hy -= Pragmas.mulscale(vy, i, 28);
                }
            }
            int i = Pragmas.klabs(vx) > Pragmas.klabs(vy) ? (hx << 16) / vx : (hy << 16) / vy;
            if (i < pp.camera_dist) {
                pp.camera_dist = i;
            }
        }
        nx.value += Pragmas.mulscale(vx, pp.camera_dist, 16);
        ny.value += Pragmas.mulscale(vy, pp.camera_dist, 16);
        nz.value += Pragmas.mulscale(vz, pp.camera_dist, 16);
        pp.camera_dist = Math.min(pp.camera_dist + 3072, 65536);
        vsect.value = Main.engine.updatesectorz(nx.value, ny.value, nz.value, vsect.value);
        nang.value = ang;
    }

    public static void PrintLocationInfo(PlayerStr pp) {
        Renderer renderer = Main.game.getRenderer();
        int windowx1 = 0;
        int windowy1 = 0;
        int x = windowx1 + 5;
        int y = windowy1 + 5;
        if (Cheats.LocationInfo != 0) {
            BitmapFont smallFont = EngineUtils.getSmallFont();
            Strhandler.buildString(txt_buffer, 0, "FPS: ", Gdx.graphics.getFramesPerSecond());
            smallFont.drawText(renderer, x, y, txt_buffer, 1.0f, 0, 1, TextAlign.Left, Transparent.None, false);
            if (Cheats.LocationInfo > 1) {
                Strhandler.buildString(txt_buffer, 0, "POSX: ", pp.posx);
                smallFont.drawText(renderer, x, y += 7, txt_buffer, 1.0f, 0, 1, TextAlign.Left, Transparent.None, false);
                Strhandler.buildString(txt_buffer, 0, "POSY: ", pp.posy);
                smallFont.drawText(renderer, x, y += 7, txt_buffer, 1.0f, 0, 1, TextAlign.Left, Transparent.None, false);
                Strhandler.buildString(txt_buffer, 0, "POSZ: ", pp.posz);
                smallFont.drawText(renderer, x, y += 7, txt_buffer, 1.0f, 0, 1, TextAlign.Left, Transparent.None, false);
                Strhandler.buildString(txt_buffer, 0, "ANG: ", pp.getAnglei());
                smallFont.drawText(renderer, x, y += 7, txt_buffer, 1.0f, 0, 1, TextAlign.Left, Transparent.None, false);
            }
        }
    }

    public static void SecretInfo(int zoom) {
        Renderer renderer = Main.game.getRenderer();
        int x = 5;
        int y = 150;
        if (Main.cfg.BorderNum <= 1) {
            y = 170;
        }
        if (Main.cfg.Stats == 0 || Main.cfg.BorderNum == 0) {
            return;
        }
        boolean shadows = true;
        float viewzoom = (float)zoom / 65536.0f;
        Font f = Main.game.getFont(0);
        Strhandler.buildString(txt_buffer, 0, "Kills ");
        int alignx = f.getWidth(txt_buffer, viewzoom);
        int yoffset = (int)(3.2f * (float)f.getSize() * viewzoom);
        y -= yoffset;
        if (Main.gNet.MultiGameType == WangNetwork.MultiGameTypes.MULTI_GAME_COMMBAT) {
            y += (int)(8.0f * viewzoom);
        }
        int staty = y;
        f.drawTextScaled(renderer, x, staty, txt_buffer, viewzoom, 0, 27, TextAlign.Left, Transparent.None, ConvertType.AlignLeft, shadows);
        int offs = Strhandler.Bitoa(Main.gNet.MultiGameType == WangNetwork.MultiGameTypes.MULTI_GAME_COMMBAT ? Game.Player[Mmulti.myconnectindex].Kills : Game.Kills, txt_buffer);
        if (Main.gNet.MultiGameType != WangNetwork.MultiGameTypes.MULTI_GAME_COMMBAT) {
            Strhandler.buildString(txt_buffer, offs, "/", Game.TotalKillable);
        }
        f.drawTextScaled(renderer, (int)((float)x + (float)(alignx + 2) * viewzoom), staty, txt_buffer, viewzoom, 0, 16, TextAlign.Left, Transparent.None, ConvertType.AlignLeft, shadows);
        staty = y + (int)(8.0f * viewzoom);
        if (Main.gNet.MultiGameType != WangNetwork.MultiGameTypes.MULTI_GAME_COMMBAT) {
            Strhandler.buildString(txt_buffer, 0, "Secrets");
            f.drawTextScaled(renderer, x, staty, txt_buffer, viewzoom, 0, 27, TextAlign.Left, Transparent.None, ConvertType.AlignLeft, shadows);
            alignx = f.getWidth(txt_buffer, viewzoom);
            offs = Strhandler.Bitoa(Game.Player[Mmulti.connecthead].SecretsFound, txt_buffer);
            Strhandler.buildString(txt_buffer, offs, " / ", Sector.LevelSecrets);
            f.drawTextScaled(renderer, x + (alignx + 2), staty, txt_buffer, viewzoom, 0, 16, TextAlign.Left, Transparent.None, ConvertType.AlignLeft, shadows);
            staty = y + (int)(16.0f * viewzoom);
        }
        Strhandler.buildString(txt_buffer, 0, "Time ");
        f.drawTextScaled(renderer, x, staty, txt_buffer, viewzoom, 0, 27, TextAlign.Left, Transparent.None, ConvertType.AlignLeft, shadows);
        alignx = f.getWidth(txt_buffer, viewzoom);
        int second_tics = Game.PlayClock / 120;
        int minutes = second_tics / 60;
        int sec = second_tics % 60;
        offs = Strhandler.Bitoa(minutes, txt_buffer, 2);
        Strhandler.buildString(txt_buffer, offs, ":", sec, 2);
        f.drawTextScaled(renderer, x + (alignx + 2), staty, txt_buffer, viewzoom, 0, 16, TextAlign.Left, Transparent.None, ConvertType.AlignLeft, shadows);
    }

    public static void DrawMessageInput() {
        if (Console.out.isShowing()) {
            return;
        }
        if (Game.MessageInputMode && Main.game.getProcessor().getWangPrompt().isCaptured()) {
            Main.game.getProcessor().getWangPrompt().draw();
        }
    }

    public static void DrawCrosshair(PlayerStr pp) {
        Renderer renderer = Main.game.getRenderer();
        if (!Main.cfg.Crosshair) {
            return;
        }
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_VIEW_FROM_OUTSIDE)) {
            return;
        }
        if (dimensionmode == 6) {
            return;
        }
        int y = 100;
        if (Main.cfg.BorderNum >= 3) {
            y -= 24;
        }
        renderer.rotatesprite(158 - (pp.lookang >> 1) << 16, (y += Pragmas.klabs(pp.lookang) / 9) << 16, Main.cfg.CrosshairSize, 0, 2326, 10, 0, Gameutils.ROTATE_SPRITE_SCREEN_CLIP);
    }

    public static void CameraView(PlayerStr pp, LONGp tx, LONGp ty, LONGp tz, LONGp tsectnum, LONGp tang, LONGp thoriz) {
        boolean player_in_camera;
        boolean found_camera;
        block9: {
            found_camera = false;
            player_in_camera = false;
            Sprite psp = pp.getSprite();
            if (psp == null) {
                return;
            }
            if (pp != Game.Player[Game.screenpeek]) break block9;
            ListNode<Sprite> node = Main.boardService.getStatNode(59);
            while (node != null) {
                ListNode<Sprite> nexti;
                block11: {
                    block10: {
                        int i = node.getIndex();
                        nexti = node.getNext();
                        Sprite sp = node.get();
                        ang = EngineUtils.getAngle(tx.value - sp.getX(), ty.value - sp.getY());
                        boolean ang_test = Player.GetDeltaAngle(sp.getAng(), ang) < sp.getLotag();
                        boolean FAFcansee_test = Rooms.FAFcansee(sp.getX(), sp.getY(), sp.getZ(), sp.getSectnum(), tx.value, ty.value, tz.value, pp.cursectnum) || Rooms.FAFcansee(sp.getX(), sp.getY(), sp.getZ(), sp.getSectnum(), tx.value, ty.value, tz.value + Gameutils.SPRITEp_SIZE_Z(psp), pp.cursectnum);
                        boolean bl = player_in_camera = ang_test && FAFcansee_test;
                        if (!player_in_camera && pp.camera_check_time_delay <= 0) break block10;
                        if (!player_in_camera && pp.last_camera_sp != i) break block11;
                        pp.last_camera_sp = i;
                        int xvect = EngineUtils.sin(Gameutils.NORM_ANGLE(ang + 512)) >> 3;
                        int yvect = EngineUtils.sin(Gameutils.NORM_ANGLE(ang)) >> 3;
                        int zdiff = sp.getZ() - tz.value;
                        int zvect = Pragmas.klabs(sp.getX() - tx.value) > 1000 ? Pragmas.scale(xvect, zdiff, sp.getX() - tx.value) : (Pragmas.klabs(sp.getY() - ty.value) > 1000 ? Pragmas.scale(yvect, zdiff, sp.getY() - ty.value) : (sp.getX() - tx.value != 0 ? Pragmas.scale(xvect, zdiff, sp.getX() - tx.value) : (sp.getY() - ty.value != 0 ? Pragmas.scale(yvect, zdiff, sp.getY() - ty.value) : 0)));
                        thoriz.value = 100 - zvect / 256;
                        thoriz.value = Math.max(thoriz.value, -99);
                        thoriz.value = Math.min(thoriz.value, 299);
                        tang.value = ang;
                        tx.value = sp.getX();
                        ty.value = sp.getY();
                        tz.value = sp.getZ();
                        tsectnum.value = sp.getSectnum();
                        found_camera = true;
                    }
                    if (found_camera) break;
                }
                node = nexti;
            }
        }
        if (player_in_camera) {
            pp.camera_check_time_delay = 60;
            pp.Flags |= Gameutils.PF_VIEW_FROM_CAMERA;
        } else if (found_camera) {
            pp.Flags |= Gameutils.PF_VIEW_FROM_CAMERA;
        } else {
            pp.circle_camera_ang = 0;
            pp.circle_camera_dist = 12000;
            pp.Flags &= ~Gameutils.PF_VIEW_FROM_CAMERA;
        }
    }

    public static void PreDraw() {
        for (ListNode<Sprite> node = Main.boardService.getStatNode(74); node != null; node = node.getNext()) {
            Sprite sp = node.get();
            ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(sp.getSectnum());
            if (sec == null) continue;
            sec.setFloorstat(sec.getFloorstat() & ~Gameutils.FLOOR_STAT_SLOPE);
        }
    }

    public static void PostDraw() {
        for (ListNode<Sprite> node = Main.boardService.getStatNode(74); node != null; node = node.getNext()) {
            Sprite sp = node.get();
            ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(sp.getSectnum());
            if (sec == null) continue;
            sec.setFloorstat(sec.getFloorstat() | Gameutils.FLOOR_STAT_SLOPE);
        }
    }

    public static TSprite CopySprite(Sprite sprite, int newsector) {
        TSprite tspr = Draw.insertTSprite(newsector, sprite.getStatnum());
        tspr.setX(sprite.getX());
        tspr.setY(sprite.getY());
        tspr.setZ(sprite.getZ());
        tspr.setCstat(sprite.getCstat());
        tspr.setPicnum(sprite.getPicnum());
        tspr.setPal(sprite.getPal());
        tspr.setXrepeat(sprite.getXrepeat());
        tspr.setYrepeat(sprite.getYrepeat());
        tspr.setXoffset(sprite.getXoffset());
        tspr.setYoffset(sprite.getYoffset());
        tspr.setAng(sprite.getAng());
        tspr.setXvel(sprite.getXvel());
        tspr.setYvel(sprite.getYvel());
        tspr.setZvel(sprite.getZvel());
        tspr.setShade(sprite.getShade());
        tspr.setOwner(sprite.getOwner());
        tspr.setCstat(tspr.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        return tspr;
    }

    public static TSprite ConnectCopySprite(Sprite sprite) {
        int testz;
        int newsector;
        int spriteSectnum = sprite.getSectnum();
        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(spriteSectnum);
        if (Gameutils.FAF_ConnectCeiling(sec)) {
            newsector = spriteSectnum;
            testz = Gameutils.SPRITEp_TOS(sprite) - Gameutils.Z(10);
            if (testz < sec.getCeilingz()) {
                newsector = Main.engine.updatesectorz(sprite.getX(), sprite.getY(), testz, newsector);
            }
            if (newsector != -1 && newsector != sprite.getSectnum()) {
                return Draw.CopySprite(sprite, newsector);
            }
        }
        if (Gameutils.FAF_ConnectFloor(sec)) {
            newsector = spriteSectnum;
            testz = Gameutils.SPRITEp_BOS(sprite) + Gameutils.Z(10);
            if (testz > sec.getFloorz()) {
                newsector = Main.engine.updatesectorz(sprite.getX(), sprite.getY(), testz, newsector);
            }
            if (newsector >= 0 && newsector != sprite.getSectnum()) {
                return Draw.CopySprite(sprite, newsector);
            }
        }
        return null;
    }

    public static void PreDrawStackedWater() {
        ListNode<Sprite> n = Main.boardService.getStatNode(52);
        while (n != null) {
            ListNode<Sprite> snexti = n.getNext();
            ListNode<Sprite> node = Main.boardService.getSectNode(n.get().getSectnum());
            while (node != null) {
                TSprite tsp;
                int i = node.getIndex();
                ListNode<Sprite> nexti = node.getNext();
                Sprite spr = node.get();
                if (Gameutils.getUser(i) != null && spr.getStatnum() > 0 && spr.getStatnum() <= 29 && spr.getStatnum() != 10 && (tsp = Draw.ConnectCopySprite(spr)) != null) {
                    tsp.setOwner(i);
                }
                node = nexti;
            }
            n = snexti;
        }
    }

    public static void FAF_DrawRooms(int x, int y, int z, float ang, float horiz, int sectnum) {
        ru.m210projects.Build.Types.Sector sec;
        Sprite sp;
        ListNode<Sprite> nexti;
        Renderer renderer = Main.game.getRenderer();
        ListNode<Sprite> node = Main.boardService.getStatNode(52);
        while (node != null) {
            nexti = node.getNext();
            sp = node.get();
            sec = Main.boardService.getSector(sp.getSectnum());
            if (sec != null) {
                if (Gameutils.SP_TAG3(sp) == 0) {
                    sp.setXvel(sec.getCeilingpicnum());
                    sp.setAng(sec.getCeilingstat());
                    sec.setCeilingpicnum(Gameutils.SP_TAG2(sp));
                    sec.setCeilingstat(sec.getCeilingstat() | Gameutils.SP_TAG6(sp));
                    sec.setCeilingstat(sec.getCeilingstat() & ~Gameutils.CEILING_STAT_PLAX);
                } else if (Gameutils.SP_TAG3(sp) == 1) {
                    sp.setXvel(sec.getFloorpicnum());
                    sp.setAng(sec.getFloorstat());
                    sec.setFloorpicnum(Gameutils.SP_TAG2(sp));
                    sec.setFloorstat(sec.getFloorstat() | Gameutils.SP_TAG6(sp));
                    sec.setFloorstat(sec.getFloorstat() & ~Gameutils.FLOOR_STAT_PLAX);
                }
            }
            node = nexti;
        }
        renderer.drawrooms(x, y, z, ang, horiz, sectnum);
        node = Main.boardService.getStatNode(52);
        while (node != null) {
            nexti = node.getNext();
            sp = node.get();
            sec = Main.boardService.getSector(sp.getSectnum());
            if (sec != null) {
                if (Gameutils.TEST_GOTSECTOR(sp.getSectnum())) {
                    Gameutils.SET_GOTPIC(2356);
                }
                if (Gameutils.SP_TAG3(sp) == 0) {
                    sec.setCeilingpicnum(Gameutils.SP_TAG5(sp));
                    sec.setCeilingstat(Gameutils.SP_TAG4(sp));
                    sec.setCeilingstat(sec.getCeilingstat() & ~Gameutils.CEILING_STAT_PLAX);
                } else if (Gameutils.SP_TAG3(sp) == 1) {
                    sec.setFloorpicnum(Gameutils.SP_TAG5(sp));
                    sec.setFloorstat(Gameutils.SP_TAG4(sp));
                    sec.setFloorstat(sec.getFloorstat() & ~Gameutils.FLOOR_STAT_PLAX);
                }
            }
            node = nexti;
        }
    }

    public static void drawscreen(PlayerStr pp, int smoothratio) {
        ru.m210projects.Build.Types.Sector psec;
        WangSprite remoteSpr;
        int bob_amt = 0;
        int windowy1 = 0;
        gPlayerIndex = -1;
        Renderer renderer = Main.game.getRenderer();
        Draw.PreDraw();
        PlayerStr camerapp = WangNetwork.PredictionOn && Mmulti.numplayers > 1 && pp == Game.Player[Mmulti.myconnectindex] ? Main.gNet.ppp : pp;
        int tx = camerapp.oposx + Pragmas.mulscale(camerapp.posx - camerapp.oposx, smoothratio, 16);
        int ty = camerapp.oposy + Pragmas.mulscale(camerapp.posy - camerapp.oposy, smoothratio, 16);
        int tz = camerapp.oposz + Pragmas.mulscale(camerapp.posz - camerapp.oposz, smoothratio, 16);
        float tang = camerapp.oang + (ru.m210projects.Build.Gameutils.BClampAngle(camerapp.pang + 1024.0f - camerapp.oang) - 1024.0f) * (float)smoothratio / 65536.0f;
        float thoriz = camerapp.ohoriz + (camerapp.horiz - camerapp.ohoriz) * (float)smoothratio / 65536.0f;
        int tsectnum = camerapp.cursectnum;
        tsectnum = Rooms.COVERupdatesector(tx, ty, tsectnum);
        tang += (float)camerapp.lookang;
        if (tsectnum == -1) {
            tsectnum = lv_sectnum;
            tx = lv_x;
            ty = lv_y;
            tz = lv_z;
        } else {
            lv_sectnum = tsectnum;
            lv_x = tx;
            lv_y = ty;
            lv_z = tz;
        }
        pp.six = tx;
        pp.siy = ty;
        pp.siz = tz - pp.posz;
        pp.siang = (int)tang;
        Quake.QuakeViewChange(camerapp, Game.tmp_ptr[0], Game.tmp_ptr[1], Game.tmp_ptr[2], Game.tmp_ptr[3]);
        int quake_z = Game.tmp_ptr[0].value;
        int quake_x = Game.tmp_ptr[1].value;
        int quake_y = Game.tmp_ptr[2].value;
        int quake_ang = Game.tmp_ptr[3].value;
        Vis.VisViewChange(camerapp, Game.tmp_ptr[0].set(Engine.visibility));
        Engine.visibility = Game.tmp_ptr[0].value;
        tz += quake_z;
        tx += quake_x;
        ty += quake_y;
        tang += (float)quake_ang;
        tang = ru.m210projects.Build.Gameutils.BClampAngle(tang);
        if (pp.sop_remote != -1 && (remoteSpr = Main.boardService.getSprite(pp.remote_sprite)) != null) {
            if (Gameutils.TEST_BOOL1(remoteSpr)) {
                tang = remoteSpr.getAng();
            } else {
                int xmid = pp.remote.oposx + Pragmas.mulscale(pp.remote.posx - pp.remote.oposx, smoothratio, 16);
                int ymid = pp.remote.oposy + Pragmas.mulscale(pp.remote.posy - pp.remote.oposy, smoothratio, 16);
                tang = EngineUtils.getAngle(xmid - tx, ymid - ty);
            }
        }
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_VIEW_FROM_OUTSIDE)) {
            Draw.BackView(Game.tmp_ptr[0].set(tx), Game.tmp_ptr[1].set(ty), Game.tmp_ptr[2].set(tz), Game.tmp_ptr[3].set(tsectnum), Game.tmp_ptr[4].set((int)tang), (int)thoriz);
            tx = Game.tmp_ptr[0].value;
            ty = Game.tmp_ptr[1].value;
            tz = Game.tmp_ptr[2].value;
            tsectnum = Game.tmp_ptr[3].value;
            tang = Game.tmp_ptr[4].value;
        } else {
            bob_amt = camerapp.obob_amt + Pragmas.mulscale(camerapp.bob_amt - camerapp.obob_amt, smoothratio, 16);
            if (Main.gDemoScreen.demfile != null) {
                Draw.CameraView(camerapp, Game.tmp_ptr[0].set(tx), Game.tmp_ptr[1].set(ty), Game.tmp_ptr[2].set(tz), Game.tmp_ptr[3].set(tsectnum), Game.tmp_ptr[4].set((int)tang), Game.tmp_ptr[5].set((int)thoriz));
                tx = Game.tmp_ptr[0].value;
                ty = Game.tmp_ptr[1].value;
                tz = Game.tmp_ptr[2].value;
                tsectnum = Game.tmp_ptr[3].value;
                tang = Game.tmp_ptr[4].value;
                thoriz = Game.tmp_ptr[5].value;
            }
        }
        if (!MyTypes.TEST(pp.Flags, Gameutils.PF_VIEW_FROM_CAMERA | Gameutils.PF_VIEW_FROM_OUTSIDE)) {
            tz += bob_amt;
            tz += camerapp.obob_z + Pragmas.mulscale(camerapp.bob_z - camerapp.obob_z, smoothratio, 16);
            thoriz += (float)pp.recoil_horizoff;
            thoriz = Math.max(thoriz, -99.0f);
            thoriz = Math.min(thoriz, 299.0f);
        }
        if (tsectnum >= 0) {
            Main.engine.getzsofslope(tsectnum, tx, ty, Rooms.fz, Rooms.cz);
            if (tz < Rooms.cz.get() + 1024) {
                tz = Rooms.cz.get() + 1024;
            }
            if (tz > Rooms.fz.get() - 1024) {
                tz = Rooms.fz.get() - 1024;
            }
        }
        if (dimensionmode != 6) {
            OverlapDraw = true;
            Rooms.DrawOverlapRoom(tx, ty, tz, tang, thoriz, tsectnum, smoothratio);
            OverlapDraw = false;
            if (dimensionmode != 6 && !Main.game.isScreenSaving()) {
                JSector.JS_DrawMirrors(pp, tx, ty, tz, tang, thoriz, smoothratio);
            }
            Draw.FAF_DrawRooms(tx, ty, tz, tang, thoriz, tsectnum);
            Rooms.PicInView((short)2356, false);
            Draw.analyzesprites(tx, ty, tz, false, smoothratio);
            Draw.post_analyzesprites(smoothratio);
            renderer.drawmasks();
            byte[] gotpic = renderer.getRenderedPics();
            if ((gotpic[288] & 2) > 0) {
                gotpic[288] = (byte)(gotpic[288] & 0xFFFFFFFD);
            }
        }
        if ((psec = Main.boardService.getSector(pp.cursectnum)) != null) {
            Engine.show2dsector.setBit(pp.cursectnum);
            for (ListNode<Wall> wn = psec.getWallNode(); wn != null; wn = wn.getNext()) {
                Wall nwall;
                Wall wal = wn.get();
                ru.m210projects.Build.Types.Sector nsec = Main.boardService.getSector(wal.getNextsector());
                if (nsec == null || (wal.getCstat() & 0x71) != 0 || (nwall = Main.boardService.getWall(wal.getNextwall())) != null && (nwall.getCstat() & 0x71) != 0 || nsec.getLotag() == Short.MAX_VALUE || nsec.getCeilingz() >= nsec.getFloorz()) continue;
                Engine.show2dsector.setBit(wal.getNextsector());
            }
        }
        if (dimensionmode == 5 || dimensionmode == 6) {
            tx = camerapp.oposx;
            ty = camerapp.oposy;
            if (ScrollMode2D) {
                tx = Follow_posx;
                ty = Follow_posy;
            }
            List<Sprite> spriteList = Main.boardService.getBoard().getSprites();
            for (Sprite spr : spriteList) {
                if (spr.getLotag() != 257 || !MyTypes.TEST(spr.getCstat(), Gameutils.CSTAT_SPRITE_FLOOR)) continue;
                spr.setCstat(spr.getCstat() & ~Gameutils.CSTAT_SPRITE_FLOOR);
                spr.setOwner(-2);
            }
            if (dimensionmode == 6) {
                renderer.clearview(0);
                renderer.drawmapview(tx, ty, zoom, (int)tang);
            }
            renderer.drawoverheadmap(tx, ty, zoom, (short)tang);
            int txt_x = 7;
            int txt_y = windowy1 + 5;
            if (Main.game.nNetMode != BuildGame.NetMode.Single) {
                txt_y += 10;
            }
            if (ScrollMode2D) {
                JPlayer.minigametext(txt_x, txt_y + 7, "Follow Mode", 0, Transparent.None, ConvertType.AlignLeft);
            }
            Main.game.getFont(0).drawTextScaled(renderer, txt_x, txt_y, Game.getMapName(Game.Level), 1.0f, 0, 4, TextAlign.Left, Transparent.None, ConvertType.AlignLeft, true);
        }
        List<Sprite> spriteList = Main.boardService.getBoard().getSprites();
        for (Sprite spr : spriteList) {
            if (spr.getLotag() != 257 || spr.getOwner() != -2) continue;
            spr.setCstat(spr.getCstat() | Gameutils.CSTAT_SPRITE_FLOOR);
        }
        Draw.PostDraw();
    }

    public static void drawhud(PlayerStr pp) {
        USER pu;
        Renderer renderer = Main.game.getRenderer();
        int windowy1 = 0;
        Panel.PreUpdatePanel();
        Panel.UpdatePanel();
        Draw.PrintLocationInfo(pp);
        if (Main.cfg.Stats == 1 || Main.cfg.Stats == 2 && (dimensionmode == 5 || dimensionmode == 6)) {
            Draw.SecretInfo(Main.cfg.gStatSize);
        }
        Draw.DrawCrosshair(pp);
        JPlayer.operatefta();
        Player.DoPlayerDiveMeter(pp);
        Sumo.BossHealthMeter();
        Draw.DrawMessageInput();
        Draw.DrawFullBar(pp);
        Draw.UpdateAltBar(pp);
        Draw.UpdateMiniBar(pp);
        if (Main.game.gPaused) {
            int w = Main.game.getFont(1).getWidth("Game Paused", 1.0f);
            JPlayer.gametext(Gameutils.TEXT_TEST_COL(w), 100, "Game Paused", 0);
        }
        if (Main.game.nNetMode == BuildGame.NetMode.Multiplayer) {
            Text.DrawFragBar();
        }
        int ydim = renderer.getHeight();
        if (gPlayerIndex != -1 && gPlayerIndex != Game.screenpeek && (pu = Gameutils.getUser(Game.Player[Draw.gPlayerIndex].PlayerSprite)) != null) {
            int len = Strhandler.buildString(txt_buffer, 0, Game.Player[gPlayerIndex].getName());
            len = Strhandler.buildString(txt_buffer, len, " (", pu.Health);
            Strhandler.buildString(txt_buffer, len, "hp)");
            int shade = 16 - (Main.engine.getTotalClock() & 0x3F);
            int y = Pragmas.scale(windowy1, 200L, ydim) + 100;
            if (Main.cfg.BorderNum < 3) {
                y += Main.engine.getTile(2434).getHeight() / 2;
            }
            Main.game.getFont(0).drawTextScaled(renderer, 160, y, txt_buffer, 1.0f, shade, (int)pu.spal, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
        }
        if (Game.screenpeek != Mmulti.myconnectindex) {
            Strhandler.buildString(txt_buffer, 0, "View from \"", Game.Player[Game.screenpeek].getName(), "\"");
            int shade = 16 - (Main.engine.getTotalClock() & 0x3F);
            Main.game.getFont(1).drawTextScaled(renderer, 160, Pragmas.scale(windowy1, 200L, ydim) + 30, txt_buffer, 1.0f, shade, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
        }
        if (Main.game.isCurrentScreen(Main.gGameScreen) && Main.engine.getTotalClock() < gNameShowTime) {
            Transparent transp = Transparent.None;
            if (Main.engine.getTotalClock() > gNameShowTime - 20) {
                transp = Transparent.Bit1;
            }
            if (Main.engine.getTotalClock() > gNameShowTime - 10) {
                transp = Transparent.Bit2;
            }
            if (Main.cfg.showMapInfo != 0 && !Main.game.menu.gShowMenu) {
                Main.game.getFont(2).drawTextScaled(renderer, 160, 134, Game.getMapName(Game.Level), 1.0f, -128, 0, TextAlign.Center, transp, ConvertType.Normal, false);
            }
        }
    }

    private static void DrawFullBar(PlayerStr pp) {
        if (Main.cfg.BorderNum != 3) {
            return;
        }
        Renderer renderer = Main.game.getRenderer();
        ArtEntry pic = renderer.getTile(53);
        int xdim = renderer.getWidth();
        int ydim = renderer.getHeight();
        int scale = Pragmas.divscale(ydim, 4L * (long)pic.getWidth(), 16);
        int width = Pragmas.mulscale(pic.getWidth(), scale, 16);
        int framesnum = xdim / width;
        pic = renderer.getTile(2434);
        int fy = ydim - Pragmas.scale(pic.getHeight(), ydim, 200L);
        int statusx1 = ru.m210projects.Build.Gameutils.coordsConvertXScaled(160 - pic.getWidth() / 2, ConvertType.Normal);
        int statusx2 = ru.m210projects.Build.Gameutils.coordsConvertXScaled(160 + pic.getWidth() / 2, ConvertType.Normal);
        int x = 0;
        for (int i = 0; i <= framesnum; ++i) {
            if (x - width <= statusx1 || x + width >= statusx2) {
                renderer.rotatesprite(x << 16, fy << 16, scale, 0, 53, 0, 0, 280);
            }
            x += width;
        }
        renderer.rotatesprite(0xA00000, 200 - pic.getHeight() / 2 << 16, 65536, 0, 2434, 0, 0, 10, 0, 0, xdim - 1, ydim - 1);
        Draw.DrawCompass(pp);
        Panel.PlayerUpdatePanelInfo(pp);
    }

    public static void UpdateAltBar(PlayerStr pp) {
        if (Main.cfg.BorderNum != 2) {
            return;
        }
        Renderer renderer = Main.game.getRenderer();
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (u == null) {
            return;
        }
        int x = 187;
        int y = 155;
        renderer.rotatesprite(x << 16, y << 16, 65536, 0, 9219, 0, 0, Gameutils.ROTATE_SPRITE_SCREEN_CLIP | Gameutils.ROTATE_SPRITE_CORNER | 0x200);
        if (pp.InventoryAmount[pp.InventoryNum] != 0) {
            INVENTORY_DATA id = Inv.InventoryData[pp.InventoryNum];
            renderer.rotatesprite(x + 45 << 16, y + 17 << 16, 65536, 0, id.State.picndx, 0, 0, Gameutils.ROTATE_SPRITE_SCREEN_CLIP | Gameutils.ROTATE_SPRITE_CORNER | 0x200);
            Inv.DrawInventory(pp, x + 43, y + 16, 512);
        }
        if (u.WeaponNum != 13 && u.WeaponNum != 0) {
            Text.DisplayPanelNumber(pp, x + 11, y + 20, pp.WpnAmmo[u.WeaponNum], 512);
        }
        if (Main.gNet.MultiGameType != WangNetwork.MultiGameTypes.MULTI_GAME_COMMBAT) {
            Panel.PlayerUpdateKeys(pp, x + 89, y + 18, 512);
        } else if (Main.gNet.TimeLimit != 0) {
            int seconds = Main.gNet.TimeLimitClock / 120;
            int offs = Strhandler.Bitoa(seconds / 60, txt_buffer, 2);
            Strhandler.buildString(txt_buffer, offs, ":", seconds % 60, 2);
            Text.DisplaySummaryString(pp, x + 92, y + 23, 0, 0, txt_buffer, 512);
        }
        x = 0;
        renderer.rotatesprite(x, y << 16, 65536, 0, 9218, 0, 0, Gameutils.ROTATE_SPRITE_SCREEN_CLIP | Gameutils.ROTATE_SPRITE_CORNER | 0x100);
        Text.DisplayMiniBarNumber(pp, x + 23, y + 20, u.Health, 256);
        if (pp.Armor != 0) {
            Text.DisplayMiniBarNumber(pp, x + 59, y + 20, pp.Armor, 256);
        }
    }

    public static void UpdateMiniBar(PlayerStr pp) {
        if (Main.cfg.BorderNum != 1) {
            return;
        }
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (u == null) {
            return;
        }
        Renderer renderer = Main.game.getRenderer();
        int x = 4;
        int y = 174;
        renderer.rotatesprite(x << 16, y << 16, 65536, 0, 2437, 0, 0, Gameutils.ROTATE_SPRITE_SCREEN_CLIP | Gameutils.ROTATE_SPRITE_CORNER | 0x100);
        Text.DisplayMiniBarNumber(pp, x + 3, y + 5, u.Health, 256);
        if (pp.Armor != 0) {
            renderer.rotatesprite((x += 28) << 16, y << 16, 65536, 0, 2437, 0, 0, Gameutils.ROTATE_SPRITE_SCREEN_CLIP | Gameutils.ROTATE_SPRITE_CORNER | 0x100);
            Text.DisplayMiniBarNumber(pp, x + 3, y + 5, pp.Armor, 256);
        }
        if (u.WeaponNum != 13 && u.WeaponNum != 0) {
            renderer.rotatesprite((x += 28) << 16, y << 16, 65536, 0, 2437, 0, 0, Gameutils.ROTATE_SPRITE_SCREEN_CLIP | Gameutils.ROTATE_SPRITE_CORNER | 0x100);
            Text.DisplayMiniBarNumber(pp, x + 3, y + 5, pp.WpnAmmo[u.WeaponNum], 256);
        }
        if (Main.gNet.MultiGameType != WangNetwork.MultiGameTypes.MULTI_GAME_COMMBAT) {
            boolean hasKey = false;
            for (int i = 0; i < 8; ++i) {
                if (pp.HasKey[i] == 0) continue;
                hasKey = true;
                break;
            }
            if (hasKey) {
                renderer.rotatesprite((x += 28) << 16, y << 16, 65536, 0, 2437, 0, 0, Gameutils.ROTATE_SPRITE_SCREEN_CLIP | Gameutils.ROTATE_SPRITE_CORNER | 0x100);
                Panel.PlayerUpdateKeys(pp, x + 2, y + 3, 256);
            }
        } else if (Main.gNet.TimeLimit != 0) {
            renderer.rotatesprite((x += 28) << 16, y << 16, 65536, 0, 2437, 0, 0, Gameutils.ROTATE_SPRITE_SCREEN_CLIP | Gameutils.ROTATE_SPRITE_CORNER | 0x100);
            int seconds = Main.gNet.TimeLimitClock / 120;
            int offs = Strhandler.Bitoa(seconds / 60, txt_buffer, 2);
            Strhandler.buildString(txt_buffer, offs, ":", seconds % 60, 2);
            Text.DisplaySummaryString(pp, x + 5, y + 8, 0, 0, txt_buffer, 0);
        }
        if (pp.InventoryAmount[pp.InventoryNum] != 0) {
            renderer.rotatesprite((x += 28) << 16, y << 16, 65536, 0, 2438, 0, 0, Gameutils.ROTATE_SPRITE_SCREEN_CLIP | Gameutils.ROTATE_SPRITE_CORNER | 0x100);
            INVENTORY_DATA id = Inv.InventoryData[pp.InventoryNum];
            renderer.rotatesprite(x + 2 << 16, y + 3 << 16, 65536, 0, id.State.picndx, 0, 0, Gameutils.ROTATE_SPRITE_SCREEN_CLIP | Gameutils.ROTATE_SPRITE_CORNER | 0x100);
            Inv.DrawInventory(pp, x, y + 1, 256);
        }
    }

    public static int NORM_CANG(int ang) {
        return ang + 32 & 0x1F;
    }

    public static void DrawCompass(PlayerStr pp) {
        if (Main.cfg.BorderNum < 3 || pp != Game.Player[Game.screenpeek]) {
            return;
        }
        int ang = pp.getAnglei();
        if (pp.sop_remote != -1) {
            ang = 0;
        }
        Renderer renderer = Main.game.getRenderer();
        int start_ang = ang + 32 >> 6;
        start_ang = Draw.NORM_CANG(start_ang - 4);
        int flags = Gameutils.ROTATE_SPRITE_SCREEN_CLIP | Gameutils.ROTATE_SPRITE_CORNER;
        int x_size = Main.engine.getTile(2382).getWidth();
        int x = 140;
        for (int i = 0; i < 10; ++i) {
            renderer.rotatesprite(x << 16, 0x9D0000, 65536, 0, CompassPic[Draw.NORM_CANG(start_ang + i)], CompassShade[i], 0, flags);
            x += x_size;
        }
    }

    public static TSprite insertTSprite(int sectnum, int stat) {
        Renderer renderer = Main.game.getRenderer();
        TSprite pTSprite = (TSprite)renderer.getRenderedSprites().obtain();
        pTSprite.reset((byte)0);
        pTSprite.setOwner(-1);
        pTSprite.setSectnum(sectnum);
        pTSprite.setStatnum(stat);
        return pTSprite;
    }

    static {
        zoom = 768;
        aVoxelArray = new ParentalStruct[Engine.MAXTILES];
        OverlapDraw = false;
        CompassShade = new short[]{25, 19, 15, 9, 1, 1, 9, 15, 19, 25};
        viewWeaponTile = new short[]{-1, 1793, 1794, 1797, 1818, 1817, 2223, 1811, 1814, 1824, -1, -1, -1, -1};
        ang = 0;
        lv_sectnum = -1;
    }
}

