/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolg;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Enemies.EnemyStateGroup;
import ru.m210projects.Wang.Enemies.Personality;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Actor_Action_Set;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.Sect_User;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.StateGroup;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class Coolie {
    public static final int COOLIE_RATE = 12;
    public static final int COOLIE_PAIN_RATE = 60;
    public static final int COOLIE_DIE_RATE = 30;
    private static final Animator DoCoolieMove = new Animator(Coolie::DoCoolieMove);
    private static final Animator CooliePain = new Animator(Coolie::CooliePain);
    private static final Animator NullCoolie = new Animator(Coolie::NullCoolie);
    private static final Animator SpawnCoolg = new Animator(Coolie::SpawnCoolg);
    private static final Animator SpawnCoolieExp = new Animator(Weapon::SpawnCoolieExp);
    private static final Decision[] CoolieBroadcast = new Decision[]{new Decision(16, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
    private static final Animator DoCoolieWaitBirth = new Animator(Coolie::DoCoolieWaitBirth);
    private static final Decision[] CoolieSurprised = new Decision[]{new Decision(700, Ai.InitActorMoveCloser), new Decision(703, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] CoolieEvasive = new Decision[]{new Decision(10, Ai.InitActorEvade), new Decision(1024, null)};
    private static final Decision[] CoolieLostTarget = new Decision[]{new Decision(900, Ai.InitActorFindPlayer), new Decision(1024, Ai.InitActorWanderAround)};
    private static final ATTRIBUTE CoolieAttrib = new ATTRIBUTE(new short[]{60, 80, 100, 200}, new short[]{3, 0, -2, -3}, 3, new int[]{78, 77, 77, 79, 0, 80, 75, 0, 0, 0});
    private static final State[][] s_CoolieRun = new State[][]{{new State(1400, 12, DoCoolieMove), new State(1401, 12, DoCoolieMove), new State(1402, 12, DoCoolieMove), new State(1403, 12, DoCoolieMove)}, {new State(1404, 12, DoCoolieMove), new State(1405, 12, DoCoolieMove), new State(1406, 12, DoCoolieMove), new State(1407, 12, DoCoolieMove)}, {new State(1408, 12, DoCoolieMove), new State(1409, 12, DoCoolieMove), new State(1410, 12, DoCoolieMove), new State(1411, 12, DoCoolieMove)}, {new State(1412, 12, DoCoolieMove), new State(1413, 12, DoCoolieMove), new State(1414, 12, DoCoolieMove), new State(1415, 12, DoCoolieMove)}, {new State(1416, 12, DoCoolieMove), new State(1417, 12, DoCoolieMove), new State(1418, 12, DoCoolieMove), new State(1419, 12, DoCoolieMove)}};
    private static final EnemyStateGroup sg_CoolieRun = new EnemyStateGroup(s_CoolieRun[0], s_CoolieRun[1], s_CoolieRun[2], s_CoolieRun[3], s_CoolieRun[4]);
    private static final State[][] s_CoolieCharge = new State[][]{{new State(1420, 12, DoCoolieMove), new State(1421, 12, DoCoolieMove), new State(1422, 12, DoCoolieMove), new State(1423, 12, DoCoolieMove)}, {new State(1424, 12, DoCoolieMove), new State(1425, 12, DoCoolieMove), new State(1426, 12, DoCoolieMove), new State(1427, 12, DoCoolieMove)}, {new State(1428, 12, DoCoolieMove), new State(1429, 12, DoCoolieMove), new State(1430, 12, DoCoolieMove), new State(1431, 12, DoCoolieMove)}, {new State(1432, 12, DoCoolieMove), new State(1433, 12, DoCoolieMove), new State(1434, 12, DoCoolieMove), new State(1435, 12, DoCoolieMove)}, {new State(1436, 12, DoCoolieMove), new State(1437, 12, DoCoolieMove), new State(1438, 12, DoCoolieMove), new State(1439, 12, DoCoolieMove)}};
    private static final EnemyStateGroup sg_CoolieCharge = new EnemyStateGroup(s_CoolieCharge[0], s_CoolieCharge[1], s_CoolieCharge[2], s_CoolieCharge[3], s_CoolieCharge[4]);
    private static final Animator InitCoolieCharge = new Animator(Coolie::InitCoolieCharge);
    private static final Decision[] CoolieBattle = new Decision[]{new Decision(700, InitCoolieCharge), new Decision(990, Ai.InitActorMoveCloser), new Decision(1000, Ai.InitActorAttackNoise), new Decision(1024, Ai.InitActorRunAway)};
    private static final Decision[] CoolieOffense = new Decision[]{new Decision(700, InitCoolieCharge), new Decision(1015, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorAttackNoise)};
    private static final Decision[] CoolieCloseRange = new Decision[]{new Decision(400, InitCoolieCharge), new Decision(1024, Ai.InitActorReposition)};
    private static final Personality CooliePersonality = new Personality(CoolieBattle, CoolieOffense, CoolieBroadcast, CoolieSurprised, CoolieEvasive, CoolieLostTarget, CoolieCloseRange, CoolieCloseRange);
    private static final State[][] s_CoolieStand = new State[][]{{new State(1400, 12, DoCoolieMove).setNext()}, {new State(1404, 12, DoCoolieMove).setNext()}, {new State(1408, 12, DoCoolieMove).setNext()}, {new State(1412, 12, DoCoolieMove).setNext()}, {new State(1416, 12, DoCoolieMove).setNext()}};
    private static final EnemyStateGroup sg_CoolieStand = new EnemyStateGroup(s_CoolieStand[0], s_CoolieStand[1], s_CoolieStand[2], s_CoolieStand[3], s_CoolieStand[4]);
    private static final State[][] s_CooliePain = new State[][]{{new State(1420, 60, CooliePain).setNext()}, {new State(1420, 60, CooliePain).setNext()}, {new State(1420, 60, CooliePain).setNext()}, {new State(1420, 60, CooliePain).setNext()}, {new State(1420, 60, CooliePain).setNext()}};
    private static final State[] s_CoolieDie = new State[]{new State(4260, 30, NullCoolie), new State(4260, Gameutils.SF_QUICK_CALL, SpawnCoolieExp), new State(4261, 30, NullCoolie), new State(4262, 30, NullCoolie), new State(4263, 30, NullCoolie), new State(4264, 30, NullCoolie), new State(4265, 30, NullCoolie), new State(4266, 30, NullCoolie), new State(4267, 30, DoCoolieWaitBirth).setNext(), new State(4267, 150, Actor.DoActorDebris), new State(4267, Gameutils.SF_QUICK_CALL, SpawnCoolg), new State(1440, Gameutils.SF_QUICK_CALL, Player.QueueFloorBlood), new State(1440, 30, Actor.DoActorDebris).setNext()};
    private static final EnemyStateGroup sg_CooliePain = new EnemyStateGroup(s_CooliePain[0], s_CooliePain[1], s_CooliePain[2], s_CooliePain[3], s_CooliePain[4]);
    private static final State[] s_CoolieDead = new State[]{new State(4268, 30, Actor.DoActorDebris)};
    private static final EnemyStateGroup sg_CoolieDead = new EnemyStateGroup(new State[][]{s_CoolieDead});
    private static final EnemyStateGroup sg_CoolieDie = new EnemyStateGroup(new State[][]{s_CoolieDie});
    private static final Actor_Action_Set CoolieActionSet = new Actor_Action_Set(sg_CoolieStand, sg_CoolieRun, null, null, null, null, null, null, null, null, null, sg_CooliePain, sg_CoolieDie, null, sg_CoolieDead, null, null, new StateGroup[]{sg_CoolieCharge}, new short[]{1024}, new StateGroup[]{sg_CoolieCharge}, new short[]{1024}, null, null, null);

    public static void InitCoolieStates() {
        for (EnemyStateGroup sg : new EnemyStateGroup[]{sg_CoolieCharge, sg_CoolieRun, sg_CooliePain, sg_CoolieDie, sg_CoolieStand, sg_CoolieDead}) {
            for (int rot = 0; rot < sg.getGroup().length; ++rot) {
                State.InitState(sg.getGroup()[rot]);
            }
        }
    }

    public static void EnemyDefaults(int SpriteNum, Actor_Action_Set action, Personality person) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        int depth = 0;
        switch (u.ID) {
            case 623: 
            case 2540: 
            case 4550: 
            case 4590: 
            case 4594: 
            case 4600: 
            case 4604: 
            case 4768: 
            case 4792: 
            case 4816: 
            case 4840: 
            case 5023: 
            case 5032: {
                break;
            }
            default: {
                ++Game.TotalKillable;
            }
        }
        sp.setCstat(sp.getCstat() & ~Gameutils.CSTAT_SPRITE_RESTORE);
        u.spal = (byte)sp.getPal();
        u.RotNum = 5;
        sp.setClipdist(64);
        u.zclip = Gameutils.Z(48);
        u.lo_step = Gameutils.Z(32);
        u.floor_dist = u.zclip - u.lo_step;
        u.ceiling_dist = Gameutils.SPRITEp_SIZE_Z(sp) - u.zclip;
        u.Radius = 400;
        u.MaxHealth = u.Health;
        u.PainThreshold = MyTypes.DIV16(u.Health) - 1;
        sp.setCstat(sp.getCstat() | (Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        sp.setExtra(sp.getExtra() | Gameutils.SPRX_PLAYER_OR_ENEMY);
        sp.setPicnum(u.State.Pic);
        Sprites.change_sprite_stat(SpriteNum, 2);
        u.Personality = person;
        u.ActorActionSet = action;
        Sprites.DoActorZrange(SpriteNum);
        if (u.lo_sectp != -1) {
            int sectnum = u.lo_sectp;
            Sect_User su = Sector.getSectUser(sectnum);
            ru.m210projects.Build.Types.Sector s = Main.boardService.getSector(sectnum);
            if (s != null && su != null && MyTypes.TEST(s.getExtra(), Gameutils.SECTFX_SINK)) {
                depth = su.depth;
            } else {
                for (ListNode<Sprite> node = Main.boardService.getSectNode(sectnum); node != null; node = node.getNext()) {
                    Sprite np = node.get();
                    if (np.getPicnum() != 2307 || np.getHitag() != 0) continue;
                    depth = np.getLotag();
                }
            }
        }
        if (depth != 0 && Pragmas.klabs(sp.getZ() - u.loz) < Gameutils.Z(8)) {
            sp.setZ(sp.getZ() + Gameutils.Z(depth));
            u.loz = sp.getZ();
            u.oz = sp.getZ();
        }
        if (action == null) {
            return;
        }
        Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Run);
        u.ActorActionFunc = Ai.DoActorDecide;
        int wpn_cnt = 0;
        for (int wpn = 0; u.ActorActionSet.Attack != null && wpn < u.ActorActionSet.Attack.length && u.ActorActionSet.Attack[wpn] != null; ++wpn) {
            ++wpn_cnt;
        }
        u.WeaponNum = wpn_cnt;
    }

    public static void SetupCoolie(int SpriteNum) {
        USER u;
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        if (MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.getUser(SpriteNum);
            if (u == null) {
                return;
            }
        } else {
            u = Sprites.SpawnUser(SpriteNum, 1400, s_CoolieRun[0][0]);
            Gameutils.setUser(SpriteNum, u);
            u.Health = 120;
        }
        Sprites.ChangeState(SpriteNum, s_CoolieRun[0][0]);
        u.Attrib = CoolieAttrib;
        Ai.DoActorSetSpeed(SpriteNum, 1);
        u.StateEnd = s_CoolieDie[0];
        u.setRot(sg_CoolieRun);
        Coolie.EnemyDefaults(SpriteNum, CoolieActionSet, CooliePersonality);
        sp.setXrepeat(42);
        sp.setYrepeat(42);
        u.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
    }

    private static void SpawnCoolg(int SpriteNum) {
        if (Gameutils.RANDOM_RANGE(1000) > 700) {
            return;
        }
        Coolg.NewCoolg(SpriteNum);
        Sound.PlaySpriteSound(SpriteNum, Ai.Attrib_Snds.attr_extra1, 1);
    }

    private static void CooliePain(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_CLIMBING)) {
            Actor.KeepActorOnFloor(SpriteNum);
        }
        Actor.DoActorSectorDamage(SpriteNum);
        if ((u.WaitTics -= 6) <= 0) {
            Ai.InitActorDecide(SpriteNum);
        }
    }

    private static void NullCoolie(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_CLIMBING)) {
            Actor.KeepActorOnFloor(SpriteNum);
        }
        Actor.DoActorSectorDamage(SpriteNum);
    }

    private static void DoCoolieMove(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (u.track >= 0) {
            Track.ActorFollowTrack(SpriteNum, 6);
        } else {
            u.ActorActionFunc.animatorInvoke(SpriteNum);
        }
        Actor.KeepActorOnFloor(SpriteNum);
        if (Actor.DoActorSectorDamage(SpriteNum)) {
            return;
        }
        WangSprite tsp = Main.boardService.getSprite(u.tgt_sp);
        if (tsp != null && Game.Distance(sp.getX(), sp.getY(), tsp.getX(), tsp.getY()) < 1200) {
            Weapon.UpdateSinglePlayKills(SpriteNum, null);
            Actor.DoActorDie(SpriteNum, SpriteNum);
        }
    }

    private static void InitCoolieCharge(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (Gameutils.RANDOM_P2(1024) > 950) {
            Sound.PlaySound(76, sp, 1);
        }
        Ai.DoActorSetSpeed(SpriteNum, 3);
        Ai.InitActorMoveCloser.animatorInvoke(SpriteNum);
        Sprites.NewStateGroup(SpriteNum, sg_CoolieCharge);
    }

    private static void DoCoolieWaitBirth(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u != null && (u.Counter -= 6) <= 0) {
            Sprites.ChangeState(SpriteNum, s_CoolieDie[9]);
        }
    }

    public static void CoolieSaveable() {
        Saveable.SaveData(SpawnCoolieExp);
        Saveable.SaveData(SpawnCoolg);
        Saveable.SaveData(CooliePain);
        Saveable.SaveData(NullCoolie);
        Saveable.SaveData(DoCoolieMove);
        Saveable.SaveData(InitCoolieCharge);
        Saveable.SaveData(DoCoolieWaitBirth);
        Saveable.SaveData(CooliePersonality);
        Saveable.SaveData(CoolieAttrib);
        Saveable.SaveData(s_CoolieRun);
        Saveable.SaveGroup(sg_CoolieRun);
        Saveable.SaveData(s_CoolieCharge);
        Saveable.SaveGroup(sg_CoolieCharge);
        Saveable.SaveData(s_CoolieStand);
        Saveable.SaveGroup(sg_CoolieStand);
        Saveable.SaveData(s_CooliePain);
        Saveable.SaveGroup(sg_CooliePain);
        Saveable.SaveData(s_CoolieDie);
        Saveable.SaveGroup(sg_CoolieDie);
        Saveable.SaveData(s_CoolieDead);
        Saveable.SaveGroup(sg_CoolieDead);
        Saveable.SaveData(CoolieActionSet);
    }
}

