/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Enemies.EnemyStateGroup;
import ru.m210projects.Wang.Enemies.Personality;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Actor_Action_Set;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.StateGroup;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class GirlNinj {
    public static final int GIRLNINJA_RATE = 18;
    public static final int GIRLNINJA_STAND_RATE = 10;
    public static final int GIRLNINJA_RISE_RATE = 10;
    public static final int GIRLNINJA_DUCK_RATE = 10;
    public static final int GIRLNINJA_CRAWL_RATE = 14;
    public static final int GIRLNINJA_JUMP_RATE = 24;
    public static final int GIRLNINJA_FALL_RATE = 16;
    public static final int GIRLNINJA_PAIN_RATE = 15;
    public static final int GIRLNINJA_STICKY_RATE = 32;
    public static final int GIRLNINJA_CROSSBOW_RATE = 14;
    public static final int GIRLNINJA_DIE_RATE = 30;
    private static final Animator DoGirlNinjaMove = new Animator(GirlNinj::DoGirlNinjaMove);
    private static final Animator NullGirlNinja = new Animator(GirlNinj::NullGirlNinja);
    private static final Animator DoGirlNinjaPain = new Animator(GirlNinj::DoGirlNinjaPain);
    private static final Animator InitEnemyMine = new Animator(GirlNinj::InitEnemyMine);
    private static final Animator InitEnemyCrossbow = new Animator(GirlNinj::InitEnemyCrossbow);
    private static final Animator DoGirlNinjaSpecial = new Animator(GirlNinj::DoGirlNinjaSpecial);
    private static final Animator DoActorDeathMove = new Animator(Actor::DoActorDeathMove);
    private static final Decision[] GirlNinjaBattle = new Decision[]{new Decision(499, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] GirlNinjaOffense = new Decision[]{new Decision(499, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] GirlNinjaBroadcast = new Decision[]{new Decision(6, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] GirlNinjaSurprised = new Decision[]{new Decision(701, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] GirlNinjaEvasive = new Decision[]{new Decision(400, Ai.InitActorDuck), new Decision(1024, null)};
    private static final Decision[] GirlNinjaLostTarget = new Decision[]{new Decision(900, Ai.InitActorFindPlayer), new Decision(1024, Ai.InitActorWanderAround)};
    private static final Decision[] GirlNinjaCloseRange = new Decision[]{new Decision(900, Ai.InitActorAttack), new Decision(1024, Ai.InitActorReposition)};
    private static final Personality GirlNinjaPersonality = new Personality(GirlNinjaBattle, GirlNinjaOffense, GirlNinjaBroadcast, GirlNinjaSurprised, GirlNinjaEvasive, GirlNinjaLostTarget, GirlNinjaCloseRange, GirlNinjaCloseRange);
    private static final ATTRIBUTE GirlNinjaAttrib = new ATTRIBUTE(new short[]{120, 140, 160, 190}, new short[]{4, 0, 0, -2}, 3, new int[]{577, 577, 2, 575, 576, 0, 0, 0, 0, 0});
    private static final State[][] s_GirlNinjaRun = new State[][]{{new State(5162, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5163, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5164, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5165, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove)}, {new State(5166, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5167, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5168, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5169, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove)}, {new State(5170, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5171, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5172, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5173, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove)}, {new State(5174, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5175, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5176, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5177, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove)}, {new State(5178, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5179, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5180, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5181, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove)}};
    private static final EnemyStateGroup sg_GirlNinjaRun = new EnemyStateGroup(s_GirlNinjaRun[0], s_GirlNinjaRun[1], s_GirlNinjaRun[2], s_GirlNinjaRun[3], s_GirlNinjaRun[4]);
    private static final State[][] s_GirlNinjaStand = new State[][]{{new State(5162, 10, DoGirlNinjaMove).setNext()}, {new State(5166, 10, DoGirlNinjaMove).setNext()}, {new State(5170, 10, DoGirlNinjaMove).setNext()}, {new State(5174, 10, DoGirlNinjaMove).setNext()}, {new State(5178, 10, DoGirlNinjaMove).setNext()}};
    private static final EnemyStateGroup sg_GirlNinjaStand = new EnemyStateGroup(s_GirlNinjaStand[0], s_GirlNinjaStand[1], s_GirlNinjaStand[2], s_GirlNinjaStand[3], s_GirlNinjaStand[4]);
    private static final State[][] s_GirlNinjaRise = new State[][]{{new State(5211, 10, NullGirlNinja), new State(5162, 10, NullGirlNinja), new State(0, 0, null)}, {new State(5212, 10, NullGirlNinja), new State(5166, 10, NullGirlNinja), new State(0, 0, null)}, {new State(5213, 10, NullGirlNinja), new State(5170, 10, NullGirlNinja), new State(0, 0, null)}, {new State(5214, 10, NullGirlNinja), new State(5174, 10, NullGirlNinja), new State(0, 0, null)}, {new State(5215, 10, NullGirlNinja), new State(5178, 10, NullGirlNinja), new State(0, 0, null)}};
    private static final EnemyStateGroup sg_GirlNinjaRise = new EnemyStateGroup(s_GirlNinjaRise[0], s_GirlNinjaRise[1], s_GirlNinjaRise[2], s_GirlNinjaRise[3], s_GirlNinjaRise[4]);
    private static final State[][] s_GirlNinjaDuck = new State[][]{{new State(5211, 10, NullGirlNinja), new State(5211, 14, DoGirlNinjaMove).setNext()}, {new State(5212, 10, NullGirlNinja), new State(5212, 14, DoGirlNinjaMove).setNext()}, {new State(5213, 10, NullGirlNinja), new State(5213, 14, DoGirlNinjaMove).setNext()}, {new State(5214, 10, NullGirlNinja), new State(5214, 14, DoGirlNinjaMove).setNext()}, {new State(5215, 10, NullGirlNinja), new State(5215, 14, DoGirlNinjaMove).setNext()}};
    private static final EnemyStateGroup sg_GirlNinjaDuck = new EnemyStateGroup(s_GirlNinjaDuck[0], s_GirlNinjaDuck[1], s_GirlNinjaDuck[2], s_GirlNinjaDuck[3], s_GirlNinjaDuck[4]);
    private static final State[][] s_GirlNinjaSit = new State[][]{{new State(5211, 10, DoGirlNinjaMove).setNext()}, {new State(5212, 10, DoGirlNinjaMove).setNext()}, {new State(5213, 10, DoGirlNinjaMove).setNext()}, {new State(5214, 10, DoGirlNinjaMove).setNext()}, {new State(5215, 10, DoGirlNinjaMove).setNext()}};
    private static final EnemyStateGroup sg_GirlNinjaSit = new EnemyStateGroup(s_GirlNinjaSit[0], s_GirlNinjaSit[1], s_GirlNinjaSit[2], s_GirlNinjaSit[3], s_GirlNinjaSit[4]);
    private static final State[][] s_GirlNinjaJump = new State[][]{{new State(5226, 24, DoGirlNinjaMove), new State(5227, 24, DoGirlNinjaMove).setNext()}, {new State(5230, 24, DoGirlNinjaMove), new State(5231, 24, DoGirlNinjaMove).setNext()}, {new State(5234, 24, DoGirlNinjaMove), new State(5235, 24, DoGirlNinjaMove).setNext()}, {new State(5238, 24, DoGirlNinjaMove), new State(5239, 24, DoGirlNinjaMove).setNext()}, {new State(5242, 24, DoGirlNinjaMove), new State(5243, 24, DoGirlNinjaMove).setNext()}};
    private static final EnemyStateGroup sg_GirlNinjaJump = new EnemyStateGroup(s_GirlNinjaJump[0], s_GirlNinjaJump[1], s_GirlNinjaJump[2], s_GirlNinjaJump[3], s_GirlNinjaJump[4]);
    private static final State[][] s_GirlNinjaFall = new State[][]{{new State(5227, 16, DoGirlNinjaMove), new State(5228, 16, DoGirlNinjaMove).setNext()}, {new State(5231, 16, DoGirlNinjaMove), new State(5232, 16, DoGirlNinjaMove).setNext()}, {new State(5235, 16, DoGirlNinjaMove), new State(5236, 16, DoGirlNinjaMove).setNext()}, {new State(5239, 16, DoGirlNinjaMove), new State(5240, 16, DoGirlNinjaMove).setNext()}, {new State(5243, 16, DoGirlNinjaMove), new State(5244, 16, DoGirlNinjaMove).setNext()}};
    private static final EnemyStateGroup sg_GirlNinjaFall = new EnemyStateGroup(s_GirlNinjaFall[0], s_GirlNinjaFall[1], s_GirlNinjaFall[2], s_GirlNinjaFall[3], s_GirlNinjaFall[4]);
    private static final State[][] s_GirlNinjaPain = new State[][]{{new State(5192, 15, DoGirlNinjaPain).setNext()}, {new State(5192, 15, DoGirlNinjaPain).setNext()}, {new State(5192, 15, DoGirlNinjaPain).setNext()}, {new State(5192, 15, DoGirlNinjaPain).setNext()}, {new State(5192, 15, DoGirlNinjaPain).setNext()}};
    private static final EnemyStateGroup sg_GirlNinjaPain = new EnemyStateGroup(s_GirlNinjaPain[0], s_GirlNinjaPain[1], s_GirlNinjaPain[2], s_GirlNinjaPain[3], s_GirlNinjaPain[4]);
    private static final State[][] s_GirlNinjaSticky = new State[][]{{new State(5246, 64, NullGirlNinja), new State(5246, 32, NullGirlNinja), new State(5247, Gameutils.SF_QUICK_CALL, InitEnemyMine), new State(5247, 64, NullGirlNinja), new State(5248, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5248, 32, DoGirlNinjaMove).setNext()}, {new State(5249, 64, NullGirlNinja), new State(5249, 32, NullGirlNinja), new State(5250, Gameutils.SF_QUICK_CALL, InitEnemyMine), new State(5250, 64, NullGirlNinja), new State(5251, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5251, 32, DoGirlNinjaMove).setNext()}, {new State(5252, 64, NullGirlNinja), new State(5252, 32, NullGirlNinja), new State(5253, Gameutils.SF_QUICK_CALL, InitEnemyMine), new State(5253, 64, NullGirlNinja), new State(5254, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5254, 32, DoGirlNinjaMove).setNext()}, {new State(5252, 64, NullGirlNinja), new State(5252, 32, NullGirlNinja), new State(5253, Gameutils.SF_QUICK_CALL, InitEnemyMine), new State(5253, 64, NullGirlNinja), new State(5254, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5254, 32, DoGirlNinjaMove).setNext()}, {new State(5252, 64, NullGirlNinja), new State(5252, 32, NullGirlNinja), new State(5253, Gameutils.SF_QUICK_CALL, InitEnemyMine), new State(5253, 64, NullGirlNinja), new State(5254, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5254, 32, DoGirlNinjaMove).setNext()}};
    private static final EnemyStateGroup sg_GirlNinjaSticky = new EnemyStateGroup(s_GirlNinjaSticky[0], s_GirlNinjaSticky[1], s_GirlNinjaSticky[2], s_GirlNinjaSticky[3], s_GirlNinjaSticky[4]);
    private static final State[][] s_GirlNinjaCrossbow = new State[][]{{new State(5182, 28, NullGirlNinja), new State(5183, Gameutils.SF_QUICK_CALL, InitEnemyCrossbow), new State(5183, 14, NullGirlNinja), new State(5183, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5183, 14, DoGirlNinjaMove).setNext()}, {new State(5184, 28, NullGirlNinja), new State(5185, Gameutils.SF_QUICK_CALL, InitEnemyCrossbow), new State(5185, 14, NullGirlNinja), new State(5185, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5185, 14, DoGirlNinjaMove).setNext()}, {new State(5186, 28, NullGirlNinja), new State(5187, Gameutils.SF_QUICK_CALL, InitEnemyCrossbow), new State(5187, 14, NullGirlNinja), new State(5187, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5187, 14, DoGirlNinjaMove).setNext()}, {new State(5188, 28, NullGirlNinja), new State(5189, Gameutils.SF_QUICK_CALL, InitEnemyCrossbow), new State(5189, 14, NullGirlNinja), new State(5189, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5189, 14, DoGirlNinjaMove).setNext()}, {new State(5190, 28, NullGirlNinja), new State(5191, Gameutils.SF_QUICK_CALL, InitEnemyCrossbow), new State(5191, 14, NullGirlNinja), new State(5191, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5191, 14, DoGirlNinjaMove).setNext()}};
    private static final EnemyStateGroup sg_GirlNinjaCrossbow = new EnemyStateGroup(s_GirlNinjaCrossbow[0], s_GirlNinjaCrossbow[1], s_GirlNinjaCrossbow[2], s_GirlNinjaCrossbow[3], s_GirlNinjaCrossbow[4]);
    private static final State[] s_GirlNinjaDie = new State[]{new State(5197, 60, NullGirlNinja), new State(5198, 30, NullGirlNinja), new State(5199, 30, NullGirlNinja), new State(5200, 30, NullGirlNinja), new State(5201, 30, NullGirlNinja), new State(5202, 30, NullGirlNinja), new State(5203, 30, NullGirlNinja), new State(5203, Gameutils.SF_QUICK_CALL, DoGirlNinjaSpecial), new State(5204, 30, NullGirlNinja), new State(5205, Gameutils.SF_QUICK_CALL, Player.QueueFloorBlood), new State(5205, 30, Actor.DoActorDebris).setNext()};
    private static final EnemyStateGroup sg_GirlNinjaDie = new EnemyStateGroup(new State[][]{s_GirlNinjaDie});
    private static final State[] s_GirlNinjaDead = new State[]{new State(5203, 30, Actor.DoActorDebris), new State(5204, Gameutils.SF_QUICK_CALL, DoGirlNinjaSpecial), new State(5204, 30, Actor.DoActorDebris), new State(5205, Gameutils.SF_QUICK_CALL, Player.QueueFloorBlood), new State(5205, 30, Actor.DoActorDebris).setNext()};
    private static final EnemyStateGroup sg_GirlNinjaDead = new EnemyStateGroup(new State[][]{s_GirlNinjaDead});
    private static final State[] s_GirlNinjaDeathJump = new State[]{new State(5197, 30, DoActorDeathMove), new State(5198, 30, DoActorDeathMove), new State(5199, 30, DoActorDeathMove).setNext()};
    private static final EnemyStateGroup sg_GirlNinjaDeathJump = new EnemyStateGroup(new State[][]{s_GirlNinjaDeathJump});
    private static final State[] s_GirlNinjaDeathFall = new State[]{new State(5200, 30, DoActorDeathMove), new State(5201, 30, DoActorDeathMove).setNext()};
    private static final EnemyStateGroup sg_GirlNinjaDeathFall = new EnemyStateGroup(new State[][]{s_GirlNinjaDeathFall});
    private static final Actor_Action_Set GirlNinjaActionSet = new Actor_Action_Set(sg_GirlNinjaStand, sg_GirlNinjaRun, sg_GirlNinjaJump, sg_GirlNinjaFall, null, null, null, sg_GirlNinjaRise, sg_GirlNinjaSit, null, null, sg_GirlNinjaPain, sg_GirlNinjaDie, null, sg_GirlNinjaDead, sg_GirlNinjaDeathJump, sg_GirlNinjaDeathFall, new StateGroup[]{sg_GirlNinjaCrossbow, sg_GirlNinjaSticky}, new short[]{800, 1024}, new StateGroup[]{sg_GirlNinjaCrossbow, sg_GirlNinjaSticky}, new short[]{800, 1024}, null, sg_GirlNinjaDuck, null);

    public static void InitGNinjaStates() {
        for (EnemyStateGroup sg : new EnemyStateGroup[]{sg_GirlNinjaStand, sg_GirlNinjaRun, sg_GirlNinjaJump, sg_GirlNinjaFall, sg_GirlNinjaRise, sg_GirlNinjaSit, sg_GirlNinjaPain, sg_GirlNinjaDie, sg_GirlNinjaDead, sg_GirlNinjaDeathJump, sg_GirlNinjaDeathFall, sg_GirlNinjaCrossbow, sg_GirlNinjaSticky, sg_GirlNinjaDuck}) {
            for (int rot = 0; rot < sg.getGroup().length; ++rot) {
                State.InitState(sg.getGroup()[rot]);
                if (sg != sg_GirlNinjaRise) continue;
                sg.getGroup()[rot][2].setNextGroup(sg_GirlNinjaRun);
            }
        }
    }

    public static void SetupGirlNinja(int SpriteNum) {
        USER u;
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        if (MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.getUser(SpriteNum);
            if (u == null) {
                return;
            }
        } else {
            u = Sprites.SpawnUser(SpriteNum, 5162, s_GirlNinjaRun[0][0]);
            Gameutils.setUser(SpriteNum, u);
            u.Health = 100;
        }
        u.StateEnd = s_GirlNinjaDie[0];
        u.setRot(sg_GirlNinjaRun);
        sp.setXrepeat(51);
        sp.setYrepeat(43);
        u.Attrib = GirlNinjaAttrib;
        u.spal = (byte)26;
        sp.setPal(26);
        Coolie.EnemyDefaults(SpriteNum, GirlNinjaActionSet, GirlNinjaPersonality);
        Sprites.ChangeState(SpriteNum, s_GirlNinjaRun[0][0]);
        Ai.DoActorSetSpeed(SpriteNum, 1);
        u.Radius = 280;
        u.Flags &= ~Gameutils.SPR_XFLIP_TOGGLE;
    }

    private static void DoGirlNinjaMove(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING) && !MyTypes.TEST(u.Flags, Gameutils.SPR_CLIMBING)) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
                Actor.DoActorJump(SpriteNum);
            } else if (MyTypes.TEST(u.Flags, Gameutils.SPR_FALLING)) {
                Actor.DoActorFall(SpriteNum);
            }
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING) && !MyTypes.TEST(u.Flags, Gameutils.SPR_CLIMBING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (u.track >= 0) {
            Track.ActorFollowTrack(SpriteNum, 6);
        } else {
            u.ActorActionFunc.animatorInvoke(SpriteNum);
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING | Gameutils.SPR_CLIMBING)) {
            Actor.KeepActorOnFloor(SpriteNum);
        }
        Actor.DoActorSectorDamage(SpriteNum);
    }

    private static void NullGirlNinja(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        if (u.WaitTics > 0) {
            u.WaitTics -= 6;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING) && !MyTypes.TEST(u.Flags, Gameutils.SPR_CLIMBING) && !MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_CLIMBING) && !MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            Actor.KeepActorOnFloor(SpriteNum);
        }
        Actor.DoActorSectorDamage(SpriteNum);
    }

    private static void DoGirlNinjaPain(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        GirlNinj.NullGirlNinja(SpriteNum);
        if (u != null && (u.WaitTics -= 6) <= 0) {
            Ai.InitActorDecide(SpriteNum);
        }
    }

    private static void DoGirlNinjaSpecial(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if (u.spal == 21) {
            sp.setCstat(sp.getCstat() & ~Gameutils.CSTAT_SPRITE_TRANSLUCENT);
            sp.setHitag(0);
            sp.setShade(-10);
        }
    }

    public static void InitEnemyMine(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        Sound.PlaySound(23, sp, 12);
        int nx = sp.getX();
        int ny = sp.getY();
        int nz = sp.getZ() - Gameutils.Z(40);
        int w = Sprites.SpawnSprite(4, 2223, Weapon.s_Mine[0], sp.getSectnum(), nx, ny, nz, sp.getAng(), 520);
        if (w == -1) {
            return;
        }
        WangSprite wp = Main.boardService.getSprite(w);
        USER wu = Gameutils.getUser(w);
        if (wp == null || wu == null) {
            return;
        }
        Sprites.SetOwner(SpriteNum, w);
        wp.setYrepeat(32);
        wp.setXrepeat(32);
        wp.setShade(-15);
        wp.setClipdist(32);
        wu.WeaponNum = u.WeaponNum;
        wu.Radius = 200;
        wu.ceiling_dist = Gameutils.Z(5);
        wu.floor_dist = Gameutils.Z(5);
        wu.Counter = 0;
        wp.setCstat(wp.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
        wp.setCstat(wp.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        wu.spal = u.spal;
        wp.setPal(wu.spal);
        if (Gameutils.SpriteInUnderwaterArea(wp)) {
            wu.Flags |= Gameutils.SPR_UNDERWATER;
        }
        Weapon.MissileSetPos(w, Weapon.DoMine, 300);
        wp.setAng(Gameutils.NORM_ANGLE(wp.getAng() - 512));
        Weapon.MissileSetPos(w, Weapon.DoMine, 300);
        wp.setAng(Gameutils.NORM_ANGLE(wp.getAng() + 512));
        wu.zchange = -5000;
        wu.xchange = Gameutils.MOVEx(wp.getXvel(), wp.getAng());
        wu.ychange = Gameutils.MOVEy(wp.getXvel(), wp.getAng());
    }

    public static boolean InitEnemyCrossbow(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return false;
        }
        WangSprite tsp = Main.boardService.getSprite(u.tgt_sp);
        if (tsp == null) {
            return false;
        }
        int nang = Gameutils.NORM_ANGLE(EngineUtils.getAngle(tsp.getX() - sp.getX(), tsp.getY() - sp.getY()));
        sp.setAng(nang);
        int nx = sp.getX();
        int ny = sp.getY();
        int nz = Gameutils.SPRITEp_MID(sp) - Gameutils.Z(14);
        int w = Sprites.SpawnSprite(4, 2230, Weapon.s_CrossBolt[0][0], sp.getSectnum(), nx, ny, nz, tsp.getAng(), 800);
        WangSprite wp = Main.boardService.getSprite(w);
        USER wu = Gameutils.getUser(w);
        if (wp == null || wu == null) {
            return false;
        }
        Sprites.SetOwner(SpriteNum, w);
        wp.setXrepeat(16);
        wp.setYrepeat(26);
        wp.setShade(-25);
        wp.setZvel(0);
        wp.setAng(nang);
        wp.setClipdist(16);
        wu.RotNum = 5;
        Sprites.NewStateGroup(w, Weapon.WeaponStateGroup.sg_CrossBolt);
        wu.xchange = Gameutils.MOVEx(wp.getXvel(), wp.getAng());
        wu.ychange = Gameutils.MOVEy(wp.getXvel(), wp.getAng());
        wu.zchange = wp.getZvel();
        wu.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
        Weapon.MissileSetPos(w, Weapon.DoStar, 400);
        int dist = Game.Distance(wp.getX(), wp.getY(), tsp.getX(), tsp.getY());
        if (dist != 0) {
            wu.zchange = (short)(wp.getXvel() * (Gameutils.SPRITEp_UPPER(tsp) - wp.getZ()) / dist);
            wp.setZvel(wu.zchange);
        }
        Sound.PlaySound(2, sp, 0);
        return w != 0;
    }

    public static void GirlNinjSaveable() {
        Saveable.SaveData(InitEnemyMine);
        Saveable.SaveData(InitEnemyCrossbow);
        Saveable.SaveData(DoActorDeathMove);
        Saveable.SaveData(DoGirlNinjaMove);
        Saveable.SaveData(NullGirlNinja);
        Saveable.SaveData(DoGirlNinjaPain);
        Saveable.SaveData(DoGirlNinjaSpecial);
        Saveable.SaveData(GirlNinjaPersonality);
        Saveable.SaveData(GirlNinjaAttrib);
        Saveable.SaveData(s_GirlNinjaRun);
        Saveable.SaveGroup(sg_GirlNinjaRun);
        Saveable.SaveData(s_GirlNinjaStand);
        Saveable.SaveGroup(sg_GirlNinjaStand);
        Saveable.SaveData(s_GirlNinjaRise);
        Saveable.SaveGroup(sg_GirlNinjaRise);
        Saveable.SaveData(s_GirlNinjaDuck);
        Saveable.SaveGroup(sg_GirlNinjaDuck);
        Saveable.SaveData(s_GirlNinjaSit);
        Saveable.SaveGroup(sg_GirlNinjaSit);
        Saveable.SaveData(s_GirlNinjaJump);
        Saveable.SaveGroup(sg_GirlNinjaJump);
        Saveable.SaveData(s_GirlNinjaFall);
        Saveable.SaveGroup(sg_GirlNinjaFall);
        Saveable.SaveData(s_GirlNinjaPain);
        Saveable.SaveGroup(sg_GirlNinjaPain);
        Saveable.SaveData(s_GirlNinjaSticky);
        Saveable.SaveGroup(sg_GirlNinjaSticky);
        Saveable.SaveData(s_GirlNinjaCrossbow);
        Saveable.SaveGroup(sg_GirlNinjaCrossbow);
        Saveable.SaveData(s_GirlNinjaDie);
        Saveable.SaveData(s_GirlNinjaDead);
        Saveable.SaveData(s_GirlNinjaDeathJump);
        Saveable.SaveData(s_GirlNinjaDeathFall);
        Saveable.SaveData(GirlNinjaActionSet);
    }
}

