/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Enemies.EnemyStateGroup;
import ru.m210projects.Wang.Enemies.Personality;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Actor_Action_Set;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.Sect_User;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Type.VOC3D;
import ru.m210projects.Wang.Weapon;

public class Hornet {
    private static final Animator InitHornetSting = new Animator(Hornet::InitHornetSting);
    private static final Animator DoHornetMove = new Animator(Hornet::DoHornetMove);
    private static final Animator DoHornetDeath = new Animator(Hornet::DoHornetDeath);
    private static final Animator DoHornetCircle = new Animator(Hornet::DoHornetCircle);
    private static final Animator InitHornetCircle = new Animator(Hornet::InitHornetCircle);
    public static final int HORNET_RUN_RATE = 7;
    public static final int HORNET_STAND_RATE = 12;
    public static final int HORNET_DIE_RATE = 20;
    public static final int HORNET_BOB_AMT = Gameutils.Z(16);
    private static final Decision[] HornetOffense = new Decision[]{new Decision(1022, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorAlertNoise)};
    private static final Decision[] HornetBroadcast = new Decision[]{new Decision(3, Ai.InitActorAlertNoise), new Decision(6, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] HornetLostTarget = new Decision[]{new Decision(900, Ai.InitActorFindPlayer), new Decision(1024, Ai.InitActorWanderAround)};
    private static final Decision[] HornetCloseRange = new Decision[]{new Decision(900, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorReposition)};
    private static final ATTRIBUTE HornetAttrib = new ATTRIBUTE(new short[]{300, 350, 375, 400}, new short[]{0, 0, 0, 0}, 0, new int[]{0, 0, 120, 120, 122, 0, 0, 0, 0, 0});
    private static final State[][] s_HornetRun = new State[][]{{new State(800, 7, DoHornetMove), new State(801, 7, DoHornetMove)}, {new State(802, 7, DoHornetMove), new State(803, 7, DoHornetMove)}, {new State(804, 7, DoHornetMove), new State(805, 7, DoHornetMove)}, {new State(806, 7, DoHornetMove), new State(807, 7, DoHornetMove)}, {new State(808, 7, DoHornetMove), new State(809, 7, DoHornetMove)}};
    private static final State[][] s_HornetStand = new State[][]{{new State(800, 12, DoHornetMove), new State(801, 12, DoHornetMove)}, {new State(802, 12, DoHornetMove), new State(803, 12, DoHornetMove)}, {new State(804, 12, DoHornetMove), new State(805, 12, DoHornetMove)}, {new State(806, 12, DoHornetMove), new State(807, 12, DoHornetMove)}, {new State(808, 12, DoHornetMove), new State(809, 12, DoHornetMove)}};
    private static final State[] s_HornetDie = new State[]{new State(810, 20, DoHornetDeath).setNext()};
    private static final State[] s_HornetDead = new State[]{new State(811, 20, Actor.DoActorDebris).setNext()};
    private static final EnemyStateGroup sg_HornetStand = new EnemyStateGroup(s_HornetStand[0], s_HornetStand[1], s_HornetStand[2], s_HornetStand[3], s_HornetStand[4]);
    private static final EnemyStateGroup sg_HornetRun = new EnemyStateGroup(s_HornetRun[0], s_HornetRun[1], s_HornetRun[2], s_HornetRun[3], s_HornetRun[4]);
    private static final EnemyStateGroup sg_HornetDie = new EnemyStateGroup(new State[][]{s_HornetDie});
    private static final EnemyStateGroup sg_HornetDead = new EnemyStateGroup(new State[][]{s_HornetDead});
    private static final Actor_Action_Set HornetActionSet = new Actor_Action_Set(sg_HornetStand, sg_HornetRun, null, null, null, null, null, null, null, null, null, null, sg_HornetDie, null, sg_HornetDead, null, null, null, new short[]{0}, null, new short[]{0}, null, null, null);
    private static final Decision[] HornetBattle = new Decision[]{new Decision(50, InitHornetCircle), new Decision(798, Ai.InitActorMoveCloser), new Decision(800, Ai.InitActorAlertNoise), new Decision(1024, Ai.InitActorRunAway)};
    private static final Decision[] HornetSurprised = new Decision[]{new Decision(100, InitHornetCircle), new Decision(701, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] HornetEvasive = new Decision[]{new Decision(20, InitHornetCircle), new Decision(1024, null)};
    private static final Decision[] HornetTouchTarget = new Decision[]{new Decision(500, InitHornetCircle), new Decision(1024, InitHornetSting)};
    private static final Personality HornetPersonality = new Personality(HornetBattle, HornetOffense, HornetBroadcast, HornetSurprised, HornetEvasive, HornetLostTarget, HornetCloseRange, HornetTouchTarget);

    public static void InitHornetStates() {
        for (EnemyStateGroup sg : new EnemyStateGroup[]{sg_HornetStand, sg_HornetRun, sg_HornetDie, sg_HornetDead}) {
            for (int rot = 0; rot < sg.getGroup().length; ++rot) {
                State.InitState(sg.getGroup()[rot]);
            }
        }
    }

    public static void SetupHornet(int SpriteNum) {
        USER u;
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        if (MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.getUser(SpriteNum);
            if (u == null) {
                return;
            }
        } else {
            u = Sprites.SpawnUser(SpriteNum, 800, s_HornetRun[0][0]);
            Gameutils.setUser(SpriteNum, u);
            u.Health = 4;
        }
        Sprites.ChangeState(SpriteNum, s_HornetRun[0][0]);
        u.Attrib = HornetAttrib;
        Ai.DoActorSetSpeed(SpriteNum, 1);
        u.StateEnd = s_HornetDie[0];
        u.setRot(sg_HornetRun);
        Coolie.EnemyDefaults(SpriteNum, HornetActionSet, HornetPersonality);
        u.Flags |= Gameutils.SPR_NO_SCAREDZ | Gameutils.SPR_XFLIP_TOGGLE;
        sp.setCstat(sp.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
        sp.setClipdist(25);
        u.floor_dist = Gameutils.Z(16);
        u.ceiling_dist = Gameutils.Z(16);
        u.sz = sp.getZ();
        sp.setXrepeat(37);
        sp.setYrepeat(32);
        VOC3D voc = Sound.PlaySound(119, sp, 65);
        Sound.Set3DSoundOwner(SpriteNum, voc);
    }

    private static void DoHornetMatchPlayerZ(int SpriteNum) {
        int bound;
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        WangSprite tsp = Main.boardService.getSprite(u.tgt_sp);
        if (tsp == null) {
            return;
        }
        int zdiff = Gameutils.SPRITEp_MID(tsp) - u.sz;
        int zdist = Gameutils.Z(20 + Gameutils.RANDOM_RANGE(200));
        if (Pragmas.klabs(zdiff) > zdist) {
            u.sz = zdiff > 0 ? (u.sz += 6144) : (u.sz -= 1536);
        }
        int loz = u.loz;
        int hiz = u.hiz;
        Sect_User su = Sector.getSectUser(u.lo_sectp);
        if (u.lo_sectp != -1 && su != null && su.depth != 0) {
            loz -= Gameutils.Z(su.depth) - Gameutils.Z(8);
        }
        if (u.sz > (bound = u.lo_sp != -1 ? loz - u.floor_dist : loz - u.floor_dist - HORNET_BOB_AMT)) {
            u.sz = bound;
        }
        if (u.sz < (bound = u.hi_sp != -1 ? hiz + u.ceiling_dist : hiz + u.ceiling_dist + HORNET_BOB_AMT)) {
            u.sz = bound;
        }
        u.sz = Math.min(u.sz, loz - u.floor_dist);
        u.sz = Math.max(u.sz, hiz + u.ceiling_dist);
        u.Counter = u.Counter + 48 + 12 & 0x7FF;
        sp.setZ(u.sz + (HORNET_BOB_AMT * EngineUtils.sin(u.Counter) >> 14));
        bound = u.hiz + u.ceiling_dist + HORNET_BOB_AMT;
        if (sp.getZ() < bound) {
            u.sz = bound + HORNET_BOB_AMT;
            sp.setZ(u.sz);
        }
    }

    private static void InitHornetCircle(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        u.ActorActionFunc = DoHornetCircle;
        Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Run);
        Ai.DoActorSetSpeed(SpriteNum, 3);
        sp.setXvel(400);
        u.Counter2 = sp.getXvel() / 3;
        if (Gameutils.RANDOM_P2(1024) < 512) {
            u.Counter2 = -u.Counter2;
        }
        u.jump_speed = 200 + Gameutils.RANDOM_P2(128);
        if (Pragmas.klabs(u.sz - u.hiz) < Pragmas.klabs(u.sz - u.loz)) {
            u.jump_speed = -u.jump_speed;
        }
        u.WaitTics = (Gameutils.RANDOM_RANGE(3) + 1) * 60;
        u.ActorActionFunc.animatorInvoke(SpriteNum);
    }

    private static void DoHornetCircle(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() + u.Counter2));
        int nx = sp.getXvel() * EngineUtils.sin(Gameutils.NORM_ANGLE(sp.getAng() + 512)) >> 14;
        int ny = sp.getXvel() * EngineUtils.sin(sp.getAng()) >> 14;
        if (!Sprites.move_actor(SpriteNum, nx, ny, 0)) {
            u.Counter2 = -u.Counter2;
            sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() + 1024));
            nx = sp.getXvel() * EngineUtils.sin(Gameutils.NORM_ANGLE(sp.getAng() + 512)) >> 14;
            ny = sp.getXvel() * EngineUtils.sin(sp.getAng()) >> 14;
            if (!Sprites.move_actor(SpriteNum, nx, ny, 0)) {
                Ai.InitActorReposition.animatorInvoke(SpriteNum);
                return;
            }
        }
        u.sz -= u.jump_speed * 6;
        int bound = u.hiz + u.ceiling_dist + HORNET_BOB_AMT;
        if (u.sz < bound) {
            u.sz = bound;
            Ai.InitActorReposition.animatorInvoke(SpriteNum);
            return;
        }
        if ((u.WaitTics -= 6) < 0) {
            Ai.InitActorReposition.animatorInvoke(SpriteNum);
            u.WaitTics = 0;
        }
    }

    private static void DoHornetDeath(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_FALLING)) {
            u.loz = u.zclip;
            Actor.DoFall(SpriteNum);
        } else {
            sp.setCstat(sp.getCstat() & ~Gameutils.CSTAT_SPRITE_YCENTER);
            u.jump_speed = 0;
            u.floor_dist = 0;
            Actor.DoBeginFall(SpriteNum);
            Weapon.DoFindGroundPoint(SpriteNum);
            u.zclip = u.loz;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        int nx = sp.getXvel() * EngineUtils.sin(Gameutils.NORM_ANGLE(sp.getAng() + 512)) >> 14;
        int ny = sp.getXvel() * EngineUtils.sin(sp.getAng()) >> 14;
        u.moveSpriteReturn = Sprites.move_sprite(SpriteNum, nx, ny, 0, u.ceiling_dist, u.floor_dist, 1, 6);
        if (sp.getZ() >= u.loz) {
            u.Flags &= ~(Gameutils.SPR_FALLING | Gameutils.SPR_SLIDING);
            sp.setCstat(sp.getCstat() & ~Gameutils.CSTAT_SPRITE_YFLIP);
            Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Dead);
            Sound.DeleteNoSoundOwner(SpriteNum);
        }
    }

    public static void DoCheckSwarm(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if (Sprites.MoveSkip8 == 0) {
            return;
        }
        if (u.tgt_sp == -1) {
            return;
        }
        Ai.DoActorPickClosePlayer(SpriteNum);
        USER tgu = Gameutils.getUser(u.tgt_sp);
        if (tgu == null || tgu.PlayerP == -1) {
            return;
        }
        PlayerStr pp = Game.Player[tgu.PlayerP];
        int pdist = Gameutils.DISTANCE(sp.getX(), sp.getY(), pp.posx, pp.posy);
        ListNode<Sprite> node = Main.boardService.getStatNode(2);
        while (node != null) {
            int dist;
            int i = node.getIndex();
            ListNode<Sprite> nexti = node.getNext();
            Sprite tsp = node.get();
            USER tu = Gameutils.getUser(i);
            if (tu != null && tsp.getHitag() == 1008 && tsp.getLotag() == 2 && (dist = Gameutils.DISTANCE(sp.getX(), sp.getY(), tsp.getX(), tsp.getY())) < pdist && u.ID == tu.ID) {
                u.tgt_sp = i;
            }
            node = nexti;
        }
    }

    private static void DoHornetMove(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if (sp.getHitag() == 1008 && sp.getLotag() == 1) {
            Hornet.DoCheckSwarm(SpriteNum);
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (u.track >= 0) {
            Track.ActorFollowTrack(SpriteNum, 6);
        } else {
            u.ActorActionFunc.animatorInvoke(SpriteNum);
        }
        Hornet.DoHornetMatchPlayerZ(SpriteNum);
        Actor.DoActorSectorDamage(SpriteNum);
    }

    public static void InitHornetSting(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        int HitSprite = Gameutils.NORM_HIT_INDEX(u.moveSpriteReturn);
        Weapon.DoDamage(HitSprite, SpriteNum);
        Ai.InitActorReposition.animatorInvoke(SpriteNum);
    }

    public static void HornetSaveable() {
        Saveable.SaveData(InitHornetSting);
        Saveable.SaveData(InitHornetCircle);
        Saveable.SaveData(DoHornetCircle);
        Saveable.SaveData(DoHornetDeath);
        Saveable.SaveData(DoHornetMove);
        Saveable.SaveData(HornetPersonality);
        Saveable.SaveData(HornetAttrib);
        Saveable.SaveData(s_HornetRun);
        Saveable.SaveGroup(sg_HornetRun);
        Saveable.SaveData(s_HornetStand);
        Saveable.SaveGroup(sg_HornetStand);
        Saveable.SaveData(s_HornetDie);
        Saveable.SaveGroup(sg_HornetDie);
        Saveable.SaveData(s_HornetDead);
        Saveable.SaveGroup(sg_HornetDead);
        Saveable.SaveData(HornetActionSet);
    }
}

