/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Enemies.EnemyStateGroup;
import ru.m210projects.Wang.Enemies.Personality;
import ru.m210projects.Wang.Enemies.Skull;
import ru.m210projects.Wang.Enemies.Sumo;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Actor_Action_Set;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.StateGroup;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class Serp {
    public static final short[] delta_ang = new short[]{-10, 10};
    private static final Animator DoSerpMove = new Animator(Serp::DoSerpMove);
    private static final Animator NullSerp = new Animator(Serp::NullSerp);
    private static final Animator InitSerpSlash = new Animator(Serp::InitSerpSlash);
    private static final Animator InitSerpRing = new Animator(Serp::InitSerpRing);
    private static final Animator InitSerpSpell = new Animator(Serp::InitSerpSpell);
    private static final Decision[] SerpBattle = new Decision[]{new Decision(670, Ai.InitActorMoveCloser), new Decision(700, Ai.InitActorAmbientNoise), new Decision(710, Ai.InitActorRunAway), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] SerpOffense = new Decision[]{new Decision(775, Ai.InitActorMoveCloser), new Decision(800, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] SerpBroadcast = new Decision[]{new Decision(10, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] SerpSurprised = new Decision[]{new Decision(701, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] SerpEvasive = new Decision[]{new Decision(10, Ai.InitActorEvade), new Decision(1024, null)};
    private static final Decision[] SerpLostTarget = new Decision[]{new Decision(900, Ai.InitActorFindPlayer), new Decision(921, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorWanderAround)};
    private static final Decision[] SerpCloseRange = new Decision[]{new Decision(700, Ai.InitActorAttack), new Decision(1024, Ai.InitActorReposition)};
    private static final Personality SerpPersonality = new Personality(SerpBattle, SerpOffense, SerpBroadcast, SerpSurprised, SerpEvasive, SerpLostTarget, SerpCloseRange, SerpCloseRange);
    private static final ATTRIBUTE SerpAttrib = new ATTRIBUTE(new short[]{200, 220, 240, 270}, new short[]{3, 0, -2, -3}, 3, new int[]{123, 124, 128, 125, 126, 129, 130, 131, 127, 0});
    private static final int SERP_RUN_RATE = 24;
    private static final int SERP_SLASH_RATE = 9;
    private static final int SERP_SKULL_SPELL_RATE = 18;
    private static final int SERP_SPELL_RATE = 18;
    private static final int SERP_STAND_RATE = 12;
    private static final State[][] s_SerpRun = new State[][]{{new State(1300, 24, DoSerpMove), new State(1301, 24, DoSerpMove), new State(1302, 24, DoSerpMove), new State(1301, 24, DoSerpMove)}, {new State(1303, 24, DoSerpMove), new State(1304, 24, DoSerpMove), new State(1305, 24, DoSerpMove), new State(1304, 24, DoSerpMove)}, {new State(1306, 24, DoSerpMove), new State(1307, 24, DoSerpMove), new State(1308, 24, DoSerpMove), new State(1307, 24, DoSerpMove)}, {new State(1309, 24, DoSerpMove), new State(1310, 24, DoSerpMove), new State(1311, 24, DoSerpMove), new State(1310, 24, DoSerpMove)}, {new State(1312, 24, DoSerpMove), new State(1313, 24, DoSerpMove), new State(1314, 24, DoSerpMove), new State(1313, 24, DoSerpMove)}};
    private static final int SERP_DIE_RATE = 20;
    private static final State[] s_SerpDead = new State[]{new State(969, 20, Actor.DoActorDebris)};
    private static final State[][] s_SerpSlash = new State[][]{{new State(974, 9, NullSerp), new State(973, 9, NullSerp), new State(972, 18, NullSerp), new State(973, 9, NullSerp), new State(974, 9, NullSerp), new State(975, Gameutils.SF_QUICK_CALL, InitSerpSlash), new State(975, 9, NullSerp), new State(976, 9, NullSerp), new State(976, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(976, 9, DoSerpMove).setNext()}, {new State(979, 9, NullSerp), new State(978, 9, NullSerp), new State(977, 18, NullSerp), new State(978, 9, NullSerp), new State(979, 9, NullSerp), new State(980, Gameutils.SF_QUICK_CALL, InitSerpSlash), new State(980, 9, NullSerp), new State(981, 9, NullSerp), new State(981, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(981, 9, DoSerpMove).setNext()}, {new State(984, 9, NullSerp), new State(983, 9, NullSerp), new State(982, 18, NullSerp), new State(983, 9, NullSerp), new State(984, 9, NullSerp), new State(985, Gameutils.SF_QUICK_CALL, InitSerpSlash), new State(985, 9, NullSerp), new State(986, 9, NullSerp), new State(986, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(986, 9, DoSerpMove).setNext()}, {new State(989, 9, NullSerp), new State(988, 9, NullSerp), new State(987, 18, NullSerp), new State(988, 9, NullSerp), new State(989, 9, NullSerp), new State(990, Gameutils.SF_QUICK_CALL, InitSerpSlash), new State(990, 9, NullSerp), new State(991, 9, NullSerp), new State(991, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(991, 9, DoSerpMove).setNext()}, {new State(994, 9, NullSerp), new State(993, 9, NullSerp), new State(992, 18, NullSerp), new State(993, 9, NullSerp), new State(994, 9, NullSerp), new State(995, Gameutils.SF_QUICK_CALL, InitSerpSlash), new State(995, 9, NullSerp), new State(996, 9, NullSerp), new State(996, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(996, 9, DoSerpMove).setNext()}};
    private static final EnemyStateGroup sg_SerpDead = new EnemyStateGroup(new State[][]{s_SerpDead});
    private static boolean alreadydid = false;
    private static final State[][] s_SerpSkullSpell = new State[][]{{new State(999, 36, NullSerp), new State(998, 18, NullSerp), new State(997, 36, NullSerp), new State(997, Gameutils.SF_QUICK_CALL, InitSerpRing), new State(997, 18, NullSerp), new State(998, 18, NullSerp), new State(998, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(998, 18, DoSerpMove).setNext()}, {new State(1003, 36, NullSerp), new State(1002, 18, NullSerp), new State(1001, 36, NullSerp), new State(1001, Gameutils.SF_QUICK_CALL, InitSerpRing), new State(1001, 18, NullSerp), new State(1002, 18, NullSerp), new State(1002, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1002, 18, DoSerpMove).setNext()}, {new State(1007, 36, NullSerp), new State(1006, 18, NullSerp), new State(1005, 36, NullSerp), new State(1005, Gameutils.SF_QUICK_CALL, InitSerpRing), new State(1005, 18, NullSerp), new State(1006, 18, NullSerp), new State(1006, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1006, 18, DoSerpMove).setNext()}, {new State(1011, 36, NullSerp), new State(1010, 18, NullSerp), new State(1009, 36, NullSerp), new State(1009, Gameutils.SF_QUICK_CALL, InitSerpRing), new State(1009, 18, NullSerp), new State(1010, 18, NullSerp), new State(1010, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1010, 18, DoSerpMove).setNext()}, {new State(1015, 36, NullSerp), new State(1014, 18, NullSerp), new State(1013, 36, NullSerp), new State(1013, Gameutils.SF_QUICK_CALL, InitSerpRing), new State(1013, 18, NullSerp), new State(1014, 18, NullSerp), new State(1014, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1014, 18, DoSerpMove).setNext()}};
    private static final Animator DoDeathSpecial = new Animator(Serp::DoDeathSpecial);
    private static final State[] s_SerpDie = new State[]{new State(960, 20, NullSerp), new State(961, 20, NullSerp), new State(962, 20, NullSerp), new State(963, 20, NullSerp), new State(964, 20, NullSerp), new State(965, 20, NullSerp), new State(966, 20, NullSerp), new State(967, 20, NullSerp), new State(968, 20, NullSerp), new State(968, Gameutils.SF_QUICK_CALL, DoDeathSpecial), new State(969, 20, Actor.DoActorDebris).setNext()};
    private static final State[][] s_SerpSpell = new State[][]{{new State(999, 36, NullSerp), new State(998, 18, NullSerp), new State(997, 36, NullSerp), new State(997, Gameutils.SF_QUICK_CALL, InitSerpSpell), new State(997, 18, NullSerp), new State(998, 18, NullSerp), new State(998, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(998, 18, DoSerpMove).setNext()}, {new State(1003, 36, NullSerp), new State(1002, 18, NullSerp), new State(1001, 36, NullSerp), new State(1001, Gameutils.SF_QUICK_CALL, InitSerpSpell), new State(1001, 18, NullSerp), new State(1002, 18, NullSerp), new State(1002, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1002, 18, DoSerpMove).setNext()}, {new State(1007, 36, NullSerp), new State(1006, 18, NullSerp), new State(1005, 36, NullSerp), new State(1005, Gameutils.SF_QUICK_CALL, InitSerpSpell), new State(1005, 18, NullSerp), new State(1006, 18, NullSerp), new State(1006, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1006, 18, DoSerpMove).setNext()}, {new State(1011, 36, NullSerp), new State(1010, 18, NullSerp), new State(1009, 36, NullSerp), new State(1009, Gameutils.SF_QUICK_CALL, InitSerpSpell), new State(1009, 18, NullSerp), new State(1010, 18, NullSerp), new State(1010, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1010, 18, DoSerpMove).setNext()}, {new State(1015, 36, NullSerp), new State(1014, 18, NullSerp), new State(1013, 36, NullSerp), new State(1013, Gameutils.SF_QUICK_CALL, InitSerpSpell), new State(1013, 18, NullSerp), new State(1014, 18, NullSerp), new State(1014, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1014, 18, DoSerpMove).setNext()}};
    private static final EnemyStateGroup sg_SerpDie = new EnemyStateGroup(new State[][]{s_SerpDie});
    private static final State[][] s_SerpRapidSpell = new State[][]{{new State(999, 36, NullSerp), new State(998, 18, NullSerp), new State(997, 36, NullSerp), new State(997, Gameutils.SF_QUICK_CALL, InitSerpSpell), new State(997, 36, NullSerp), new State(997, Gameutils.SF_QUICK_CALL, InitSerpSpell), new State(997, 18, NullSerp), new State(998, 18, NullSerp), new State(998, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(998, 18, DoSerpMove).setNext()}, {new State(1003, 36, NullSerp), new State(1002, 18, NullSerp), new State(1001, 36, NullSerp), new State(1001, Gameutils.SF_QUICK_CALL, InitSerpSpell), new State(1001, 36, NullSerp), new State(1001, Gameutils.SF_QUICK_CALL, InitSerpSpell), new State(1001, 18, NullSerp), new State(1002, 18, NullSerp), new State(1002, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1002, 18, DoSerpMove).setNext()}, {new State(1007, 36, NullSerp), new State(1006, 18, NullSerp), new State(1005, 36, NullSerp), new State(1005, Gameutils.SF_QUICK_CALL, InitSerpSpell), new State(1005, 36, NullSerp), new State(1005, Gameutils.SF_QUICK_CALL, InitSerpSpell), new State(1005, 18, NullSerp), new State(1006, 18, NullSerp), new State(1006, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1006, 18, DoSerpMove).setNext()}, {new State(1011, 36, NullSerp), new State(1010, 18, NullSerp), new State(1009, 36, NullSerp), new State(1009, Gameutils.SF_QUICK_CALL, InitSerpSpell), new State(1009, 36, NullSerp), new State(1009, Gameutils.SF_QUICK_CALL, InitSerpSpell), new State(1009, 18, NullSerp), new State(1010, 18, NullSerp), new State(1010, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1010, 18, DoSerpMove).setNext()}, {new State(1015, 36, NullSerp), new State(1014, 18, NullSerp), new State(1013, 36, NullSerp), new State(1013, Gameutils.SF_QUICK_CALL, InitSerpSpell), new State(1013, 36, NullSerp), new State(1013, Gameutils.SF_QUICK_CALL, InitSerpSpell), new State(1013, 18, NullSerp), new State(1014, 18, NullSerp), new State(1014, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1014, 18, DoSerpMove).setNext()}};
    private static final State[][] s_SerpStand = new State[][]{{new State(1300, 12, DoSerpMove).setNext()}, {new State(1303, 12, DoSerpMove).setNext()}, {new State(1306, 12, DoSerpMove).setNext()}, {new State(1309, 12, DoSerpMove).setNext()}, {new State(1312, 12, DoSerpMove).setNext()}};
    private static final EnemyStateGroup sg_SerpStand = new EnemyStateGroup(s_SerpStand[0], s_SerpStand[1], s_SerpStand[2], s_SerpStand[3], s_SerpStand[4]);
    private static final EnemyStateGroup sg_SerpRun = new EnemyStateGroup(s_SerpRun[0], s_SerpRun[1], s_SerpRun[2], s_SerpRun[3], s_SerpRun[4]);
    private static final EnemyStateGroup sg_SerpSlash = new EnemyStateGroup(s_SerpSlash[0], s_SerpSlash[1], s_SerpSlash[2], s_SerpSlash[3], s_SerpSlash[4]);
    private static final EnemyStateGroup sg_SerpSpell = new EnemyStateGroup(s_SerpSpell[0], s_SerpSpell[1], s_SerpSpell[2], s_SerpSpell[3], s_SerpSpell[4]);
    private static final EnemyStateGroup sg_SerpRapidSpell = new EnemyStateGroup(s_SerpRapidSpell[0], s_SerpRapidSpell[1], s_SerpRapidSpell[2], s_SerpRapidSpell[3], s_SerpRapidSpell[4]);
    private static final EnemyStateGroup sg_SerpSkullSpell = new EnemyStateGroup(s_SerpSkullSpell[0], s_SerpSkullSpell[1], s_SerpSkullSpell[2], s_SerpSkullSpell[3], s_SerpSkullSpell[4]);
    private static final Actor_Action_Set SerpActionSet = new Actor_Action_Set(sg_SerpStand, sg_SerpRun, null, null, null, null, null, null, null, null, null, null, sg_SerpDie, null, sg_SerpDead, null, null, new StateGroup[]{sg_SerpSlash}, new short[]{1024}, new StateGroup[]{sg_SerpSlash, sg_SerpSpell, sg_SerpRapidSpell, sg_SerpRapidSpell}, new short[]{256, 724, 900, 1024}, null, null, null);

    public static void SetupSerp(int SpriteNum) {
        USER u;
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        if (MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.getUser(SpriteNum);
            if (u == null) {
                return;
            }
        } else {
            u = Sprites.SpawnUser(SpriteNum, 1300, s_SerpRun[0][0]);
            Gameutils.setUser(SpriteNum, u);
            u.Health = 3800;
        }
        if (Game.Skill == 0) {
            u.Health = 1100;
        }
        if (Game.Skill == 1) {
            u.Health = 2200;
        }
        Sprites.ChangeState(SpriteNum, s_SerpRun[0][0]);
        u.Attrib = SerpAttrib;
        Ai.DoActorSetSpeed(SpriteNum, 1);
        u.StateEnd = s_SerpDie[0];
        u.setRot(sg_SerpRun);
        Coolie.EnemyDefaults(SpriteNum, SerpActionSet, SerpPersonality);
        if (sp.getPal() == 16) {
            u.Health = 1000;
            sp.setYrepeat(74);
            sp.setXrepeat(74);
        } else {
            sp.setYrepeat(100);
            sp.setXrepeat(128);
        }
        sp.setClipdist(128);
        u.Flags |= Gameutils.SPR_XFLIP_TOGGLE | Gameutils.SPR_ELECTRO_TOLERANT;
        u.loz = sp.getZ();
        u.zclip = Gameutils.Z(80);
        u.lo_step = Gameutils.Z(40);
        u.floor_dist = u.zclip - u.lo_step;
        u.ceiling_dist = Gameutils.SPRITEp_SIZE_Z(sp) - u.zclip;
        alreadydid = false;
    }

    public static void InitSerpSpell(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        WangSprite tsp = Main.boardService.getSprite(u.tgt_sp);
        if (tsp == null) {
            return;
        }
        for (int i = 0; i < 2; ++i) {
            sp.setAng(EngineUtils.getAngle(tsp.getX() - sp.getX(), tsp.getY() - sp.getY()));
            int newsp = Sprites.SpawnSprite(4, 2099, Weapon.WeaponStateGroup.sg_SerpMeteor.getState(0), sp.getSectnum(), sp.getX(), sp.getY(), sp.getZ(), sp.getAng(), 1500);
            WangSprite np = Main.boardService.getSprite(newsp);
            USER nu = Gameutils.getUser(newsp);
            if (np == null || nu == null) {
                return;
            }
            np.setZ(Gameutils.SPRITEp_TOS(sp));
            nu.RotNum = 5;
            Sprites.NewStateGroup(newsp, Weapon.WeaponStateGroup.sg_SerpMeteor);
            nu.StateEnd = Weapon.s_MirvMeteorExp[0];
            Sprites.SetOwner(SpriteNum, newsp);
            np.setShade(-40);
            Sound.PlaySound(129, sp, 0);
            nu.spal = (byte)27;
            np.setPal(27);
            np.setXrepeat(64);
            np.setYrepeat(64);
            np.setClipdist(8);
            np.setZvel(0);
            np.setCstat(np.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
            nu.ceiling_dist = Gameutils.Z(16);
            nu.floor_dist = Gameutils.Z(16);
            nu.Dist = 200;
            int oclipdist = sp.getClipdist();
            sp.setClipdist(1);
            np.setAng(Gameutils.NORM_ANGLE(np.getAng() + Weapon.lat_ang[i]));
            Weapon.HelpMissileLateral(newsp, 4200);
            np.setAng(Gameutils.NORM_ANGLE(np.getAng() - Weapon.lat_ang[i]));
            int dist = Game.Distance(np.getX(), np.getY(), tsp.getX(), tsp.getY());
            if (dist != 0) {
                np.setZvel(np.getXvel() * (Gameutils.SPRITEp_UPPER(tsp) - np.getZ()) / dist);
            }
            np.setAng(Gameutils.NORM_ANGLE(np.getAng() + delta_ang[i]));
            nu.xchange = Gameutils.MOVEx(np.getXvel(), np.getAng());
            nu.ychange = Gameutils.MOVEy(np.getXvel(), np.getAng());
            nu.zchange = np.getZvel();
            Weapon.MissileSetPos(newsp, Weapon.DoMirvMissile, 400);
            sp.setClipdist(oclipdist);
            if (!MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER)) continue;
            nu.Flags |= Gameutils.SPR_UNDERWATER;
        }
    }

    public static void InitSerpSlash(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        Sound.PlaySound(128, sp, 0);
        block0: for (int stat = 0; stat < Weapon.StatDamageList.length; ++stat) {
            ListNode<Sprite> node = Main.boardService.getStatNode(Weapon.StatDamageList[stat]);
            while (node != null) {
                int i = node.getIndex();
                ListNode<Sprite> nexti = node.getNext();
                Sprite hp = node.get();
                if (i == SpriteNum) continue block0;
                int dist = Gameutils.DISTANCE(hp.getX(), hp.getY(), sp.getX(), sp.getY());
                if (dist < Weapon.CLOSE_RANGE_DIST_FUDGE(sp, hp, 800) && Gameutils.FACING_RANGE(hp, sp, 150)) {
                    Weapon.DoDamage(i, SpriteNum);
                }
                node = nexti;
            }
        }
    }

    public static void InitSerpRing(int SpriteNum) {
        int max_missiles;
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        u.Counter = max_missiles = 12;
        int ang_diff = 2048 / max_missiles;
        int ang_start = Gameutils.NORM_ANGLE(sp.getAng() - MyTypes.DIV2(2048));
        Sound.PlaySound(130, sp, 0);
        int ang = ang_start;
        for (int missiles = 0; missiles < max_missiles; ++missiles) {
            int newsp = Sprites.SpawnSprite(6, 822, Skull.s_SkullRing[0][0], sp.getSectnum(), sp.getX(), sp.getY(), sp.getZ(), ang, 0);
            WangSprite np = Main.boardService.getSprite(newsp);
            USER nu = Gameutils.getUser(newsp);
            if (np == null || nu == null) {
                return;
            }
            np.setXvel(500);
            Sprites.SetOwner(SpriteNum, newsp);
            np.setShade(-20);
            np.setXrepeat(64);
            np.setYrepeat(64);
            np.setYvel(24);
            np.setZvel(Gameutils.Z(3));
            np.setPal(0);
            np.setZ(Gameutils.SPRITEp_TOS(sp) - Gameutils.Z(20));
            nu.sz = Gameutils.Z(50);
            nu.slide_ang = np.getAng();
            np.setAng(Gameutils.RANDOM_P2(65536) >> 5);
            u.Flags ^= Gameutils.SPR_BOUNCE;
            nu.Flags |= MyTypes.DTEST(u.Flags, Gameutils.SPR_BOUNCE);
            nu.Dist = 600;
            nu.TargetDist = 2800;
            nu.Counter2 = 0;
            nu.StateEnd = Skull.s_SkullExplode[0];
            nu.setRot(Skull.sg_SkullRing);
            Coolie.EnemyDefaults(newsp, null, null);
            Sprites.change_sprite_stat(newsp, 6);
            np.setExtra(np.getExtra() & ~Gameutils.SPRX_PLAYER_OR_ENEMY);
            np.setClipdist(48);
            nu.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
            np.setCstat(np.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
            nu.Radius = 400;
            ang += ang_diff;
        }
    }

    private static void NullSerp(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u != null && MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        Actor.KeepActorOnFloor(SpriteNum);
    }

    private static void DoSerpMove(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (u.track >= 0) {
            Track.ActorFollowTrack(SpriteNum, 6);
        } else {
            u.ActorActionFunc.animatorInvoke(SpriteNum);
        }
        if (sp.getPal() != 16) {
            switch (u.Counter2) {
                case 0: {
                    if (u.Health == u.MaxHealth) break;
                    Sprites.NewStateGroup(SpriteNum, sg_SerpSkullSpell);
                    ++u.Counter2;
                    break;
                }
                case 1: {
                    if (u.Counter > 0) break;
                    Sprites.NewStateGroup(SpriteNum, sg_SerpSkullSpell);
                }
            }
        }
        Actor.KeepActorOnFloor(SpriteNum);
    }

    private static void DoDeathSpecial(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        Sector.DoMatchEverything(null, sp.getLotag(), 1);
        if (!Main.cfg.isMuteMusic() && !alreadydid) {
            Sound.CDAudio_Play(Sound.RedBookSong[Game.Level], true);
            alreadydid = true;
        }
        Sumo.BossSpriteNum[0] = -2;
    }

    public static void InitSerpStates() {
        for (EnemyStateGroup sg : new EnemyStateGroup[]{sg_SerpStand, sg_SerpRun, sg_SerpDie, sg_SerpDead, sg_SerpSlash, sg_SerpSpell, sg_SerpRapidSpell, sg_SerpSkullSpell}) {
            for (int rot = 0; rot < sg.getGroup().length; ++rot) {
                State.InitState(sg.getGroup()[rot]);
            }
        }
    }

    public static void SerpSaveable() {
        Saveable.SaveData(InitSerpSlash);
        Saveable.SaveData(InitSerpRing);
        Saveable.SaveData(InitSerpSpell);
        Saveable.SaveData(NullSerp);
        Saveable.SaveData(DoSerpMove);
        Saveable.SaveData(DoDeathSpecial);
        Saveable.SaveData(SerpPersonality);
        Saveable.SaveData(SerpAttrib);
        Saveable.SaveData(s_SerpRun);
        Saveable.SaveGroup(sg_SerpRun);
        Saveable.SaveData(s_SerpSlash);
        Saveable.SaveGroup(sg_SerpSlash);
        Saveable.SaveData(s_SerpSkullSpell);
        Saveable.SaveGroup(sg_SerpSkullSpell);
        Saveable.SaveData(s_SerpSpell);
        Saveable.SaveGroup(sg_SerpSpell);
        Saveable.SaveData(s_SerpRapidSpell);
        Saveable.SaveGroup(sg_SerpRapidSpell);
        Saveable.SaveData(s_SerpStand);
        Saveable.SaveGroup(sg_SerpStand);
        Saveable.SaveData(s_SerpDie);
        Saveable.SaveData(s_SerpDead);
        Saveable.SaveGroup(sg_SerpDie);
        Saveable.SaveGroup(sg_SerpDead);
        Saveable.SaveData(SerpActionSet);
    }
}

