/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Enemies.EnemyStateGroup;
import ru.m210projects.Wang.Enemies.Personality;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Actor_Action_Set;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.StateGroup;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class Skel {
    public static final int SKEL_RUN_RATE = 12;
    public static final int SKEL_SLASH_RATE = 20;
    public static final int SKEL_SPELL_RATE = 20;
    public static final int SKEL_PAIN_RATE = 38;
    public static final int SKEL_TELEPORT_RATE = 20;
    public static final int SKEL_STAND_RATE = 12;
    public static final int SKEL_DIE_RATE = 25;
    private static final Animator NullSkel = new Animator(Skel::NullSkel);
    private static final Animator InitSkelSlash = new Animator(Skel::InitSkelSlash);
    private static final Animator InitSkelSpell = new Animator(Skel::InitSkelSpell);
    private static final Animator DoSkelMove = new Animator(Skel::DoSkelMove);
    private static final Animator DoSkelPain = new Animator(Skel::DoSkelPain);
    private static final Animator DoSkelInitTeleport = new Animator(Skel::DoSkelInitTeleport);
    private static final Animator DoSkelTeleport = new Animator(Skel::DoSkelTeleport);
    private static final Animator DoSkelTermTeleport = new Animator(Skel::DoSkelTermTeleport);
    private static final Decision[] SkelBattle = new Decision[]{new Decision(600, Ai.InitActorMoveCloser), new Decision(602, Ai.InitActorAlertNoise), new Decision(700, Ai.InitActorRunAway), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] SkelOffense = new Decision[]{new Decision(700, Ai.InitActorMoveCloser), new Decision(702, Ai.InitActorAlertNoise), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] SkelBroadcast = new Decision[]{new Decision(3, Ai.InitActorAlertNoise), new Decision(6, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] SkelSurprised = new Decision[]{new Decision(701, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] SkelEvasive = new Decision[]{new Decision(22, Ai.InitActorDuck), new Decision(30, Ai.InitActorEvade), new Decision(1024, null)};
    private static final Decision[] SkelLostTarget = new Decision[]{new Decision(900, Ai.InitActorFindPlayer), new Decision(1024, Ai.InitActorWanderAround)};
    private static final Decision[] SkelCloseRange = new Decision[]{new Decision(800, Ai.InitActorAttack), new Decision(1024, Ai.InitActorReposition)};
    private static final Personality SkelPersonality = new Personality(SkelBattle, SkelOffense, SkelBroadcast, SkelSurprised, SkelEvasive, SkelLostTarget, SkelCloseRange, SkelCloseRange);
    private static final ATTRIBUTE SkelAttrib = new ATTRIBUTE(new short[]{60, 80, 100, 130}, new short[]{3, 0, -2, -3}, 3, new int[]{108, 109, 0, 110, 111, 112, 113, 114, 0, 0});
    private static final State[][] s_SkelRun = new State[][]{{new State(1367, 16, DoSkelMove), new State(1368, 12, DoSkelMove), new State(1369, 12, DoSkelMove), new State(1370, 16, DoSkelMove), new State(1371, 12, DoSkelMove), new State(1372, 12, DoSkelMove)}, {new State(1373, 16, DoSkelMove), new State(1374, 12, DoSkelMove), new State(1375, 12, DoSkelMove), new State(1376, 16, DoSkelMove), new State(1377, 12, DoSkelMove), new State(1378, 12, DoSkelMove)}, {new State(1379, 16, DoSkelMove), new State(1380, 12, DoSkelMove), new State(1381, 12, DoSkelMove), new State(1382, 16, DoSkelMove), new State(1383, 12, DoSkelMove), new State(1384, 12, DoSkelMove)}, {new State(1385, 16, DoSkelMove), new State(1386, 12, DoSkelMove), new State(1387, 12, DoSkelMove), new State(1388, 16, DoSkelMove), new State(1389, 12, DoSkelMove), new State(1390, 12, DoSkelMove)}, {new State(1391, 16, DoSkelMove), new State(1392, 12, DoSkelMove), new State(1393, 12, DoSkelMove), new State(1394, 16, DoSkelMove), new State(1395, 12, DoSkelMove), new State(1396, 12, DoSkelMove)}};
    private static final EnemyStateGroup sg_SkelRun = new EnemyStateGroup(s_SkelRun[0], s_SkelRun[1], s_SkelRun[2], s_SkelRun[3], s_SkelRun[4]);
    private static final State[][] s_SkelSlash = new State[][]{{new State(1326, 20, NullSkel), new State(1327, 20, NullSkel), new State(1328, Gameutils.SF_QUICK_CALL, InitSkelSlash), new State(1328, 40, NullSkel), new State(1327, 20, NullSkel), new State(1327, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1327, 20, DoSkelMove).setNext()}, {new State(1329, 20, NullSkel), new State(1330, 20, NullSkel), new State(1331, Gameutils.SF_QUICK_CALL, InitSkelSlash), new State(1331, 40, NullSkel), new State(1330, 20, NullSkel), new State(1330, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1330, 20, DoSkelMove).setNext()}, {new State(1332, 20, NullSkel), new State(1333, 20, NullSkel), new State(1334, Gameutils.SF_QUICK_CALL, InitSkelSlash), new State(1334, 40, NullSkel), new State(1333, 20, NullSkel), new State(1333, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1333, 20, DoSkelMove).setNext()}, {new State(1335, 20, NullSkel), new State(1336, 20, NullSkel), new State(1337, Gameutils.SF_QUICK_CALL, InitSkelSlash), new State(1337, 40, NullSkel), new State(1336, 20, NullSkel), new State(1336, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1336, 20, DoSkelMove).setNext()}, {new State(1338, 20, NullSkel), new State(1339, 20, NullSkel), new State(1340, Gameutils.SF_QUICK_CALL, InitSkelSlash), new State(1340, 40, NullSkel), new State(1339, 20, NullSkel), new State(1339, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1339, 20, DoSkelMove).setNext()}};
    private static final EnemyStateGroup sg_SkelSlash = new EnemyStateGroup(s_SkelSlash[0], s_SkelSlash[1], s_SkelSlash[2], s_SkelSlash[3], s_SkelSlash[4]);
    private static final State[][] s_SkelSpell = new State[][]{{new State(1341, 29, NullSkel), new State(1342, 20, NullSkel), new State(1343, 20, NullSkel), new State(1344, 40, NullSkel), new State(1344, Gameutils.SF_QUICK_CALL, InitSkelSpell), new State(1344, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1344, 20, DoSkelMove).setNext()}, {new State(1345, 29, NullSkel), new State(1346, 20, NullSkel), new State(1347, 20, NullSkel), new State(1348, 40, NullSkel), new State(1348, Gameutils.SF_QUICK_CALL, InitSkelSpell), new State(1348, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1348, 20, DoSkelMove).setNext()}, {new State(1349, 29, NullSkel), new State(1350, 20, NullSkel), new State(1351, 20, NullSkel), new State(1352, 40, NullSkel), new State(1352, Gameutils.SF_QUICK_CALL, InitSkelSpell), new State(1352, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1352, 20, DoSkelMove).setNext()}, {new State(1353, 29, NullSkel), new State(1354, 20, NullSkel), new State(1355, 20, NullSkel), new State(1356, 40, NullSkel), new State(1356, Gameutils.SF_QUICK_CALL, InitSkelSpell), new State(1356, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1356, 20, DoSkelMove).setNext()}, {new State(1357, 29, NullSkel), new State(1358, 20, NullSkel), new State(1359, 20, NullSkel), new State(1360, 40, NullSkel), new State(1360, Gameutils.SF_QUICK_CALL, InitSkelSpell), new State(1360, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1360, 20, DoSkelMove).setNext()}};
    private static final EnemyStateGroup sg_SkelSpell = new EnemyStateGroup(s_SkelSpell[0], s_SkelSpell[1], s_SkelSpell[2], s_SkelSpell[3], s_SkelSpell[4]);
    private static final State[][] s_SkelPain = new State[][]{{new State(1327, 38, DoSkelPain).setNext()}, {new State(1330, 38, DoSkelPain).setNext()}, {new State(1333, 38, DoSkelPain).setNext()}, {new State(1336, 38, DoSkelPain).setNext()}, {new State(1339, 38, DoSkelPain).setNext()}};
    private static final EnemyStateGroup sg_SkelPain = new EnemyStateGroup(s_SkelPain[0], s_SkelPain[1], s_SkelPain[2], s_SkelPain[3], s_SkelPain[4]);
    private static final State[] s_SkelTeleport = new State[]{new State(1361, 1, null), new State(1361, Gameutils.SF_QUICK_CALL, DoSkelInitTeleport), new State(1361, 20, null), new State(1362, 20, null), new State(1363, 20, null), new State(1364, 20, null), new State(1365, 20, null), new State(1366, 20, null), new State(1366, Gameutils.SF_QUICK_CALL, DoSkelTeleport), new State(1366, 20, null), new State(1365, 20, null), new State(1364, 20, null), new State(1363, 20, null), new State(1362, 20, null), new State(1361, 20, DoSkelTermTeleport), new State(1361, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1361, 20, DoSkelMove).setNext()};
    private static final EnemyStateGroup sg_SkelTeleport = new EnemyStateGroup(s_SkelTeleport, s_SkelTeleport, s_SkelTeleport, s_SkelTeleport, s_SkelTeleport);
    private static final State[][] s_SkelStand = new State[][]{{new State(1367, 12, DoSkelMove).setNext()}, {new State(1373, 12, DoSkelMove).setNext()}, {new State(1379, 12, DoSkelMove).setNext()}, {new State(1385, 12, DoSkelMove).setNext()}, {new State(1391, 12, DoSkelMove).setNext()}};
    private static final EnemyStateGroup sg_SkelStand = new EnemyStateGroup(s_SkelStand[0], s_SkelStand[1], s_SkelStand[2], s_SkelStand[3], s_SkelStand[4]);
    private static final State[] s_SkelDie = new State[]{new State(1320, 25, null), new State(1321, 25, null), new State(1322, 25, null), new State(1323, 25, null), new State(1324, 25, null), new State(1325, 25, Weapon.DoSuicide).setNext()};
    private static final EnemyStateGroup sg_SkelDie = new EnemyStateGroup(new State[][]{s_SkelDie});
    private static final Actor_Action_Set SkelActionSet = new Actor_Action_Set(sg_SkelStand, sg_SkelRun, null, null, null, null, null, null, null, null, null, sg_SkelPain, sg_SkelDie, null, null, null, null, new StateGroup[]{sg_SkelSlash}, new short[]{1024}, new StateGroup[]{sg_SkelSpell}, new short[]{1024}, null, sg_SkelTeleport, null);

    public static void InitSkelStates() {
        for (EnemyStateGroup sg : new EnemyStateGroup[]{sg_SkelRun, sg_SkelTeleport, sg_SkelSpell, sg_SkelDie, sg_SkelSlash, sg_SkelPain, sg_SkelStand}) {
            for (int rot = 0; rot < sg.getGroup().length; ++rot) {
                State.InitState(sg.getGroup()[rot]);
            }
        }
    }

    public static void SetupSkel(int SpriteNum) {
        USER u;
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        if (MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.getUser(SpriteNum);
            if (u == null) {
                return;
            }
        } else {
            u = Sprites.SpawnUser(SpriteNum, 1367, s_SkelRun[0][0]);
            Gameutils.setUser(SpriteNum, u);
            u.Health = 90;
        }
        Sprites.ChangeState(SpriteNum, s_SkelRun[0][0]);
        u.Attrib = SkelAttrib;
        Ai.DoActorSetSpeed(SpriteNum, 1);
        u.StateEnd = s_SkelDie[0];
        u.setRot(sg_SkelRun);
        Coolie.EnemyDefaults(SpriteNum, SkelActionSet, SkelPersonality);
        u.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
    }

    private static void DoSkelInitTeleport(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        sp.setCstat(sp.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        Sound.PlaySpriteSound(SpriteNum, Ai.Attrib_Snds.attr_extra3, 1);
    }

    private static void DoSkelTeleport(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        int x = sp.getX();
        int y = sp.getY();
        do {
            sp.setX(x);
            sp.setY(y);
            if (Gameutils.RANDOM_P2(1024) < 512) {
                sp.setX(sp.getX() + 512 + Gameutils.RANDOM_P2(1024));
            } else {
                sp.setX(sp.getX() - (512 + Gameutils.RANDOM_P2(1024)));
            }
            if (Gameutils.RANDOM_P2(1024) < 512) {
                sp.setY(sp.getY() + 512 + Gameutils.RANDOM_P2(1024));
            } else {
                sp.setY(sp.getY() - (512 + Gameutils.RANDOM_P2(1024)));
            }
            Main.engine.setspritez(SpriteNum, sp.getX(), sp.getY(), sp.getZ());
        } while (sp.getSectnum() == -1);
    }

    private static void DoSkelTermTeleport(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp != null) {
            sp.setCstat(sp.getCstat() | (Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        }
    }

    private static void NullSkel(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u != null && MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        Actor.KeepActorOnFloor(SpriteNum);
        Actor.DoActorSectorDamage(SpriteNum);
    }

    private static void DoSkelPain(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        Skel.NullSkel(SpriteNum);
        if (u != null && (u.WaitTics -= 6) <= 0) {
            Ai.InitActorDecide(SpriteNum);
        }
    }

    private static void DoSkelMove(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (u.track >= 0) {
            Track.ActorFollowTrack(SpriteNum, 6);
        } else {
            u.ActorActionFunc.animatorInvoke(SpriteNum);
        }
        Actor.KeepActorOnFloor(SpriteNum);
        Actor.DoActorSectorDamage(SpriteNum);
    }

    public static void InitSkelSlash(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        Sound.PlaySound(112, sp, 0);
        block0: for (int j : Weapon.StatDamageList) {
            ListNode<Sprite> node = Main.boardService.getStatNode(j);
            while (node != null) {
                int i = node.getIndex();
                ListNode<Sprite> nexti = node.getNext();
                Sprite hp = node.get();
                if (i == SpriteNum) continue block0;
                int dist = Gameutils.DISTANCE(hp.getX(), hp.getY(), sp.getX(), sp.getY());
                if (dist < Weapon.CLOSE_RANGE_DIST_FUDGE(sp, hp, 600) && Gameutils.FACING_RANGE(hp, sp, 150)) {
                    Weapon.DoDamage(i, SpriteNum);
                }
                node = nexti;
            }
        }
    }

    public static boolean InitSkelSpell(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return false;
        }
        WangSprite tsp = Main.boardService.getSprite(u.tgt_sp);
        if (tsp == null) {
            return false;
        }
        Sound.PlaySound(113, sp, 0);
        int nang = Gameutils.NORM_ANGLE(EngineUtils.getAngle(tsp.getX() - sp.getX(), tsp.getY() - sp.getY()));
        sp.setAng(nang);
        int nx = sp.getX();
        int ny = sp.getY();
        int nz = sp.getZ() - MyTypes.DIV2(Gameutils.SPRITEp_SIZE_Z(sp));
        int w = Sprites.SpawnSprite(4, 2026, Weapon.s_Electro[0], sp.getSectnum(), nx, ny, nz, tsp.getAng(), 850);
        WangSprite wp = Main.boardService.getSprite(w);
        USER wu = Gameutils.getUser(w);
        if (wp == null || wu == null) {
            return false;
        }
        Sprites.SetOwner(SpriteNum, w);
        wp.setXrepeat(wp.getXrepeat() - 20);
        wp.setYrepeat(wp.getYrepeat() - 20);
        wp.setShade(-40);
        wp.setZvel(0);
        wp.setAng(nang);
        wp.setClipdist(16);
        wp.setCstat(wp.getCstat() | Gameutils.CSTAT_SPRITE_YCENTER);
        int dist = Game.Distance(nx, ny, tsp.getX(), tsp.getY());
        if (dist != 0) {
            wp.setZvel(wp.getXvel() * (Gameutils.SPRITEp_UPPER(tsp) - nz) / dist);
        }
        wu.xchange = Gameutils.MOVEx(wp.getXvel(), wp.getAng());
        wu.ychange = Gameutils.MOVEy(wp.getXvel(), wp.getAng());
        wu.zchange = wp.getZvel();
        Weapon.MissileSetPos(w, Weapon.DoElectro, 400);
        return w != 0;
    }

    public static void SkelSaveable() {
        Saveable.SaveData(InitSkelSlash);
        Saveable.SaveData(InitSkelSpell);
        Saveable.SaveData(DoSkelInitTeleport);
        Saveable.SaveData(DoSkelTeleport);
        Saveable.SaveData(DoSkelTermTeleport);
        Saveable.SaveData(NullSkel);
        Saveable.SaveData(DoSkelPain);
        Saveable.SaveData(DoSkelMove);
        Saveable.SaveData(SkelPersonality);
        Saveable.SaveData(SkelAttrib);
        Saveable.SaveData(s_SkelRun);
        Saveable.SaveGroup(sg_SkelRun);
        Saveable.SaveData(s_SkelSlash);
        Saveable.SaveGroup(sg_SkelSlash);
        Saveable.SaveData(s_SkelSpell);
        Saveable.SaveGroup(sg_SkelSpell);
        Saveable.SaveData(s_SkelPain);
        Saveable.SaveGroup(sg_SkelPain);
        Saveable.SaveData(s_SkelTeleport);
        Saveable.SaveGroup(sg_SkelTeleport);
        Saveable.SaveData(s_SkelStand);
        Saveable.SaveGroup(sg_SkelStand);
        Saveable.SaveData(s_SkelDie);
        Saveable.SaveGroup(sg_SkelDie);
        Saveable.SaveData(SkelActionSet);
    }
}

