/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Enemies.EnemyStateGroup;
import ru.m210projects.Wang.Enemies.Personality;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.JWeapon;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Actor_Action_Set;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.StateGroup;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class Zombie {
    public static final Animator InitEnemyRail = new Animator(Zombie::InitEnemyRail);
    public static final Animator DoZombieMove = new Animator(Zombie::DoZombieMove);
    public static final Animator NullZombie = new Animator(Zombie::NullZombie);
    public static final Animator DoZombiePain = new Animator(Zombie::DoZombiePain);
    private static final int ZOMBIE_RATE = 32;
    private static final int ZOMBIE_TIME_LIMIT = 400;
    private static final State[][] s_ZombieRun = new State[][]{{new State(1094, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1095, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1096, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1097, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove)}, {new State(1098, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1099, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1100, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1101, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove)}, {new State(1102, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1103, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1104, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1105, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove)}, {new State(1106, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1107, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1108, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1109, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove)}, {new State(1110, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1111, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1112, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove), new State(1113, 0x20 | Gameutils.SF_TIC_ADJUST, DoZombieMove)}};
    private static final int ZOMBIE_PAIN_RATE = 15;
    private static final State[][] s_ZombiePain = new State[][]{{new State(1094, 15, DoZombiePain), new State(1095, 15, DoZombiePain)}, {new State(1098, 15, DoZombiePain), new State(1098, 15, DoZombiePain)}, {new State(1102, 15, DoZombiePain), new State(1102, 15, DoZombiePain)}, {new State(1106, 15, DoZombiePain), new State(1106, 15, DoZombiePain)}, {new State(1110, 15, DoZombiePain), new State(1110, 15, DoZombiePain)}};
    private static final ATTRIBUTE ZombieAttrib = new ATTRIBUTE(new short[]{120, 140, 170, 200}, new short[]{4, 0, 0, -2}, 3, new int[]{88, 92, 2, 90, 91, 0, 0, 0, 0, 0});
    private static final Decision[] ZombieBattle = new Decision[]{new Decision(399, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] ZombieOffense = new Decision[]{new Decision(399, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] ZombieBroadcast = new Decision[]{new Decision(6, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] ZombieSurprised = new Decision[]{new Decision(701, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] ZombieEvasive = new Decision[]{new Decision(400, Ai.InitActorDuck), new Decision(1024, null)};
    private static final Decision[] ZombieLostTarget = new Decision[]{new Decision(900, Ai.InitActorFindPlayer), new Decision(1024, Ai.InitActorWanderAround)};
    private static final Decision[] ZombieCloseRange = new Decision[]{new Decision(800, Ai.InitActorAttack), new Decision(1024, Ai.InitActorReposition)};
    private static final Personality ZombiePersonality = new Personality(ZombieBattle, ZombieOffense, ZombieBroadcast, ZombieSurprised, ZombieEvasive, ZombieLostTarget, ZombieCloseRange, ZombieCloseRange);
    private static final int ZOMBIE_STAND_RATE = 10;
    private static final State[][] s_ZombieStand = new State[][]{{new State(1094, 10, NullZombie).setNext()}, {new State(1098, 10, NullZombie).setNext()}, {new State(1102, 10, NullZombie).setNext()}, {new State(1106, 10, NullZombie).setNext()}, {new State(1110, 10, NullZombie).setNext()}};
    private static final int ZOMBIE_FALL_RATE = 25;
    private static final State[][] s_ZombieFall = new State[][]{{new State(1077, 25, DoZombieMove).setNext()}, {new State(1081, 25, DoZombieMove).setNext()}, {new State(1085, 25, DoZombieMove).setNext()}, {new State(1089, 25, DoZombieMove).setNext()}, {new State(1093, 25, DoZombieMove).setNext()}};
    private static final int ZOMBIE_RAIL_RATE = 14;
    private static final State[][] s_ZombieRail = new State[][]{{new State(1094, 28, NullZombie), new State(1094, Gameutils.SF_QUICK_CALL, InitEnemyRail), new State(1094, 14, NullZombie), new State(1094, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1094, 14, DoZombieMove).setNext()}, {new State(1098, 28, NullZombie), new State(1098, Gameutils.SF_QUICK_CALL, InitEnemyRail), new State(1098, 14, NullZombie), new State(1098, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1098, 14, DoZombieMove).setNext()}, {new State(1102, 28, NullZombie), new State(1102, Gameutils.SF_QUICK_CALL, InitEnemyRail), new State(1102, 14, NullZombie), new State(1102, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1102, 14, DoZombieMove).setNext()}, {new State(1106, 28, NullZombie), new State(1106, Gameutils.SF_QUICK_CALL, InitEnemyRail), new State(1106, 14, NullZombie), new State(1106, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1106, 14, DoZombieMove).setNext()}, {new State(1110, 28, NullZombie), new State(1110, Gameutils.SF_QUICK_CALL, InitEnemyRail), new State(1110, 14, NullZombie), new State(1110, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1110, 14, DoZombieMove).setNext()}};
    private static final EnemyStateGroup sg_ZombieStand = new EnemyStateGroup(s_ZombieStand[0], s_ZombieStand[1], s_ZombieStand[2], s_ZombieStand[3], s_ZombieStand[4]);
    private static final EnemyStateGroup sg_ZombieRun = new EnemyStateGroup(s_ZombieRun[0], s_ZombieRun[1], s_ZombieRun[2], s_ZombieRun[3], s_ZombieRun[4]);
    private static final EnemyStateGroup sg_ZombieFall = new EnemyStateGroup(s_ZombieFall[0], s_ZombieFall[1], s_ZombieFall[2], s_ZombieFall[3], s_ZombieFall[4]);
    private static final EnemyStateGroup sg_ZombiePain = new EnemyStateGroup(s_ZombiePain[0], s_ZombiePain[1], s_ZombiePain[2], s_ZombiePain[3], s_ZombiePain[4]);
    private static final EnemyStateGroup sg_ZombieRail = new EnemyStateGroup(s_ZombieRail[0], s_ZombieRail[1], s_ZombieRail[2], s_ZombieRail[3], s_ZombieRail[4]);
    private static final Actor_Action_Set ZombieActionSet = new Actor_Action_Set(sg_ZombieStand, sg_ZombieRun, null, sg_ZombieFall, null, null, null, sg_ZombieRun, sg_ZombieRun, null, null, sg_ZombiePain, sg_ZombieRun, null, null, null, null, new StateGroup[]{sg_ZombieRail}, new short[]{1024}, new StateGroup[]{sg_ZombieRail}, new short[]{1024}, null, null, null);

    public static void SpawnZombie2(int Weapon2) {
        int sectnum;
        WangSprite sp = Main.boardService.getSprite(Weapon2);
        if (sp == null) {
            return;
        }
        Sector sectp = Main.boardService.getSector(sp.getSectnum());
        short owner = sp.getOwner();
        if (owner < 0) {
            return;
        }
        if (sectp != null && MyTypes.DTEST(sectp.getExtra(), Gameutils.SECTFX_LIQUID_MASK) != 0) {
            return;
        }
        if (Gameutils.SectorIsUnderwaterArea(sp.getSectnum())) {
            return;
        }
        if (Gameutils.FAF_ConnectArea(sp.getSectnum()) && (sectnum = Main.engine.updatesectorz(sp.getX(), sp.getY(), sp.getZ() + Gameutils.Z(10), sp.getSectnum())) >= 0 && Gameutils.SectorIsUnderwaterArea(sectnum)) {
            return;
        }
        int newsp = Sprites.SpawnSprite(2, 1095, s_ZombieRun[0][0], sp.getSectnum(), sp.getX(), sp.getY(), sp.getZ(), sp.getAng(), 0);
        WangSprite np = Main.boardService.getSprite(newsp);
        USER nu = Gameutils.getUser(newsp);
        USER ou = Gameutils.getUser(owner);
        if (ou == null || np == null || nu == null) {
            return;
        }
        nu.Counter3 = 0;
        np.setOwner(owner);
        nu.spal = ou.spal;
        np.setPal(nu.spal);
        np.setAng(Gameutils.RANDOM_P2(2048));
        Zombie.SetupZombie(newsp);
        np.setShade(-10);
        nu.Flags2 |= Gameutils.SPR2_DONT_TARGET_OWNER;
        np.setCstat(np.getCstat() | Gameutils.CSTAT_SPRITE_TRANSLUCENT);
        Ai.DoActorPickClosePlayer(newsp);
        nu.Flags |= Gameutils.SPR_ACTIVE;
        nu.Flags &= ~Gameutils.SPR_JUMPING;
        nu.Flags &= ~Gameutils.SPR_FALLING;
        Sprites.DoActorZrange(newsp);
    }

    public static void NullZombie(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        if (u.Counter3++ >= 400) {
            JWeapon.InitBloodSpray(SpriteNum, true, 105);
            JWeapon.InitBloodSpray(SpriteNum, true, 105);
            JWeapon.InitBloodSpray(SpriteNum, true, 105);
            Weapon.SetSuicide(SpriteNum);
            return;
        }
        USER tu = Gameutils.getUser(u.tgt_sp);
        if (u.tgt_sp != -1 && tu != null && MyTypes.TEST(tu.Flags, Gameutils.PF_DEAD)) {
            Ai.DoActorPickClosePlayer(SpriteNum);
        }
        if (u.WaitTics > 0) {
            u.WaitTics -= 6;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING) && !MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            Actor.KeepActorOnFloor(SpriteNum);
        }
        Actor.DoActorSectorDamage(SpriteNum);
    }

    public static void DoZombieMove(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        if (u.Counter3++ >= 400) {
            JWeapon.InitBloodSpray(SpriteNum, true, 105);
            JWeapon.InitBloodSpray(SpriteNum, true, 105);
            JWeapon.InitBloodSpray(SpriteNum, true, 105);
            Weapon.SetSuicide(SpriteNum);
            return;
        }
        USER tu = Gameutils.getUser(u.tgt_sp);
        if (u.tgt_sp != -1 && tu != null && MyTypes.TEST(tu.Flags, Gameutils.PF_DEAD)) {
            Ai.DoActorPickClosePlayer(SpriteNum);
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
                Actor.DoActorJump(SpriteNum);
            } else if (MyTypes.TEST(u.Flags, Gameutils.SPR_FALLING)) {
                Actor.DoActorFall(SpriteNum);
            }
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (u.track >= 0) {
            Track.ActorFollowTrack(SpriteNum, 6);
        } else {
            u.ActorActionFunc.animatorInvoke(SpriteNum);
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            Actor.KeepActorOnFloor(SpriteNum);
        }
        Actor.DoActorSectorDamage(SpriteNum);
    }

    public static void InitZombieStates() {
        for (EnemyStateGroup sg : new EnemyStateGroup[]{sg_ZombieStand, sg_ZombieRun, sg_ZombieFall, sg_ZombiePain, sg_ZombieRail}) {
            for (int rot = 0; rot < sg.getGroup().length; ++rot) {
                State.InitState(sg.getGroup()[rot]);
            }
        }
    }

    public static void DoZombiePain(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        NullZombie.animatorInvoke(SpriteNum);
        if (u != null && (u.WaitTics -= 6) <= 0) {
            Ai.InitActorDecide(SpriteNum);
        }
    }

    private static void SetupZombie(int SpriteNum) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        USER u = Gameutils.getUser(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        u.Health = 100;
        u.StateEnd = s_ZombiePain[0][0];
        u.setRot(sg_ZombieRun);
        sp.setXrepeat(47);
        sp.setYrepeat(33);
        u.Attrib = ZombieAttrib;
        Coolie.EnemyDefaults(SpriteNum, ZombieActionSet, ZombiePersonality);
        Sprites.ChangeState(SpriteNum, s_ZombieRun[0][0]);
        Ai.DoActorSetSpeed(SpriteNum, 1);
        u.Radius = 280;
        u.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
    }

    public static boolean InitEnemyRail(int SpriteNum) {
        WangSprite tsp;
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return false;
        }
        if (Main.gNet.MultiGameType == WangNetwork.MultiGameTypes.MULTI_GAME_COOPERATIVE && u.ID == 1095) {
            short pnum = Mmulti.connecthead;
            while (pnum != -1) {
                PlayerStr pp = Game.Player[pnum];
                if (u.tgt_sp == pp.PlayerSprite) {
                    return false;
                }
                pnum = Mmulti.connectpoint2[pnum];
            }
        }
        if ((tsp = Main.boardService.getSprite(u.tgt_sp)) == null) {
            return false;
        }
        Sound.PlaySound(269, sp, 12);
        sp.setAng(EngineUtils.getAngle(tsp.getX() - sp.getX(), tsp.getY() - sp.getY()));
        if (Gameutils.RANDOM_P2(1024) < 512) {
            sp.setAng(Gameutils.NORM_ANGLE(sp.getAng() + Gameutils.RANDOM_P2(128) - 64));
        }
        int nx = sp.getX();
        int ny = sp.getY();
        int nz = sp.getZ() - MyTypes.DIV2(Gameutils.SPRITEp_SIZE_Z(sp)) - Gameutils.Z(8);
        int w = Sprites.SpawnSprite(4, 2017, Weapon.s_Rail[0][0], sp.getSectnum(), nx, ny, nz, sp.getAng(), 1200);
        WangSprite wp = Main.boardService.getSprite(w);
        USER wu = Gameutils.getUser(w);
        if (wp == null || wu == null) {
            return false;
        }
        if (u.ID == 1095) {
            Sprites.SetOwner(sp.getOwner(), w);
        } else {
            Sprites.SetOwner(SpriteNum, w);
        }
        wp.setYrepeat(52);
        wp.setXrepeat(52);
        wp.setShade(-15);
        wp.setZvel(0);
        wu.RotNum = 5;
        Sprites.NewStateGroup(w, Weapon.WeaponStateGroup.sg_Rail);
        wu.Radius = 200;
        wu.ceiling_dist = Gameutils.Z(1);
        wu.floor_dist = Gameutils.Z(1);
        wu.Flags2 |= Gameutils.SPR2_SO_MISSILE;
        wp.setCstat(wp.getCstat() | (Gameutils.CSTAT_SPRITE_YCENTER | Gameutils.CSTAT_SPRITE_INVISIBLE));
        wp.setCstat(wp.getCstat() | (Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        wp.setClipdist(16);
        wu.xchange = Gameutils.MOVEx(wp.getXvel(), wp.getAng());
        wu.ychange = Gameutils.MOVEy(wp.getXvel(), wp.getAng());
        wu.zchange = wp.getZvel();
        if (Weapon.TestMissileSetPos(w, Weapon.DoRailStart, 600, wp.getZvel())) {
            Sprites.KillSprite(w);
            return false;
        }
        int dist = Game.Distance(wp.getX(), wp.getY(), tsp.getX(), tsp.getY());
        if (dist != 0) {
            wu.zchange = (short)(wp.getXvel() * (Gameutils.SPRITEp_UPPER(tsp) - wp.getZ()) / dist);
            wp.setZvel(wu.zchange);
        }
        return w != 0;
    }

    public static void ZombieSaveable() {
        Saveable.SaveData(InitEnemyRail);
        Saveable.SaveData(DoZombieMove);
        Saveable.SaveData(NullZombie);
        Saveable.SaveData(DoZombiePain);
        Saveable.SaveData(ZombiePersonality);
        Saveable.SaveData(ZombieAttrib);
        Saveable.SaveData(s_ZombieRun);
        Saveable.SaveGroup(sg_ZombieRun);
        Saveable.SaveData(s_ZombieStand);
        Saveable.SaveGroup(sg_ZombieStand);
        Saveable.SaveData(s_ZombiePain);
        Saveable.SaveGroup(sg_ZombiePain);
        Saveable.SaveData(s_ZombieRail);
        Saveable.SaveGroup(sg_ZombieRail);
        Saveable.SaveData(s_ZombieFall);
        Saveable.SaveGroup(sg_ZombieFall);
        Saveable.SaveData(ZombieActionSet);
    }
}

