/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Factory;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.USER;

public class DemoRecorder {
    private final ByteArrayOutputStream baos;
    private final FileOutputStream os;
    private final Path filepath;
    public int reccnt;
    public int totalreccnt;
    public int recversion;

    public DemoRecorder(FileOutputStream os, Path fn, int ver, String map) throws IOException {
        this.filepath = fn;
        Console.out.println("Start recording to " + fn);
        if (ver != 1) {
            int episode;
            StreamUtils.writeString(os, "SWDEM");
            StreamUtils.writeInt(os, ver);
            StreamUtils.writeInt(os, 0L);
            byte warp_on = 0;
            if (Main.mUserFlag == Main.UserFlag.Addon) {
                warp_on = (byte)(Game.currentGame != null ? 1 : 2);
            }
            if (Main.mUserFlag == Main.UserFlag.UserMap) {
                warp_on = (byte)2;
            }
            StreamUtils.writeByte(os, warp_on);
            if (warp_on == 1) {
                String path = Game.currentGame.getPath();
                StreamUtils.writeDataString(os, path);
            }
            StreamUtils.writeDataString(os, map);
            StreamUtils.writeByte(os, Mmulti.numplayers);
            int level = Game.Level;
            if (level < 5) {
                episode = 0;
            } else if (level < 23) {
                episode = 1;
                level -= 4;
            } else {
                episode = 2;
                level -= 22;
            }
            StreamUtils.writeByte(os, episode);
            StreamUtils.writeByte(os, level);
            for (int p = 0; p < Mmulti.numplayers; ++p) {
                int i;
                USER u = Gameutils.getUser(Game.Player[p].PlayerSprite);
                StreamUtils.writeInt(os, Game.Player[p].Flags);
                StreamUtils.writeInt(os, Game.Player[p].Armor);
                StreamUtils.writeInt(os, u != null ? (long)u.Health : 100L);
                StreamUtils.writeInt(os, Game.Player[p].MaxHealth);
                StreamUtils.writeInt(os, Game.Player[p].WpnFlags);
                StreamUtils.writeByte(os, Game.Player[p].WpnRocketHeat);
                StreamUtils.writeByte(os, Game.Player[p].WpnRocketNuke);
                for (i = 0; i < 14; ++i) {
                    StreamUtils.writeInt(os, Game.Player[p].WpnAmmo[i]);
                }
                for (i = 0; i < 7; ++i) {
                    StreamUtils.writeInt(os, Game.Player[p].InventoryPercent[i]);
                    StreamUtils.writeInt(os, Game.Player[p].InventoryAmount[i]);
                }
                StreamUtils.writeInt(os, Game.Player[p].InventoryNum);
            }
            StreamUtils.writeShort(os, Game.Skill);
            StreamUtils.writeInt(os, Main.gNet.KillLimit);
            StreamUtils.writeInt(os, Main.gNet.TimeLimit);
            StreamUtils.writeInt(os, Main.gNet.TimeLimitClock);
            StreamUtils.writeShort(os, Main.gNet.MultiGameType != null ? Main.gNet.MultiGameType.ordinal() : -1);
            StreamUtils.writeByte(os, Main.gNet.TeamPlay ? 1 : 0);
            StreamUtils.writeByte(os, Main.gNet.HurtTeammate ? 1 : 0);
            StreamUtils.writeByte(os, Main.gNet.SpawnMarkers ? 1 : 0);
            StreamUtils.writeByte(os, Main.cfg.AutoAim ? 1 : 0);
            StreamUtils.writeByte(os, Main.gNet.NoRespawn ? 1 : 0);
            StreamUtils.writeByte(os, Main.gNet.Nuke ? 1 : 0);
        }
        this.recversion = ver;
        this.totalreccnt = 0;
        this.reccnt = 0;
        this.os = os;
        this.baos = new ByteArrayOutputStream(2520);
    }

    public void record() {
        short i = Mmulti.connecthead;
        while (i >= 0) {
            try {
                PlayerStr pp = Game.Player[i];
                pp.input.writeObject(this.baos, this.recversion);
                ++this.reccnt;
                ++this.totalreccnt;
                if (this.reccnt >= 2520) {
                    this.os.write(this.baos.toByteArray());
                    this.baos.reset();
                    this.reccnt = 0;
                }
            }
            catch (Exception e) {
                Console.out.println(e.toString(), OsdColor.RED);
                this.close();
            }
            i = Mmulti.connectpoint2[i];
        }
    }

    public void close() {
        if (Game.DemoRecording) {
            Game.DemoRecording = false;
            try {
                if (this.baos.size() != 0) {
                    this.os.write(this.baos.toByteArray());
                }
                StreamUtils.seek(this.os, 9);
                StreamUtils.writeInt(this.os, this.totalreccnt);
                this.os.close();
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
            Console.out.println("Stop recording");
            Directory dir = Main.game.getCache().getGameDirectory();
            dir.revalidate();
            FileEntry entry = dir.getEntry(dir.getPath().relativize(this.filepath));
            if (entry.exists()) {
                List demos = Main.gDemoScreen.demofiles.computeIfAbsent(dir, e -> new ArrayList());
                demos.add(entry);
            }
        }
    }
}

