/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Factory;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.FontHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.SliderDrawable;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.osd.OsdFunc;
import ru.m210projects.Wang.Factory.WangEngine;
import ru.m210projects.Wang.Factory.WangMenuHandler;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Factory.WangOsdFunc;
import ru.m210projects.Wang.Factory.WangPolyGDX;
import ru.m210projects.Wang.Factory.WangPolymost;
import ru.m210projects.Wang.Factory.WangSliderDrawable;
import ru.m210projects.Wang.Factory.WangSoftware;
import ru.m210projects.Wang.Fonts.GameFont;
import ru.m210projects.Wang.Fonts.MenuFont;
import ru.m210projects.Wang.Fonts.MiniFont;
import ru.m210projects.Wang.Main;

public class WangFactory
extends BuildFactory {
    private final Main app;

    public WangFactory(Main app) {
        super("sw.grp");
        this.app = app;
        OsdColor.DEFAULT.setPal(4);
    }

    @Override
    public Engine engine() throws Exception {
        Main.engine = new WangEngine(this.app);
        return Main.engine;
    }

    @Override
    public Renderer renderer(Renderer.RenderType type) {
        if (type == Renderer.RenderType.Software) {
            return new WangSoftware(this.app.pCfg);
        }
        if (type == Renderer.RenderType.PolyGDX) {
            return new WangPolyGDX(this.app.pCfg);
        }
        return new WangPolymost(this.app.pCfg);
    }

    @Override
    public DefScript getBaseDef(Engine engine) {
        return new DefScript(engine);
    }

    @Override
    public OsdFunc getOsdFunc() {
        return new WangOsdFunc();
    }

    @Override
    public MenuHandler menus() {
        return new WangMenuHandler(this.app);
    }

    @Override
    public FontHandler fonts() {
        return new FontHandler(3){

            @Override
            protected Font init(int i) {
                if (i == 0) {
                    return new MiniFont(((WangFactory)WangFactory.this).app.pEngine);
                }
                if (i == 1) {
                    return new GameFont(((WangFactory)WangFactory.this).app.pEngine);
                }
                return new MenuFont(((WangFactory)WangFactory.this).app.pEngine);
            }
        };
    }

    @Override
    public BuildNet net() {
        Main.gNet = this.app.net = new WangNetwork(this.app);
        return this.app.net;
    }

    @Override
    public SliderDrawable slider() {
        return new WangSliderDrawable();
    }

    @Override
    public void drawInitScreen() {
        Renderer renderer = Main.game.getRenderer();
        renderer.clearview(117);
        int xdim = renderer.getWidth();
        int ydim = renderer.getHeight();
        renderer.rotatesprite(xdim << 15, ydim << 15, Pragmas.divscale(ydim, 240L, 16), 0, 2324, 0, 0, 8, 0, 0, xdim - 1, ydim - 1);
    }
}

