/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Factory;

import ru.m210projects.Build.Pattern.Tools.Interpolation;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;

public abstract class WangInterpolation
extends Interpolation {
    public abstract int getSkipValue();

    public abstract int getSkipMax();

    @Override
    public void clearinterpolations() {
        if (this.getSkipValue() != this.getSkipMax() - 1) {
            return;
        }
        super.clearinterpolations();
    }

    @Override
    public void dospriteinterp(Sprite tsp, int smoothratio) {
        smoothratio += this.getSkipValue() << 16;
        super.dospriteinterp(tsp, smoothratio /= this.getSkipMax());
    }

    @Override
    public void dointerpolations(float smoothratio) {
        smoothratio += (float)(this.getSkipValue() << 16);
        smoothratio /= (float)this.getSkipMax();
        block8: for (int i = 0; i < this.InterpolationCount; ++i) {
            Interpolation.IData gInt = this.gInterpolationData[i];
            Object obj = gInt.ptr;
            int value = (int)((float)gInt.oldpos + (float)(this.getValue(gInt) - gInt.oldpos) * smoothratio / 65536.0f);
            switch (gInt.type) {
                case WallX: {
                    ((Wall)obj).setX(value);
                    continue block8;
                }
                case WallY: {
                    ((Wall)obj).setY(value);
                    continue block8;
                }
                case FloorZ: {
                    ((Sector)obj).setFloorz(value);
                    continue block8;
                }
                case CeilZ: {
                    ((Sector)obj).setCeilingz(value);
                    continue block8;
                }
                case FloorH: {
                    ((Sector)obj).setFloorheinum(value);
                    continue block8;
                }
                case CeilH: {
                    ((Sector)obj).setCeilingheinum(value);
                }
            }
        }
    }

    public void saveinterpolations() {
        for (int i = 0; i < this.InterpolationCount; ++i) {
            Interpolation.IData gInt = this.gInterpolationData[i];
            gInt.bakpos = this.getValue(gInt);
        }
    }
}

