/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Factory;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenuList;
import ru.m210projects.Build.Pattern.MenuItems.MenuFileBrowser;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuJoyList;
import ru.m210projects.Build.Pattern.MenuItems.MenuKeyboardList;
import ru.m210projects.Build.Pattern.MenuItems.MenuList;
import ru.m210projects.Build.Pattern.MenuItems.MenuResolutionList;
import ru.m210projects.Build.Pattern.MenuItems.MenuSlotList;
import ru.m210projects.Build.Pattern.MenuItems.MenuVariants;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Menus.MenuCorruptGame;
import ru.m210projects.Wang.Menus.MenuDifficulty;
import ru.m210projects.Wang.Menus.MenuGame;
import ru.m210projects.Wang.Menus.MenuInterface;
import ru.m210projects.Wang.Menus.MenuLastLoad;
import ru.m210projects.Wang.Menus.MenuLoad;
import ru.m210projects.Wang.Menus.MenuMain;
import ru.m210projects.Wang.Menus.MenuNewAddon;
import ru.m210projects.Wang.Menus.MenuNewGame;
import ru.m210projects.Wang.Menus.MenuOptions;
import ru.m210projects.Wang.Menus.MenuQuit;
import ru.m210projects.Wang.Menus.MenuSave;
import ru.m210projects.Wang.Menus.MenuSound;
import ru.m210projects.Wang.Menus.Network.MenuMultiplayer;
import ru.m210projects.Wang.Menus.Network.MenuNetwork;
import ru.m210projects.Wang.Screens.MenuScreen;
import ru.m210projects.Wang.Sound;

public class WangMenuHandler
extends MenuHandler {
    public static final int MAIN = 0;
    public static final int GAME = 1;
    public static final int NEWGAME = 2;
    public static final int SOUNDSET = 3;
    public static final int DIFFICULTY = 4;
    public static final int OPTIONS = 5;
    public static final int HELP = 6;
    public static final int LOADGAME = 7;
    public static final int SAVEGAME = 8;
    public static final int QUIT = 9;
    public static final int QUITTITLE = 10;
    public static final int NETWORKGAME = 11;
    public static final int MULTIPLAYER = 12;
    public static final int COLORCORR = 13;
    public static final int NEWADDON = 14;
    public static final int USERCONTENT = 15;
    public static final int LASTSAVE = 16;
    public static final int CORRUPTLOAD = 17;
    public static final int pic_yinyang = 2870;
    private final Engine engine;
    private final BuildGame app;

    public WangMenuHandler(Main app) {
        super(app);
        app.menu = this;
        app.pMenu = app.menu;
        this.mMenus = new BuildMenu[19];
        this.engine = app.pEngine;
        this.app = app;
        this.mMenus[4] = new MenuDifficulty(app);
        this.mMenus[2] = new MenuNewGame(app);
        this.mMenus[7] = new MenuLoad(app);
        this.mMenus[8] = new MenuSave(app);
        this.mMenus[9] = new MenuQuit(app, false);
        this.mMenus[10] = new MenuQuit(app, true);
        this.mMenus[3] = new MenuSound(app);
        this.mMenus[5] = new MenuOptions(app);
        this.mMenus[14] = new MenuNewAddon(app);
        this.mMenus[11] = new MenuNetwork(app);
        this.mMenus[12] = new MenuMultiplayer(app);
        this.mMenus[16] = new MenuLastLoad(app);
        this.mMenus[17] = new MenuCorruptGame(app);
        this.mMenus[0] = new MenuMain(app);
        this.mMenus[1] = new MenuGame(app);
    }

    @Override
    public void mDrawMenu() {
        if (!(this.app.getScreen() instanceof MenuScreen || this.app.pMenu.getCurrentMenu() instanceof BuildMenuList || this.app.pMenu.getCurrentMenu() instanceof MenuInterface)) {
            Renderer renderer = this.game.getRenderer();
            int tile = 2324;
            ArtEntry pic = renderer.getTile(tile);
            int xdim = renderer.getWidth();
            int ydim = renderer.getHeight();
            float kt = (float)xdim / (float)ydim;
            float kv = (float)pic.getWidth() / (float)pic.getHeight();
            float scale = kv >= kt ? (float)(ydim + 1) / (float)pic.getHeight() : (float)(xdim + 1) / (float)pic.getWidth();
            renderer.rotatesprite(0, 0, (int)(scale * 65536.0f), 0, tile, 127, 4, 25);
        }
        super.mDrawMenu();
    }

    @Override
    public int getShade(MenuItem item) {
        if (item != null) {
            if (!item.isEnabled()) {
                return 16;
            }
            if (item.font.equals(this.app.getFont(0))) {
                int shade = 8;
                if (item.isFocused()) {
                    shade = 8 + Pragmas.mulscale(16L, EngineUtils.sin(32 * this.engine.getTotalClock() & 0x7FF), 16);
                }
                return shade;
            }
        }
        return 0;
    }

    @Override
    public int getPal(Font font, MenuItem item) {
        if (item != null && item.font.equals(this.app.getFont(0)) && item.isFocused()) {
            return 24;
        }
        return 16;
    }

    @Override
    public void mPostDraw(MenuItem item) {
        Renderer renderer = this.game.getRenderer();
        if (item.isFocused()) {
            if (item instanceof MenuList) {
                if (item instanceof MenuJoyList) {
                    MenuList list = (MenuList)item;
                    int px = list.x;
                    int focus = list.l_nFocus;
                    if (focus == -1 || focus < list.l_nMin || focus >= list.l_nMin + list.rowCount) {
                        return;
                    }
                    int py = list.y + (focus - list.l_nMin) * list.mFontOffset();
                    renderer.rotatesprite(px - 6 << 16, py + 3 << 16, 20000, 0, 2440 + (this.engine.getTotalClock() >> 3) % 7, 0, 0, Gameutils.ROTATE_SPRITE_SCREEN_CLIP);
                } else if (item instanceof MenuKeyboardList) {
                    MenuList list = (MenuList)item;
                    int px = list.x;
                    int focus = list.l_nFocus;
                    if (focus == -1 || focus < list.l_nMin || focus >= list.l_nMin + list.rowCount) {
                        return;
                    }
                    int py = list.y + (focus - list.l_nMin) * list.mFontOffset();
                    renderer.rotatesprite(px - 6 << 16, py + 3 << 16, 20000, 0, 2440 + (this.engine.getTotalClock() >> 3) % 7, 0, 0, Gameutils.ROTATE_SPRITE_SCREEN_CLIP);
                } else if (item instanceof MenuSlotList) {
                    MenuSlotList list = (MenuSlotList)item;
                    if (!list.deleteQuestion && !list.isTyping()) {
                        int px = list.x;
                        int focus = list.l_nFocus;
                        if (focus == -1 || focus < list.l_nMin || focus >= list.l_nMin + list.rowCount) {
                            return;
                        }
                        int py = list.y + (focus - list.l_nMin) * list.mFontOffset();
                        renderer.rotatesprite(px + 125 << 16, py + 2 << 16, 20000, 0, 2440 + (this.engine.getTotalClock() >> 3) % 7, 0, 0, Gameutils.ROTATE_SPRITE_SCREEN_CLIP);
                    }
                } else if (item instanceof MenuResolutionList) {
                    MenuList list = (MenuList)item;
                    int px = list.x;
                    int focus = list.l_nFocus;
                    if (focus == -1 || focus < list.l_nMin || focus >= list.l_nMin + list.rowCount) {
                        return;
                    }
                    int py = list.y + (focus - list.l_nMin) * list.mFontOffset();
                    renderer.rotatesprite(px << 16, py + 3 << 16, 20000, 0, 2440 + (this.engine.getTotalClock() >> 3) % 7, 0, 0, Gameutils.ROTATE_SPRITE_SCREEN_CLIP);
                } else {
                    MenuList list = (MenuList)item;
                    ArtEntry pic = this.engine.getTile(2870);
                    int scale = 32768;
                    int px = list.x;
                    int focus = list.l_nFocus;
                    if (focus == -1 || focus < list.l_nMin || focus >= list.l_nMin + list.rowCount) {
                        return;
                    }
                    int py = list.y + (focus - list.l_nMin) * list.mFontOffset();
                    int xoff = 0;
                    int yoff = 0;
                    if (item.font.equals(this.app.getFont(1))) {
                        xoff = -(pic.getWidth() / 2) + 10;
                        yoff = 3;
                    } else if (item.font.equals(this.app.getFont(2))) {
                        xoff = -(pic.getWidth() / 2) + 10;
                        yoff = 8;
                    }
                    renderer.rotatesprite(px + xoff << 16, py + yoff << 16, scale, 0, 2870, 0, 0, 10);
                }
            } else if (item instanceof MenuFileBrowser) {
                MenuFileBrowser list = (MenuFileBrowser)item;
                int px = list.x;
                int focus = list.getFocus();
                if (focus == -1 || focus < list.getMin() || focus >= list.getMin() + list.getRowCount()) {
                    return;
                }
                int py = list.y + (focus - list.getMin()) * list.mFontOffset() + 23;
                int column = list.getColumn();
                String value = list.getText(column, focus);
                int textWidth = list.font.getWidth(value, 1.0f);
                px = column == 1 ? (px += list.width - textWidth - 17) : (px += textWidth + 17);
                renderer.rotatesprite(px << 16, py + 3 << 16, 20000, 0, 2440 + (this.engine.getTotalClock() >> 3) % 7, 0, 0, Gameutils.ROTATE_SPRITE_SCREEN_CLIP);
            } else if (!(item instanceof MenuVariants)) {
                int scale = 32768;
                int px = item.x;
                int py = item.y;
                int xoff = 0;
                int yoff = 0;
                ArtEntry pic = this.engine.getTile(2870);
                if (item.font.equals(this.app.getFont(1))) {
                    xoff = -(pic.getWidth() / 2) + 10;
                    yoff = 3;
                }
                if (item.font.equals(this.app.getFont(2))) {
                    xoff = -(pic.getWidth() / 2) + 10;
                    yoff = 8;
                }
                renderer.rotatesprite(px + xoff << 16, py + yoff << 16, scale, 0, 2870, 0, 0, 10);
            }
        }
    }

    @Override
    public void mDrawMouse(int x, int y) {
        if (!this.app.pCfg.isMenuMouse()) {
            return;
        }
        Renderer renderer = this.game.getRenderer();
        int zoom = Pragmas.scale(65536L, renderer.getHeight(), 200L);
        int czoom = Pragmas.mulscale(32768L, Pragmas.mulscale(zoom, this.app.pCfg.getgMouseCursorSize(), 16), 16);
        int xoffset = 0;
        int yoffset = 0;
        int ang = 0;
        renderer.rotatesprite(x + xoffset << 16, y + yoffset << 16, czoom, ang, 9217, 0, 0, 8);
    }

    @Override
    public void mDrawBackButton() {
        if (!this.app.pCfg.isMenuMouse()) {
            return;
        }
        Renderer renderer = this.game.getRenderer();
        ArtEntry pic = renderer.getTile(9216);
        int ydim = renderer.getHeight();
        int zoom = Pragmas.scale(16384L, ydim, 200L);
        if (this.mCount > 1) {
            int shade = 4 + Pragmas.mulscale(16L, EngineUtils.sin(20 * this.engine.getTotalClock() & 0x7FF), 16);
            renderer.rotatesprite(0, ydim - Pragmas.mulscale(pic.getHeight(), zoom, 16) << 16, zoom, 0, 9216, shade, 0, 24, 0, 0, Pragmas.mulscale(zoom, pic.getWidth() - 1, 16), ydim - 1);
        }
    }

    @Override
    public boolean mCheckBackButton(int mx, int my) {
        Renderer renderer = this.game.getRenderer();
        int ydim = renderer.getHeight();
        int zoom = Pragmas.scale(16384L, ydim, 200L);
        ArtEntry pic = renderer.getTile(9216);
        int size = Pragmas.mulscale(pic.getWidth(), zoom, 16);
        int bx = 0;
        int by = ydim - Pragmas.mulscale(pic.getHeight(), zoom, 16);
        if (mx >= bx && mx < bx + size) {
            return my >= by && my < by + size;
        }
        return false;
    }

    @Override
    public void mSound(MenuItem item, MenuHandler.MenuOpt opt) {
        switch (opt) {
            case Open: {
                if (this.mCount <= 1) break;
                Sound.PlaySound(1, null, 8);
                break;
            }
            case ENTER: {
                Sound.PlaySound(1, null, 8);
                break;
            }
            case UP: 
            case DW: 
            case LEFT: 
            case RIGHT: 
            case PGUP: 
            case PGDW: 
            case HOME: 
            case END: 
            case MCHANGE: {
                Sound.PlaySound(2, null, 8);
                break;
            }
            case Close: {
                if (this.mCount == 1) {
                    Sound.PlaySound(3, null, 8);
                    break;
                }
                Sound.PlaySound(1, null, 8);
                break;
            }
        }
    }
}

