/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Factory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.LittleEndian;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.JPlayer;
import ru.m210projects.Wang.JWeapon;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Menus.Network.MenuNetwork;
import ru.m210projects.Wang.Palette;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Type.GameInfo;
import ru.m210projects.Wang.Type.Input;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.Predict;
import ru.m210projects.Wang.Type.SafeLoader;
import ru.m210projects.Wang.Type.USER;

public class WangNetwork
extends BuildNet {
    public static final short[] TimeLimitTable = new short[]{0, 3, 5, 10, 15, 20, 30, 45, 60};
    public static final short nNetVersion = 500;
    private static final int TypeOffset = 8;
    public static boolean PredictionOn = true;
    public static boolean Prediction = false;
    public static int PlayerSyncTrail = -1;
    public static int PlayerSyncIndex = -1;
    public static PlayerStr PlayerSync = null;
    public static Sprite PlayerSpriteSync = null;
    public static final byte[] netbuf = new byte[256];
    public static int CommPlayers = 0;
    private static boolean SavePrediction;
    public final PlayerStr ppp = new PlayerStr();
    public final Predict[] predictFifo = new Predict[256];
    public int MoveThingsCount;
    public boolean FakeMultiplayer;
    public int FakeMultiNumPlayers;
    public boolean BotMode = false;
    public int BotSkill = -1;
    public int KillLimit;
    public int TimeLimit;
    public int TimeLimitClock;
    public MultiGameTypes MultiGameType = MultiGameTypes.MULTI_GAME_NONE;
    public boolean TeamPlay;
    public boolean HurtTeammate;
    public boolean SpawnMarkers;
    public boolean NoRespawn;
    public boolean Nuke = true;
    public final byte[] gContentFound = new byte[16];
    private final USER PredictUser = new USER();
    private final WangSprite PredictSprite = new WangSprite(){

        @Override
        public String toString() {
            String out = "Prediction sprite \r\n";
            out = out + super.toString();
            return out;
        }
    };
    private final Main app;

    public WangNetwork(Main game) {
        super(game);
        this.app = game;
        for (int i = 0; i < 256; ++i) {
            this.predictFifo[i] = new Predict();
        }
    }

    public void PauseMultiPlay() {
        short pnum = Mmulti.connecthead;
        while (pnum != -1) {
            PlayerStr pp = Game.Player[pnum];
            if (Gameutils.TEST_SYNC_KEY(pp, 9)) {
                if (Gameutils.FLAG_KEY_PRESSED(pp, 9)) {
                    Gameutils.FLAG_KEY_RELEASE(pp, 9);
                    boolean bl = this.game.gPaused = !this.game.gPaused;
                    if (this.game.gPaused) {
                        SavePrediction = PredictionOn;
                        PredictionOn = false;
                    } else {
                        PredictionOn = SavePrediction;
                    }
                }
            } else {
                Gameutils.FLAG_KEY_RESET(pp, 9);
            }
            pnum = Mmulti.connectpoint2[pnum];
        }
    }

    public void InitNetPlayerProfile() {
        if (Main.cfg.getpName() == null) {
            Main.cfg.setpName("PLAYER " + (Mmulti.myconnectindex + 1));
        }
        Game.Player[Mmulti.myconnectindex].PlayerName = Main.cfg.getpName();
        Game.Player[Mmulti.myconnectindex].TeamColor = Main.cfg.NetColor;
        Game.Player[Mmulti.myconnectindex].Flags = Main.cfg.AutoAim ? (Game.Player[Mmulti.myconnectindex].Flags |= Gameutils.PF_AUTO_AIM) : (Game.Player[Mmulti.myconnectindex].Flags &= ~Gameutils.PF_AUTO_AIM);
        int l = PacketType.Profile.Send(netbuf);
        this.WaitForSend();
        this.sendtoall(netbuf, l);
        this.GetPackets();
    }

    public void InitNetPlayerOptions() {
        PlayerStr pp = Game.Player[Mmulti.myconnectindex];
        USER pu = Gameutils.getUser(pp.PlayerSprite);
        Sprite psp = pp.getSprite();
        if (psp == null || pu == null) {
            return;
        }
        pp.TeamColor = Main.cfg.NetColor;
        psp.setPal(16 + pp.TeamColor);
        pu.spal = (byte)pp.getSprite().getPal();
        if (this.game.nNetMode != BuildGame.NetMode.Single) {
            this.InitNetPlayerProfile();
        }
    }

    public void SendMessage(int sendmessagecommand, String message) {
        PacketType.Message.setData(sendmessagecommand, message);
        int l = PacketType.Message.Send(netbuf);
        if (Mmulti.myconnectindex != Mmulti.connecthead) {
            Mmulti.sendpacket(Mmulti.connecthead, netbuf, l);
        } else {
            this.sendtoall(netbuf, l);
        }
    }

    public boolean MyCommPlayerQuit() {
        short i = Mmulti.connecthead;
        while (i != -1) {
            PlayerStr pp = Game.Player[i];
            if (Gameutils.TEST_SYNC_KEY(pp, 28) && i == Mmulti.myconnectindex) {
                Game.QuitFlag = true;
                return true;
            }
            i = Mmulti.connectpoint2[i];
        }
        return false;
    }

    @Override
    public BuildNet.NetInput newInstance() {
        return new Input();
    }

    @Override
    public int GetPackets(byte[] p, int ptr, int len, int nPlayer) {
        PacketType[] types = PacketType.values();
        byte nPacket = p[0];
        if (nPacket == 7) {
            return this.GetDisconnectPacket(p, 1, len, nPlayer, nDelete -> {
                if (Game.rec != null) {
                    Game.rec.close();
                }
                if (this.game.isCurrentScreen(Main.gGameScreen)) {
                    PlayerStr qpp = Game.Player[nDelete];
                    Sprite psp = qpp.getSprite();
                    if (psp != null) {
                        psp.setCstat(psp.getCstat() | Gameutils.CSTAT_SPRITE_INVISIBLE);
                        psp.setCstat(psp.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN | Gameutils.CSTAT_SPRITE_BLOCK_MISSILE));
                        JWeapon.InitBloodSpray(qpp.PlayerSprite, true, -2);
                        JWeapon.InitBloodSpray(qpp.PlayerSprite, false, -2);
                        psp.setAng(Gameutils.NORM_ANGLE(psp.getAng() + 1024));
                        JWeapon.InitBloodSpray(qpp.PlayerSprite, false, -1);
                        JWeapon.InitBloodSpray(qpp.PlayerSprite, true, -1);
                    }
                    qpp.input.bits |= 0x10000000;
                    JPlayer.adduserquote(qpp.getName() + " has quit the game.");
                }
                if (Game.screenpeek == nDelete) {
                    Game.screenpeek = Mmulti.connectpoint2[nDelete];
                    if (Game.screenpeek < 0) {
                        Game.screenpeek = Mmulti.connecthead;
                    }
                    Palette.ResetPalette(Game.Player[Game.screenpeek], 256);
                    Palette.DoPlayerDivePalette(Game.Player[Game.screenpeek]);
                    Palette.DoPlayerNightVisionPalette(Game.Player[Game.screenpeek]);
                }
                --CommPlayers;
            });
        }
        if (nPacket >= 8) {
            return types[nPacket - 8].Get(nPlayer, p, len);
        }
        System.err.println("Unsupported packet " + nPacket);
        return 0;
    }

    public boolean WaitForContentCheck(byte[] data, int timeout) {
        int i;
        Arrays.fill(this.gContentFound, (byte)-1);
        if (Mmulti.numplayers < 2) {
            return true;
        }
        this.WaitForSend();
        PacketType.ContentRequest.setData(new Object[]{data});
        int l = PacketType.ContentRequest.Send(this.packbuf);
        this.sendtoall(this.packbuf, l);
        this.gContentFound[Mmulti.myconnectindex] = 1;
        long starttime = System.currentTimeMillis();
        block0: do {
            long time = System.currentTimeMillis() - starttime;
            if (timeout != 0 && time > (long)timeout) {
                Console.out.println("Connection timed out!", OsdColor.YELLOW);
                return false;
            }
            this.GetPackets();
            i = Mmulti.connecthead;
            while (i >= 0 && this.gContentFound[i] != -1) {
                if (Mmulti.myconnectindex != Mmulti.connecthead) {
                    i = -1;
                    continue block0;
                }
                i = Mmulti.connectpoint2[i];
            }
        } while (i >= 0);
        i = Mmulti.connecthead;
        while (i >= 0) {
            if (this.gContentFound[i] != 1) {
                return false;
            }
            i = Mmulti.connectpoint2[i];
        }
        return true;
    }

    @Override
    public void ComputerInput(int i) {
        if (this.BotMode) {
            JPlayer.computergetinput(i, (Input)this.gFifoInput[this.gNetFifoHead[i] & 0xFF][i]);
        }
    }

    @Override
    public void UpdatePrediction(BuildNet.NetInput input) {
        if (!PredictionOn) {
            ++this.gPredictTail;
            return;
        }
        this.ppp.input.Copy(input);
        this.ppp.input.bits &= ~(MyTypes.BIT(17) | MyTypes.BIT(18) | MyTypes.BIT(26) | MyTypes.BIT(27) | MyTypes.BIT(29) | MyTypes.BIT(30) | MyTypes.BIT(7) | MyTypes.BIT(8) | Gameutils.SK_WEAPON_MASK | Gameutils.SK_INV_HOTKEY_MASK);
        this.ppp.KeyPressFlags |= MyTypes.BIT(17) | MyTypes.BIT(18) | MyTypes.BIT(26) | MyTypes.BIT(27) | MyTypes.BIT(29) | MyTypes.BIT(30) | MyTypes.BIT(7) | MyTypes.BIT(8) | Gameutils.SK_WEAPON_MASK | Gameutils.SK_INV_HOTKEY_MASK;
        List<Sprite> sprites = Main.boardService.getBoard().getSprites();
        int bakrandomseed = Main.engine.getrand();
        USER u = Gameutils.getUser(this.ppp.PlayerSprite);
        Sprite spr = this.ppp.getSprite();
        sprites.set(this.ppp.PlayerSprite, this.PredictSprite);
        Gameutils.setUser(this.ppp.PlayerSprite, this.PredictUser);
        this.PredictSprite.setCstat(0);
        this.ppp.oang = this.ppp.getAnglef();
        this.ppp.oposx = this.ppp.posx;
        this.ppp.oposy = this.ppp.posy;
        this.ppp.oposz = this.ppp.posz;
        this.ppp.ohoriz = this.ppp.getHorizf();
        this.ppp.obob_z = this.ppp.bob_z;
        Prediction = true;
        Player.DoPlayerSectorUpdatePreMove(this.ppp);
        this.ppp.DoPlayerAction.invoke(this.ppp);
        Player.DoPlayerSectorUpdatePostMove(this.ppp);
        Prediction = false;
        sprites.set(this.ppp.PlayerSprite, spr);
        Gameutils.setUser(this.ppp.PlayerSprite, u);
        Main.engine.srand(bakrandomseed);
        this.predictFifo[this.gPredictTail & 0xFF].set(this.ppp);
        ++this.gPredictTail;
    }

    public void InitPrediction(PlayerStr pp) {
        if (!PredictionOn) {
            return;
        }
        USER pu = Gameutils.getUser(pp.PlayerSprite);
        Sprite psp = pp.getSprite();
        if (psp == null || pu == null) {
            return;
        }
        this.ppp.copy(pp);
        this.PredictUser.copy(pu);
        this.PredictSprite.set(psp);
    }

    @Override
    public void CorrectPrediction() {
        if (Mmulti.numplayers < 2 || !PredictionOn) {
            return;
        }
        Predict predict = this.predictFifo[this.gNetFifoTail - 1 & 0xFF];
        PlayerStr p = Game.Player[Mmulti.myconnectindex];
        if (predict.ang == p.getAnglef() && predict.horiz == p.getHorizf() && predict.x == p.posx && predict.y == p.posy && predict.z == p.posz) {
            return;
        }
        this.InitPrediction(p);
        this.gPredictTail = this.gNetFifoTail;
        while (this.gPredictTail < this.gNetFifoHead[Mmulti.myconnectindex]) {
            this.UpdatePrediction(this.gFifoInput[this.gPredictTail & 0xFF][Mmulti.myconnectindex]);
        }
    }

    private long PlayerSync(PlayerStr pp) {
        USER pu = Gameutils.getUser(pp.PlayerSprite);
        if (pu == null) {
            return -1L;
        }
        long crc = pp.posx;
        crc += (long)pp.posy;
        crc += (long)pp.posz;
        crc += (long)pp.getAnglei();
        crc += (long)pp.getHorizi();
        crc += (long)pu.Health;
        return crc += (long)pp.bcnt;
    }

    private long MissileSync() {
        long crc = 0L;
        for (ListNode<Sprite> node = Main.boardService.getStatNode(4); node != null; node = node.getNext()) {
            Sprite spr = node.get();
            crc += (long)spr.getX();
            crc += (long)spr.getY();
            crc += (long)spr.getZ();
            crc += (long)spr.getAng();
        }
        return crc;
    }

    @Override
    public void CalcChecksum() {
        if ((Mmulti.numplayers >= 2 || Main.gNet.FakeMultiplayer) && (this.gNetFifoTail & 7) == 7) {
            Arrays.fill(this.gChecksum, 0);
            this.gChecksum[0] = Main.engine.getrand();
            int i = Mmulti.connecthead;
            while (i >= 0) {
                PlayerStr pp = Game.Player[i];
                Sprite psp = pp.getSprite();
                this.gChecksum[1] = this.gChecksum[1] ^ (int)this.PlayerSync(pp);
                if (psp != null) {
                    this.gChecksum[2] = (int)((long)this.gChecksum[2] ^ this.checksum(psp));
                }
                i = Mmulti.connectpoint2[i];
            }
            this.gChecksum[3] = this.gChecksum[3] ^ (int)this.MissileSync();
            for (i = 0; i < this.gChecksum.length; ++i) {
                LittleEndian.putInt(this.gCheckFifo[Mmulti.myconnectindex], 16 * (this.gCheckHead[Mmulti.myconnectindex] & 0xFF) + 4 * i, this.gChecksum[i]);
            }
            short s = Mmulti.myconnectindex;
            this.gCheckHead[s] = this.gCheckHead[s] + 1;
        }
    }

    @Override
    public void CheckSync() {
        if (PlayerSync != null || PlayerSpriteSync != null) {
            WangSprite psp;
            if (this.gNetFifoTail < PlayerSyncTrail) {
                return;
            }
            Console.out.println("gNetFifoTail: " + this.gNetFifoTail + ", PlayerSyncTrail: " + PlayerSyncTrail);
            if (PlayerSync != null) {
                PlayerSync.compare(Game.Player[WangNetwork.PlayerSync.pnum]);
            }
            if (PlayerSpriteSync != null && (psp = Main.boardService.getSprite(PlayerSyncIndex)) != null) {
                Main.engine.compare(PlayerSpriteSync, psp);
            }
            PlayerSyncTrail = -1;
            PlayerSyncIndex = -1;
            PlayerSync = null;
            PlayerSpriteSync = null;
        }
        super.CheckSync();
    }

    @Override
    public void NetDisconnect(int nPlayer) {
        super.NetDisconnect(nPlayer);
        this.app.Disconnect();
    }

    public void save(OutputStream os) throws IOException {
        StreamUtils.writeInt(os, this.KillLimit);
        StreamUtils.writeInt(os, this.TimeLimit);
        StreamUtils.writeInt(os, this.TimeLimitClock);
        StreamUtils.writeByte(os, this.MultiGameType != null ? this.MultiGameType.ordinal() : -1);
        StreamUtils.writeBoolean(os, this.TeamPlay);
        StreamUtils.writeBoolean(os, this.HurtTeammate);
        StreamUtils.writeBoolean(os, this.SpawnMarkers);
        StreamUtils.writeBoolean(os, this.NoRespawn);
        StreamUtils.writeBoolean(os, this.Nuke);
    }

    public void load(InputStream is) throws IOException {
        this.KillLimit = StreamUtils.readInt(is);
        this.TimeLimit = StreamUtils.readInt(is);
        this.TimeLimitClock = StreamUtils.readInt(is);
        byte i = StreamUtils.readByte(is);
        this.MultiGameType = i != -1 ? MultiGameTypes.values()[i] : null;
        this.TeamPlay = StreamUtils.readBoolean(is);
        this.HurtTeammate = StreamUtils.readBoolean(is);
        this.SpawnMarkers = StreamUtils.readBoolean(is);
        this.NoRespawn = StreamUtils.readBoolean(is);
        this.Nuke = StreamUtils.readBoolean(is);
    }

    public static enum MultiGameTypes {
        MULTI_GAME_NONE,
        MULTI_GAME_COMMBAT,
        MULTI_GAME_COMMBAT_NO_RESPAWN,
        MULTI_GAME_COOPERATIVE,
        MULTI_GAME_AI_BOTS;

    }

    public static enum PacketType {
        LevelStart{

            @Override
            public int Get(int fromPlayer, byte[] buf, int len) {
                Main.gNet.retransmit(fromPlayer, buf, len);
                try (ByteArrayInputStream is = new ByteArrayInputStream(buf, 1, len);){
                    short nCheckVersion = StreamUtils.readShort(is);
                    Game.pNetInfo.readObject(is);
                    if (nCheckVersion != 500) {
                        Main.gNet.NetDisconnect(Mmulti.myconnectindex);
                        throw new AssertException("These versions of Shadow Warrior cannot play together.");
                    }
                    if (Main.gNet.WaitForAllPlayers(0)) {
                        Main.gGameScreen.newgame(true, ((MenuNetwork)Main.game.menu.mMenus[11]).getFile(), Game.pNetInfo.nEpisode, Game.pNetInfo.nLevel, Game.pNetInfo.nDifficulty);
                    }
                }
                catch (Exception e) {
                    throw new AssertException(e.toString());
                }
                return 0;
            }

            @Override
            public int Send(byte[] buf) {
                int n;
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try {
                    StreamUtils.writeByte(os, this.ordinal() + 8);
                    StreamUtils.writeShort(os, 500);
                    Game.pNetInfo.writeObject(os);
                    System.arraycopy(os.toByteArray(), 0, buf, 0, os.size());
                    n = os.size();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        Console.out.println(e.toString(), OsdColor.RED);
                        return 0;
                    }
                }
                os.close();
                return n;
            }
        }
        ,
        Profile{

            @Override
            public int Get(int fromPlayer, byte[] buf, int len) {
                Main.gNet.retransmit(fromPlayer, buf, len);
                byte nP = buf[1];
                boolean AutoRun = buf[2] == 1;
                byte NetColor = buf[3];
                boolean AutoAim = buf[4] == 1;
                len = 0;
                int i = 5;
                while (buf[i] != 0) {
                    ++len;
                    ++i;
                }
                PlayerStr pp = Game.Player[nP];
                pp.Flags = AutoRun ? (pp.Flags |= Gameutils.PF_LOCK_RUN) : (pp.Flags &= ~Gameutils.PF_LOCK_RUN);
                pp.Flags = AutoAim ? (pp.Flags |= Gameutils.PF_AUTO_AIM) : (pp.Flags &= ~Gameutils.PF_AUTO_AIM);
                pp.PlayerName = new String(buf, 5, len);
                pp.TeamColor = NetColor;
                if (pp.PlayerSprite != -1 && Gameutils.getUser(pp.PlayerSprite) != null) {
                    USER pu = Gameutils.getUser(pp.PlayerSprite);
                    Sprite psp = pp.getSprite();
                    if (psp != null && pu != null) {
                        psp.setPal(16 + pp.TeamColor);
                        pu.spal = (byte)pp.getSprite().getPal();
                    }
                }
                return 0;
            }

            @Override
            public int Send(byte[] buf) {
                buf[0] = (byte)(this.ordinal() + 8);
                buf[1] = (byte)Mmulti.myconnectindex;
                buf[2] = Main.cfg.AutoRun ? (byte)1 : 0;
                buf[3] = Main.cfg.NetColor;
                buf[4] = Main.cfg.AutoAim ? (byte)1 : 0;
                int l = 5;
                char[] name = Strhandler.toCharArray(Main.cfg.getpName());
                for (int i = 0; i < Main.cfg.getpName().length() && name[i] != '\u0000'; ++i) {
                    buf[l++] = (byte)name[i];
                }
                buf[l++] = 0;
                return l;
            }
        }
        ,
        Message{
            private int sendmessagecommand;
            private String message;

            @Override
            public void setData(Object ... opts) {
                if (opts.length < 2) {
                    return;
                }
                this.sendmessagecommand = (Integer)opts[0];
                this.message = (String)opts[1];
            }

            @Override
            public int Get(int fromMaster, byte[] buf, int len) {
                byte fromPlayer = buf[1];
                byte nPlayer = buf[2];
                Main.gNet.retransmit(fromMaster, buf, len);
                if (nPlayer == -1 || nPlayer == Mmulti.myconnectindex) {
                    if (nPlayer != -1) {
                        JPlayer.adduserquote(Game.Player[fromPlayer].getName() + ": " + new String(buf, 3, len - 3));
                    } else {
                        JPlayer.adduserquote(new String(buf, 3, len - 3));
                    }
                    Sound.PlaySound(504, null, 8);
                }
                return 0;
            }

            @Override
            public int Send(byte[] buf) {
                ByteBuffer bb = ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN);
                bb.put((byte)(this.ordinal() + 8));
                bb.put((byte)Mmulti.myconnectindex);
                bb.put((byte)this.sendmessagecommand);
                bb.put(this.message.getBytes());
                bb.put((byte)0);
                return bb.position();
            }
        }
        ,
        RTS_Sound{
            int num = 0;

            @Override
            public void setData(Object ... opts) {
                this.num = (Integer)opts[0];
            }

            @Override
            public int Get(int fromPlayer, byte[] buf, int len) {
                Main.gNet.retransmit(fromPlayer, buf, len);
                Sound.PlaySoundRTS(buf[1]);
                return 0;
            }

            @Override
            public int Send(byte[] buf) {
                Sound.PlaySoundRTS(this.num);
                buf[0] = (byte)(this.ordinal() + 8);
                buf[1] = (byte)this.num;
                return 2;
            }
        }
        ,
        PlayerData{
            int num = 0;

            @Override
            public void setData(Object ... opts) {
                this.num = (Integer)opts[0];
            }

            @Override
            public int Get(int fromPlayer, byte[] buf, int len) {
                Main.gNet.retransmit(fromPlayer, buf, len);
                try (ByteArrayInputStream is = new ByteArrayInputStream(buf);){
                    StreamUtils.readByte(is);
                    PlayerSyncTrail = StreamUtils.readInt(is);
                    PlayerSyncIndex = StreamUtils.readInt(is);
                    PlayerSpriteSync = new WangSprite();
                    PlayerSpriteSync.readObject(is);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return 0;
            }

            @Override
            public int Send(byte[] buf) {
                int n;
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try {
                    StreamUtils.writeByte(os, this.ordinal() + 8);
                    int trail = Main.gNet.gNetFifoTail;
                    if (Mmulti.myconnectindex == Mmulti.connecthead) {
                        ++trail;
                    }
                    StreamUtils.writeInt(os, trail);
                    Sprite psp = Game.Player[this.num].getSprite();
                    StreamUtils.writeInt(os, psp != null ? (long)Game.Player[this.num].PlayerSprite : -1L);
                    if (psp != null) {
                        psp.writeObject(os);
                    }
                    System.arraycopy(os.toByteArray(), 0, buf, 0, os.size());
                    n = os.size();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        return 0;
                    }
                }
                os.close();
                return n;
            }
        }
        ,
        ContentRequest{
            private byte[] data;

            @Override
            public void setData(Object ... opts) {
                this.data = (byte[])opts[0];
            }

            @Override
            public int Get(int fromPlayer, byte[] p, int len) {
                Main.gNet.retransmit(fromPlayer, p, len);
                int found = 0;
                try (ByteArrayInputStream is = new ByteArrayInputStream(p, 5, len);){
                    boolean isAddon = StreamUtils.readBoolean(is);
                    String path = StreamUtils.readDataString(is);
                    long crc32 = StreamUtils.readLong(is);
                    FileEntry fil = Directory.DUMMY_ENTRY;
                    GameInfo ini = null;
                    if (isAddon) {
                        ini = SafeLoader.findAddon(path);
                    } else {
                        fil = Main.game.getCache().getGameDirectory().getEntry(FileUtils.getPath(path, new String[0]));
                    }
                    if (fil.exists() || ini != null) {
                        MenuNetwork network = (MenuNetwork)Main.game.menu.mMenus[11];
                        if (ini != null) {
                            long mycrc = ini.getEpisodeEntry().getFileEntry().getChecksum();
                            if (mycrc == crc32) {
                                found = 1;
                                network.setEpisode(ini);
                            } else {
                                found = 2;
                                Console.out.println("Player" + fromPlayer + " - " + Game.Player[fromPlayer].getName() + " tried to set user content. User content found, but has a different checksum!", OsdColor.RED);
                                Console.out.println("Make sure that you have the same content: " + File.separator + path, OsdColor.RED);
                                if (!Console.out.isShowing()) {
                                    Console.out.onToggle();
                                }
                            }
                        } else if (fil.exists() && fil.isExtension("map")) {
                            long mycrc = fil.getChecksum();
                            if (mycrc == crc32) {
                                found = 1;
                                network.setMap(fil);
                            } else {
                                found = 2;
                                Console.out.println("Player" + fromPlayer + " - " + Game.Player[fromPlayer].getName() + " tried to set user content. User content found, but has a different checksum!", OsdColor.RED);
                                Console.out.println("Make sure that you have the same content: " + File.separator + path, OsdColor.RED);
                                if (!Console.out.isShowing()) {
                                    Console.out.onToggle();
                                }
                            }
                        }
                    } else {
                        Console.out.println("Player" + fromPlayer + " - " + Game.Player[fromPlayer].getName() + " tried to set user content. User content not found!", OsdColor.RED);
                        Console.out.println("Make sure that you have content at the same path: " + File.separator + path, OsdColor.RED);
                        if (!Console.out.isShowing()) {
                            Console.out.onToggle();
                        }
                    }
                }
                catch (Exception e) {
                    Console.out.println(e.toString(), OsdColor.RED);
                }
                ContentAnswer.setData((byte)found);
                int l = ContentAnswer.Send(netbuf);
                Mmulti.sendpacket(fromPlayer, netbuf, l);
                return 0;
            }

            @Override
            public int Send(byte[] buf) {
                ByteBuffer bb = ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN);
                bb.put((byte)(this.ordinal() + 8));
                int len = Math.min(this.data.length, 246);
                bb.putInt(len);
                bb.put(this.data);
                return bb.position();
            }
        }
        ,
        ContentAnswer{
            private byte found;

            @Override
            public void setData(Object ... opts) {
                this.found = (Byte)opts[0];
            }

            @Override
            public int Get(int fromPlayer, byte[] p, int len) {
                Main.gNet.retransmit(fromPlayer, p, len);
                Main.gNet.gContentFound[fromPlayer] = p[1];
                return 0;
            }

            @Override
            public int Send(byte[] buf) {
                ByteBuffer bb = ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN);
                bb.put((byte)(this.ordinal() + 8));
                bb.put(this.found);
                return bb.position();
            }
        };


        public abstract int Get(int var1, byte[] var2, int var3);

        public abstract int Send(byte[] var1);

        public void setData(Object ... opts) {
        }
    }
}

