/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import java.util.Arrays;
import org.jetbrains.annotations.Nullable;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.USER;

public class Gameutils {
    public static final int SK_WEAPON_BIT0 = 0;
    public static final int SK_WEAPON_BIT1 = 1;
    public static final int SK_WEAPON_BIT2 = 2;
    public static final int SK_WEAPON_BIT3 = 3;
    public static final int SK_WEAPON_MASK = MyTypes.BIT(0) | MyTypes.BIT(1) | MyTypes.BIT(2) | MyTypes.BIT(3);
    public static final int SK_INV_HOTKEY_BIT0 = 4;
    public static final int SK_INV_HOTKEY_BIT1 = 5;
    public static final int SK_INV_HOTKEY_BIT2 = 6;
    public static final int SK_INV_HOTKEY_MASK = MyTypes.BIT(4) | MyTypes.BIT(5) | MyTypes.BIT(6);
    public static final int SK_AUTO_AIM = 7;
    public static final int SK_CENTER_VIEW = 8;
    public static final int SK_PAUSE = 9;
    public static final int SK_RUN_LOCK = 10;
    public static final int SK_LOOK_UP = 12;
    public static final int SK_LOOK_DOWN = 13;
    public static final int SK_CRAWL_LOCK = 14;
    public static final int SK_FLY = 15;
    public static final int SK_RUN = 16;
    public static final int SK_SHOOT = 17;
    public static final int SK_OPERATE = 18;
    public static final int SK_JUMP = 19;
    public static final int SK_CRAWL = 20;
    public static final int SK_SNAP_UP = 21;
    public static final int SK_SNAP_DOWN = 22;
    public static final int SK_TILT_LEFT = 23;
    public static final int SK_TILT_RIGHT = 24;
    public static final int SK_TURN_180 = 25;
    public static final int SK_INV_LEFT = 26;
    public static final int SK_INV_RIGHT = 27;
    public static final int SK_QUIT_GAME = 28;
    public static final int SK_INV_USE = 29;
    public static final int SK_HIDE_WEAPON = 30;
    public static final int SK_SPACE_BAR = 31;
    public static final int WPN_FIST = 0;
    public static final int WPN_STAR = 1;
    public static final int WPN_SHOTGUN = 2;
    public static final int WPN_UZI = 3;
    public static final int WPN_MICRO = 4;
    public static final int WPN_GRENADE = 5;
    public static final int WPN_MINE = 6;
    public static final int WPN_RAIL = 7;
    public static final int WPN_HOTHEAD = 8;
    public static final int WPN_HEART = 9;
    public static final int WPN_NAPALM = 10;
    public static final int WPN_RING = 11;
    public static final int WPN_ROCKET = 12;
    public static final int WPN_SWORD = 13;
    public static final int DMG_NAPALM = 14;
    public static final int DMG_MIRV_METEOR = 15;
    public static final int DMG_SERP_METEOR = 16;
    public static final int DMG_ELECTRO_SHARD = 17;
    public static final int DMG_SECTOR_EXP = 18;
    public static final int DMG_BOLT_EXP = 19;
    public static final int DMG_TANK_SHELL_EXP = 20;
    public static final int DMG_FIREBALL_EXP = 21;
    public static final int DMG_NAPALM_EXP = 22;
    public static final int DMG_SKULL_EXP = 23;
    public static final int DMG_BASIC_EXP = 24;
    public static final int DMG_GRENADE_EXP = 25;
    public static final int DMG_MINE_EXP = 26;
    public static final int DMG_MINE_SHRAP = 27;
    public static final int DMG_MICRO_EXP = 28;
    public static final int DMG_NUCLEAR_EXP = 29;
    public static final int DMG_RADIATION_CLOUD = 30;
    public static final int DMG_FLASHBOMB = 31;
    public static final int DMG_FIREBALL_FLAMES = 32;
    public static final int DMG_RIPPER_SLASH = 33;
    public static final int DMG_SKEL_SLASH = 34;
    public static final int DMG_COOLG_BASH = 35;
    public static final int DMG_COOLG_FIRE = 36;
    public static final int DMG_GORO_CHOP = 37;
    public static final int DMG_GORO_FIREBALL = 38;
    public static final int DMG_SERP_SLASH = 39;
    public static final int DMG_LAVA_BOULDER = 40;
    public static final int DMG_LAVA_SHARD = 41;
    public static final int DMG_HORNET_STING = 42;
    public static final int DMG_EEL_ELECTRO = 43;
    public static final int DMG_SPEAR_TRAP = 44;
    public static final int DMG_VOMIT = 45;
    public static final int DMG_BLADE = 46;
    public static final int CIRCLE_CAMERA_DIST_MIN = 12000;
    public static final int MAX_ACTIVE_RANGE = 42000;
    public static final int MIN_ACTIVE_RANGE = 20000;
    public static final int CEILING_DIST = Gameutils.Z(4);
    public static final int FLOOR_DIST = Gameutils.Z(4);
    public static final int HIT_MASK = -536870912;
    public static final int HIT_PLAX_WALL = 0x20000000;
    public static final int ROTATE_SPRITE_TRANSLUCENT = MyTypes.BIT(0);
    public static final int ROTATE_SPRITE_VIEW_CLIP = MyTypes.BIT(1);
    public static final int ROTATE_SPRITE_YFLIP = MyTypes.BIT(2);
    public static final int ROTATE_SPRITE_IGNORE_START_MOST = MyTypes.BIT(3);
    public static final int ROTATE_SPRITE_SCREEN_CLIP = MyTypes.BIT(1) | MyTypes.BIT(3);
    public static final int ROTATE_SPRITE_CORNER = MyTypes.BIT(4);
    public static final int ROTATE_SPRITE_NON_MASK = MyTypes.BIT(6);
    public static final int ROTATE_SPRITE_ALL_PAGES = MyTypes.BIT(7);
    public static final int RS_SCALE = MyTypes.BIT(16);
    public static final int CEILING_STAT_PLAX = MyTypes.BIT(0);
    public static final int CEILING_STAT_SLOPE = MyTypes.BIT(1);
    public static final int CEILING_STAT_FAF_BLOCK_HITSCAN = MyTypes.BIT(15);
    public static final int FLOOR_STAT_PLAX = MyTypes.BIT(0);
    public static final int FLOOR_STAT_SLOPE = MyTypes.BIT(1);
    public static final int FLOOR_STAT_RELATIVE = MyTypes.BIT(6);
    public static final int FLOOR_STAT_FAF_BLOCK_HITSCAN = MyTypes.BIT(15);
    public static final int CSTAT_WALL_BLOCK = MyTypes.BIT(0);
    public static final int CSTAT_WALL_MASKED = MyTypes.BIT(4);
    public static final int CSTAT_WALL_1WAY = MyTypes.BIT(5);
    public static final int CSTAT_WALL_BLOCK_HITSCAN = MyTypes.BIT(6);
    public static final int CSTAT_WALL_TRANSLUCENT = MyTypes.BIT(7);
    public static final int CSTAT_WALL_BLOCK_ACTOR = MyTypes.BIT(14);
    public static final int CSTAT_WALL_WARP_HITSCAN = MyTypes.BIT(15);
    public static final int CSTAT_SPRITE_BLOCK = MyTypes.BIT(0);
    public static final int CSTAT_SPRITE_TRANSLUCENT = MyTypes.BIT(1);
    public static final int CSTAT_SPRITE_XFLIP = MyTypes.BIT(2);
    public static final int CSTAT_SPRITE_YFLIP = MyTypes.BIT(3);
    public static final int CSTAT_SPRITE_WALL = MyTypes.BIT(4);
    public static final int CSTAT_SPRITE_FLOOR = MyTypes.BIT(5);
    public static final int CSTAT_SPRITE_SLAB = MyTypes.BIT(4) | MyTypes.BIT(5);
    public static final int CSTAT_SPRITE_ONE_SIDE = MyTypes.BIT(6);
    public static final int CSTAT_SPRITE_YCENTER = MyTypes.BIT(7);
    public static final int CSTAT_SPRITE_BLOCK_HITSCAN = MyTypes.BIT(8);
    public static final int CSTAT_SPRITE_TRANS_FLIP = MyTypes.BIT(9);
    public static final int CSTAT_SPRITE_RESTORE = MyTypes.BIT(12);
    public static final int CSTAT_SPRITE_CLOSE_FLOOR = MyTypes.BIT(13);
    public static final int CSTAT_SPRITE_BLOCK_MISSILE = MyTypes.BIT(14);
    public static final int CSTAT_SPRITE_INVISIBLE = MyTypes.BIT(15);
    public static final int CSTAT_SPRITE_BREAKABLE = CSTAT_SPRITE_BLOCK_HITSCAN | CSTAT_SPRITE_BLOCK_MISSILE;
    public static final int CLIPMASK_PLAYER = Gameutils.CS(CSTAT_SPRITE_BLOCK) | CSTAT_WALL_BLOCK;
    public static final int CLIPMASK_ACTOR = Gameutils.CS(CSTAT_SPRITE_BLOCK) | CSTAT_WALL_BLOCK | CSTAT_WALL_BLOCK_ACTOR;
    public static final int CLIPMASK_MISSILE = Gameutils.CS(CSTAT_SPRITE_BLOCK_HITSCAN | CSTAT_SPRITE_BLOCK_MISSILE) | CSTAT_WALL_BLOCK_HITSCAN;
    public static final int CLIPMASK_WARP_HITSCAN = Gameutils.CS(CSTAT_SPRITE_BLOCK_HITSCAN) | CSTAT_WALL_BLOCK_HITSCAN | CSTAT_WALL_WARP_HITSCAN;
    public static final int TILE_ANIM_TYPE = MyTypes.BIT(6) | MyTypes.BIT(7);
    public static final int SEARCH_DOWN = 1;
    public static final int SEARCH_FLOOR = 1;
    public static final int SF_TICS_MASK = 65535;
    public static final int SF_QUICK_CALL = MyTypes.BIT(16);
    public static final int SF_PLAYER_FUNC = MyTypes.BIT(17);
    public static final int SF_TIC_ADJUST = MyTypes.BIT(18);
    public static final int SF_WALL_STATE = MyTypes.BIT(19);
    public static final int MAX_PAIN = 5;
    public static final int MAX_TAUNTAI = 33;
    public static final int MAX_GETSOUNDS = 5;
    public static final int MAX_YELLSOUNDS = 3;
    public static final int MESSAGE_LINE = 142;
    public static final int MAXUSERQUOTES = 6;
    public static final int MAX_WEAPONS_KEYS = 10;
    public static final int MAX_WEAPONS_EXTRA = 4;
    public static final int MAX_WEAPONS = 14;
    public static final int WPN_NM_LAVA = -8;
    public static final int WPN_NM_SECTOR_SQUISH = -9;
    public static final int MAX_SW_PLAYERS = 8;
    public static final int MAX_LEVELS = 29;
    public static final int MOVEFIFOSIZ = 256;
    public static final int NUM_KEYS = 8;
    public static final int PLAYER_DEATH_FLIP = 0;
    public static final int PLAYER_DEATH_CRUMBLE = 1;
    public static final int PLAYER_DEATH_EXPLODE = 2;
    public static final int PLAYER_DEATH_RIPPER = 3;
    public static final int PLAYER_DEATH_SQUISH = 4;
    public static final int PLAYER_DEATH_DROWN = 5;
    public static final int PF_DEAD = MyTypes.BIT(1);
    public static final int PF_JUMPING = MyTypes.BIT(2);
    public static final int PF_FALLING = MyTypes.BIT(3);
    public static final int PF_LOCK_CRAWL = MyTypes.BIT(4);
    public static final int PF_LOCK_HORIZ = MyTypes.BIT(5);
    public static final int PF_LOOKING = MyTypes.BIT(6);
    public static final int PF_PLAYER_MOVED = MyTypes.BIT(7);
    public static final int PF_PLAYER_RIDING = MyTypes.BIT(8);
    public static final int PF_AUTO_AIM = MyTypes.BIT(9);
    public static final int PF_RECOIL = MyTypes.BIT(10);
    public static final int PF_FLYING = MyTypes.BIT(11);
    public static final int PF_WEAPON_RETRACT = MyTypes.BIT(12);
    public static final int PF_PICKED_UP_AN_UZI = MyTypes.BIT(13);
    public static final int PF_CRAWLING = MyTypes.BIT(14);
    public static final int PF_CLIMBING = MyTypes.BIT(15);
    public static final int PF_SWIMMING = MyTypes.BIT(16);
    public static final int PF_DIVING = MyTypes.BIT(17);
    public static final int PF_DIVING_IN_LAVA = MyTypes.BIT(18);
    public static final int PF_TWO_UZI = MyTypes.BIT(19);
    public static final int PF_LOCK_RUN = MyTypes.BIT(20);
    public static final int PF_TURN_180 = MyTypes.BIT(21);
    public static final int PF_DEAD_HEAD = MyTypes.BIT(22);
    public static final int PF_HEAD_CONTROL = MyTypes.BIT(23);
    public static final int PF_CLIP_CHEAT = MyTypes.BIT(24);
    public static final int PF_VIEW_FROM_OUTSIDE = MyTypes.BIT(26);
    public static final int PF_VIEW_FROM_CAMERA = MyTypes.BIT(28);
    public static final int PF_WEAPON_DOWN = MyTypes.BIT(31);
    public static final int PF2_TELEPORTED = MyTypes.BIT(0);
    public static final int HEALTH_RIPPER = 70;
    public static final int HEALTH_RIPPER2 = 200;
    public static final int HEALTH_MOMMA_RIPPER = 500;
    public static final int HEALTH_NINJA = 40;
    public static final int HEALTH_RED_NINJA = 160;
    public static final int HEALTH_COOLIE = 120;
    public static final int HEALTH_COOLIE_GHOST = 65;
    public static final int HEALTH_SKEL_PRIEST = 90;
    public static final int HEALTH_GORO = 200;
    public static final int HEALTH_HORNET = 4;
    public static final int HEALTH_SKULL = 4;
    public static final int HEALTH_SERP_GOD = 3800;
    public static final int SPRX_SKILL = MyTypes.BIT(0) | MyTypes.BIT(1) | MyTypes.BIT(2);
    public static final int SPRX_STAY_PUT_VATOR = MyTypes.BIT(5);
    public static final int SPRX_MULTI_ITEM = MyTypes.BIT(9);
    public static final int SPRX_PLAYER_OR_ENEMY = MyTypes.BIT(11);
    public static final int SPRX_BLADE = MyTypes.BIT(12);
    public static final int SPRX_BREAKABLE = MyTypes.BIT(13);
    public static final int SPRX_BURNABLE = MyTypes.BIT(14);
    public static final int SPRX_BOOL11 = MyTypes.BIT(5);
    public static final int SPRX_BOOL1 = MyTypes.BIT(6);
    public static final int SPRX_BOOL2 = MyTypes.BIT(7);
    public static final int SPRX_BOOL3 = MyTypes.BIT(8);
    public static final int SPRX_BOOL4 = MyTypes.BIT(9);
    public static final int SPRX_BOOL5 = MyTypes.BIT(10);
    public static final int SPRX_BOOL6 = MyTypes.BIT(11);
    public static final int SPRX_BOOL7 = MyTypes.BIT(4);
    public static final int SPRX_BOOL8 = MyTypes.BIT(13);
    public static final int SPRX_BOOL9 = MyTypes.BIT(14);
    public static final int SPRX_BOOL10 = MyTypes.BIT(15);
    public static final int SPR_MOVED = MyTypes.BIT(0);
    public static final int SPR_ATTACKED = MyTypes.BIT(1);
    public static final int SPR_TARGETED = MyTypes.BIT(2);
    public static final int SPR_ACTIVE = MyTypes.BIT(3);
    public static final int SPR_ELECTRO_TOLERANT = MyTypes.BIT(4);
    public static final int SPR_JUMPING = MyTypes.BIT(5);
    public static final int SPR_FALLING = MyTypes.BIT(6);
    public static final int SPR_CLIMBING = MyTypes.BIT(7);
    public static final int SPR_DEAD = MyTypes.BIT(8);
    public static final int SPR_ZDIFF_MODE = MyTypes.BIT(10);
    public static final int SPR_SPEED_UP = MyTypes.BIT(11);
    public static final int SPR_SLOW_DOWN = MyTypes.BIT(12);
    public static final int SPR_DONT_UPDATE_ANG = MyTypes.BIT(13);
    public static final int SPR_SO_ATTACHED = MyTypes.BIT(14);
    public static final int SPR_SUICIDE = MyTypes.BIT(15);
    public static final int SPR_RUN_AWAY = MyTypes.BIT(16);
    public static final int SPR_FIND_PLAYER = MyTypes.BIT(17);
    public static final int SPR_SWIMMING = MyTypes.BIT(18);
    public static final int SPR_WAIT_FOR_PLAYER = MyTypes.BIT(19);
    public static final int SPR_WAIT_FOR_TRIGGER = MyTypes.BIT(20);
    public static final int SPR_SLIDING = MyTypes.BIT(21);
    public static final int SPR_ON_SO_SECTOR = MyTypes.BIT(22);
    public static final int SPR_SHADE_DIR = MyTypes.BIT(23);
    public static final int SPR_XFLIP_TOGGLE = MyTypes.BIT(24);
    public static final int SPR_NO_SCAREDZ = MyTypes.BIT(25);
    public static final int SPR_SET_POS_DONT_KILL = MyTypes.BIT(26);
    public static final int SPR_SKIP2 = MyTypes.BIT(27);
    public static final int SPR_SKIP4 = MyTypes.BIT(28);
    public static final int SPR_BOUNCE = MyTypes.BIT(29);
    public static final int SPR_UNDERWATER = MyTypes.BIT(30);
    public static final int SPR_SHADOW = MyTypes.BIT(31);
    public static final int SPR2_BLUR_TAPER = MyTypes.BIT(13) | MyTypes.BIT(14);
    public static final int SPR2_BLUR_TAPER_FAST = 8192;
    public static final int SPR2_BLUR_TAPER_SLOW = 16384;
    public static final int SPR2_SPRITE_FAKE_BLOCK = MyTypes.BIT(15);
    public static final int SPR2_NEVER_RESPAWN = MyTypes.BIT(16);
    public static final int SPR2_ATTACH_WALL = MyTypes.BIT(17);
    public static final int SPR2_ATTACH_FLOOR = MyTypes.BIT(18);
    public static final int SPR2_ATTACH_CEILING = MyTypes.BIT(19);
    public static final int SPR2_CHILDREN = MyTypes.BIT(20);
    public static final int SPR2_SO_MISSILE = MyTypes.BIT(21);
    public static final int SPR2_DYING = MyTypes.BIT(22);
    public static final int SPR2_VIS_SHADING = MyTypes.BIT(23);
    public static final int SPR2_DONT_TARGET_OWNER = MyTypes.BIT(24);
    public static final int SECTFX_SINK = MyTypes.BIT(0);
    public static final int SECTFX_OPERATIONAL = MyTypes.BIT(1);
    public static final int SECTFX_WARP_SECTOR = MyTypes.BIT(2);
    public static final int SECTFX_CURRENT = MyTypes.BIT(3);
    public static final int SECTFX_Z_ADJUST = MyTypes.BIT(4);
    public static final int SECTFX_NO_RIDE = MyTypes.BIT(5);
    public static final int SECTFX_DYNAMIC_AREA = MyTypes.BIT(6);
    public static final int SECTFX_DIVE_AREA = MyTypes.BIT(7);
    public static final int SECTFX_UNDERWATER = MyTypes.BIT(8);
    public static final int SECTFX_UNDERWATER2 = MyTypes.BIT(9);
    public static final int SECTFX_LIQUID_MASK = MyTypes.BIT(10) | MyTypes.BIT(11);
    public static final int SECTFX_LIQUID_NONE = 0;
    public static final int SECTFX_LIQUID_LAVA = MyTypes.BIT(10);
    public static final int SECTFX_LIQUID_WATER = MyTypes.BIT(11);
    public static final int SECTFX_SECTOR_OBJECT = MyTypes.BIT(12);
    public static final int SECTFX_VATOR = MyTypes.BIT(13);
    public static final int SECTFX_TRIGGER = MyTypes.BIT(14);
    public static final int SECTFU_SO_DONT_BOB = MyTypes.BIT(0);
    public static final int SECTFU_SO_SINK_DEST = MyTypes.BIT(1);
    public static final int SECTFU_SO_DONT_SINK = MyTypes.BIT(2);
    public static final int SECTFU_DONT_COPY_PALETTE = MyTypes.BIT(3);
    public static final int SECTFU_SO_SLOPE_FLOOR_TO_POINT = MyTypes.BIT(4);
    public static final int SECTFU_SO_SLOPE_CEILING_TO_POINT = MyTypes.BIT(5);
    public static final int SECTFU_DAMAGE_ABOVE_SECTOR = MyTypes.BIT(6);
    public static final int SECTFU_VATOR_BOTH = MyTypes.BIT(7);
    public static final int SECTFU_CANT_SURFACE = MyTypes.BIT(8);
    public static final int SECTFU_SLIDE_SECTOR = MyTypes.BIT(9);
    public static final int WALLFX_LOOP_DONT_SPIN = MyTypes.BIT(0);
    public static final int WALLFX_LOOP_REVERSE_SPIN = MyTypes.BIT(1);
    public static final int WALLFX_LOOP_SPIN_2X = MyTypes.BIT(2);
    public static final int WALLFX_LOOP_SPIN_4X = MyTypes.BIT(3);
    public static final int WALLFX_LOOP_OUTER = MyTypes.BIT(4);
    public static final int WALLFX_DONT_MOVE = MyTypes.BIT(5);
    public static final int WALLFX_SECTOR_OBJECT = MyTypes.BIT(6);
    public static final int WALLFX_DONT_STICK = MyTypes.BIT(7);
    public static final int WALLFX_DONT_SCALE = MyTypes.BIT(8);
    public static final int WALLFX_LOOP_OUTER_SECONDARY = MyTypes.BIT(9);
    public static final int MAX_TARGET_SORT = 16;
    public static final int MAXANIM = 256;
    public static final int TF_TRACK_OCCUPIED = MyTypes.BIT(0);
    public static final int MAX_SO_SECTOR = 40;
    public static final int MAX_SO_POINTS = 600;
    public static final int MAX_SO_SPRITE = 60;
    public static final int MAX_CLIPBOX = 32;
    public static final int MAX_SECTOR_OBJECTS = 25;
    public static final int SOBJ_SPEED_UP = MyTypes.BIT(0);
    public static final int SOBJ_SLOW_DOWN = MyTypes.BIT(1);
    public static final int SOBJ_ZUP = MyTypes.BIT(2);
    public static final int SOBJ_ZDOWN = MyTypes.BIT(3);
    public static final int SOBJ_ZDIFF_MODE = MyTypes.BIT(4);
    public static final int SOBJ_MOVE_VERTICAL = MyTypes.BIT(5);
    public static final int SOBJ_SPRITE_OBJ = MyTypes.BIT(8);
    public static final int SOBJ_DONT_ROTATE = MyTypes.BIT(9);
    public static final int SOBJ_WAIT_FOR_EVENT = MyTypes.BIT(10);
    public static final int SOBJ_HAS_WEAPON = MyTypes.BIT(11);
    public static final int SOBJ_SYNC1 = MyTypes.BIT(12);
    public static final int SOBJ_SYNC2 = MyTypes.BIT(13);
    public static final int SOBJ_DYNAMIC = MyTypes.BIT(14);
    public static final int SOBJ_ZMID_FLOOR = MyTypes.BIT(15);
    public static final int SOBJ_OPERATIONAL = MyTypes.BIT(17);
    public static final int SOBJ_KILLABLE = MyTypes.BIT(18);
    public static final int SOBJ_DIE_HARD = MyTypes.BIT(19);
    public static final int SOBJ_UPDATE_ONCE = MyTypes.BIT(20);
    public static final int SOBJ_UPDATE = MyTypes.BIT(21);
    public static final int SOBJ_NO_QUAKE = MyTypes.BIT(22);
    public static final int SOBJ_REMOTE_ONLY = MyTypes.BIT(23);
    public static final int SOBJ_RECT_CLIP = MyTypes.BIT(24);
    public static final int SOBJ_BROKEN = MyTypes.BIT(25);
    public static final int SO_OPERATE_TRACK_START = 90;
    public static final int SO_TURRET_MGUN = 96;
    public static final int SO_TURRET = 97;
    public static final int SO_TANK = 98;
    public static final int SO_SPEED_BOAT = 99;
    public static final int FAF_PLACE_MIRROR_PIC = 341;
    public static final short FAF_MIRROR_PIC = 2356;
    public static final int ACTOR_GRAVITY = 8;
    public static final int synctics = 3;
    public static final int ACTORMOVETICS = 6;
    public static final int GETZRANGE_CLIP_ADJ = 8;
    public static final int MAXSO = Integer.MAX_VALUE;
    private static final USER[] pUser = new USER[Engine.MAXSPRITES];
    public static int dist_x;
    public static int dist_y;
    public static int dist_min;

    public static int SP_TAG1(Sprite sp) {
        return sp.getHitag();
    }

    public static int SP_TAG2(Sprite sp) {
        return sp.getLotag();
    }

    public static int SP_TAG3(Sprite sp) {
        return sp.getClipdist();
    }

    public static int SP_TAG4(Sprite sp) {
        return sp.getAng();
    }

    public static int SP_TAG5(Sprite sp) {
        return sp.getXvel();
    }

    public static int SP_TAG6(Sprite sp) {
        return sp.getYvel();
    }

    public static int SP_TAG7(Sprite sp) {
        return sp.getZvel() >> 8 & 0xFF;
    }

    public static void SET_SP_TAG7(Sprite sp, int var) {
        sp.setZvel(Gameutils.SP_TAG8(sp) | (var & 0xFF) << 8);
    }

    public static int SP_TAG8(Sprite sp) {
        return sp.getZvel() & 0xFF;
    }

    public static int SP_TAG9(Sprite sp) {
        return sp.getOwner() >> 8 & 0xFF;
    }

    public static void SET_SP_TAG9(Sprite sp, int var) {
        sp.setOwner(Gameutils.SP_TAG10(sp) | (var & 0xFF) << 8);
    }

    public static int SP_TAG10(Sprite sp) {
        return sp.getOwner() & 0xFF;
    }

    public static void SET_SP_TAG10(Sprite sp, int var) {
        sp.setOwner(var & 0xFF | Gameutils.SP_TAG9(sp) << 8);
    }

    public static int SP_TAG13(Sprite sp) {
        return sp.getXoffset() & 0xFF | (sp.getYoffset() & 0xFF) << 8;
    }

    public static void SET_SP_TAG13(Sprite sp, int value) {
        sp.setXoffset(value & 0xFF);
        sp.setYoffset(value >>> 8 & 0xFF);
    }

    public static int SP_TAG14(Sprite sp) {
        return sp.getXrepeat() & 0xFF | (sp.getYrepeat() & 0xFF) << 8;
    }

    public static void SET_SP_TAG14(Sprite sp, int value) {
        sp.setXrepeat(value & 0xFF);
        sp.setYrepeat(value >>> 8 & 0xFF);
    }

    public static int SPRITE_TAG1(int sp) {
        WangSprite s = Main.boardService.getSprite(sp);
        if (s != null) {
            return s.getHitag();
        }
        return -1;
    }

    public static int SPRITE_TAG2(int sp) {
        WangSprite s = Main.boardService.getSprite(sp);
        if (s != null) {
            return s.getLotag();
        }
        return -1;
    }

    public static int SPRITE_TAG3(int sp) {
        WangSprite s = Main.boardService.getSprite(sp);
        if (s != null) {
            return s.getClipdist();
        }
        return -1;
    }

    public static int SPRITE_TAG6(int sp) {
        WangSprite s = Main.boardService.getSprite(sp);
        if (s != null) {
            return s.getYvel();
        }
        return -1;
    }

    public static boolean SpriteInDiveArea(Sprite sp) {
        return Gameutils.SectorIsDiveArea(sp.getSectnum());
    }

    public static boolean SpriteInUnderwaterArea(Sprite sp) {
        return Gameutils.SectorIsUnderwaterArea(sp.getSectnum());
    }

    public static boolean SectorIsDiveArea(int sect) {
        Sector sec = Main.boardService.getSector(sect);
        if (sec != null) {
            return MyTypes.TEST(sec.getExtra(), SECTFX_DIVE_AREA);
        }
        return false;
    }

    public static boolean SectorIsUnderwaterArea(int sect) {
        Sector sec = Main.boardService.getSector(sect);
        if (sec != null) {
            return MyTypes.TEST(sec.getExtra(), SECTFX_UNDERWATER | SECTFX_UNDERWATER2);
        }
        return false;
    }

    public static boolean FLAG_KEY_PRESSED(PlayerStr pp, int sync_key) {
        return MyTypes.TEST(pp.KeyPressFlags, 1 << sync_key);
    }

    public static void FLAG_KEY_RELEASE(PlayerStr pp, int sync_key) {
        pp.KeyPressFlags &= ~(1 << sync_key);
    }

    public static void FLAG_KEY_RESET(PlayerStr pp, int sync_key) {
        pp.KeyPressFlags |= 1 << sync_key;
    }

    public static boolean TEST_SYNC_KEY(PlayerStr player, int sync_num) {
        return MyTypes.TEST(player.input.bits, 1 << sync_num);
    }

    public static void RESET_SYNC_KEY(PlayerStr player, int sync_num) {
        player.input.bits &= ~(1 << sync_num);
    }

    public static int NORM_ANGLE(int ang) {
        return ang & 0x7FF;
    }

    public static int STD_RANDOM_P2(int pwr_of_2) {
        return MyTypes.MOD_P2(Main.engine.rand(), pwr_of_2);
    }

    public static int STD_RANDOM_RANGE(int range) {
        return Ai.StdRandomRange(range);
    }

    public static int STD_RANDOM() {
        return Main.engine.rand();
    }

    public static int MOVEx(int vel, int ang) {
        return vel * EngineUtils.sin(Gameutils.NORM_ANGLE(ang + 512)) >> 14;
    }

    public static int MOVEy(int vel, int ang) {
        return vel * EngineUtils.sin(Gameutils.NORM_ANGLE(ang)) >> 14;
    }

    public static int DIST(int x1, int y1, int x2, int y2) {
        return EngineUtils.sqrt(Gameutils.SQ(x1 - x2) + Gameutils.SQ(y1 - y2));
    }

    public static int PIC_SIZY(int sn) {
        WangSprite sp = Main.boardService.getSprite(sn);
        if (sp != null) {
            return Main.engine.getTile(sp.getPicnum()).getHeight();
        }
        return 0;
    }

    public static int DISTANCE(int x1, int y1, int x2, int y2) {
        dist_x = Pragmas.klabs(x2 - x1);
        dist_y = Pragmas.klabs(y2 - y1);
        dist_min = Math.min(dist_x, dist_y);
        return dist_x + dist_y - MyTypes.DIV2(dist_min);
    }

    public static int SPRITE_SIZE_Z(int sp_num) {
        WangSprite sp = Main.boardService.getSprite(sp_num);
        if (sp != null) {
            return sp.getYrepeat() == 64 ? Gameutils.Z(Main.engine.getTile(sp.getPicnum()).getHeight()) : sp.getYrepeat() * Main.engine.getTile(sp.getPicnum()).getHeight() << 2;
        }
        return 0;
    }

    public static int SPRITEp_SIZE_X(Sprite sp) {
        return sp.getXrepeat() == 64 ? Main.engine.getTile(sp.getPicnum()).getWidth() : sp.getXrepeat() * Main.engine.getTile(sp.getPicnum()).getWidth() >> 6;
    }

    public static int SPRITEp_SIZE_Y(Sprite sp) {
        return sp.getYrepeat() == 64 ? Main.engine.getTile(sp.getPicnum()).getHeight() : sp.getYrepeat() * Main.engine.getTile(sp.getPicnum()).getHeight() >> 6;
    }

    public static int SPRITEp_SIZE_Z(Sprite sp) {
        return sp.getYrepeat() == 64 ? Gameutils.Z(Main.engine.getTile(sp.getPicnum()).getHeight()) : sp.getYrepeat() * Main.engine.getTile(sp.getPicnum()).getHeight() << 2;
    }

    public static int SPRITEp_SIZE_Z_2_YREPEAT(Sprite sp, int zh) {
        return zh / (4 * Main.engine.getTile(sp.getPicnum()).getHeight());
    }

    public static int TILE_XOFF(int picnum) {
        return Main.engine.getTile(picnum).getOffsetX();
    }

    public static int SPRITEp_YOFF(Sprite sp) {
        return Main.engine.getTile(sp.getPicnum()).getOffsetY();
    }

    public static int SPRITEp_SIZE_TOS(Sprite sp) {
        return MyTypes.DIV2(Gameutils.SPRITEp_SIZE_Z(sp)) + Gameutils.Z(Gameutils.SPRITEp_YOFF(sp));
    }

    public static int SPRITEp_SIZE_BOS(Sprite sp) {
        return MyTypes.DIV2(Gameutils.SPRITEp_SIZE_Z(sp)) - Gameutils.Z(Gameutils.SPRITEp_YOFF(sp));
    }

    public static int SPRITEp_TOS(Sprite sp) {
        return MyTypes.TEST(sp.getCstat(), CSTAT_SPRITE_YCENTER) ? sp.getZ() - Gameutils.SPRITEp_SIZE_TOS(sp) : sp.getZ() - Gameutils.SPRITEp_SIZE_Z(sp);
    }

    public static int SPRITEp_BOS(Sprite sp) {
        return MyTypes.TEST(sp.getCstat(), CSTAT_SPRITE_YCENTER) ? sp.getZ() + Gameutils.SPRITEp_SIZE_BOS(sp) : sp.getZ();
    }

    public static int SPRITEp_MID(Sprite sp) {
        return MyTypes.DIV2(Gameutils.SPRITEp_TOS(sp) + Gameutils.SPRITEp_BOS(sp));
    }

    public static int SPRITEp_UPPER(Sprite sp) {
        return Gameutils.SPRITEp_TOS(sp) + MyTypes.DIV4(Gameutils.SPRITEp_SIZE_Z(sp));
    }

    public static int SPRITEp_LOWER(Sprite sp) {
        return Gameutils.SPRITEp_BOS(sp) - MyTypes.DIV4(Gameutils.SPRITEp_SIZE_Z(sp));
    }

    public static int Z(int value) {
        return value << 8;
    }

    public static int PIXZ(int value) {
        return value >> 8;
    }

    public static int SQ(int val) {
        return val * val;
    }

    public static boolean FACING(Sprite sp1, Sprite sp2) {
        return Pragmas.klabs(Player.GetDeltaAngle(sp2.getAng(), Gameutils.NORM_ANGLE(EngineUtils.getAngle(sp1.getX() - sp2.getX(), sp1.getY() - sp2.getY())))) < 512;
    }

    public static boolean PLAYER_FACING_RANGE(PlayerStr pp, Sprite sp, int range) {
        return Pragmas.klabs(Player.GetDeltaAngle(pp.getAnglei(), Gameutils.NORM_ANGLE(EngineUtils.getAngle(sp.getX() - pp.posx, sp.getY() - pp.posy)))) < range;
    }

    public static boolean FACING_RANGE(Sprite sp1, Sprite sp2, int range) {
        return Pragmas.klabs(Player.GetDeltaAngle(sp2.getAng(), Gameutils.NORM_ANGLE(EngineUtils.getAngle(sp1.getX() - sp2.getX(), sp1.getY() - sp2.getY())))) < range;
    }

    public static int DOT_PRODUCT_2D(int x1, int y1, int x2, int y2) {
        return Pragmas.mulscale(x1, x2, 16) + Pragmas.mulscale(y1, y2, 16);
    }

    public static int PLAYER_MOVING(PlayerStr pp) {
        return pp.xvect | pp.yvect;
    }

    public static boolean TEST_GOTSECTOR(int sect_num) {
        Renderer renderer = Main.game.getRenderer();
        return MyTypes.TEST(renderer.getRenderedSectors()[sect_num >> 3], 1 << (sect_num & 7));
    }

    public static boolean TEST_GOTPIC(int tile_num) {
        Renderer renderer = Main.game.getRenderer();
        return tile_num != -1 && MyTypes.TEST(renderer.getRenderedPics()[tile_num >> 3], 1 << (tile_num & 7));
    }

    public static void RESET_GOTPIC(int tile_num) {
        Renderer renderer = Main.game.getRenderer();
        byte[] byArray = renderer.getRenderedPics();
        int n = tile_num >> 3;
        byArray[n] = (byte)(byArray[n] & (byte)(~(1 << (tile_num & 7))));
    }

    public static void SET_GOTPIC(int tile_num) {
        Renderer renderer = Main.game.getRenderer();
        byte[] byArray = renderer.getRenderedPics();
        int n = tile_num >> 3;
        byArray[n] = (byte)(byArray[n] | (byte)(1 << (tile_num & 7)));
    }

    public static int LOW_TAG(int sectnum) {
        Sector sec = Main.boardService.getSector(sectnum);
        if (sec != null) {
            return sec.getLotag();
        }
        return 0;
    }

    public static int HIGH_TAG(int sectnum) {
        Sector sec = Main.boardService.getSector(sectnum);
        if (sec != null) {
            return sec.getHitag();
        }
        return 0;
    }

    public static int LOW_TAG_SPRITE(int spnum) {
        WangSprite sp = Main.boardService.getSprite(spnum);
        if (sp != null) {
            return sp.getLotag();
        }
        return 0;
    }

    public static int SEC(int value) {
        return value * 120;
    }

    public static int NORM_HIT_INDEX(int val) {
        return val & 0x1FFFFFFF;
    }

    public static int CS(int sprite_bit) {
        return sprite_bit << 16;
    }

    public static void SET_BOOL1(Sprite sp) {
        sp.setExtra(sp.getExtra() | SPRX_BOOL1);
    }

    public static void SET_BOOL2(Sprite sp) {
        sp.setExtra(sp.getExtra() | SPRX_BOOL2);
    }

    public static void SET_BOOL3(Sprite sp) {
        sp.setExtra(sp.getExtra() | SPRX_BOOL3);
    }

    public static void SET_BOOL6(Sprite sp) {
        sp.setExtra(sp.getExtra() | SPRX_BOOL6);
    }

    public static void SET_BOOL8(Sprite sp) {
        sp.setExtra(sp.getExtra() | SPRX_BOOL8);
    }

    public static void SET_BOOL9(Sprite sp) {
        sp.setExtra(sp.getExtra() | SPRX_BOOL9);
    }

    public static void RESET_BOOL1(Sprite sp) {
        sp.setExtra(sp.getExtra() & ~SPRX_BOOL1);
    }

    public static void RESET_BOOL2(Sprite sp) {
        sp.setExtra(sp.getExtra() & ~SPRX_BOOL2);
    }

    public static void RESET_BOOL3(Sprite sp) {
        sp.setExtra(sp.getExtra() & ~SPRX_BOOL3);
    }

    public static void RESET_BOOL8(Sprite sp) {
        sp.setExtra(sp.getExtra() & ~SPRX_BOOL8);
    }

    public static boolean TEST_BOOL1(Sprite sp) {
        return MyTypes.TEST(sp.getExtra(), SPRX_BOOL1);
    }

    public static boolean TEST_BOOL2(Sprite sp) {
        return MyTypes.TEST(sp.getExtra(), SPRX_BOOL2);
    }

    public static boolean TEST_BOOL3(Sprite sp) {
        return MyTypes.TEST(sp.getExtra(), SPRX_BOOL3);
    }

    public static boolean TEST_BOOL4(Sprite sp) {
        return MyTypes.TEST(sp.getExtra(), SPRX_BOOL4);
    }

    public static boolean TEST_BOOL5(Sprite sp) {
        return MyTypes.TEST(sp.getExtra(), SPRX_BOOL5);
    }

    public static boolean TEST_BOOL6(Sprite sp) {
        return MyTypes.TEST(sp.getExtra(), SPRX_BOOL6);
    }

    public static boolean TEST_BOOL7(Sprite sp) {
        return MyTypes.TEST(sp.getExtra(), SPRX_BOOL7);
    }

    public static boolean TEST_BOOL8(Sprite sp) {
        return MyTypes.TEST(sp.getExtra(), SPRX_BOOL8);
    }

    public static boolean TEST_BOOL9(Sprite sp) {
        return MyTypes.TEST(sp.getExtra(), SPRX_BOOL9);
    }

    public static boolean TEST_BOOL11(Sprite sp) {
        return MyTypes.TEST(sp.getExtra(), SPRX_BOOL11);
    }

    public static boolean FAF_ConnectCeiling(Sector sec) {
        return sec != null && sec.getCeilingpicnum() == 2356;
    }

    public static boolean FAF_ConnectFloor(Sector sec) {
        return sec != null && sec.getFloorpicnum() == 2356;
    }

    public static boolean FAF_ConnectArea(int sectnum) {
        Sector sec = Main.boardService.getSector(sectnum);
        return Gameutils.FAF_ConnectCeiling(sec) || Gameutils.FAF_ConnectFloor(sec);
    }

    public static int TEXT_XCENTER(int width) {
        return (320 - width) / 2;
    }

    public static int TEXT_TEST_COL(int width) {
        return Gameutils.TEXT_XCENTER(width);
    }

    public static int RANDOM_P2(int pwr_of_2) {
        return MyTypes.MOD_P2(Main.engine.krand(), pwr_of_2);
    }

    public static int RANDOM_RANGE(int range) {
        return Ai.RandomRange(range);
    }

    public static int RANDOM() {
        return Main.engine.krand();
    }

    public static int FindDistance2D(int dx, int dy) {
        dx = Pragmas.klabs(dx);
        dy = Pragmas.klabs(dy);
        if (dx == 0) {
            return dy;
        }
        if (dy == 0) {
            return dx;
        }
        if (dy < dx) {
            int i = dx;
            dx = dy;
            dy = i;
        }
        dx += dx >> 1;
        return (dx >> 6) + (dx >> 2) + dy - (dy >> 5) - (dy >> 7);
    }

    public static int FindDistance3D(int dx, int dy, int dz) {
        int i;
        dx = Pragmas.klabs(dx);
        dy = Pragmas.klabs(dy);
        dz = Pragmas.klabs(dz);
        if (dx < dy) {
            i = dx;
            dx = dy;
            dy = i;
        }
        if (dx < dz) {
            i = dx;
            dx = dz;
            dz = i;
        }
        int t = dy + dz;
        return dx - (dx >> 4) + (t >> 2) + (t >> 3);
    }

    public static void clearUser() {
        Arrays.fill(pUser, null);
    }

    @Nullable
    public static USER getUser(int sn) {
        USER u;
        if (sn < 0 || sn >= pUser.length || Main.boardService.getBoard() == null) {
            return null;
        }
        WangSprite wsp = Main.boardService.getSprite(sn);
        if (wsp != null && (u = wsp.getUser()) != pUser[sn]) {
            throw new RuntimeException("Unsync USER structs");
        }
        return pUser[sn];
    }

    public static void setUser(int sn, USER user) {
        WangSprite wsp = Main.boardService.getSprite(sn);
        if (wsp != null) {
            if (sn >= 0 && sn < pUser.length) {
                Gameutils.pUser[sn] = user;
            }
            wsp.setUser(user);
        }
    }

    public static enum FootType {
        WATER_FOOT,
        BLOOD_FOOT;

    }
}

