/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.JWeapon;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Palette;
import ru.m210projects.Wang.Panel;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Text;
import ru.m210projects.Wang.Type.INVENTORY_DATA;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Panel_Sprite;
import ru.m210projects.Wang.Type.Panel_State;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.USER;

public class Inv {
    public static final int INVENTORY_MEDKIT = 0;
    public static final int INVENTORY_REPAIR_KIT = 1;
    public static final int INVENTORY_CLOAK = 2;
    public static final int INVENTORY_NIGHT_VISION = 3;
    public static final int INVENTORY_CHEMBOMB = 4;
    public static final int INVENTORY_FLASHBOMB = 5;
    public static final int INVENTORY_CALTROPS = 6;
    public static final int MAX_INVENTORY = 7;
    public static final int INVENTORY_BOX_X = 231;
    public static final int INVENTORY_BOX_Y = 168;
    private static final int INVF_AUTO_USE = MyTypes.BIT(0);
    private static final int INVF_TIMED = MyTypes.BIT(1);
    private static final int INVF_COUNT = MyTypes.BIT(2);
    private static final short[] InventoryBarXpos = new short[]{110, 130, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80};
    private static final short[] InventoryBarYpos = new short[]{172, 172, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130};
    private static final int INVENTORY_ICON_WIDTH = 28;
    private static final Inventory_Stop_Func StopInventoryCloak = Inv::StopInventoryCloak;
    private static final Inventory_Stop_Func StopInventoryNightVision = Inv::StopInventoryNightVision;
    public static final INVENTORY_DATA[] InventoryData = new INVENTORY_DATA[]{new INVENTORY_DATA("PORTABLE MEDKIT", Player.Player_Action_Func.UseInventoryMedkit, null, Panel.ps_PanelMedkit, 0, 1, 65536, 0), new INVENTORY_DATA("REPAIR KIT", null, null, Panel.ps_PanelRepairKit, 100, 1, 65536, INVF_AUTO_USE), new INVENTORY_DATA("SMOKE BOMB", Player.Player_Action_Func.UseInventoryCloak, StopInventoryCloak, Panel.ps_PanelCloak, 4, 1, 65536, INVF_TIMED), new INVENTORY_DATA("NIGHT VISION", Player.Player_Action_Func.UseInventoryNightVision, StopInventoryNightVision, Panel.ps_PanelNightVision, 3, 1, 65536, INVF_TIMED), new INVENTORY_DATA("GAS BOMB", Player.Player_Action_Func.UseInventoryChemBomb, null, Panel.ps_PanelChemBomb, 0, 1, 65536, INVF_COUNT), new INVENTORY_DATA("FLASH BOMB", Player.Player_Action_Func.UseInventoryFlashBomb, null, Panel.ps_PanelFlashBomb, 0, 2, 65536, INVF_COUNT), new INVENTORY_DATA("CALTROPS", Player.Player_Action_Func.UseInventoryCaltrops, null, Panel.ps_PanelCaltrops, 0, 3, 65536, INVF_COUNT)};
    private static final int INVENTORY_PIC_XOFF = 1;
    private static final int INVENTORY_PIC_YOFF = 1;
    private static final int INVENTORY_PERCENT_XOFF = 19;
    private static final int INVENTORY_PERCENT_YOFF = 13;
    private static final int INVENTORY_STATE_XOFF = 19;
    private static final int INVENTORY_STATE_YOFF = 1;
    private static final char[] buffer = new char[32];
    private static int InventoryBoxX;
    private static int InventoryBoxY;

    public static void PanelInvTestSuicide(Panel_Sprite psp) {
        if (MyTypes.TEST(psp.flags, Panel.PANF_SUICIDE)) {
            Panel.pKillSprite(psp);
        }
    }

    public static Panel_Sprite SpawnInventoryIcon(PlayerStr pp, int InventoryNum) {
        Panel_Sprite psp;
        if (pp.InventorySprite[InventoryNum] != null) {
            return null;
        }
        if (Inv.InventoryData[InventoryNum].State == null) {
            return null;
        }
        Renderer renderer = Main.game.getRenderer();
        int x = InventoryBarXpos[Main.cfg.BorderNum] + InventoryNum * 28;
        short y = InventoryBarYpos[Main.cfg.BorderNum];
        pp.InventorySprite[InventoryNum] = psp = Panel.pSpawnSprite(pp, Inv.InventoryData[InventoryNum].State, 192, x, y);
        psp.x1 = 0;
        psp.y1 = 0;
        psp.x2 = renderer.getWidth() - 1;
        psp.y2 = renderer.getHeight() - 1;
        psp.scale = Inv.InventoryData[InventoryNum].Scale;
        psp.flags |= Panel.PANF_STATUS_AREA | Panel.PANF_SCREEN_CLIP;
        return psp;
    }

    private static void KillPlayerIcon(PlayerStr ignored, Panel_Sprite pspp) {
        if (pspp != null) {
            pspp.flags |= Panel.PANF_SUICIDE;
        }
    }

    private static void KillAllPanelInv(PlayerStr pp) {
        pp.InventoryBarTics = 0;
        for (int i = 0; i < 7; ++i) {
            if (pp.InventorySprite[i] == null) continue;
            pp.InventoryTics[i] = 0;
            pp.InventorySprite[i].flags |= Panel.PANF_SUICIDE;
            pp.InventorySprite[i].numpages = 0;
            pp.InventorySprite[i] = null;
        }
    }

    public static Panel_Sprite SpawnIcon(PlayerStr pp, Panel_State state) {
        Renderer renderer = Main.game.getRenderer();
        Panel_Sprite psp = Panel.pSpawnSprite(pp, state, 192, 0, 0);
        psp.x1 = 0;
        psp.y1 = 0;
        psp.x2 = renderer.getWidth() - 1;
        psp.y2 = renderer.getHeight() - 1;
        psp.flags |= Panel.PANF_STATUS_AREA | Panel.PANF_SCREEN_CLIP;
        return psp;
    }

    private static void AutoPickInventory(PlayerStr pp) {
        if (pp.InventoryAmount[pp.InventoryNum] <= 0) {
            for (int i = 0; i < 7; ++i) {
                if (i == 1 || pp.InventoryAmount[i] == 0) continue;
                pp.InventoryNum = i;
                return;
            }
            if (pp.InventoryAmount[1] != 0) {
                pp.InventoryNum = 1;
            }
        }
    }

    public static void UseInventoryMedkit(PlayerStr pp) {
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (u == null) {
            return;
        }
        int inv = 0;
        if (pp.InventoryAmount[inv] == 0) {
            return;
        }
        int diff = 100 - u.Health;
        if (diff <= 0) {
            return;
        }
        int amt = diff > pp.InventoryPercent[inv] ? pp.InventoryPercent[inv] : diff;
        Panel.PlayerUpdateHealth(pp, amt);
        int n = inv;
        pp.InventoryPercent[n] = (short)(pp.InventoryPercent[n] - (short)diff);
        if (pp.InventoryPercent[inv] < 0) {
            pp.InventoryPercent[inv] = 0;
            int n2 = inv;
            pp.InventoryAmount[n2] = (short)(pp.InventoryAmount[n2] - 1);
        }
        Inv.AutoPickInventory(pp);
        Inv.PlayerUpdateInventory(pp, pp.InventoryNum);
        if (pp == Game.Player[Mmulti.myconnectindex]) {
            if (amt >= 30) {
                Sound.PlayerSound(417, 9, pp);
            } else {
                Sound.PlayerSound(418, 9, pp);
            }
        }
    }

    public static void UseInventoryChemBomb(PlayerStr pp) {
        int inv = 4;
        if (pp.InventoryAmount[inv] == 0) {
            return;
        }
        JWeapon.PlayerInitChemBomb(pp);
        pp.InventoryPercent[inv] = 0;
        int n = inv;
        pp.InventoryAmount[n] = (short)(pp.InventoryAmount[n] - 1);
        if (pp.InventoryAmount[n] < 0) {
            pp.InventoryAmount[inv] = 0;
        }
        Inv.AutoPickInventory(pp);
        Inv.PlayerUpdateInventory(pp, pp.InventoryNum);
    }

    public static void UseInventoryFlashBomb(PlayerStr pp) {
        int inv = 5;
        if (pp.InventoryAmount[inv] == 0) {
            return;
        }
        JWeapon.PlayerInitFlashBomb(pp);
        pp.InventoryPercent[inv] = 0;
        int n = inv;
        pp.InventoryAmount[n] = (short)(pp.InventoryAmount[n] - 1);
        if (pp.InventoryAmount[n] < 0) {
            pp.InventoryAmount[inv] = 0;
        }
        Inv.AutoPickInventory(pp);
        Inv.PlayerUpdateInventory(pp, pp.InventoryNum);
    }

    public static void UseInventoryCaltrops(PlayerStr pp) {
        int inv = 6;
        if (pp.InventoryAmount[inv] == 0) {
            return;
        }
        JWeapon.PlayerInitCaltrops(pp);
        pp.InventoryPercent[inv] = 0;
        int n = inv;
        pp.InventoryAmount[n] = (short)(pp.InventoryAmount[n] - 1);
        if (pp.InventoryAmount[n] < 0) {
            pp.InventoryAmount[inv] = 0;
        }
        Inv.AutoPickInventory(pp);
        Inv.PlayerUpdateInventory(pp, pp.InventoryNum);
    }

    public static void UseInventoryRepairKit(PlayerStr pp) {
        int inv = 1;
        if (pp == Game.Player[Mmulti.myconnectindex]) {
            if (Gameutils.STD_RANDOM_RANGE(1000) > 500) {
                Sound.PlayerSound(370, 9, pp);
            } else {
                Sound.PlayerSound(443, 9, pp);
            }
        }
        pp.InventoryPercent[inv] = 0;
        pp.InventoryAmount[inv] = 0;
        Inv.AutoPickInventory(pp);
        Inv.PlayerUpdateInventory(pp, pp.InventoryNum);
    }

    public static void UseInventoryCloak(PlayerStr pp) {
        Sprite sp = pp.getSprite();
        if (sp == null || pp.InventoryActive[pp.InventoryNum]) {
            return;
        }
        pp.InventoryActive[pp.InventoryNum] = true;
        Inv.AutoPickInventory(pp);
        Inv.PlayerUpdateInventory(pp, pp.InventoryNum);
        sp.setCstat(sp.getCstat() | Gameutils.CSTAT_SPRITE_TRANSLUCENT);
        sp.setShade(100);
        Sound.PlaySound(283, pp, 0);
        if (pp == Game.Player[Mmulti.myconnectindex]) {
            Sound.PlayerSound(359, 9, pp);
        }
    }

    private static void StopInventoryCloak(PlayerStr pp, int InventoryNum) {
        Sprite sp = pp.getSprite();
        if (sp == null) {
            return;
        }
        pp.InventoryActive[InventoryNum] = false;
        if (pp.InventoryPercent[InventoryNum] <= 0) {
            pp.InventoryPercent[InventoryNum] = 0;
            int n = InventoryNum;
            pp.InventoryAmount[n] = (short)(pp.InventoryAmount[n] - 1);
            if (pp.InventoryAmount[n] < 0) {
                pp.InventoryAmount[InventoryNum] = 0;
            }
        }
        Inv.PlayerUpdateInventory(pp, InventoryNum);
        sp.setCstat(sp.getCstat() & ~Gameutils.CSTAT_SPRITE_TRANSLUCENT);
        sp.setShade(0);
        Sound.PlaySound(283, pp, 0);
    }

    public static void UseInventoryNightVision(PlayerStr pp) {
        if (pp.InventoryActive[pp.InventoryNum]) {
            Inv.StopInventoryNightVision(pp, pp.InventoryNum);
            return;
        }
        pp.InventoryActive[pp.InventoryNum] = true;
        Inv.PlayerUpdateInventory(pp, pp.InventoryNum);
        Palette.DoPlayerNightVisionPalette(pp);
        Sound.PlaySound(289, pp, 9);
    }

    private static void StopInventoryNightVision(PlayerStr pp, int InventoryNum) {
        pp.InventoryActive[InventoryNum] = false;
        if (pp.InventoryPercent[InventoryNum] <= 0) {
            pp.InventoryPercent[InventoryNum] = 0;
            int n = InventoryNum;
            pp.InventoryAmount[n] = (short)(pp.InventoryAmount[n] - 1);
            if (pp.InventoryAmount[n] < 0) {
                pp.InventoryAmount[InventoryNum] = 0;
            }
        }
        Inv.AutoPickInventory(pp);
        Inv.PlayerUpdateInventory(pp, pp.InventoryNum);
        Palette.DoPlayerNightVisionPalette(pp);
        Palette.DoPlayerDivePalette(pp);
        Sound.PlaySound(290, pp, 9);
    }

    public static void InventoryKeys(PlayerStr pp) {
        int inv_hotkey;
        if (Gameutils.TEST_SYNC_KEY(pp, 26)) {
            if (Gameutils.FLAG_KEY_PRESSED(pp, 26)) {
                Gameutils.FLAG_KEY_RELEASE(pp, 26);
                Inv.SpawnInventoryBar(pp);
                Inv.PlayerUpdateInventory(pp, pp.InventoryNum - 1);
                Text.PutStringInfo(pp, Inv.InventoryData[pp.InventoryNum].Name);
                Inv.InventoryBarUpdatePosition(pp);
            }
        } else {
            Gameutils.FLAG_KEY_RESET(pp, 26);
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 27)) {
            if (Gameutils.FLAG_KEY_PRESSED(pp, 27)) {
                Gameutils.FLAG_KEY_RELEASE(pp, 27);
                Inv.SpawnInventoryBar(pp);
                Inv.PlayerUpdateInventory(pp, pp.InventoryNum + 1);
                Text.PutStringInfo(pp, Inv.InventoryData[pp.InventoryNum].Name);
                Inv.InventoryBarUpdatePosition(pp);
            }
        } else {
            Gameutils.FLAG_KEY_RESET(pp, 27);
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 29)) {
            if (Gameutils.FLAG_KEY_PRESSED(pp, 29)) {
                Gameutils.FLAG_KEY_RELEASE(pp, 29);
                if (Inv.InventoryData[pp.InventoryNum].init != null) {
                    if (pp.InventoryAmount[pp.InventoryNum] != 0) {
                        Inv.InventoryUse(pp);
                    } else {
                        Text.PutStringInfo(pp, "No " + Inv.InventoryData[pp.InventoryNum].Name);
                    }
                }
            }
        } else {
            Gameutils.FLAG_KEY_RESET(pp, 29);
        }
        if ((inv_hotkey = MyTypes.DTEST(pp.input.bits, Gameutils.SK_INV_HOTKEY_MASK) >> 4) != 0) {
            if (Gameutils.FLAG_KEY_PRESSED(pp, 4)) {
                Gameutils.FLAG_KEY_RELEASE(pp, 4);
                pp.InventoryNum = --inv_hotkey;
                if (Inv.InventoryData[pp.InventoryNum].init != null && !MyTypes.TEST(pp.Flags, Gameutils.PF_CLIMBING) && pp.InventoryAmount[pp.InventoryNum] != 0) {
                    Inv.InventoryUse(pp);
                }
            }
        } else {
            Gameutils.FLAG_KEY_RESET(pp, 4);
        }
    }

    public static void InventoryTimer(PlayerStr pp) {
        if (pp.InventoryBarTics != 0) {
            Inv.InventoryBarUpdatePosition(pp);
            pp.InventoryBarTics -= 3;
            if (pp.InventoryBarTics <= 0) {
                Inv.KillInventoryBar(pp);
                pp.InventoryBarTics = 0;
            }
        }
        int inv = 0;
        int i = 0;
        while (i < InventoryData.length) {
            INVENTORY_DATA id = InventoryData[i];
            if (MyTypes.TEST(id.Flags, INVF_TIMED) && pp.InventoryActive[inv]) {
                int n = inv;
                pp.InventoryTics[n] = (short)(pp.InventoryTics[n] - 3);
                if (pp.InventoryTics[inv] <= 0) {
                    int n2 = inv;
                    pp.InventoryPercent[n2] = (short)(pp.InventoryPercent[n2] - (short)id.DecPerSec);
                    if (pp.InventoryPercent[inv] <= 0) {
                        pp.InventoryPercent[inv] = 0;
                        Inv.InventoryStop(pp, inv);
                        pp.InventoryActive[inv] = false;
                    } else {
                        pp.InventoryTics[inv] = (short)Gameutils.SEC(1);
                    }
                    Inv.PlayerUpdateInventory(pp, pp.InventoryNum);
                }
            } else if (MyTypes.TEST(id.Flags, INVF_AUTO_USE) && pp.InventoryActive[inv]) {
                int n = inv;
                pp.InventoryTics[n] = (short)(pp.InventoryTics[n] - 3);
                if (pp.InventoryTics[inv] <= 0) {
                    int n3 = inv;
                    pp.InventoryPercent[n3] = (short)(pp.InventoryPercent[n3] - (short)id.DecPerSec);
                    if (pp.InventoryPercent[inv] <= 0) {
                        pp.InventoryPercent[inv] = 0;
                        Inv.InventoryStop(pp, inv);
                    } else {
                        pp.InventoryTics[inv] = (short)Gameutils.SEC(1);
                        pp.InventoryActive[inv] = false;
                    }
                    Inv.PlayerUpdateInventory(pp, pp.InventoryNum);
                }
            }
            ++i;
            ++inv;
        }
    }

    private static void SpawnInventoryBar(PlayerStr pp) {
        int inv = 0;
        INVENTORY_DATA id = InventoryData[0];
        if (pp.InventoryBarTics != 0) {
            pp.InventoryBarTics = Gameutils.SEC(2);
            return;
        }
        pp.InventorySelectionBox = Inv.SpawnIcon(pp, Panel.ps_PanelSelectionBox[0]);
        int i = 0;
        while (i < InventoryData.length && id.Name != null) {
            id = InventoryData[i];
            Panel_Sprite psp = Inv.SpawnInventoryIcon(pp, inv);
            if (psp != null && pp.InventoryAmount[inv] == 0) {
                psp.shade = 100;
            }
            ++i;
            ++inv;
        }
        pp.InventoryBarTics = Gameutils.SEC(2);
    }

    public static void KillInventoryBar(PlayerStr pp) {
        Inv.KillAllPanelInv(pp);
        Inv.KillPlayerIcon(pp, pp.InventorySelectionBox);
        pp.InventorySelectionBox = null;
    }

    private static void InventoryBarUpdatePosition(PlayerStr pp) {
        int inv = 0;
        INVENTORY_DATA id = InventoryData[0];
        int x = InventoryBarXpos[Main.cfg.BorderNum] + pp.InventoryNum * 28;
        int y = InventoryBarYpos[Main.cfg.BorderNum];
        if (pp.InventorySelectionBox == null) {
            return;
        }
        pp.InventorySelectionBox.x = x - 5;
        pp.InventorySelectionBox.y = y - 5;
        int i = 0;
        while (i < InventoryData.length && id.Name != null) {
            id = InventoryData[i];
            x = InventoryBarXpos[Main.cfg.BorderNum] + inv * 28;
            y = InventoryBarYpos[Main.cfg.BorderNum];
            if (pp.InventorySprite[inv] != null) {
                pp.InventorySprite[inv].x = x;
                pp.InventorySprite[inv].y = y;
            }
            ++i;
            ++inv;
        }
    }

    private static void InventoryUse(PlayerStr pp) {
        INVENTORY_DATA id = InventoryData[pp.InventoryNum];
        if (id.init != null) {
            id.init.invoke(pp);
        }
    }

    private static void InventoryStop(PlayerStr pp, int InventoryNum) {
        INVENTORY_DATA id = InventoryData[InventoryNum];
        if (id.stop != null) {
            id.stop.invoke(pp, InventoryNum);
        }
    }

    public static void DrawInventory(PlayerStr pp, int x, int y, int flags) {
        if (pp.InventoryBarTics != 0) {
            int inv = 0;
            INVENTORY_DATA id = InventoryData[0];
            int i = 0;
            while (i < InventoryData.length && id.Name != null) {
                id = InventoryData[i];
                Panel_Sprite psp = pp.InventorySprite[inv];
                if (psp != null) {
                    psp.shade = pp.InventoryAmount[inv] == 0 ? 100 : 0;
                }
                ++i;
                ++inv;
            }
        }
        InventoryBoxX = x;
        InventoryBoxY = y;
        if (Main.cfg.BorderNum == 3 && pp.InventoryAmount[pp.InventoryNum] != 0) {
            Inv.PlayerUpdateInventoryPic(pp, flags);
        }
        if (pp.InventoryAmount[pp.InventoryNum] != 0) {
            Inv.PlayerUpdateInventoryState(pp, flags);
            Inv.PlayerUpdateInventoryPercent(pp, flags);
        }
    }

    public static void PlayerUpdateInventory(PlayerStr pp, int InventoryNum) {
        pp.InventoryNum = InventoryNum;
        if (pp.InventoryNum < 0) {
            pp.InventoryNum = 6;
        }
        if (pp.InventoryNum >= 7) {
            pp.InventoryNum = 0;
        }
    }

    private static void PlayerUpdateInventoryPercent(PlayerStr pp, int flags) {
        INVENTORY_DATA id = InventoryData[pp.InventoryNum];
        int x = InventoryBoxX + 19;
        int y = InventoryBoxY + 13;
        if (MyTypes.TEST(id.Flags, INVF_COUNT)) {
            Strhandler.Bitoa(pp.InventoryAmount[pp.InventoryNum], buffer);
            Inv.InventoryDisplayString(pp, x, y, flags);
        } else {
            int offs = Strhandler.Bitoa(pp.InventoryPercent[pp.InventoryNum], buffer);
            Strhandler.buildString(buffer, offs, "%");
            Inv.InventoryDisplayString(pp, x, y, flags);
        }
    }

    private static void PlayerUpdateInventoryPic(PlayerStr pp, int flags) {
        Renderer renderer = Main.game.getRenderer();
        INVENTORY_DATA id = InventoryData[pp.InventoryNum];
        int x = InventoryBoxX + 1;
        int y = InventoryBoxY + 1;
        renderer.rotatesprite(x << 16, y << 16, id.Scale, 0, id.State.picndx, 0, 0, Gameutils.ROTATE_SPRITE_SCREEN_CLIP | Gameutils.ROTATE_SPRITE_CORNER | flags);
    }

    private static void PlayerUpdateInventoryState(PlayerStr pp, int flags) {
        INVENTORY_DATA id = InventoryData[pp.InventoryNum];
        int x = InventoryBoxX + 19;
        int y = InventoryBoxY + 1;
        if (MyTypes.TEST(id.Flags, INVF_AUTO_USE)) {
            Strhandler.buildString(buffer, 0, "AUTO");
            Inv.InventoryDisplayString(pp, x, y, flags);
        } else if (MyTypes.TEST(id.Flags, INVF_TIMED)) {
            Strhandler.buildString(buffer, 0, pp.InventoryActive[pp.InventoryNum] ? "ON" : "OFF");
            Inv.InventoryDisplayString(pp, x, y, flags);
        }
    }

    private static void InventoryDisplayString(PlayerStr pp, int x, int y, int flags) {
        if (Main.cfg.BorderNum != 3) {
            Text.DisplayMiniBarSmString(pp, x, y, 0, buffer, flags);
        } else {
            Text.DisplaySmString(pp, x, y, 0, buffer);
        }
    }

    public static interface Inventory_Stop_Func {
        public void invoke(PlayerStr var1, int var2);
    }
}

