/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import java.util.ArrayList;
import java.util.List;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Mirror;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.exceptions.WarningException;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Wang.Draw;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Type.MirrorType;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.OrgTile;
import ru.m210projects.Wang.Type.ParentalStruct;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.ResourceHandler;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Type.VOC3D;
import ru.m210projects.Wang.Weapon;

public class JSector {
    public static final int MAXMIRRORMONSTERS = 4;
    public static final int MAXMIRRORS = 8;
    public static final int MIRRORLABEL = 6000;
    public static final int MIRROR = 340;
    public static final int CAMSPRITE = 3830;
    public static final int MAXCAMDIST = 8000;
    public static final MirrorType[] mirror = new MirrorType[8];
    public static int camloopcnt = 0;
    public static int camplayerview = 1;
    public static boolean mirrorinview;
    public static int mirrorcnt;
    public static final List<OrgTile> orgwalllist;
    public static final List<OrgTile> orgwalloverlist;
    public static final List<OrgTile> orgsectorceilinglist;
    public static final List<OrgTile> orgsectorfloorlist;
    static int MirrorMoveSkip16;
    static final boolean bAutoSize = true;
    static int rotang;

    public static void InitJSectorStructs() {
        for (int i = 0; i < Engine.MAXTILES; ++i) {
            Draw.aVoxelArray[i] = new ParentalStruct();
        }
    }

    public static void JS_SpriteSetup() {
        Wall[] walls;
        ListNode<Sprite> node = Main.boardService.getStatNode(0);
        while (node != null) {
            int SpriteNum = node.getIndex();
            ListNode<Sprite> NextSprite = node.getNext();
            Sprite sp = node.get();
            short tag = sp.getHitag();
            if (Game.Level == 9 && Game.swGetAddon() == 2 && SpriteNum == 11 && sp.getPicnum() == 817) {
                sp.setExtra(0);
            }
            if (tag == 1000 && sp.getPicnum() != 2307) {
                Sprites.change_sprite_stat(SpriteNum, 67);
            }
            switch (sp.getPicnum()) {
                case 2307: {
                    if (tag == 1000) {
                        Sprites.change_sprite_stat(SpriteNum, 500);
                        break;
                    }
                    if (tag == 1001) {
                        Sprites.change_sprite_stat(SpriteNum, 500);
                        break;
                    }
                    if (tag == 1002) {
                        Sprites.change_sprite_stat(SpriteNum, 68);
                        break;
                    }
                    if (tag == 1005) {
                        Sprites.change_sprite_stat(SpriteNum, 69);
                        break;
                    }
                    if (tag != 1006) break;
                    USER u = Sprites.SpawnUser(SpriteNum, 0, null);
                    u.RotNum = 0;
                    u.WaitTics = sp.getLotag() * 120;
                    u.ActorActionFunc = Weapon.GenerateDrips;
                    Sprites.change_sprite_stat(SpriteNum, 41);
                    sp.setCstat(sp.getCstat() | Gameutils.CSTAT_SPRITE_INVISIBLE);
                    break;
                }
                case 380: 
                case 396: 
                case 430: 
                case 443: 
                case 512: 
                case 521: 
                case 541: 
                case 2720: 
                case 3143: 
                case 3157: {
                    VOC3D voc = Sound.PlaySound(185, sp, 13);
                    if (voc == null) break;
                    Sound.Set3DSoundOwner(SpriteNum, voc);
                    break;
                }
                case 795: 
                case 880: {
                    VOC3D voc = Sound.PlaySound(178, sp, 13);
                    if (voc == null) break;
                    Sound.Set3DSoundOwner(SpriteNum, voc);
                    break;
                }
                case 460: {
                    VOC3D voc = Sound.PlaySound(79, sp, 85);
                    if (voc == null) break;
                    Sound.Set3DSoundOwner(SpriteNum, voc);
                }
            }
            node = NextSprite;
        }
        for (Wall wall : walls = Main.boardService.getBoard().getWalls()) {
            short picnum = wall.getPicnum();
            switch (picnum) {
                case 175: 
                case 179: 
                case 300: 
                case 320: 
                case 330: 
                case 352: 
                case 780: 
                case 890: 
                case 2608: 
                case 2616: {
                    wall.setExtra(wall.getExtra() | Gameutils.WALLFX_DONT_STICK);
                }
            }
        }
    }

    public static void JS_InitMirrors() {
        int i;
        int i2;
        for (i2 = 0; i2 < 8; ++i2) {
            if (mirror[i2] == null) {
                JSector.mirror[i2] = new MirrorType();
                continue;
            }
            mirror[i2].reset();
        }
        mirrorinview = false;
        mirrorcnt = 0;
        ResourceHandler.InitSpecialTextures();
        for (i2 = 0; i2 < 8; ++i2) {
            JSector.mirror[i2].campic = -1;
            JSector.mirror[i2].camsprite = -1;
            JSector.mirror[i2].camera = -1;
            JSector.mirror[i2].ismagic = false;
        }
        Wall[] walls = Main.boardService.getBoard().getWalls();
        for (i = 0; i < walls.length; ++i) {
            Wall wal = walls[i];
            short s = wal.getNextsector();
            Sector nsec = Main.boardService.getSector(s);
            if (nsec == null || wal.getOverpicnum() != 340 || (wal.getCstat() & 0x20) == 0) continue;
            if ((nsec.getFloorstat() & 1) == 0) {
                wal.setOverpicnum(6000 + mirrorcnt);
                wal.setPicnum(6000 + mirrorcnt);
                nsec.setCeilingpicnum(6000 + mirrorcnt);
                nsec.setFloorpicnum(6000 + mirrorcnt);
                nsec.setFloorstat(nsec.getFloorstat() | 1);
                JSector.mirror[JSector.mirrorcnt].mirrorwall = i;
                JSector.mirror[JSector.mirrorcnt].mirrorsector = s;
                JSector.mirror[JSector.mirrorcnt].numspawnspots = 0;
                JSector.mirror[JSector.mirrorcnt].ismagic = false;
                if (wal.getLotag() == 306) {
                    Sprite sp;
                    ListNode<Sprite> node;
                    JSector.mirror[JSector.mirrorcnt].ismagic = true;
                    boolean Found_Cam = false;
                    for (node = Main.boardService.getStatNode(500); node != null; node = node.getNext()) {
                        sp = node.get();
                        if (sp.getHitag() != 1000 || sp.getLotag() != wal.getHitag()) continue;
                        JSector.mirror[JSector.mirrorcnt].camera = node.getIndex();
                        sp.setXvel(sp.getAng());
                        Found_Cam = true;
                    }
                    for (node = Main.boardService.getStatNode(67); node != null; node = node.getNext()) {
                        sp = node.get();
                        if (sp.getHitag() != 1000 || sp.getLotag() != wal.getHitag()) continue;
                        JSector.mirror[JSector.mirrorcnt].camera = node.getIndex();
                        sp.setXvel(sp.getAng());
                        Found_Cam = true;
                    }
                    if (!Found_Cam) {
                        throw new WarningException("Cound not find the camera view sprite for match " + wal.getHitag() + "\r\nMap Coordinates: x = " + wal.getX() + ", y = " + wal.getY());
                    }
                    Found_Cam = false;
                    WangSprite camSpr = Main.boardService.getSprite(JSector.mirror[JSector.mirrorcnt].camera);
                    if (camSpr != null && Gameutils.TEST_BOOL1(camSpr)) {
                        for (ListNode<Sprite> node2 = Main.boardService.getStatNode(0); node2 != null; node2 = node2.getNext()) {
                            sp = node2.get();
                            if (sp.getPicnum() < 3830 || sp.getPicnum() >= 3838 || sp.getHitag() != wal.getHitag()) continue;
                            JSector.mirror[JSector.mirrorcnt].campic = sp.getPicnum();
                            JSector.mirror[JSector.mirrorcnt].camsprite = node2.getIndex();
                            Found_Cam = true;
                        }
                        if (!Found_Cam) {
                            throw new WarningException("Did not find drawtotile for camera number " + mirrorcnt + "\r\nwall[" + i + "].hitag == " + wal.getHitag() + "\r\nMap Coordinates: x = " + wal.getX() + ", y = " + wal.getY());
                        }
                    }
                    JSector.mirror[JSector.mirrorcnt].maxtics = 1800;
                }
                JSector.mirror[JSector.mirrorcnt].mstate = MirrorType.MirrorState.m_normal;
                JSector.mirror[JSector.mirrorcnt].tics = 0;
                ++mirrorcnt;
                continue;
            }
            wal.setOverpicnum(nsec.getCeilingpicnum());
        }
        for (i = 0; i < mirrorcnt; ++i) {
            Sector sec = Main.boardService.getSector(JSector.mirror[i].mirrorsector);
            if (sec == null) continue;
            for (ListNode<Wall> wn = sec.getWallNode(); wn != null; wn = wn.getNext()) {
                Wall wal = wn.get();
                wal.setPicnum(340);
                wal.setOverpicnum(340);
            }
        }
    }

    public static void drawroomstotile(int daposx, int daposy, int daposz, int daang, int dahoriz, int dacursectnum, int tilenume, int smoothratio) {
        Renderer renderer = Main.game.getRenderer();
        DynamicArtEntry pic = Main.engine.getTileManager().getDynamicTile(tilenume);
        renderer.setviewtotile(pic);
        renderer.drawrooms(daposx, daposy, daposz, daang, dahoriz, dacursectnum);
        Draw.analyzesprites(daposx, daposy, daposz, false, smoothratio);
        renderer.drawmasks();
        renderer.setviewback();
        if (renderer.getType() == Renderer.RenderType.Software) {
            Main.engine.getTileManager().squarerotatetile(pic);
        }
        pic.invalidate();
    }

    public static void JS_ProcessEchoSpot() {
        PlayerStr pp = Game.Player[Game.screenpeek];
        boolean reverb_set = false;
        for (ListNode<Sprite> node = Main.boardService.getStatNode(69); node != null; node = node.getNext()) {
            long dist = Integer.MAX_VALUE;
            Sprite tp = node.get();
            long j = Pragmas.klabs(tp.getX() - pp.posx);
            if ((j += (long)Pragmas.klabs(tp.getY() - pp.posy)) < dist) {
                dist = j;
            }
            if (dist > (long)Gameutils.SP_TAG4(tp)) continue;
            int reverb = Gameutils.SP_TAG2(tp);
            if (reverb > 200) {
                reverb = 200;
            }
            if (reverb < 100) {
                reverb = 100;
            }
            Sound.COVER_SetReverb(reverb);
            reverb_set = true;
        }
        if (!MyTypes.TEST(pp.Flags, Gameutils.PF_DIVING) && !reverb_set && pp.Reverb <= 0) {
            Sound.COVER_SetReverb(0);
        }
    }

    public static void JS_DrawMirrors(PlayerStr pp, int tx, int ty, int tz, float tpang, float tphoriz, int smoothratio) {
        Renderer renderer;
        byte[] gotpic;
        MirrorMoveSkip16 = MirrorMoveSkip16 + 1 & 0xF;
        if ((camloopcnt += Main.engine.getTotalClock() - Main.game.pNet.ototalclock) > 300) {
            camloopcnt = 0;
            if (++camplayerview >= Mmulti.numplayers) {
                camplayerview = 1;
            }
        }
        if (((gotpic = (renderer = Main.game.getRenderer()).getRenderedPics())[750] | gotpic[751]) != 0) {
            for (int cnt = 7; cnt >= 0; --cnt) {
                if (Gameutils.TEST_GOTPIC(cnt + 6000) || Gameutils.TEST_GOTPIC(JSector.mirror[cnt].campic)) {
                    WangSprite tp;
                    int j;
                    boolean bIsWallMirror = false;
                    if (Gameutils.TEST_GOTPIC(cnt + 6000)) {
                        bIsWallMirror = true;
                        Gameutils.RESET_GOTPIC(cnt + 6000);
                    } else if (Gameutils.TEST_GOTPIC(JSector.mirror[cnt].campic)) {
                        Gameutils.RESET_GOTPIC(JSector.mirror[cnt].campic);
                    }
                    mirrorinview = true;
                    int dist = Integer.MAX_VALUE;
                    if (bIsWallMirror && JSector.mirror[cnt].mirrorwall != -1) {
                        Wall wal = Main.boardService.getWall(JSector.mirror[cnt].mirrorwall);
                        if (wal != null) {
                            j = Pragmas.klabs(wal.getX() - tx);
                            if ((j += Pragmas.klabs(wal.getY() - ty)) < dist) {
                                dist = j;
                            }
                        }
                    } else if (JSector.mirror[cnt].camsprite != -1 && (tp = Main.boardService.getSprite(JSector.mirror[cnt].camsprite)) != null) {
                        j = Pragmas.klabs(tp.getX() - tx);
                        if ((j += Pragmas.klabs(tp.getY() - ty)) < dist) {
                            dist = j;
                        }
                    }
                    if (JSector.mirror[cnt].ismagic) {
                        WangSprite sp = Main.boardService.getSprite(JSector.mirror[cnt].camera);
                        int w = JSector.mirror[cnt].mirrorwall;
                        Wall wall = Main.boardService.getWall(w);
                        if (wall == null || sp == null) continue;
                        int midx = (wall.getX() + wall.getWall2().getX()) / 2;
                        int midy = (wall.getY() + wall.getWall2().getY()) / 2;
                        int tdx = Pragmas.klabs(midx - tx);
                        int tdy = Pragmas.klabs(midy - ty);
                        int dx = midx >= tx ? sp.getX() - tdx : sp.getX() + tdx;
                        int dy = midy >= ty ? sp.getY() - tdy : sp.getY() + tdy;
                        int tdz = Pragmas.klabs(tz - sp.getZ());
                        int dz = tz >= sp.getZ() ? sp.getZ() + tdz : sp.getZ() - tdz;
                        JSector.mirror[cnt].mstate = MirrorType.MirrorState.m_normal;
                        if (Gameutils.TEST_BOOL1(sp)) {
                            JSector.mirror[cnt].mstate = MirrorType.MirrorState.m_viewon;
                        }
                        if (JSector.mirror[cnt].mstate != MirrorType.MirrorState.m_viewon) {
                            renderer.drawrooms(dx, dy, dz, tpang, tphoriz, sp.getSectnum() + Main.boardService.getSectorCount());
                            Draw.analyzesprites(dx, dy, dz, false, smoothratio);
                            renderer.drawmasks();
                        } else {
                            boolean DoCam = false;
                            if (JSector.mirror[cnt].campic == -1) {
                                throw new AssertException("Missing campic for mirror " + cnt + "\r\nMap Coordinates: x = " + midx + ", y = " + midy);
                            }
                            if (Gameutils.TEST_BOOL2(sp) && !Sprites.MoveSkip2) {
                                if (Gameutils.TEST_BOOL3(sp)) {
                                    sp.setXvel(Gameutils.NORM_ANGLE(sp.getXvel() + 4));
                                    if (Pragmas.klabs(Player.GetDeltaAngle(Gameutils.SP_TAG5(sp), sp.getAng())) >= Gameutils.SP_TAG6(sp)) {
                                        Gameutils.RESET_BOOL3(sp);
                                    }
                                } else {
                                    sp.setXvel(Gameutils.NORM_ANGLE(sp.getXvel() - 4));
                                    if (Pragmas.klabs(Player.GetDeltaAngle(Gameutils.SP_TAG5(sp), sp.getAng())) >= Gameutils.SP_TAG6(sp)) {
                                        Gameutils.SET_BOOL3(sp);
                                    }
                                }
                            } else if (!Gameutils.TEST_BOOL2(sp)) {
                                sp.setXvel(sp.getAng());
                            }
                            int camhoriz = 100;
                            if (Gameutils.SP_TAG7(sp) != 0) {
                                camhoriz = Gameutils.SP_TAG7(sp);
                                if (camhoriz > 299) {
                                    camhoriz = 299;
                                } else if (camhoriz < -99) {
                                    camhoriz = -99;
                                }
                            }
                            if (pp.posx == pp.oposx && pp.posy == pp.oposy && pp.posz == pp.oposz) {
                                DoCam = true;
                            }
                            if ((MirrorMoveSkip16 == 0 || DoCam && Sprites.MoveSkip4 == 0) && dist < 8000) {
                                PlayerStr cp = Game.Player[camplayerview];
                                if (Gameutils.TEST_BOOL11(sp) && (Mmulti.numplayers > 1 || Main.gNet.FakeMultiplayer)) {
                                    JSector.drawroomstotile(cp.posx, cp.posy, cp.posz, cp.getAnglei(), cp.getHorizi(), cp.cursectnum, JSector.mirror[cnt].campic, smoothratio);
                                } else {
                                    JSector.drawroomstotile(sp.getX(), sp.getY(), sp.getZ(), Gameutils.SP_TAG5(sp), camhoriz, sp.getSectnum(), JSector.mirror[cnt].campic, smoothratio);
                                }
                            }
                        }
                    } else if (JSector.mirror[cnt].mirrorwall != -1) {
                        Mirror mirr = renderer.preparemirror(tx, ty, tz, tpang, tphoriz, JSector.mirror[cnt].mirrorwall, JSector.mirror[cnt].mirrorsector);
                        renderer.drawrooms(mirr.getX(), mirr.getY(), tz, mirr.getAngle(), tphoriz, JSector.mirror[cnt].mirrorsector + Main.boardService.getSectorCount());
                        Draw.analyzesprites((int)mirr.getX(), (int)mirr.getY(), tz, true, smoothratio);
                        renderer.drawmasks();
                        renderer.completemirror();
                    }
                    Wall mirrorWall = Main.boardService.getWall(JSector.mirror[cnt].mirrorwall);
                    if (mirrorWall == null) continue;
                    mirrorWall.setOverpicnum(6000 + cnt);
                    continue;
                }
                mirrorinview = false;
            }
        }
    }

    public static void DoAutoSize(Sprite tspr) {
        switch (tspr.getPicnum()) {
            case 1793: {
                break;
            }
            case 1797: 
            case 1807: {
                tspr.setXrepeat(43);
                tspr.setYrepeat(40);
                break;
            }
            case 1799: {
                break;
            }
            case 1824: {
                break;
            }
            case 1820: {
                break;
            }
            case 1814: {
                break;
            }
            case 3035: {
                break;
            }
            case 1843: {
                break;
            }
            case 1794: {
                tspr.setXrepeat(57);
                tspr.setYrepeat(58);
                break;
            }
            case 1796: {
                break;
            }
            case 1823: {
                break;
            }
            case 1818: {
                break;
            }
            case 1800: {
                break;
            }
            case 1817: {
                tspr.setXrepeat(54);
                tspr.setYrepeat(52);
                break;
            }
            case 1831: {
                break;
            }
            case 1842: {
                break;
            }
            case 1811: {
                tspr.setXrepeat(50);
                tspr.setYrepeat(54);
                break;
            }
            case 1812: {
                break;
            }
            case 1802: {
                break;
            }
            case 1803: {
                break;
            }
            case 1808: {
                tspr.setXrepeat(64);
                tspr.setYrepeat(47);
                break;
            }
            case 1805: {
                tspr.setXrepeat(32);
                tspr.setYrepeat(34);
                break;
            }
            case 1829: {
                tspr.setXrepeat(37);
                tspr.setYrepeat(30);
                break;
            }
            case 1810: {
                tspr.setXrepeat(30);
                tspr.setYrepeat(38);
                break;
            }
            case 1819: {
                tspr.setXrepeat(46);
                tspr.setYrepeat(47);
                break;
            }
            case 1813: {
                break;
            }
            case 1801: {
                break;
            }
            case 1837: {
                break;
            }
            case 1782: {
                break;
            }
            case 1804: {
                break;
            }
            case 3031: {
                tspr.setXrepeat(59);
                tspr.setYrepeat(71);
                break;
            }
            case 3046: {
                break;
            }
            case 3050: {
                break;
            }
            case 3054: {
                break;
            }
            case 3058: {
                break;
            }
            case 3059: {
                break;
            }
            case 3030: {
                tspr.setXrepeat(82);
                tspr.setYrepeat(84);
                break;
            }
            case 1766: {
                break;
            }
            case 1770: {
                break;
            }
            case 1774: {
                break;
            }
            case 1778: {
                break;
            }
            case 1767: 
            case 1771: 
            case 1775: 
            case 1779: {
                tspr.setXrepeat(36);
                tspr.setYrepeat(33);
                break;
            }
            case 1765: 
            case 1769: 
            case 1773: 
            case 1777: {
                tspr.setXrepeat(39);
                tspr.setYrepeat(45);
                break;
            }
            case 1846: 
            case 1847: {
                tspr.setXrepeat(47);
                tspr.setYrepeat(40);
                break;
            }
        }
    }

    public static void JAnalyzeSprites(Sprite tspr) {
        if ((rotang += 4) > 2047) {
            rotang = 0;
        }
        JSector.DoAutoSize(tspr);
        if (tspr.getPicnum() == 764) {
            tspr.setCstat(tspr.getCstat() | 0x10);
        }
    }

    public static OrgTile InitOrgTile(List<OrgTile> thelist) {
        OrgTile tp = new OrgTile();
        thelist.add(tp);
        return tp;
    }

    public static OrgTile FindOrgTile(int index, List<OrgTile> thelist) {
        if (thelist.isEmpty()) {
            return null;
        }
        for (OrgTile t : thelist) {
            if (t.index != index) continue;
            return t;
        }
        return null;
    }

    public static void JS_UnInitLockouts() {
        orgwalllist.clear();
        orgwalloverlist.clear();
        orgsectorceilinglist.clear();
        orgsectorfloorlist.clear();
    }

    public static void JS_PlockError(int wall_num, int t) {
        throw new WarningException("ERROR: JS_InitLockouts(), out of range tile number " + wall_num + " " + t);
    }

    public static void JS_InitLockouts() {
        OrgTile tp;
        short picnum;
        orgwalllist.clear();
        orgwalloverlist.clear();
        orgsectorceilinglist.clear();
        orgsectorfloorlist.clear();
        Wall[] walls = Main.boardService.getBoard().getWalls();
        for (int i = 0; i < walls.length; ++i) {
            Wall wal = walls[i];
            picnum = wal.getPicnum();
            if (Draw.aVoxelArray[picnum].Parental >= 6145) {
                JSector.JS_PlockError(i, 1);
            }
            if (Draw.aVoxelArray[picnum].Parental >= 0) {
                tp = JSector.FindOrgTile(i, orgwalllist);
                if (tp == null) {
                    tp = JSector.InitOrgTile(orgwalllist);
                }
                tp.index = i;
                tp.orgpicnum = wal.getPicnum();
            }
            picnum = wal.getOverpicnum();
            if (Draw.aVoxelArray[picnum].Parental >= 6145) {
                JSector.JS_PlockError(i, 2);
            }
            if (Draw.aVoxelArray[picnum].Parental < 0) continue;
            tp = JSector.FindOrgTile(i, orgwalloverlist);
            if (tp == null) {
                tp = JSector.InitOrgTile(orgwalloverlist);
            }
            tp.index = i;
            tp.orgpicnum = wal.getOverpicnum();
        }
        Sector[] sectors = Main.boardService.getBoard().getSectors();
        for (int i = 0; i < sectors.length; ++i) {
            picnum = sectors[i].getCeilingpicnum();
            if (Draw.aVoxelArray[picnum].Parental >= 6145) {
                JSector.JS_PlockError(i, 3);
            }
            if (Draw.aVoxelArray[picnum].Parental >= 0) {
                tp = JSector.FindOrgTile(i, orgsectorceilinglist);
                if (tp == null) {
                    tp = JSector.InitOrgTile(orgsectorceilinglist);
                }
                tp.index = i;
                tp.orgpicnum = sectors[i].getCeilingpicnum();
            }
            picnum = sectors[i].getFloorpicnum();
            if (Draw.aVoxelArray[picnum].Parental >= 6145) {
                JSector.JS_PlockError(i, 2);
            }
            if (Draw.aVoxelArray[picnum].Parental < 0) continue;
            tp = JSector.FindOrgTile(i, orgsectorfloorlist);
            if (tp == null) {
                tp = JSector.InitOrgTile(orgsectorfloorlist);
            }
            tp.index = i;
            tp.orgpicnum = sectors[i].getFloorpicnum();
        }
    }

    public static void JS_ToggleLockouts() {
        OrgTile tp;
        Wall[] walls = Main.boardService.getBoard().getWalls();
        for (int i = 0; i < walls.length; ++i) {
            short picnum;
            Wall wal = walls[i];
            if (Main.cfg.ParentalLock) {
                picnum = wal.getPicnum();
                if (Draw.aVoxelArray[picnum].Parental >= 0) {
                    wal.setPicnum(Draw.aVoxelArray[picnum].Parental);
                }
            } else {
                tp = JSector.FindOrgTile(i, orgwalllist);
                if (tp != null) {
                    wal.setPicnum(tp.orgpicnum);
                }
            }
            if (Main.cfg.ParentalLock) {
                picnum = wal.getOverpicnum();
                if (Draw.aVoxelArray[picnum].Parental < 0) continue;
                wal.setOverpicnum(Draw.aVoxelArray[picnum].Parental);
                continue;
            }
            tp = JSector.FindOrgTile(i, orgwalloverlist);
            if (tp == null) continue;
            wal.setOverpicnum(tp.orgpicnum);
        }
        Sector[] sectors = Main.boardService.getBoard().getSectors();
        for (int i = 0; i < sectors.length; ++i) {
            short picnum;
            Sector sec = sectors[i];
            if (Main.cfg.ParentalLock) {
                picnum = sec.getCeilingpicnum();
                if (Draw.aVoxelArray[picnum].Parental >= 0) {
                    sec.setCeilingpicnum(Draw.aVoxelArray[picnum].Parental);
                }
            } else {
                tp = JSector.FindOrgTile(i, orgsectorceilinglist);
                if (tp != null) {
                    sec.setCeilingpicnum(tp.orgpicnum);
                }
            }
            if (Main.cfg.ParentalLock) {
                picnum = sec.getFloorpicnum();
                if (Draw.aVoxelArray[picnum].Parental < 0) continue;
                sec.setFloorpicnum(Draw.aVoxelArray[picnum].Parental);
                continue;
            }
            tp = JSector.FindOrgTile(i, orgsectorfloorlist);
            if (tp == null) continue;
            sec.setFloorpicnum(tp.orgpicnum);
        }
    }

    public static void UnlockKeyLock(int key_num, int hitsprite) {
        short color = 0;
        switch (key_num - 1) {
            case 0: 
            case 7: {
                color = 25;
                break;
            }
            case 1: {
                color = 23;
                break;
            }
            case 2: {
                color = 22;
                break;
            }
            case 3: 
            case 4: {
                color = 20;
                break;
            }
            case 5: {
                color = 17;
                break;
            }
            case 6: {
                color = 24;
            }
        }
        block13: for (ListNode<Sprite> node = Main.boardService.getStatNode(0); node != null; node = node.getNext()) {
            Sprite sp = node.get();
            switch (sp.getPicnum()) {
                case 1846: {
                    if (sp.getPal() != color) continue block13;
                    Sound.PlaySound(209, sp, 12);
                    if (node.getIndex() != hitsprite) continue block13;
                    sp.setPicnum(1847);
                    continue block13;
                }
                case 1850: {
                    if (sp.getPal() != color) continue block13;
                    Sound.PlaySound(325, sp, 12);
                    sp.setPicnum(1851);
                    continue block13;
                }
                case 1852: {
                    if (sp.getPal() != color) continue block13;
                    Sound.PlaySound(324, sp, 12);
                    if (node.getIndex() == hitsprite) {
                        sp.setPicnum(1853);
                        continue block13;
                    }
                    sp.setPicnum(1854);
                }
            }
        }
    }

    static {
        orgwalllist = new ArrayList<OrgTile>();
        orgwalloverlist = new ArrayList<OrgTile>();
        orgsectorceilinglist = new ArrayList<OrgTile>();
        orgsectorfloorlist = new ArrayList<OrgTile>();
        MirrorMoveSkip16 = 0;
        rotang = 0;
    }
}

