/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.USER;

public class Light {
    public static final int LIGHT_CONSTANT = 0;
    public static final int LIGHT_FLICKER = 1;
    public static final int LIGHT_FADE = 2;
    public static final int LIGHT_FLICKER_ON = 3;
    public static final int LIGHT_FADE_TO_ON_OFF = 4;

    public static int LIGHT_Match(Sprite sp) {
        return Gameutils.SP_TAG2(sp);
    }

    public static int LIGHT_Type(Sprite sp) {
        return Gameutils.SP_TAG3(sp);
    }

    public static int LIGHT_MaxTics(Sprite sp) {
        return Gameutils.SP_TAG4(sp);
    }

    public static int LIGHT_MaxBright(Sprite sp) {
        return Gameutils.SP_TAG5(sp);
    }

    public static int LIGHT_MaxDark(Sprite sp) {
        return Gameutils.SP_TAG6(sp);
    }

    public static int LIGHT_ShadeInc(Sprite sp) {
        return Gameutils.SP_TAG7(sp);
    }

    public static boolean LIGHT_Dir(Sprite sp) {
        return MyTypes.TEST(sp.getExtra(), Gameutils.SPRX_BOOL10);
    }

    public static void LIGHT_DirChange(Sprite sp) {
        int extra = sp.getExtra() ^ Gameutils.SPRX_BOOL10;
        sp.setExtra(extra);
    }

    public static int LIGHT_FloorShade(Sprite sp) {
        return sp.getXoffset();
    }

    public static int LIGHT_CeilingShade(Sprite sp) {
        return sp.getYoffset();
    }

    public static int LIGHT_Tics(Sprite sp) {
        return sp.getZ();
    }

    public static int LIGHT_DiffuseNum(Sprite sp) {
        return Gameutils.SP_TAG3(sp);
    }

    public static int LIGHT_DiffuseMult(Sprite sp) {
        return Gameutils.SP_TAG4(sp);
    }

    public static void SectorLightShade(int spnum, int intensity) {
        USER u;
        Sector sec;
        WangSprite sp = Main.boardService.getSprite(spnum);
        if (sp == null) {
            return;
        }
        if (Gameutils.TEST_BOOL8(sp)) {
            intensity = -intensity;
        }
        if ((sec = Main.boardService.getSector(sp.getSectnum())) == null) {
            return;
        }
        if (!Gameutils.TEST_BOOL2(sp)) {
            if (!Gameutils.TEST_BOOL6(sp)) {
                sec.setFloorpal(sp.getPal());
            }
            sec.setFloorshade((byte)(Light.LIGHT_FloorShade(sp) + intensity));
        }
        if (!Gameutils.TEST_BOOL3(sp)) {
            if (!Gameutils.TEST_BOOL6(sp)) {
                sec.setCeilingpal(sp.getPal());
            }
            sec.setCeilingshade((byte)(Light.LIGHT_CeilingShade(sp) + intensity));
        }
        if (!Gameutils.TEST_BOOL4(sp) && (u = Gameutils.getUser(spnum)) != null) {
            byte[] wall_shade = u.WallShade;
            int wallcount = 0;
            for (ListNode<Wall> wn = sec.getWallNode(); wn != null; wn = wn.getNext()) {
                Wall wal = wn.get();
                if (wallcount >= wall_shade.length) break;
                byte base_shade = wall_shade[wallcount];
                wal.setShade((byte)(base_shade + intensity));
                if (!Gameutils.TEST_BOOL6(sp)) {
                    wal.setPal(sp.getPal());
                }
                ++wallcount;
                Wall nw = Main.boardService.getWall(wal.getNextwall());
                if (!MyTypes.TEST(sp.getExtra(), Gameutils.SPRX_BOOL5) || nw == null) continue;
                if (wallcount >= wall_shade.length) break;
                base_shade = wall_shade[wallcount];
                nw.setShade((byte)(base_shade + intensity));
                if (!Gameutils.TEST_BOOL6(sp)) {
                    nw.setPal(sp.getPal());
                }
                ++wallcount;
            }
        }
    }

    public static void DiffuseLighting(Sprite sp) {
        ListNode<Sprite> node = Main.boardService.getStatNode(84);
        while (node != null) {
            ListNode<Sprite> nexti = node.getNext();
            Sprite dsp = node.get();
            if (Light.LIGHT_Match(dsp) == Light.LIGHT_Match(sp)) {
                int shade = sp.getShade() + (Light.LIGHT_DiffuseNum(dsp) + 1) * Light.LIGHT_DiffuseMult(dsp);
                if (shade > Light.LIGHT_MaxDark(sp)) {
                    shade = Light.LIGHT_MaxDark(sp);
                }
                if (!Gameutils.TEST_BOOL6(dsp)) {
                    dsp.setPal(sp.getPal());
                }
                Light.SectorLightShade(node.getIndex(), shade);
            }
            node = nexti;
        }
    }

    public static void DoLightingMatch(int match, int state) {
        ListNode<Sprite> node = Main.boardService.getStatNode(83);
        while (node != null) {
            int i = node.getIndex();
            ListNode<Sprite> nexti = node.getNext();
            Sprite sp = node.get();
            if (Light.LIGHT_Match(sp) == match) {
                switch (Light.LIGHT_Type(sp)) {
                    case 0: {
                        Gameutils.SET_BOOL9(sp);
                        if (state == -1) {
                            int n = state = !Gameutils.TEST_BOOL1(sp) ? 1 : 0;
                        }
                        if (state == 1) {
                            Gameutils.SET_BOOL1(sp);
                            sp.setShade((byte)(-Light.LIGHT_MaxBright(sp)));
                            USER u = Gameutils.getUser(i);
                            if (u != null) {
                                sp.setPal(u.spal);
                            }
                        } else {
                            Gameutils.RESET_BOOL1(sp);
                            sp.setShade((byte)Light.LIGHT_MaxDark(sp));
                            sp.setPal(0);
                        }
                        Light.SectorLightShade(i, sp.getShade());
                        Light.DiffuseLighting(sp);
                        break;
                    }
                    case 1: 
                    case 2: {
                        Gameutils.SET_BOOL9(sp);
                        if (state == -1) {
                            int n = state = !Gameutils.TEST_BOOL1(sp) ? 1 : 0;
                        }
                        if (state == 1) {
                            Gameutils.SET_BOOL1(sp);
                            break;
                        }
                        Gameutils.RESET_BOOL1(sp);
                        sp.setShade((byte)Light.LIGHT_MaxDark(sp));
                        Light.SectorLightShade(i, sp.getShade());
                        Light.DiffuseLighting(sp);
                        break;
                    }
                    case 4: {
                        Gameutils.SET_BOOL9(sp);
                        if (state == 1) {
                            if (Light.LIGHT_Dir(sp)) {
                                Light.LIGHT_DirChange(sp);
                            }
                        } else if (state == 0 && !Light.LIGHT_Dir(sp)) {
                            Light.LIGHT_DirChange(sp);
                        }
                        Gameutils.SET_BOOL1(sp);
                        break;
                    }
                    case 3: {
                        Gameutils.SET_BOOL9(sp);
                        if (state == -1) {
                            int n = state = !Gameutils.TEST_BOOL1(sp) ? 1 : 0;
                        }
                        if (state == 1) {
                            Gameutils.SET_BOOL1(sp);
                            break;
                        }
                        short spal = sp.getPal();
                        Gameutils.RESET_BOOL1(sp);
                        sp.setPal(0);
                        sp.setShade((byte)Light.LIGHT_MaxDark(sp));
                        Light.SectorLightShade(i, sp.getShade());
                        Light.DiffuseLighting(sp);
                        sp.setPal(spal);
                    }
                }
            }
            node = nexti;
        }
    }

    public static void InitLighting() {
        ListNode<Sprite> node = Main.boardService.getStatNode(83);
        while (node != null) {
            ListNode<Sprite> nexti = node.getNext();
            Sprite sp = node.get();
            if (!Gameutils.TEST_BOOL9(sp)) {
                Light.DoLightingMatch(Light.LIGHT_Match(sp), Gameutils.TEST_BOOL1(sp) ? 1 : 0);
            }
            node = nexti;
        }
    }

    public static void DoLighting() {
        ListNode<Sprite> node = Main.boardService.getStatNode(83);
        while (node != null) {
            int i = node.getIndex();
            ListNode<Sprite> nexti = node.getNext();
            Sprite sp = node.get();
            if (Gameutils.TEST_BOOL1(sp)) {
                switch (Light.LIGHT_Type(sp)) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        short spal;
                        sp.setZ(sp.getZ() + 3);
                        while (Light.LIGHT_Tics(sp) >= Light.LIGHT_MaxTics(sp)) {
                            sp.setZ(sp.getZ() - Light.LIGHT_MaxTics(sp));
                            if (Gameutils.RANDOM_P2(32768) >> 8 > 64) {
                                sp.setShade((byte)(-Light.LIGHT_MaxBright(sp) + Gameutils.RANDOM_RANGE(Light.LIGHT_MaxBright(sp) + Light.LIGHT_MaxDark(sp))));
                                Light.SectorLightShade(i, sp.getShade());
                                Light.DiffuseLighting(sp);
                                continue;
                            }
                            spal = sp.getPal();
                            sp.setPal(0);
                            sp.setShade((byte)Light.LIGHT_MaxDark(sp));
                            Light.SectorLightShade(i, sp.getShade());
                            Light.DiffuseLighting(sp);
                            sp.setPal(spal);
                        }
                        break;
                    }
                    case 2: {
                        sp.setZ(sp.getZ() + 3);
                        while (Light.LIGHT_Tics(sp) >= Light.LIGHT_MaxTics(sp)) {
                            sp.setZ(sp.getZ() - Light.LIGHT_MaxTics(sp));
                            if (Light.LIGHT_Dir(sp)) {
                                sp.setShade(sp.getShade() + Light.LIGHT_ShadeInc(sp));
                                if (sp.getShade() >= Light.LIGHT_MaxDark(sp)) {
                                    Light.LIGHT_DirChange(sp);
                                }
                            } else {
                                sp.setShade(sp.getShade() - Light.LIGHT_ShadeInc(sp));
                                if (sp.getShade() <= -Light.LIGHT_MaxBright(sp)) {
                                    Light.LIGHT_DirChange(sp);
                                }
                            }
                            Light.SectorLightShade(i, sp.getShade());
                            Light.DiffuseLighting(sp);
                        }
                        break;
                    }
                    case 4: {
                        sp.setZ(sp.getZ() + 3);
                        while (Light.LIGHT_Tics(sp) >= Light.LIGHT_MaxTics(sp)) {
                            sp.setZ(sp.getZ() - Light.LIGHT_MaxTics(sp));
                            if (Light.LIGHT_Dir(sp)) {
                                sp.setShade(sp.getShade() + Light.LIGHT_ShadeInc(sp));
                                if (sp.getShade() >= Light.LIGHT_MaxDark(sp)) {
                                    sp.setPal(0);
                                    Light.LIGHT_DirChange(sp);
                                    Gameutils.RESET_BOOL1(sp);
                                }
                            } else {
                                sp.setShade(sp.getShade() - Light.LIGHT_ShadeInc(sp));
                                USER u = Gameutils.getUser(i);
                                if (u != null) {
                                    sp.setPal(u.spal);
                                }
                                if (sp.getShade() <= -Light.LIGHT_MaxBright(sp)) {
                                    Light.LIGHT_DirChange(sp);
                                    Gameutils.RESET_BOOL1(sp);
                                }
                            }
                            Light.SectorLightShade(i, sp.getShade());
                            Light.DiffuseLighting(sp);
                        }
                        break;
                    }
                    case 3: {
                        short spal;
                        sp.setZ(sp.getZ() + 3);
                        while (Light.LIGHT_Tics(sp) >= Light.LIGHT_MaxTics(sp)) {
                            sp.setZ(sp.getZ() - Light.LIGHT_MaxTics(sp));
                            if (Gameutils.RANDOM_P2(32768) >> 8 > 64) {
                                sp.setShade((byte)(-Light.LIGHT_MaxBright(sp) + Gameutils.RANDOM_RANGE(Light.LIGHT_MaxBright(sp) + Light.LIGHT_MaxDark(sp))));
                                Light.SectorLightShade(i, sp.getShade());
                                Light.DiffuseLighting(sp);
                            } else {
                                spal = sp.getPal();
                                sp.setPal(0);
                                sp.setShade((byte)Light.LIGHT_MaxDark(sp));
                                Light.SectorLightShade(i, sp.getShade());
                                Light.DiffuseLighting(sp);
                                sp.setPal(spal);
                            }
                            if (Gameutils.RANDOM_P2(32768) >> 8 >= 8) continue;
                            sp.setShade((byte)(-Light.LIGHT_MaxBright(sp)));
                            Light.SectorLightShade(i, sp.getShade());
                            Light.DiffuseLighting(sp);
                            Gameutils.RESET_BOOL1(sp);
                        }
                        break;
                    }
                }
            }
            node = nexti;
        }
    }
}

