/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import ru.m210projects.Build.Board;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.Tools.SaveManager;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Wang.Enemies.Bunny;
import ru.m210projects.Wang.Enemies.Sumo;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.JSector;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Menus.MenuCorruptGame;
import ru.m210projects.Wang.Palette;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Text;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.Anim;
import ru.m210projects.Wang.Type.GameInfo;
import ru.m210projects.Wang.Type.LSInfo;
import ru.m210projects.Wang.Type.MirrorType;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.ResourceHandler;
import ru.m210projects.Wang.Type.SINE_WALL;
import ru.m210projects.Wang.Type.SINE_WAVE_FLOOR;
import ru.m210projects.Wang.Type.SafeLoader;
import ru.m210projects.Wang.Type.Sect_User;
import ru.m210projects.Wang.Type.Sector_Object;
import ru.m210projects.Wang.Type.Spring_Board;
import ru.m210projects.Wang.Type.TRACK;
import ru.m210projects.Wang.Type.TRACK_POINT;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class LoadSave {
    public static final String savsign = "SHWR";
    public static final int gdxVersionSave = 100;
    public static final int gdxCurrentSave = 102;
    public static final int SAVETIME = 8;
    public static final int SAVENAME = 32;
    public static final int SAVESCREENSHOTSIZE = 16000;
    public static final char[] filenum = new char[4];
    public static boolean gQuickSaving;
    public static boolean gAutosaveRequest;
    public static final LSInfo lsInf;
    public static final SafeLoader loader;
    public static int quickslot;
    public static Entry lastload;

    public static void FindSaves(Directory dir) {
        for (Entry file : dir) {
            if (!file.isExtension("sav") || !(file instanceof FileEntry)) continue;
            try {
                InputStream is = file.getInputStream();
                try {
                    short nVersion;
                    String signature = StreamUtils.readString(is, 4);
                    if (signature.isEmpty() || !signature.equals(savsign) || (nVersion = StreamUtils.readShort(is)) < 100) continue;
                    long time = StreamUtils.readLong(is);
                    String savname = StreamUtils.readString(is, 32);
                    Main.game.pSavemgr.add(savname, time, (FileEntry)file);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        Main.game.pSavemgr.sort();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int lsReadLoadData(FileEntry file) {
        if (file.exists()) {
            ArtEntry pic = Main.engine.getTile(SaveManager.Screenshot);
            if (!(pic instanceof DynamicArtEntry) || !pic.exists()) {
                pic = Main.engine.allocatepermanenttile(SaveManager.Screenshot, 160, 100);
            }
            try (InputStream is = file.getInputStream();){
                int nVersion = LoadSave.checkSave(is) & 0xFFFF;
                lsInf.clear();
                if (nVersion == 102) {
                    LoadSave.lsInf.date = Main.game.date.getDate(StreamUtils.readLong(is));
                    StreamUtils.skip(is, 32);
                    lsInf.read(is);
                    if (is.available() <= 16000) {
                        int n = -1;
                        return n;
                    }
                    ((DynamicArtEntry)pic).copyData(StreamUtils.readBytes(is, 16000));
                    LoadSave.lsInf.addonfile = null;
                    if (StreamUtils.readBoolean(is)) {
                        boolean isPackage = StreamUtils.readBoolean(is);
                        String fullname = StreamUtils.readDataString(is);
                        LoadSave.lsInf.addonfile = isPackage && !fullname.isEmpty() ? "File: " + LoadSave.getFilename(fullname) : "Addon: " + LoadSave.getFilename(fullname);
                    }
                    int n = 1;
                    return n;
                }
                LoadSave.lsInf.info = "Incompatible ver. " + nVersion + " != " + 102;
                int n = -1;
                return n;
            }
            catch (Exception e) {
                Console.out.println(e.toString(), OsdColor.RED);
            }
        }
        lsInf.clear();
        return -1;
    }

    public static String getFilename(String path) {
        if (path != null) {
            path = FileUtils.getPath(path, new String[0]).getFileName().toString();
        }
        return path;
    }

    public static String makeNum(int num) {
        LoadSave.filenum[3] = (char)(num % 10 + 48);
        LoadSave.filenum[2] = (char)(num / 10 % 10 + 48);
        LoadSave.filenum[1] = (char)(num / 100 % 10 + 48);
        LoadSave.filenum[0] = (char)(num / 1000 % 10 + 48);
        return new String(filenum);
    }

    public static int checkSave(InputStream is) throws IOException {
        String signature = StreamUtils.readString(is, 4);
        if (!signature.equals(savsign)) {
            return 0;
        }
        return StreamUtils.readShort(is);
    }

    public static void savegame(Directory dir, String savename, String filename) {
        block9: {
            FileEntry file = dir.getEntry(filename);
            if (file.exists() && !file.delete()) {
                Text.PutStringInfo(Game.Player[Mmulti.myconnectindex], "Game not saved. Access denied!");
                return;
            }
            Path path = dir.getPath().resolve(filename);
            try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
                long time = Main.game.date.getCurrentDate();
                LoadSave.save(os, savename, time);
                file = dir.addEntry(path);
                if (file.exists()) {
                    Main.game.pSavemgr.add(savename, time, file);
                    lastload = file;
                    Text.PutStringInfo(Game.Player[Mmulti.myconnectindex], "Game saved");
                    break block9;
                }
                throw new FileNotFoundException(filename);
            }
            catch (Exception e) {
                Text.PutStringInfo(Game.Player[Mmulti.myconnectindex], "Game not saved. Access denied!");
            }
        }
    }

    public static void save(OutputStream os, String savename, long time) throws IOException {
        LoadSave.SaveHeader(os, savename, time);
        LoadSave.SaveGDXBlock(os);
        LoadSave.SaveMap(os);
        LoadSave.SavePlayers(os);
        LoadSave.SaveSectorUserInfos(os);
        LoadSave.SaveUserInfos(os);
        LoadSave.SaveSectorObjects(os);
        LoadSave.SaveSineSect(os);
        StreamUtils.writeInt(os, Sector.x_min_bound);
        StreamUtils.writeInt(os, Sector.y_min_bound);
        StreamUtils.writeInt(os, Sector.x_max_bound);
        StreamUtils.writeInt(os, Sector.y_max_bound);
        LoadSave.SaveTracks(os);
        StreamUtils.writeInt(os, Game.screenpeek);
        StreamUtils.writeInt(os, Game.totalsynctics);
        LoadSave.SaveAnims(os);
        StreamUtils.writeInt(os, Main.engine.getTotalClock());
        StreamUtils.writeInt(os, Main.engine.getrand());
        StreamUtils.writeShort(os, Player.NormalVisibility);
        StreamUtils.writeInt(os, Engine.visibility);
        StreamUtils.writeByte(os, Engine.parallaxtype);
        StreamUtils.writeInt(os, Main.game.getRenderer().getParallaxOffset());
        LoadSave.writeBytes(os, Engine.pskyoff);
        StreamUtils.writeShort(os, Engine.pskybits);
        StreamUtils.writeBoolean(os, Sprites.MoveSkip2);
        StreamUtils.writeInt(os, Sprites.MoveSkip4);
        StreamUtils.writeInt(os, Sprites.MoveSkip8);
        LoadSave.SaveMirrors(os);
        LoadSave.SaveQueues(os);
        LoadSave.SaveStuff(os);
    }

    private static void SaveStuff(OutputStream os) throws IOException {
        StreamUtils.writeInt(os, Game.PlayClock);
        StreamUtils.writeInt(os, Game.Kills);
        StreamUtils.writeInt(os, Game.TotalKillable);
        Main.gNet.save(os);
        for (int i = 0; i < Engine.MAXTILES; ++i) {
            StreamUtils.writeInt(os, Main.engine.getTile(i).getFlags());
        }
        StreamUtils.writeShort(os, Sector.LevelSecrets);
        Engine.show2dsector.writeObject(os);
        Engine.show2dwall.writeObject(os);
        Engine.show2dsprite.writeObject(os);
        StreamUtils.writeInt(os, Bunny.Bunny_Count);
        StreamUtils.writeBoolean(os, Game.GodMode);
        StreamUtils.writeBoolean(os, Sumo.serpwasseen);
        StreamUtils.writeBoolean(os, Sumo.sumowasseen);
        StreamUtils.writeBoolean(os, Sumo.zillawasseen);
        LoadSave.writeBytes(os, Sumo.BossSpriteNum, 3);
    }

    private static void SaveMirrors(OutputStream os) throws IOException {
        StreamUtils.writeInt(os, JSector.mirrorcnt);
        StreamUtils.writeBoolean(os, JSector.mirrorinview);
        StreamUtils.writeInt(os, JSector.mirror.length);
        for (MirrorType mirrorType : JSector.mirror) {
            mirrorType.save(os);
        }
    }

    private static void SaveQueues(OutputStream os) throws IOException {
        StreamUtils.writeInt(os, Weapon.StarQueueHead);
        LoadSave.writeBytes(os, Weapon.StarQueue, 32);
        StreamUtils.writeInt(os, Weapon.HoleQueueHead);
        LoadSave.writeBytes(os, Weapon.HoleQueue, 64);
        StreamUtils.writeInt(os, Weapon.WallBloodQueueHead);
        LoadSave.writeBytes(os, Weapon.WallBloodQueue, 32);
        StreamUtils.writeInt(os, Weapon.FloorBloodQueueHead);
        LoadSave.writeBytes(os, Weapon.FloorBloodQueue, 32);
        StreamUtils.writeInt(os, Weapon.GenericQueueHead);
        LoadSave.writeBytes(os, Weapon.GenericQueue, 32);
        StreamUtils.writeInt(os, Weapon.LoWangsQueueHead);
        LoadSave.writeBytes(os, Weapon.LoWangsQueue, 16);
    }

    private static void SaveVersion(OutputStream os) throws IOException {
        StreamUtils.writeString(os, savsign);
        StreamUtils.writeShort(os, 102);
    }

    private static void SaveScreenshot(OutputStream os) throws IOException {
        StreamUtils.writeBytes(os, Main.gGameScreen.captBuffer, 16000);
        Main.gGameScreen.captBuffer = null;
    }

    private static void SaveGDXBlock(OutputStream os) throws IOException {
        LoadSave.SaveScreenshot(os);
        byte warp_on = 0;
        if (Main.mUserFlag == Main.UserFlag.Addon) {
            warp_on = (byte)(Game.currentGame != null ? 1 : 2);
        }
        if (Main.mUserFlag == Main.UserFlag.UserMap) {
            warp_on = (byte)2;
        }
        StreamUtils.writeByte(os, warp_on);
        if (warp_on == 1) {
            boolean isPacked = Game.currentGame.getEpisodeEntry().isPackageEpisode();
            StreamUtils.writeBoolean(os, isPacked);
            StreamUtils.writeDataString(os, Game.currentGame.getPath());
        }
    }

    private static void SaveHeader(OutputStream os, String savename, long time) throws IOException {
        LoadSave.SaveVersion(os);
        StreamUtils.writeLong(os, time);
        StreamUtils.writeString(os, savename, 32);
        StreamUtils.writeInt(os, Game.Level);
        StreamUtils.writeInt(os, Game.Skill);
    }

    private static void SavePlayers(OutputStream os) throws IOException {
        StreamUtils.writeShort(os, Mmulti.numplayers);
        StreamUtils.writeShort(os, WangNetwork.CommPlayers);
        StreamUtils.writeShort(os, Mmulti.myconnectindex);
        StreamUtils.writeShort(os, Mmulti.connecthead);
        LoadSave.writeBytes(os, Mmulti.connectpoint2);
        for (int i = 0; i < Mmulti.numplayers; ++i) {
            Game.Player[i].writeObject(os);
        }
    }

    private static void SaveMap(OutputStream os) throws IOException {
        if (Game.boardfilename != null && Game.boardfilename.exists()) {
            if (Game.boardfilename instanceof FileEntry) {
                StreamUtils.writeString(os, ((FileEntry)Game.boardfilename).getPath().toString(), 144);
            } else {
                StreamUtils.writeString(os, Game.boardfilename.getName(), 144);
            }
        } else {
            StreamUtils.writeString(os, "", 144);
        }
        Board board = Main.boardService.getBoard();
        ru.m210projects.Build.Types.Sector[] sectors = board.getSectors();
        StreamUtils.writeInt(os, sectors.length);
        for (ru.m210projects.Build.Types.Sector s : sectors) {
            s.writeObject(os);
        }
        Wall[] walls = board.getWalls();
        StreamUtils.writeInt(os, walls.length);
        for (Wall wal : walls) {
            wal.writeObject(os);
        }
        List<Sprite> sprites = board.getSprites();
        StreamUtils.writeInt(os, sprites.size());
        for (Sprite s : sprites) {
            s.writeObject(os);
        }
        StreamUtils.writeInt(os, Weapon.FinishTimer);
        StreamUtils.writeBoolean(os, Game.FinishedLevel);
        StreamUtils.writeInt(os, Game.FinishAnim);
        StreamUtils.writeInt(os, Sound.playTrack);
    }

    private static void SaveSectorUserInfos(OutputStream os) throws IOException {
        StreamUtils.writeInt(os, Main.boardService.getSectorCount());
        for (int i = 0; i < Main.boardService.getSectorCount(); ++i) {
            Sect_User su = Sector.getSectUser(i);
            StreamUtils.writeInt(os, su != null ? (long)i : -1L);
            if (su == null) continue;
            su.writeObject(os);
        }
    }

    private static void SaveUserInfos(OutputStream os) throws IOException {
        int numsprites = Main.boardService.getSpriteCount();
        StreamUtils.writeInt(os, numsprites);
        for (int i = 0; i < numsprites; ++i) {
            USER u = Gameutils.getUser(i);
            StreamUtils.writeInt(os, u != null ? (long)i : -1L);
            if (u == null) continue;
            u.writeObject(os);
        }
    }

    private static void SaveSectorObjects(OutputStream os) throws IOException {
        StreamUtils.writeInt(os, Sprites.SectorObject.length);
        for (Sector_Object sectorObject : Sprites.SectorObject) {
            sectorObject.writeObject(os);
        }
    }

    private static void SaveSineSect(OutputStream os) throws IOException {
        int j;
        StreamUtils.writeInt(os, Sector.SineWaveFloor.length);
        StreamUtils.writeInt(os, Sector.SineWaveFloor[0].length);
        for (SINE_WAVE_FLOOR[] sINE_WAVE_FLOORArray : Sector.SineWaveFloor) {
            for (j = 0; j < Sector.SineWaveFloor[0].length; ++j) {
                sINE_WAVE_FLOORArray[j].save(os);
            }
        }
        StreamUtils.writeInt(os, Sector.SineWall.length);
        StreamUtils.writeInt(os, Sector.SineWall[0].length);
        for (SINE_WALL[] sINE_WALLArray : Sector.SineWall) {
            for (j = 0; j < Sector.SineWall[0].length; ++j) {
                sINE_WALLArray[j].save(os);
            }
        }
        StreamUtils.writeInt(os, Sector.SpringBoard.length);
        for (Spring_Board spring_Board : Sector.SpringBoard) {
            spring_Board.save(os);
        }
    }

    private static void SaveTracks(OutputStream os) throws IOException {
        StreamUtils.writeInt(os, Track.Track.length);
        for (TRACK tr : Track.Track) {
            StreamUtils.writeInt(os, tr.ttflags);
            StreamUtils.writeShort(os, tr.flags);
            StreamUtils.writeShort(os, tr.NumPoints);
            if (tr.NumPoints == 0) continue;
            for (int j = 0; j < tr.NumPoints; ++j) {
                TRACK_POINT tp = tr.TrackPoint[j];
                StreamUtils.writeInt(os, tp.x);
                StreamUtils.writeInt(os, tp.y);
                StreamUtils.writeInt(os, tp.z);
                StreamUtils.writeShort(os, tp.ang);
                StreamUtils.writeShort(os, tp.tag_low);
                StreamUtils.writeShort(os, tp.tag_high);
            }
        }
    }

    private static void SaveAnims(OutputStream os) throws IOException {
        StreamUtils.writeInt(os, Sector.AnimCnt);
        for (int i = 0; i < Sector.AnimCnt; ++i) {
            Sector.pAnim[i].save(os);
        }
    }

    public static void quicksave() {
        if (Mmulti.numplayers > 1 || Main.game.net.FakeMultiplayer) {
            return;
        }
        if (!MyTypes.TEST(Game.Player[Mmulti.myconnectindex].Flags, Gameutils.PF_DEAD)) {
            gQuickSaving = true;
        }
    }

    public static void quickload() {
        if (Mmulti.numplayers > 1) {
            return;
        }
        FileEntry loadFile = Main.game.pSavemgr.getLast();
        if (LoadSave.canLoad(loadFile)) {
            Main.game.changeScreen(Main.gLoadingScreen.setTitle(loadFile.getName()));
            Main.gLoadingScreen.init(() -> {
                if (!LoadSave.loadgame(loadFile)) {
                    Main.game.show();
                }
            });
        }
    }

    public static void checkfile(InputStream is) throws IOException {
        int nVersion = LoadSave.checkSave(is);
        if (nVersion != 102) {
            return;
        }
        if (!loader.load(is)) {
            throw new RuntimeException("Can't load the file");
        }
    }

    public static boolean canLoad(Entry fil) {
        return fil.load(is -> {
            int nVersion = LoadSave.checkSave(is) & 0xFFFF;
            if (nVersion != 102) {
                if (nVersion >= 100) {
                    GameInfo addon = loader.LoadGDXHeader(is);
                    if (LoadSave.loader.Level <= 20 && LoadSave.loader.Skill >= 0 && LoadSave.loader.Skill < 4 && LoadSave.loader.warp_on != 2) {
                        Main.game.menu.mOpen(LoadSave.getMenuCorruptGame(addon), -1);
                    }
                }
                throw new IOException("Wrong file version");
            }
        });
    }

    @NotNull
    private static MenuCorruptGame getMenuCorruptGame(GameInfo addon) {
        MenuCorruptGame menu = (MenuCorruptGame)Main.game.menu.mMenus[17];
        menu.setRunnable(() -> {
            GameInfo game = addon != null ? addon : Game.defGame;
            int nEpisode = game.getNumEpisode(LoadSave.loader.Level);
            int nLevel = game.getNumLevel(LoadSave.loader.Level);
            Main.gGameScreen.newgame(false, game, nEpisode, nLevel, LoadSave.loader.Skill);
        });
        MenuCorruptGame menuCorruptGame = menu;
        if (menuCorruptGame == null) {
            LoadSave.$$$reportNull$$$0(0);
        }
        return menuCorruptGame;
    }

    public static boolean loadgame(Entry file) {
        boolean status = file.load(LoadSave::checkfile);
        if (status) {
            LoadSave.load();
            if (lastload == null || !lastload.exists()) {
                lastload = file;
            }
            if (loader.getMessage() != null) {
                Text.PutStringInfo(Game.Player[Mmulti.myconnectindex], loader.getMessage());
            }
            return true;
        }
        if (file.exists()) {
            Text.PutStringInfo(Game.Player[Mmulti.myconnectindex], "Incompatible version of saved game found!");
        } else {
            Text.PutStringInfo(Game.Player[Mmulti.myconnectindex], "Can't access to file or file not found!");
        }
        return false;
    }

    public static void LoadGDXBlock() {
        if (LoadSave.loader.warp_on == 0) {
            Main.mUserFlag = Main.UserFlag.None;
        }
        if (LoadSave.loader.warp_on == 1) {
            Main.mUserFlag = Main.UserFlag.Addon;
        }
        if (LoadSave.loader.warp_on == 2) {
            Main.mUserFlag = Main.UserFlag.UserMap;
        }
        if (Main.mUserFlag == Main.UserFlag.Addon) {
            GameInfo ini = LoadSave.loader.addon;
            ResourceHandler.checkEpisodeResources(ini);
        } else {
            ResourceHandler.resetEpisodeResources();
        }
    }

    public static void load() {
        if (Game.rec != null) {
            Game.rec.close();
        }
        Game.Level = LoadSave.loader.Level;
        Game.Skill = LoadSave.loader.Skill;
        Sector.clearSecUser();
        Gameutils.clearUser();
        LoadSave.LoadGDXBlock();
        LoadSave.MapLoad();
        LoadSave.LoadPlayers();
        LoadSave.LoadSectorUserInfos();
        LoadSave.LoadUserInfos();
        LoadSave.LoadSectorObjects();
        LoadSave.LoadSineSect();
        Sector.x_min_bound = LoadSave.loader.x_min_bound;
        Sector.y_min_bound = LoadSave.loader.y_min_bound;
        Sector.x_max_bound = LoadSave.loader.x_max_bound;
        Sector.y_max_bound = LoadSave.loader.y_max_bound;
        LoadSave.LoadTracks();
        Game.screenpeek = LoadSave.loader.screenpeek;
        Game.totalsynctics = LoadSave.loader.totalsynctics;
        LoadSave.LoadAnims();
        Main.engine.getTimer().setTotalClock(LoadSave.loader.totalclock);
        Main.engine.srand(LoadSave.loader.randomseed);
        Player.NormalVisibility = LoadSave.loader.NormalVisibility;
        Engine.visibility = LoadSave.loader.visibility;
        Engine.parallaxtype = LoadSave.loader.parallaxtype;
        Main.game.getRenderer().setParallaxOffset(LoadSave.loader.parallaxyoffs);
        System.arraycopy(LoadSave.loader.pskyoff, 0, Engine.pskyoff, 0, 256);
        System.arraycopy(Engine.pskyoff, 0, Engine.zeropskyoff, 0, 256);
        Engine.pskybits = LoadSave.loader.pskybits;
        Sprites.MoveSkip2 = LoadSave.loader.MoveSkip2;
        Sprites.MoveSkip4 = LoadSave.loader.MoveSkip4;
        Sprites.MoveSkip8 = LoadSave.loader.MoveSkip8;
        LoadSave.LoadMirrors();
        LoadSave.LoadQueues();
        LoadSave.LoadStuff();
        Sound.StopFX();
        Game.screenpeek = Mmulti.myconnectindex;
        Game.PlayingLevel = Game.Level;
        int i = Mmulti.connecthead;
        while (i != -1) {
            Game.Player[i].PlayerTalking = false;
            Game.Player[i].TalkVocnum = -1;
            Game.Player[i].TalkVocHandle = null;
            Game.Player[i].StartColor = 0;
            i = Mmulti.connectpoint2[i];
        }
        block6: for (i = Sector.AnimCnt - 1; i >= 0; --i) {
            Anim gAnm = Sector.pAnim[i];
            Object object = gAnm.ptr = Sector.GetAnimObject(gAnm.index, gAnm.type);
            switch (gAnm.type) {
                case FloorZ: {
                    Main.game.pInt.setfloorinterpolate(gAnm.index, (ru.m210projects.Build.Types.Sector)object);
                    continue block6;
                }
                case CeilZ: {
                    Main.game.pInt.setceilinterpolate(gAnm.index, (ru.m210projects.Build.Types.Sector)object);
                    continue block6;
                }
                case SpriteZ: {
                    Main.game.pInt.setsprinterpolate(gAnm.index, (Sprite)object);
                    continue block6;
                }
            }
        }
        Main.game.doPrecache(() -> {
            ResourceHandler.InitSpecialTextures();
            Palette.DoPlayerDivePalette(Game.Player[Mmulti.myconnectindex]);
            Palette.DoPlayerNightVisionPalette(Game.Player[Mmulti.myconnectindex]);
            Main.cfg.AutoAim = (Game.Player[Mmulti.myconnectindex].Flags & Gameutils.PF_AUTO_AIM) != 0;
            Sound.setEcho(false, 0.0f);
            Main.game.gPaused = false;
            Main.game.nNetMode = BuildGame.NetMode.Single;
            Main.game.changeScreen(Main.gGameScreen);
            int SavePlayClock = Game.PlayClock;
            Game.InitTimingVars();
            Game.PlayClock = SavePlayClock;
            Main.game.pNet.WaitForAllPlayers(0);
            Main.game.pNet.ready2send = true;
            Sumo.triedplay = false;
            if (LoadSave.loader.playTrack != -1) {
                Sound.CDAudio_Play(LoadSave.loader.playTrack, true);
            } else {
                Sound.CDAudio_Play(Sound.RedBookSong[Game.Level], true);
            }
            Sound.StartAmbientSound();
            System.gc();
        });
    }

    private static void MapLoad() {
        Game.boardfilename = LoadSave.loader.boardfilename;
        Main.boardService.setBoard(new Board(null, LoadSave.loader.sector, LoadSave.loader.wall, LoadSave.loader.sprite));
        Weapon.FinishTimer = LoadSave.loader.FinishTimer;
        Game.FinishedLevel = LoadSave.loader.FinishedLevel;
        Game.FinishAnim = LoadSave.loader.FinishAnim;
    }

    private static void LoadPlayers() {
        Mmulti.numplayers = LoadSave.loader.numplayers;
        WangNetwork.CommPlayers = LoadSave.loader.CommPlayers;
        Mmulti.myconnectindex = LoadSave.loader.myconnectindex;
        Mmulti.connecthead = LoadSave.loader.connecthead;
        System.arraycopy(LoadSave.loader.connectpoint2, 0, Mmulti.connectpoint2, 0, 16);
        for (int i = 0; i < Mmulti.numplayers; ++i) {
            Game.Player[i].copy(LoadSave.loader.Player[i]);
        }
    }

    private static void LoadSectorUserInfos() {
        for (int i = 0; i < LoadSave.loader.SectUser.size; ++i) {
            Sect_User pSectUser = ((Sect_User[])LoadSave.loader.SectUser.items)[i];
            if (pSectUser == null) continue;
            Sector.setSectUser(i, pSectUser);
        }
    }

    private static void LoadUserInfos() {
        for (int i = 0; i < LoadSave.loader.pUser.size; ++i) {
            USER user = ((USER[])LoadSave.loader.pUser.items)[i];
            if (user == null) continue;
            Gameutils.setUser(i, user);
        }
    }

    private static void LoadSectorObjects() {
        for (int i = 0; i < LoadSave.loader.SectorObject.length; ++i) {
            Sprites.SectorObject[i] = Sector_Object.copy(LoadSave.loader.SectorObject[i]);
        }
    }

    private static void LoadSineSect() {
        int j;
        int i;
        int len = LoadSave.loader.SineWaveFloor.length;
        int len2 = LoadSave.loader.SineWaveFloor[0].length;
        for (i = 0; i < len; ++i) {
            for (j = 0; j < len2; ++j) {
                Sector.SineWaveFloor[i][j] = SINE_WAVE_FLOOR.copy(LoadSave.loader.SineWaveFloor[i][j]);
            }
        }
        len = LoadSave.loader.SineWall.length;
        len2 = LoadSave.loader.SineWall[0].length;
        for (i = 0; i < len; ++i) {
            for (j = 0; j < len2; ++j) {
                Sector.SineWall[i][j] = SINE_WALL.copy(LoadSave.loader.SineWall[i][j]);
            }
        }
        for (i = 0; i < LoadSave.loader.SpringBoard.length; ++i) {
            Sector.SpringBoard[i] = Spring_Board.copy(LoadSave.loader.SpringBoard[i]);
        }
    }

    private static void LoadTracks() {
        for (int i = 0; i < LoadSave.loader.Track.length; ++i) {
            Track.Track[i] = new TRACK();
            Track.Track[i].copy(LoadSave.loader.Track[i]);
        }
    }

    private static void LoadAnims() {
        Sector.AnimCnt = LoadSave.loader.AnimCnt;
        for (int i = 0; i < Sector.AnimCnt; ++i) {
            Sector.pAnim[i].copy(LoadSave.loader.pAnim[i]);
        }
    }

    private static void LoadMirrors() {
        JSector.mirrorcnt = LoadSave.loader.mirrorcnt;
        JSector.mirrorinview = LoadSave.loader.mirrorinview;
        for (int i = 0; i < LoadSave.loader.mirror.length; ++i) {
            JSector.mirror[i] = new MirrorType();
            JSector.mirror[i].copy(LoadSave.loader.mirror[i]);
        }
    }

    private static void LoadQueues() {
        ListNode<Sprite> node;
        Weapon.StarQueueHead = LoadSave.loader.StarQueueHead;
        System.arraycopy(LoadSave.loader.StarQueue.items, 0, Weapon.StarQueue, 0, LoadSave.loader.StarQueue.size);
        Weapon.HoleQueueHead = LoadSave.loader.HoleQueueHead;
        System.arraycopy(LoadSave.loader.HoleQueue.items, 0, Weapon.HoleQueue, 0, LoadSave.loader.HoleQueue.size);
        Weapon.WallBloodQueueHead = LoadSave.loader.WallBloodQueueHead;
        System.arraycopy(LoadSave.loader.WallBloodQueue.items, 0, Weapon.WallBloodQueue, 0, LoadSave.loader.WallBloodQueue.size);
        Weapon.FloorBloodQueueHead = LoadSave.loader.FloorBloodQueueHead;
        System.arraycopy(LoadSave.loader.FloorBloodQueue.items, 0, Weapon.FloorBloodQueue, 0, LoadSave.loader.FloorBloodQueue.size);
        Weapon.GenericQueueHead = LoadSave.loader.GenericQueueHead;
        System.arraycopy(LoadSave.loader.GenericQueue.items, 0, Weapon.GenericQueue, 0, LoadSave.loader.GenericQueue.size);
        Weapon.LoWangsQueueHead = LoadSave.loader.LoWangsQueueHead;
        System.arraycopy(LoadSave.loader.LoWangsQueue.items, 0, Weapon.LoWangsQueue, 0, LoadSave.loader.LoWangsQueue.size);
        Arrays.fill(Weapon.HoleQueue, -1);
        int head = Weapon.HoleQueueHead;
        for (node = Main.boardService.getStatNode(44); node != null; node = node.getNext()) {
            Weapon.HoleQueue[head] = node.getIndex();
            head = head + 1 & 0x3F;
        }
        Arrays.fill(Weapon.WallBloodQueue, -1);
        head = Weapon.WallBloodQueueHead;
        for (node = Main.boardService.getStatNode(39); node != null; node = node.getNext()) {
            Weapon.WallBloodQueue[head] = node.getIndex();
            head = head + 1 & 0x1F;
        }
        Arrays.fill(Weapon.GenericQueue, -1);
        head = Weapon.GenericQueueHead;
        for (node = Main.boardService.getStatNode(37); node != null; node = node.getNext()) {
            Weapon.GenericQueue[head] = node.getIndex();
            head = head + 1 & 0x1F;
        }
        Arrays.fill(Weapon.FloorBloodQueue, -1);
        head = Weapon.FloorBloodQueueHead;
        for (node = Main.boardService.getStatNode(40); node != null; node = node.getNext()) {
            Weapon.FloorBloodQueue[head] = node.getIndex();
            head = head + 1 & 0x1F;
        }
    }

    private static void LoadStuff() {
        Game.PlayClock = LoadSave.loader.PlayClock;
        Game.Kills = LoadSave.loader.Kills;
        Game.TotalKillable = LoadSave.loader.TotalKillable;
        Main.gNet.KillLimit = LoadSave.loader.TotalKillable;
        Main.gNet.TimeLimit = LoadSave.loader.TimeLimit;
        Main.gNet.TimeLimitClock = LoadSave.loader.TimeLimitClock;
        Main.gNet.MultiGameType = LoadSave.loader.MultiGameType;
        Main.gNet.TeamPlay = LoadSave.loader.TeamPlay;
        Main.gNet.HurtTeammate = LoadSave.loader.HurtTeammate;
        Main.gNet.SpawnMarkers = LoadSave.loader.SpawnMarkers;
        Main.gNet.NoRespawn = LoadSave.loader.NoRespawn;
        Main.gNet.Nuke = LoadSave.loader.Nuke;
        for (int i = 0; i < Engine.MAXTILES; ++i) {
            Main.engine.getTile(i).setFlags(LoadSave.loader.picanm[i]);
        }
        Sector.LevelSecrets = LoadSave.loader.LevelSecrets;
        Engine.show2dsector.copy(LoadSave.loader.show2dsector);
        Engine.show2dwall.copy(LoadSave.loader.show2dwall);
        Engine.show2dsprite.copy(LoadSave.loader.show2dsprite);
        Bunny.Bunny_Count = LoadSave.loader.Bunny_Count;
        Game.GodMode = LoadSave.loader.GodMode;
        Sumo.serpwasseen = LoadSave.loader.serpwasseen;
        Sumo.sumowasseen = LoadSave.loader.sumowasseen;
        Sumo.zillawasseen = LoadSave.loader.zillawasseen;
        System.arraycopy(LoadSave.loader.BossSpriteNum.items, 0, Sumo.BossSpriteNum, 0, LoadSave.loader.BossSpriteNum.size);
    }

    private static void writeBytes(OutputStream os, short[] array) throws IOException {
        for (short val : array) {
            StreamUtils.writeShort(os, val);
        }
    }

    private static void writeBytes(OutputStream os, int[] array, int len) throws IOException {
        StreamUtils.writeInt(os, len);
        for (int i = 0; i < len; ++i) {
            StreamUtils.writeInt(os, array[i]);
        }
    }

    static {
        lsInf = new LSInfo();
        loader = new SafeLoader();
        quickslot = 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ru/m210projects/Wang/LoadSave", "getMenuCorruptGame"));
    }
}

